/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ListenerEntry;
import org.knopflerfish.framework.RemoveOnlyCollection;
import org.knopflerfish.framework.ServiceReferenceImpl;
import org.knopflerfish.framework.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.bundle.CollisionHook;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.bundle.FindHook;

class BundleHooks {
    private final FrameworkContext fwCtx;

    BundleHooks(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    Bundle filterBundle(BundleContextImpl bc, Bundle bundle) {
        if (bundle == null) {
            return bundle;
        }
        List<ServiceRegistrationImpl<?>> srl = this.fwCtx.services.get(FindHook.class.getName());
        if (srl == null || srl.isEmpty()) {
            return bundle;
        }
        ArrayList<Bundle> bl = new ArrayList<Bundle>();
        bl.add(bundle);
        this.filterBundles(bc, bl);
        return bl.isEmpty() ? null : bundle;
    }

    void filterBundles(BundleContextImpl bc, Collection<Bundle> bundles) {
        List<ServiceRegistrationImpl<?>> srl = this.fwCtx.services.get(FindHook.class.getName());
        if (srl != null) {
            RemoveOnlyCollection<Bundle> filtered = new RemoveOnlyCollection<Bundle>(bundles);
            for (ServiceRegistrationImpl<?> serviceRegistrationImpl : srl) {
                ServiceReferenceImpl sr = serviceRegistrationImpl.reference;
                FindHook fh = (FindHook)sr.getService();
                if (fh == null) continue;
                try {
                    fh.find(bc, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(bc, (Throwable)new BundleException("Failed to call Bundle FindHook  #" + sr.getProperty("service.id"), e), new FrameworkListener[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filterBundleEventReceivers(BundleEvent evt, HashSet<ListenerEntry> syncBundleListeners, HashSet<ListenerEntry> bundleListeners) {
        List<ServiceRegistrationImpl<?>> eventHooks = this.fwCtx.services.get(EventHook.class.getName());
        HashSet<ListenerEntry> hashSet = this.fwCtx.listeners.syncBundleListeners;
        synchronized (hashSet) {
            syncBundleListeners.addAll(this.fwCtx.listeners.syncBundleListeners);
        }
        hashSet = this.fwCtx.listeners.bundleListeners;
        synchronized (hashSet) {
            if (bundleListeners != null) {
                bundleListeners.addAll(this.fwCtx.listeners.bundleListeners);
            }
        }
        if (eventHooks != null) {
            HashSet<BundleContextImpl> bundleContexts = new HashSet<BundleContextImpl>();
            for (ListenerEntry le : syncBundleListeners) {
                bundleContexts.add(le.bc);
            }
            if (bundleListeners != null) {
                for (ListenerEntry le : bundleListeners) {
                    bundleContexts.add(le.bc);
                }
            }
            int unfilteredSize = bundleContexts.size();
            RemoveOnlyCollection<BundleContext> filtered = new RemoveOnlyCollection<BundleContext>(bundleContexts);
            for (ServiceRegistrationImpl<?> serviceRegistrationImpl : eventHooks) {
                ServiceReferenceImpl sr = serviceRegistrationImpl.reference;
                EventHook eh = (EventHook)sr.getService();
                if (eh == null) continue;
                try {
                    eh.event(evt, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(this.fwCtx.systemBundle, (Throwable)new BundleException("Failed to call Bundle EventHook #" + sr.getProperty("service.id"), e), new FrameworkListener[0]);
                }
            }
            if (unfilteredSize != bundleContexts.size()) {
                ListenerEntry le;
                bundleContexts.add(this.fwCtx.systemBundle.bundleContext);
                Iterator<ListenerEntry> i = syncBundleListeners.iterator();
                while (i.hasNext()) {
                    le = i.next();
                    if (bundleContexts.contains(le.bc)) continue;
                    i.remove();
                }
                if (bundleListeners != null) {
                    i = bundleListeners.iterator();
                    while (i.hasNext()) {
                        le = i.next();
                        if (bundleContexts.contains(le.bc)) continue;
                        i.remove();
                    }
                }
            }
        }
    }

    void filterCollisions(int mode, Bundle b, Collection<Bundle> bundles) {
        List<ServiceRegistrationImpl<?>> srl = this.fwCtx.services.get(CollisionHook.class.getName());
        if (srl != null) {
            RemoveOnlyCollection<Bundle> filtered = new RemoveOnlyCollection<Bundle>(bundles);
            for (ServiceRegistrationImpl<?> serviceRegistrationImpl : srl) {
                ServiceReferenceImpl sr = serviceRegistrationImpl.reference;
                CollisionHook ch = (CollisionHook)sr.getService();
                if (ch == null) continue;
                try {
                    ch.filterCollisions(mode, b, filtered);
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(b, (Throwable)new BundleException("Failed to call Bundle CollisionHook #" + sr.getProperty("service.id"), e), new FrameworkListener[0]);
                }
            }
        }
    }
}

