/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.util.regex.Pattern;

public enum CopiedImageSources {
    ANY,
    ANY_ABSOLUTE_URL(Pattern.compile("^\\w{2,}:/", 2)),
    ANY_HTTP_URL(Pattern.compile("^https?:/", 2)),
    NONE;

    private final Pattern pattern;

    private CopiedImageSources() {
        this(null);
    }

    private CopiedImageSources(Pattern pattern) {
        this.pattern = pattern;
    }

    boolean includes(String source) {
        if (source == null) {
            return false;
        }
        switch (this) {
            case ANY: {
                return true;
            }
            case NONE: {
                return false;
            }
        }
        return this.pattern.matcher(source).find();
    }
}

