/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Action;
import javax.swing.JComponent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.UnknownElementWriter;
import org.freeplane.core.io.UnknownElements;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.DelayedRunner;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.CloneConditionController;
import org.freeplane.features.map.CloseAction;
import org.freeplane.features.map.GotoNodeAction;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.JumpInAction;
import org.freeplane.features.map.JumpOutAction;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeChangeAnnouncer;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeLevelConditionController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.ShowNextChildAction;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.ToggleChildrenFoldedAction;
import org.freeplane.features.map.ToggleFoldedAction;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.SelectionController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.UrlManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MouseEventActor;

public class MapController
extends SelectionController
implements IExtension,
NodeChangeAnnouncer {
    private final List<IMapChangeListener> mapChangeListeners;
    private boolean areMapChangeListenersSorted;
    private final List<IMapLifeCycleListener> mapLifeCycleListeners;
    private final MapReader mapReader;
    private final MapWriter mapWriter;
    private final ModeController modeController;
    final LinkedList<INodeChangeListener> nodeChangeListeners;
    private boolean areNodeChangeListenersSorted;
    private final ReadManager readManager;
    private final WriteManager writeManager;
    private final ActionEnablerOnChange actionEnablerOnChange;
    private final ActionSelectorOnChange actionSelectorOnChange;
    private final Refresher refresher;
    private JComponent changedMapViewComponent;

    private static boolean hasValidSelection() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        return selection != null && selection.getSelected() != null;
    }

    public static void install() {
        ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();
        conditionFactory.addConditionController(80, new NodeLevelConditionController());
        conditionFactory.addConditionController(75, new CloneConditionController());
    }

    public void addListenerForAction(AFreeplaneAction action) {
        if (action.checkEnabledOnChange()) {
            this.actionEnablerOnChange.add(action);
        }
        if (action.checkSelectionOnChange()) {
            this.actionSelectorOnChange.add(action);
        }
    }

    public void removeListenerForAction(AFreeplaneAction action) {
        if (action.checkEnabledOnChange()) {
            this.actionEnablerOnChange.remove(action);
        }
        if (action.checkSelectionOnChange()) {
            this.actionSelectorOnChange.remove(action);
        }
    }

    public MapController(ModeController modeController) {
        modeController.setMapController(this);
        this.refresher = new Refresher();
        this.modeController = modeController;
        this.mapLifeCycleListeners = new LinkedList<IMapLifeCycleListener>();
        this.addMapLifeCycleListener(modeController.getController());
        this.writeManager = new WriteManager();
        this.mapWriter = new MapWriter(this);
        this.readManager = new ReadManager();
        this.mapReader = new MapReader(this.readManager);
        this.readManager.addElementHandler("map", this.mapReader);
        this.readManager.addAttributeHandler("map", "version", new IAttributeHandler(){

            @Override
            public void setAttribute(Object node, String value) {
            }
        });
        this.readManager.addAttributeHandler("map", "dialect", new IAttributeHandler(){

            @Override
            public void setAttribute(Object node, String value) {
            }
        });
        this.writeManager.addElementWriter("map", this.mapWriter);
        this.writeManager.addAttributeWriter("map", this.mapWriter);
        UnknownElementWriter unknownElementWriter = new UnknownElementWriter();
        this.writeManager.addExtensionAttributeWriter(UnknownElements.class, unknownElementWriter);
        this.writeManager.addExtensionElementWriter(UnknownElements.class, unknownElementWriter);
        this.mapChangeListeners = new LinkedList<IMapChangeListener>();
        this.nodeChangeListeners = new LinkedList();
        this.actionEnablerOnChange = new ActionEnablerOnChange(modeController);
        this.actionSelectorOnChange = new ActionSelectorOnChange(modeController);
        this.addNodeSelectionListener(this.actionEnablerOnChange);
        this.addUINodeChangeListener(this.actionEnablerOnChange);
        this.addUIMapChangeListener(this.actionEnablerOnChange);
        this.addNodeSelectionListener(this.actionSelectorOnChange);
        this.addUINodeChangeListener(this.actionSelectorOnChange);
        this.addUIMapChangeListener(this.actionSelectorOnChange);
        MapClipboardController mapClipboardController = this.createMapClipboardController();
        modeController.addExtension(MapClipboardController.class, mapClipboardController);
        this.createActions(modeController);
    }

    protected MapClipboardController createMapClipboardController() {
        MapClipboardController mapClipboardController = new MapClipboardController(this.modeController);
        this.modeController.getExtension(ClipboardControllers.class).add(mapClipboardController);
        return mapClipboardController;
    }

    public void unfoldAndScroll(NodeModel node, Filter filter) {
        boolean wasFoldedOnCurrentView = this.canBeUnfoldedOnCurrentView(node, filter);
        this.unfold(node, filter);
        if (wasFoldedOnCurrentView) {
            this.scrollNodeTreeAfterUnfold(node);
        }
    }

    void scrollNodeTreeAfterUnfold(NodeModel node) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (this.shouldAutoscroll("scrollOnUnfold")) {
            selection.scrollNodeTreeToVisible(node);
        } else {
            selection.scrollNodeToVisible(node);
        }
    }

    public void scrollNodeTreeAfterSelect(NodeModel node) {
        boolean shouldCenterNode = this.shouldAutoscroll("center_selected_node");
        boolean shouldScrollSubtree = this.shouldAutoscroll("scrollOnSelect");
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (shouldCenterNode) {
            selection.scrollNodeToCenter(node);
            if (shouldScrollSubtree) {
                selection.scrollNodeTreeToVisible(node);
            }
        } else if (shouldScrollSubtree) {
            selection.scrollNodeTreeToVisible(node);
        } else {
            selection.scrollNodeToVisible(node);
        }
    }

    private boolean shouldAutoscroll(String propertyName) {
        ResourceController resourceController = ResourceController.getResourceController();
        boolean shouldAutoscroll = resourceController.getBooleanProperty(propertyName) && (!MouseEventActor.INSTANCE.isActive() || !resourceController.getBooleanProperty("autoscroll_disabled_for_mouse_interaction"));
        return shouldAutoscroll;
    }

    public void setFolded(NodeModel node, boolean fold, Filter filter) {
        if (!fold || node.isRoot()) {
            this.unfold(node, filter);
        } else {
            this.fold(node);
        }
    }

    public void toggleFolded(NodeModel node) {
        Filter filter = Controller.getCurrentController().getSelection().getFilter();
        this.toggleFolded(node, filter);
    }

    public void toggleFolded(NodeModel node, Filter filter) {
        if (this.canBeUnfoldedOnCurrentView(node, filter)) {
            this.unfold(node, filter);
        } else {
            this.fold(node);
        }
    }

    public void toggleFoldedAndScroll(NodeModel node) {
        Filter filter = Controller.getCurrentController().getSelection().getFilter();
        this.toggleFoldedAndScroll(node, filter);
    }

    public void toggleFoldedAndScroll(NodeModel node, List<NodeModel> childNodes, Filter filter) {
        boolean unfolded = this.toggleFolded(filter, childNodes);
        if (unfolded) {
            this.scrollNodeTreeAfterUnfold(node);
        } else {
            NodeModel node1 = node;
            Controller.getCurrentController().getSelection().scrollNodeToVisible(node1);
        }
    }

    public void toggleFoldedAndScroll(NodeModel node, Filter filter) {
        if (this.canBeUnfoldedOnCurrentView(node, filter)) {
            this.unfoldAndScroll(node, filter);
        } else {
            this.fold(node);
            Controller.getCurrentController().getSelection().scrollNodeToVisible(node);
        }
    }

    public void unfold(NodeModel node, Filter filter) {
        if (node.getChildCount() == 0) {
            return;
        }
        boolean hiddenChildShown = this.unfoldHiddenChildren(node);
        boolean mapChanged = false;
        if (this.canBeUnfoldedOnCurrentView(node, filter)) {
            this.unfoldUpToVisibleChild(node, filter);
            mapChanged = true;
        } else if (node.isFolded()) {
            mapChanged = true;
            this.setFoldingState(node, false);
        }
        if (mapChanged) {
            this.fireFoldingChanged(node);
        }
        if (hiddenChildShown) {
            this.fireNodeUnfold(node);
        }
    }

    public void fold(NodeModel node) {
        if (node.getChildCount() == 0 || node.isRoot() || this.isCurrentSelectionRoot(node)) {
            return;
        }
        boolean hiddenChildShown = this.unfoldHiddenChildren(node);
        boolean mapChanged = false;
        if (!node.isFolded()) {
            mapChanged = true;
        }
        this.setFoldingState(node, true);
        if (mapChanged) {
            this.fireFoldingChanged(node);
        }
        if (hiddenChildShown) {
            this.fireNodeUnfold(node);
        }
    }

    private boolean isCurrentSelectionRoot(NodeModel node) {
        IMapSelection selection = this.getModeController().getController().getSelection();
        return selection == null ? false : selection.getSelectionRoot() == node;
    }

    protected void setFoldingState(NodeModel node, boolean folded) {
        node.setFolded(folded);
    }

    public boolean showNextChild(NodeModel node) {
        if (node.getChildCount() == 0) {
            return false;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        boolean unfold = mapViewManager.isFoldedOnCurrentView(node);
        if (unfold) {
            mapViewManager.hideChildren(node);
            this.setFoldingState(node, false);
        }
        boolean childShown = false;
        Filter filter = Controller.getCurrentController().getSelection().getFilter();
        for (NodeModel child : node.getChildren()) {
            if (!mapViewManager.showHiddenNode(child)) continue;
            if (child.hasVisibleContent(filter)) {
                childShown = true;
                break;
            }
            if (!this.canBeUnfoldedOnCurrentView(child, filter) && (!SummaryNode.isSummaryNode(child) || !child.subtreeHasVisibleContent(filter))) continue;
            this.unfoldUpToVisibleChild(child, filter);
            childShown = true;
            break;
        }
        if (childShown) {
            this.fireNodeUnfold(node);
        }
        return childShown;
    }

    private void fireNodeUnfold(NodeModel node) {
        node.fireNodeChanged(new NodeChangeEvent(node, (Object)NodeView.Properties.HIDDEN_CHILDREN, null, null, false, false));
    }

    protected void fireFoldingChanged(NodeModel node) {
        if (this.isFoldingPersistentAlways()) {
            MapModel map = node.getMap();
            this.mapSaved(map, false);
        }
    }

    protected boolean isFoldingPersistentAlways() {
        ResourceController resourceController = ResourceController.getResourceController();
        return resourceController.getProperty("save_folding").equals("always_save_folding");
    }

    protected boolean unfoldHiddenChildren(NodeModel node) {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        return !mapViewManager.isFoldedOnCurrentView(node) && mapViewManager.unfoldHiddenChildren(node);
    }

    public boolean canBeUnfoldedOnCurrentView(NodeModel node, Filter filter) {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        boolean isFolded = mapViewManager.isFoldedOnCurrentView(node) || mapViewManager.hasHiddenChildren(node);
        boolean canBeAncestor = filter == null || filter.getFilterInfo(node).canBeAncestor();
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeModel child = node.getChildAt(i);
            if ((!isFolded || !child.subtreeHasVisibleContent(filter)) && (!canBeAncestor || child.isVisible(filter) || !this.canBeUnfoldedOnCurrentView(child, filter))) continue;
            return true;
        }
        return false;
    }

    private void unfoldUpToVisibleChild(NodeModel node, Filter filter) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            NodeModel child = node.getChildAt(i);
            if (child.hasVisibleContent(filter) || !this.canBeUnfoldedOnCurrentView(child, filter)) continue;
            this.unfoldUpToVisibleChild(child, filter);
        }
        this.setFoldingState(node, false);
    }

    public void addUIMapChangeListener(IMapChangeListener listener) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.addMapChangeListener(listener);
        }
    }

    public void addMapChangeListener(IMapChangeListener listener) {
        this.mapChangeListeners.add(listener);
        this.areMapChangeListenersSorted = false;
    }

    public void addUINodeChangeListener(INodeChangeListener listener) {
        if (!GraphicsEnvironment.isHeadless()) {
            this.addNodeChangeListener(listener);
        }
    }

    public void addNodeChangeListener(INodeChangeListener listener) {
        this.nodeChangeListeners.add(listener);
        this.areNodeChangeListenersSorted = false;
    }

    public void addMapLifeCycleListener(IMapLifeCycleListener listener) {
        this.mapLifeCycleListeners.add(listener);
    }

    public void centerNode(NodeModel node) {
        Controller.getCurrentController().getSelection().scrollNodeToCenter(node);
    }

    public List<NodeModel> childrenFolded(NodeModel node) {
        if (node.isFolded()) {
            List<NodeModel> empty = Collections.emptyList();
            return empty;
        }
        return node.getChildren();
    }

    public void closeWithoutSaving(MapModel map) {
        this.fireMapRemoved(map);
        map.releaseResources();
    }

    private void createActions(ModeController modeController) {
        modeController.addAction(new ToggleFoldedAction());
        modeController.addAction(new ToggleChildrenFoldedAction());
        modeController.addAction(new ShowNextChildAction());
        modeController.addAction(new GotoNodeAction());
        modeController.addAction(new CloseAction());
        modeController.addAction(new JumpInAction());
        modeController.addAction(new JumpOutAction());
    }

    public void displayNode(NodeModel node) {
        this.displayNode(node, null);
    }

    public void displayNode(NodeModel node, ArrayList<NodeModel> nodesUnfoldedByDisplay) {
        Controller controller = this.modeController.getController();
        IMapSelection selection = controller.getSelection();
        if (node.getMap() != selection.getSelected().getMap()) {
            return;
        }
        Filter filter = selection.getFilter();
        if (!node.hasVisibleContent(filter)) {
            filter.showAsMatched(node);
            this.modeController.getMapController().fireMapChanged(new MapChangeEvent(this, node.getMap(), Filter.class, null, this, false));
        }
        NodeModel[] path = node.getPathToRoot();
        for (int i = 0; i < path.length - 1; ++i) {
            NodeModel nodeOnPath = path[i];
            if (nodesUnfoldedByDisplay == null || !this.isFolded(nodeOnPath)) continue;
            nodesUnfoldedByDisplay.add(nodeOnPath);
        }
        controller.getMapViewManager().displayOnCurrentView(node);
    }

    public void fireMapChanged(MapChangeEvent event) {
        IMapChangeListener[] list;
        MapModel map = event.getMap();
        if (map != null && event.setsDirtyFlag()) {
            this.mapSaved(map, false);
        }
        this.sortMapChangeListeners();
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.mapChanged(event);
        }
        if (map != null) {
            map.fireMapChangeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMapCreated(MapModel map) {
        boolean readOnly = map.isReadOnly();
        try {
            IMapLifeCycleListener[] list;
            map.setReadOnly(false);
            for (IMapLifeCycleListener next : list = this.mapLifeCycleListeners.toArray(new IMapLifeCycleListener[0])) {
                next.onCreate(map);
            }
        }
        finally {
            map.setReadOnly(readOnly);
        }
    }

    protected void fireMapRemoved(MapModel map) {
        IMapLifeCycleListener[] list;
        for (IMapLifeCycleListener next : list = this.mapLifeCycleListeners.toArray(new IMapLifeCycleListener[0])) {
            next.onRemove(map);
        }
    }

    private void sortNodeChangeListeners() {
        if (!this.areNodeChangeListenersSorted) {
            Collections.sort(this.nodeChangeListeners);
            this.areNodeChangeListenersSorted = true;
        }
    }

    private void fireNodeChanged(NodeModel node, NodeChangeEvent nodeChangeEvent) {
        this.sortNodeChangeListeners();
        INodeChangeListener[] nodeChangeListeners = this.nodeChangeListeners.toArray(new INodeChangeListener[0]);
        node.fireNodeChanged(nodeChangeListeners, nodeChangeEvent);
    }

    private void sortMapChangeListeners() {
        if (!this.areMapChangeListenersSorted) {
            Collections.sort(this.mapChangeListeners);
            this.areMapChangeListenersSorted = true;
        }
    }

    protected void fireNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        this.sortMapChangeListeners();
        IMapChangeListener[] list = this.mapChangeListeners.toArray(new IMapChangeListener[0]);
        nodeDeletionEvent.parent.fireNodeRemoved(list, nodeDeletionEvent);
        NodeModel node = nodeDeletionEvent.node;
        MapModel map = node.getMap();
        map.fireNodeDeletionEvent(nodeDeletionEvent);
        map.unregistryNodes(node);
    }

    protected void fireNodeInserted(NodeModel parent, NodeModel child, int index) {
        this.sortMapChangeListeners();
        MapModel map = parent.getMap();
        map.registryNodeRecursive(child);
        IMapChangeListener[] list = this.mapChangeListeners.toArray(new IMapChangeListener[0]);
        map.fireNodeInsertionEvent(parent, child, index);
        parent.fireNodeInserted(list, child, index);
    }

    protected void fireNodeMoved(NodeMoveEvent nodeMovedEvent) {
        this.sortMapChangeListeners();
        IMapChangeListener[] list = this.mapChangeListeners.toArray(new IMapChangeListener[0]);
        NodeModel.fireNodeMoved(list, nodeMovedEvent);
        NodeModel node = nodeMovedEvent.child;
        MapModel map = node.getMap();
        map.fireNodeMovedEvent(nodeMovedEvent);
    }

    protected void firePreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        IMapChangeListener[] list;
        this.sortMapChangeListeners();
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onPreNodeMoved(nodeMoveEvent);
        }
    }

    protected void firePreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
        IMapChangeListener[] list;
        this.sortMapChangeListeners();
        for (IMapChangeListener next : list = this.mapChangeListeners.toArray(new IMapChangeListener[0])) {
            next.onPreNodeDelete(nodeDeletionEvent);
        }
    }

    public void getFilteredXml(MapModel map, Writer fileout, MapWriter.Mode mode, boolean forceFormat) throws IOException {
        this.getMapWriter().writeMapAsXml(map, fileout, mode, MapClipboardController.CopiedNodeSet.FILTERED_NODES, forceFormat);
    }

    public void getFilteredXml(Collection<NodeModel> nodes, Writer fileout, MapWriter.Mode mode, boolean forceFormat) throws IOException {
        for (NodeModel node : nodes) {
            this.getMapWriter().writeNodeAsXml(fileout, node, mode, MapClipboardController.CopiedNodeSet.FILTERED_NODES, true, forceFormat);
        }
    }

    public MapReader getMapReader() {
        return this.mapReader;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    public NodeModel getNodeFromID_(String nodeID) {
        MapModel map = Controller.getCurrentController().getMap();
        if (map == null) {
            return null;
        }
        NodeModel node = map.getNodeForID(nodeID);
        return node;
    }

    public String getNodeID(NodeModel selected) {
        return selected.createID();
    }

    public ReadManager getReadManager() {
        return this.readManager;
    }

    public NodeModel getRootNode() {
        MapModel map = Controller.getCurrentController().getMap();
        return map.getRootNode();
    }

    public NodeModel getSelectedNode() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            return selection.getSelected();
        }
        return null;
    }

    public List<NodeModel> getSelectedNodes() {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection == null) {
            return Collections.emptyList();
        }
        return selection.getOrderedSelection();
    }

    public WriteManager getWriteManager() {
        return this.writeManager;
    }

    public boolean hasFoldedStrictDescendant(NodeModel node) {
        for (NodeModel child : node.getChildren()) {
            if (!this.isFolded(child) && !this.hasFoldedStrictDescendant(child)) continue;
            return true;
        }
        return false;
    }

    public void insertNodeIntoWithoutUndo(NodeModel newChild, NodeModel parent) {
        this.insertNodeIntoWithoutUndo(newChild, parent, parent.getChildCount());
    }

    public void insertNodeIntoWithoutUndo(NodeModel newNode, NodeModel parent, int index) {
        parent.insert(newNode, index);
        this.fireNodeInserted(parent, newNode, index);
    }

    public boolean isFolded(NodeModel node) {
        return node.isFolded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void openMap(URL url) throws FileNotFoundException, XMLParseException, IOException, URISyntaxException, XMLException {
        if (AddOnsController.getController().installIfAppropriate(url)) {
            return;
        }
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        if (mapViewManager.tryToChangeToMapView(url)) {
            return;
        }
        try {
            Controller.getCurrentController().getViewController().setWaitingCursor(true);
            MapModel newModel = new MapModel(this.duplicator());
            UrlManager.getController().loadCatchExceptions(url, newModel);
            newModel.setReadOnly(true);
            newModel.setSaved(true);
            this.fireMapCreated(newModel);
            this.createMapView(newModel);
        }
        finally {
            Controller.getCurrentController().getViewController().setWaitingCursor(false);
        }
    }

    public void openMapSelectReferencedNode(URL url) throws FileNotFoundException, XMLParseException, IOException, URISyntaxException, XMLException, MalformedURLException {
        String nodeReference = url.getRef();
        if (nodeReference != null) {
            this.openMap(new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath()));
            NodeModel node = this.getNodeAt(nodeReference);
            if (node != null) {
                this.select(node);
            }
        } else {
            this.openMap(url);
        }
    }

    private NodeModel getNodeAt(String nodeReference) {
        return this.modeController.getExtension(MapExplorerController.class).getNodeAt(this.getRootNode(), nodeReference);
    }

    public void createMapView(MapModel mapModel) {
        mapModel.beforeViewCreated();
        Controller.getCurrentController().getMapViewManager().newMapView(mapModel, this.modeController);
    }

    public MapModel newMap() {
        MapModel mindMapMapModel = new MapModel(this.duplicator());
        mindMapMapModel.createNewRoot();
        this.fireMapCreated(mindMapMapModel);
        this.createMapView(mindMapMapModel);
        return mindMapMapModel;
    }

    public INodeDuplicator duplicator() {
        return this.modeController.getExtension(MapClipboardController.class);
    }

    @Override
    public void nodeChanged(NodeModel node) {
        this.nodeChanged(node, NodeModel.UNKNOWN_PROPERTY, null, null);
    }

    @Override
    public void nodeChanged(NodeModel node, Object property, Object oldValue, Object newValue) {
        NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, property, oldValue, newValue, true, true);
        this.nodeRefresh(nodeChangeEvent);
    }

    @Override
    public void nodeRefresh(NodeModel node) {
        this.nodeRefresh(node, NodeModel.UNKNOWN_PROPERTY, null, null);
    }

    @Override
    public void nodeRefresh(NodeModel node, Object property, Object oldValue, Object newValue) {
        NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, property, oldValue, newValue, false, false);
        this.nodeRefresh(nodeChangeEvent);
    }

    @Override
    public void nodeRefresh(NodeChangeEvent nodeChangeEvent) {
        HistoryInformationModel historyInformation;
        if (this.mapReader.isMapLoadingInProcess()) {
            return;
        }
        final NodeModel node = nodeChangeEvent.getNode();
        MapModel map = node.getMap();
        if (nodeChangeEvent.setsDirtyFlag()) {
            this.mapSaved(map, false);
        }
        if (nodeChangeEvent.updatesModificationTime() && !map.isUndoActionRunning() && (historyInformation = node.getHistoryInformation()) != null) {
            IActor historyActor = new IActor(){
                private final Date lastModifiedAt;
                private final Date now;
                {
                    this.lastModifiedAt = historyInformation.getLastModifiedAt();
                    this.now = new Date();
                }

                @Override
                public void undo() {
                    this.setDate(historyInformation, this.lastModifiedAt);
                }

                private void setDate(HistoryInformationModel historyInformation2, Date lastModifiedAt) {
                    Date oldLastModifiedAt = historyInformation2.getLastModifiedAt();
                    historyInformation2.setLastModifiedAt(lastModifiedAt);
                    NodeChangeEvent nodeChangeEvent = new NodeChangeEvent(node, HistoryInformationModel.class, oldLastModifiedAt, lastModifiedAt, false, false);
                    MapController.this.fireNodeChanged(node, nodeChangeEvent);
                }

                @Override
                public String getDescription() {
                    return null;
                }

                @Override
                public void act() {
                    this.setDate(historyInformation, this.now);
                }
            };
            Controller.getCurrentModeController().execute(historyActor, map);
        }
        this.fireNodeChanged(node, nodeChangeEvent);
    }

    public void refreshNodeLaterUndoable(final NodeModel node, final Object property, final Object oldValue, final Object newValue) {
        IActor actor = new IActor(){

            @Override
            public void undo() {
                MapController.this.delayedNodeRefresh(node, property, newValue, oldValue);
            }

            @Override
            public String getDescription() {
                return "delayedNodeRefresh";
            }

            @Override
            public void act() {
                MapController.this.delayedNodeRefresh(node, property, oldValue, newValue);
            }
        };
        this.getModeController().execute(actor, node.getMap());
    }

    public void delayedNodeRefresh(NodeModel node, Object property, Object oldValue, Object newValue) {
        if (Controller.getCurrentController().getViewController().isDispatchThread()) {
            this.refresher.delayedNodeRefresh(node, property, oldValue, newValue);
        } else {
            this.nodeRefresh(node, property, oldValue, newValue);
        }
    }

    public void removeMapChangeListener(IMapChangeListener listener) {
        this.mapChangeListeners.remove(listener);
    }

    public void removeMapLifeCycleListener(IMapLifeCycleListener listener) {
        this.mapLifeCycleListeners.remove(listener);
    }

    void removeNodeChangeListener(Class<? extends AController.IActionOnChange> clazz, Action action) {
        Iterator iterator = this.nodeChangeListeners.iterator();
        while (iterator.hasNext()) {
            INodeChangeListener next = (INodeChangeListener)iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    void removeMapChangeListener(Class<? extends AController.IActionOnChange> clazz, Action action) {
        Iterator<IMapChangeListener> iterator = this.mapChangeListeners.iterator();
        while (iterator.hasNext()) {
            IMapChangeListener next = iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    public void removeNodeChangeListener(INodeChangeListener listener) {
        this.nodeChangeListeners.remove(listener);
    }

    void removeNodeSelectionListener(Class<? extends AController.IActionOnChange> clazz, Action action) {
        Iterator iterator = this.getNodeSelectionListeners().iterator();
        while (iterator.hasNext()) {
            INodeSelectionListener next = (INodeSelectionListener)iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    public Collection<IMapChangeListener> getMapChangeListeners() {
        this.sortMapChangeListeners();
        return Collections.unmodifiableCollection(this.mapChangeListeners);
    }

    public Collection<IMapLifeCycleListener> getMapLifeCycleListeners() {
        return Collections.unmodifiableCollection(this.mapLifeCycleListeners);
    }

    public Collection<INodeChangeListener> getNodeChangeListeners() {
        this.sortNodeChangeListeners();
        return Collections.unmodifiableCollection(this.nodeChangeListeners);
    }

    public void forceViewChange(Runnable runnable) {
        JComponent previous = this.changedMapViewComponent;
        this.changedMapViewComponent = this.modeController.getController().getMapViewManager().getMapViewComponent();
        try {
            runnable.run();
        }
        finally {
            this.changedMapViewComponent = previous;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void select(final NodeModel node) {
        MapModel map = node.getMap();
        Controller controller = Controller.getCurrentController();
        final IMapViewManager mapViewManager = controller.getMapViewManager();
        if (this.changedMapViewComponent == mapViewManager.getMapViewComponent()) {
            List<Component> views = mapViewManager.getViews(map);
            Optional<Component> anotherView = views.stream().filter(v -> !v.equals(this.changedMapViewComponent)).findFirst();
            if (!anotherView.isPresent()) {
                mapViewManager.addMapViewChangeListener(new IMapViewChangeListener(){

                    @Override
                    public void afterViewDisplayed(Component oldView, Component newView) {
                        mapViewManager.removeMapViewChangeListener(this);
                        MapController.this.select(node);
                    }
                });
                mapViewManager.newMapView(map, this.modeController);
                return;
            }
            mapViewManager.changeToMapView(anotherView.get());
        } else if (!map.equals(controller.getMap())) {
            mapViewManager.changeToMap(map);
        }
        this.displayNode(node);
        IMapSelection selection = controller.getSelection();
        selection.selectAsTheOnlyOneSelected(node);
    }

    public void selectMultipleNodes(NodeModel focussed, Collection<NodeModel> selecteds) {
        for (NodeModel node : selecteds) {
            this.displayNode(node);
        }
        this.select(focussed);
        for (NodeModel node : selecteds) {
            Controller.getCurrentController().getSelection().makeTheSelected(node);
        }
    }

    public void mapSaved(MapModel mapModel, boolean saved) {
    }

    public void sortNodesByDepth(List<NodeModel> collection) {
        Collections.sort(collection, new NodesDepthComparator());
    }

    public boolean toggleFolded(Filter filter, Collection<NodeModel> collection) {
        NodeModel[] nodes;
        boolean shouldBeUnfolded = this.canBeUnfoldedOnCurrentView(filter, collection);
        for (NodeModel node : nodes = collection.toArray(new NodeModel[0])) {
            this.setFolded(node, !shouldBeUnfolded, filter);
        }
        return shouldBeUnfolded;
    }

    private boolean canBeUnfoldedOnCurrentView(Filter filter, Collection<NodeModel> collection) {
        for (NodeModel node : collection) {
            if (!node.isRoot()) continue;
            return false;
        }
        for (NodeModel node : collection) {
            if (!this.canBeUnfoldedOnCurrentView(node, filter)) continue;
            return true;
        }
        return false;
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public void select(String nodeReference) {
        this.select(this.getNodeFromID_(nodeReference));
    }

    public MapModel getMap(URL url) {
        throw new RuntimeException("Method not implemented");
    }

    public static NodeModel.Side suggestNewChildSide(NodeModel target, NodeModel.Side sideArgument) {
        NodeModel.Side side;
        if (sideArgument.isSibling()) {
            side = target.getSide();
        } else {
            IMapSelection selection = Controller.getCurrentController().getSelection();
            side = target.isRoot() || selection != null && selection.getSelectionRoot() == target ? (sideArgument == NodeModel.Side.DEFAULT ? target.suggestNewChildSide(target) : sideArgument) : NodeModel.Side.DEFAULT;
        }
        return side;
    }

    private static class ActionEnablerOnChange
    implements INodeChangeListener,
    INodeSelectionListener,
    IMapChangeListener {
        private final Collection<AFreeplaneAction> actions = new HashSet<AFreeplaneAction>();
        private final DelayedRunner runner;

        public ActionEnablerOnChange(final ModeController modeController) {
            this.runner = new DelayedRunner(new Runnable(){

                @Override
                public void run() {
                    if (modeController == Controller.getCurrentModeController()) {
                        this.setActionsEnabledNow();
                    }
                }
            });
        }

        @Override
        public void nodeChanged(NodeChangeEvent event) {
            this.setActionEnabled();
        }

        @Override
        public void onDeselect(NodeModel node) {
        }

        @Override
        public void onSelect(NodeModel node) {
            this.runner.runLater();
        }

        private void setActionsEnabledNow() {
            if (MapController.hasValidSelection()) {
                MapModel map = Controller.getCurrentController().getMap();
                UserRole userRole = Controller.getCurrentModeController().userRole(map);
                for (AFreeplaneAction action : this.actions) {
                    action.setEnabled(userRole);
                }
            }
        }

        @Override
        public void mapChanged(MapChangeEvent event) {
            this.setActionEnabled();
        }

        @Override
        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionEnabled();
        }

        @Override
        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            this.setActionEnabled();
        }

        @Override
        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.setActionEnabled();
        }

        @Override
        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
        }

        @Override
        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionEnabled();
        }

        private void setActionEnabled() {
            if (MapController.hasValidSelection()) {
                this.runner.runLater();
            }
        }

        public void add(AFreeplaneAction action) {
            this.actions.add(action);
        }

        public void remove(AFreeplaneAction action) {
            this.actions.remove(action);
        }
    }

    private static class ActionSelectorOnChange
    implements INodeChangeListener,
    INodeSelectionListener,
    IMapChangeListener {
        private final Collection<AFreeplaneAction> actions = new HashSet<AFreeplaneAction>();
        private final DelayedRunner runner;

        public ActionSelectorOnChange(final ModeController modeController) {
            this.runner = new DelayedRunner(new Runnable(){

                @Override
                public void run() {
                    if (modeController == Controller.getCurrentModeController()) {
                        this.setActionsSelectedNow();
                    }
                }
            });
        }

        @Override
        public void nodeChanged(NodeChangeEvent event) {
            if (NodeModel.NodeChangeType.REFRESH.equals(event.getProperty())) {
                return;
            }
            this.setActionsSelected();
        }

        private void setActionsSelected() {
            if (MapController.hasValidSelection()) {
                this.runner.runLater();
            }
        }

        private void setActionsSelectedNow() {
            if (MapController.hasValidSelection()) {
                for (AFreeplaneAction action : this.actions) {
                    action.setSelected();
                }
            }
        }

        @Override
        public void onDeselect(NodeModel node) {
        }

        @Override
        public void onSelect(NodeModel node) {
            this.setActionsSelected();
        }

        @Override
        public void mapChanged(MapChangeEvent event) {
            this.setActionsSelected();
        }

        @Override
        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionsSelected();
        }

        @Override
        public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
            this.setActionsSelected();
        }

        @Override
        public void onNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.setActionsSelected();
        }

        @Override
        public void onPreNodeDelete(NodeDeletionEvent nodeDeletionEvent) {
            this.setActionsSelected();
        }

        @Override
        public void onPreNodeMoved(NodeMoveEvent nodeMoveEvent) {
            this.setActionsSelected();
        }

        public void add(AFreeplaneAction action) {
            this.actions.add(action);
        }

        public void remove(AFreeplaneAction action) {
            this.actions.remove(action);
        }
    }

    static class Refresher {
        private final ConcurrentHashMap<NodeRefreshKey, NodeRefreshValue> nodesToRefresh = new ConcurrentHashMap();

        Refresher() {
        }

        void delayedNodeRefresh(NodeModel node, Object property, Object oldValue, Object newValue) {
            boolean startThread = this.nodesToRefresh.isEmpty();
            NodeRefreshKey key = new NodeRefreshKey(node, property);
            NodeRefreshValue value = new NodeRefreshValue(Controller.getCurrentModeController(), oldValue, newValue);
            NodeRefreshValue old = this.nodesToRefresh.put(key, value);
            if (old != null && old.newValue != value.newValue) {
                old.newValue = value.newValue;
                this.nodesToRefresh.put(key, old);
            }
            if (startThread) {
                Runnable refresher = new Runnable(){

                    @Override
                    public void run() {
                        ModeController currentModeController = Controller.getCurrentModeController();
                        Map.Entry[] entries = nodesToRefresh.entrySet().toArray(new Map.Entry[0]);
                        nodesToRefresh.clear();
                        for (Map.Entry entry : entries) {
                            NodeRefreshValue info = (NodeRefreshValue)entry.getValue();
                            if (info.controller != currentModeController) continue;
                            NodeRefreshKey key = (NodeRefreshKey)entry.getKey();
                            currentModeController.getMapController().nodeRefresh(key.node, key.property, info.oldValue, info.newValue);
                        }
                    }
                };
                Controller.getCurrentController().getViewController().invokeLater(refresher);
            }
        }
    }

    private static class NodesDepthComparator
    implements Comparator<NodeModel> {
        @Override
        public int compare(NodeModel n1, NodeModel n2) {
            NodeModel[] path2;
            NodeModel[] path1 = n1.getPathToRoot();
            int depth = path1.length - (path2 = n2.getPathToRoot()).length;
            if (depth > 0) {
                return -1;
            }
            if (depth < 0) {
                return 1;
            }
            if (n1.isRoot()) {
                return 0;
            }
            return n1.getParentNode().getIndex(n1) - n2.getParentNode().getIndex(n2);
        }
    }

    static class NodeRefreshValue {
        final ModeController controller;
        Object oldValue;
        Object newValue;

        public NodeRefreshValue(ModeController controller, Object oldValue, Object newValue) {
            this.controller = controller;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }

    static class NodeRefreshKey {
        final NodeModel node;
        final Object property;

        public NodeRefreshKey(NodeModel node, Object property) {
            this.node = node;
            this.property = property;
        }

        public int hashCode() {
            return this.node.hashCode() + this.propertyHash();
        }

        protected int propertyHash() {
            return this.property != null ? 37 * this.property.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            NodeRefreshKey key2 = (NodeRefreshKey)obj;
            return this.node.equals(key2.node) && (this.property == key2.property || this.property != null && this.property.equals(key2.property));
        }
    }

    public static enum Direction {
        BACK,
        BACK_N_FOLD,
        BACK_VISIBLE,
        BACK_REMOVE_FILTER,
        FORWARD,
        FORWARD_N_FOLD,
        FORWARD_VISIBLE,
        FORWARD_REMOVE_FILTER;


        public boolean isForward() {
            return this.ordinal() >= FORWARD.ordinal();
        }

        public boolean canUnfold() {
            return this != BACK_VISIBLE && this != FORWARD_VISIBLE;
        }

        public boolean removesFilter() {
            return this == BACK_REMOVE_FILTER || this == FORWARD_REMOVE_FILTER;
        }
    }
}

