'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const htmlEscapes = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#39;',
};
function escape(str) {
    return str.replace(/[&<>"']/g, match => htmlEscapes[match]);
}

exports.escape = escape;
