#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-D2hCqriZPbQIpGQN4WLWjs
key:                  gitit-0.15.1.2-D2hCqriZPbQIpGQN4WLWjs
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  e3de351221c5b3a94135a961b258cec5
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-D2hCqriZPbQIpGQN4WLWjs
depends:
    HStringTemplate-0.8.8-3bOksBklQak2xsn0gNfX5m
    HTTP-4000.4.1-Jrt54KhoQpbANaTbXKQmev
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G
    blaze-html-0.9.2.0-LUjYdeknUl1Ef7LhdtXXgs bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-4Oihfq7nLExBE82fNODnxN
    feed-1.3.2.1-C0zuXv9loGJLY8OM1SUIrK filepath-1.4.300.1
    filestore-0.6.5.1-Gf0IpmG6QIkBZPRkA0z7ux ghc-9.6.6
    ghc-paths-0.1.0.12-JSGGj7CcxjZ2Iy0LlOG5cZ
    happstack-server-7.9.3-2hgXdy7NErLElgvi7qEjXt
    hoauth2-2.14.0-2OqCXHfnxgzDvO3VEH481w
    hslogger-1.3.2.0-8na4OJTpcaTE1sntXXtv2J
    http-client-tls-0.3.6.4-JIwEy8eUUufD8fETx9XfAs
    http-conduit-2.3.9.1-7ahJY63SDSHLtE0Wi5iEVy
    json-0.10-9brdcdxWRzrFsg3sW0d3xW mtl-2.3.1
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    network-bsd-2.8.1.0-2FRtrywvz2KB3NVtr6LNTj
    network-uri-2.6.4.2-4GU1spYfCy5EsCjKjgc97p
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx
    pandoc-3.4-8crF8V9foAeAZlGYbkGt7Y
    pandoc-types-1.23.1-ExyetKadj41IRCG9E6pUvm parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-AnjXBTm5XaC2u12cWBrzsX
    recaptcha-0.1.0.4-JBjOzwziSIs3MAwXUzl5wg
    safe-0.3.21-EsRFO8M87PCEtDqVSuBNfo
    skylighting-0.14.3-8pv6NyUYkE84Mp4kiQeoYu
    split-0.2.5-LIo01L9HFTI75RwsLzYVkn syb-0.7.3-7GPFF4ffw0kLXaCjDkD2wt
    tagsoup-0.14.8-C5zdnVYyiZc2uQ23ongVC7
    temporary-1.3-D64vl65CCuJL1VfIJwvdvy text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-H7vpfTvP4nCBzPTh68f7gP
    url-2.1.3-7Kl4E3eXP9D927NfHGnLmQ
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1
    uuid-1.3.16-EyOlyIAMrlEEEVOkbbuSDJ xhtml-3000.2.2.1
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-GIDamUBLjrqAkx7UMSJfmz
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau
    xss-sanitize-0.3.7.2-AzBT12BCVpBFokNoi3Qok9
    zlib-0.7.0.0-1ujaGtF2c5l6Jpv01tSCEr

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

