# frozen_string_literal: true

class AddAiDetectionFieldsToVulnerabilityFlags < Gitlab::Database::Migration[2.3]
  milestone '18.5'

  TABLE = :vulnerability_flags

  def up
    add_column TABLE, :confidence_score, :float, default: 0.0, null: false
    add_column TABLE, :workflow_id, :bigint, null: true
    add_column TABLE, :status, :integer, limit: 2, default: 0, null: false
  end

  def down
    remove_column TABLE, :status
    remove_column TABLE, :workflow_id
    remove_column TABLE, :confidence_score
  end
end
