import { useRef, useEffect, useMemo } from 'react';

function useLatestCallback(callback) {
  const ref = useRef(callback);
  useEffect(() => {
    ref.current = callback;
  });
  const hasCallback = Boolean(callback);
  return useMemo(
    () => hasCallback ? (...args) => ref.current(...args) : undefined,
    [hasCallback]
  );
}

export { useLatestCallback };
//# sourceMappingURL=useLatestCallback.js.map
