/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.colors.ColorId;
import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.frontend.SwitcherListItem;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\u0005\u0010\rBw\b\u0012\u0012\u0006\u0010\u000e\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u0012\b\u0010\u0019\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u001a\u001a\u00020\u0014\u0012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\b\u0005\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u00102\u001a\u0004\u0018\u00010\u00172\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0014H\u0016J\u0013\u0010:\u001a\u00020\u00142\b\u0010;\u001a\u0004\u0018\u00010<H\u0096\u0002J\b\u0010=\u001a\u000204H\u0016R\u0019\u0010\u000e\u001a\u00070\n\u00a2\u0006\u0002\b\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0019\u0010\u000f\u001a\u00070\n\u00a2\u0006\u0002\b\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u0019\u0010\u0010\u001a\u00070\n\u00a2\u0006\u0002\b\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u001b\u0010\u0011\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u001b\u0010\u0012\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010'R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006>"}, d2={"Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherListItem;", "Lcom/intellij/ui/BackgroundSupplier;", "rpcModel", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;", "<init>", "(Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;)V", "localFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "", "localIcon", "Ljavax/swing/Icon;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljavax/swing/Icon;)V", "mainText", "statusText", "pathText", "mnemonic", "shortcutText", "separatorAbove", "", "virtualFile", "backgroundColor", "Ljava/awt/Color;", "foregroundTextColor", "icon", "hasProblems", "editorWindow", "Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/intellij/openapi/vfs/VirtualFile;Ljava/awt/Color;Ljava/awt/Color;Ljavax/swing/Icon;ZLcom/intellij/openapi/fileEditor/impl/EditorWindow;)V", "withAssociatedEditorWindow", "Lcom/intellij/openapi/util/NlsSafe;", "getMainText", "()Ljava/lang/String;", "getStatusText", "getPathText", "getMnemonic", "getShortcutText", "getSeparatorAbove", "()Z", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getBackgroundColor", "()Ljava/awt/Color;", "getForegroundTextColor", "getIcon", "()Ljavax/swing/Icon;", "getHasProblems", "getEditorWindow", "()Lcom/intellij/openapi/fileEditor/impl/EditorWindow;", "getElementBackground", "row", "", "prepareMainRenderer", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "equals", "other", "", "hashCode", "intellij.platform.recentFiles.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSwitcherRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherRendering.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
public final class SwitcherVirtualFile
implements SwitcherListItem,
BackgroundSupplier {
    @NotNull
    private final String mainText;
    @NotNull
    private final String statusText;
    @NotNull
    private final String pathText;
    @Nullable
    private final String mnemonic;
    @Nullable
    private final String shortcutText;
    private final boolean separatorAbove;
    @Nullable
    private final VirtualFile virtualFile;
    @Nullable
    private final Color backgroundColor;
    @Nullable
    private final Color foregroundTextColor;
    @Nullable
    private final Icon icon;
    private final boolean hasProblems;
    @Nullable
    private final EditorWindow editorWindow;

    public SwitcherVirtualFile(@NotNull SwitcherRpcDto.File rpcModel) {
        Intrinsics.checkNotNullParameter((Object)rpcModel, (String)"rpcModel");
        this.mainText = rpcModel.getMainText();
        this.statusText = rpcModel.getStatusText();
        this.pathText = rpcModel.getPathText();
        this.mnemonic = null;
        this.shortcutText = null;
        this.separatorAbove = false;
        this.virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)rpcModel.getVirtualFileId());
        ColorId colorId = rpcModel.getBackgroundColorId();
        this.backgroundColor = colorId != null ? ColorIdKt.color((ColorId)colorId) : null;
        ColorId colorId2 = rpcModel.getForegroundTextColorId();
        this.foregroundTextColor = colorId2 != null ? ColorIdKt.color((ColorId)colorId2) : null;
        this.icon = IconIdKt.icon((IconId)rpcModel.getIconId());
        this.hasProblems = rpcModel.getHasProblems();
        this.editorWindow = null;
    }

    public SwitcherVirtualFile(@NotNull VirtualFile localFile, @NotNull String fileName, @NotNull Icon localIcon) {
        Intrinsics.checkNotNullParameter((Object)localFile, (String)"localFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)localIcon, (String)"localIcon");
        this.mainText = fileName;
        this.statusText = "";
        this.pathText = "";
        this.mnemonic = null;
        this.shortcutText = null;
        this.separatorAbove = false;
        this.virtualFile = localFile;
        this.backgroundColor = null;
        this.foregroundTextColor = null;
        this.icon = localIcon;
        this.hasProblems = false;
        this.editorWindow = null;
    }

    private SwitcherVirtualFile(String mainText, String statusText, String pathText, String mnemonic, String shortcutText, boolean separatorAbove, VirtualFile virtualFile, Color backgroundColor, Color foregroundTextColor, Icon icon, boolean hasProblems, EditorWindow editorWindow) {
        this.mainText = mainText;
        this.statusText = statusText;
        this.pathText = pathText;
        this.mnemonic = mnemonic;
        this.shortcutText = shortcutText;
        this.separatorAbove = separatorAbove;
        this.virtualFile = virtualFile;
        this.backgroundColor = backgroundColor;
        this.foregroundTextColor = foregroundTextColor;
        this.icon = icon;
        this.hasProblems = hasProblems;
        this.editorWindow = editorWindow;
    }

    @NotNull
    public final SwitcherVirtualFile withAssociatedEditorWindow(@NotNull EditorWindow editorWindow) {
        Intrinsics.checkNotNullParameter((Object)editorWindow, (String)"editorWindow");
        return new SwitcherVirtualFile(this.getMainText(), this.getStatusText(), this.getPathText(), this.getMnemonic(), this.getShortcutText(), this.getSeparatorAbove(), this.virtualFile, this.backgroundColor, this.foregroundTextColor, this.icon, this.hasProblems, editorWindow);
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.mainText;
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    @NotNull
    public String getPathText() {
        return this.pathText;
    }

    @Override
    @Nullable
    public String getMnemonic() {
        return this.mnemonic;
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return this.shortcutText;
    }

    @Override
    public boolean getSeparatorAbove() {
        return this.separatorAbove;
    }

    @Nullable
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Nullable
    public final Color getForegroundTextColor() {
        return this.foregroundTextColor;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean getHasProblems() {
        return this.hasProblems;
    }

    @Nullable
    public final EditorWindow getEditorWindow() {
        return this.editorWindow;
    }

    @Nullable
    public Color getElementBackground(int row) {
        return this.backgroundColor;
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component, boolean selected) {
        block7: {
            int n;
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIconTextGap(JBUI.scale((int)4));
            if (Registry.Companion.is("ide.project.view.change.icon.on.selection", true)) {
                icon = RenderingUtil.getIcon((Icon)this.icon, (boolean)selected);
            } else {
                icon = this.icon;
                if (icon == null) {
                    Icon icon2 = AllIcons.Nodes.EmptyNode;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EmptyNode");
                }
            }
            component.setIcon(icon);
            Color foreground = selected ? null : this.foregroundTextColor;
            JBColor effectColor = this.hasProblems ? JBColor.red : null;
            int style = effectColor == null ? 0 : 8;
            component.append(this.getMainText(), new SimpleTextAttributes(style, foreground, (Color)effectColor));
            Font font = component.getFont();
            if (font == null) break block7;
            Font it = font;
            boolean bl = false;
            FontMetrics fontMetrics = component.getFontMetrics(it);
            int mainTextWidth = UIUtil.computeStringWidth((JComponent)((JComponent)component), (FontMetrics)fontMetrics, (String)this.getMainText());
            String string = this.getShortcutText();
            if (string != null) {
                String shortcut = string;
                boolean bl2 = false;
                n = UIUtil.computeStringWidth((JComponent)((JComponent)component), (FontMetrics)fontMetrics, (String)shortcut);
            } else {
                n = 0;
            }
            int shortcutTextWidth = n;
            Icon icon3 = component.getIcon();
            int iconWidth = icon3 != null ? icon3.getIconWidth() : AllIcons.FileTypes.Text.getIconWidth();
            int width = component.getWidth() - mainTextWidth - shortcutTextWidth - component.getIconTextGap() - iconWidth - component.getInsets().left - component.getInsets().right;
            if (width > 0) {
                String string2 = PaintUtil.cutContainerText((String)(" " + this.getPathText()), (int)width, (JComponent)((JComponent)component));
                if (string2 != null) {
                    String fragment = string2;
                    boolean bl3 = false;
                    component.append(fragment, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwitcherVirtualFile)) {
            return false;
        }
        return this.virtualFile != null && Intrinsics.areEqual((Object)this.virtualFile, (Object)((SwitcherVirtualFile)other).virtualFile) && Intrinsics.areEqual((Object)this.editorWindow, (Object)((SwitcherVirtualFile)other).editorWindow);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.virtualFile, this.editorWindow};
        return Objects.hash(objectArray);
    }
}

