/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.event.AudioDeviceEvent;
import org.jsampler.event.AudioDeviceListener;
import org.jsampler.event.ParameterEvent;
import org.jsampler.event.ParameterListener;
import org.jsampler.task.Audio;
import org.jsampler.view.ParameterTable;
import org.jsampler.view.fantasia.DevicePane;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.linuxsampler.lscp.AudioOutputChannel;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.Parameter;

public class AudioDevicePane
extends DevicePane {
    private final OptionsPane optionsPane;
    private final ParameterTable channelParamTable = new ParameterTable();
    private final AudioDeviceModel audioDeviceModel;

    public AudioDevicePane(AudioDeviceModel audioDeviceModel) {
        this.audioDeviceModel = audioDeviceModel;
        this.channelParamTable.setFillsViewportHeight(true);
        this.optionsPane = new OptionsPane();
        this.setOptionsPane(this.optionsPane);
        int n = audioDeviceModel.getDeviceId();
        String string = audioDeviceModel.getDeviceInfo().getDriverName();
        this.setDeviceName(FantasiaI18n.i18n.getLabel("AudioDevicePane.lDevName", n, string));
    }

    @Override
    protected void destroyDevice() {
        final Audio.DestroyDevice destroyDevice = new Audio.DestroyDevice(this.getDeviceId());
        destroyDevice.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (destroyDevice.doneWithErrors()) {
                    AudioDevicePane.this.restoreDevice();
                }
            }
        });
        CC.getTaskQueue().add(destroyDevice);
    }

    public int getDeviceId() {
        return this.audioDeviceModel.getDeviceId();
    }

    class OptionsPane
    extends PixmapPane
    implements ActionListener,
    ItemListener,
    ChangeListener,
    AudioDeviceListener,
    ParameterListener {
        private final JCheckBox checkActive;
        private final JLabel lChannels;
        private final JSpinner spinnerChannels;
        private final JLabel lChannel;
        private final JComboBox cbChannel;
        private final ParameterTable additionalParamsTable;
        private final JPanel additionalParamsPane;

        OptionsPane() {
            super(Res.gfxChannelOptions);
            this.checkActive = new JCheckBox(FantasiaI18n.i18n.getLabel("AudioDevicePane.checkActive"));
            this.lChannels = new JLabel(FantasiaI18n.i18n.getLabel("AudioDevicePane.lChannels"));
            this.lChannel = new JLabel(FantasiaI18n.i18n.getLabel("AudioDevicePane.lChannel"));
            this.cbChannel = new JComboBox();
            this.additionalParamsTable = new ParameterTable();
            this.additionalParamsPane = new JPanel();
            this.setAlignmentX(0.0f);
            this.setPixmapInsets(new Insets(1, 1, 1, 1));
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setOpaque(false);
            PixmapPane pixmapPane = new PixmapPane(Res.gfxRoundBg7);
            pixmapPane.setPixmapInsets(new Insets(3, 3, 3, 3));
            pixmapPane.setOpaque(false);
            pixmapPane.setLayout(new BoxLayout(pixmapPane, 1));
            pixmapPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pixmapPane.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.checkActive);
            jPanel.add(Box.createRigidArea(new Dimension(12, 0)));
            jPanel.add(this.lChannels);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            Parameter<Integer> parameter = AudioDevicePane.this.audioDeviceModel.getDeviceInfo().getChannelsParameter();
            int n = 1;
            if (parameter.getRangeMin() != null) {
                n = parameter.getRangeMin().intValue();
            }
            int n2 = 10000;
            if (parameter.getRangeMax() != null) {
                n2 = parameter.getRangeMax().intValue();
            }
            this.spinnerChannels = new JSpinner(new SpinnerNumberModel(1, n, n2, 1));
            if (parameter.isFixed()) {
                this.spinnerChannels.setEnabled(false);
            }
            int n3 = this.spinnerChannels.getPreferredSize().height;
            this.spinnerChannels.setPreferredSize(new Dimension(30, n3));
            jPanel.add(this.spinnerChannels);
            jPanel.setOpaque(false);
            pixmapPane.add(jPanel);
            pixmapPane.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel jPanel2 = this.additionalParamsPane;
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.setOpaque(false);
            jPanel2.add(AudioDevicePane.this.createHSeparator());
            jPanel2.add(Box.createRigidArea(new Dimension(0, 5)));
            JScrollPane jScrollPane = new JScrollPane(this.additionalParamsTable);
            jScrollPane.setPreferredSize(new Dimension(77, 90));
            jPanel2.add(jScrollPane);
            pixmapPane.add(jPanel2);
            pixmapPane.add(Box.createRigidArea(new Dimension(0, 5)));
            pixmapPane.add(AudioDevicePane.this.createHSeparator());
            pixmapPane.add(Box.createRigidArea(new Dimension(0, 5)));
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setOpaque(false);
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(this.lChannel);
            jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel2.add(this.cbChannel);
            jPanel2.setOpaque(false);
            jPanel.add(jPanel2);
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            jScrollPane = new JScrollPane(AudioDevicePane.this.channelParamTable);
            jScrollPane.setPreferredSize(new Dimension(77, 90));
            jPanel.add(jScrollPane);
            pixmapPane.add(jPanel);
            this.add(pixmapPane);
            this.checkActive.setSelected(AudioDevicePane.this.audioDeviceModel.isActive());
            this.spinnerChannels.setValue(AudioDevicePane.this.audioDeviceModel.getDeviceInfo().getChannelCount());
            this.cbChannel.addActionListener(this);
            this.checkActive.addItemListener(this);
            this.spinnerChannels.addChangeListener(this);
            AudioDevicePane.this.audioDeviceModel.addAudioDeviceListener(this);
            AudioDevicePane.this.channelParamTable.getModel().addParameterListener(this);
            AudioDeviceModel audioDeviceModel = AudioDevicePane.this.audioDeviceModel;
            for (AudioOutputChannel audioOutputChannel : audioDeviceModel.getDeviceInfo().getAudioChannels()) {
                this.cbChannel.addItem(audioOutputChannel);
            }
            this.updateParams(AudioDevicePane.this.audioDeviceModel.getDeviceInfo());
            this.additionalParamsTable.getModel().addParameterListener(new ParameterListener(){

                @Override
                public void parameterChanged(ParameterEvent parameterEvent) {
                    AudioDevicePane.this.audioDeviceModel.setBackendDeviceParameter(parameterEvent.getParameter());
                }
            });
            this.updateAdditionalParamsViewState();
            String string = "AudioDevice.showAdditionalParameters";
            FantasiaPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    OptionsPane.this.updateAdditionalParamsViewState();
                }
            });
        }

        private void updateAdditionalParamsViewState() {
            String string = "AudioDevice.showAdditionalParameters";
            this.additionalParamsPane.setVisible(FantasiaPrefs.preferences().getBoolProperty(string));
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.cbChannel.getSelectedItem();
            if (object == null) {
                AudioDevicePane.this.channelParamTable.getModel().setParameters(new Parameter[0]);
                return;
            }
            AudioOutputChannel audioOutputChannel = (AudioOutputChannel)object;
            AudioDevicePane.this.channelParamTable.getModel().setParameters(audioOutputChannel.getAllParameters());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = this.checkActive.isSelected();
            if (bl != AudioDevicePane.this.audioDeviceModel.isActive()) {
                AudioDevicePane.this.audioDeviceModel.setBackendActive(bl);
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = (Integer)this.spinnerChannels.getValue();
            if (n != AudioDevicePane.this.audioDeviceModel.getDeviceInfo().getAudioChannelCount()) {
                AudioDevicePane.this.audioDeviceModel.setBackendChannelCount(n);
            }
        }

        @Override
        public void settingsChanged(AudioDeviceEvent audioDeviceEvent) {
            boolean bl;
            boolean bl2;
            int n;
            int n2 = (Integer)this.spinnerChannels.getValue();
            if (n2 != (n = AudioDevicePane.this.audioDeviceModel.getDeviceInfo().getAudioChannelCount())) {
                this.spinnerChannels.setValue(n);
            }
            if ((bl2 = this.checkActive.isSelected()) != (bl = AudioDevicePane.this.audioDeviceModel.isActive())) {
                this.checkActive.setSelected(bl);
            }
            AudioOutputDevice audioOutputDevice = audioDeviceEvent.getAudioDeviceModel().getDeviceInfo();
            this.updateParams(audioOutputDevice);
            int n3 = this.cbChannel.getSelectedIndex();
            this.cbChannel.removeAllItems();
            for (AudioOutputChannel audioOutputChannel : audioOutputDevice.getAudioChannels()) {
                this.cbChannel.addItem(audioOutputChannel);
            }
            if (n3 >= this.cbChannel.getModel().getSize()) {
                n3 = 0;
            }
            if (this.cbChannel.getModel().getSize() > 0) {
                this.cbChannel.setSelectedIndex(n3);
            }
        }

        @Override
        public void parameterChanged(ParameterEvent parameterEvent) {
            int n = this.cbChannel.getSelectedIndex();
            if (n == -1) {
                CC.getLogger().warning("There is no audio channel selected!");
                return;
            }
            AudioDevicePane.this.audioDeviceModel.setBackendChannelParameter(n, parameterEvent.getParameter());
        }

        private void updateParams(AudioOutputDevice audioOutputDevice) {
            Parameter<Integer> parameter = audioOutputDevice.getSampleRateParameter();
            boolean bl = parameter == null || parameter.getName() == null || parameter.getValue() == null;
            Parameter[] parameterArray = audioOutputDevice.getAdditionalParameters();
            Parameter[] parameterArray2 = bl ? new Parameter[parameterArray.length] : new Parameter[parameterArray.length + 1];
            for (int i = 0; i < parameterArray.length; ++i) {
                parameterArray2[i] = parameterArray[i];
            }
            if (!bl) {
                parameterArray2[parameterArray.length] = parameter;
            }
            this.additionalParamsTable.getModel().setParameters(parameterArray2);
        }
    }
}

