/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractSimpleLimitHandler;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class LimitOffsetLimitHandler
extends AbstractSimpleLimitHandler {
    public static LimitOffsetLimitHandler INSTANCE = new LimitOffsetLimitHandler();
    public static LimitOffsetLimitHandler OFFSET_ONLY_INSTANCE = new LimitOffsetLimitHandler(){

        @Override
        protected String offsetOnlyClause() {
            return " offset ?";
        }

        @Override
        protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
            return " offset " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
        }
    };

    @Override
    protected String limitClause(boolean hasFirstRow) {
        return hasFirstRow ? " limit ? offset ?" : " limit ?";
    }

    @Override
    protected String limitClause(boolean hasFirstRow, int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        String firstParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
        if (hasFirstRow) {
            return " limit " + firstParameter + " offset " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
        }
        return " limit " + firstParameter;
    }

    @Override
    protected String offsetOnlyClause() {
        return " limit 2147483647 offset ?";
    }

    @Override
    protected String offsetOnlyClause(int jdbcParameterCount, ParameterMarkerStrategy parameterMarkerStrategy) {
        return " limit 2147483647 offset " + parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
    }

    @Override
    public final boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean processSqlMutatesState() {
        return false;
    }
}

