/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.common;

import org.hibernate.dialect.Dialect;
import org.hibernate.query.SemanticException;

public enum TemporalUnit {
    YEAR,
    QUARTER,
    MONTH,
    WEEK,
    DAY,
    HOUR,
    MINUTE,
    SECOND,
    NANOSECOND,
    DAY_OF_WEEK,
    DAY_OF_YEAR,
    DAY_OF_MONTH,
    WEEK_OF_MONTH,
    WEEK_OF_YEAR,
    OFFSET,
    TIMEZONE_HOUR,
    TIMEZONE_MINUTE,
    DATE,
    TIME,
    EPOCH,
    NATIVE;


    public String conversionFactor(TemporalUnit unit, Dialect dialect) {
        long to;
        if (unit == this) {
            return "";
        }
        if (unit.normalized() != this.normalized()) {
            throw new SemanticException("Illegal unit conversion " + String.valueOf((Object)this) + " to " + String.valueOf((Object)unit));
        }
        long from = this.normalizationFactor(dialect);
        if (from == (to = unit.normalizationFactor(dialect))) {
            return "";
        }
        return (from < to ? "/" : "*") + TemporalUnit.factorAsString(from < to ? to / from : from / to);
    }

    public String conversionFactorFull(TemporalUnit unit, Dialect dialect) {
        long to;
        if (unit == this) {
            return "";
        }
        if (unit.normalized() != this.normalized()) {
            throw new SemanticException("Illegal unit conversion " + String.valueOf((Object)this) + " to " + String.valueOf((Object)unit));
        }
        long from = this.normalizationFactor(dialect);
        if (from == (to = unit.normalizationFactor(dialect))) {
            return "";
        }
        return (from < to ? "/" : "*") + (from < to ? to / from : from / to);
    }

    private long normalizationFactor(Dialect dialect) {
        long factor = 1L;
        switch (this.ordinal()) {
            case 0: {
                factor *= 4L;
            }
            case 1: {
                factor *= 3L;
            }
            case 2: {
                break;
            }
            case 3: {
                factor *= 7L;
            }
            case 4: {
                factor *= 24L;
            }
            case 5: {
                factor *= 60L;
            }
            case 6: {
                factor *= 60L;
            }
            case 7: 
            case 19: {
                factor *= 1000000000L;
            }
            case 8: {
                break;
            }
            case 20: {
                factor *= dialect.getFractionalSecondPrecisionInNanos();
                break;
            }
            default: {
                throw new SemanticException("Inconvertible unit " + String.valueOf((Object)this));
            }
        }
        return factor;
    }

    private static String factorAsString(long factor) {
        int len;
        int chop;
        Object string = String.valueOf(factor);
        for (chop = len = ((String)string).length(); chop > 0 && ((String)string).charAt(chop - 1) == '0'; --chop) {
        }
        int e = len - chop;
        if (chop > 0 && e > 2) {
            string = ((String)string).substring(0, chop) + "e" + e;
        }
        return string;
    }

    public boolean isDateUnit() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public boolean isTimeUnit() {
        switch (this.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 16: 
            case 20: {
                return true;
            }
        }
        return false;
    }

    public TemporalUnit normalized() {
        switch (this.ordinal()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 19: 
            case 20: {
                return NANOSECOND;
            }
            case 0: 
            case 1: 
            case 2: {
                return MONTH;
            }
        }
        throw new SemanticException("Illegal unit " + String.valueOf((Object)this));
    }

    public String toString() {
        return super.toString().toLowerCase();
    }
}

