/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.component;

import com.fasterxml.jackson.databind.JsonNode;
import org.keycloak.component.ComponentModel;
import org.keycloak.provider.Provider;

public class JsonConfigComponentModel
extends ComponentModel {
    private final String providerType;
    private final String providerId;
    private final String componentId;
    private final JsonNode configNode;

    public JsonConfigComponentModel(Class<? extends Provider> providerType, String realmId, String providerId, JsonNode configNode) {
        this.checkNotNull(providerType, "providerType must be not null");
        this.checkNotNull(realmId, "realmId must be not null");
        this.checkNotNull(providerId, "providerId must be not null");
        this.checkNotNull(configNode, "configNode must be not null for provider " + providerId);
        this.providerType = providerType.getName();
        this.providerId = providerId;
        this.configNode = configNode;
        this.componentId = realmId + "::" + String.valueOf(providerType) + "::" + this.providerId + "::" + configNode.hashCode();
    }

    private void checkNotNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public String getProviderType() {
        return this.providerType;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public String getName() {
        return this.componentId + "-config";
    }

    @Override
    public String getId() {
        return this.componentId;
    }

    @Override
    public boolean get(String key, boolean defaultValue) {
        JsonNode sub = this.configNode.get(key);
        return sub == null ? defaultValue : sub.asBoolean();
    }

    @Override
    public long get(String key, long defaultValue) {
        JsonNode sub = this.configNode.get(key);
        return sub == null ? defaultValue : sub.asLong();
    }

    @Override
    public int get(String key, int defaultValue) {
        JsonNode sub = this.configNode.get(key);
        return sub == null ? defaultValue : sub.asInt();
    }

    @Override
    public String get(String key, String defaultValue) {
        JsonNode sub = this.configNode.get(key);
        return sub == null ? defaultValue : sub.asText();
    }

    @Override
    public String get(String key) {
        return this.get(key, null);
    }
}

