/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import jakarta.ws.rs.ForbiddenException;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.services.resources.admin.AdminAuth;

class RealmAuth {
    private AdminAuth.Resource resource;
    private AdminAuth auth;
    private ClientModel realmAdminApp;

    public RealmAuth(AdminAuth auth, ClientModel realmAdminApp) {
        this.auth = auth;
        this.realmAdminApp = realmAdminApp;
    }

    public RealmAuth init(AdminAuth.Resource resource) {
        this.resource = resource;
        return this;
    }

    public AdminAuth getAuth() {
        return this.auth;
    }

    public void requireAny() {
        if (!this.hasAny()) {
            throw new ForbiddenException();
        }
    }

    public boolean hasAny() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, AdminRoles.ALL_REALM_ROLES);
    }

    public boolean hasView() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, this.getViewRole(this.resource), this.getManageRole(this.resource));
    }

    public boolean hasManage() {
        return this.auth.hasOneOfAppRole(this.realmAdminApp, this.getManageRole(this.resource));
    }

    public void requireView() {
        if (!this.hasView()) {
            throw new ForbiddenException();
        }
    }

    public void requireManage() {
        if (!this.hasManage()) {
            throw new ForbiddenException();
        }
    }

    private String getViewRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return "view-clients";
            }
            case USER: {
                return "view-users";
            }
            case REALM: {
                return "view-realm";
            }
            case EVENTS: {
                return "view-events";
            }
            case IDENTITY_PROVIDER: {
                return "view-identity-providers";
            }
            case AUTHORIZATION: {
                return "view-authorization";
            }
        }
        throw new IllegalStateException();
    }

    private String getManageRole(AdminAuth.Resource resource) {
        switch (resource) {
            case CLIENT: {
                return "manage-clients";
            }
            case USER: {
                return "manage-users";
            }
            case REALM: {
                return "manage-realm";
            }
            case EVENTS: {
                return "manage-events";
            }
            case IDENTITY_PROVIDER: {
                return "manage-identity-providers";
            }
            case IMPERSONATION: {
                return "impersonation";
            }
            case AUTHORIZATION: {
                return "manage-authorization";
            }
        }
        throw new IllegalStateException();
    }
}

