/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractJWTClientValidator;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.http.HttpRequest;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.OIDCLoginProtocol;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.OIDCProviderConfig;
import org.keycloak.protocol.oidc.grants.ciba.CibaGrantType;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.services.Urls;

public class JWTClientValidator
extends AbstractJWTClientValidator {
    public JWTClientValidator(ClientAuthenticationFlowContext context, AbstractJWTClientValidator.SignatureValidator signatureValidator, String clientAuthenticatorProviderId) throws Exception {
        super(context, signatureValidator, clientAuthenticatorProviderId);
    }

    @Override
    protected String getExpectedTokenIssuer() {
        return this.clientAssertionState.getToken().getSubject();
    }

    @Override
    protected List<String> getExpectedAudiences() {
        String issuerUrl = Urls.realmIssuer(this.context.getUriInfo().getBaseUri(), this.realm.getName());
        String tokenUrl = OIDCLoginProtocolService.tokenUrl(this.context.getUriInfo().getBaseUriBuilder()).build(new Object[]{this.realm.getName()}).toString();
        String tokenIntrospectUrl = OIDCLoginProtocolService.tokenIntrospectionUrl(this.context.getUriInfo().getBaseUriBuilder()).build(new Object[]{this.realm.getName()}).toString();
        String parEndpointUrl = ParEndpoint.parUrl(this.context.getUriInfo().getBaseUriBuilder()).build(new Object[]{this.realm.getName()}).toString();
        ArrayList<String> expectedAudiences = new ArrayList<String>(Arrays.asList(issuerUrl, tokenUrl, tokenIntrospectUrl, parEndpointUrl));
        String backchannelAuthenticationUrl = CibaGrantType.authorizationUrl(this.context.getUriInfo().getBaseUriBuilder()).build(new Object[]{this.realm.getName()}).toString();
        expectedAudiences.add(backchannelAuthenticationUrl);
        return expectedAudiences;
    }

    @Override
    public boolean validate() {
        return this.clientAssertionParametersValidation() && super.validate();
    }

    @Override
    protected boolean isMultipleAudienceAllowed() {
        OIDCLoginProtocol loginProtocol = (OIDCLoginProtocol)this.context.getSession().getProvider(LoginProtocol.class, "openid-connect");
        OIDCProviderConfig config = loginProtocol.getConfig();
        return config.isAllowMultipleAudiencesForJwtClientAuthentication();
    }

    @Override
    protected int getAllowedClockSkew() {
        return 15;
    }

    @Override
    protected int getMaximumExpirationTime() {
        return OIDCAdvancedConfigWrapper.fromClientModel(this.client).getTokenEndpointAuthSigningMaxExp();
    }

    @Override
    protected boolean isReusePermitted() {
        return false;
    }

    @Override
    protected String getExpectedSignatureAlgorithm() {
        return OIDCAdvancedConfigWrapper.fromClientModel(this.client).getTokenEndpointAuthSigningAlg();
    }

    public boolean clientAssertionParametersValidation() {
        if (!this.isFormDataRequest(this.context.getHttpRequest())) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Parameter client_assertion_type is missing");
            this.context.challenge(challengeResponse);
            return false;
        }
        MultivaluedMap params = this.context.getHttpRequest().getDecodedFormParameters();
        String clientAssertionType = (String)params.getFirst((Object)"client_assertion_type");
        String clientAssertion = (String)params.getFirst((Object)"client_assertion");
        if (clientAssertionType == null) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Parameter client_assertion_type is missing");
            this.context.challenge(challengeResponse);
            return false;
        }
        if (!clientAssertionType.equals("urn:ietf:params:oauth:client-assertion-type:jwt-bearer")) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "Parameter client_assertion_type has value '" + clientAssertionType + "' but expected is 'urn:ietf:params:oauth:client-assertion-type:jwt-bearer'");
            this.context.challenge(challengeResponse);
            return false;
        }
        if (clientAssertion == null) {
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "invalid_client", "client_assertion parameter missing");
            this.context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
            return false;
        }
        return true;
    }

    private boolean isFormDataRequest(HttpRequest request) {
        MediaType mediaType = request.getHttpHeaders().getMediaType();
        return mediaType != null && mediaType.isCompatible(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }
}

