/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.scripting;

import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jboss.logging.Logger;
import org.keycloak.models.ScriptModel;
import org.keycloak.scripting.AbstractEvaluatableScriptAdapter;
import org.keycloak.scripting.CompiledEvaluatableScriptAdapter;
import org.keycloak.scripting.DefaultScriptingProviderFactory;
import org.keycloak.scripting.InvocableScriptAdapter;
import org.keycloak.scripting.Script;
import org.keycloak.scripting.ScriptBindingsConfigurer;
import org.keycloak.scripting.ScriptCompilationException;
import org.keycloak.scripting.ScriptingProvider;
import org.keycloak.scripting.UncompiledEvaluatableScriptAdapter;
import org.keycloak.services.ServicesLogger;

public class DefaultScriptingProvider
implements ScriptingProvider {
    private static final Logger logger = Logger.getLogger(DefaultScriptingProvider.class);
    private final DefaultScriptingProviderFactory factory;

    DefaultScriptingProvider(DefaultScriptingProviderFactory factory) {
        this.factory = factory;
    }

    public InvocableScriptAdapter prepareInvocableScript(ScriptModel scriptModel, ScriptBindingsConfigurer bindingsConfigurer) {
        AbstractEvaluatableScriptAdapter evaluatable = this.prepareEvaluatableScript(scriptModel);
        return evaluatable.prepareInvokableScript(bindingsConfigurer);
    }

    public AbstractEvaluatableScriptAdapter prepareEvaluatableScript(ScriptModel scriptModel) {
        if (scriptModel == null) {
            throw new IllegalArgumentException("script must not be null");
        }
        if (scriptModel.getCode() == null || scriptModel.getCode().trim().isEmpty()) {
            throw new IllegalArgumentException("script must not be null or empty");
        }
        ScriptEngine engine = this.getPreparedScriptEngine(scriptModel);
        if (engine instanceof Compilable) {
            return new CompiledEvaluatableScriptAdapter(scriptModel, this.tryCompile(scriptModel, (Compilable)((Object)engine)));
        }
        return new UncompiledEvaluatableScriptAdapter(scriptModel, engine);
    }

    private CompiledScript tryCompile(ScriptModel scriptModel, Compilable engine) {
        try {
            return engine.compile(scriptModel.getCode());
        }
        catch (ScriptException e) {
            throw new ScriptCompilationException(scriptModel, (Exception)e);
        }
    }

    public ScriptModel createScript(String realmId, String mimeType, String scriptName, String scriptCode, String scriptDescription) {
        return new Script(null, realmId, scriptName, mimeType, scriptCode, scriptDescription);
    }

    public void close() {
    }

    private ScriptEngine getPreparedScriptEngine(ScriptModel script) {
        ScriptEngine scriptEngine;
        if (this.factory.isEnableScriptEngineCache() && (scriptEngine = this.factory.getScriptEngineCache().get(script.getMimeType())) != null) {
            return scriptEngine;
        }
        scriptEngine = this.lookupScriptEngineFor(script);
        if (scriptEngine == null) {
            throw new IllegalStateException("Could not find ScriptEngine for script: " + String.valueOf(script));
        }
        ServicesLogger.LOGGER.scriptEngineCreated(scriptEngine.getFactory().getEngineName(), scriptEngine.getFactory().getEngineVersion(), script.getMimeType());
        if (this.factory.isEnableScriptEngineCache()) {
            this.factory.getScriptEngineCache().put(script.getMimeType(), scriptEngine);
        }
        return scriptEngine;
    }

    private ScriptEngine lookupScriptEngineFor(ScriptModel script) {
        return new ScriptEngineManager().getEngineByMimeType(script.getMimeType());
    }
}

