/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;

public class NotificationInterceptor
extends DDAsyncInterceptor {
    @Inject
    CacheNotifier notifier;
    private final InvocationSuccessFunction<VisitableCommand> commitSuccessAction = new InvocationSuccessFunction<VisitableCommand>(){

        @Override
        public Object apply(InvocationContext rCtx, VisitableCommand rCommand, Object rv) throws Throwable {
            return BaseAsyncInterceptor.delayedValue(NotificationInterceptor.this.notifier.notifyTransactionCompleted(((TxInvocationContext)rCtx).getGlobalTransaction(), true, rCtx), rv);
        }
    };
    private final InvocationSuccessFunction<RollbackCommand> rollbackSuccessAction = new InvocationSuccessFunction<RollbackCommand>(){

        @Override
        public Object apply(InvocationContext rCtx, RollbackCommand rCommand, Object rv) throws Throwable {
            return BaseAsyncInterceptor.delayedValue(NotificationInterceptor.this.notifier.notifyTransactionCompleted(((TxInvocationContext)rCtx).getGlobalTransaction(), false, rCtx), rv);
        }
    };

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!command.isOnePhaseCommit() || !this.notifier.hasListener(TransactionCompleted.class)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.commitSuccessAction);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.notifier.hasListener(TransactionCompleted.class)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.commitSuccessAction);
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.notifier.hasListener(TransactionCompleted.class)) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.rollbackSuccessAction);
    }
}

