/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.ImmutablePseudoClassSetsCache;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.SimpleSelector;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.css.Selector;
import javafx.geometry.NodeOrientation;

public final class Match
implements Comparable<Match> {
    private final Selector selector;
    private final Set<PseudoClass> pseudoClasses;
    private final int styleClassCount;
    private final int idCount;
    private final int specificity;

    static Match of(Selector selector) {
        Selector selector2 = selector;
        Objects.requireNonNull(selector2);
        Selector selector3 = selector2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleSelector.class, CompoundSelector.class}, (Object)selector3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SimpleSelector var3_3 = (SimpleSelector)selector3;
                yield Match.ofSimpleSelector(var3_3);
            }
            case 1 -> {
                CompoundSelector var4_4 = (CompoundSelector)selector3;
                yield Match.ofCompoundSelector(var4_4);
            }
        };
    }

    private static Match ofCompoundSelector(CompoundSelector compoundSelector) {
        PseudoClassState pseudoClassState = new PseudoClassState();
        int n = 0;
        int n2 = 0;
        List<SimpleSelector> list = compoundSelector.getSelectors();
        int n3 = list.size();
        for (int i = 0; i < n3; ++i) {
            Match match = Match.ofSimpleSelector(list.get(i));
            pseudoClassState.addAll(match.getPseudoClasses());
            n += match.idCount;
            n2 += match.styleClassCount;
        }
        return new Match(compoundSelector, pseudoClassState, n, n2);
    }

    private static Match ofSimpleSelector(SimpleSelector simpleSelector) {
        int n = simpleSelector.getId().isEmpty() ? 0 : 1;
        int n2 = simpleSelector.getStyleClassSet().size();
        return new Match(simpleSelector, simpleSelector.getPseudoClassStates(), n, n2);
    }

    Match(Selector selector, Set<PseudoClass> set, int n, int n2) {
        SimpleSelector simpleSelector;
        Objects.requireNonNull(selector);
        Objects.requireNonNull(set);
        this.selector = selector;
        this.idCount = n;
        this.styleClassCount = n2;
        this.pseudoClasses = ImmutablePseudoClassSetsCache.of(set);
        int n3 = set.size();
        if (selector instanceof SimpleSelector && (simpleSelector = (SimpleSelector)selector).getNodeOrientation() != NodeOrientation.INHERIT) {
            ++n3;
        }
        this.specificity = n << 8 | n2 << 4 | n3;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public Set<PseudoClass> getPseudoClasses() {
        return this.pseudoClasses;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    @Override
    public int compareTo(Match match) {
        return this.specificity - match.specificity;
    }
}

