/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import mediathek.daten.DatenFilm;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BookmarkData {
    @JsonProperty(value="seen")
    private final BooleanProperty seen = new SimpleBooleanProperty(false);
    private String url;
    @JsonIgnore
    private DatenFilm filmdata;
    private String note;

    public BookmarkData() {
    }

    public BookmarkData(DatenFilm film) {
        this();
        this.url = film.getUrlNormalQuality();
        this.filmdata = film;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getNote() {
        return this.note;
    }

    @JsonIgnore
    public Optional<String> getNoteOptional() {
        return Optional.ofNullable(this.note);
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean getSeen() {
        return this.seen.get();
    }

    @JsonIgnore
    public boolean getNotSeen() {
        return !this.seen.get();
    }

    public void setSeen(boolean seen) {
        this.seen.set(seen);
    }

    @JsonIgnore
    public BooleanProperty getSeenProperty() {
        return this.seen;
    }

    @JsonIgnore
    public boolean isNotInFilmList() {
        return this.filmdata == null;
    }

    @JsonIgnore
    public boolean isLiveStream() {
        return this.filmdata != null ? this.filmdata.isLivestream() : false;
    }

    @JsonIgnore
    public DatenFilm getDatenFilm() {
        return this.filmdata;
    }

    @JsonIgnore
    public void setDatenFilm(DatenFilm filmdata) {
        this.filmdata = filmdata;
    }

    @JsonIgnore
    public String getWebUrl() {
        return this.filmdata != null ? this.filmdata.getWebsiteUrl() : null;
    }

    @JsonIgnore
    public String getFormattedNote() {
        return this.note != null && !this.note.isEmpty() ? String.format("\n\nNotiz:\n%s", this.note) : "";
    }

    @JsonIgnore
    public String getExtendedDescription() {
        if (this.filmdata == null) {
            return "Es wurde kein Filmobjekt mehr in der Filmliste gefunden. --> Ung\u00fcltiger Eintrag!";
        }
        return String.format("%s - %s\n\n%s%s", this.filmdata.getSender(), this.filmdata.getTitle(), this.filmdata.getDescription(), this.getFormattedNote());
    }

    @JsonIgnore
    public Optional<DatenFilm> getDatenFilmOptional() {
        return Optional.ofNullable(this.filmdata);
    }
}

