/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.AbstractList;
import java.util.List;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public class JakartaArrayImpl
extends AbstractList<JsonValue>
implements JsonArray,
Wrapper {
    OracleJsonArrayImpl wrapped;

    JakartaArrayImpl(OracleJsonArrayImpl wrapped) {
        this.wrapped = wrapped;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public JsonValue get(int index) {
        OracleJsonValue v = this.wrapped.get(index);
        return v.wrap(JsonValue.class);
    }

    @Override
    public List<JsonValue> subList(int fromIndex, int toIndex) {
        return (List)this.wrapped.subList(fromIndex, toIndex).wrap(JsonArray.class);
    }

    public boolean getBoolean(int i) {
        return this.wrapped.getBoolean(i);
    }

    public boolean getBoolean(int i, boolean d) {
        if (i < 0 || i >= this.wrapped.size()) {
            return d;
        }
        OracleJsonValue v = this.wrapped.get(i);
        if (OracleJsonValue.TRUE.equals(v)) {
            return true;
        }
        if (OracleJsonValue.FALSE.equals(v)) {
            return false;
        }
        return d;
    }

    public int getInt(int i) {
        return this.wrapped.getInt(i);
    }

    public int getInt(int i, int d) {
        if (i < 0 || i >= this.wrapped.size()) {
            return d;
        }
        OracleJsonValue v = this.wrapped.get(i);
        if (v instanceof OracleJsonNumber) {
            return ((OracleJsonNumber)v).intValue();
        }
        return d;
    }

    public JsonArray getJsonArray(int i) {
        return this.wrapped.get(i).asJsonArray().wrap(JsonArray.class);
    }

    public JsonNumber getJsonNumber(int i) {
        return ((OracleJsonNumber)this.wrapped.get(i)).wrap(JsonNumber.class);
    }

    public JsonObject getJsonObject(int i) {
        return this.wrapped.get(i).asJsonObject().wrap(JsonObject.class);
    }

    public JsonString getJsonString(int i) {
        return this.wrapped.get(i).wrap(JsonString.class);
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> arg0) {
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return JakartaArrayImpl.this.get(index);
            }

            @Override
            public int size() {
                return JakartaArrayImpl.this.wrapped.size();
            }
        };
    }

    public String getString(int i) {
        return ((JsonString)this.get(i)).getString();
    }

    public String getString(int i, String d) {
        if (i < 0 || i >= this.wrapped.size()) {
            return d;
        }
        OracleJsonValue v = this.wrapped.get(i);
        switch (v.getOracleJsonType()) {
            case BINARY: 
            case DATE: 
            case INTERVALDS: 
            case INTERVALYM: 
            case STRING: 
            case TIMESTAMP: {
                return v.wrap(JsonString.class).getString();
            }
        }
        return d;
    }

    public boolean isNull(int index) {
        return this.wrapped.isNull(index);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(OracleJsonArray.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return iface.cast(this.wrapped);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }
}

