/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsCollector;
import org.apache.lucene.search.join.TermsWithScoreCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

interface GenericTermsCollector
extends Collector {
    public BytesRefHash getCollectedTerms();

    public float[] getScoresPerTerm();

    public static GenericTermsCollector createCollectorMV(DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction, ScoreMode mode) {
        switch (mode) {
            case None: {
                return GenericTermsCollector.wrap(new TermsCollector.MV(mvFunction));
            }
            case Avg: {
                return new TermsWithScoreCollector.MV.Avg(mvFunction);
            }
        }
        return new TermsWithScoreCollector.MV(mvFunction, mode);
    }

    public static DocValuesTermsCollector.Function<SortedSetDocValues> verbose(final PrintStream out, DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction) {
        return ctx -> {
            final SortedSetDocValues target = (SortedSetDocValues)mvFunction.apply(ctx);
            return new SortedSetDocValues(){

                public int docID() {
                    return target.docID();
                }

                public int nextDoc() throws IOException {
                    int docID = target.nextDoc();
                    out.println("\nnextDoc doc# " + docID);
                    return docID;
                }

                public int advance(int dest) throws IOException {
                    int docID = target.advance(dest);
                    out.println("\nadvance(" + dest + ") -> doc# " + docID);
                    return docID;
                }

                public boolean advanceExact(int dest) throws IOException {
                    boolean exists = target.advanceExact(dest);
                    out.println("\nadvanceExact(" + dest + ") -> exists# " + exists);
                    return exists;
                }

                public long cost() {
                    return target.cost();
                }

                public long nextOrd() throws IOException {
                    return target.nextOrd();
                }

                public int docValueCount() {
                    return target.docValueCount();
                }

                public BytesRef lookupOrd(long ord) throws IOException {
                    BytesRef val = target.lookupOrd(ord);
                    out.println(val.toString() + ", ");
                    return val;
                }

                public long getValueCount() {
                    return target.getValueCount();
                }
            };
        };
    }

    public static GenericTermsCollector createCollectorSV(DocValuesTermsCollector.Function<SortedDocValues> svFunction, ScoreMode mode) {
        switch (mode) {
            case None: {
                return GenericTermsCollector.wrap(new TermsCollector.SV(svFunction));
            }
            case Avg: {
                return new TermsWithScoreCollector.SV.Avg(svFunction);
            }
        }
        return new TermsWithScoreCollector.SV(svFunction, mode);
    }

    public static GenericTermsCollector wrap(final TermsCollector<?> collector) {
        return new GenericTermsCollector(){

            public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                return collector.getLeafCollector(context);
            }

            public org.apache.lucene.search.ScoreMode scoreMode() {
                return collector.scoreMode();
            }

            @Override
            public BytesRefHash getCollectedTerms() {
                return collector.getCollectorTerms();
            }

            @Override
            public float[] getScoresPerTerm() {
                throw new UnsupportedOperationException("scores are not available for " + String.valueOf((Object)collector));
            }
        };
    }
}

