/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.common.settings.Settings;
import org.opensearch.plugins.DefaultSecureTransportParameters;
import org.opensearch.plugins.TransportExceptionHandler;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportAdapterProvider;

@ExperimentalApi
public interface SecureTransportSettingsProvider {
    default public Collection<TransportAdapterProvider<Transport>> getTransportAdapterProviders(Settings settings) {
        return Collections.emptyList();
    }

    default public Optional<SecureTransportParameters> parameters(Settings settings) {
        return Optional.of(new DefaultSecureTransportParameters(settings));
    }

    public Optional<TransportExceptionHandler> buildServerTransportExceptionHandler(Settings var1, Transport var2);

    public Optional<SSLEngine> buildSecureServerTransportEngine(Settings var1, Transport var2) throws SSLException;

    public Optional<SSLEngine> buildSecureClientTransportEngine(Settings var1, String var2, int var3) throws SSLException;

    default public Optional<SSLEngine> buildSecureClientTransportEngine(Settings settings, String serverName, String hostname, int port) throws SSLException {
        return this.buildSecureClientTransportEngine(settings, hostname, port);
    }

    @ExperimentalApi
    public static interface SecureTransportParameters {
        public boolean dualModeEnabled();

        public Optional<KeyManagerFactory> keyManagerFactory();

        public Optional<String> sslProvider();

        public Optional<String> clientAuth();

        public Collection<String> protocols();

        public Collection<String> cipherSuites();

        public Optional<TrustManagerFactory> trustManagerFactory();
    }
}

