/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.util;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.core.common.breaker.CircuitBreaker;
import org.opensearch.core.indices.breaker.CircuitBreakerService;

public class CircuitBreakerStreamObserver<T>
implements StreamObserver<T> {
    private final StreamObserver<T> delegate;
    private final CircuitBreakerService circuitBreakerService;
    private final int requestSize;
    private final AtomicBoolean released = new AtomicBoolean(false);

    public CircuitBreakerStreamObserver(StreamObserver<T> delegate, CircuitBreakerService circuitBreakerService, int requestSize) {
        this.delegate = delegate;
        this.circuitBreakerService = circuitBreakerService;
        this.requestSize = requestSize;
    }

    public void onNext(T value) {
        this.delegate.onNext(value);
    }

    public void onError(Throwable t) {
        this.releaseBytes();
        this.delegate.onError(t);
    }

    public void onCompleted() {
        this.releaseBytes();
        this.delegate.onCompleted();
    }

    private void releaseBytes() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        CircuitBreaker breaker = this.circuitBreakerService.getBreaker("in_flight_requests");
        breaker.addWithoutBreaking((long)(-this.requestSize));
    }
}

