(window["explore_bundle_jsonpfunction"]=window["explore_bundle_jsonpfunction"]||[]).push([[7],{1025:function(module,exports,__webpack_require__){module.exports={graphlib:__webpack_require__(484),layout:__webpack_require__(1038),debug:__webpack_require__(1060),util:{time:__webpack_require__(482).time,notime:__webpack_require__(482).notime},version:__webpack_require__(1061)}},1026:function(module,exports,__webpack_require__){module.exports={Graph:__webpack_require__(501),version:__webpack_require__(1027)}},1027:function(module,exports){module.exports="2.2.4"},1028:function(module,exports,__webpack_require__){var Graph=__webpack_require__(501);module.exports={write:write,read:read};function write(g){var json={options:{directed:g.isDirected(),multigraph:g.isMultigraph(),compound:g.isCompound()},nodes:writeNodes(g),edges:writeEdges(g)};if(g.graph()!==undefined){json.value=structuredClone(g.graph())}return json}function writeNodes(g){return g.nodes().map((function(v){var nodeValue=g.node(v);var parent=g.parent(v);var node={v:v};if(nodeValue!==undefined){node.value=nodeValue}if(parent!==undefined){node.parent=parent}return node}))}function writeEdges(g){return g.edges().map((function(e){var edgeValue=g.edge(e);var edge={v:e.v,w:e.w};if(e.name!==undefined){edge.name=e.name}if(edgeValue!==undefined){edge.value=edgeValue}return edge}))}function read(json){var g=new Graph(json.options).setGraph(json.value);json.nodes.forEach((function(entry){g.setNode(entry.v,entry.value);if(entry.parent){g.setParent(entry.v,entry.parent)}}));json.edges.forEach((function(entry){g.setEdge({v:entry.v,w:entry.w,name:entry.name},entry.value)}));return g}},1029:function(module,exports,__webpack_require__){module.exports={components:__webpack_require__(1030),dijkstra:__webpack_require__(515),dijkstraAll:__webpack_require__(1031),findCycles:__webpack_require__(1032),floydWarshall:__webpack_require__(1033),isAcyclic:__webpack_require__(1034),postorder:__webpack_require__(1035),preorder:__webpack_require__(1036),prim:__webpack_require__(1037),tarjan:__webpack_require__(517),topsort:__webpack_require__(518)}},1030:function(module,exports){module.exports=components;function components(g){var visited={};var cmpts=[];var cmpt;function dfs(v){if(Object.hasOwn(visited,v))return;visited[v]=true;cmpt.push(v);g.successors(v).forEach(dfs);g.predecessors(v).forEach(dfs)}g.nodes().forEach((function(v){cmpt=[];dfs(v);if(cmpt.length){cmpts.push(cmpt)}}));return cmpts}},1031:function(module,exports,__webpack_require__){var dijkstra=__webpack_require__(515);module.exports=dijkstraAll;function dijkstraAll(g,weightFunc,edgeFunc){return g.nodes().reduce((function(acc,v){acc[v]=dijkstra(g,v,weightFunc,edgeFunc);return acc}),{})}},1032:function(module,exports,__webpack_require__){var tarjan=__webpack_require__(517);module.exports=findCycles;function findCycles(g){return tarjan(g).filter((function(cmpt){return cmpt.length>1||cmpt.length===1&&g.hasEdge(cmpt[0],cmpt[0])}))}},1033:function(module,exports){module.exports=floydWarshall;var DEFAULT_WEIGHT_FUNC=()=>1;function floydWarshall(g,weightFn,edgeFn){return runFloydWarshall(g,weightFn||DEFAULT_WEIGHT_FUNC,edgeFn||function(v){return g.outEdges(v)})}function runFloydWarshall(g,weightFn,edgeFn){var results={};var nodes=g.nodes();nodes.forEach((function(v){results[v]={};results[v][v]={distance:0};nodes.forEach((function(w){if(v!==w){results[v][w]={distance:Number.POSITIVE_INFINITY}}}));edgeFn(v).forEach((function(edge){var w=edge.v===v?edge.w:edge.v;var d=weightFn(edge);results[v][w]={distance:d,predecessor:v}}))}));nodes.forEach((function(k){var rowK=results[k];nodes.forEach((function(i){var rowI=results[i];nodes.forEach((function(j){var ik=rowI[k];var kj=rowK[j];var ij=rowI[j];var altDistance=ik.distance+kj.distance;if(altDistance<ij.distance){ij.distance=altDistance;ij.predecessor=kj.predecessor}}))}))}));return results}},1034:function(module,exports,__webpack_require__){var topsort=__webpack_require__(518);module.exports=isAcyclic;function isAcyclic(g){try{topsort(g)}catch(e){if(e instanceof topsort.CycleException){return false}throw e}return true}},1035:function(module,exports,__webpack_require__){var dfs=__webpack_require__(519);module.exports=postorder;function postorder(g,vs){return dfs(g,vs,"post")}},1036:function(module,exports,__webpack_require__){var dfs=__webpack_require__(519);module.exports=preorder;function preorder(g,vs){return dfs(g,vs,"pre")}},1037:function(module,exports,__webpack_require__){var Graph=__webpack_require__(501);var PriorityQueue=__webpack_require__(516);module.exports=prim;function prim(g,weightFunc){var result=new Graph;var parents={};var pq=new PriorityQueue;var v;function updateNeighbors(edge){var w=edge.v===v?edge.w:edge.v;var pri=pq.priority(w);if(pri!==undefined){var edgeWeight=weightFunc(edge);if(edgeWeight<pri){parents[w]=v;pq.decrease(w,edgeWeight)}}}if(g.nodeCount()===0){return result}g.nodes().forEach((function(v){pq.add(v,Number.POSITIVE_INFINITY);result.setNode(v)}));pq.decrease(g.nodes()[0],0);var init=false;while(pq.size()>0){v=pq.removeMin();if(Object.hasOwn(parents,v)){result.setEdge(v,parents[v])}else if(init){throw new Error("Input graph is not connected: "+g)}else{init=true}g.nodeEdges(v).forEach(updateNeighbors)}return result}},1038:function(module,exports,__webpack_require__){"use strict";let acyclic=__webpack_require__(1039);let normalize=__webpack_require__(1042);let rank=__webpack_require__(1043);let normalizeRanks=__webpack_require__(482).normalizeRanks;let parentDummyChains=__webpack_require__(1045);let removeEmptyRanks=__webpack_require__(482).removeEmptyRanks;let nestingGraph=__webpack_require__(1046);let addBorderSegments=__webpack_require__(1047);let coordinateSystem=__webpack_require__(1048);let order=__webpack_require__(1049);let position=__webpack_require__(1058);let util=__webpack_require__(482);let Graph=__webpack_require__(484).Graph;module.exports=layout;function layout(g,opts){let time=opts&&opts.debugTiming?util.time:util.notime;time("layout",()=>{let layoutGraph=time("  buildLayoutGraph",()=>buildLayoutGraph(g));time("  runLayout",()=>runLayout(layoutGraph,time,opts));time("  updateInputGraph",()=>updateInputGraph(g,layoutGraph))})}function runLayout(g,time,opts){time("    makeSpaceForEdgeLabels",()=>makeSpaceForEdgeLabels(g));time("    removeSelfEdges",()=>removeSelfEdges(g));time("    acyclic",()=>acyclic.run(g));time("    nestingGraph.run",()=>nestingGraph.run(g));time("    rank",()=>rank(util.asNonCompoundGraph(g)));time("    injectEdgeLabelProxies",()=>injectEdgeLabelProxies(g));time("    removeEmptyRanks",()=>removeEmptyRanks(g));time("    nestingGraph.cleanup",()=>nestingGraph.cleanup(g));time("    normalizeRanks",()=>normalizeRanks(g));time("    assignRankMinMax",()=>assignRankMinMax(g));time("    removeEdgeLabelProxies",()=>removeEdgeLabelProxies(g));time("    normalize.run",()=>normalize.run(g));time("    parentDummyChains",()=>parentDummyChains(g));time("    addBorderSegments",()=>addBorderSegments(g));time("    order",()=>order(g,opts));time("    insertSelfEdges",()=>insertSelfEdges(g));time("    adjustCoordinateSystem",()=>coordinateSystem.adjust(g));time("    position",()=>position(g));time("    positionSelfEdges",()=>positionSelfEdges(g));time("    removeBorderNodes",()=>removeBorderNodes(g));time("    normalize.undo",()=>normalize.undo(g));time("    fixupEdgeLabelCoords",()=>fixupEdgeLabelCoords(g));time("    undoCoordinateSystem",()=>coordinateSystem.undo(g));time("    translateGraph",()=>translateGraph(g));time("    assignNodeIntersects",()=>assignNodeIntersects(g));time("    reversePoints",()=>reversePointsForReversedEdges(g));time("    acyclic.undo",()=>acyclic.undo(g))}function updateInputGraph(inputGraph,layoutGraph){inputGraph.nodes().forEach(v=>{let inputLabel=inputGraph.node(v);let layoutLabel=layoutGraph.node(v);if(inputLabel){inputLabel.x=layoutLabel.x;inputLabel.y=layoutLabel.y;inputLabel.rank=layoutLabel.rank;if(layoutGraph.children(v).length){inputLabel.width=layoutLabel.width;inputLabel.height=layoutLabel.height}}});inputGraph.edges().forEach(e=>{let inputLabel=inputGraph.edge(e);let layoutLabel=layoutGraph.edge(e);inputLabel.points=layoutLabel.points;if(Object.hasOwn(layoutLabel,"x")){inputLabel.x=layoutLabel.x;inputLabel.y=layoutLabel.y}});inputGraph.graph().width=layoutGraph.graph().width;inputGraph.graph().height=layoutGraph.graph().height}let graphNumAttrs=["nodesep","edgesep","ranksep","marginx","marginy"];let graphDefaults={ranksep:50,edgesep:20,nodesep:50,rankdir:"tb"};let graphAttrs=["acyclicer","ranker","rankdir","align"];let nodeNumAttrs=["width","height","rank"];let nodeDefaults={width:0,height:0};let edgeNumAttrs=["minlen","weight","width","height","labeloffset"];let edgeDefaults={minlen:1,weight:1,width:0,height:0,labeloffset:10,labelpos:"r"};let edgeAttrs=["labelpos"];function buildLayoutGraph(inputGraph){let g=new Graph({multigraph:true,compound:true});let graph=canonicalize(inputGraph.graph());g.setGraph(Object.assign({},graphDefaults,selectNumberAttrs(graph,graphNumAttrs),util.pick(graph,graphAttrs)));inputGraph.nodes().forEach(v=>{let node=canonicalize(inputGraph.node(v));const newNode=selectNumberAttrs(node,nodeNumAttrs);Object.keys(nodeDefaults).forEach(k=>{if(newNode[k]===undefined){newNode[k]=nodeDefaults[k]}});g.setNode(v,newNode);g.setParent(v,inputGraph.parent(v))});inputGraph.edges().forEach(e=>{let edge=canonicalize(inputGraph.edge(e));g.setEdge(e,Object.assign({},edgeDefaults,selectNumberAttrs(edge,edgeNumAttrs),util.pick(edge,edgeAttrs)))});return g}function makeSpaceForEdgeLabels(g){let graph=g.graph();graph.ranksep/=2;g.edges().forEach(e=>{let edge=g.edge(e);edge.minlen*=2;if(edge.labelpos.toLowerCase()!=="c"){if(graph.rankdir==="TB"||graph.rankdir==="BT"){edge.width+=edge.labeloffset}else{edge.height+=edge.labeloffset}}})}function injectEdgeLabelProxies(g){g.edges().forEach(e=>{let edge=g.edge(e);if(edge.width&&edge.height){let v=g.node(e.v);let w=g.node(e.w);let label={rank:(w.rank-v.rank)/2+v.rank,e:e};util.addDummyNode(g,"edge-proxy",label,"_ep")}})}function assignRankMinMax(g){let maxRank=0;g.nodes().forEach(v=>{let node=g.node(v);if(node.borderTop){node.minRank=g.node(node.borderTop).rank;node.maxRank=g.node(node.borderBottom).rank;maxRank=Math.max(maxRank,node.maxRank)}});g.graph().maxRank=maxRank}function removeEdgeLabelProxies(g){g.nodes().forEach(v=>{let node=g.node(v);if(node.dummy==="edge-proxy"){g.edge(node.e).labelRank=node.rank;g.removeNode(v)}})}function translateGraph(g){let minX=Number.POSITIVE_INFINITY;let maxX=0;let minY=Number.POSITIVE_INFINITY;let maxY=0;let graphLabel=g.graph();let marginX=graphLabel.marginx||0;let marginY=graphLabel.marginy||0;function getExtremes(attrs){let x=attrs.x;let y=attrs.y;let w=attrs.width;let h=attrs.height;minX=Math.min(minX,x-w/2);maxX=Math.max(maxX,x+w/2);minY=Math.min(minY,y-h/2);maxY=Math.max(maxY,y+h/2)}g.nodes().forEach(v=>getExtremes(g.node(v)));g.edges().forEach(e=>{let edge=g.edge(e);if(Object.hasOwn(edge,"x")){getExtremes(edge)}});minX-=marginX;minY-=marginY;g.nodes().forEach(v=>{let node=g.node(v);node.x-=minX;node.y-=minY});g.edges().forEach(e=>{let edge=g.edge(e);edge.points.forEach(p=>{p.x-=minX;p.y-=minY});if(Object.hasOwn(edge,"x")){edge.x-=minX}if(Object.hasOwn(edge,"y")){edge.y-=minY}});graphLabel.width=maxX-minX+marginX;graphLabel.height=maxY-minY+marginY}function assignNodeIntersects(g){g.edges().forEach(e=>{let edge=g.edge(e);let nodeV=g.node(e.v);let nodeW=g.node(e.w);let p1,p2;if(!edge.points){edge.points=[];p1=nodeW;p2=nodeV}else{p1=edge.points[0];p2=edge.points[edge.points.length-1]}edge.points.unshift(util.intersectRect(nodeV,p1));edge.points.push(util.intersectRect(nodeW,p2))})}function fixupEdgeLabelCoords(g){g.edges().forEach(e=>{let edge=g.edge(e);if(Object.hasOwn(edge,"x")){if(edge.labelpos==="l"||edge.labelpos==="r"){edge.width-=edge.labeloffset}switch(edge.labelpos){case"l":edge.x-=edge.width/2+edge.labeloffset;break;case"r":edge.x+=edge.width/2+edge.labeloffset;break}}})}function reversePointsForReversedEdges(g){g.edges().forEach(e=>{let edge=g.edge(e);if(edge.reversed){edge.points.reverse()}})}function removeBorderNodes(g){g.nodes().forEach(v=>{if(g.children(v).length){let node=g.node(v);let t=g.node(node.borderTop);let b=g.node(node.borderBottom);let l=g.node(node.borderLeft[node.borderLeft.length-1]);let r=g.node(node.borderRight[node.borderRight.length-1]);node.width=Math.abs(r.x-l.x);node.height=Math.abs(b.y-t.y);node.x=l.x+node.width/2;node.y=t.y+node.height/2}});g.nodes().forEach(v=>{if(g.node(v).dummy==="border"){g.removeNode(v)}})}function removeSelfEdges(g){g.edges().forEach(e=>{if(e.v===e.w){var node=g.node(e.v);if(!node.selfEdges){node.selfEdges=[]}node.selfEdges.push({e:e,label:g.edge(e)});g.removeEdge(e)}})}function insertSelfEdges(g){var layers=util.buildLayerMatrix(g);layers.forEach(layer=>{var orderShift=0;layer.forEach((v,i)=>{var node=g.node(v);node.order=i+orderShift;(node.selfEdges||[]).forEach(selfEdge=>{util.addDummyNode(g,"selfedge",{width:selfEdge.label.width,height:selfEdge.label.height,rank:node.rank,order:i+ ++orderShift,e:selfEdge.e,label:selfEdge.label},"_se")});delete node.selfEdges})})}function positionSelfEdges(g){g.nodes().forEach(v=>{var node=g.node(v);if(node.dummy==="selfedge"){var selfNode=g.node(node.e.v);var x=selfNode.x+selfNode.width/2;var y=selfNode.y;var dx=node.x-x;var dy=selfNode.height/2;g.setEdge(node.e,node.label);g.removeNode(v);node.label.points=[{x:x+2*dx/3,y:y-dy},{x:x+5*dx/6,y:y-dy},{x:x+dx,y:y},{x:x+5*dx/6,y:y+dy},{x:x+2*dx/3,y:y+dy}];node.label.x=node.x;node.label.y=node.y}})}function selectNumberAttrs(obj,attrs){return util.mapValues(util.pick(obj,attrs),Number)}function canonicalize(attrs){var newAttrs={};if(attrs){Object.entries(attrs).forEach(_ref=>{let[k,v]=_ref;if(typeof k==="string"){k=k.toLowerCase()}newAttrs[k]=v})}return newAttrs}},1039:function(module,exports,__webpack_require__){"use strict";let greedyFAS=__webpack_require__(1040);let uniqueId=__webpack_require__(482).uniqueId;module.exports={run:run,undo:undo};function run(g){let fas=g.graph().acyclicer==="greedy"?greedyFAS(g,weightFn(g)):dfsFAS(g);fas.forEach(e=>{let label=g.edge(e);g.removeEdge(e);label.forwardName=e.name;label.reversed=true;g.setEdge(e.w,e.v,label,uniqueId("rev"))});function weightFn(g){return e=>g.edge(e).weight}}function dfsFAS(g){let fas=[];let stack={};let visited={};function dfs(v){if(Object.hasOwn(visited,v)){return}visited[v]=true;stack[v]=true;g.outEdges(v).forEach(e=>{if(Object.hasOwn(stack,e.w)){fas.push(e)}else{dfs(e.w)}});delete stack[v]}g.nodes().forEach(dfs);return fas}function undo(g){g.edges().forEach(e=>{let label=g.edge(e);if(label.reversed){g.removeEdge(e);let forwardName=label.forwardName;delete label.reversed;delete label.forwardName;g.setEdge(e.w,e.v,label,forwardName)}})}},1040:function(module,exports,__webpack_require__){let Graph=__webpack_require__(484).Graph;let List=__webpack_require__(1041);module.exports=greedyFAS;let DEFAULT_WEIGHT_FN=()=>1;function greedyFAS(g,weightFn){if(g.nodeCount()<=1){return[]}let state=buildState(g,weightFn||DEFAULT_WEIGHT_FN);let results=doGreedyFAS(state.graph,state.buckets,state.zeroIdx);return results.flatMap(e=>g.outEdges(e.v,e.w))}function doGreedyFAS(g,buckets,zeroIdx){let results=[];let sources=buckets[buckets.length-1];let sinks=buckets[0];let entry;while(g.nodeCount()){while(entry=sinks.dequeue()){removeNode(g,buckets,zeroIdx,entry)}while(entry=sources.dequeue()){removeNode(g,buckets,zeroIdx,entry)}if(g.nodeCount()){for(let i=buckets.length-2;i>0;--i){entry=buckets[i].dequeue();if(entry){results=results.concat(removeNode(g,buckets,zeroIdx,entry,true));break}}}}return results}function removeNode(g,buckets,zeroIdx,entry,collectPredecessors){let results=collectPredecessors?[]:undefined;g.inEdges(entry.v).forEach(edge=>{let weight=g.edge(edge);let uEntry=g.node(edge.v);if(collectPredecessors){results.push({v:edge.v,w:edge.w})}uEntry.out-=weight;assignBucket(buckets,zeroIdx,uEntry)});g.outEdges(entry.v).forEach(edge=>{let weight=g.edge(edge);let w=edge.w;let wEntry=g.node(w);wEntry["in"]-=weight;assignBucket(buckets,zeroIdx,wEntry)});g.removeNode(entry.v);return results}function buildState(g,weightFn){let fasGraph=new Graph;let maxIn=0;let maxOut=0;g.nodes().forEach(v=>{fasGraph.setNode(v,{v:v,in:0,out:0})});g.edges().forEach(e=>{let prevWeight=fasGraph.edge(e.v,e.w)||0;let weight=weightFn(e);let edgeWeight=prevWeight+weight;fasGraph.setEdge(e.v,e.w,edgeWeight);maxOut=Math.max(maxOut,fasGraph.node(e.v).out+=weight);maxIn=Math.max(maxIn,fasGraph.node(e.w)["in"]+=weight)});let buckets=range(maxOut+maxIn+3).map(()=>new List);let zeroIdx=maxIn+1;fasGraph.nodes().forEach(v=>{assignBucket(buckets,zeroIdx,fasGraph.node(v))});return{graph:fasGraph,buckets:buckets,zeroIdx:zeroIdx}}function assignBucket(buckets,zeroIdx,entry){if(!entry.out){buckets[0].enqueue(entry)}else if(!entry["in"]){buckets[buckets.length-1].enqueue(entry)}else{buckets[entry.out-entry["in"]+zeroIdx].enqueue(entry)}}function range(limit){const range=[];for(let i=0;i<limit;i++){range.push(i)}return range}},1041:function(module,exports){class List{constructor(){let sentinel={};sentinel._next=sentinel._prev=sentinel;this._sentinel=sentinel}dequeue(){let sentinel=this._sentinel;let entry=sentinel._prev;if(entry!==sentinel){unlink(entry);return entry}}enqueue(entry){let sentinel=this._sentinel;if(entry._prev&&entry._next){unlink(entry)}entry._next=sentinel._next;sentinel._next._prev=entry;sentinel._next=entry;entry._prev=sentinel}toString(){let strs=[];let sentinel=this._sentinel;let curr=sentinel._prev;while(curr!==sentinel){strs.push(JSON.stringify(curr,filterOutLinks));curr=curr._prev}return"["+strs.join(", ")+"]"}}function unlink(entry){entry._prev._next=entry._next;entry._next._prev=entry._prev;delete entry._next;delete entry._prev}function filterOutLinks(k,v){if(k!=="_next"&&k!=="_prev"){return v}}module.exports=List},1042:function(module,exports,__webpack_require__){"use strict";let util=__webpack_require__(482);module.exports={run:run,undo:undo};function run(g){g.graph().dummyChains=[];g.edges().forEach(edge=>normalizeEdge(g,edge))}function normalizeEdge(g,e){let v=e.v;let vRank=g.node(v).rank;let w=e.w;let wRank=g.node(w).rank;let name=e.name;let edgeLabel=g.edge(e);let labelRank=edgeLabel.labelRank;if(wRank===vRank+1)return;g.removeEdge(e);let dummy,attrs,i;for(i=0,++vRank;vRank<wRank;++i,++vRank){edgeLabel.points=[];attrs={width:0,height:0,edgeLabel:edgeLabel,edgeObj:e,rank:vRank};dummy=util.addDummyNode(g,"edge",attrs,"_d");if(vRank===labelRank){attrs.width=edgeLabel.width;attrs.height=edgeLabel.height;attrs.dummy="edge-label";attrs.labelpos=edgeLabel.labelpos}g.setEdge(v,dummy,{weight:edgeLabel.weight},name);if(i===0){g.graph().dummyChains.push(dummy)}v=dummy}g.setEdge(v,w,{weight:edgeLabel.weight},name)}function undo(g){g.graph().dummyChains.forEach(v=>{let node=g.node(v);let origLabel=node.edgeLabel;let w;g.setEdge(node.edgeObj,origLabel);while(node.dummy){w=g.successors(v)[0];g.removeNode(v);origLabel.points.push({x:node.x,y:node.y});if(node.dummy==="edge-label"){origLabel.x=node.x;origLabel.y=node.y;origLabel.width=node.width;origLabel.height=node.height}v=w;node=g.node(v)}})}},1043:function(module,exports,__webpack_require__){"use strict";var rankUtil=__webpack_require__(494);var longestPath=rankUtil.longestPath;var feasibleTree=__webpack_require__(520);var networkSimplex=__webpack_require__(1044);module.exports=rank;function rank(g){var ranker=g.graph().ranker;if(ranker instanceof Function){return ranker(g)}switch(g.graph().ranker){case"network-simplex":networkSimplexRanker(g);break;case"tight-tree":tightTreeRanker(g);break;case"longest-path":longestPathRanker(g);break;case"none":break;default:networkSimplexRanker(g)}}var longestPathRanker=longestPath;function tightTreeRanker(g){longestPath(g);feasibleTree(g)}function networkSimplexRanker(g){networkSimplex(g)}},1044:function(module,exports,__webpack_require__){"use strict";var feasibleTree=__webpack_require__(520);var slack=__webpack_require__(494).slack;var initRank=__webpack_require__(494).longestPath;var preorder=__webpack_require__(484).alg.preorder;var postorder=__webpack_require__(484).alg.postorder;var simplify=__webpack_require__(482).simplify;module.exports=networkSimplex;networkSimplex.initLowLimValues=initLowLimValues;networkSimplex.initCutValues=initCutValues;networkSimplex.calcCutValue=calcCutValue;networkSimplex.leaveEdge=leaveEdge;networkSimplex.enterEdge=enterEdge;networkSimplex.exchangeEdges=exchangeEdges;function networkSimplex(g){g=simplify(g);initRank(g);var t=feasibleTree(g);initLowLimValues(t);initCutValues(t,g);var e,f;while(e=leaveEdge(t)){f=enterEdge(t,g,e);exchangeEdges(t,g,e,f)}}function initCutValues(t,g){var vs=postorder(t,t.nodes());vs=vs.slice(0,vs.length-1);vs.forEach(v=>assignCutValue(t,g,v))}function assignCutValue(t,g,child){var childLab=t.node(child);var parent=childLab.parent;t.edge(child,parent).cutvalue=calcCutValue(t,g,child)}function calcCutValue(t,g,child){var childLab=t.node(child);var parent=childLab.parent;var childIsTail=true;var graphEdge=g.edge(child,parent);var cutValue=0;if(!graphEdge){childIsTail=false;graphEdge=g.edge(parent,child)}cutValue=graphEdge.weight;g.nodeEdges(child).forEach(e=>{var isOutEdge=e.v===child,other=isOutEdge?e.w:e.v;if(other!==parent){var pointsToHead=isOutEdge===childIsTail,otherWeight=g.edge(e).weight;cutValue+=pointsToHead?otherWeight:-otherWeight;if(isTreeEdge(t,child,other)){var otherCutValue=t.edge(child,other).cutvalue;cutValue+=pointsToHead?-otherCutValue:otherCutValue}}});return cutValue}function initLowLimValues(tree,root){if(arguments.length<2){root=tree.nodes()[0]}dfsAssignLowLim(tree,{},1,root)}function dfsAssignLowLim(tree,visited,nextLim,v,parent){var low=nextLim;var label=tree.node(v);visited[v]=true;tree.neighbors(v).forEach(w=>{if(!Object.hasOwn(visited,w)){nextLim=dfsAssignLowLim(tree,visited,nextLim,w,v)}});label.low=low;label.lim=nextLim++;if(parent){label.parent=parent}else{delete label.parent}return nextLim}function leaveEdge(tree){return tree.edges().find(e=>tree.edge(e).cutvalue<0)}function enterEdge(t,g,edge){var v=edge.v;var w=edge.w;if(!g.hasEdge(v,w)){v=edge.w;w=edge.v}var vLabel=t.node(v);var wLabel=t.node(w);var tailLabel=vLabel;var flip=false;if(vLabel.lim>wLabel.lim){tailLabel=wLabel;flip=true}var candidates=g.edges().filter(edge=>flip===isDescendant(t,t.node(edge.v),tailLabel)&&flip!==isDescendant(t,t.node(edge.w),tailLabel));return candidates.reduce((acc,edge)=>{if(slack(g,edge)<slack(g,acc)){return edge}return acc})}function exchangeEdges(t,g,e,f){var v=e.v;var w=e.w;t.removeEdge(v,w);t.setEdge(f.v,f.w,{});initLowLimValues(t);initCutValues(t,g);updateRanks(t,g)}function updateRanks(t,g){var root=t.nodes().find(v=>!g.node(v).parent);var vs=preorder(t,root);vs=vs.slice(1);vs.forEach(v=>{var parent=t.node(v).parent,edge=g.edge(v,parent),flipped=false;if(!edge){edge=g.edge(parent,v);flipped=true}g.node(v).rank=g.node(parent).rank+(flipped?edge.minlen:-edge.minlen)})}function isTreeEdge(tree,u,v){return tree.hasEdge(u,v)}function isDescendant(tree,vLabel,rootLabel){return rootLabel.low<=vLabel.lim&&vLabel.lim<=rootLabel.lim}},1045:function(module,exports){module.exports=parentDummyChains;function parentDummyChains(g){let postorderNums=postorder(g);g.graph().dummyChains.forEach(v=>{let node=g.node(v);let edgeObj=node.edgeObj;let pathData=findPath(g,postorderNums,edgeObj.v,edgeObj.w);let path=pathData.path;let lca=pathData.lca;let pathIdx=0;let pathV=path[pathIdx];let ascending=true;while(v!==edgeObj.w){node=g.node(v);if(ascending){while((pathV=path[pathIdx])!==lca&&g.node(pathV).maxRank<node.rank){pathIdx++}if(pathV===lca){ascending=false}}if(!ascending){while(pathIdx<path.length-1&&g.node(pathV=path[pathIdx+1]).minRank<=node.rank){pathIdx++}pathV=path[pathIdx]}g.setParent(v,pathV);v=g.successors(v)[0]}})}function findPath(g,postorderNums,v,w){let vPath=[];let wPath=[];let low=Math.min(postorderNums[v].low,postorderNums[w].low);let lim=Math.max(postorderNums[v].lim,postorderNums[w].lim);let parent;let lca;parent=v;do{parent=g.parent(parent);vPath.push(parent)}while(parent&&(postorderNums[parent].low>low||lim>postorderNums[parent].lim));lca=parent;parent=w;while((parent=g.parent(parent))!==lca){wPath.push(parent)}return{path:vPath.concat(wPath.reverse()),lca:lca}}function postorder(g){let result={};let lim=0;function dfs(v){let low=lim;g.children(v).forEach(dfs);result[v]={low:low,lim:lim++}}g.children().forEach(dfs);return result}},1046:function(module,exports,__webpack_require__){let util=__webpack_require__(482);module.exports={run:run,cleanup:cleanup};function run(g){let root=util.addDummyNode(g,"root",{},"_root");let depths=treeDepths(g);let depthsArr=Object.values(depths);let height=util.applyWithChunking(Math.max,depthsArr)-1;let nodeSep=2*height+1;g.graph().nestingRoot=root;g.edges().forEach(e=>g.edge(e).minlen*=nodeSep);let weight=sumWeights(g)+1;g.children().forEach(child=>dfs(g,root,nodeSep,weight,height,depths,child));g.graph().nodeRankFactor=nodeSep}function dfs(g,root,nodeSep,weight,height,depths,v){let children=g.children(v);if(!children.length){if(v!==root){g.setEdge(root,v,{weight:0,minlen:nodeSep})}return}let top=util.addBorderNode(g,"_bt");let bottom=util.addBorderNode(g,"_bb");let label=g.node(v);g.setParent(top,v);label.borderTop=top;g.setParent(bottom,v);label.borderBottom=bottom;children.forEach(child=>{dfs(g,root,nodeSep,weight,height,depths,child);let childNode=g.node(child);let childTop=childNode.borderTop?childNode.borderTop:child;let childBottom=childNode.borderBottom?childNode.borderBottom:child;let thisWeight=childNode.borderTop?weight:2*weight;let minlen=childTop!==childBottom?1:height-depths[v]+1;g.setEdge(top,childTop,{weight:thisWeight,minlen:minlen,nestingEdge:true});g.setEdge(childBottom,bottom,{weight:thisWeight,minlen:minlen,nestingEdge:true})});if(!g.parent(v)){g.setEdge(root,top,{weight:0,minlen:height+depths[v]})}}function treeDepths(g){var depths={};function dfs(v,depth){var children=g.children(v);if(children&&children.length){children.forEach(child=>dfs(child,depth+1))}depths[v]=depth}g.children().forEach(v=>dfs(v,1));return depths}function sumWeights(g){return g.edges().reduce((acc,e)=>acc+g.edge(e).weight,0)}function cleanup(g){var graphLabel=g.graph();g.removeNode(graphLabel.nestingRoot);delete graphLabel.nestingRoot;g.edges().forEach(e=>{var edge=g.edge(e);if(edge.nestingEdge){g.removeEdge(e)}})}},1047:function(module,exports,__webpack_require__){let util=__webpack_require__(482);module.exports=addBorderSegments;function addBorderSegments(g){function dfs(v){let children=g.children(v);let node=g.node(v);if(children.length){children.forEach(dfs)}if(Object.hasOwn(node,"minRank")){node.borderLeft=[];node.borderRight=[];for(let rank=node.minRank,maxRank=node.maxRank+1;rank<maxRank;++rank){addBorderNode(g,"borderLeft","_bl",v,node,rank);addBorderNode(g,"borderRight","_br",v,node,rank)}}}g.children().forEach(dfs)}function addBorderNode(g,prop,prefix,sg,sgNode,rank){let label={width:0,height:0,rank:rank,borderType:prop};let prev=sgNode[prop][rank-1];let curr=util.addDummyNode(g,"border",label,prefix);sgNode[prop][rank]=curr;g.setParent(curr,sg);if(prev){g.setEdge(prev,curr,{weight:1})}}},1048:function(module,exports,__webpack_require__){"use strict";module.exports={adjust:adjust,undo:undo};function adjust(g){let rankDir=g.graph().rankdir.toLowerCase();if(rankDir==="lr"||rankDir==="rl"){swapWidthHeight(g)}}function undo(g){let rankDir=g.graph().rankdir.toLowerCase();if(rankDir==="bt"||rankDir==="rl"){reverseY(g)}if(rankDir==="lr"||rankDir==="rl"){swapXY(g);swapWidthHeight(g)}}function swapWidthHeight(g){g.nodes().forEach(v=>swapWidthHeightOne(g.node(v)));g.edges().forEach(e=>swapWidthHeightOne(g.edge(e)))}function swapWidthHeightOne(attrs){let w=attrs.width;attrs.width=attrs.height;attrs.height=w}function reverseY(g){g.nodes().forEach(v=>reverseYOne(g.node(v)));g.edges().forEach(e=>{let edge=g.edge(e);edge.points.forEach(reverseYOne);if(Object.hasOwn(edge,"y")){reverseYOne(edge)}})}function reverseYOne(attrs){attrs.y=-attrs.y}function swapXY(g){g.nodes().forEach(v=>swapXYOne(g.node(v)));g.edges().forEach(e=>{let edge=g.edge(e);edge.points.forEach(swapXYOne);if(Object.hasOwn(edge,"x")){swapXYOne(edge)}})}function swapXYOne(attrs){let x=attrs.x;attrs.x=attrs.y;attrs.y=x}},1049:function(module,exports,__webpack_require__){"use strict";let initOrder=__webpack_require__(1050);let crossCount=__webpack_require__(1051);let sortSubgraph=__webpack_require__(1052);let buildLayerGraph=__webpack_require__(1056);let addSubgraphConstraints=__webpack_require__(1057);let Graph=__webpack_require__(484).Graph;let util=__webpack_require__(482);module.exports=order;function order(g,opts){if(opts&&typeof opts.customOrder==="function"){opts.customOrder(g,order);return}let maxRank=util.maxRank(g),downLayerGraphs=buildLayerGraphs(g,util.range(1,maxRank+1),"inEdges"),upLayerGraphs=buildLayerGraphs(g,util.range(maxRank-1,-1,-1),"outEdges");let layering=initOrder(g);assignOrder(g,layering);if(opts&&opts.disableOptimalOrderHeuristic){return}let bestCC=Number.POSITIVE_INFINITY,best;for(let i=0,lastBest=0;lastBest<4;++i,++lastBest){sweepLayerGraphs(i%2?downLayerGraphs:upLayerGraphs,i%4>=2);layering=util.buildLayerMatrix(g);let cc=crossCount(g,layering);if(cc<bestCC){lastBest=0;best=Object.assign({},layering);bestCC=cc}}assignOrder(g,best)}function buildLayerGraphs(g,ranks,relationship){return ranks.map((function(rank){return buildLayerGraph(g,rank,relationship)}))}function sweepLayerGraphs(layerGraphs,biasRight){let cg=new Graph;layerGraphs.forEach((function(lg){let root=lg.graph().root;let sorted=sortSubgraph(lg,root,cg,biasRight);sorted.vs.forEach((v,i)=>lg.node(v).order=i);addSubgraphConstraints(lg,cg,sorted.vs)}))}function assignOrder(g,layering){Object.values(layering).forEach(layer=>layer.forEach((v,i)=>g.node(v).order=i))}},1050:function(module,exports,__webpack_require__){"use strict";let util=__webpack_require__(482);module.exports=initOrder;function initOrder(g){let visited={};let simpleNodes=g.nodes().filter(v=>!g.children(v).length);let simpleNodesRanks=simpleNodes.map(v=>g.node(v).rank);let maxRank=util.applyWithChunking(Math.max,simpleNodesRanks);let layers=util.range(maxRank+1).map(()=>[]);function dfs(v){if(visited[v])return;visited[v]=true;let node=g.node(v);layers[node.rank].push(v);g.successors(v).forEach(dfs)}let orderedVs=simpleNodes.sort((a,b)=>g.node(a).rank-g.node(b).rank);orderedVs.forEach(dfs);return layers}},1051:function(module,exports,__webpack_require__){"use strict";let zipObject=__webpack_require__(482).zipObject;module.exports=crossCount;function crossCount(g,layering){let cc=0;for(let i=1;i<layering.length;++i){cc+=twoLayerCrossCount(g,layering[i-1],layering[i])}return cc}function twoLayerCrossCount(g,northLayer,southLayer){let southPos=zipObject(southLayer,southLayer.map((v,i)=>i));let southEntries=northLayer.flatMap(v=>g.outEdges(v).map(e=>({pos:southPos[e.w],weight:g.edge(e).weight})).sort((a,b)=>a.pos-b.pos));let firstIndex=1;while(firstIndex<southLayer.length)firstIndex<<=1;let treeSize=2*firstIndex-1;firstIndex-=1;let tree=new Array(treeSize).fill(0);let cc=0;southEntries.forEach(entry=>{let index=entry.pos+firstIndex;tree[index]+=entry.weight;let weightSum=0;while(index>0){if(index%2){weightSum+=tree[index+1]}index=index-1>>1;tree[index]+=entry.weight}cc+=entry.weight*weightSum});return cc}},1052:function(module,exports,__webpack_require__){let barycenter=__webpack_require__(1053);let resolveConflicts=__webpack_require__(1054);let sort=__webpack_require__(1055);module.exports=sortSubgraph;function sortSubgraph(g,v,cg,biasRight){let movable=g.children(v);let node=g.node(v);let bl=node?node.borderLeft:undefined;let br=node?node.borderRight:undefined;let subgraphs={};if(bl){movable=movable.filter(w=>w!==bl&&w!==br)}let barycenters=barycenter(g,movable);barycenters.forEach(entry=>{if(g.children(entry.v).length){let subgraphResult=sortSubgraph(g,entry.v,cg,biasRight);subgraphs[entry.v]=subgraphResult;if(Object.hasOwn(subgraphResult,"barycenter")){mergeBarycenters(entry,subgraphResult)}}});let entries=resolveConflicts(barycenters,cg);expandSubgraphs(entries,subgraphs);let result=sort(entries,biasRight);if(bl){result.vs=[bl,result.vs,br].flat(true);if(g.predecessors(bl).length){let blPred=g.node(g.predecessors(bl)[0]),brPred=g.node(g.predecessors(br)[0]);if(!Object.hasOwn(result,"barycenter")){result.barycenter=0;result.weight=0}result.barycenter=(result.barycenter*result.weight+blPred.order+brPred.order)/(result.weight+2);result.weight+=2}}return result}function expandSubgraphs(entries,subgraphs){entries.forEach(entry=>{entry.vs=entry.vs.flatMap(v=>{if(subgraphs[v]){return subgraphs[v].vs}return v})})}function mergeBarycenters(target,other){if(target.barycenter!==undefined){target.barycenter=(target.barycenter*target.weight+other.barycenter*other.weight)/(target.weight+other.weight);target.weight+=other.weight}else{target.barycenter=other.barycenter;target.weight=other.weight}}},1053:function(module,exports){module.exports=barycenter;function barycenter(g){let movable=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[];return movable.map(v=>{let inV=g.inEdges(v);if(!inV.length){return{v:v}}else{let result=inV.reduce((acc,e)=>{let edge=g.edge(e),nodeU=g.node(e.v);return{sum:acc.sum+edge.weight*nodeU.order,weight:acc.weight+edge.weight}},{sum:0,weight:0});return{v:v,barycenter:result.sum/result.weight,weight:result.weight}}})}},1054:function(module,exports,__webpack_require__){"use strict";let util=__webpack_require__(482);module.exports=resolveConflicts;function resolveConflicts(entries,cg){let mappedEntries={};entries.forEach((entry,i)=>{let tmp=mappedEntries[entry.v]={indegree:0,in:[],out:[],vs:[entry.v],i:i};if(entry.barycenter!==undefined){tmp.barycenter=entry.barycenter;tmp.weight=entry.weight}});cg.edges().forEach(e=>{let entryV=mappedEntries[e.v];let entryW=mappedEntries[e.w];if(entryV!==undefined&&entryW!==undefined){entryW.indegree++;entryV.out.push(mappedEntries[e.w])}});let sourceSet=Object.values(mappedEntries).filter(entry=>!entry.indegree);return doResolveConflicts(sourceSet)}function doResolveConflicts(sourceSet){let entries=[];function handleIn(vEntry){return uEntry=>{if(uEntry.merged){return}if(uEntry.barycenter===undefined||vEntry.barycenter===undefined||uEntry.barycenter>=vEntry.barycenter){mergeEntries(vEntry,uEntry)}}}function handleOut(vEntry){return wEntry=>{wEntry["in"].push(vEntry);if(--wEntry.indegree===0){sourceSet.push(wEntry)}}}while(sourceSet.length){let entry=sourceSet.pop();entries.push(entry);entry["in"].reverse().forEach(handleIn(entry));entry.out.forEach(handleOut(entry))}return entries.filter(entry=>!entry.merged).map(entry=>util.pick(entry,["vs","i","barycenter","weight"]))}function mergeEntries(target,source){let sum=0;let weight=0;if(target.weight){sum+=target.barycenter*target.weight;weight+=target.weight}if(source.weight){sum+=source.barycenter*source.weight;weight+=source.weight}target.vs=source.vs.concat(target.vs);target.barycenter=sum/weight;target.weight=weight;target.i=Math.min(source.i,target.i);source.merged=true}},1055:function(module,exports,__webpack_require__){let util=__webpack_require__(482);module.exports=sort;function sort(entries,biasRight){let parts=util.partition(entries,entry=>Object.hasOwn(entry,"barycenter"));let sortable=parts.lhs,unsortable=parts.rhs.sort((a,b)=>b.i-a.i),vs=[],sum=0,weight=0,vsIndex=0;sortable.sort(compareWithBias(!!biasRight));vsIndex=consumeUnsortable(vs,unsortable,vsIndex);sortable.forEach(entry=>{vsIndex+=entry.vs.length;vs.push(entry.vs);sum+=entry.barycenter*entry.weight;weight+=entry.weight;vsIndex=consumeUnsortable(vs,unsortable,vsIndex)});let result={vs:vs.flat(true)};if(weight){result.barycenter=sum/weight;result.weight=weight}return result}function consumeUnsortable(vs,unsortable,index){let last;while(unsortable.length&&(last=unsortable[unsortable.length-1]).i<=index){unsortable.pop();vs.push(last.vs);index++}return index}function compareWithBias(bias){return(entryV,entryW)=>{if(entryV.barycenter<entryW.barycenter){return-1}else if(entryV.barycenter>entryW.barycenter){return 1}return!bias?entryV.i-entryW.i:entryW.i-entryV.i}}},1056:function(module,exports,__webpack_require__){let Graph=__webpack_require__(484).Graph;let util=__webpack_require__(482);module.exports=buildLayerGraph;function buildLayerGraph(g,rank,relationship){let root=createRootNode(g),result=new Graph({compound:true}).setGraph({root:root}).setDefaultNodeLabel(v=>g.node(v));g.nodes().forEach(v=>{let node=g.node(v),parent=g.parent(v);if(node.rank===rank||node.minRank<=rank&&rank<=node.maxRank){result.setNode(v);result.setParent(v,parent||root);g[relationship](v).forEach(e=>{let u=e.v===v?e.w:e.v,edge=result.edge(u,v),weight=edge!==undefined?edge.weight:0;result.setEdge(u,v,{weight:g.edge(e).weight+weight})});if(Object.hasOwn(node,"minRank")){result.setNode(v,{borderLeft:node.borderLeft[rank],borderRight:node.borderRight[rank]})}}});return result}function createRootNode(g){var v;while(g.hasNode(v=util.uniqueId("_root")));return v}},1057:function(module,exports){module.exports=addSubgraphConstraints;function addSubgraphConstraints(g,cg,vs){let prev={},rootPrev;vs.forEach(v=>{let child=g.parent(v),parent,prevChild;while(child){parent=g.parent(child);if(parent){prevChild=prev[parent];prev[parent]=child}else{prevChild=rootPrev;rootPrev=child}if(prevChild&&prevChild!==child){cg.setEdge(prevChild,child);return}child=parent}})}},1058:function(module,exports,__webpack_require__){"use strict";let util=__webpack_require__(482);let positionX=__webpack_require__(1059).positionX;module.exports=position;function position(g){g=util.asNonCompoundGraph(g);positionY(g);Object.entries(positionX(g)).forEach(_ref=>{let[v,x]=_ref;return g.node(v).x=x})}function positionY(g){let layering=util.buildLayerMatrix(g);let rankSep=g.graph().ranksep;let prevY=0;layering.forEach(layer=>{const maxHeight=layer.reduce((acc,v)=>{const height=g.node(v).height;if(acc>height){return acc}else{return height}},0);layer.forEach(v=>g.node(v).y=prevY+maxHeight/2);prevY+=maxHeight+rankSep})}},1059:function(module,exports,__webpack_require__){"use strict";let Graph=__webpack_require__(484).Graph;let util=__webpack_require__(482);module.exports={positionX:positionX,findType1Conflicts:findType1Conflicts,findType2Conflicts:findType2Conflicts,addConflict:addConflict,hasConflict:hasConflict,verticalAlignment:verticalAlignment,horizontalCompaction:horizontalCompaction,alignCoordinates:alignCoordinates,findSmallestWidthAlignment:findSmallestWidthAlignment,balance:balance};function findType1Conflicts(g,layering){let conflicts={};function visitLayer(prevLayer,layer){let k0=0,scanPos=0,prevLayerLength=prevLayer.length,lastNode=layer[layer.length-1];layer.forEach((v,i)=>{let w=findOtherInnerSegmentNode(g,v),k1=w?g.node(w).order:prevLayerLength;if(w||v===lastNode){layer.slice(scanPos,i+1).forEach(scanNode=>{g.predecessors(scanNode).forEach(u=>{let uLabel=g.node(u),uPos=uLabel.order;if((uPos<k0||k1<uPos)&&!(uLabel.dummy&&g.node(scanNode).dummy)){addConflict(conflicts,u,scanNode)}})});scanPos=i+1;k0=k1}});return layer}layering.length&&layering.reduce(visitLayer);return conflicts}function findType2Conflicts(g,layering){let conflicts={};function scan(south,southPos,southEnd,prevNorthBorder,nextNorthBorder){let v;util.range(southPos,southEnd).forEach(i=>{v=south[i];if(g.node(v).dummy){g.predecessors(v).forEach(u=>{let uNode=g.node(u);if(uNode.dummy&&(uNode.order<prevNorthBorder||uNode.order>nextNorthBorder)){addConflict(conflicts,u,v)}})}})}function visitLayer(north,south){let prevNorthPos=-1,nextNorthPos,southPos=0;south.forEach((v,southLookahead)=>{if(g.node(v).dummy==="border"){let predecessors=g.predecessors(v);if(predecessors.length){nextNorthPos=g.node(predecessors[0]).order;scan(south,southPos,southLookahead,prevNorthPos,nextNorthPos);southPos=southLookahead;prevNorthPos=nextNorthPos}}scan(south,southPos,south.length,nextNorthPos,north.length)});return south}layering.length&&layering.reduce(visitLayer);return conflicts}function findOtherInnerSegmentNode(g,v){if(g.node(v).dummy){return g.predecessors(v).find(u=>g.node(u).dummy)}}function addConflict(conflicts,v,w){if(v>w){let tmp=v;v=w;w=tmp}let conflictsV=conflicts[v];if(!conflictsV){conflicts[v]=conflictsV={}}conflictsV[w]=true}function hasConflict(conflicts,v,w){if(v>w){let tmp=v;v=w;w=tmp}return!!conflicts[v]&&Object.hasOwn(conflicts[v],w)}function verticalAlignment(g,layering,conflicts,neighborFn){let root={},align={},pos={};layering.forEach(layer=>{layer.forEach((v,order)=>{root[v]=v;align[v]=v;pos[v]=order})});layering.forEach(layer=>{let prevIdx=-1;layer.forEach(v=>{let ws=neighborFn(v);if(ws.length){ws=ws.sort((a,b)=>pos[a]-pos[b]);let mp=(ws.length-1)/2;for(let i=Math.floor(mp),il=Math.ceil(mp);i<=il;++i){let w=ws[i];if(align[v]===v&&prevIdx<pos[w]&&!hasConflict(conflicts,v,w)){align[w]=v;align[v]=root[v]=root[w];prevIdx=pos[w]}}}})});return{root:root,align:align}}function horizontalCompaction(g,layering,root,align,reverseSep){let xs={},blockG=buildBlockGraph(g,layering,root,reverseSep),borderType=reverseSep?"borderLeft":"borderRight";function iterate(setXsFunc,nextNodesFunc){let stack=blockG.nodes();let elem=stack.pop();let visited={};while(elem){if(visited[elem]){setXsFunc(elem)}else{visited[elem]=true;stack.push(elem);stack=stack.concat(nextNodesFunc(elem))}elem=stack.pop()}}function pass1(elem){xs[elem]=blockG.inEdges(elem).reduce((acc,e)=>Math.max(acc,xs[e.v]+blockG.edge(e)),0)}function pass2(elem){let min=blockG.outEdges(elem).reduce((acc,e)=>Math.min(acc,xs[e.w]-blockG.edge(e)),Number.POSITIVE_INFINITY);let node=g.node(elem);if(min!==Number.POSITIVE_INFINITY&&node.borderType!==borderType){xs[elem]=Math.max(xs[elem],min)}}iterate(pass1,blockG.predecessors.bind(blockG));iterate(pass2,blockG.successors.bind(blockG));Object.keys(align).forEach(v=>xs[v]=xs[root[v]]);return xs}function buildBlockGraph(g,layering,root,reverseSep){let blockGraph=new Graph,graphLabel=g.graph(),sepFn=sep(graphLabel.nodesep,graphLabel.edgesep,reverseSep);layering.forEach(layer=>{let u;layer.forEach(v=>{let vRoot=root[v];blockGraph.setNode(vRoot);if(u){var uRoot=root[u],prevMax=blockGraph.edge(uRoot,vRoot);blockGraph.setEdge(uRoot,vRoot,Math.max(sepFn(g,v,u),prevMax||0))}u=v})});return blockGraph}function findSmallestWidthAlignment(g,xss){return Object.values(xss).reduce((currentMinAndXs,xs)=>{let max=Number.NEGATIVE_INFINITY;let min=Number.POSITIVE_INFINITY;Object.entries(xs).forEach(_ref=>{let[v,x]=_ref;let halfWidth=width(g,v)/2;max=Math.max(x+halfWidth,max);min=Math.min(x-halfWidth,min)});const newMin=max-min;if(newMin<currentMinAndXs[0]){currentMinAndXs=[newMin,xs]}return currentMinAndXs},[Number.POSITIVE_INFINITY,null])[1]}function alignCoordinates(xss,alignTo){let alignToVals=Object.values(alignTo),alignToMin=util.applyWithChunking(Math.min,alignToVals),alignToMax=util.applyWithChunking(Math.max,alignToVals);["u","d"].forEach(vert=>{["l","r"].forEach(horiz=>{let alignment=vert+horiz,xs=xss[alignment];if(xs===alignTo)return;let xsVals=Object.values(xs);let delta=alignToMin-util.applyWithChunking(Math.min,xsVals);if(horiz!=="l"){delta=alignToMax-util.applyWithChunking(Math.max,xsVals)}if(delta){xss[alignment]=util.mapValues(xs,x=>x+delta)}})})}function balance(xss,align){return util.mapValues(xss.ul,(num,v)=>{if(align){return xss[align.toLowerCase()][v]}else{let xs=Object.values(xss).map(xs=>xs[v]).sort((a,b)=>a-b);return(xs[1]+xs[2])/2}})}function positionX(g){let layering=util.buildLayerMatrix(g);let conflicts=Object.assign(findType1Conflicts(g,layering),findType2Conflicts(g,layering));let xss={};let adjustedLayering;["u","d"].forEach(vert=>{adjustedLayering=vert==="u"?layering:Object.values(layering).reverse();["l","r"].forEach(horiz=>{if(horiz==="r"){adjustedLayering=adjustedLayering.map(inner=>Object.values(inner).reverse())}let neighborFn=(vert==="u"?g.predecessors:g.successors).bind(g);let align=verticalAlignment(g,adjustedLayering,conflicts,neighborFn);let xs=horizontalCompaction(g,adjustedLayering,align.root,align.align,horiz==="r");if(horiz==="r"){xs=util.mapValues(xs,x=>-x)}xss[vert+horiz]=xs})});let smallestWidth=findSmallestWidthAlignment(g,xss);alignCoordinates(xss,smallestWidth);return balance(xss,g.graph().align)}function sep(nodeSep,edgeSep,reverseSep){return(g,v,w)=>{let vLabel=g.node(v);let wLabel=g.node(w);let sum=0;let delta;sum+=vLabel.width/2;if(Object.hasOwn(vLabel,"labelpos")){switch(vLabel.labelpos.toLowerCase()){case"l":delta=-vLabel.width/2;break;case"r":delta=vLabel.width/2;break}}if(delta){sum+=reverseSep?delta:-delta}delta=0;sum+=(vLabel.dummy?edgeSep:nodeSep)/2;sum+=(wLabel.dummy?edgeSep:nodeSep)/2;sum+=wLabel.width/2;if(Object.hasOwn(wLabel,"labelpos")){switch(wLabel.labelpos.toLowerCase()){case"l":delta=wLabel.width/2;break;case"r":delta=-wLabel.width/2;break}}if(delta){sum+=reverseSep?delta:-delta}delta=0;return sum}}function width(g,v){return g.node(v).width}},1060:function(module,exports,__webpack_require__){let util=__webpack_require__(482);let Graph=__webpack_require__(484).Graph;module.exports={debugOrdering:debugOrdering};function debugOrdering(g){let layerMatrix=util.buildLayerMatrix(g);let h=new Graph({compound:true,multigraph:true}).setGraph({});g.nodes().forEach(v=>{h.setNode(v,{label:v});h.setParent(v,"layer"+g.node(v).rank)});g.edges().forEach(e=>h.setEdge(e.v,e.w,{},e.name));layerMatrix.forEach((layer,i)=>{let layerV="layer"+i;h.setNode(layerV,{rank:"same"});layer.reduce((u,v)=>{h.setEdge(u,v,{style:"invis"});return v})});return h}},1061:function(module,exports){module.exports="1.1.5"},1062:function(module,exports,__webpack_require__){var api=__webpack_require__(7);var content=__webpack_require__(1063);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},1063:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var _css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0__);var ___CSS_LOADER_EXPORT___=_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_0___default()((function(i){return i[1]}));___CSS_LOADER_EXPORT___.push([module.i,".react-flow {\n  direction: ltr;\n\n  --xy-edge-stroke-default: #b1b1b7;\n  --xy-edge-stroke-width-default: 1;\n  --xy-edge-stroke-selected-default: #555;\n\n  --xy-connectionline-stroke-default: #b1b1b7;\n  --xy-connectionline-stroke-width-default: 1;\n\n  --xy-attribution-background-color-default: rgba(255, 255, 255, 0.5);\n\n  --xy-minimap-background-color-default: #fff;\n  --xy-minimap-mask-background-color-default: rgba(240, 240, 240, 0.6);\n  --xy-minimap-mask-stroke-color-default: transparent;\n  --xy-minimap-mask-stroke-width-default: 1;\n  --xy-minimap-node-background-color-default: #e2e2e2;\n  --xy-minimap-node-stroke-color-default: transparent;\n  --xy-minimap-node-stroke-width-default: 2;\n\n  --xy-background-color-default: transparent;\n  --xy-background-pattern-dots-color-default: #91919a;\n  --xy-background-pattern-lines-color-default: #eee;\n  --xy-background-pattern-cross-color-default: #e2e2e2;\n  background-color: var(--xy-background-color, var(--xy-background-color-default));\n  --xy-node-color-default: inherit;\n  --xy-node-border-default: 1px solid #1a192b;\n  --xy-node-background-color-default: #fff;\n  --xy-node-group-background-color-default: rgba(240, 240, 240, 0.25);\n  --xy-node-boxshadow-hover-default: 0 1px 4px 1px rgba(0, 0, 0, 0.08);\n  --xy-node-boxshadow-selected-default: 0 0 0 0.5px #1a192b;\n  --xy-node-border-radius-default: 3px;\n\n  --xy-handle-background-color-default: #1a192b;\n  --xy-handle-border-color-default: #fff;\n\n  --xy-selection-background-color-default: rgba(0, 89, 220, 0.08);\n  --xy-selection-border-default: 1px dotted rgba(0, 89, 220, 0.8);\n\n  --xy-controls-button-background-color-default: #fefefe;\n  --xy-controls-button-background-color-hover-default: #f4f4f4;\n  --xy-controls-button-color-default: inherit;\n  --xy-controls-button-color-hover-default: inherit;\n  --xy-controls-button-border-color-default: #eee;\n  --xy-controls-box-shadow-default: 0 0 2px 1px rgba(0, 0, 0, 0.08);\n\n  --xy-edge-label-background-color-default: #ffffff;\n  --xy-edge-label-color-default: inherit;\n  --xy-resize-background-color-default: #3367d9;\n}\n.react-flow.dark {\n  --xy-edge-stroke-default: #3e3e3e;\n  --xy-edge-stroke-width-default: 1;\n  --xy-edge-stroke-selected-default: #727272;\n\n  --xy-connectionline-stroke-default: #b1b1b7;\n  --xy-connectionline-stroke-width-default: 1;\n\n  --xy-attribution-background-color-default: rgba(150, 150, 150, 0.25);\n\n  --xy-minimap-background-color-default: #141414;\n  --xy-minimap-mask-background-color-default: rgba(60, 60, 60, 0.6);\n  --xy-minimap-mask-stroke-color-default: transparent;\n  --xy-minimap-mask-stroke-width-default: 1;\n  --xy-minimap-node-background-color-default: #2b2b2b;\n  --xy-minimap-node-stroke-color-default: transparent;\n  --xy-minimap-node-stroke-width-default: 2;\n\n  --xy-background-color-default: #141414;\n  --xy-background-pattern-dots-color-default: #777;\n  --xy-background-pattern-lines-color-default: #777;\n  --xy-background-pattern-cross-color-default: #777;\n  --xy-node-color-default: #f8f8f8;\n  --xy-node-border-default: 1px solid #3c3c3c;\n  --xy-node-background-color-default: #1e1e1e;\n  --xy-node-group-background-color-default: rgba(240, 240, 240, 0.25);\n  --xy-node-boxshadow-hover-default: 0 1px 4px 1px rgba(255, 255, 255, 0.08);\n  --xy-node-boxshadow-selected-default: 0 0 0 0.5px #999;\n\n  --xy-handle-background-color-default: #bebebe;\n  --xy-handle-border-color-default: #1e1e1e;\n\n  --xy-selection-background-color-default: rgba(200, 200, 220, 0.08);\n  --xy-selection-border-default: 1px dotted rgba(200, 200, 220, 0.8);\n\n  --xy-controls-button-background-color-default: #2b2b2b;\n  --xy-controls-button-background-color-hover-default: #3e3e3e;\n  --xy-controls-button-color-default: #f8f8f8;\n  --xy-controls-button-color-hover-default: #fff;\n  --xy-controls-button-border-color-default: #5b5b5b;\n  --xy-controls-box-shadow-default: 0 0 2px 1px rgba(0, 0, 0, 0.08);\n\n  --xy-edge-label-background-color-default: #141414;\n  --xy-edge-label-color-default: #f8f8f8;\n}\n.react-flow__background {\n  background-color: var(--xy-background-color-props, var(--xy-background-color, var(--xy-background-color-default)));\n  pointer-events: none;\n  z-index: -1;\n}\n.react-flow__container {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  top: 0;\n  left: 0;\n}\n.react-flow__pane {\n  z-index: 1;\n}\n.react-flow__pane.draggable {\n    cursor: grab;\n  }\n.react-flow__pane.dragging {\n    cursor: grabbing;\n  }\n.react-flow__pane.selection {\n    cursor: pointer;\n  }\n.react-flow__viewport {\n  transform-origin: 0 0;\n  z-index: 2;\n  pointer-events: none;\n}\n.react-flow__renderer {\n  z-index: 4;\n}\n.react-flow__selection {\n  z-index: 6;\n}\n.react-flow__nodesselection-rect:focus,\n.react-flow__nodesselection-rect:focus-visible {\n  outline: none;\n}\n.react-flow__edge-path {\n  stroke: var(--xy-edge-stroke, var(--xy-edge-stroke-default));\n  stroke-width: var(--xy-edge-stroke-width, var(--xy-edge-stroke-width-default));\n  fill: none;\n}\n.react-flow__connection-path {\n  stroke: var(--xy-connectionline-stroke, var(--xy-connectionline-stroke-default));\n  stroke-width: var(--xy-connectionline-stroke-width, var(--xy-connectionline-stroke-width-default));\n  fill: none;\n}\n.react-flow .react-flow__edges {\n  position: absolute;\n}\n.react-flow .react-flow__edges svg {\n    overflow: visible;\n    position: absolute;\n    pointer-events: none;\n  }\n.react-flow__edge {\n  pointer-events: visibleStroke;\n}\n.react-flow__edge.selectable {\n    cursor: pointer;\n  }\n.react-flow__edge.animated path {\n    stroke-dasharray: 5;\n    animation: dashdraw 0.5s linear infinite;\n  }\n.react-flow__edge.animated path.react-flow__edge-interaction {\n    stroke-dasharray: none;\n    animation: none;\n  }\n.react-flow__edge.inactive {\n    pointer-events: none;\n  }\n.react-flow__edge.selected,\n  .react-flow__edge:focus,\n  .react-flow__edge:focus-visible {\n    outline: none;\n  }\n.react-flow__edge.selected .react-flow__edge-path,\n  .react-flow__edge.selectable:focus .react-flow__edge-path,\n  .react-flow__edge.selectable:focus-visible .react-flow__edge-path {\n    stroke: var(--xy-edge-stroke-selected, var(--xy-edge-stroke-selected-default));\n  }\n.react-flow__edge-textwrapper {\n    pointer-events: all;\n  }\n.react-flow__edge .react-flow__edge-text {\n    pointer-events: none;\n    -webkit-user-select: none;\n       -moz-user-select: none;\n            user-select: none;\n  }\n.react-flow__connection {\n  pointer-events: none;\n}\n.react-flow__connection .animated {\n    stroke-dasharray: 5;\n    animation: dashdraw 0.5s linear infinite;\n  }\nsvg.react-flow__connectionline {\n  z-index: 1001;\n  overflow: visible;\n  position: absolute;\n}\n.react-flow__nodes {\n  pointer-events: none;\n  transform-origin: 0 0;\n}\n.react-flow__node {\n  position: absolute;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n          user-select: none;\n  pointer-events: all;\n  transform-origin: 0 0;\n  box-sizing: border-box;\n  cursor: default;\n}\n.react-flow__node.selectable {\n    cursor: pointer;\n  }\n.react-flow__node.draggable {\n    cursor: grab;\n    pointer-events: all;\n  }\n.react-flow__node.draggable.dragging {\n      cursor: grabbing;\n    }\n.react-flow__nodesselection {\n  z-index: 3;\n  transform-origin: left top;\n  pointer-events: none;\n}\n.react-flow__nodesselection-rect {\n    position: absolute;\n    pointer-events: all;\n    cursor: grab;\n  }\n.react-flow__handle {\n  position: absolute;\n  pointer-events: none;\n  min-width: 5px;\n  min-height: 5px;\n  width: 6px;\n  height: 6px;\n  background-color: var(--xy-handle-background-color, var(--xy-handle-background-color-default));\n  border: 1px solid var(--xy-handle-border-color, var(--xy-handle-border-color-default));\n  border-radius: 100%;\n}\n.react-flow__handle.connectingfrom {\n    pointer-events: all;\n  }\n.react-flow__handle.connectionindicator {\n    pointer-events: all;\n    cursor: crosshair;\n  }\n.react-flow__handle-bottom {\n    top: auto;\n    left: 50%;\n    bottom: 0;\n    transform: translate(-50%, 50%);\n  }\n.react-flow__handle-top {\n    top: 0;\n    left: 50%;\n    transform: translate(-50%, -50%);\n  }\n.react-flow__handle-left {\n    top: 50%;\n    left: 0;\n    transform: translate(-50%, -50%);\n  }\n.react-flow__handle-right {\n    top: 50%;\n    right: 0;\n    transform: translate(50%, -50%);\n  }\n.react-flow__edgeupdater {\n  cursor: move;\n  pointer-events: all;\n}\n.react-flow__pane.selection .react-flow__panel {\n  pointer-events: none;\n}\n.react-flow__panel {\n  position: absolute;\n  z-index: 5;\n  margin: 15px;\n}\n.react-flow__panel.top {\n    top: 0;\n  }\n.react-flow__panel.bottom {\n    bottom: 0;\n  }\n.react-flow__panel.top.center, .react-flow__panel.bottom.center {\n      left: 50%;\n      transform: translateX(-15px) translateX(-50%);\n    }\n.react-flow__panel.left {\n    left: 0;\n  }\n.react-flow__panel.right {\n    right: 0;\n  }\n.react-flow__panel.left.center, .react-flow__panel.right.center {\n      top: 50%;\n      transform: translateY(-15px) translateY(-50%);\n    }\n.react-flow__attribution {\n  font-size: 10px;\n  background: var(--xy-attribution-background-color, var(--xy-attribution-background-color-default));\n  padding: 2px 3px;\n  margin: 0;\n}\n.react-flow__attribution a {\n    text-decoration: none;\n    color: #999;\n  }\n@keyframes dashdraw {\n  from {\n    stroke-dashoffset: 10;\n  }\n}\n.react-flow__edgelabel-renderer {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  pointer-events: none;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n          user-select: none;\n  left: 0;\n  top: 0;\n}\n.react-flow__viewport-portal {\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  left: 0;\n  top: 0;\n  -webkit-user-select: none;\n     -moz-user-select: none;\n          user-select: none;\n}\n.react-flow__minimap {\n  background: var(\n    --xy-minimap-background-color-props,\n    var(--xy-minimap-background-color, var(--xy-minimap-background-color-default))\n  );\n}\n.react-flow__minimap-svg {\n    display: block;\n  }\n.react-flow__minimap-mask {\n    fill: var(\n      --xy-minimap-mask-background-color-props,\n      var(--xy-minimap-mask-background-color, var(--xy-minimap-mask-background-color-default))\n    );\n    stroke: var(\n      --xy-minimap-mask-stroke-color-props,\n      var(--xy-minimap-mask-stroke-color, var(--xy-minimap-mask-stroke-color-default))\n    );\n    stroke-width: var(\n      --xy-minimap-mask-stroke-width-props,\n      var(--xy-minimap-mask-stroke-width, var(--xy-minimap-mask-stroke-width-default))\n    );\n  }\n.react-flow__minimap-node {\n    fill: var(\n      --xy-minimap-node-background-color-props,\n      var(--xy-minimap-node-background-color, var(--xy-minimap-node-background-color-default))\n    );\n    stroke: var(\n      --xy-minimap-node-stroke-color-props,\n      var(--xy-minimap-node-stroke-color, var(--xy-minimap-node-stroke-color-default))\n    );\n    stroke-width: var(\n      --xy-minimap-node-stroke-width-props,\n      var(--xy-minimap-node-stroke-width, var(--xy-minimap-node-stroke-width-default))\n    );\n  }\n.react-flow__background-pattern.dots {\n    fill: var(\n      --xy-background-pattern-color-props,\n      var(--xy-background-pattern-color, var(--xy-background-pattern-dots-color-default))\n    );\n  }\n.react-flow__background-pattern.lines {\n    stroke: var(\n      --xy-background-pattern-color-props,\n      var(--xy-background-pattern-color, var(--xy-background-pattern-lines-color-default))\n    );\n  }\n.react-flow__background-pattern.cross {\n    stroke: var(\n      --xy-background-pattern-color-props,\n      var(--xy-background-pattern-color, var(--xy-background-pattern-cross-color-default))\n    );\n  }\n.react-flow__controls {\n  display: flex;\n  flex-direction: column;\n  box-shadow: var(--xy-controls-box-shadow, var(--xy-controls-box-shadow-default));\n}\n.react-flow__controls.horizontal {\n    flex-direction: row;\n  }\n.react-flow__controls-button {\n    display: flex;\n    justify-content: center;\n    align-items: center;\n    height: 26px;\n    width: 26px;\n    padding: 4px;\n    border: none;\n    background: var(--xy-controls-button-background-color, var(--xy-controls-button-background-color-default));\n    border-bottom: 1px solid\n      var(\n        --xy-controls-button-border-color-props,\n        var(--xy-controls-button-border-color, var(--xy-controls-button-border-color-default))\n      );\n    color: var(\n      --xy-controls-button-color-props,\n      var(--xy-controls-button-color, var(--xy-controls-button-color-default))\n    );\n    cursor: pointer;\n    -webkit-user-select: none;\n       -moz-user-select: none;\n            user-select: none;\n  }\n.react-flow__controls-button svg {\n      width: 100%;\n      max-width: 12px;\n      max-height: 12px;\n      fill: currentColor;\n    }\n.react-flow__edge.updating .react-flow__edge-path {\n      stroke: #777;\n    }\n.react-flow__edge-text {\n    font-size: 10px;\n  }\n.react-flow__node.selectable:focus,\n  .react-flow__node.selectable:focus-visible {\n    outline: none;\n  }\n.react-flow__node-input,\n.react-flow__node-default,\n.react-flow__node-output,\n.react-flow__node-group {\n  padding: 10px;\n  border-radius: var(--xy-node-border-radius, var(--xy-node-border-radius-default));\n  width: 150px;\n  font-size: 12px;\n  color: var(--xy-node-color, var(--xy-node-color-default));\n  text-align: center;\n  border: var(--xy-node-border, var(--xy-node-border-default));\n  background-color: var(--xy-node-background-color, var(--xy-node-background-color-default));\n}\n.react-flow__node-input.selectable:hover, .react-flow__node-default.selectable:hover, .react-flow__node-output.selectable:hover, .react-flow__node-group.selectable:hover {\n      box-shadow: var(--xy-node-boxshadow-hover, var(--xy-node-boxshadow-hover-default));\n    }\n.react-flow__node-input.selectable.selected,\n    .react-flow__node-input.selectable:focus,\n    .react-flow__node-input.selectable:focus-visible,\n    .react-flow__node-default.selectable.selected,\n    .react-flow__node-default.selectable:focus,\n    .react-flow__node-default.selectable:focus-visible,\n    .react-flow__node-output.selectable.selected,\n    .react-flow__node-output.selectable:focus,\n    .react-flow__node-output.selectable:focus-visible,\n    .react-flow__node-group.selectable.selected,\n    .react-flow__node-group.selectable:focus,\n    .react-flow__node-group.selectable:focus-visible {\n      box-shadow: var(--xy-node-boxshadow-selected, var(--xy-node-boxshadow-selected-default));\n    }\n.react-flow__node-group {\n  background-color: var(--xy-node-group-background-color, var(--xy-node-group-background-color-default));\n}\n.react-flow__nodesselection-rect,\n.react-flow__selection {\n  background: var(--xy-selection-background-color, var(--xy-selection-background-color-default));\n  border: var(--xy-selection-border, var(--xy-selection-border-default));\n}\n.react-flow__nodesselection-rect:focus,\n  .react-flow__nodesselection-rect:focus-visible,\n  .react-flow__selection:focus,\n  .react-flow__selection:focus-visible {\n    outline: none;\n  }\n.react-flow__controls-button:hover {\n      background: var(\n        --xy-controls-button-background-color-hover-props,\n        var(--xy-controls-button-background-color-hover, var(--xy-controls-button-background-color-hover-default))\n      );\n      color: var(\n        --xy-controls-button-color-hover-props,\n        var(--xy-controls-button-color-hover, var(--xy-controls-button-color-hover-default))\n      );\n    }\n.react-flow__controls-button:disabled {\n      pointer-events: none;\n    }\n.react-flow__controls-button:disabled svg {\n        fill-opacity: 0.4;\n      }\n.react-flow__controls-button:last-child {\n    border-bottom: none;\n  }\n.react-flow__controls.horizontal .react-flow__controls-button {\n    border-bottom: none;\n    border-right: 1px solid\n      var(\n        --xy-controls-button-border-color-props,\n        var(--xy-controls-button-border-color, var(--xy-controls-button-border-color-default))\n      );\n  }\n.react-flow__controls.horizontal .react-flow__controls-button:last-child {\n    border-right: none;\n  }\n.react-flow__resize-control {\n  position: absolute;\n}\n.react-flow__resize-control.left,\n.react-flow__resize-control.right {\n  cursor: ew-resize;\n}\n.react-flow__resize-control.top,\n.react-flow__resize-control.bottom {\n  cursor: ns-resize;\n}\n.react-flow__resize-control.top.left,\n.react-flow__resize-control.bottom.right {\n  cursor: nwse-resize;\n}\n.react-flow__resize-control.bottom.left,\n.react-flow__resize-control.top.right {\n  cursor: nesw-resize;\n}\n.react-flow__resize-control.handle {\n  width: 5px;\n  height: 5px;\n  border: 1px solid #fff;\n  border-radius: 1px;\n  background-color: var(--xy-resize-background-color, var(--xy-resize-background-color-default));\n  translate: -50% -50%;\n}\n.react-flow__resize-control.handle.left {\n  left: 0;\n  top: 50%;\n}\n.react-flow__resize-control.handle.right {\n  left: 100%;\n  top: 50%;\n}\n.react-flow__resize-control.handle.top {\n  left: 50%;\n  top: 0;\n}\n.react-flow__resize-control.handle.bottom {\n  left: 50%;\n  top: 100%;\n}\n.react-flow__resize-control.handle.top.left {\n  left: 0;\n}\n.react-flow__resize-control.handle.bottom.left {\n  left: 0;\n}\n.react-flow__resize-control.handle.top.right {\n  left: 100%;\n}\n.react-flow__resize-control.handle.bottom.right {\n  left: 100%;\n}\n.react-flow__resize-control.line {\n  border-color: var(--xy-resize-background-color, var(--xy-resize-background-color-default));\n  border-width: 0;\n  border-style: solid;\n}\n.react-flow__resize-control.line.left,\n.react-flow__resize-control.line.right {\n  width: 1px;\n  transform: translate(-50%, 0);\n  top: 0;\n  height: 100%;\n}\n.react-flow__resize-control.line.left {\n  left: 0;\n  border-left-width: 1px;\n}\n.react-flow__resize-control.line.right {\n  left: 100%;\n  border-right-width: 1px;\n}\n.react-flow__resize-control.line.top,\n.react-flow__resize-control.line.bottom {\n  height: 1px;\n  transform: translate(0, -50%);\n  left: 0;\n  width: 100%;\n}\n.react-flow__resize-control.line.top {\n  top: 0;\n  border-top-width: 1px;\n}\n.react-flow__resize-control.line.bottom {\n  border-bottom-width: 1px;\n  top: 100%;\n}\n.react-flow__edge-textbg {\n  fill: var(--xy-edge-label-background-color, var(--xy-edge-label-background-color-default));\n}\n.react-flow__edge-text {\n  fill: var(--xy-edge-label-color, var(--xy-edge-label-color-default));\n}\n",""]);__webpack_exports__["default"]=___CSS_LOADER_EXPORT___},1077:function(module,exports,__webpack_require__){!function(e,t){true?t(exports,__webpack_require__(1078),__webpack_require__(0),__webpack_require__(149)):undefined}(this,(function(e,t,n,o){"use strict";function r(e){if("string"==typeof e||"number"==typeof e)return""+e;let t="";if(Array.isArray(e))for(let n,o=0;o<e.length;o++)""!==(n=r(e[o]))&&(t+=(t&&" ")+n);else for(let n in e)e[n]&&(t+=(t&&" ")+n);return t}var i={value:()=>{}};function a(){for(var e,t=0,n=arguments.length,o={};t<n;++t){if(!(e=arguments[t]+"")||e in o||/[\s.]/.test(e))throw new Error("illegal type: "+e);o[e]=[]}return new s(o)}function s(e){this._=e}function l(e,t){for(var n,o=0,r=e.length;o<r;++o)if((n=e[o]).name===t)return n.value}function c(e,t,n){for(var o=0,r=e.length;o<r;++o)if(e[o].name===t){e[o]=i,e=e.slice(0,o).concat(e.slice(o+1));break}return null!=n&&e.push({name:t,value:n}),e}s.prototype=a.prototype={constructor:s,on:function(e,t){var n,o,r=this._,i=(o=r,(e+"").trim().split(/^|\s+/).map((function(e){var t="",n=e.indexOf(".");if(n>=0&&(t=e.slice(n+1),e=e.slice(0,n)),e&&!o.hasOwnProperty(e))throw new Error("unknown type: "+e);return{type:e,name:t}}))),a=-1,s=i.length;if(!(arguments.length<2)){if(null!=t&&"function"!=typeof t)throw new Error("invalid callback: "+t);for(;++a<s;)if(n=(e=i[a]).type)r[n]=c(r[n],e.name,t);else if(null==t)for(n in r)r[n]=c(r[n],e.name,null);return this}for(;++a<s;)if((n=(e=i[a]).type)&&(n=l(r[n],e.name)))return n},copy:function(){var e={},t=this._;for(var n in t)e[n]=t[n].slice();return new s(e)},call:function(e,t){if((n=arguments.length-2)>0)for(var n,o,r=new Array(n),i=0;i<n;++i)r[i]=arguments[i+2];if(!this._.hasOwnProperty(e))throw new Error("unknown type: "+e);for(i=0,n=(o=this._[e]).length;i<n;++i)o[i].value.apply(t,r)},apply:function(e,t,n){if(!this._.hasOwnProperty(e))throw new Error("unknown type: "+e);for(var o=this._[e],r=0,i=o.length;r<i;++r)o[r].value.apply(t,n)}};var u="http://www.w3.org/1999/xhtml",d={svg:"http://www.w3.org/2000/svg",xhtml:u,xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};function h(e){var t=e+="",n=t.indexOf(":");return n>=0&&"xmlns"!==(t=e.slice(0,n))&&(e=e.slice(n+1)),d.hasOwnProperty(t)?{space:d[t],local:e}:e}function f(e){return function(){var t=this.ownerDocument,n=this.namespaceURI;return n===u&&t.documentElement.namespaceURI===u?t.createElement(e):t.createElementNS(n,e)}}function g(e){return function(){return this.ownerDocument.createElementNS(e.space,e.local)}}function p(e){var t=h(e);return(t.local?g:f)(t)}function m(){}function y(e){return null==e?m:function(){return this.querySelector(e)}}function v(){return[]}function x(e){return null==e?v:function(){return this.querySelectorAll(e)}}function w(e){return function(){return null==(t=e.apply(this,arguments))?[]:Array.isArray(t)?t:Array.from(t);var t}}function b(e){return function(){return this.matches(e)}}function S(e){return function(t){return t.matches(e)}}var C=Array.prototype.find;function E(){return this.firstElementChild}var k=Array.prototype.filter;function M(){return Array.from(this.children)}function N(e){return new Array(e.length)}function _(e,t){this.ownerDocument=e.ownerDocument,this.namespaceURI=e.namespaceURI,this._next=null,this._parent=e,this.__data__=t}function P(e,t,n,o,r,i){for(var a,s=0,l=t.length,c=i.length;s<c;++s)(a=t[s])?(a.__data__=i[s],o[s]=a):n[s]=new _(e,i[s]);for(;s<l;++s)(a=t[s])&&(r[s]=a)}function z(e,t,n,o,r,i,a){var s,l,c,u=new Map,d=t.length,h=i.length,f=new Array(d);for(s=0;s<d;++s)(l=t[s])&&(f[s]=c=a.call(l,l.__data__,s,t)+"",u.has(c)?r[s]=l:u.set(c,l));for(s=0;s<h;++s)c=a.call(e,i[s],s,i)+"",(l=u.get(c))?(o[s]=l,l.__data__=i[s],u.delete(c)):n[s]=new _(e,i[s]);for(s=0;s<d;++s)(l=t[s])&&u.get(f[s])===l&&(r[s]=l)}function O(e){return e.__data__}function A(e){return"object"==typeof e&&"length"in e?e:Array.from(e)}function D(e,t){return e<t?-1:e>t?1:e>=t?0:NaN}function I(e){return function(){this.removeAttribute(e)}}function R(e){return function(){this.removeAttributeNS(e.space,e.local)}}function L(e,t){return function(){this.setAttribute(e,t)}}function $(e,t){return function(){this.setAttributeNS(e.space,e.local,t)}}function T(e,t){return function(){var n=t.apply(this,arguments);null==n?this.removeAttribute(e):this.setAttribute(e,n)}}function V(e,t){return function(){var n=t.apply(this,arguments);null==n?this.removeAttributeNS(e.space,e.local):this.setAttributeNS(e.space,e.local,n)}}function B(e){return e.ownerDocument&&e.ownerDocument.defaultView||e.document&&e||e.defaultView}function j(e){return function(){this.style.removeProperty(e)}}function H(e,t,n){return function(){this.style.setProperty(e,t,n)}}function Z(e,t,n){return function(){var o=t.apply(this,arguments);null==o?this.style.removeProperty(e):this.style.setProperty(e,o,n)}}function X(e,t){return e.style.getPropertyValue(t)||B(e).getComputedStyle(e,null).getPropertyValue(t)}function Y(e){return function(){delete this[e]}}function F(e,t){return function(){this[e]=t}}function W(e,t){return function(){var n=t.apply(this,arguments);null==n?delete this[e]:this[e]=n}}function K(e){return e.trim().split(/^|\s+/)}function G(e){return e.classList||new q(e)}function q(e){this._node=e,this._names=K(e.getAttribute("class")||"")}function U(e,t){for(var n=G(e),o=-1,r=t.length;++o<r;)n.add(t[o])}function Q(e,t){for(var n=G(e),o=-1,r=t.length;++o<r;)n.remove(t[o])}function J(e){return function(){U(this,e)}}function ee(e){return function(){Q(this,e)}}function te(e,t){return function(){(t.apply(this,arguments)?U:Q)(this,e)}}function ne(){this.textContent=""}function oe(e){return function(){this.textContent=e}}function re(e){return function(){var t=e.apply(this,arguments);this.textContent=null==t?"":t}}function ie(){this.innerHTML=""}function ae(e){return function(){this.innerHTML=e}}function se(e){return function(){var t=e.apply(this,arguments);this.innerHTML=null==t?"":t}}function le(){this.nextSibling&&this.parentNode.appendChild(this)}function ce(){this.previousSibling&&this.parentNode.insertBefore(this,this.parentNode.firstChild)}function ue(){return null}function de(){var e=this.parentNode;e&&e.removeChild(this)}function he(){var e=this.cloneNode(!1),t=this.parentNode;return t?t.insertBefore(e,this.nextSibling):e}function fe(){var e=this.cloneNode(!0),t=this.parentNode;return t?t.insertBefore(e,this.nextSibling):e}function ge(e){return function(){var t=this.__on;if(t){for(var n,o=0,r=-1,i=t.length;o<i;++o)n=t[o],e.type&&n.type!==e.type||n.name!==e.name?t[++r]=n:this.removeEventListener(n.type,n.listener,n.options);++r?t.length=r:delete this.__on}}}function pe(e,t,n){return function(){var o,r=this.__on,i=function(e){return function(t){e.call(this,t,this.__data__)}}(t);if(r)for(var a=0,s=r.length;a<s;++a)if((o=r[a]).type===e.type&&o.name===e.name)return this.removeEventListener(o.type,o.listener,o.options),this.addEventListener(o.type,o.listener=i,o.options=n),void(o.value=t);this.addEventListener(e.type,i,n),o={type:e.type,name:e.name,value:t,listener:i,options:n},r?r.push(o):this.__on=[o]}}function me(e,t,n){var o=B(e),r=o.CustomEvent;"function"==typeof r?r=new r(t,n):(r=o.document.createEvent("Event"),n?(r.initEvent(t,n.bubbles,n.cancelable),r.detail=n.detail):r.initEvent(t,!1,!1)),e.dispatchEvent(r)}function ye(e,t){return function(){return me(this,e,t)}}function ve(e,t){return function(){return me(this,e,t.apply(this,arguments))}}_.prototype={constructor:_,appendChild:function(e){return this._parent.insertBefore(e,this._next)},insertBefore:function(e,t){return this._parent.insertBefore(e,t)},querySelector:function(e){return this._parent.querySelector(e)},querySelectorAll:function(e){return this._parent.querySelectorAll(e)}},q.prototype={add:function(e){this._names.indexOf(e)<0&&(this._names.push(e),this._node.setAttribute("class",this._names.join(" ")))},remove:function(e){var t=this._names.indexOf(e);t>=0&&(this._names.splice(t,1),this._node.setAttribute("class",this._names.join(" ")))},contains:function(e){return this._names.indexOf(e)>=0}};var xe=[null];function we(e,t){this._groups=e,this._parents=t}function be(){return new we([[document.documentElement]],xe)}function Se(e){return"string"==typeof e?new we([[document.querySelector(e)]],[document.documentElement]):new we([[e]],xe)}function Ce(e,t){if(e=function(e){let t;for(;t=e.sourceEvent;)e=t;return e}(e),void 0===t&&(t=e.currentTarget),t){var n=t.ownerSVGElement||t;if(n.createSVGPoint){var o=n.createSVGPoint();return o.x=e.clientX,o.y=e.clientY,[(o=o.matrixTransform(t.getScreenCTM().inverse())).x,o.y]}if(t.getBoundingClientRect){var r=t.getBoundingClientRect();return[e.clientX-r.left-t.clientLeft,e.clientY-r.top-t.clientTop]}}return[e.pageX,e.pageY]}we.prototype=be.prototype={constructor:we,select:function(e){"function"!=typeof e&&(e=y(e));for(var t=this._groups,n=t.length,o=new Array(n),r=0;r<n;++r)for(var i,a,s=t[r],l=s.length,c=o[r]=new Array(l),u=0;u<l;++u)(i=s[u])&&(a=e.call(i,i.__data__,u,s))&&("__data__"in i&&(a.__data__=i.__data__),c[u]=a);return new we(o,this._parents)},selectAll:function(e){e="function"==typeof e?w(e):x(e);for(var t=this._groups,n=t.length,o=[],r=[],i=0;i<n;++i)for(var a,s=t[i],l=s.length,c=0;c<l;++c)(a=s[c])&&(o.push(e.call(a,a.__data__,c,s)),r.push(a));return new we(o,r)},selectChild:function(e){return this.select(null==e?E:function(e){return function(){return C.call(this.children,e)}}("function"==typeof e?e:S(e)))},selectChildren:function(e){return this.selectAll(null==e?M:function(e){return function(){return k.call(this.children,e)}}("function"==typeof e?e:S(e)))},filter:function(e){"function"!=typeof e&&(e=b(e));for(var t=this._groups,n=t.length,o=new Array(n),r=0;r<n;++r)for(var i,a=t[r],s=a.length,l=o[r]=[],c=0;c<s;++c)(i=a[c])&&e.call(i,i.__data__,c,a)&&l.push(i);return new we(o,this._parents)},data:function(e,t){if(!arguments.length)return Array.from(this,O);var n,o=t?z:P,r=this._parents,i=this._groups;"function"!=typeof e&&(n=e,e=function(){return n});for(var a=i.length,s=new Array(a),l=new Array(a),c=new Array(a),u=0;u<a;++u){var d=r[u],h=i[u],f=h.length,g=A(e.call(d,d&&d.__data__,u,r)),p=g.length,m=l[u]=new Array(p),y=s[u]=new Array(p);o(d,h,m,y,c[u]=new Array(f),g,t);for(var v,x,w=0,b=0;w<p;++w)if(v=m[w]){for(w>=b&&(b=w+1);!(x=y[b])&&++b<p;);v._next=x||null}}return(s=new we(s,r))._enter=l,s._exit=c,s},enter:function(){return new we(this._enter||this._groups.map(N),this._parents)},exit:function(){return new we(this._exit||this._groups.map(N),this._parents)},join:function(e,t,n){var o=this.enter(),r=this,i=this.exit();return"function"==typeof e?(o=e(o))&&(o=o.selection()):o=o.append(e+""),null!=t&&(r=t(r))&&(r=r.selection()),null==n?i.remove():n(i),o&&r?o.merge(r).order():r},merge:function(e){for(var t=e.selection?e.selection():e,n=this._groups,o=t._groups,r=n.length,i=o.length,a=Math.min(r,i),s=new Array(r),l=0;l<a;++l)for(var c,u=n[l],d=o[l],h=u.length,f=s[l]=new Array(h),g=0;g<h;++g)(c=u[g]||d[g])&&(f[g]=c);for(;l<r;++l)s[l]=n[l];return new we(s,this._parents)},selection:function(){return this},order:function(){for(var e=this._groups,t=-1,n=e.length;++t<n;)for(var o,r=e[t],i=r.length-1,a=r[i];--i>=0;)(o=r[i])&&(a&&4^o.compareDocumentPosition(a)&&a.parentNode.insertBefore(o,a),a=o);return this},sort:function(e){function t(t,n){return t&&n?e(t.__data__,n.__data__):!t-!n}e||(e=D);for(var n=this._groups,o=n.length,r=new Array(o),i=0;i<o;++i){for(var a,s=n[i],l=s.length,c=r[i]=new Array(l),u=0;u<l;++u)(a=s[u])&&(c[u]=a);c.sort(t)}return new we(r,this._parents).order()},call:function(){var e=arguments[0];return arguments[0]=this,e.apply(null,arguments),this},nodes:function(){return Array.from(this)},node:function(){for(var e=this._groups,t=0,n=e.length;t<n;++t)for(var o=e[t],r=0,i=o.length;r<i;++r){var a=o[r];if(a)return a}return null},size:function(){let e=0;for(const t of this)++e;return e},empty:function(){return!this.node()},each:function(e){for(var t=this._groups,n=0,o=t.length;n<o;++n)for(var r,i=t[n],a=0,s=i.length;a<s;++a)(r=i[a])&&e.call(r,r.__data__,a,i);return this},attr:function(e,t){var n=h(e);if(arguments.length<2){var o=this.node();return n.local?o.getAttributeNS(n.space,n.local):o.getAttribute(n)}return this.each((null==t?n.local?R:I:"function"==typeof t?n.local?V:T:n.local?$:L)(n,t))},style:function(e,t,n){return arguments.length>1?this.each((null==t?j:"function"==typeof t?Z:H)(e,t,null==n?"":n)):X(this.node(),e)},property:function(e,t){return arguments.length>1?this.each((null==t?Y:"function"==typeof t?W:F)(e,t)):this.node()[e]},classed:function(e,t){var n=K(e+"");if(arguments.length<2){for(var o=G(this.node()),r=-1,i=n.length;++r<i;)if(!o.contains(n[r]))return!1;return!0}return this.each(("function"==typeof t?te:t?J:ee)(n,t))},text:function(e){return arguments.length?this.each(null==e?ne:("function"==typeof e?re:oe)(e)):this.node().textContent},html:function(e){return arguments.length?this.each(null==e?ie:("function"==typeof e?se:ae)(e)):this.node().innerHTML},raise:function(){return this.each(le)},lower:function(){return this.each(ce)},append:function(e){var t="function"==typeof e?e:p(e);return this.select((function(){return this.appendChild(t.apply(this,arguments))}))},insert:function(e,t){var n="function"==typeof e?e:p(e),o=null==t?ue:"function"==typeof t?t:y(t);return this.select((function(){return this.insertBefore(n.apply(this,arguments),o.apply(this,arguments)||null)}))},remove:function(){return this.each(de)},clone:function(e){return this.select(e?fe:he)},datum:function(e){return arguments.length?this.property("__data__",e):this.node().__data__},on:function(e,t,n){var o,r,i=function(e){return e.trim().split(/^|\s+/).map((function(e){var t="",n=e.indexOf(".");return n>=0&&(t=e.slice(n+1),e=e.slice(0,n)),{type:e,name:t}}))}(e+""),a=i.length;if(!(arguments.length<2)){for(s=t?pe:ge,o=0;o<a;++o)this.each(s(i[o],t,n));return this}var s=this.node().__on;if(s)for(var l,c=0,u=s.length;c<u;++c)for(o=0,l=s[c];o<a;++o)if((r=i[o]).type===l.type&&r.name===l.name)return l.value},dispatch:function(e,t){return this.each(("function"==typeof t?ve:ye)(e,t))},[Symbol.iterator]:function*(){for(var e=this._groups,t=0,n=e.length;t<n;++t)for(var o,r=e[t],i=0,a=r.length;i<a;++i)(o=r[i])&&(yield o)}};const Ee={passive:!1},ke={capture:!0,passive:!1};function Me(e){e.stopImmediatePropagation()}function Ne(e){e.preventDefault(),e.stopImmediatePropagation()}function _e(e){var t=e.document.documentElement,n=Se(e).on("dragstart.drag",Ne,ke);"onselectstart"in t?n.on("selectstart.drag",Ne,ke):(t.__noselect=t.style.MozUserSelect,t.style.MozUserSelect="none")}function Pe(e,t){var n=e.document.documentElement,o=Se(e).on("dragstart.drag",null);t&&(o.on("click.drag",Ne,ke),setTimeout((function(){o.on("click.drag",null)}),0)),"onselectstart"in n?o.on("selectstart.drag",null):(n.style.MozUserSelect=n.__noselect,delete n.__noselect)}var ze=e=>()=>e;function Oe(e,_ref){let{sourceEvent:t,subject:n,target:o,identifier:r,active:i,x:a,y:s,dx:l,dy:c,dispatch:u}=_ref;Object.defineProperties(this,{type:{value:e,enumerable:!0,configurable:!0},sourceEvent:{value:t,enumerable:!0,configurable:!0},subject:{value:n,enumerable:!0,configurable:!0},target:{value:o,enumerable:!0,configurable:!0},identifier:{value:r,enumerable:!0,configurable:!0},active:{value:i,enumerable:!0,configurable:!0},x:{value:a,enumerable:!0,configurable:!0},y:{value:s,enumerable:!0,configurable:!0},dx:{value:l,enumerable:!0,configurable:!0},dy:{value:c,enumerable:!0,configurable:!0},_:{value:u}})}function Ae(e){return!e.ctrlKey&&!e.button}function De(){return this.parentNode}function Ie(e,t){return null==t?{x:e.x,y:e.y}:t}function Re(){return navigator.maxTouchPoints||"ontouchstart"in this}function Le(){var e,t,n,o,r=Ae,i=De,s=Ie,l=Re,c={},u=a("start","drag","end"),d=0,h=0;function f(e){e.on("mousedown.drag",g).filter(l).on("touchstart.drag",y).on("touchmove.drag",v,Ee).on("touchend.drag touchcancel.drag",x).style("touch-action","none").style("-webkit-tap-highlight-color","rgba(0,0,0,0)")}function g(a,s){if(!o&&r.call(this,a,s)){var l=w(this,i.call(this,a,s),a,s,"mouse");l&&(Se(a.view).on("mousemove.drag",p,ke).on("mouseup.drag",m,ke),_e(a.view),Me(a),n=!1,e=a.clientX,t=a.clientY,l("start",a))}}function p(o){if(Ne(o),!n){var r=o.clientX-e,i=o.clientY-t;n=r*r+i*i>h}c.mouse("drag",o)}function m(e){Se(e.view).on("mousemove.drag mouseup.drag",null),Pe(e.view,n),Ne(e),c.mouse("end",e)}function y(e,t){if(r.call(this,e,t)){var n,o,a=e.changedTouches,s=i.call(this,e,t),l=a.length;for(n=0;n<l;++n)(o=w(this,s,e,t,a[n].identifier,a[n]))&&(Me(e),o("start",e,a[n]))}}function v(e){var t,n,o=e.changedTouches,r=o.length;for(t=0;t<r;++t)(n=c[o[t].identifier])&&(Ne(e),n("drag",e,o[t]))}function x(e){var t,n,r=e.changedTouches,i=r.length;for(o&&clearTimeout(o),o=setTimeout((function(){o=null}),500),t=0;t<i;++t)(n=c[r[t].identifier])&&(Me(e),n("end",e,r[t]))}function w(e,t,n,o,r,i){var a,l,h,g=u.copy(),p=Ce(i||n,t);if(null!=(h=s.call(e,new Oe("beforestart",{sourceEvent:n,target:f,identifier:r,active:d,x:p[0],y:p[1],dx:0,dy:0,dispatch:g}),o)))return a=h.x-p[0]||0,l=h.y-p[1]||0,function n(i,s,u){var m,y=p;switch(i){case"start":c[r]=n,m=d++;break;case"end":delete c[r],--d;case"drag":p=Ce(u||s,t),m=d}g.call(i,e,new Oe(i,{sourceEvent:s,subject:h,target:f,identifier:r,active:m,x:p[0]+a,y:p[1]+l,dx:p[0]-y[0],dy:p[1]-y[1],dispatch:g}),o)}}return f.filter=function(e){return arguments.length?(r="function"==typeof e?e:ze(!!e),f):r},f.container=function(e){return arguments.length?(i="function"==typeof e?e:ze(e),f):i},f.subject=function(e){return arguments.length?(s="function"==typeof e?e:ze(e),f):s},f.touchable=function(e){return arguments.length?(l="function"==typeof e?e:ze(!!e),f):l},f.on=function(){var e=u.on.apply(u,arguments);return e===u?f:e},f.clickDistance=function(e){return arguments.length?(h=(e=+e)*e,f):Math.sqrt(h)},f}function $e(e,t,n){e.prototype=t.prototype=n,n.constructor=e}function Te(e,t){var n=Object.create(e.prototype);for(var o in t)n[o]=t[o];return n}function Ve(){}Oe.prototype.on=function(){var e=this._.on.apply(this._,arguments);return e===this._?this:e};var Be=.7,je=1/Be,He="\\s*([+-]?\\d+)\\s*",Ze="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*",Xe="\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*",Ye=/^#([0-9a-f]{3,8})$/,Fe=new RegExp(`^rgb\\(${He},${He},${He}\\)$`),We=new RegExp(`^rgb\\(${Xe},${Xe},${Xe}\\)$`),Ke=new RegExp(`^rgba\\(${He},${He},${He},${Ze}\\)$`),Ge=new RegExp(`^rgba\\(${Xe},${Xe},${Xe},${Ze}\\)$`),qe=new RegExp(`^hsl\\(${Ze},${Xe},${Xe}\\)$`),Ue=new RegExp(`^hsla\\(${Ze},${Xe},${Xe},${Ze}\\)$`),Qe={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};function Je(){return this.rgb().formatHex()}function et(){return this.rgb().formatRgb()}function tt(e){var t,n;return e=(e+"").trim().toLowerCase(),(t=Ye.exec(e))?(n=t[1].length,t=parseInt(t[1],16),6===n?nt(t):3===n?new it(t>>8&15|t>>4&240,t>>4&15|240&t,(15&t)<<4|15&t,1):8===n?ot(t>>24&255,t>>16&255,t>>8&255,(255&t)/255):4===n?ot(t>>12&15|t>>8&240,t>>8&15|t>>4&240,t>>4&15|240&t,((15&t)<<4|15&t)/255):null):(t=Fe.exec(e))?new it(t[1],t[2],t[3],1):(t=We.exec(e))?new it(255*t[1]/100,255*t[2]/100,255*t[3]/100,1):(t=Ke.exec(e))?ot(t[1],t[2],t[3],t[4]):(t=Ge.exec(e))?ot(255*t[1]/100,255*t[2]/100,255*t[3]/100,t[4]):(t=qe.exec(e))?dt(t[1],t[2]/100,t[3]/100,1):(t=Ue.exec(e))?dt(t[1],t[2]/100,t[3]/100,t[4]):Qe.hasOwnProperty(e)?nt(Qe[e]):"transparent"===e?new it(NaN,NaN,NaN,0):null}function nt(e){return new it(e>>16&255,e>>8&255,255&e,1)}function ot(e,t,n,o){return o<=0&&(e=t=n=NaN),new it(e,t,n,o)}function rt(e,t,n,o){return 1===arguments.length?((r=e)instanceof Ve||(r=tt(r)),r?new it((r=r.rgb()).r,r.g,r.b,r.opacity):new it):new it(e,t,n,null==o?1:o);var r}function it(e,t,n,o){this.r=+e,this.g=+t,this.b=+n,this.opacity=+o}function at(){return`#${ut(this.r)}${ut(this.g)}${ut(this.b)}`}function st(){const e=lt(this.opacity);return`${1===e?"rgb(":"rgba("}${ct(this.r)}, ${ct(this.g)}, ${ct(this.b)}${1===e?")":`, ${e})`}`}function lt(e){return isNaN(e)?1:Math.max(0,Math.min(1,e))}function ct(e){return Math.max(0,Math.min(255,Math.round(e)||0))}function ut(e){return((e=ct(e))<16?"0":"")+e.toString(16)}function dt(e,t,n,o){return o<=0?e=t=n=NaN:n<=0||n>=1?e=t=NaN:t<=0&&(e=NaN),new ft(e,t,n,o)}function ht(e){if(e instanceof ft)return new ft(e.h,e.s,e.l,e.opacity);if(e instanceof Ve||(e=tt(e)),!e)return new ft;if(e instanceof ft)return e;var t=(e=e.rgb()).r/255,n=e.g/255,o=e.b/255,r=Math.min(t,n,o),i=Math.max(t,n,o),a=NaN,s=i-r,l=(i+r)/2;return s?(a=t===i?(n-o)/s+6*(n<o):n===i?(o-t)/s+2:(t-n)/s+4,s/=l<.5?i+r:2-i-r,a*=60):s=l>0&&l<1?0:a,new ft(a,s,l,e.opacity)}function ft(e,t,n,o){this.h=+e,this.s=+t,this.l=+n,this.opacity=+o}function gt(e){return(e=(e||0)%360)<0?e+360:e}function pt(e){return Math.max(0,Math.min(1,e||0))}function mt(e,t,n){return 255*(e<60?t+(n-t)*e/60:e<180?n:e<240?t+(n-t)*(240-e)/60:t)}$e(Ve,tt,{copy(e){return Object.assign(new this.constructor,this,e)},displayable(){return this.rgb().displayable()},hex:Je,formatHex:Je,formatHex8:function(){return this.rgb().formatHex8()},formatHsl:function(){return ht(this).formatHsl()},formatRgb:et,toString:et}),$e(it,rt,Te(Ve,{brighter(e){return e=null==e?je:Math.pow(je,e),new it(this.r*e,this.g*e,this.b*e,this.opacity)},darker(e){return e=null==e?Be:Math.pow(Be,e),new it(this.r*e,this.g*e,this.b*e,this.opacity)},rgb(){return this},clamp(){return new it(ct(this.r),ct(this.g),ct(this.b),lt(this.opacity))},displayable(){return-.5<=this.r&&this.r<255.5&&-.5<=this.g&&this.g<255.5&&-.5<=this.b&&this.b<255.5&&0<=this.opacity&&this.opacity<=1},hex:at,formatHex:at,formatHex8:function(){return`#${ut(this.r)}${ut(this.g)}${ut(this.b)}${ut(255*(isNaN(this.opacity)?1:this.opacity))}`},formatRgb:st,toString:st})),$e(ft,(function(e,t,n,o){return 1===arguments.length?ht(e):new ft(e,t,n,null==o?1:o)}),Te(Ve,{brighter(e){return e=null==e?je:Math.pow(je,e),new ft(this.h,this.s,this.l*e,this.opacity)},darker(e){return e=null==e?Be:Math.pow(Be,e),new ft(this.h,this.s,this.l*e,this.opacity)},rgb(){var e=this.h%360+360*(this.h<0),t=isNaN(e)||isNaN(this.s)?0:this.s,n=this.l,o=n+(n<.5?n:1-n)*t,r=2*n-o;return new it(mt(e>=240?e-240:e+120,r,o),mt(e,r,o),mt(e<120?e+240:e-120,r,o),this.opacity)},clamp(){return new ft(gt(this.h),pt(this.s),pt(this.l),lt(this.opacity))},displayable(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&0<=this.l&&this.l<=1&&0<=this.opacity&&this.opacity<=1},formatHsl(){const e=lt(this.opacity);return`${1===e?"hsl(":"hsla("}${gt(this.h)}, ${100*pt(this.s)}%, ${100*pt(this.l)}%${1===e?")":`, ${e})`}`}}));var yt=e=>()=>e;function vt(e){return 1==(e=+e)?xt:function(t,n){return n-t?function(e,t,n){return e=Math.pow(e,n),t=Math.pow(t,n)-e,n=1/n,function(o){return Math.pow(e+o*t,n)}}(t,n,e):yt(isNaN(t)?n:t)}}function xt(e,t){var n=t-e;return n?function(e,t){return function(n){return e+n*t}}(e,n):yt(isNaN(e)?t:e)}var wt=function e(t){var n=vt(t);function o(e,t){var o=n((e=rt(e)).r,(t=rt(t)).r),r=n(e.g,t.g),i=n(e.b,t.b),a=xt(e.opacity,t.opacity);return function(t){return e.r=o(t),e.g=r(t),e.b=i(t),e.opacity=a(t),e+""}}return o.gamma=e,o}(1);function bt(e,t){t||(t=[]);var n,o=e?Math.min(t.length,e.length):0,r=t.slice();return function(i){for(n=0;n<o;++n)r[n]=e[n]*(1-i)+t[n]*i;return r}}function St(e,t){var n,o=t?t.length:0,r=e?Math.min(o,e.length):0,i=new Array(r),a=new Array(o);for(n=0;n<r;++n)i[n]=Pt(e[n],t[n]);for(;n<o;++n)a[n]=t[n];return function(e){for(n=0;n<r;++n)a[n]=i[n](e);return a}}function Ct(e,t){var n=new Date;return e=+e,t=+t,function(o){return n.setTime(e*(1-o)+t*o),n}}function Et(e,t){return e=+e,t=+t,function(n){return e*(1-n)+t*n}}function kt(e,t){var n,o={},r={};for(n in null!==e&&"object"==typeof e||(e={}),null!==t&&"object"==typeof t||(t={}),t)n in e?o[n]=Pt(e[n],t[n]):r[n]=t[n];return function(e){for(n in o)r[n]=o[n](e);return r}}var Mt=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,Nt=new RegExp(Mt.source,"g");function _t(e,t){var n,o,r,i=Mt.lastIndex=Nt.lastIndex=0,a=-1,s=[],l=[];for(e+="",t+="";(n=Mt.exec(e))&&(o=Nt.exec(t));)(r=o.index)>i&&(r=t.slice(i,r),s[a]?s[a]+=r:s[++a]=r),(n=n[0])===(o=o[0])?s[a]?s[a]+=o:s[++a]=o:(s[++a]=null,l.push({i:a,x:Et(n,o)})),i=Nt.lastIndex;return i<t.length&&(r=t.slice(i),s[a]?s[a]+=r:s[++a]=r),s.length<2?l[0]?function(e){return function(t){return e(t)+""}}(l[0].x):function(e){return function(){return e}}(t):(t=l.length,function(e){for(var n,o=0;o<t;++o)s[(n=l[o]).i]=n.x(e);return s.join("")})}function Pt(e,t){var n,o,r=typeof t;return null==t||"boolean"===r?yt(t):("number"===r?Et:"string"===r?(n=tt(t))?(t=n,wt):_t:t instanceof tt?wt:t instanceof Date?Ct:(o=t,!ArrayBuffer.isView(o)||o instanceof DataView?Array.isArray(t)?St:"function"!=typeof t.valueOf&&"function"!=typeof t.toString||isNaN(t)?kt:Et:bt))(e,t)}var zt,Ot=180/Math.PI,At={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function Dt(e,t,n,o,r,i){var a,s,l;return(a=Math.sqrt(e*e+t*t))&&(e/=a,t/=a),(l=e*n+t*o)&&(n-=e*l,o-=t*l),(s=Math.sqrt(n*n+o*o))&&(n/=s,o/=s,l/=s),e*o<t*n&&(e=-e,t=-t,l=-l,a=-a),{translateX:r,translateY:i,rotate:Math.atan2(t,e)*Ot,skewX:Math.atan(l)*Ot,scaleX:a,scaleY:s}}function It(e,t,n,o){function r(e){return e.length?e.pop()+" ":""}return function(i,a){var s=[],l=[];return i=e(i),a=e(a),function(e,o,r,i,a,s){if(e!==r||o!==i){var l=a.push("translate(",null,t,null,n);s.push({i:l-4,x:Et(e,r)},{i:l-2,x:Et(o,i)})}else(r||i)&&a.push("translate("+r+t+i+n)}(i.translateX,i.translateY,a.translateX,a.translateY,s,l),function(e,t,n,i){e!==t?(e-t>180?t+=360:t-e>180&&(e+=360),i.push({i:n.push(r(n)+"rotate(",null,o)-2,x:Et(e,t)})):t&&n.push(r(n)+"rotate("+t+o)}(i.rotate,a.rotate,s,l),function(e,t,n,i){e!==t?i.push({i:n.push(r(n)+"skewX(",null,o)-2,x:Et(e,t)}):t&&n.push(r(n)+"skewX("+t+o)}(i.skewX,a.skewX,s,l),function(e,t,n,o,i,a){if(e!==n||t!==o){var s=i.push(r(i)+"scale(",null,",",null,")");a.push({i:s-4,x:Et(e,n)},{i:s-2,x:Et(t,o)})}else 1===n&&1===o||i.push(r(i)+"scale("+n+","+o+")")}(i.scaleX,i.scaleY,a.scaleX,a.scaleY,s,l),i=a=null,function(e){for(var t,n=-1,o=l.length;++n<o;)s[(t=l[n]).i]=t.x(e);return s.join("")}}}var Rt=It((function(e){const t=new("function"==typeof DOMMatrix?DOMMatrix:WebKitCSSMatrix)(e+"");return t.isIdentity?At:Dt(t.a,t.b,t.c,t.d,t.e,t.f)}),"px, ","px)","deg)"),Lt=It((function(e){return null==e?At:(zt||(zt=document.createElementNS("http://www.w3.org/2000/svg","g")),zt.setAttribute("transform",e),(e=zt.transform.baseVal.consolidate())?Dt((e=e.matrix).a,e.b,e.c,e.d,e.e,e.f):At)}),", ",")",")");function $t(e){return((e=Math.exp(e))+1/e)/2}var Tt,Vt,Bt=function e(t,n,o){function r(e,r){var i,a,s=e[0],l=e[1],c=e[2],u=r[0],d=r[1],h=r[2],f=u-s,g=d-l,p=f*f+g*g;if(p<1e-12)a=Math.log(h/c)/t,i=function(e){return[s+e*f,l+e*g,c*Math.exp(t*e*a)]};else{var m=Math.sqrt(p),y=(h*h-c*c+o*p)/(2*c*n*m),v=(h*h-c*c-o*p)/(2*h*n*m),x=Math.log(Math.sqrt(y*y+1)-y),w=Math.log(Math.sqrt(v*v+1)-v);a=(w-x)/t,i=function(e){var o,r=e*a,i=$t(x),u=c/(n*m)*(i*(o=t*r+x,((o=Math.exp(2*o))-1)/(o+1))-function(e){return((e=Math.exp(e))-1/e)/2}(x));return[s+u*f,l+u*g,c*i/$t(t*r+x)]}}return i.duration=1e3*a*t/Math.SQRT2,i}return r.rho=function(t){var n=Math.max(.001,+t),o=n*n;return e(n,o,o*o)},r}(Math.SQRT2,2,4),jt=0,Ht=0,Zt=0,Xt=1e3,Yt=0,Ft=0,Wt=0,Kt="object"==typeof performance&&performance.now?performance:Date,Gt="object"==typeof window&&window.requestAnimationFrame?window.requestAnimationFrame.bind(window):function(e){setTimeout(e,17)};function qt(){return Ft||(Gt(Ut),Ft=Kt.now()+Wt)}function Ut(){Ft=0}function Qt(){this._call=this._time=this._next=null}function Jt(e,t,n){var o=new Qt;return o.restart(e,t,n),o}function en(){Ft=(Yt=Kt.now())+Wt,jt=Ht=0;try{!function(){qt(),++jt;for(var e,t=Tt;t;)(e=Ft-t._time)>=0&&t._call.call(void 0,e),t=t._next;--jt}()}finally{jt=0,function(){var e,t,n=Tt,o=1/0;for(;n;)n._call?(o>n._time&&(o=n._time),e=n,n=n._next):(t=n._next,n._next=null,n=e?e._next=t:Tt=t);Vt=e,nn(o)}(),Ft=0}}function tn(){var e=Kt.now(),t=e-Yt;t>Xt&&(Wt-=t,Yt=e)}function nn(e){jt||(Ht&&(Ht=clearTimeout(Ht)),e-Ft>24?(e<1/0&&(Ht=setTimeout(en,e-Kt.now()-Wt)),Zt&&(Zt=clearInterval(Zt))):(Zt||(Yt=Kt.now(),Zt=setInterval(tn,Xt)),jt=1,Gt(en)))}function on(e,t,n){var o=new Qt;return t=null==t?0:+t,o.restart(n=>{o.stop(),e(n+t)},t,n),o}Qt.prototype=Jt.prototype={constructor:Qt,restart:function(e,t,n){if("function"!=typeof e)throw new TypeError("callback is not a function");n=(null==n?qt():+n)+(null==t?0:+t),this._next||Vt===this||(Vt?Vt._next=this:Tt=this,Vt=this),this._call=e,this._time=n,nn()},stop:function(){this._call&&(this._call=null,this._time=1/0,nn())}};var rn=a("start","end","cancel","interrupt"),an=[],sn=0,ln=1,cn=2,un=3,dn=4,hn=5,fn=6;function gn(e,t,n,o,r,i){var a=e.__transition;if(a){if(n in a)return}else e.__transition={};!function(e,t,n){var o,r=e.__transition;function i(e){n.state=ln,n.timer.restart(a,n.delay,n.time),n.delay<=e&&a(e-n.delay)}function a(i){var c,u,d,h;if(n.state!==ln)return l();for(c in r)if((h=r[c]).name===n.name){if(h.state===un)return on(a);h.state===dn?(h.state=fn,h.timer.stop(),h.on.call("interrupt",e,e.__data__,h.index,h.group),delete r[c]):+c<t&&(h.state=fn,h.timer.stop(),h.on.call("cancel",e,e.__data__,h.index,h.group),delete r[c])}if(on((function(){n.state===un&&(n.state=dn,n.timer.restart(s,n.delay,n.time),s(i))})),n.state=cn,n.on.call("start",e,e.__data__,n.index,n.group),n.state===cn){for(n.state=un,o=new Array(d=n.tween.length),c=0,u=-1;c<d;++c)(h=n.tween[c].value.call(e,e.__data__,n.index,n.group))&&(o[++u]=h);o.length=u+1}}function s(t){for(var r=t<n.duration?n.ease.call(null,t/n.duration):(n.timer.restart(l),n.state=hn,1),i=-1,a=o.length;++i<a;)o[i].call(e,r);n.state===hn&&(n.on.call("end",e,e.__data__,n.index,n.group),l())}function l(){for(var o in n.state=fn,n.timer.stop(),delete r[t],r)return;delete e.__transition}r[t]=n,n.timer=Jt(i,0,n.time)}(e,n,{name:t,index:o,group:r,on:rn,tween:an,time:i.time,delay:i.delay,duration:i.duration,ease:i.ease,timer:null,state:sn})}function pn(e,t){var n=yn(e,t);if(n.state>sn)throw new Error("too late; already scheduled");return n}function mn(e,t){var n=yn(e,t);if(n.state>un)throw new Error("too late; already running");return n}function yn(e,t){var n=e.__transition;if(!n||!(n=n[t]))throw new Error("transition not found");return n}function vn(e,t){var n,o,r,i=e.__transition,a=!0;if(i){for(r in t=null==t?null:t+"",i)(n=i[r]).name===t?(o=n.state>cn&&n.state<hn,n.state=fn,n.timer.stop(),n.on.call(o?"interrupt":"cancel",e,e.__data__,n.index,n.group),delete i[r]):a=!1;a&&delete e.__transition}}function xn(e,t){var n,o;return function(){var r=mn(this,e),i=r.tween;if(i!==n)for(var a=0,s=(o=n=i).length;a<s;++a)if(o[a].name===t){(o=o.slice()).splice(a,1);break}r.tween=o}}function wn(e,t,n){var o,r;if("function"!=typeof n)throw new Error;return function(){var i=mn(this,e),a=i.tween;if(a!==o){r=(o=a).slice();for(var s={name:t,value:n},l=0,c=r.length;l<c;++l)if(r[l].name===t){r[l]=s;break}l===c&&r.push(s)}i.tween=r}}function bn(e,t,n){var o=e._id;return e.each((function(){var e=mn(this,o);(e.value||(e.value={}))[t]=n.apply(this,arguments)})),function(e){return yn(e,o).value[t]}}function Sn(e,t){var n;return("number"==typeof t?Et:t instanceof tt?wt:(n=tt(t))?(t=n,wt):_t)(e,t)}function Cn(e){return function(){this.removeAttribute(e)}}function En(e){return function(){this.removeAttributeNS(e.space,e.local)}}function kn(e,t,n){var o,r,i=n+"";return function(){var a=this.getAttribute(e);return a===i?null:a===o?r:r=t(o=a,n)}}function Mn(e,t,n){var o,r,i=n+"";return function(){var a=this.getAttributeNS(e.space,e.local);return a===i?null:a===o?r:r=t(o=a,n)}}function Nn(e,t,n){var o,r,i;return function(){var a,s,l=n(this);if(null!=l)return(a=this.getAttribute(e))===(s=l+"")?null:a===o&&s===r?i:(r=s,i=t(o=a,l));this.removeAttribute(e)}}function _n(e,t,n){var o,r,i;return function(){var a,s,l=n(this);if(null!=l)return(a=this.getAttributeNS(e.space,e.local))===(s=l+"")?null:a===o&&s===r?i:(r=s,i=t(o=a,l));this.removeAttributeNS(e.space,e.local)}}function Pn(e,t){var n,o;function r(){var r=t.apply(this,arguments);return r!==o&&(n=(o=r)&&function(e,t){return function(n){this.setAttributeNS(e.space,e.local,t.call(this,n))}}(e,r)),n}return r._value=t,r}function zn(e,t){var n,o;function r(){var r=t.apply(this,arguments);return r!==o&&(n=(o=r)&&function(e,t){return function(n){this.setAttribute(e,t.call(this,n))}}(e,r)),n}return r._value=t,r}function On(e,t){return function(){pn(this,e).delay=+t.apply(this,arguments)}}function An(e,t){return t=+t,function(){pn(this,e).delay=t}}function Dn(e,t){return function(){mn(this,e).duration=+t.apply(this,arguments)}}function In(e,t){return t=+t,function(){mn(this,e).duration=t}}var Rn=be.prototype.constructor;function Ln(e){return function(){this.style.removeProperty(e)}}var $n=0;function Tn(e,t,n,o){this._groups=e,this._parents=t,this._name=n,this._id=o}function Vn(){return++$n}var Bn=be.prototype;Tn.prototype={constructor:Tn,select:function(e){var t=this._name,n=this._id;"function"!=typeof e&&(e=y(e));for(var o=this._groups,r=o.length,i=new Array(r),a=0;a<r;++a)for(var s,l,c=o[a],u=c.length,d=i[a]=new Array(u),h=0;h<u;++h)(s=c[h])&&(l=e.call(s,s.__data__,h,c))&&("__data__"in s&&(l.__data__=s.__data__),d[h]=l,gn(d[h],t,n,h,d,yn(s,n)));return new Tn(i,this._parents,t,n)},selectAll:function(e){var t=this._name,n=this._id;"function"!=typeof e&&(e=x(e));for(var o=this._groups,r=o.length,i=[],a=[],s=0;s<r;++s)for(var l,c=o[s],u=c.length,d=0;d<u;++d)if(l=c[d]){for(var h,f=e.call(l,l.__data__,d,c),g=yn(l,n),p=0,m=f.length;p<m;++p)(h=f[p])&&gn(h,t,n,p,f,g);i.push(f),a.push(l)}return new Tn(i,a,t,n)},selectChild:Bn.selectChild,selectChildren:Bn.selectChildren,filter:function(e){"function"!=typeof e&&(e=b(e));for(var t=this._groups,n=t.length,o=new Array(n),r=0;r<n;++r)for(var i,a=t[r],s=a.length,l=o[r]=[],c=0;c<s;++c)(i=a[c])&&e.call(i,i.__data__,c,a)&&l.push(i);return new Tn(o,this._parents,this._name,this._id)},merge:function(e){if(e._id!==this._id)throw new Error;for(var t=this._groups,n=e._groups,o=t.length,r=n.length,i=Math.min(o,r),a=new Array(o),s=0;s<i;++s)for(var l,c=t[s],u=n[s],d=c.length,h=a[s]=new Array(d),f=0;f<d;++f)(l=c[f]||u[f])&&(h[f]=l);for(;s<o;++s)a[s]=t[s];return new Tn(a,this._parents,this._name,this._id)},selection:function(){return new Rn(this._groups,this._parents)},transition:function(){for(var e=this._name,t=this._id,n=Vn(),o=this._groups,r=o.length,i=0;i<r;++i)for(var a,s=o[i],l=s.length,c=0;c<l;++c)if(a=s[c]){var u=yn(a,t);gn(a,e,n,c,s,{time:u.time+u.delay+u.duration,delay:0,duration:u.duration,ease:u.ease})}return new Tn(o,this._parents,e,n)},call:Bn.call,nodes:Bn.nodes,node:Bn.node,size:Bn.size,empty:Bn.empty,each:Bn.each,on:function(e,t){var n=this._id;return arguments.length<2?yn(this.node(),n).on.on(e):this.each(function(e,t,n){var o,r,i=function(e){return(e+"").trim().split(/^|\s+/).every((function(e){var t=e.indexOf(".");return t>=0&&(e=e.slice(0,t)),!e||"start"===e}))}(t)?pn:mn;return function(){var a=i(this,e),s=a.on;s!==o&&(r=(o=s).copy()).on(t,n),a.on=r}}(n,e,t))},attr:function(e,t){var n=h(e),o="transform"===n?Lt:Sn;return this.attrTween(e,"function"==typeof t?(n.local?_n:Nn)(n,o,bn(this,"attr."+e,t)):null==t?(n.local?En:Cn)(n):(n.local?Mn:kn)(n,o,t))},attrTween:function(e,t){var n="attr."+e;if(arguments.length<2)return(n=this.tween(n))&&n._value;if(null==t)return this.tween(n,null);if("function"!=typeof t)throw new Error;var o=h(e);return this.tween(n,(o.local?Pn:zn)(o,t))},style:function(e,t,n){var o="transform"==(e+="")?Rt:Sn;return null==t?this.styleTween(e,function(e,t){var n,o,r;return function(){var i=X(this,e),a=(this.style.removeProperty(e),X(this,e));return i===a?null:i===n&&a===o?r:r=t(n=i,o=a)}}(e,o)).on("end.style."+e,Ln(e)):"function"==typeof t?this.styleTween(e,function(e,t,n){var o,r,i;return function(){var a=X(this,e),s=n(this),l=s+"";return null==s&&(this.style.removeProperty(e),l=s=X(this,e)),a===l?null:a===o&&l===r?i:(r=l,i=t(o=a,s))}}(e,o,bn(this,"style."+e,t))).each(function(e,t){var n,o,r,i,a="style."+t,s="end."+a;return function(){var l=mn(this,e),c=l.on,u=null==l.value[a]?i||(i=Ln(t)):void 0;c===n&&r===u||(o=(n=c).copy()).on(s,r=u),l.on=o}}(this._id,e)):this.styleTween(e,function(e,t,n){var o,r,i=n+"";return function(){var a=X(this,e);return a===i?null:a===o?r:r=t(o=a,n)}}(e,o,t),n).on("end.style."+e,null)},styleTween:function(e,t,n){var o="style."+(e+="");if(arguments.length<2)return(o=this.tween(o))&&o._value;if(null==t)return this.tween(o,null);if("function"!=typeof t)throw new Error;return this.tween(o,function(e,t,n){var o,r;function i(){var i=t.apply(this,arguments);return i!==r&&(o=(r=i)&&function(e,t,n){return function(o){this.style.setProperty(e,t.call(this,o),n)}}(e,i,n)),o}return i._value=t,i}(e,t,null==n?"":n))},text:function(e){return this.tween("text","function"==typeof e?function(e){return function(){var t=e(this);this.textContent=null==t?"":t}}(bn(this,"text",e)):function(e){return function(){this.textContent=e}}(null==e?"":e+""))},textTween:function(e){var t="text";if(arguments.length<1)return(t=this.tween(t))&&t._value;if(null==e)return this.tween(t,null);if("function"!=typeof e)throw new Error;return this.tween(t,function(e){var t,n;function o(){var o=e.apply(this,arguments);return o!==n&&(t=(n=o)&&function(e){return function(t){this.textContent=e.call(this,t)}}(o)),t}return o._value=e,o}(e))},remove:function(){return this.on("end.remove",function(e){return function(){var t=this.parentNode;for(var n in this.__transition)if(+n!==e)return;t&&t.removeChild(this)}}(this._id))},tween:function(e,t){var n=this._id;if(e+="",arguments.length<2){for(var o,r=yn(this.node(),n).tween,i=0,a=r.length;i<a;++i)if((o=r[i]).name===e)return o.value;return null}return this.each((null==t?xn:wn)(n,e,t))},delay:function(e){var t=this._id;return arguments.length?this.each(("function"==typeof e?On:An)(t,e)):yn(this.node(),t).delay},duration:function(e){var t=this._id;return arguments.length?this.each(("function"==typeof e?Dn:In)(t,e)):yn(this.node(),t).duration},ease:function(e){var t=this._id;return arguments.length?this.each(function(e,t){if("function"!=typeof t)throw new Error;return function(){mn(this,e).ease=t}}(t,e)):yn(this.node(),t).ease},easeVarying:function(e){if("function"!=typeof e)throw new Error;return this.each(function(e,t){return function(){var n=t.apply(this,arguments);if("function"!=typeof n)throw new Error;mn(this,e).ease=n}}(this._id,e))},end:function(){var e,t,n=this,o=n._id,r=n.size();return new Promise((function(i,a){var s={value:a},l={value:function(){0==--r&&i()}};n.each((function(){var n=mn(this,o),r=n.on;r!==e&&((t=(e=r).copy())._.cancel.push(s),t._.interrupt.push(s),t._.end.push(l)),n.on=t})),0===r&&i()}))},[Symbol.iterator]:Bn[Symbol.iterator]};var jn={time:null,delay:0,duration:250,ease:function(e){return((e*=2)<=1?e*e*e:(e-=2)*e*e+2)/2}};function Hn(e,t){for(var n;!(n=e.__transition)||!(n=n[t]);)if(!(e=e.parentNode))throw new Error(`transition ${t} not found`);return n}be.prototype.interrupt=function(e){return this.each((function(){vn(this,e)}))},be.prototype.transition=function(e){var t,n;e instanceof Tn?(t=e._id,e=e._name):(t=Vn(),(n=jn).time=qt(),e=null==e?null:e+"");for(var o=this._groups,r=o.length,i=0;i<r;++i)for(var a,s=o[i],l=s.length,c=0;c<l;++c)(a=s[c])&&gn(a,e,t,c,s,n||Hn(a,t));return new Tn(o,this._parents,e,t)};var Zn=e=>()=>e;function Xn(e,_ref2){let{sourceEvent:t,target:n,transform:o,dispatch:r}=_ref2;Object.defineProperties(this,{type:{value:e,enumerable:!0,configurable:!0},sourceEvent:{value:t,enumerable:!0,configurable:!0},target:{value:n,enumerable:!0,configurable:!0},transform:{value:o,enumerable:!0,configurable:!0},_:{value:r}})}function Yn(e,t,n){this.k=e,this.x=t,this.y=n}Yn.prototype={constructor:Yn,scale:function(e){return 1===e?this:new Yn(this.k*e,this.x,this.y)},translate:function(e,t){return 0===e&0===t?this:new Yn(this.k,this.x+this.k*e,this.y+this.k*t)},apply:function(e){return[e[0]*this.k+this.x,e[1]*this.k+this.y]},applyX:function(e){return e*this.k+this.x},applyY:function(e){return e*this.k+this.y},invert:function(e){return[(e[0]-this.x)/this.k,(e[1]-this.y)/this.k]},invertX:function(e){return(e-this.x)/this.k},invertY:function(e){return(e-this.y)/this.k},rescaleX:function(e){return e.copy().domain(e.range().map(this.invertX,this).map(e.invert,e))},rescaleY:function(e){return e.copy().domain(e.range().map(this.invertY,this).map(e.invert,e))},toString:function(){return"translate("+this.x+","+this.y+") scale("+this.k+")"}};var Fn=new Yn(1,0,0);function Wn(e){for(;!e.__zoom;)if(!(e=e.parentNode))return Fn;return e.__zoom}function Kn(e){e.stopImmediatePropagation()}function Gn(e){e.preventDefault(),e.stopImmediatePropagation()}function qn(e){return!(e.ctrlKey&&"wheel"!==e.type||e.button)}function Un(){var e=this;return e instanceof SVGElement?(e=e.ownerSVGElement||e).hasAttribute("viewBox")?[[(e=e.viewBox.baseVal).x,e.y],[e.x+e.width,e.y+e.height]]:[[0,0],[e.width.baseVal.value,e.height.baseVal.value]]:[[0,0],[e.clientWidth,e.clientHeight]]}function Qn(){return this.__zoom||Fn}function Jn(e){return-e.deltaY*(1===e.deltaMode?.05:e.deltaMode?1:.002)*(e.ctrlKey?10:1)}function eo(){return navigator.maxTouchPoints||"ontouchstart"in this}function to(e,t,n){var o=e.invertX(t[0][0])-n[0][0],r=e.invertX(t[1][0])-n[1][0],i=e.invertY(t[0][1])-n[0][1],a=e.invertY(t[1][1])-n[1][1];return e.translate(r>o?(o+r)/2:Math.min(0,o)||Math.max(0,r),a>i?(i+a)/2:Math.min(0,i)||Math.max(0,a))}function no(){var e,t,n,o=qn,r=Un,i=to,s=Jn,l=eo,c=[0,1/0],u=[[-1/0,-1/0],[1/0,1/0]],d=250,h=Bt,f=a("start","zoom","end"),g=500,p=150,m=0,y=10;function v(e){e.property("__zoom",Qn).on("wheel.zoom",k,{passive:!1}).on("mousedown.zoom",M).on("dblclick.zoom",N).filter(l).on("touchstart.zoom",_).on("touchmove.zoom",P).on("touchend.zoom touchcancel.zoom",z).style("-webkit-tap-highlight-color","rgba(0,0,0,0)")}function x(e,t){return(t=Math.max(c[0],Math.min(c[1],t)))===e.k?e:new Yn(t,e.x,e.y)}function w(e,t,n){var o=t[0]-n[0]*e.k,r=t[1]-n[1]*e.k;return o===e.x&&r===e.y?e:new Yn(e.k,o,r)}function b(e){return[(+e[0][0]+ +e[1][0])/2,(+e[0][1]+ +e[1][1])/2]}function S(e,t,n,o){e.on("start.zoom",(function(){C(this,arguments).event(o).start()})).on("interrupt.zoom end.zoom",(function(){C(this,arguments).event(o).end()})).tween("zoom",(function(){var e=this,i=arguments,a=C(e,i).event(o),s=r.apply(e,i),l=null==n?b(s):"function"==typeof n?n.apply(e,i):n,c=Math.max(s[1][0]-s[0][0],s[1][1]-s[0][1]),u=e.__zoom,d="function"==typeof t?t.apply(e,i):t,f=h(u.invert(l).concat(c/u.k),d.invert(l).concat(c/d.k));return function(e){if(1===e)e=d;else{var t=f(e),n=c/t[2];e=new Yn(n,l[0]-t[0]*n,l[1]-t[1]*n)}a.zoom(null,e)}}))}function C(e,t,n){return!n&&e.__zooming||new E(e,t)}function E(e,t){this.that=e,this.args=t,this.active=0,this.sourceEvent=null,this.extent=r.apply(e,t),this.taps=0}function k(e){for(var _len=arguments.length,t=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){t[_key-1]=arguments[_key]}if(o.apply(this,arguments)){var n=C(this,t).event(e),r=this.__zoom,a=Math.max(c[0],Math.min(c[1],r.k*Math.pow(2,s.apply(this,arguments)))),l=Ce(e);if(n.wheel)n.mouse[0][0]===l[0]&&n.mouse[0][1]===l[1]||(n.mouse[1]=r.invert(n.mouse[0]=l)),clearTimeout(n.wheel);else{if(r.k===a)return;n.mouse=[l,r.invert(l)],vn(this),n.start()}Gn(e),n.wheel=setTimeout((function(){n.wheel=null,n.end()}),p),n.zoom("mouse",i(w(x(r,a),n.mouse[0],n.mouse[1]),n.extent,u))}}function M(e){for(var _len2=arguments.length,t=new Array(_len2>1?_len2-1:0),_key2=1;_key2<_len2;_key2++){t[_key2-1]=arguments[_key2]}if(!n&&o.apply(this,arguments)){var r=e.currentTarget,a=C(this,t,!0).event(e),s=Se(e.view).on("mousemove.zoom",(function(e){if(Gn(e),!a.moved){var t=e.clientX-c,n=e.clientY-d;a.moved=t*t+n*n>m}a.event(e).zoom("mouse",i(w(a.that.__zoom,a.mouse[0]=Ce(e,r),a.mouse[1]),a.extent,u))}),!0).on("mouseup.zoom",(function(e){s.on("mousemove.zoom mouseup.zoom",null),Pe(e.view,a.moved),Gn(e),a.event(e).end()}),!0),l=Ce(e,r),c=e.clientX,d=e.clientY;_e(e.view),Kn(e),a.mouse=[l,this.__zoom.invert(l)],vn(this),a.start()}}function N(e){for(var _len3=arguments.length,t=new Array(_len3>1?_len3-1:0),_key3=1;_key3<_len3;_key3++){t[_key3-1]=arguments[_key3]}if(o.apply(this,arguments)){var n=this.__zoom,a=Ce(e.changedTouches?e.changedTouches[0]:e,this),s=n.invert(a),l=n.k*(e.shiftKey?.5:2),c=i(w(x(n,l),a,s),r.apply(this,t),u);Gn(e),d>0?Se(this).transition().duration(d).call(S,c,a,e):Se(this).call(v.transform,c,a,e)}}function _(n){for(var _len4=arguments.length,r=new Array(_len4>1?_len4-1:0),_key4=1;_key4<_len4;_key4++){r[_key4-1]=arguments[_key4]}if(o.apply(this,arguments)){var i,a,s,l,c=n.touches,u=c.length,d=C(this,r,n.changedTouches.length===u).event(n);for(Kn(n),a=0;a<u;++a)l=[l=Ce(s=c[a],this),this.__zoom.invert(l),s.identifier],d.touch0?d.touch1||d.touch0[2]===l[2]||(d.touch1=l,d.taps=0):(d.touch0=l,i=!0,d.taps=1+!!e);e&&(e=clearTimeout(e)),i&&(d.taps<2&&(t=l[0],e=setTimeout((function(){e=null}),g)),vn(this),d.start())}}function P(e){if(this.__zooming){for(var _len5=arguments.length,t=new Array(_len5>1?_len5-1:0),_key5=1;_key5<_len5;_key5++){t[_key5-1]=arguments[_key5]}var n,o,r,a,s=C(this,t).event(e),l=e.changedTouches,c=l.length;for(Gn(e),n=0;n<c;++n)r=Ce(o=l[n],this),s.touch0&&s.touch0[2]===o.identifier?s.touch0[0]=r:s.touch1&&s.touch1[2]===o.identifier&&(s.touch1[0]=r);if(o=s.that.__zoom,s.touch1){var d=s.touch0[0],h=s.touch0[1],f=s.touch1[0],g=s.touch1[1],p=(p=f[0]-d[0])*p+(p=f[1]-d[1])*p,m=(m=g[0]-h[0])*m+(m=g[1]-h[1])*m;o=x(o,Math.sqrt(p/m)),r=[(d[0]+f[0])/2,(d[1]+f[1])/2],a=[(h[0]+g[0])/2,(h[1]+g[1])/2]}else{if(!s.touch0)return;r=s.touch0[0],a=s.touch0[1]}s.zoom("touch",i(w(o,r,a),s.extent,u))}}function z(e){for(var _len6=arguments.length,o=new Array(_len6>1?_len6-1:0),_key6=1;_key6<_len6;_key6++){o[_key6-1]=arguments[_key6]}if(this.__zooming){var r,i,a=C(this,o).event(e),s=e.changedTouches,l=s.length;for(Kn(e),n&&clearTimeout(n),n=setTimeout((function(){n=null}),g),r=0;r<l;++r)i=s[r],a.touch0&&a.touch0[2]===i.identifier?delete a.touch0:a.touch1&&a.touch1[2]===i.identifier&&delete a.touch1;if(a.touch1&&!a.touch0&&(a.touch0=a.touch1,delete a.touch1),a.touch0)a.touch0[1]=this.__zoom.invert(a.touch0[0]);else if(a.end(),2===a.taps&&(i=Ce(i,this),Math.hypot(t[0]-i[0],t[1]-i[1])<y)){var c=Se(this).on("dblclick.zoom");c&&c.apply(this,arguments)}}}return v.transform=function(e,t,n,o){var r=e.selection?e.selection():e;r.property("__zoom",Qn),e!==r?S(e,t,n,o):r.interrupt().each((function(){C(this,arguments).event(o).start().zoom(null,"function"==typeof t?t.apply(this,arguments):t).end()}))},v.scaleBy=function(e,t,n,o){v.scaleTo(e,(function(){return this.__zoom.k*("function"==typeof t?t.apply(this,arguments):t)}),n,o)},v.scaleTo=function(e,t,n,o){v.transform(e,(function(){var e=r.apply(this,arguments),o=this.__zoom,a=null==n?b(e):"function"==typeof n?n.apply(this,arguments):n,s=o.invert(a),l="function"==typeof t?t.apply(this,arguments):t;return i(w(x(o,l),a,s),e,u)}),n,o)},v.translateBy=function(e,t,n,o){v.transform(e,(function(){return i(this.__zoom.translate("function"==typeof t?t.apply(this,arguments):t,"function"==typeof n?n.apply(this,arguments):n),r.apply(this,arguments),u)}),null,o)},v.translateTo=function(e,t,n,o,a){v.transform(e,(function(){var e=r.apply(this,arguments),a=this.__zoom,s=null==o?b(e):"function"==typeof o?o.apply(this,arguments):o;return i(Fn.translate(s[0],s[1]).scale(a.k).translate("function"==typeof t?-t.apply(this,arguments):-t,"function"==typeof n?-n.apply(this,arguments):-n),e,u)}),o,a)},E.prototype={event:function(e){return e&&(this.sourceEvent=e),this},start:function(){return 1==++this.active&&(this.that.__zooming=this,this.emit("start")),this},zoom:function(e,t){return this.mouse&&"mouse"!==e&&(this.mouse[1]=t.invert(this.mouse[0])),this.touch0&&"touch"!==e&&(this.touch0[1]=t.invert(this.touch0[0])),this.touch1&&"touch"!==e&&(this.touch1[1]=t.invert(this.touch1[0])),this.that.__zoom=t,this.emit("zoom"),this},end:function(){return 0==--this.active&&(delete this.that.__zooming,this.emit("end")),this},emit:function(e){var t=Se(this.that).datum();f.call(e,this.that,new Xn(e,{sourceEvent:this.sourceEvent,target:v,type:e,transform:this.that.__zoom,dispatch:f}),t)}},v.wheelDelta=function(e){return arguments.length?(s="function"==typeof e?e:Zn(+e),v):s},v.filter=function(e){return arguments.length?(o="function"==typeof e?e:Zn(!!e),v):o},v.touchable=function(e){return arguments.length?(l="function"==typeof e?e:Zn(!!e),v):l},v.extent=function(e){return arguments.length?(r="function"==typeof e?e:Zn([[+e[0][0],+e[0][1]],[+e[1][0],+e[1][1]]]),v):r},v.scaleExtent=function(e){return arguments.length?(c[0]=+e[0],c[1]=+e[1],v):[c[0],c[1]]},v.translateExtent=function(e){return arguments.length?(u[0][0]=+e[0][0],u[1][0]=+e[1][0],u[0][1]=+e[0][1],u[1][1]=+e[1][1],v):[[u[0][0],u[0][1]],[u[1][0],u[1][1]]]},v.constrain=function(e){return arguments.length?(i=e,v):i},v.duration=function(e){return arguments.length?(d=+e,v):d},v.interpolate=function(e){return arguments.length?(h=e,v):h},v.on=function(){var e=f.on.apply(f,arguments);return e===f?v:e},v.clickDistance=function(e){return arguments.length?(m=(e=+e)*e,v):Math.sqrt(m)},v.tapDistance=function(e){return arguments.length?(y=+e,v):y},v}Wn.prototype=Yn.prototype;const oo={error001:()=>"[React Flow]: Seems like you have not used zustand provider as an ancestor. Help: https://reactflow.dev/error#001",error002:()=>"It looks like you've created a new nodeTypes or edgeTypes object. If this wasn't on purpose please define the nodeTypes/edgeTypes outside of the component or memoize them.",error003:e=>`Node type "${e}" not found. Using fallback type "default".`,error004:()=>"The React Flow parent container needs a width and a height to render the graph.",error005:()=>"Only child nodes can use a parent extent.",error006:()=>"Can't create edge. An edge needs a source and a target.",error007:e=>`The old edge with id=${e} does not exist.`,error009:e=>`Marker type "${e}" doesn't exist.`,error008:(e,_ref3)=>{let{id:t,sourceHandle:n,targetHandle:o}=_ref3;return`Couldn't create edge for ${e} handle id: "${"source"===e?n:o}", edge id: ${t}.`},error010:()=>"Handle: No node id found. Make sure to only use a Handle inside a custom Node.",error011:e=>`Edge type "${e}" not found. Using fallback type "default".`,error012:e=>`Node with id "${e}" does not exist, it may have been removed. This can happen when a node is deleted before the "onNodeClick" handler is called.`,error013:function(){let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"react";return`It seems that you haven't loaded the styles. Please import '@xyflow/${e}/dist/style.css' or base.css to make sure everything is working properly.`},error014:()=>"useNodeConnections: No node ID found. Call useNodeConnections inside a custom Node or provide a node ID.",error015:()=>"It seems that you are trying to drag a node that is not initialized. Please use onNodesChange as explained in the docs."},ro=[[Number.NEGATIVE_INFINITY,Number.NEGATIVE_INFINITY],[Number.POSITIVE_INFINITY,Number.POSITIVE_INFINITY]],io=["Enter"," ","Escape"],ao={"node.a11yDescription.default":"Press enter or space to select a node. Press delete to remove it and escape to cancel.","node.a11yDescription.keyboardDisabled":"Press enter or space to select a node. You can then use the arrow keys to move the node around. Press delete to remove it and escape to cancel.","node.a11yDescription.ariaLiveMessage":_ref4=>{let{direction:e,x:t,y:n}=_ref4;return`Moved selected node ${e}. New position, x: ${t}, y: ${n}`},"edge.a11yDescription.default":"Press enter or space to select an edge. You can then press delete to remove it or escape to cancel.","controls.ariaLabel":"Control Panel","controls.zoomIn.ariaLabel":"Zoom In","controls.zoomOut.ariaLabel":"Zoom Out","controls.fitView.ariaLabel":"Fit View","controls.interactive.ariaLabel":"Toggle Interactivity","minimap.ariaLabel":"Mini Map","handle.ariaLabel":"Handle"};var so,lo,co;e.ConnectionMode=void 0,(so=e.ConnectionMode||(e.ConnectionMode={})).Strict="strict",so.Loose="loose",e.PanOnScrollMode=void 0,(lo=e.PanOnScrollMode||(e.PanOnScrollMode={})).Free="free",lo.Vertical="vertical",lo.Horizontal="horizontal",e.SelectionMode=void 0,(co=e.SelectionMode||(e.SelectionMode={})).Partial="partial",co.Full="full";const uo={inProgress:!1,isValid:null,from:null,fromHandle:null,fromPosition:null,fromNode:null,to:null,toHandle:null,toPosition:null,toNode:null};var ho,fo,go;e.ConnectionLineType=void 0,(ho=e.ConnectionLineType||(e.ConnectionLineType={})).Bezier="default",ho.Straight="straight",ho.Step="step",ho.SmoothStep="smoothstep",ho.SimpleBezier="simplebezier",e.MarkerType=void 0,(fo=e.MarkerType||(e.MarkerType={})).Arrow="arrow",fo.ArrowClosed="arrowclosed",e.Position=void 0,(go=e.Position||(e.Position={})).Left="left",go.Top="top",go.Right="right",go.Bottom="bottom";const po={[e.Position.Left]:e.Position.Right,[e.Position.Right]:e.Position.Left,[e.Position.Top]:e.Position.Bottom,[e.Position.Bottom]:e.Position.Top};function mo(e,t){if(!e&&!t)return!0;if(!e||!t||e.size!==t.size)return!1;if(!e.size&&!t.size)return!0;for(const n of e.keys())if(!t.has(n))return!1;return!0}function yo(e,t,n){if(!n)return;const o=[];e.forEach((e,n)=>{(t===null||t===void 0?void 0:t.has(n))||o.push(e)}),o.length&&n(o)}function vo(e){return null===e?null:e?"valid":"invalid"}const xo=e=>"id"in e&&"source"in e&&"target"in e,wo=e=>"id"in e&&"internals"in e&&!("source"in e)&&!("target"in e),bo=function(e){var _e$origin;let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[0,0];const{width:n,height:o}=qo(e),r=(_e$origin=e.origin)!==null&&_e$origin!==void 0?_e$origin:t,i=n*r[0],a=o*r[1];return{x:e.position.x-i,y:e.position.y-a}},So=function(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{nodeOrigin:[0,0]};if(0===e.length)return{x:0,y:0,width:0,height:0};const n=e.reduce((e,n)=>{const o="string"==typeof n;let r=t.nodeLookup||o?void 0:n;t.nodeLookup&&(r=o?t.nodeLookup.get(n):wo(n)?n:t.nodeLookup.get(n.id));const i=r?$o(r,t.nodeOrigin):{x:0,y:0,x2:0,y2:0};return Do(e,i)},{x:1/0,y:1/0,x2:-1/0,y2:-1/0});return Ro(n)},Co=function(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};if(0===e.size)return{x:0,y:0,width:0,height:0};let n={x:1/0,y:1/0,x2:-1/0,y2:-1/0};return e.forEach(e=>{if(void 0===t.filter||t.filter(e)){const t=$o(e);n=Do(n,t)}}),Ro(n)},Eo=function(e,t){let[n,o,r]=arguments.length>2&&arguments[2]!==undefined?arguments[2]:[0,0,1];let i=arguments.length>3&&arguments[3]!==undefined?arguments[3]:!1;let a=arguments.length>4&&arguments[4]!==undefined?arguments[4]:!1;const s={...Xo(t,[n,o,r]),width:t.width/r,height:t.height/r},l=[];for(const t of e.values()){var _ref5,_ref6,_e$width,_ref7,_ref8,_e$height;const{measured:e,selectable:n=!0,hidden:o=!1}=t;if(a&&!n||o)continue;const r=(_ref5=(_ref6=(_e$width=e.width)!==null&&_e$width!==void 0?_e$width:t.width)!==null&&_ref6!==void 0?_ref6:t.initialWidth)!==null&&_ref5!==void 0?_ref5:null,c=(_ref7=(_ref8=(_e$height=e.height)!==null&&_e$height!==void 0?_e$height:t.height)!==null&&_ref8!==void 0?_ref8:t.initialHeight)!==null&&_ref7!==void 0?_ref7:null,u=Vo(s,Lo(t)),d=(r!==null&&r!==void 0?r:0)*(c!==null&&c!==void 0?c:0),h=i&&u>0;(!t.internals.handleBounds||h||u>=d||t.dragging)&&l.push(t)}return l},ko=(e,t)=>{const n=new Set;return e.forEach(e=>{n.add(e.id)}),t.filter(e=>n.has(e.source)||n.has(e.target))};async function Mo(_ref9,a){var _a$minZoom,_a$maxZoom,_a$padding;let{nodes:e,width:t,height:n,panZoom:o,minZoom:r,maxZoom:i}=_ref9;if(0===e.size)return Promise.resolve(!0);const s=function(e,t){const n=new Map,o=t!==null&&t!==void 0&&t.nodes?new Set(t.nodes.map(e=>e.id)):null;return e.forEach(e=>{!e.measured.width||!e.measured.height||!(t!==null&&t!==void 0&&t.includeHiddenNodes)&&e.hidden||o&&!o.has(e.id)||n.set(e.id,e)}),n}(e,a),l=Co(s),c=Wo(l,t,n,(_a$minZoom=a===null||a===void 0?void 0:a.minZoom)!==null&&_a$minZoom!==void 0?_a$minZoom:r,(_a$maxZoom=a===null||a===void 0?void 0:a.maxZoom)!==null&&_a$maxZoom!==void 0?_a$maxZoom:i,(_a$padding=a===null||a===void 0?void 0:a.padding)!==null&&_a$padding!==void 0?_a$padding:.1);return await o.setViewport(c,{duration:a===null||a===void 0?void 0:a.duration,ease:a===null||a===void 0?void 0:a.ease,interpolate:a===null||a===void 0?void 0:a.interpolate}),Promise.resolve(!0)}function No(_ref10){var _a$origin,_a$measured$width,_a$measured$height;let{nodeId:e,nextPosition:t,nodeLookup:n,nodeOrigin:o=[0,0],nodeExtent:r,onError:i}=_ref10;const a=n.get(e),s=a.parentId?n.get(a.parentId):void 0,{x:l,y:c}=s?s.internals.positionAbsolute:{x:0,y:0},u=(_a$origin=a.origin)!==null&&_a$origin!==void 0?_a$origin:o;let d=a.extent||r;if("parent"!==a.extent||a.expandParent)s&&Go(a.extent)&&(d=[[a.extent[0][0]+l,a.extent[0][1]+c],[a.extent[1][0]+l,a.extent[1][1]+c]]);else if(s){const e=s.measured.width,t=s.measured.height;e&&t&&(d=[[l,c],[l+e,c+t]])}else i===null||i===void 0||i("005",oo.error005());const h=Go(d)?Po(t,d,a.measured):t;return void 0!==a.measured.width&&void 0!==a.measured.height||i!==null&&i!==void 0&&i("015",oo.error015()),{position:{x:h.x-l+((_a$measured$width=a.measured.width)!==null&&_a$measured$width!==void 0?_a$measured$width:0)*u[0],y:h.y-c+((_a$measured$height=a.measured.height)!==null&&_a$measured$height!==void 0?_a$measured$height:0)*u[1]},positionAbsolute:h}}const _o=function(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:1;return Math.min(Math.max(e,t),n)},Po=function(){var _n$width,_n$height;let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{x:0,y:0};let t=arguments.length>1?arguments[1]:undefined;let n=arguments.length>2?arguments[2]:undefined;return{x:_o(e.x,t[0][0],t[1][0]-((_n$width=n===null||n===void 0?void 0:n.width)!==null&&_n$width!==void 0?_n$width:0)),y:_o(e.y,t[0][1],t[1][1]-((_n$height=n===null||n===void 0?void 0:n.height)!==null&&_n$height!==void 0?_n$height:0))}};function zo(e,t,n){const{width:o,height:r}=qo(n),{x:i,y:a}=n.internals.positionAbsolute;return Po(e,[[i,a],[i+o,a+r]],t)}const Oo=(e,t,n)=>e<t?_o(Math.abs(e-t),1,t)/t:e>n?-_o(Math.abs(e-n),1,t)/t:0,Ao=function(e,t){let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:15;let o=arguments.length>3&&arguments[3]!==undefined?arguments[3]:40;return[Oo(e.x,o,t.width-o)*n,Oo(e.y,o,t.height-o)*n]},Do=(e,t)=>({x:Math.min(e.x,t.x),y:Math.min(e.y,t.y),x2:Math.max(e.x2,t.x2),y2:Math.max(e.y2,t.y2)}),Io=_ref11=>{let{x:e,y:t,width:n,height:o}=_ref11;return{x:e,y:t,x2:e+n,y2:t+o}},Ro=_ref12=>{let{x:e,y:t,x2:n,y2:o}=_ref12;return{x:e,y:t,width:n-e,height:o-t}},Lo=function(e){var _ref13,_ref14,_e$measured$width,_e$measured,_ref15,_ref16,_e$measured$height,_e$measured2;let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[0,0];const{x:n,y:o}=wo(e)?e.internals.positionAbsolute:bo(e,t);return{x:n,y:o,width:(_ref13=(_ref14=(_e$measured$width=(_e$measured=e.measured)===null||_e$measured===void 0?void 0:_e$measured.width)!==null&&_e$measured$width!==void 0?_e$measured$width:e.width)!==null&&_ref14!==void 0?_ref14:e.initialWidth)!==null&&_ref13!==void 0?_ref13:0,height:(_ref15=(_ref16=(_e$measured$height=(_e$measured2=e.measured)===null||_e$measured2===void 0?void 0:_e$measured2.height)!==null&&_e$measured$height!==void 0?_e$measured$height:e.height)!==null&&_ref16!==void 0?_ref16:e.initialHeight)!==null&&_ref15!==void 0?_ref15:0}},$o=function(e){var _ref17,_ref18,_e$measured$width2,_e$measured3,_ref19,_ref20,_e$measured$height2,_e$measured4;let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[0,0];const{x:n,y:o}=wo(e)?e.internals.positionAbsolute:bo(e,t);return{x:n,y:o,x2:n+((_ref17=(_ref18=(_e$measured$width2=(_e$measured3=e.measured)===null||_e$measured3===void 0?void 0:_e$measured3.width)!==null&&_e$measured$width2!==void 0?_e$measured$width2:e.width)!==null&&_ref18!==void 0?_ref18:e.initialWidth)!==null&&_ref17!==void 0?_ref17:0),y2:o+((_ref19=(_ref20=(_e$measured$height2=(_e$measured4=e.measured)===null||_e$measured4===void 0?void 0:_e$measured4.height)!==null&&_e$measured$height2!==void 0?_e$measured$height2:e.height)!==null&&_ref20!==void 0?_ref20:e.initialHeight)!==null&&_ref19!==void 0?_ref19:0)}},To=(e,t)=>Ro(Do(Io(e),Io(t))),Vo=(e,t)=>{const n=Math.max(0,Math.min(e.x+e.width,t.x+t.width)-Math.max(e.x,t.x)),o=Math.max(0,Math.min(e.y+e.height,t.y+t.height)-Math.max(e.y,t.y));return Math.ceil(n*o)},Bo=e=>jo(e.width)&&jo(e.height)&&jo(e.x)&&jo(e.y),jo=e=>!isNaN(e)&&isFinite(e),Ho=(e,t)=>{},Zo=function(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:[1,1];return{x:t[0]*Math.round(e.x/t[0]),y:t[1]*Math.round(e.y/t[1])}},Xo=function(_ref21,_ref22){let{x:e,y:t}=_ref21;let[n,o,r]=_ref22;let i=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!1;let a=arguments.length>3&&arguments[3]!==undefined?arguments[3]:[1,1];const s={x:(e-n)/r,y:(t-o)/r};return i?Zo(s,a):s},Yo=(_ref23,_ref24)=>{let{x:e,y:t}=_ref23;let[n,o,r]=_ref24;return{x:e*r+n,y:t*r+o}};function Fo(e,t){if("number"==typeof e)return Math.floor(.5*(t-t/(1+e)));if("string"==typeof e&&e.endsWith("px")){const t=parseFloat(e);if(!Number.isNaN(t))return Math.floor(t)}if("string"==typeof e&&e.endsWith("%")){const n=parseFloat(e);if(!Number.isNaN(n))return Math.floor(t*n*.01)}return console.error(`[React Flow] The padding value "${e}" is invalid. Please provide a number or a string with a valid unit (px or %).`),0}const Wo=(e,t,n,o,r,i)=>{const a=function(e,t,n){if("string"==typeof e||"number"==typeof e){const o=Fo(e,n),r=Fo(e,t);return{top:o,right:r,bottom:o,left:r,x:2*r,y:2*o}}if("object"==typeof e){var _ref25,_e$top,_ref26,_e$bottom,_ref27,_e$left,_ref28,_e$right;const o=Fo((_ref25=(_e$top=e.top)!==null&&_e$top!==void 0?_e$top:e.y)!==null&&_ref25!==void 0?_ref25:0,n),r=Fo((_ref26=(_e$bottom=e.bottom)!==null&&_e$bottom!==void 0?_e$bottom:e.y)!==null&&_ref26!==void 0?_ref26:0,n),i=Fo((_ref27=(_e$left=e.left)!==null&&_e$left!==void 0?_e$left:e.x)!==null&&_ref27!==void 0?_ref27:0,t),a=Fo((_ref28=(_e$right=e.right)!==null&&_e$right!==void 0?_e$right:e.x)!==null&&_ref28!==void 0?_ref28:0,t);return{top:o,right:a,bottom:r,left:i,x:i+a,y:o+r}}return{top:0,right:0,bottom:0,left:0,x:0,y:0}}(i,t,n),s=(t-a.x)/e.width,l=(n-a.y)/e.height,c=Math.min(s,l),u=_o(c,o,r),d=t/2-(e.x+e.width/2)*u,h=n/2-(e.y+e.height/2)*u,f=function(e,t,n,o,r,i){const{x:a,y:s}=Yo(e,[t,n,o]),{x:l,y:c}=Yo({x:e.x+e.width,y:e.y+e.height},[t,n,o]),u=r-l,d=i-c;return{left:Math.floor(a),top:Math.floor(s),right:Math.floor(u),bottom:Math.floor(d)}}(e,d,h,u,t,n),g=Math.min(f.left-a.left,0),p=Math.min(f.top-a.top,0);return{x:d-g+Math.min(f.right-a.right,0),y:h-p+Math.min(f.bottom-a.bottom,0),zoom:u}},Ko=()=>{var _navigator;return"undefined"!=typeof navigator&&((_navigator=navigator)===null||_navigator===void 0||(_navigator=_navigator.userAgent)===null||_navigator===void 0?void 0:_navigator.indexOf("Mac"))>=0};function Go(e){return void 0!==e&&"parent"!==e}function qo(e){var _ref29,_ref30,_e$measured$width3,_e$measured5,_ref31,_ref32,_e$measured$height3,_e$measured6;return{width:(_ref29=(_ref30=(_e$measured$width3=(_e$measured5=e.measured)===null||_e$measured5===void 0?void 0:_e$measured5.width)!==null&&_e$measured$width3!==void 0?_e$measured$width3:e.width)!==null&&_ref30!==void 0?_ref30:e.initialWidth)!==null&&_ref29!==void 0?_ref29:0,height:(_ref31=(_ref32=(_e$measured$height3=(_e$measured6=e.measured)===null||_e$measured6===void 0?void 0:_e$measured6.height)!==null&&_e$measured$height3!==void 0?_e$measured$height3:e.height)!==null&&_ref32!==void 0?_ref32:e.initialHeight)!==null&&_ref31!==void 0?_ref31:0}}function Uo(e){var _ref33,_e$measured$width4,_e$measured7,_ref34,_e$measured$height4,_e$measured8;return void 0!==((_ref33=(_e$measured$width4=(_e$measured7=e.measured)===null||_e$measured7===void 0?void 0:_e$measured7.width)!==null&&_e$measured$width4!==void 0?_e$measured$width4:e.width)!==null&&_ref33!==void 0?_ref33:e.initialWidth)&&void 0!==((_ref34=(_e$measured$height4=(_e$measured8=e.measured)===null||_e$measured8===void 0?void 0:_e$measured8.height)!==null&&_e$measured$height4!==void 0?_e$measured$height4:e.height)!==null&&_ref34!==void 0?_ref34:e.initialHeight)}function Qo(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{width:0,height:0};let n=arguments.length>2?arguments[2]:undefined;let o=arguments.length>3?arguments[3]:undefined;let r=arguments.length>4?arguments[4]:undefined;const i={...e},a=o.get(n);if(a){var _t$width,_t$height;const e=a.origin||r;i.x+=a.internals.positionAbsolute.x-((_t$width=t.width)!==null&&_t$width!==void 0?_t$width:0)*e[0],i.y+=a.internals.positionAbsolute.y-((_t$height=t.height)!==null&&_t$height!==void 0?_t$height:0)*e[1]}return i}function Jo(e,t){if(e.size!==t.size)return!1;for(const n of e)if(!t.has(n))return!1;return!0}function er(e,_ref35){var _r$left,_r$top;let{snapGrid:t=[0,0],snapToGrid:n=!1,transform:o,containerBounds:r}=_ref35;const{x:i,y:a}=ar(e),s=Xo({x:i-((_r$left=r===null||r===void 0?void 0:r.left)!==null&&_r$left!==void 0?_r$left:0),y:a-((_r$top=r===null||r===void 0?void 0:r.top)!==null&&_r$top!==void 0?_r$top:0)},o),{x:l,y:c}=n?Zo(s,t):s;return{xSnapped:l,ySnapped:c,...s}}const tr=e=>({width:e.offsetWidth,height:e.offsetHeight}),nr=e=>{var _e$getRootNode,_window;return(e===null||e===void 0||(_e$getRootNode=e.getRootNode)===null||_e$getRootNode===void 0?void 0:_e$getRootNode.call(e))||((_window=window)===null||_window===void 0?void 0:_window.document)},or=["INPUT","SELECT","TEXTAREA"];function rr(e){var _e$composedPath;const t=((_e$composedPath=e.composedPath)===null||_e$composedPath===void 0||(_e$composedPath=_e$composedPath.call(e))===null||_e$composedPath===void 0?void 0:_e$composedPath[0])||e.target;if(1!==(t===null||t===void 0?void 0:t.nodeType))return!1;return or.includes(t.nodeName)||t.hasAttribute("contenteditable")||!!t.closest(".nokey")}const ir=e=>"clientX"in e,ar=(e,t)=>{var _e$touches,_e$touches2,_t$left,_t$top;const n=ir(e),o=n?e.clientX:(_e$touches=e.touches)===null||_e$touches===void 0?void 0:_e$touches[0].clientX,r=n?e.clientY:(_e$touches2=e.touches)===null||_e$touches2===void 0?void 0:_e$touches2[0].clientY;return{x:o-((_t$left=t===null||t===void 0?void 0:t.left)!==null&&_t$left!==void 0?_t$left:0),y:r-((_t$top=t===null||t===void 0?void 0:t.top)!==null&&_t$top!==void 0?_t$top:0)}},sr=(e,t,n,o,r)=>{const i=t.querySelectorAll(`.${e}`);return i&&i.length?Array.from(i).map(t=>{const i=t.getBoundingClientRect();return{id:t.getAttribute("data-handleid"),type:e,nodeId:r,position:t.getAttribute("data-handlepos"),x:(i.left-n.left)/o,y:(i.top-n.top)/o,...tr(t)}}):null};function lr(_ref36){let{sourceX:e,sourceY:t,targetX:n,targetY:o,sourceControlX:r,sourceControlY:i,targetControlX:a,targetControlY:s}=_ref36;const l=.125*e+.375*r+.375*a+.125*n,c=.125*t+.375*i+.375*s+.125*o;return[l,c,Math.abs(l-e),Math.abs(c-t)]}function cr(e,t){return e>=0?.5*e:25*t*Math.sqrt(-e)}function ur(_ref37){let{pos:t,x1:n,y1:o,x2:r,y2:i,c:a}=_ref37;switch(t){case e.Position.Left:return[n-cr(n-r,a),o];case e.Position.Right:return[n+cr(r-n,a),o];case e.Position.Top:return[n,o-cr(o-i,a)];case e.Position.Bottom:return[n,o+cr(i-o,a)]}}function dr(_ref38){let{sourceX:t,sourceY:n,sourcePosition:o=e.Position.Bottom,targetX:r,targetY:i,targetPosition:a=e.Position.Top,curvature:s=.25}=_ref38;const[l,c]=ur({pos:o,x1:t,y1:n,x2:r,y2:i,c:s}),[u,d]=ur({pos:a,x1:r,y1:i,x2:t,y2:n,c:s}),[h,f,g,p]=lr({sourceX:t,sourceY:n,targetX:r,targetY:i,sourceControlX:l,sourceControlY:c,targetControlX:u,targetControlY:d});return[`M${t},${n} C${l},${c} ${u},${d} ${r},${i}`,h,f,g,p]}function hr(_ref39){let{sourceX:e,sourceY:t,targetX:n,targetY:o}=_ref39;const r=Math.abs(n-e)/2,i=n<e?n+r:n-r,a=Math.abs(o-t)/2;return[i,o<t?o+a:o-a,r,a]}function fr(_ref40){let{sourceNode:e,targetNode:t,width:n,height:o,transform:r}=_ref40;const i=Do($o(e),$o(t));i.x===i.x2&&(i.x2+=1),i.y===i.y2&&(i.y2+=1);const a={x:-r[0]/r[2],y:-r[1]/r[2],width:n/r[2],height:o/r[2]};return Vo(a,Ro(i))>0}const gr=_ref41=>{let{source:e,sourceHandle:t,target:n,targetHandle:o}=_ref41;return`xy-edge__${e}${t||""}-${n}${o||""}`},pr=(e,t)=>{if(!e.source||!e.target)return t;let n;return n=xo(e)?{...e}:{...e,id:gr(e)},((e,t)=>t.some(t=>!(t.source!==e.source||t.target!==e.target||t.sourceHandle!==e.sourceHandle&&(t.sourceHandle||e.sourceHandle)||t.targetHandle!==e.targetHandle&&(t.targetHandle||e.targetHandle))))(n,t)?t:(null===n.sourceHandle&&delete n.sourceHandle,null===n.targetHandle&&delete n.targetHandle,t.concat(n))};function mr(_ref42){let{sourceX:e,sourceY:t,targetX:n,targetY:o}=_ref42;const[r,i,a,s]=hr({sourceX:e,sourceY:t,targetX:n,targetY:o});return[`M ${e},${t}L ${n},${o}`,r,i,a,s]}const yr={[e.Position.Left]:{x:-1,y:0},[e.Position.Right]:{x:1,y:0},[e.Position.Top]:{x:0,y:-1},[e.Position.Bottom]:{x:0,y:1}},vr=_ref43=>{let{source:t,sourcePosition:n=e.Position.Bottom,target:o}=_ref43;return n===e.Position.Left||n===e.Position.Right?t.x<o.x?{x:1,y:0}:{x:-1,y:0}:t.y<o.y?{x:0,y:1}:{x:0,y:-1}},xr=(e,t)=>Math.sqrt(Math.pow(t.x-e.x,2)+Math.pow(t.y-e.y,2));function wr(_ref44){let{sourceX:t,sourceY:n,sourcePosition:o=e.Position.Bottom,targetX:r,targetY:i,targetPosition:a=e.Position.Top,borderRadius:s=5,centerX:l,centerY:c,offset:u=20,stepPosition:d=.5}=_ref44;const[h,f,g,p,m]=function(_ref45){let{source:t,sourcePosition:n=e.Position.Bottom,target:o,targetPosition:r=e.Position.Top,center:i,offset:a,stepPosition:s}=_ref45;const l=yr[n],c=yr[r],u={x:t.x+l.x*a,y:t.y+l.y*a},d={x:o.x+c.x*a,y:o.y+c.y*a},h=vr({source:u,sourcePosition:n,target:d}),f=0!==h.x?"x":"y",g=h[f];let p,m,y=[];const v={x:0,y:0},x={x:0,y:0},[,,w,b]=hr({sourceX:t.x,sourceY:t.y,targetX:o.x,targetY:o.y});if(l[f]*c[f]==-1){var _i$x,_i$y,_i$x2,_i$y2;"x"===f?(p=(_i$x=i.x)!==null&&_i$x!==void 0?_i$x:u.x+(d.x-u.x)*s,m=(_i$y=i.y)!==null&&_i$y!==void 0?_i$y:(u.y+d.y)/2):(p=(_i$x2=i.x)!==null&&_i$x2!==void 0?_i$x2:(u.x+d.x)/2,m=(_i$y2=i.y)!==null&&_i$y2!==void 0?_i$y2:u.y+(d.y-u.y)*s);const e=[{x:p,y:u.y},{x:p,y:d.y}],t=[{x:u.x,y:m},{x:d.x,y:m}];y=l[f]===g?"x"===f?e:t:"x"===f?t:e}else{const e=[{x:u.x,y:d.y}],i=[{x:d.x,y:u.y}];if(y="x"===f?l.x===g?i:e:l.y===g?e:i,n===r){const e=Math.abs(t[f]-o[f]);if(e<=a){const n=Math.min(a-1,a-e);l[f]===g?v[f]=(u[f]>t[f]?-1:1)*n:x[f]=(d[f]>o[f]?-1:1)*n}}if(n!==r){const t="x"===f?"y":"x",n=l[f]===c[t],o=u[t]>d[t],r=u[t]<d[t];(1===l[f]&&(!n&&o||n&&r)||1!==l[f]&&(!n&&r||n&&o))&&(y="x"===f?e:i)}const s={x:u.x+v.x,y:u.y+v.y},h={x:d.x+x.x,y:d.y+x.y};Math.max(Math.abs(s.x-y[0].x),Math.abs(h.x-y[0].x))>=Math.max(Math.abs(s.y-y[0].y),Math.abs(h.y-y[0].y))?(p=(s.x+h.x)/2,m=y[0].y):(p=y[0].x,m=(s.y+h.y)/2)}return[[t,{x:u.x+v.x,y:u.y+v.y},...y,{x:d.x+x.x,y:d.y+x.y},o],p,m,w,b]}({source:{x:t,y:n},sourcePosition:o,target:{x:r,y:i},targetPosition:a,center:{x:l,y:c},offset:u,stepPosition:d});return[h.reduce((e,t,n)=>{let o="";return o=n>0&&n<h.length-1?function(e,t,n,o){const r=Math.min(xr(e,t)/2,xr(t,n)/2,o),{x:i,y:a}=t;if(e.x===i&&i===n.x||e.y===a&&a===n.y)return`L${i} ${a}`;if(e.y===a)return`L ${i+r*(e.x<n.x?-1:1)},${a}Q ${i},${a} ${i},${a+r*(e.y<n.y?1:-1)}`;const s=e.x<n.x?1:-1;return`L ${i},${a+r*(e.y<n.y?-1:1)}Q ${i},${a} ${i+r*s},${a}`}(h[n-1],t,h[n+1],s):`${0===n?"M":"L"}${t.x} ${t.y}`,e+=o},""),f,g,p,m]}function br(e){var _e$handles;return e&&!(!e.internals.handleBounds&&!((_e$handles=e.handles)!==null&&_e$handles!==void 0&&_e$handles.length))&&!!(e.measured.width||e.width||e.initialWidth)}function Sr(e){if(!e)return null;const t=[],n=[];for(const o of e){var _o$width,_o$height;o.width=(_o$width=o.width)!==null&&_o$width!==void 0?_o$width:1,o.height=(_o$height=o.height)!==null&&_o$height!==void 0?_o$height:1,"source"===o.type?t.push(o):"target"===o.type&&n.push(o)}return{source:t,target:n}}function Cr(t,n){var _n$x,_n$y,_n$position;let o=arguments.length>2&&arguments[2]!==undefined?arguments[2]:e.Position.Left;let r=arguments.length>3&&arguments[3]!==undefined?arguments[3]:!1;const i=((_n$x=n===null||n===void 0?void 0:n.x)!==null&&_n$x!==void 0?_n$x:0)+t.internals.positionAbsolute.x,a=((_n$y=n===null||n===void 0?void 0:n.y)!==null&&_n$y!==void 0?_n$y:0)+t.internals.positionAbsolute.y,{width:s,height:l}=n!==null&&n!==void 0?n:qo(t);if(r)return{x:i+s/2,y:a+l/2};switch((_n$position=n===null||n===void 0?void 0:n.position)!==null&&_n$position!==void 0?_n$position:o){case e.Position.Top:return{x:i+s/2,y:a};case e.Position.Right:return{x:i+s,y:a+l/2};case e.Position.Bottom:return{x:i+s/2,y:a+l};case e.Position.Left:return{x:i,y:a+l/2}}}function Er(e,t){return e&&(t?e.find(e=>e.id===t):e[0])||null}function kr(e,t){if(!e)return"";if("string"==typeof e)return e;return`${t?`${t}__`:""}${Object.keys(e).sort().map(t=>`${t}=${e[t]}`).join("&")}`}function Mr(t,n,o,r,i){let a=.5;"start"===i?a=0:"end"===i&&(a=1);let s=[(t.x+t.width*a)*n.zoom+n.x,t.y*n.zoom+n.y-r],l=[-100*a,-100];switch(o){case e.Position.Right:s=[(t.x+t.width)*n.zoom+n.x+r,(t.y+t.height*a)*n.zoom+n.y],l=[0,-100*a];break;case e.Position.Bottom:s[1]=(t.y+t.height)*n.zoom+n.y+r,l[1]=0;break;case e.Position.Left:s=[t.x*n.zoom+n.x-r,(t.y+t.height*a)*n.zoom+n.y],l=[-100,-100*a]}return`translate(${s[0]}px, ${s[1]}px) translate(${l[0]}%, ${l[1]}%)`}const Nr={nodeOrigin:[0,0],nodeExtent:ro,elevateNodesOnSelect:!0,defaults:{}},_r={...Nr,checkEquality:!0};function Pr(e,t){const n={...e};for(const e in t)void 0!==t[e]&&(n[e]=t[e]);return n}function zr(e,t,n,o){const r=Pr(_r,o);let i=e.length>0;const a=new Map(t),s=r!==null&&r!==void 0&&r.elevateNodesOnSelect?1e3:0;t.clear(),n.clear();for(const l of e){var _e2;let e=a.get(l.id);if(r.checkEquality&&l===((_e2=e)===null||_e2===void 0?void 0:_e2.internals.userNode))t.set(l.id,e);else{var _l$measured,_l$measured2,_e3;const n=bo(l,r.nodeOrigin),o=Go(l.extent)?l.extent:r.nodeExtent,i=Po(n,o,qo(l));e={...r.defaults,...l,measured:{width:(_l$measured=l.measured)===null||_l$measured===void 0?void 0:_l$measured.width,height:(_l$measured2=l.measured)===null||_l$measured2===void 0?void 0:_l$measured2.height},internals:{positionAbsolute:i,handleBounds:l.measured?(_e3=e)===null||_e3===void 0?void 0:_e3.internals.handleBounds:void 0,z:Ar(l,s),userNode:l}},t.set(l.id,e)}void 0!==e.measured&&void 0!==e.measured.width&&void 0!==e.measured.height||e.hidden||(i=!1),l.parentId&&Or(e,t,n,o)}return i}function Or(e,t,n,o){const{elevateNodesOnSelect:r,nodeOrigin:i,nodeExtent:a}=Pr(Nr,o),s=e.parentId,l=t.get(s);if(!l)return void console.warn(`Parent node ${s} not found. Please make sure that parent nodes are in front of their child nodes in the nodes array.`);!function(e,t){if(!e.parentId)return;const n=t.get(e.parentId);n?n.set(e.id,e):t.set(e.parentId,new Map([[e.id,e]]))}(e,n);const c=r?1e3:0,{x:u,y:d,z:h}=function(e,t,n,o,r,_t$internals$z){const{x:i,y:a}=t.internals.positionAbsolute,s=qo(e),l=bo(e,n),c=Go(e.extent)?Po(l,e.extent,s):l;let u=Po({x:i+c.x,y:a+c.y},o,s);"parent"===e.extent&&(u=zo(u,s,t));const d=Ar(e,r),h=(_t$internals$z=t.internals.z)!==null&&_t$internals$z!==void 0?_t$internals$z:0;return{x:u.x,y:u.y,z:h>=d?h+1:d}}(e,l,i,a,c),{positionAbsolute:f}=e.internals,g=u!==f.x||d!==f.y;(g||h!==e.internals.z)&&t.set(e.id,{...e,internals:{...e.internals,positionAbsolute:g?{x:u,y:d}:f,z:h}})}function Ar(e,t){return(jo(e.zIndex)?e.zIndex:0)+(e.selected?t:0)}function Dr(e,t,n){let o=arguments.length>3&&arguments[3]!==undefined?arguments[3]:[0,0];const r=[],i=new Map;for(const n of e){var _i$get$expandedRect,_i$get;const e=t.get(n.parentId);if(!e)continue;const o=(_i$get$expandedRect=(_i$get=i.get(n.parentId))===null||_i$get===void 0?void 0:_i$get.expandedRect)!==null&&_i$get$expandedRect!==void 0?_i$get$expandedRect:Lo(e),r=To(o,n.rect);i.set(n.parentId,{expandedRect:r,parent:e})}return i.size>0&&i.forEach((_ref46,a)=>{var _i$origin,_n$get;let{expandedRect:t,parent:i}=_ref46;const s=i.internals.positionAbsolute,l=qo(i),c=(_i$origin=i.origin)!==null&&_i$origin!==void 0?_i$origin:o,u=t.x<s.x?Math.round(Math.abs(s.x-t.x)):0,d=t.y<s.y?Math.round(Math.abs(s.y-t.y)):0,h=Math.max(l.width,Math.round(t.width)),f=Math.max(l.height,Math.round(t.height)),g=(h-l.width)*c[0],p=(f-l.height)*c[1];(u>0||d>0||g||p)&&(r.push({id:a,type:"position",position:{x:i.position.x-u+g,y:i.position.y-d+p}}),(_n$get=n.get(a))!==null&&_n$get!==void 0&&_n$get.forEach(t=>{e.some(e=>e.id===t.id)||r.push({id:t.id,type:"position",position:{x:t.position.x+u,y:t.position.y+d}})})),(l.width<t.width||l.height<t.height||u||d)&&r.push({id:a,type:"dimensions",setAttributes:!0,dimensions:{width:h+(u?c[0]*u-g:0),height:f+(d?c[1]*d-p:0)}})}),r}function Ir(e,t,n,o,r,i){let a=r;const s=o.get(a)||new Map;o.set(a,s.set(n,t)),a=`${r}-${e}`;const l=o.get(a)||new Map;if(o.set(a,l.set(n,t)),i){a=`${r}-${e}-${i}`;const s=o.get(a)||new Map;o.set(a,s.set(n,t))}}function Rr(e,t,n){e.clear(),t.clear();for(const o of n){const{source:n,target:r,sourceHandle:i=null,targetHandle:a=null}=o,s={edgeId:o.id,source:n,target:r,sourceHandle:i,targetHandle:a},l=`${n}-${i}--${r}-${a}`;Ir("source",s,`${r}-${a}--${n}-${i}`,e,n,i),Ir("target",s,l,e,r,a),t.set(o.id,o)}}function Lr(e,t){if(null===e||null===t)return!1;const n=Array.isArray(e)?e:[e],o=Array.isArray(t)?t:[t];if(n.length!==o.length)return!1;for(let e=0;e<n.length;e++)if(n[e].id!==o[e].id||n[e].type!==o[e].type||!Object.is(n[e].data,o[e].data))return!1;return!0}function $r(e,t){if(!e.parentId)return!1;const n=t.get(e.parentId);return!!n&&(!!n.selected||$r(n,t))}function Tr(e,t,n){let o=e;do{var _o2,_o2$matches,_o3;if((_o2=o)!==null&&_o2!==void 0&&(_o2$matches=_o2.matches)!==null&&_o2$matches!==void 0&&_o2$matches.call(_o2,t))return!0;if(o===n)return!1;o=(_o3=o)===null||_o3===void 0?void 0:_o3.parentElement}while(o);return!1}function Vr(_ref47){var _n$get3,_t$get;let{nodeId:e,dragItems:t,nodeLookup:n,dragging:o=!0}=_ref47;const r=[];for(const[e,i]of t){var _n$get2;const t=(_n$get2=n.get(e))===null||_n$get2===void 0?void 0:_n$get2.internals.userNode;t&&r.push({...t,position:i.position,dragging:o})}if(!e)return[r[0],r];const i=(_n$get3=n.get(e))===null||_n$get3===void 0?void 0:_n$get3.internals.userNode;return[i?{...i,position:((_t$get=t.get(e))===null||_t$get===void 0?void 0:_t$get.position)||i.position,dragging:o}:r[0],r]}function Br(_ref48){let{onNodeMouseDown:e,getStoreItems:t,onDragStart:n,onDrag:o,onDragStop:r}=_ref48;let i={x:null,y:null},a=0,s=new Map,l=!1,c={x:0,y:0},u=null,d=!1,h=null,f=!1,g=!1;return{update:function(_ref49){let{noDragClassName:p,handleSelector:m,domNode:y,isSelectable:v,nodeId:x,nodeClickDistance:w=0}=_ref49;function b(_ref50,r){let{x:e,y:n}=_ref50;const{nodeLookup:a,nodeExtent:l,snapGrid:c,snapToGrid:u,nodeOrigin:d,onNodeDrag:h,onSelectionDrag:f,onError:p,updateNodePositions:m}=t();i={x:e,y:n};let y=!1,v={x:0,y:0,x2:0,y2:0};if(s.size>1&&l){const e=Co(s);v=Io(e)}for(const[t,o]of s){if(!a.has(t))continue;let r={x:e-o.distance.x,y:n-o.distance.y};u&&(r=Zo(r,c));let i=[[l[0][0],l[0][1]],[l[1][0],l[1][1]]];if(s.size>1&&l&&!o.extent){const{positionAbsolute:e}=o.internals,t=e.x-v.x+l[0][0],n=e.x+o.measured.width-v.x2+l[1][0];i=[[t,e.y-v.y+l[0][1]],[n,e.y+o.measured.height-v.y2+l[1][1]]]}const{position:h,positionAbsolute:f}=No({nodeId:t,nextPosition:r,nodeLookup:a,nodeExtent:i,nodeOrigin:d,onError:p});y=y||o.position.x!==h.x||o.position.y!==h.y,o.position=h,o.internals.positionAbsolute=f}if(g=g||y,y&&(m(s,!0),r&&(o||h||!x&&f))){const[e,t]=Vr({nodeId:x,dragItems:s,nodeLookup:a});o!==null&&o!==void 0&&o(r,s,e,t),h!==null&&h!==void 0&&h(r,e,t),x||(f===null||f===void 0?void 0:f(r,t))}}async function S(){var _i$x3,_i$y3;if(!u)return;const{transform:e,panBy:n,autoPanSpeed:o,autoPanOnNodeDrag:r}=t();if(!r)return l=!1,void cancelAnimationFrame(a);const[s,d]=Ao(c,u,o);0===s&&0===d||(i.x=((_i$x3=i.x)!==null&&_i$x3!==void 0?_i$x3:0)-s/e[2],i.y=((_i$y3=i.y)!==null&&_i$y3!==void 0?_i$y3:0)-d/e[2],await n({x:s,y:d})&&b(i,null)),a=requestAnimationFrame(S)}function C(o){var _r$get;const{nodeLookup:r,multiSelectionActive:a,nodesDraggable:l,transform:c,snapGrid:h,snapToGrid:f,selectNodesOnDrag:g,onNodeDragStart:p,onSelectionDragStart:m,unselectNodesAndEdges:y}=t();d=!0,g&&v||a||!x||(_r$get=r.get(x))!==null&&_r$get!==void 0&&_r$get.selected||y(),v&&g&&x&&(e===null||e===void 0?void 0:e(x));const w=er(o.sourceEvent,{transform:c,snapGrid:h,snapToGrid:f,containerBounds:u});if(i=w,s=function(e,t,n,o){const r=new Map;for(const[i,a]of e)if((a.selected||a.id===o)&&(!a.parentId||!$r(a,e))&&(a.draggable||t&&void 0===a.draggable)){var _t$measured$width,_t$measured$height;const t=e.get(i);t&&r.set(i,{id:i,position:t.position||{x:0,y:0},distance:{x:n.x-t.internals.positionAbsolute.x,y:n.y-t.internals.positionAbsolute.y},extent:t.extent,parentId:t.parentId,origin:t.origin,expandParent:t.expandParent,internals:{positionAbsolute:t.internals.positionAbsolute||{x:0,y:0}},measured:{width:(_t$measured$width=t.measured.width)!==null&&_t$measured$width!==void 0?_t$measured$width:0,height:(_t$measured$height=t.measured.height)!==null&&_t$measured$height!==void 0?_t$measured$height:0}})}return r}(r,l,w,x),s.size>0&&(n||p||!x&&m)){const[e,t]=Vr({nodeId:x,dragItems:s,nodeLookup:r});n!==null&&n!==void 0&&n(o.sourceEvent,s,e,t),p!==null&&p!==void 0&&p(o.sourceEvent,e,t),x||(m===null||m===void 0?void 0:m(o.sourceEvent,t))}}h=Se(y);const E=Le().clickDistance(w).on("start",e=>{const{domNode:n,nodeDragThreshold:o,transform:r,snapGrid:a,snapToGrid:s}=t();u=(n===null||n===void 0?void 0:n.getBoundingClientRect())||null,f=!1,g=!1,0===o&&C(e);const l=er(e.sourceEvent,{transform:r,snapGrid:a,snapToGrid:s,containerBounds:u});i=l,c=ar(e.sourceEvent,u)}).on("drag",e=>{const{autoPanOnNodeDrag:n,transform:o,snapGrid:r,snapToGrid:a,nodeDragThreshold:h,nodeLookup:g}=t(),p=er(e.sourceEvent,{transform:o,snapGrid:r,snapToGrid:a,containerBounds:u});if(("touchmove"===e.sourceEvent.type&&e.sourceEvent.touches.length>1||x&&!g.has(x))&&(f=!0),!f){if(!l&&n&&d&&(l=!0,S()),!d){var _i$x4,_i$y4;const t=p.xSnapped-((_i$x4=i.x)!==null&&_i$x4!==void 0?_i$x4:0),n=p.ySnapped-((_i$y4=i.y)!==null&&_i$y4!==void 0?_i$y4:0);Math.sqrt(t*t+n*n)>h&&C(e)}(i.x!==p.xSnapped||i.y!==p.ySnapped)&&s&&d&&(c=ar(e.sourceEvent,u),b(p,e.sourceEvent))}}).on("end",e=>{if(d&&!f&&(l=!1,d=!1,cancelAnimationFrame(a),s.size>0)){const{nodeLookup:n,updateNodePositions:o,onNodeDragStop:i,onSelectionDragStop:a}=t();if(g&&(o(s,!1),g=!1),r||i||!x&&a){const[t,o]=Vr({nodeId:x,dragItems:s,nodeLookup:n,dragging:!1});r!==null&&r!==void 0&&r(e.sourceEvent,s,t,o),i!==null&&i!==void 0&&i(e.sourceEvent,t,o),x||(a===null||a===void 0?void 0:a(e.sourceEvent,o))}}}).filter(e=>{const t=e.target;return!e.button&&(!p||!Tr(t,`.${p}`,y))&&(!m||Tr(t,m,y))});h.call(E)},destroy:function(){var _h;(_h=h)===null||_h===void 0||_h.on(".drag",null)}}}const jr=250;function Hr(e,t,n,o){let r=[],i=1/0;const a=function(e,t,n){const o=[],r={x:e.x-n,y:e.y-n,width:2*n,height:2*n};for(const e of t.values())Vo(r,Lo(e))>0&&o.push(e);return o}(e,n,t+jr);for(const n of a){var _n$internals$handleBo,_n$internals$handleBo2,_n$internals$handleBo3,_n$internals$handleBo4;const a=[...(_n$internals$handleBo=(_n$internals$handleBo2=n.internals.handleBounds)===null||_n$internals$handleBo2===void 0?void 0:_n$internals$handleBo2.source)!==null&&_n$internals$handleBo!==void 0?_n$internals$handleBo:[],...(_n$internals$handleBo3=(_n$internals$handleBo4=n.internals.handleBounds)===null||_n$internals$handleBo4===void 0?void 0:_n$internals$handleBo4.target)!==null&&_n$internals$handleBo3!==void 0?_n$internals$handleBo3:[]];for(const s of a){if(o.nodeId===s.nodeId&&o.type===s.type&&o.id===s.id)continue;const{x:a,y:l}=Cr(n,s,s.position,!0),c=Math.sqrt(Math.pow(a-e.x,2)+Math.pow(l-e.y,2));c>t||(c<i?(r=[{...s,x:a,y:l}],i=c):c===i&&r.push({...s,x:a,y:l}))}}if(!r.length)return null;if(r.length>1){var _r$find;const e="source"===o.type?"target":"source";return(_r$find=r.find(t=>t.type===e))!==null&&_r$find!==void 0?_r$find:r[0]}return r[0]}function Zr(e,t,n,o,r){var _a$internals$handleBo,_a$internals$handleBo2,_a$internals$handleBo3,_a$internals$handleBo4,_a$internals$handleBo5,_ref51;let i=arguments.length>5&&arguments[5]!==undefined?arguments[5]:!1;const a=o.get(e);if(!a)return null;const s="strict"===r?(_a$internals$handleBo=a.internals.handleBounds)===null||_a$internals$handleBo===void 0?void 0:_a$internals$handleBo[t]:[...(_a$internals$handleBo2=(_a$internals$handleBo3=a.internals.handleBounds)===null||_a$internals$handleBo3===void 0?void 0:_a$internals$handleBo3.source)!==null&&_a$internals$handleBo2!==void 0?_a$internals$handleBo2:[],...(_a$internals$handleBo4=(_a$internals$handleBo5=a.internals.handleBounds)===null||_a$internals$handleBo5===void 0?void 0:_a$internals$handleBo5.target)!==null&&_a$internals$handleBo4!==void 0?_a$internals$handleBo4:[]],l=(_ref51=n?s===null||s===void 0?void 0:s.find(e=>e.id===n):s===null||s===void 0?void 0:s[0])!==null&&_ref51!==void 0?_ref51:null;return l&&i?{...l,...Cr(a,l,l.position,!0)}:l}function Xr(e,t){return e||(t!==null&&t!==void 0&&t.classList.contains("target")?"target":t!==null&&t!==void 0&&t.classList.contains("source")?"source":null)}const Yr=()=>!0;function Fr(t,_ref52){let{handle:n,connectionMode:o,fromNodeId:r,fromHandleId:i,fromType:a,doc:s,lib:l,flowId:c,isValidConnection:u=Yr,nodeLookup:d}=_ref52;const h="target"===a,f=n?s.querySelector(`.${l}-flow__handle[data-id="${c}-${n===null||n===void 0?void 0:n.nodeId}-${n===null||n===void 0?void 0:n.id}-${n===null||n===void 0?void 0:n.type}"]`):null,{x:g,y:p}=ar(t),m=s.elementFromPoint(g,p),y=m!==null&&m!==void 0&&m.classList.contains(`${l}-flow__handle`)?m:f,v={handleDomNode:y,isValid:!1,connection:null,toHandle:null};if(y){const t=Xr(void 0,y),n=y.getAttribute("data-nodeid"),a=y.getAttribute("data-handleid"),s=y.classList.contains("connectable"),l=y.classList.contains("connectableend");if(!n||!t)return v;const c={source:h?n:r,sourceHandle:h?a:i,target:h?r:n,targetHandle:h?i:a};v.connection=c;const f=s&&l&&(o===e.ConnectionMode.Strict?h&&"source"===t||!h&&"target"===t:n!==r||a!==i);v.isValid=f&&u(c),v.toHandle=Zr(n,t,a,d,o,!0)}return v}const Wr={onPointerDown:function(t,_ref53){let{connectionMode:n,connectionRadius:o,handleId:r,nodeId:i,edgeUpdaterType:a,isTarget:s,domNode:l,nodeLookup:c,lib:u,autoPanOnConnect:d,flowId:h,panBy:f,cancelConnection:g,onConnectStart:p,onConnect:m,onConnectEnd:y,isValidConnection:v=Yr,onReconnectEnd:x,updateConnection:w,getTransform:b,getFromHandle:S,autoPanSpeed:C,dragThreshold:E=1}=_ref53;const k=nr(t.target);let M,N=0;const{x:_,y:P}=ar(t),z=k===null||k===void 0?void 0:k.elementFromPoint(_,P),O=Xr(a,z),A=l===null||l===void 0?void 0:l.getBoundingClientRect();let D=!1;if(!A||!O)return;const I=Zr(i,O,r,c,n);if(!I)return;let R=ar(t,A),L=!1,$=null,T=!1,V=null;function B(){if(!d||!A)return;const[e,t]=Ao(R,A,C);f({x:e,y:t}),N=requestAnimationFrame(B)}const j={...I,nodeId:i,type:O,position:I.position},H=c.get(i);let Z={inProgress:!0,isValid:null,from:Cr(H,j,e.Position.Left,!0),fromHandle:j,fromPosition:j.position,fromNode:H,to:R,toHandle:null,toPosition:po[j.position],toNode:null};function X(){D=!0,w(Z),p===null||p===void 0?void 0:p(t,{nodeId:i,handleId:r,handleType:O})}function Y(e){if(!D){const{x:t,y:n}=ar(e),o=t-_,r=n-P;if(!(o*o+r*r>E*E))return;X()}if(!S()||!j)return void F(e);const t=b();R=ar(e,A),M=Hr(Xo(R,t,!1,[1,1]),o,c,j),L||(B(),L=!0);const a=Fr(e,{handle:M,connectionMode:n,fromNodeId:i,fromHandleId:r,fromType:s?"target":"source",isValidConnection:v,doc:k,lib:u,flowId:h,nodeLookup:c});V=a.handleDomNode,$=a.connection,T=function(e,t){let n=null;return t?n=!0:e&&!t&&(n=!1),n}(!!M,a.isValid);const l={...Z,isValid:T,to:a.toHandle&&T?Yo({x:a.toHandle.x,y:a.toHandle.y},t):R,toHandle:a.toHandle,toPosition:T&&a.toHandle?a.toHandle.position:po[j.position],toNode:a.toHandle?c.get(a.toHandle.nodeId):null};T&&M&&Z.toHandle&&l.toHandle&&Z.toHandle.type===l.toHandle.type&&Z.toHandle.nodeId===l.toHandle.nodeId&&Z.toHandle.id===l.toHandle.id&&Z.to.x===l.to.x&&Z.to.y===l.to.y||(w(l),Z=l)}function F(e){if(D){(M||V)&&$&&T&&(m===null||m===void 0?void 0:m($));const{inProgress:t,...n}=Z,o={...n,toPosition:Z.toHandle?Z.toPosition:null};y!==null&&y!==void 0&&y(e,o),a&&(x===null||x===void 0?void 0:x(e,o))}g(),cancelAnimationFrame(N),L=!1,T=!1,$=null,V=null,k.removeEventListener("mousemove",Y),k.removeEventListener("mouseup",F),k.removeEventListener("touchmove",Y),k.removeEventListener("touchend",F)}0===E&&X(),k.addEventListener("mousemove",Y),k.addEventListener("mouseup",F),k.addEventListener("touchmove",Y),k.addEventListener("touchend",F)},isValid:Fr};const Kr=(e,t)=>e.x!==t.x||e.y!==t.y||e.zoom!==t.k,Gr=e=>({x:e.x,y:e.y,zoom:e.k}),qr=_ref54=>{let{x:e,y:t,zoom:n}=_ref54;return Fn.translate(e,t).scale(n)},Ur=(e,t)=>e.target.closest(`.${t}`),Qr=(e,t)=>2===t&&Array.isArray(e)&&e.includes(2),Jr=e=>((e*=2)<=1?e*e*e:(e-=2)*e*e+2)/2,ei=function(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:0;let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:Jr;let o=arguments.length>3&&arguments[3]!==undefined?arguments[3]:()=>{};const r="number"==typeof t&&t>0;return r||o(),r?e.transition().duration(t).ease(n).on("end",o):e},ti=e=>{const t=e.ctrlKey&&Ko()?10:1;return-e.deltaY*(1===e.deltaMode?.05:e.deltaMode?1:.002)*t};function ni(_ref55){let{domNode:t,minZoom:n,maxZoom:o,paneClickDistance:r,translateExtent:i,viewport:a,onPanZoom:s,onPanZoomStart:l,onPanZoomEnd:c,onDraggingChange:u}=_ref55;const d={isZoomingOrPanning:!1,usedRightMouseButton:!1,prevViewport:{x:0,y:0,zoom:0},mouseButton:0,timerId:void 0,panScrollTimeout:void 0,isPanScrolling:!1},h=t.getBoundingClientRect(),f=no().clickDistance(!jo(r)||r<0?0:r).scaleExtent([n,o]).translateExtent(i),g=Se(t).call(f);x({x:a.x,y:a.y,zoom:_o(a.zoom,n,o)},[[0,0],[h.width,h.height]],i);const p=g.on("wheel.zoom"),m=g.on("dblclick.zoom");function y(e,t){return g?new Promise(n=>{f===null||f===void 0||f.interpolate("linear"===(t===null||t===void 0?void 0:t.interpolate)?Pt:Bt).transform(ei(g,t===null||t===void 0?void 0:t.duration,t===null||t===void 0?void 0:t.ease,()=>n(!0)),e)}):Promise.resolve(!1)}function v(){f.on("zoom",null)}async function x(e,t,n){const o=qr(e),r=f===null||f===void 0?void 0:f.constrain()(o,t,n);return r&&await y(r),new Promise(e=>e(r))}return f.wheelDelta(ti),{update:function(_ref56){let{noWheelClassName:t,noPanClassName:n,onPaneContextMenu:o,userSelectionActive:r,panOnScroll:i,panOnDrag:a,panOnScrollMode:h,panOnScrollSpeed:y,preventScrolling:x,zoomOnPinch:w,zoomOnScroll:b,zoomOnDoubleClick:S,zoomActivationKeyPressed:C,lib:E,onTransformChange:k}=_ref56;r&&!d.isZoomingOrPanning&&v();const M=i&&!C&&!r?function(_ref57){let{zoomPanValues:t,noWheelClassName:n,d3Selection:o,d3Zoom:r,panOnScrollMode:i,panOnScrollSpeed:a,zoomOnPinch:s,onPanZoomStart:l,onPanZoom:c,onPanZoomEnd:u}=_ref57;return d=>{if(Ur(d,n))return!1;d.preventDefault(),d.stopImmediatePropagation();const h=o.property("__zoom").k||1;if(d.ctrlKey&&s){const e=Ce(d),t=ti(d),n=h*Math.pow(2,t);return void r.scaleTo(o,n,e,d)}const f=1===d.deltaMode?20:1;let g=i===e.PanOnScrollMode.Vertical?0:d.deltaX*f,p=i===e.PanOnScrollMode.Horizontal?0:d.deltaY*f;!Ko()&&d.shiftKey&&i!==e.PanOnScrollMode.Vertical&&(g=d.deltaY*f,p=0),r.translateBy(o,-g/h*a,-p/h*a,{internal:!0});const m=Gr(o.property("__zoom"));clearTimeout(t.panScrollTimeout),t.isPanScrolling||(t.isPanScrolling=!0,l!==null&&l!==void 0&&l(d,m)),t.isPanScrolling&&(c!==null&&c!==void 0&&c(d,m),t.panScrollTimeout=setTimeout(()=>{u!==null&&u!==void 0&&u(d,m),t.isPanScrolling=!1},150))}}({zoomPanValues:d,noWheelClassName:t,d3Selection:g,d3Zoom:f,panOnScrollMode:h,panOnScrollSpeed:y,zoomOnPinch:w,onPanZoomStart:l,onPanZoom:s,onPanZoomEnd:c}):function(_ref58){let{noWheelClassName:e,preventScrolling:t,d3ZoomHandler:n}=_ref58;return function(o,r){const i="wheel"===o.type,a=!t&&i&&!o.ctrlKey,s=Ur(o,e);if(o.ctrlKey&&i&&s&&o.preventDefault(),a||s)return null;o.preventDefault(),n.call(this,o,r)}}({noWheelClassName:t,preventScrolling:x,d3ZoomHandler:p});if(g.on("wheel.zoom",M,{passive:!1}),!r){const e=function(_ref59){let{zoomPanValues:e,onDraggingChange:t,onPanZoomStart:n}=_ref59;return o=>{var _o$sourceEvent,_o$sourceEvent2,_o$sourceEvent3;if((_o$sourceEvent=o.sourceEvent)!==null&&_o$sourceEvent!==void 0&&_o$sourceEvent.internal)return;const r=Gr(o.transform);e.mouseButton=((_o$sourceEvent2=o.sourceEvent)===null||_o$sourceEvent2===void 0?void 0:_o$sourceEvent2.button)||0,e.isZoomingOrPanning=!0,e.prevViewport=r,"mousedown"===((_o$sourceEvent3=o.sourceEvent)===null||_o$sourceEvent3===void 0?void 0:_o$sourceEvent3.type)&&t(!0),n&&(n===null||n===void 0?void 0:n(o.sourceEvent,r))}}({zoomPanValues:d,onDraggingChange:u,onPanZoomStart:l});f.on("start",e);const t=function(_ref60){let{zoomPanValues:e,panOnDrag:t,onPaneContextMenu:n,onTransformChange:o,onPanZoom:r}=_ref60;return i=>{var _e$mouseButton,_i$sourceEvent,_i$sourceEvent2;e.usedRightMouseButton=!(!n||!Qr(t,(_e$mouseButton=e.mouseButton)!==null&&_e$mouseButton!==void 0?_e$mouseButton:0)),(_i$sourceEvent=i.sourceEvent)!==null&&_i$sourceEvent!==void 0&&_i$sourceEvent.sync||o([i.transform.x,i.transform.y,i.transform.k]),r&&!((_i$sourceEvent2=i.sourceEvent)!==null&&_i$sourceEvent2!==void 0&&_i$sourceEvent2.internal)&&(r===null||r===void 0?void 0:r(i.sourceEvent,Gr(i.transform)))}}({zoomPanValues:d,panOnDrag:a,onPaneContextMenu:!!o,onPanZoom:s,onTransformChange:k});f.on("zoom",t);const n=function(_ref61){let{zoomPanValues:e,panOnDrag:t,panOnScroll:n,onDraggingChange:o,onPanZoomEnd:r,onPaneContextMenu:i}=_ref61;return a=>{var _a$sourceEvent,_e$mouseButton2;if(!((_a$sourceEvent=a.sourceEvent)!==null&&_a$sourceEvent!==void 0&&_a$sourceEvent.internal)&&(e.isZoomingOrPanning=!1,i&&Qr(t,(_e$mouseButton2=e.mouseButton)!==null&&_e$mouseButton2!==void 0?_e$mouseButton2:0)&&!e.usedRightMouseButton&&a.sourceEvent&&i(a.sourceEvent),e.usedRightMouseButton=!1,o(!1),r&&Kr(e.prevViewport,a.transform))){const t=Gr(a.transform);e.prevViewport=t,clearTimeout(e.timerId),e.timerId=setTimeout(()=>{r===null||r===void 0||r(a.sourceEvent,t)},n?150:0)}}}({zoomPanValues:d,panOnDrag:a,panOnScroll:i,onPaneContextMenu:o,onPanZoomEnd:c,onDraggingChange:u});f.on("end",n)}const N=function(_ref62){let{zoomActivationKeyPressed:e,zoomOnScroll:t,zoomOnPinch:n,panOnDrag:o,panOnScroll:r,zoomOnDoubleClick:i,userSelectionActive:a,noWheelClassName:s,noPanClassName:l,lib:c}=_ref62;return u=>{var _u$touches;const d=e||t,h=n&&u.ctrlKey;if(1===u.button&&"mousedown"===u.type&&(Ur(u,`${c}-flow__node`)||Ur(u,`${c}-flow__edge`)))return!0;if(!(o||d||r||i||n))return!1;if(a)return!1;if(Ur(u,s)&&"wheel"===u.type)return!1;if(Ur(u,l)&&("wheel"!==u.type||r&&"wheel"===u.type&&!e))return!1;if(!n&&u.ctrlKey&&"wheel"===u.type)return!1;if(!n&&"touchstart"===u.type&&((_u$touches=u.touches)===null||_u$touches===void 0?void 0:_u$touches.length)>1)return u.preventDefault(),!1;if(!d&&!r&&!h&&"wheel"===u.type)return!1;if(!o&&("mousedown"===u.type||"touchstart"===u.type))return!1;if(Array.isArray(o)&&!o.includes(u.button)&&"mousedown"===u.type)return!1;const f=Array.isArray(o)&&o.includes(u.button)||!u.button||u.button<=1;return(!u.ctrlKey||"wheel"===u.type)&&f}}({zoomActivationKeyPressed:C,panOnDrag:a,zoomOnScroll:b,panOnScroll:i,zoomOnDoubleClick:S,zoomOnPinch:w,userSelectionActive:r,noPanClassName:n,noWheelClassName:t,lib:E});f.filter(N),S?g.on("dblclick.zoom",m):g.on("dblclick.zoom",null)},destroy:v,setViewport:async function(e,t){const n=qr(e);return await y(n,t),new Promise(e=>e(n))},setViewportConstrained:x,getViewport:function(){const e=g?Wn(g.node()):{x:0,y:0,k:1};return{x:e.x,y:e.y,zoom:e.k}},scaleTo:function(e,t){return g?new Promise(n=>{f===null||f===void 0||f.interpolate("linear"===(t===null||t===void 0?void 0:t.interpolate)?Pt:Bt).scaleTo(ei(g,t===null||t===void 0?void 0:t.duration,t===null||t===void 0?void 0:t.ease,()=>n(!0)),e)}):Promise.resolve(!1)},scaleBy:function(e,t){return g?new Promise(n=>{f===null||f===void 0||f.interpolate("linear"===(t===null||t===void 0?void 0:t.interpolate)?Pt:Bt).scaleBy(ei(g,t===null||t===void 0?void 0:t.duration,t===null||t===void 0?void 0:t.ease,()=>n(!0)),e)}):Promise.resolve(!1)},setScaleExtent:function(e){f===null||f===void 0||f.scaleExtent(e)},setTranslateExtent:function(e){f===null||f===void 0||f.translateExtent(e)},syncViewport:function(e){if(g){const t=qr(e),n=g.property("__zoom");n.k===e.zoom&&n.x===e.x&&n.y===e.y||(f===null||f===void 0?void 0:f.transform(g,t,null,{sync:!0}))}},setClickDistance:function(e){const t=!jo(e)||e<0?0:e;f===null||f===void 0||f.clickDistance(t)}}}var oi;e.ResizeControlVariant=void 0,(oi=e.ResizeControlVariant||(e.ResizeControlVariant={})).Line="line",oi.Handle="handle";const ri=["top-left","top-right","bottom-left","bottom-right"],ii=["top","right","bottom","left"];function ai(e,t){return Math.max(0,t-e)}function si(e,t){return Math.max(0,e-t)}function li(e,t,n){return Math.max(0,t-e,e-n)}function ci(e,t){return e?!t:t}const ui={width:0,height:0,x:0,y:0},di={...ui,pointerX:0,pointerY:0,aspectRatio:1};function hi(e,t,n){var _e$measured$width5,_e$measured$height5;const o=t.position.x+e.position.x,r=t.position.y+e.position.y,i=(_e$measured$width5=e.measured.width)!==null&&_e$measured$width5!==void 0?_e$measured$width5:0,a=(_e$measured$height5=e.measured.height)!==null&&_e$measured$height5!==void 0?_e$measured$height5:0,s=n[0]*i,l=n[1]*a;return[[o-s,r-l],[o+i-s,r+a-l]]}function fi(_ref63){let{domNode:e,nodeId:t,getStoreItems:n,onChange:o,onEnd:r}=_ref63;const i=Se(e);return{update:function(_ref64){let{controlPosition:e,boundaries:a,keepAspectRatio:s,resizeDirection:l,onResizeStart:c,onResize:u,onResizeEnd:d,shouldResize:h}=_ref64;let f={...ui},g={...di};const p=function(e){return{isHorizontal:e.includes("right")||e.includes("left"),isVertical:e.includes("bottom")||e.includes("top"),affectsX:e.includes("left"),affectsY:e.includes("top")}}(e);let m,y,v,x,w=null,b=[];const S=Le().on("start",e=>{var _l$getBoundingClientR,_m$measured$width,_m$measured$height,_m$position$x,_m$position$y;const{nodeLookup:o,transform:r,snapGrid:i,snapToGrid:a,nodeOrigin:s,paneDomNode:l}=n();if(m=o.get(t),!m)return;w=(_l$getBoundingClientR=l===null||l===void 0?void 0:l.getBoundingClientRect())!==null&&_l$getBoundingClientR!==void 0?_l$getBoundingClientR:null;const{xSnapped:u,ySnapped:d}=er(e.sourceEvent,{transform:r,snapGrid:i,snapToGrid:a,containerBounds:w});f={width:(_m$measured$width=m.measured.width)!==null&&_m$measured$width!==void 0?_m$measured$width:0,height:(_m$measured$height=m.measured.height)!==null&&_m$measured$height!==void 0?_m$measured$height:0,x:(_m$position$x=m.position.x)!==null&&_m$position$x!==void 0?_m$position$x:0,y:(_m$position$y=m.position.y)!==null&&_m$position$y!==void 0?_m$position$y:0},g={...f,pointerX:u,pointerY:d,aspectRatio:f.width/f.height},y=void 0,m.parentId&&("parent"===m.extent||m.expandParent)&&(y=o.get(m.parentId),v=y&&"parent"===m.extent?function(e){return[[0,0],[e.measured.width,e.measured.height]]}(y):void 0),b=[],x=void 0;for(const[e,n]of o)if(n.parentId===t&&(b.push({id:e,position:{...n.position},extent:n.extent}),"parent"===n.extent||n.expandParent)){var _n$origin;const e=hi(n,m,(_n$origin=n.origin)!==null&&_n$origin!==void 0?_n$origin:s);x=x?[[Math.min(e[0][0],x[0][0]),Math.min(e[0][1],x[0][1])],[Math.max(e[1][0],x[1][0]),Math.max(e[1][1],x[1][1])]]:e}c===null||c===void 0||c(e,{...f})}).on("drag",e=>{var _m$origin;const{transform:t,snapGrid:r,snapToGrid:i,nodeOrigin:c}=n(),d=er(e.sourceEvent,{transform:t,snapGrid:r,snapToGrid:i,containerBounds:w}),S=[];if(!m)return;const{x:C,y:E,width:k,height:M}=f,N={},_=(_m$origin=m.origin)!==null&&_m$origin!==void 0?_m$origin:c,{width:P,height:z,x:O,y:A}=function(e,t,n,o,r,i,a,s){let{affectsX:l,affectsY:c}=t;const{isHorizontal:u,isVertical:d}=t,h=u&&d,{xSnapped:f,ySnapped:g}=n,{minWidth:p,maxWidth:m,minHeight:y,maxHeight:v}=o,{x:x,y:w,width:b,height:S,aspectRatio:C}=e;let E=Math.floor(u?f-e.pointerX:0),k=Math.floor(d?g-e.pointerY:0);const M=b+(l?-E:E),N=S+(c?-k:k),_=-i[0]*b,P=-i[1]*S;let z=li(M,p,m),O=li(N,y,v);if(a){let e=0,t=0;l&&E<0?e=ai(x+E+_,a[0][0]):!l&&E>0&&(e=si(x+M+_,a[1][0])),c&&k<0?t=ai(w+k+P,a[0][1]):!c&&k>0&&(t=si(w+N+P,a[1][1])),z=Math.max(z,e),O=Math.max(O,t)}if(s){let e=0,t=0;l&&E>0?e=si(x+E,s[0][0]):!l&&E<0&&(e=ai(x+M,s[1][0])),c&&k>0?t=si(w+k,s[0][1]):!c&&k<0&&(t=ai(w+N,s[1][1])),z=Math.max(z,e),O=Math.max(O,t)}if(r){if(u){const e=li(M/C,y,v)*C;if(z=Math.max(z,e),a){let e=0;e=!l&&!c||l&&!c&&h?si(w+P+M/C,a[1][1])*C:ai(w+P+(l?E:-E)/C,a[0][1])*C,z=Math.max(z,e)}if(s){let e=0;e=!l&&!c||l&&!c&&h?ai(w+M/C,s[1][1])*C:si(w+(l?E:-E)/C,s[0][1])*C,z=Math.max(z,e)}}if(d){const e=li(N*C,p,m)/C;if(O=Math.max(O,e),a){let e=0;e=!l&&!c||c&&!l&&h?si(x+N*C+_,a[1][0])/C:ai(x+(c?k:-k)*C+_,a[0][0])/C,O=Math.max(O,e)}if(s){let e=0;e=!l&&!c||c&&!l&&h?ai(x+N*C,s[1][0])/C:si(x+(c?k:-k)*C,s[0][0])/C,O=Math.max(O,e)}}}k+=k<0?O:-O,E+=E<0?z:-z,r&&(h?M>N*C?k=(ci(l,c)?-E:E)/C:E=(ci(l,c)?-k:k)*C:u?(k=E/C,c=l):(E=k*C,l=c));const A=l?x+E:x,D=c?w+k:w;return{width:b+(l?-E:E),height:S+(c?-k:k),x:i[0]*E*(l?-1:1)+A,y:i[1]*k*(c?-1:1)+D}}(g,p,d,a,s,_,v,x),D=P!==k,I=z!==M,R=O!==C&&D,L=A!==E&&I;if(!(R||L||D||I))return;if((R||L||1===_[0]||1===_[1])&&(N.x=R?O:f.x,N.y=L?A:f.y,f.x=N.x,f.y=N.y,b.length>0)){const e=O-C,t=A-E;for(const n of b)n.position={x:n.position.x-e+_[0]*(P-k),y:n.position.y-t+_[1]*(z-M)},S.push(n)}if((D||I)&&(N.width=!D||l&&"horizontal"!==l?f.width:P,N.height=!I||l&&"vertical"!==l?f.height:z,f.width=N.width,f.height=N.height),y&&m.expandParent){var _N$width,_N$height;const e=_[0]*((_N$width=N.width)!==null&&_N$width!==void 0?_N$width:0);N.x&&N.x<e&&(f.x=e,g.x=g.x-(N.x-e));const t=_[1]*((_N$height=N.height)!==null&&_N$height!==void 0?_N$height:0);N.y&&N.y<t&&(f.y=t,g.y=g.y-(N.y-t))}const $=function(_ref65){let{width:e,prevWidth:t,height:n,prevHeight:o,affectsX:r,affectsY:i}=_ref65;const a=e-t,s=n-o,l=[a>0?1:a<0?-1:0,s>0?1:s<0?-1:0];return a&&r&&(l[0]=-1*l[0]),s&&i&&(l[1]=-1*l[1]),l}({width:f.width,prevWidth:k,height:f.height,prevHeight:M,affectsX:p.affectsX,affectsY:p.affectsY}),T={...f,direction:$},V=h===null||h===void 0?void 0:h(e,T);!1!==V&&(u!==null&&u!==void 0&&u(e,T),o(N,S))}).on("end",e=>{d!==null&&d!==void 0&&d(e,{...f}),r===null||r===void 0?void 0:r({...f})});i.call(S)},destroy:function(){i.on(".drag",null)}}}function gi(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var pi,mi,yi,vi={exports:{}},xi={},wi={exports:{}},bi={};function Si(){return mi||(mi=1,wi.exports=function(){if(pi)return bi;pi=1;var e=n,t="function"==typeof Object.is?Object.is:function(e,t){return e===t&&(0!==e||1/e==1/t)||e!=e&&t!=t},o=e.useState,r=e.useEffect,i=e.useLayoutEffect,a=e.useDebugValue;function s(e){var n=e.getSnapshot;e=e.value;try{var o=n();return!t(e,o)}catch(e){return!0}}var l="undefined"==typeof window||void 0===window.document||void 0===window.document.createElement?function(e,t){return t()}:function(e,t){var n=t(),l=o({inst:{value:n,getSnapshot:t}}),c=l[0].inst,u=l[1];return i((function(){c.value=n,c.getSnapshot=t,s(c)&&u({inst:c})}),[e,n,t]),r((function(){return s(c)&&u({inst:c}),e((function(){s(c)&&u({inst:c})}))}),[e]),a(n),n};return bi.useSyncExternalStore=void 0!==e.useSyncExternalStore?e.useSyncExternalStore:l,bi}()),wi.exports
/**
     * @license React
     * use-sync-external-store-shim/with-selector.production.min.js
     *
     * Copyright (c) Facebook, Inc. and its affiliates.
     *
     * This source code is licensed under the MIT license found in the
     * LICENSE file in the root directory of this source tree.
     */}vi.exports=function(){if(yi)return xi;yi=1;var e=n,t=Si(),o="function"==typeof Object.is?Object.is:function(e,t){return e===t&&(0!==e||1/e==1/t)||e!=e&&t!=t},r=t.useSyncExternalStore,i=e.useRef,a=e.useEffect,s=e.useMemo,l=e.useDebugValue;return xi.useSyncExternalStoreWithSelector=function(e,t,n,c,u){var d=i(null);if(null===d.current){var h={hasValue:!1,value:null};d.current=h}else h=d.current;d=s((function(){function e(e){if(!a){if(a=!0,r=e,e=c(e),void 0!==u&&h.hasValue){var t=h.value;if(u(t,e))return i=t}return i=e}if(t=i,o(r,e))return t;var n=c(e);return void 0!==u&&u(t,n)?t:(r=e,i=n)}var r,i,a=!1,s=void 0===n?null:n;return[function(){return e(t())},null===s?void 0:function(){return e(s())}]}),[t,n,c,u]);var f=r(e,d[0],d[1]);return a((function(){h.hasValue=!0,h.value=f}),[f]),l(f),f},xi}();var Ci=gi(vi.exports);const Ei=e=>{let t;const n=new Set,o=(e,o)=>{const r="function"==typeof e?e(t):e;if(!Object.is(r,t)){const e=t;t=(null!=o?o:"object"!=typeof r)?r:Object.assign({},t,r),n.forEach(n=>n(t,e))}},r=()=>t,i={setState:o,getState:r,subscribe:e=>(n.add(e),()=>n.delete(e)),destroy:()=>{console.warn("[DEPRECATED] The `destroy` method will be unsupported in a future version. Instead use unsubscribe function returned by subscribe. Everything will be garbage-collected if store is garbage-collected."),n.clear()}};return t=e(o,r,i),i},{useSyncExternalStoreWithSelector:ki}=Ci;function Mi(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:e.getState;let o=arguments.length>2?arguments[2]:undefined;const r=ki(e.subscribe,e.getState,e.getServerState||e.getState,t,o);return n.useDebugValue(r),r}const Ni=(e,t)=>{const n=(e=>e?Ei(e):Ei)(e),o=function(e){let o=arguments.length>1&&arguments[1]!==undefined?arguments[1]:t;return Mi(n,e,o)};return Object.assign(o,n),o},_i=n.createContext(null),Pi=_i.Provider,zi=oo.error001();function Oi(e,t){const o=n.useContext(_i);if(null===o)throw new Error(zi);return Mi(o,e,t)}function Ai(){const e=n.useContext(_i);if(null===e)throw new Error(zi);return n.useMemo(()=>({getState:e.getState,setState:e.setState,subscribe:e.subscribe}),[e])}const Di={display:"none"},Ii={position:"absolute",width:1,height:1,margin:-1,border:0,padding:0,overflow:"hidden",clip:"rect(0px, 0px, 0px, 0px)",clipPath:"inset(100%)"},Ri="react-flow__node-desc",Li="react-flow__edge-desc",$i="react-flow__aria-live",Ti=e=>e.ariaLiveMessage,Vi=e=>e.ariaLabelConfig;function Bi(_ref66){let{rfId:e}=_ref66;const n=Oi(Ti);return t.jsx("div",{id:`${$i}-${e}`,"aria-live":"assertive","aria-atomic":"true",style:Ii,children:n})}function ji(_ref67){let{rfId:e,disableKeyboardA11y:n}=_ref67;const o=Oi(Vi);return t.jsxs(t.Fragment,{children:[t.jsx("div",{id:`${Ri}-${e}`,style:Di,children:n?o["node.a11yDescription.default"]:o["node.a11yDescription.keyboardDisabled"]}),t.jsx("div",{id:`${Li}-${e}`,style:Di,children:o["edge.a11yDescription.default"]}),!n&&t.jsx(Bi,{rfId:e})]})}const Hi=n.forwardRef((_ref68,s)=>{let{position:e="top-left",children:n,className:o,style:i,...a}=_ref68;const l=`${e}`.split("-");return t.jsx("div",{className:r(["react-flow__panel",o,...l]),style:i,ref:s,...a,children:n})});function Zi(_ref69){let{proOptions:e,position:n="bottom-right"}=_ref69;return e!==null&&e!==void 0&&e.hideAttribution?null:t.jsx(Hi,{position:n,className:"react-flow__attribution","data-message":"Please only hide this attribution when you are subscribed to React Flow Pro: https://pro.reactflow.dev",children:t.jsx("a",{href:"https://reactflow.dev",target:"_blank",rel:"noopener noreferrer","aria-label":"React Flow attribution",children:"React Flow"})})}function Xi(e,t){if(Object.is(e,t))return!0;if("object"!=typeof e||null===e||"object"!=typeof t||null===t)return!1;if(e instanceof Map&&t instanceof Map){if(e.size!==t.size)return!1;for(const[n,o]of e)if(!Object.is(o,t.get(n)))return!1;return!0}if(e instanceof Set&&t instanceof Set){if(e.size!==t.size)return!1;for(const n of e)if(!t.has(n))return!1;return!0}const n=Object.keys(e);if(n.length!==Object.keys(t).length)return!1;for(let o=0;o<n.length;o++)if(!Object.prototype.hasOwnProperty.call(t,n[o])||!Object.is(e[n[o]],t[n[o]]))return!1;return!0}Hi.displayName="Panel";const Yi=e=>{const t=[],n=[];for(const[,n]of e.nodeLookup)n.selected&&t.push(n.internals.userNode);for(const[,t]of e.edgeLookup)t.selected&&n.push(t);return{selectedNodes:t,selectedEdges:n}},Fi=e=>e.id;function Wi(e,t){return Xi(e.selectedNodes.map(Fi),t.selectedNodes.map(Fi))&&Xi(e.selectedEdges.map(Fi),t.selectedEdges.map(Fi))}function Ki(_ref70){let{onSelectionChange:e}=_ref70;const t=Ai(),{selectedNodes:o,selectedEdges:r}=Oi(Yi,Wi);return n.useEffect(()=>{const n={nodes:o,edges:r};e!==null&&e!==void 0&&e(n),t.getState().onSelectionChangeHandlers.forEach(e=>e(n))},[o,r,e]),null}const Gi=e=>!!e.onSelectionChangeHandlers;function qi(_ref71){let{onSelectionChange:e}=_ref71;const n=Oi(Gi);return e||n?t.jsx(Ki,{onSelectionChange:e}):null}const Ui=[0,0],Qi={x:0,y:0,zoom:1},Ji=["nodes","edges","defaultNodes","defaultEdges","onConnect","onConnectStart","onConnectEnd","onClickConnectStart","onClickConnectEnd","nodesDraggable","autoPanOnNodeFocus","nodesConnectable","nodesFocusable","edgesFocusable","edgesReconnectable","elevateNodesOnSelect","elevateEdgesOnSelect","minZoom","maxZoom","nodeExtent","onNodesChange","onEdgesChange","elementsSelectable","connectionMode","snapGrid","snapToGrid","translateExtent","connectOnClick","defaultEdgeOptions","fitView","fitViewOptions","onNodesDelete","onEdgesDelete","onDelete","onNodeDrag","onNodeDragStart","onNodeDragStop","onSelectionDrag","onSelectionDragStart","onSelectionDragStop","onMoveStart","onMove","onMoveEnd","noPanClassName","nodeOrigin","autoPanOnConnect","autoPanOnNodeDrag","onError","connectionRadius","isValidConnection","selectNodesOnDrag","nodeDragThreshold","connectionDragThreshold","onBeforeDelete","debug","autoPanSpeed","paneClickDistance","ariaLabelConfig","rfId"],ea=e=>({setNodes:e.setNodes,setEdges:e.setEdges,setMinZoom:e.setMinZoom,setMaxZoom:e.setMaxZoom,setTranslateExtent:e.setTranslateExtent,setNodeExtent:e.setNodeExtent,reset:e.reset,setDefaultNodesAndEdges:e.setDefaultNodesAndEdges,setPaneClickDistance:e.setPaneClickDistance}),ta={translateExtent:ro,nodeOrigin:Ui,minZoom:.5,maxZoom:2,elementsSelectable:!0,noPanClassName:"nopan",rfId:"1",paneClickDistance:0};function na(e){const{setNodes:t,setEdges:o,setMinZoom:r,setMaxZoom:i,setTranslateExtent:a,setNodeExtent:s,reset:l,setDefaultNodesAndEdges:c,setPaneClickDistance:u}=Oi(ea,Xi),d=Ai();n.useEffect(()=>(c(e.defaultNodes,e.defaultEdges),()=>{h.current=ta,l()}),[]);const h=n.useRef(ta);return n.useEffect(()=>{for(const l of Ji){const c=e[l];c!==h.current[l]&&void 0!==e[l]&&("nodes"===l?t(c):"edges"===l?o(c):"minZoom"===l?r(c):"maxZoom"===l?i(c):"translateExtent"===l?a(c):"nodeExtent"===l?s(c):"paneClickDistance"===l?u(c):"ariaLabelConfig"===l?d.setState({ariaLabelConfig:(n=c,{...ao,...n||{}})}):"fitView"===l?d.setState({fitViewQueued:c}):"fitViewOptions"===l?d.setState({fitViewOptions:c}):d.setState({[l]:c}))}var n;h.current=e},Ji.map(t=>e[t])),null}function oa(){return"undefined"!=typeof window&&window.matchMedia?window.matchMedia("(prefers-color-scheme: dark)"):null}const ra="undefined"!=typeof document?document:null;function ia(){let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:null;let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{target:ra,actInsideInputWithModifier:!0};const[o,r]=n.useState(!1),i=n.useRef(!1),a=n.useRef(new Set([])),[s,l]=n.useMemo(()=>{if(null!==e){const t=(Array.isArray(e)?e:[e]).filter(e=>"string"==typeof e).map(e=>e.replace("+","\n").replace("\n\n","\n+").split("\n")),n=t.reduce((e,t)=>e.concat(...t),[]);return[t,n]}return[[],[]]},[e]);return n.useEffect(()=>{var _t$target,_t$actInsideInputWith;const n=(_t$target=t===null||t===void 0?void 0:t.target)!==null&&_t$target!==void 0?_t$target:ra,o=(_t$actInsideInputWith=t===null||t===void 0?void 0:t.actInsideInputWithModifier)!==null&&_t$actInsideInputWith!==void 0?_t$actInsideInputWith:!0;if(null!==e){const e=e=>{i.current=e.ctrlKey||e.metaKey||e.shiftKey||e.altKey;if((!i.current||i.current&&!o)&&rr(e))return!1;const n=sa(e.code,l);if(a.current.add(e[n]),aa(s,a.current,!1)){var _e$composedPath2;const n=((_e$composedPath2=e.composedPath)===null||_e$composedPath2===void 0||(_e$composedPath2=_e$composedPath2.call(e))===null||_e$composedPath2===void 0?void 0:_e$composedPath2[0])||e.target,o="BUTTON"===(n===null||n===void 0?void 0:n.nodeName)||"A"===(n===null||n===void 0?void 0:n.nodeName);!1===t.preventDefault||!i.current&&o||e.preventDefault(),r(!0)}},c=e=>{const t=sa(e.code,l);aa(s,a.current,!0)?(r(!1),a.current.clear()):a.current.delete(e[t]),"Meta"===e.key&&a.current.clear(),i.current=!1},u=()=>{a.current.clear(),r(!1)};return n!==null&&n!==void 0&&n.addEventListener("keydown",e),n!==null&&n!==void 0&&n.addEventListener("keyup",c),window.addEventListener("blur",u),window.addEventListener("contextmenu",u),()=>{n!==null&&n!==void 0&&n.removeEventListener("keydown",e),n!==null&&n!==void 0&&n.removeEventListener("keyup",c),window.removeEventListener("blur",u),window.removeEventListener("contextmenu",u)}}},[e,r]),o}function aa(e,t,n){return e.filter(e=>n||e.length===t.size).some(e=>e.every(e=>t.has(e)))}function sa(e,t){return t.includes(e)?"code":"key"}const la=()=>{const e=Ai();return n.useMemo(()=>({zoomIn:t=>{const{panZoom:n}=e.getState();return n?n.scaleBy(1.2,{duration:t===null||t===void 0?void 0:t.duration}):Promise.resolve(!1)},zoomOut:t=>{const{panZoom:n}=e.getState();return n?n.scaleBy(1/1.2,{duration:t===null||t===void 0?void 0:t.duration}):Promise.resolve(!1)},zoomTo:(t,n)=>{const{panZoom:o}=e.getState();return o?o.scaleTo(t,{duration:n===null||n===void 0?void 0:n.duration}):Promise.resolve(!1)},getZoom:()=>e.getState().transform[2],setViewport:async(t,n)=>{var _t$x,_t$y,_t$zoom;const{transform:[o,r,i],panZoom:a}=e.getState();return a?(await a.setViewport({x:(_t$x=t.x)!==null&&_t$x!==void 0?_t$x:o,y:(_t$y=t.y)!==null&&_t$y!==void 0?_t$y:r,zoom:(_t$zoom=t.zoom)!==null&&_t$zoom!==void 0?_t$zoom:i},n),Promise.resolve(!0)):Promise.resolve(!1)},getViewport:()=>{const[t,n,o]=e.getState().transform;return{x:t,y:n,zoom:o}},setCenter:async(t,n,o)=>e.getState().setCenter(t,n,o),fitBounds:async(t,n)=>{var _n$padding;const{width:o,height:r,minZoom:i,maxZoom:a,panZoom:s}=e.getState(),l=Wo(t,o,r,i,a,(_n$padding=n===null||n===void 0?void 0:n.padding)!==null&&_n$padding!==void 0?_n$padding:.1);return s?(await s.setViewport(l,{duration:n===null||n===void 0?void 0:n.duration,ease:n===null||n===void 0?void 0:n.ease,interpolate:n===null||n===void 0?void 0:n.interpolate}),Promise.resolve(!0)):Promise.resolve(!1)},screenToFlowPosition:function(t){var _n$snapGrid,_n$snapToGrid;let n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};const{transform:o,snapGrid:r,snapToGrid:i,domNode:a}=e.getState();if(!a)return t;const{x:s,y:l}=a.getBoundingClientRect(),c={x:t.x-s,y:t.y-l},u=(_n$snapGrid=n.snapGrid)!==null&&_n$snapGrid!==void 0?_n$snapGrid:r,d=(_n$snapToGrid=n.snapToGrid)!==null&&_n$snapToGrid!==void 0?_n$snapToGrid:i;return Xo(c,o,d,u)},flowToScreenPosition:t=>{const{transform:n,domNode:o}=e.getState();if(!o)return t;const{x:r,y:i}=o.getBoundingClientRect(),a=Yo(t,n);return{x:a.x+r,y:a.y+i}}}),[])};function ca(e,t){const n=[],o=new Map,r=[];for(const t of e)if("add"!==t.type){if("remove"===t.type||"replace"===t.type)o.set(t.id,[t]);else{const e=o.get(t.id);e?e.push(t):o.set(t.id,[t])}}else r.push(t);for(const e of t){const t=o.get(e.id);if(!t){n.push(e);continue}if("remove"===t[0].type)continue;if("replace"===t[0].type){n.push({...t[0].item});continue}const r={...e};for(const e of t)ua(e,r);n.push(r)}return r.length&&r.forEach(e=>{void 0!==e.index?n.splice(e.index,0,{...e.item}):n.push({...e.item})}),n}function ua(e,t){var _t$measured;switch(e.type){case"select":t.selected=e.selected;break;case"position":void 0!==e.position&&(t.position=e.position),void 0!==e.dragging&&(t.dragging=e.dragging);break;case"dimensions":void 0!==e.dimensions&&((_t$measured=t.measured)!==null&&_t$measured!==void 0?_t$measured:t.measured={},t.measured.width=e.dimensions.width,t.measured.height=e.dimensions.height,e.setAttributes&&(!0!==e.setAttributes&&"width"!==e.setAttributes||(t.width=e.dimensions.width),!0!==e.setAttributes&&"height"!==e.setAttributes||(t.height=e.dimensions.height))),"boolean"==typeof e.resizing&&(t.resizing=e.resizing)}}function da(e,t){return ca(e,t)}function ha(e,t){return ca(e,t)}function fa(e,t){return{id:e,type:"select",selected:t}}function ga(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:new Set;let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!1;const o=[];for(const[r,i]of e){const e=t.has(r);void 0===i.selected&&!e||i.selected===e||(n&&(i.selected=e),o.push(fa(i.id,e)))}return o}function pa(_ref72){let{items:e=[],lookup:t}=_ref72;const n=[],o=new Map(e.map(e=>[e.id,e]));for(const[o,r]of e.entries()){var _e$internals$userNode,_e$internals;const e=t.get(r.id),i=(_e$internals$userNode=e===null||e===void 0||(_e$internals=e.internals)===null||_e$internals===void 0?void 0:_e$internals.userNode)!==null&&_e$internals$userNode!==void 0?_e$internals$userNode:e;void 0!==i&&i!==r&&n.push({id:r.id,item:r,type:"replace"}),void 0===i&&n.push({item:r,type:"add",index:o})}for(const[e]of t){void 0===o.get(e)&&n.push({id:e,type:"remove"})}return n}function ma(e){return{id:e.id,type:"remove"}}const ya=e=>(e=>"id"in e&&"position"in e&&!("source"in e)&&!("target"in e))(e),va=e=>xo(e);function xa(e){return n.forwardRef(e)}const wa="undefined"!=typeof window?n.useLayoutEffect:n.useEffect;function ba(e){const[t,o]=n.useState(BigInt(0)),[r]=n.useState(()=>function(e){let t=[];return{get:()=>t,reset:()=>{t=[]},push:n=>{t.push(n),e()}}}(()=>o(e=>e+BigInt(1))));return wa(()=>{const t=r.get();t.length&&(e(t),r.reset())},[t]),r}const Sa=n.createContext(null);function Ca(_ref73){let{children:e}=_ref73;const o=Ai(),r=ba(n.useCallback(e=>{const{nodes:t=[],setNodes:n,hasDefaultNodes:r,onNodesChange:i,nodeLookup:a,fitViewQueued:s}=o.getState();let l=t;for(const t of e)l="function"==typeof t?t(l):t;const c=pa({items:l,lookup:a});r&&n(l),c.length>0?i===null||i===void 0?void 0:i(c):s&&window.requestAnimationFrame(()=>{const{fitViewQueued:e,nodes:t,setNodes:n}=o.getState();e&&n(t)})},[])),i=ba(n.useCallback(e=>{const{edges:t=[],setEdges:n,hasDefaultEdges:r,onEdgesChange:i,edgeLookup:a}=o.getState();let s=t;for(const t of e)s="function"==typeof t?t(s):t;r?n(s):i&&i(pa({items:s,lookup:a}))},[])),a=n.useMemo(()=>({nodeQueue:r,edgeQueue:i}),[]);return t.jsx(Sa.Provider,{value:a,children:e})}const Ea=e=>!!e.panZoom;function ka(){const e=la(),t=Ai(),o=function(){const e=n.useContext(Sa);if(!e)throw new Error("useBatchContext must be used within a BatchProvider");return e}(),r=Oi(Ea),i=n.useMemo(()=>{const e=e=>t.getState().nodeLookup.get(e),n=e=>{o.nodeQueue.push(e)},r=e=>{o.edgeQueue.push(e)},i=e=>{var _r$measured$width,_r$measured,_r$measured$height,_r$measured2;const{nodeLookup:n,nodeOrigin:o}=t.getState(),r=ya(e)?e:n.get(e.id),i=r.parentId?Qo(r.position,r.measured,r.parentId,n,o):r.position,a={...r,position:i,width:(_r$measured$width=(_r$measured=r.measured)===null||_r$measured===void 0?void 0:_r$measured.width)!==null&&_r$measured$width!==void 0?_r$measured$width:r.width,height:(_r$measured$height=(_r$measured2=r.measured)===null||_r$measured2===void 0?void 0:_r$measured2.height)!==null&&_r$measured$height!==void 0?_r$measured$height:r.height};return Lo(a)},a=function(e,t){let o=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{replace:!1};n(n=>n.map(n=>{if(n.id===e){const e="function"==typeof t?t(n):t;return o.replace&&ya(e)?e:{...n,...e}}return n}))},s=function(e,t){let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{replace:!1};r(o=>o.map(o=>{if(o.id===e){const e="function"==typeof t?t(o):t;return n.replace&&va(e)?e:{...o,...e}}return o}))};return{getNodes:()=>t.getState().nodes.map(e=>({...e})),getNode:t=>{var _e4;return(_e4=e(t))===null||_e4===void 0?void 0:_e4.internals.userNode},getInternalNode:e,getEdges:()=>{const{edges:e=[]}=t.getState();return e.map(e=>({...e}))},getEdge:e=>t.getState().edgeLookup.get(e),setNodes:n,setEdges:r,addNodes:e=>{const t=Array.isArray(e)?e:[e];o.nodeQueue.push(e=>[...e,...t])},addEdges:e=>{const t=Array.isArray(e)?e:[e];o.edgeQueue.push(e=>[...e,...t])},toObject:()=>{const{nodes:e=[],edges:n=[],transform:o}=t.getState(),[r,i,a]=o;return{nodes:e.map(e=>({...e})),edges:n.map(e=>({...e})),viewport:{x:r,y:i,zoom:a}}},deleteElements:async _ref74=>{let{nodes:e=[],edges:n=[]}=_ref74;const{nodes:o,edges:r,onNodesDelete:i,onEdgesDelete:a,triggerNodeChanges:s,triggerEdgeChanges:l,onDelete:c,onBeforeDelete:u}=t.getState(),{nodes:d,edges:h}=await async function(_ref75){let{nodesToRemove:e=[],edgesToRemove:t=[],nodes:n,edges:o,onBeforeDelete:r}=_ref75;const i=new Set(e.map(e=>e.id)),a=[];for(const e of n){if(!1===e.deletable)continue;const t=i.has(e.id),n=!t&&e.parentId&&a.find(t=>t.id===e.parentId);(t||n)&&a.push(e)}const s=new Set(t.map(e=>e.id)),l=o.filter(e=>!1!==e.deletable),c=ko(a,l);for(const e of l)s.has(e.id)&&!c.find(t=>t.id===e.id)&&c.push(e);if(!r)return{edges:c,nodes:a};const u=await r({nodes:a,edges:c});return"boolean"==typeof u?u?{edges:c,nodes:a}:{edges:[],nodes:[]}:u}({nodesToRemove:e,edgesToRemove:n,nodes:o,edges:r,onBeforeDelete:u}),f=h.length>0,g=d.length>0;if(f){const e=h.map(ma);a!==null&&a!==void 0&&a(h),l(e)}if(g){const e=d.map(ma);i!==null&&i!==void 0&&i(d),s(e)}return(g||f)&&c!==null&&c!==void 0&&c({nodes:d,edges:h}),{deletedNodes:d,deletedEdges:h}},getIntersectingNodes:function(e){let n=arguments.length>1&&arguments[1]!==undefined?arguments[1]:!0;let o=arguments.length>2?arguments[2]:undefined;const r=Bo(e),a=r?e:i(e),s=void 0!==o;return a?(o||t.getState().nodes).filter(o=>{const i=t.getState().nodeLookup.get(o.id);if(i&&!r&&(o.id===e.id||!i.internals.positionAbsolute))return!1;const l=Lo(s?o:i),c=Vo(l,a);return n&&c>0||c>=l.width*l.height||c>=a.width*a.height}):[]},isNodeIntersecting:function(e,t){let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:!0;const o=Bo(e)?e:i(e);if(!o)return!1;const r=Vo(o,t);return n&&r>0||r>=o.width*o.height},updateNode:a,updateNodeData:function(e,t){let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{replace:!1};a(e,e=>{const o="function"==typeof t?t(e):t;return n.replace?{...e,data:o}:{...e,data:{...e.data,...o}}},n)},updateEdge:s,updateEdgeData:function(e,t){let n=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{replace:!1};s(e,e=>{const o="function"==typeof t?t(e):t;return n.replace?{...e,data:o}:{...e,data:{...e.data,...o}}},n)},getNodesBounds:e=>{const{nodeLookup:n,nodeOrigin:o}=t.getState();return So(e,{nodeLookup:n,nodeOrigin:o})},getHandleConnections:_ref76=>{var _t$getState$connectio,_t$getState$connectio2;let{type:e,id:n,nodeId:o}=_ref76;return Array.from((_t$getState$connectio=(_t$getState$connectio2=t.getState().connectionLookup.get(`${o}-${e}${n?`-${n}`:""}`))===null||_t$getState$connectio2===void 0?void 0:_t$getState$connectio2.values())!==null&&_t$getState$connectio!==void 0?_t$getState$connectio:[])},getNodeConnections:_ref77=>{var _t$getState$connectio3,_t$getState$connectio4;let{type:e,handleId:n,nodeId:o}=_ref77;return Array.from((_t$getState$connectio3=(_t$getState$connectio4=t.getState().connectionLookup.get(`${o}${e?n?`-${e}-${n}`:`-${e}`:""}`))===null||_t$getState$connectio4===void 0?void 0:_t$getState$connectio4.values())!==null&&_t$getState$connectio3!==void 0?_t$getState$connectio3:[])},fitView:async e=>{var _t$getState$fitViewRe;const n=(_t$getState$fitViewRe=t.getState().fitViewResolver)!==null&&_t$getState$fitViewRe!==void 0?_t$getState$fitViewRe:function(){let e,t;return{promise:new Promise((n,o)=>{e=n,t=o}),resolve:e,reject:t}}();return t.setState({fitViewQueued:!0,fitViewOptions:e,fitViewResolver:n}),o.nodeQueue.push(e=>[...e]),n.promise}}},[]);return n.useMemo(()=>({...i,...e,viewportInitialized:r}),[r])}const Ma=e=>e.selected,Na="undefined"!=typeof window?window:void 0;const _a={position:"absolute",width:"100%",height:"100%",top:0,left:0},Pa=e=>({userSelectionActive:e.userSelectionActive,lib:e.lib});function za(_ref78){let{onPaneContextMenu:o,zoomOnScroll:r=!0,zoomOnPinch:i=!0,panOnScroll:a=!1,panOnScrollSpeed:s=.5,panOnScrollMode:l=e.PanOnScrollMode.Free,zoomOnDoubleClick:c=!0,panOnDrag:u=!0,defaultViewport:d,translateExtent:h,minZoom:f,maxZoom:g,zoomActivationKeyCode:p,preventScrolling:m=!0,children:y,noWheelClassName:v,noPanClassName:x,onViewportChange:w,isControlledViewport:b,paneClickDistance:S}=_ref78;const C=Ai(),E=n.useRef(null),{userSelectionActive:k,lib:M}=Oi(Pa,Xi),N=ia(p),_=n.useRef();!function(e){const t=Ai();n.useEffect(()=>{const n=()=>{var _t$getState$onError,_t$getState;if(!e.current)return!1;const n=tr(e.current);0!==n.height&&0!==n.width||(_t$getState$onError=(_t$getState=t.getState()).onError)!==null&&_t$getState$onError!==void 0&&_t$getState$onError.call(_t$getState,"004",oo.error004()),t.setState({width:n.width||500,height:n.height||500})};if(e.current){n(),window.addEventListener("resize",n);const t=new ResizeObserver(()=>n());return t.observe(e.current),()=>{window.removeEventListener("resize",n),t&&e.current&&t.unobserve(e.current)}}},[])}(E);const P=n.useCallback(e=>{w!==null&&w!==void 0&&w({x:e[0],y:e[1],zoom:e[2]}),b||C.setState({transform:e})},[w,b]);return n.useEffect(()=>{if(E.current){_.current=ni({domNode:E.current,minZoom:f,maxZoom:g,translateExtent:h,viewport:d,paneClickDistance:S,onDraggingChange:e=>C.setState({paneDragging:e}),onPanZoomStart:(e,t)=>{const{onViewportChangeStart:n,onMoveStart:o}=C.getState();o!==null&&o!==void 0&&o(e,t),n===null||n===void 0?void 0:n(t)},onPanZoom:(e,t)=>{const{onViewportChange:n,onMove:o}=C.getState();o!==null&&o!==void 0&&o(e,t),n===null||n===void 0?void 0:n(t)},onPanZoomEnd:(e,t)=>{const{onViewportChangeEnd:n,onMoveEnd:o}=C.getState();o!==null&&o!==void 0&&o(e,t),n===null||n===void 0?void 0:n(t)}});const{x:e,y:t,zoom:n}=_.current.getViewport();return C.setState({panZoom:_.current,transform:[e,t,n],domNode:E.current.closest(".react-flow")}),()=>{var _$current;(_$current=_.current)===null||_$current===void 0||_$current.destroy()}}},[]),n.useEffect(()=>{var _$current2;(_$current2=_.current)===null||_$current2===void 0||_$current2.update({onPaneContextMenu:o,zoomOnScroll:r,zoomOnPinch:i,panOnScroll:a,panOnScrollSpeed:s,panOnScrollMode:l,zoomOnDoubleClick:c,panOnDrag:u,zoomActivationKeyPressed:N,preventScrolling:m,noPanClassName:x,userSelectionActive:k,noWheelClassName:v,lib:M,onTransformChange:P})},[o,r,i,a,s,l,c,u,N,m,x,k,v,M,P]),t.jsx("div",{className:"react-flow__renderer",ref:E,style:_a,children:y})}const Oa=e=>({userSelectionActive:e.userSelectionActive,userSelectionRect:e.userSelectionRect});function Aa(){const{userSelectionActive:e,userSelectionRect:n}=Oi(Oa,Xi);return e&&n?t.jsx("div",{className:"react-flow__selection react-flow__container",style:{width:n.width,height:n.height,transform:`translate(${n.x}px, ${n.y}px)`}}):null}const Da=(e,t)=>n=>{n.target===t.current&&(e===null||e===void 0?void 0:e(n))},Ia=e=>({userSelectionActive:e.userSelectionActive,elementsSelectable:e.elementsSelectable,connectionInProgress:e.connection.inProgress,dragging:e.paneDragging});function Ra(_ref79){let{isSelecting:o,selectionKeyPressed:i,selectionMode:a=e.SelectionMode.Full,panOnDrag:s,selectionOnDrag:l,onSelectionStart:c,onSelectionEnd:u,onPaneClick:d,onPaneContextMenu:h,onPaneScroll:f,onPaneMouseEnter:g,onPaneMouseMove:p,onPaneMouseLeave:m,children:y}=_ref79;const v=Ai(),{userSelectionActive:x,elementsSelectable:w,dragging:b,connectionInProgress:S}=Oi(Ia,Xi),C=w&&(o||x),E=n.useRef(null),k=n.useRef(),M=n.useRef(new Set),N=n.useRef(new Set),_=n.useRef(!1),P=n.useRef(!1),z=e=>{_.current||S?_.current=!1:(d!==null&&d!==void 0&&d(e),v.getState().resetSelectedElements(),v.setState({nodesSelectionActive:!1}))},O=f?e=>f(e):void 0,A=!0===s||Array.isArray(s)&&s.includes(0);return t.jsxs("div",{className:r(["react-flow__pane",{draggable:A,dragging:b,selection:o}]),onClick:C?void 0:Da(z,E),onContextMenu:Da(e=>{Array.isArray(s)&&s!==null&&s!==void 0&&s.includes(2)?e.preventDefault():h===null||h===void 0?void 0:h(e)},E),onWheel:Da(O,E),onPointerEnter:C?void 0:g,onPointerDown:C?e=>{var _e$target,_e$target$setPointerC;const{resetSelectedElements:t,domNode:n}=v.getState();if(k.current=n===null||n===void 0?void 0:n.getBoundingClientRect(),!w||!o||0!==e.button||e.target!==E.current||!k.current)return;(_e$target=e.target)!==null&&_e$target!==void 0&&(_e$target$setPointerC=_e$target.setPointerCapture)!==null&&_e$target$setPointerC!==void 0&&_e$target$setPointerC.call(_e$target,e.pointerId),P.current=!0,_.current=!1;const{x:r,y:i}=ar(e.nativeEvent,k.current);t(),v.setState({userSelectionRect:{width:0,height:0,startX:r,startY:i,x:r,y:i}}),c===null||c===void 0?void 0:c(e)}:p,onPointerMove:C?t=>{var _u$selectable;const{userSelectionRect:n,transform:o,nodeLookup:r,edgeLookup:i,connectionLookup:s,triggerNodeChanges:l,triggerEdgeChanges:c,defaultEdgeOptions:u}=v.getState();if(!k.current||!n)return;_.current=!0;const{x:d,y:h}=ar(t.nativeEvent,k.current),{startX:f,startY:g}=n,p={startX:f,startY:g,x:d<f?d:f,y:h<g?h:g,width:Math.abs(d-f),height:Math.abs(h-g)},m=M.current,y=N.current;M.current=new Set(Eo(r,p,o,a===e.SelectionMode.Partial,!0).map(e=>e.id)),N.current=new Set;const x=(_u$selectable=u===null||u===void 0?void 0:u.selectable)!==null&&_u$selectable!==void 0?_u$selectable:!0;for(const e of M.current){const t=s.get(e);if(t)for(const{edgeId:e}of t.values()){var _t$selectable;const t=i.get(e);t&&((_t$selectable=t.selectable)!==null&&_t$selectable!==void 0?_t$selectable:x)&&N.current.add(e)}}if(!Jo(m,M.current)){l(ga(r,M.current,!0))}if(!Jo(y,N.current)){c(ga(i,N.current))}v.setState({userSelectionRect:p,userSelectionActive:!0,nodesSelectionActive:!1})}:p,onPointerUp:C?e=>{var _e$target2,_e$target2$releasePoi;if(0!==e.button||!P.current)return;(_e$target2=e.target)===null||_e$target2===void 0||(_e$target2$releasePoi=_e$target2.releasePointerCapture)===null||_e$target2$releasePoi===void 0||_e$target2$releasePoi.call(_e$target2,e.pointerId);const{userSelectionRect:t}=v.getState();!x&&t&&e.target===E.current&&z!==null&&z!==void 0&&z(e),v.setState({userSelectionActive:!1,userSelectionRect:null,nodesSelectionActive:M.current.size>0}),u!==null&&u!==void 0&&u(e),(i||l)&&(_.current=!1),P.current=!1}:void 0,onPointerLeave:m,ref:E,style:_a,children:[y,t.jsx(Aa,{})]})}function La(_ref80){let{id:e,store:t,unselect:n=!1,nodeRef:o}=_ref80;const{addSelectedNodes:r,unselectNodesAndEdges:i,multiSelectionActive:a,nodeLookup:s,onError:l}=t.getState(),c=s.get(e);c?(t.setState({nodesSelectionActive:!1}),c.selected?(n||c.selected&&a)&&(i({nodes:[c],edges:[]}),requestAnimationFrame(()=>{var _o$current;return o===null||o===void 0||(_o$current=o.current)===null||_o$current===void 0?void 0:_o$current.blur()})):r([e])):l===null||l===void 0?void 0:l("012",oo.error012(e))}function $a(_ref81){let{nodeRef:e,disabled:t=!1,noDragClassName:o,handleSelector:r,nodeId:i,isSelectable:a,nodeClickDistance:s}=_ref81;const l=Ai(),[c,u]=n.useState(!1),d=n.useRef();return n.useEffect(()=>{d.current=Br({getStoreItems:()=>l.getState(),onNodeMouseDown:t=>{La({id:t,store:l,nodeRef:e})},onDragStart:()=>{u(!0)},onDragStop:()=>{u(!1)}})},[]),n.useEffect(()=>{var _d$current,_d$current2;if(t)(_d$current=d.current)===null||_d$current===void 0||_d$current.destroy();else if(e.current)return(_d$current2=d.current)!==null&&_d$current2!==void 0&&_d$current2.update({noDragClassName:o,handleSelector:r,domNode:e.current,isSelectable:a,nodeId:i,nodeClickDistance:s}),()=>{var _d$current3;(_d$current3=d.current)===null||_d$current3===void 0||_d$current3.destroy()}},[o,r,t,a,e,i]),c}const Ta=e=>t=>t.selected&&(t.draggable||e&&void 0===t.draggable);function Va(){const e=Ai();return n.useCallback(t=>{const{nodeExtent:n,snapToGrid:o,snapGrid:r,nodesDraggable:i,onError:a,updateNodePositions:s,nodeLookup:l,nodeOrigin:c}=e.getState(),u=new Map,d=Ta(i),h=o?r[0]:5,f=o?r[1]:5,g=t.direction.x*h*t.factor,p=t.direction.y*f*t.factor;for(const[,e]of l){if(!d(e))continue;let t={x:e.internals.positionAbsolute.x+g,y:e.internals.positionAbsolute.y+p};o&&(t=Zo(t,r));const{position:i,positionAbsolute:s}=No({nodeId:e.id,nextPosition:t,nodeLookup:l,nodeExtent:n,nodeOrigin:c,onError:a});e.position=i,e.internals.positionAbsolute=s,u.set(e.id,e)}s(u)},[])}const Ba=n.createContext(null),ja=Ba.Provider;Ba.Consumer;const Ha=()=>n.useContext(Ba),Za=e=>({connectOnClick:e.connectOnClick,noPanClassName:e.noPanClassName,rfId:e.rfId});const Xa=n.memo(xa((function(_ref82,m){var _x$getState$onError,_x$getState;let{type:n="source",position:o=e.Position.Top,isValidConnection:i,isConnectable:a=!0,isConnectableStart:s=!0,isConnectableEnd:l=!0,id:c,onConnect:u,children:d,className:h,onMouseDown:f,onTouchStart:g,...p}=_ref82;const y=c||null,v="target"===n,x=Ai(),w=Ha(),{connectOnClick:b,noPanClassName:S,rfId:C}=Oi(Za,Xi),{connectingFrom:E,connectingTo:k,clickConnecting:M,isPossibleEndHandle:N,connectionInProcess:_,clickConnectionInProcess:P,valid:z}=Oi(((t,n,o)=>r=>{const{connectionClickStartHandle:i,connectionMode:a,connection:s}=r,{fromHandle:l,toHandle:c,isValid:u}=s,d=(c===null||c===void 0?void 0:c.nodeId)===t&&(c===null||c===void 0?void 0:c.id)===n&&(c===null||c===void 0?void 0:c.type)===o;return{connectingFrom:(l===null||l===void 0?void 0:l.nodeId)===t&&(l===null||l===void 0?void 0:l.id)===n&&(l===null||l===void 0?void 0:l.type)===o,connectingTo:d,clickConnecting:(i===null||i===void 0?void 0:i.nodeId)===t&&(i===null||i===void 0?void 0:i.id)===n&&(i===null||i===void 0?void 0:i.type)===o,isPossibleEndHandle:a===e.ConnectionMode.Strict?(l===null||l===void 0?void 0:l.type)!==o:t!==(l===null||l===void 0?void 0:l.nodeId)||n!==(l===null||l===void 0?void 0:l.id),connectionInProcess:!!l,clickConnectionInProcess:!!i,valid:d&&u}})(w,y,n),Xi);w||((_x$getState$onError=(_x$getState=x.getState()).onError)===null||_x$getState$onError===void 0?void 0:_x$getState$onError.call(_x$getState,"010",oo.error010()));const O=e=>{const{defaultEdgeOptions:t,onConnect:n,hasDefaultEdges:o}=x.getState(),r={...t,...e};if(o){const{edges:e,setEdges:t}=x.getState();t(pr(r,e))}n!==null&&n!==void 0&&n(r),u===null||u===void 0?void 0:u(r)},A=e=>{if(!w)return;const t=ir(e.nativeEvent);if(s&&(t&&0===e.button||!t)){const t=x.getState();Wr.onPointerDown(e.nativeEvent,{autoPanOnConnect:t.autoPanOnConnect,connectionMode:t.connectionMode,connectionRadius:t.connectionRadius,domNode:t.domNode,nodeLookup:t.nodeLookup,lib:t.lib,isTarget:v,handleId:y,nodeId:w,flowId:t.rfId,panBy:t.panBy,cancelConnection:t.cancelConnection,onConnectStart:t.onConnectStart,onConnectEnd:t.onConnectEnd,updateConnection:t.updateConnection,onConnect:O,isValidConnection:i||t.isValidConnection,getTransform:()=>x.getState().transform,getFromHandle:()=>x.getState().connection.fromHandle,autoPanSpeed:t.autoPanSpeed,dragThreshold:t.connectionDragThreshold})}t?f===null||f===void 0?void 0:f(e):g===null||g===void 0?void 0:g(e)};return t.jsx("div",{"data-handleid":y,"data-nodeid":w,"data-handlepos":o,"data-id":`${C}-${w}-${y}-${n}`,className:r(["react-flow__handle",`react-flow__handle-${o}`,"nodrag",S,h,{source:!v,target:v,connectable:a,connectablestart:s,connectableend:l,clickconnecting:M,connectingfrom:E,connectingto:k,valid:z,connectionindicator:a&&(!_||N)&&(_||P?l:s)}]),onMouseDown:A,onTouchStart:A,onClick:b?e=>{const{onClickConnectStart:t,onClickConnectEnd:o,connectionClickStartHandle:r,connectionMode:a,isValidConnection:l,lib:c,rfId:u,nodeLookup:d,connection:h}=x.getState();if(!w||!r&&!s)return;if(!r)return t!==null&&t!==void 0&&t(e.nativeEvent,{nodeId:w,handleId:y,handleType:n}),void x.setState({connectionClickStartHandle:{nodeId:w,type:n,id:y}});const f=nr(e.target),g=i||l,{connection:p,isValid:m}=Wr.isValid(e.nativeEvent,{handle:{nodeId:w,id:y,type:n},connectionMode:a,fromNodeId:r.nodeId,fromHandleId:r.id||null,fromType:r.type,isValidConnection:g,flowId:u,doc:f,lib:c,nodeLookup:d});m&&p&&O(p);const v=structuredClone(h);delete v.inProgress,v.toPosition=v.toHandle?v.toHandle.position:null,o!==null&&o!==void 0&&o(e,v),x.setState({connectionClickStartHandle:null})}:void 0,ref:m,...p,children:d})})));const Ya={ArrowUp:{x:0,y:-1},ArrowDown:{x:0,y:1},ArrowLeft:{x:-1,y:0},ArrowRight:{x:1,y:0}},Fa={input:function(_ref83){let{data:n,isConnectable:o,sourcePosition:r=e.Position.Bottom}=_ref83;return t.jsxs(t.Fragment,{children:[n===null||n===void 0?void 0:n.label,t.jsx(Xa,{type:"source",position:r,isConnectable:o})]})},default:function(_ref84){let{data:n,isConnectable:o,targetPosition:r=e.Position.Top,sourcePosition:i=e.Position.Bottom}=_ref84;return t.jsxs(t.Fragment,{children:[t.jsx(Xa,{type:"target",position:r,isConnectable:o}),n===null||n===void 0?void 0:n.label,t.jsx(Xa,{type:"source",position:i,isConnectable:o})]})},output:function(_ref85){let{data:n,isConnectable:o,targetPosition:r=e.Position.Top}=_ref85;return t.jsxs(t.Fragment,{children:[t.jsx(Xa,{type:"target",position:r,isConnectable:o}),n===null||n===void 0?void 0:n.label]})},group:function(){return null}};const Wa=e=>{const{width:t,height:n,x:o,y:r}=Co(e.nodeLookup,{filter:e=>!!e.selected});return{width:jo(t)?t:null,height:jo(n)?n:null,userSelectionActive:e.userSelectionActive,transformString:`translate(${e.transform[0]}px,${e.transform[1]}px) scale(${e.transform[2]}) translate(${o}px,${r}px)`}};function Ka(_ref86){let{onSelectionContextMenu:e,noPanClassName:o,disableKeyboardA11y:i}=_ref86;const a=Ai(),{width:s,height:l,transformString:c,userSelectionActive:u}=Oi(Wa,Xi),d=Va(),h=n.useRef(null);if(n.useEffect(()=>{var _h$current;i||((_h$current=h.current)===null||_h$current===void 0?void 0:_h$current.focus({preventScroll:!0}))},[i]),$a({nodeRef:h}),u||!s||!l)return null;const f=e?t=>{const n=a.getState().nodes.filter(e=>e.selected);e(t,n)}:void 0;return t.jsx("div",{className:r(["react-flow__nodesselection","react-flow__container",o]),style:{transform:c},children:t.jsx("div",{ref:h,className:"react-flow__nodesselection-rect",onContextMenu:f,tabIndex:i?void 0:-1,onKeyDown:i?void 0:e=>{Object.prototype.hasOwnProperty.call(Ya,e.key)&&(e.preventDefault(),d({direction:Ya[e.key],factor:e.shiftKey?4:1}))},style:{width:s,height:l}})})}const Ga="undefined"!=typeof window?window:void 0,qa=e=>({nodesSelectionActive:e.nodesSelectionActive,userSelectionActive:e.userSelectionActive});function Ua(_ref87){let{children:e,onPaneClick:o,onPaneMouseEnter:r,onPaneMouseMove:i,onPaneMouseLeave:a,onPaneContextMenu:s,onPaneScroll:l,paneClickDistance:c,deleteKeyCode:u,selectionKeyCode:d,selectionOnDrag:h,selectionMode:f,onSelectionStart:g,onSelectionEnd:p,multiSelectionKeyCode:m,panActivationKeyCode:y,zoomActivationKeyCode:v,elementsSelectable:x,zoomOnScroll:w,zoomOnPinch:b,panOnScroll:S,panOnScrollSpeed:C,panOnScrollMode:E,zoomOnDoubleClick:k,panOnDrag:M,defaultViewport:N,translateExtent:_,minZoom:P,maxZoom:z,preventScrolling:O,onSelectionContextMenu:A,noWheelClassName:D,noPanClassName:I,disableKeyboardA11y:R,onViewportChange:L,isControlledViewport:$}=_ref87;const{nodesSelectionActive:T,userSelectionActive:V}=Oi(qa),B=ia(d,{target:Ga}),j=ia(y,{target:Ga}),H=j||M,Z=j||S,X=h&&!0!==H,Y=B||V||X;return function(_ref88){let{deleteKeyCode:e,multiSelectionKeyCode:t}=_ref88;const o=Ai(),{deleteElements:r}=ka(),i=ia(e,{actInsideInputWithModifier:!1}),a=ia(t,{target:Na});n.useEffect(()=>{if(i){const{edges:e,nodes:t}=o.getState();r({nodes:t.filter(Ma),edges:e.filter(Ma)}),o.setState({nodesSelectionActive:!1})}},[i]),n.useEffect(()=>{o.setState({multiSelectionActive:a})},[a])}({deleteKeyCode:u,multiSelectionKeyCode:m}),t.jsx(za,{onPaneContextMenu:s,elementsSelectable:x,zoomOnScroll:w,zoomOnPinch:b,panOnScroll:Z,panOnScrollSpeed:C,panOnScrollMode:E,zoomOnDoubleClick:k,panOnDrag:!B&&H,defaultViewport:N,translateExtent:_,minZoom:P,maxZoom:z,zoomActivationKeyCode:v,preventScrolling:O,noWheelClassName:D,noPanClassName:I,onViewportChange:L,isControlledViewport:$,paneClickDistance:c,children:t.jsxs(Ra,{onSelectionStart:g,onSelectionEnd:p,onPaneClick:o,onPaneMouseEnter:r,onPaneMouseMove:i,onPaneMouseLeave:a,onPaneContextMenu:s,onPaneScroll:l,panOnDrag:H,isSelecting:!!Y,selectionMode:f,selectionKeyPressed:B,selectionOnDrag:X,children:[e,T&&t.jsx(Ka,{onSelectionContextMenu:A,noPanClassName:I,disableKeyboardA11y:R})]})})}Ua.displayName="FlowRenderer";const Qa=n.memo(Ua),Ja=e=>t=>e?Eo(t.nodeLookup,{x:0,y:0,width:t.width,height:t.height},t.transform,!0).map(e=>e.id):Array.from(t.nodeLookup.keys());const es=e=>e.updateNodeInternals;function ts(_ref89){var _S$ariaRole,_S$selected,_S$deletable;let{id:e,onClick:o,onMouseEnter:i,onMouseMove:a,onMouseLeave:s,onContextMenu:l,onDoubleClick:c,nodesDraggable:u,elementsSelectable:d,nodesConnectable:h,nodesFocusable:f,resizeObserver:g,noDragClassName:p,noPanClassName:m,disableKeyboardA11y:y,rfId:v,nodeTypes:x,nodeClickDistance:w,onError:b}=_ref89;const{node:S,internals:C,isParent:E}=Oi(t=>{const n=t.nodeLookup.get(e),o=t.parentLookup.has(e);return{node:n,internals:n.internals,isParent:o}},Xi);let k=S.type||"default",M=(x===null||x===void 0?void 0:x[k])||Fa[k];void 0===M&&(b!==null&&b!==void 0&&b("003",oo.error003(k)),k="default",M=(x===null||x===void 0?void 0:x.default)||Fa.default);const N=!!(S.draggable||u&&void 0===S.draggable),_=!!(S.selectable||d&&void 0===S.selectable),P=!!(S.connectable||h&&void 0===S.connectable),z=!!(S.focusable||f&&void 0===S.focusable),O=Ai(),A=Uo(S),D=function(_ref90){let{node:e,nodeType:t,hasDimensions:o,resizeObserver:r}=_ref90;const i=Ai(),a=n.useRef(null),s=n.useRef(null),l=n.useRef(e.sourcePosition),c=n.useRef(e.targetPosition),u=n.useRef(t),d=o&&!!e.internals.handleBounds;return n.useEffect(()=>{!a.current||e.hidden||d&&s.current===a.current||(s.current&&r!==null&&r!==void 0&&r.unobserve(s.current),r!==null&&r!==void 0&&r.observe(a.current),s.current=a.current)},[d,e.hidden]),n.useEffect(()=>()=>{s.current&&(r!==null&&r!==void 0&&r.unobserve(s.current),s.current=null)},[]),n.useEffect(()=>{if(a.current){const n=u.current!==t,o=l.current!==e.sourcePosition,r=c.current!==e.targetPosition;(n||o||r)&&(u.current=t,l.current=e.sourcePosition,c.current=e.targetPosition,i.getState().updateNodeInternals(new Map([[e.id,{id:e.id,nodeElement:a.current,force:!0}]])))}},[e.id,t,e.sourcePosition,e.targetPosition]),a}({node:S,nodeType:k,hasDimensions:A,resizeObserver:g}),I=$a({nodeRef:D,disabled:S.hidden||!N,noDragClassName:p,handleSelector:S.dragHandle,nodeId:e,isSelectable:_,nodeClickDistance:w}),R=Va();if(S.hidden)return null;const L=qo(S),$=function(e,_ref91,_e$width2,_e$style,_ref92,_e$height2,_e$style2,_e$width3,_e$style3,_e$height3,_e$style4){return void 0===e.internals.handleBounds?{width:(_ref91=(_e$width2=e.width)!==null&&_e$width2!==void 0?_e$width2:e.initialWidth)!==null&&_ref91!==void 0?_ref91:(_e$style=e.style)===null||_e$style===void 0?void 0:_e$style.width,height:(_ref92=(_e$height2=e.height)!==null&&_e$height2!==void 0?_e$height2:e.initialHeight)!==null&&_ref92!==void 0?_ref92:(_e$style2=e.style)===null||_e$style2===void 0?void 0:_e$style2.height}:{width:(_e$width3=e.width)!==null&&_e$width3!==void 0?_e$width3:(_e$style3=e.style)===null||_e$style3===void 0?void 0:_e$style3.width,height:(_e$height3=e.height)!==null&&_e$height3!==void 0?_e$height3:(_e$style4=e.style)===null||_e$style4===void 0?void 0:_e$style4.height}}(S),T=_||N||o||i||a||s,V=i?e=>i(e,{...C.userNode}):void 0,B=a?e=>a(e,{...C.userNode}):void 0,j=s?e=>s(e,{...C.userNode}):void 0,H=l?e=>l(e,{...C.userNode}):void 0,Z=c?e=>c(e,{...C.userNode}):void 0;return t.jsx("div",{className:r(["react-flow__node",`react-flow__node-${k}`,{[m]:N},S.className,{selected:S.selected,selectable:_,parent:E,draggable:N,dragging:I}]),ref:D,style:{zIndex:C.z,transform:`translate(${C.positionAbsolute.x}px,${C.positionAbsolute.y}px)`,pointerEvents:T?"all":"none",visibility:A?"visible":"hidden",...S.style,...$},"data-id":e,"data-testid":`rf__node-${e}`,onMouseEnter:V,onMouseMove:B,onMouseLeave:j,onContextMenu:H,onClick:t=>{const{selectNodesOnDrag:n,nodeDragThreshold:r}=O.getState();_&&(!n||!N||r>0)&&La({id:e,store:O,nodeRef:D}),o&&o(t,{...C.userNode})},onDoubleClick:Z,onKeyDown:z?t=>{if(!rr(t.nativeEvent)&&!y)if(io.includes(t.key)&&_){const n="Escape"===t.key;La({id:e,store:O,unselect:n,nodeRef:D})}else if(N&&S.selected&&Object.prototype.hasOwnProperty.call(Ya,t.key)){t.preventDefault();const{ariaLabelConfig:e}=O.getState();O.setState({ariaLiveMessage:e["node.a11yDescription.ariaLiveMessage"]({direction:t.key.replace("Arrow","").toLowerCase(),x:~~C.positionAbsolute.x,y:~~C.positionAbsolute.y})}),R({direction:Ya[t.key],factor:t.shiftKey?4:1})}}:void 0,tabIndex:z?0:void 0,onFocus:z?()=>{var _D$current;if(y||!((_D$current=D.current)!==null&&_D$current!==void 0&&_D$current.matches(":focus-visible")))return;const{transform:t,width:n,height:o,autoPanOnNodeFocus:r,setCenter:i}=O.getState();if(!r)return;Eo(new Map([[e,S]]),{x:0,y:0,width:n,height:o},t,!0).length>0||i(S.position.x+L.width/2,S.position.y+L.height/2,{zoom:t[2]})}:void 0,role:(_S$ariaRole=S.ariaRole)!==null&&_S$ariaRole!==void 0?_S$ariaRole:z?"group":void 0,"aria-roledescription":"node","aria-describedby":y?void 0:`${Ri}-${v}`,"aria-label":S.ariaLabel,...S.domAttributes,children:t.jsx(ja,{value:e,children:t.jsx(M,{id:e,data:S.data,type:k,positionAbsoluteX:C.positionAbsolute.x,positionAbsoluteY:C.positionAbsolute.y,selected:(_S$selected=S.selected)!==null&&_S$selected!==void 0?_S$selected:!1,selectable:_,draggable:N,deletable:(_S$deletable=S.deletable)!==null&&_S$deletable!==void 0?_S$deletable:!0,isConnectable:P,sourcePosition:S.sourcePosition,targetPosition:S.targetPosition,dragging:I,dragHandle:S.dragHandle,zIndex:C.z,parentId:S.parentId,...L})})})}const ns=e=>({nodesDraggable:e.nodesDraggable,nodesConnectable:e.nodesConnectable,nodesFocusable:e.nodesFocusable,elementsSelectable:e.elementsSelectable,onError:e.onError});function os(e){const{nodesDraggable:o,nodesConnectable:r,nodesFocusable:i,elementsSelectable:a,onError:s}=Oi(ns,Xi),l=(c=e.onlyRenderVisibleElements,Oi(n.useCallback(Ja(c),[c]),Xi));var c;const u=function(){const e=Oi(es),[t]=n.useState(()=>"undefined"==typeof ResizeObserver?null:new ResizeObserver(t=>{const n=new Map;t.forEach(e=>{const t=e.target.getAttribute("data-id");n.set(t,{id:t,nodeElement:e.target,force:!0})}),e(n)}));return n.useEffect(()=>()=>{t===null||t===void 0||t.disconnect()},[t]),t}();return t.jsx("div",{className:"react-flow__nodes",style:_a,children:l.map(n=>t.jsx(ts,{id:n,nodeTypes:e.nodeTypes,nodeExtent:e.nodeExtent,onClick:e.onNodeClick,onMouseEnter:e.onNodeMouseEnter,onMouseMove:e.onNodeMouseMove,onMouseLeave:e.onNodeMouseLeave,onContextMenu:e.onNodeContextMenu,onDoubleClick:e.onNodeDoubleClick,noDragClassName:e.noDragClassName,noPanClassName:e.noPanClassName,rfId:e.rfId,disableKeyboardA11y:e.disableKeyboardA11y,resizeObserver:u,nodesDraggable:o,nodesConnectable:r,nodesFocusable:i,elementsSelectable:a,nodeClickDistance:e.nodeClickDistance,onError:s},n))})}os.displayName="NodeRenderer";const rs=n.memo(os);const is={[e.MarkerType.Arrow]:_ref93=>{let{color:e="none",strokeWidth:n=1}=_ref93;return t.jsx("polyline",{style:{stroke:e,strokeWidth:n},strokeLinecap:"round",strokeLinejoin:"round",fill:"none",points:"-5,-4 0,0 -5,4"})},[e.MarkerType.ArrowClosed]:_ref94=>{let{color:e="none",strokeWidth:n=1}=_ref94;return t.jsx("polyline",{style:{stroke:e,fill:e,strokeWidth:n},strokeLinecap:"round",strokeLinejoin:"round",points:"-5,-4 0,0 -5,4 -5,-4"})}};const as=_ref95=>{let{id:e,type:o,color:r,width:i=12.5,height:a=12.5,markerUnits:s="strokeWidth",strokeWidth:l,orient:c="auto-start-reverse"}=_ref95;const u=function(e){const t=Ai();return n.useMemo(()=>{var _t$getState$onError2,_t$getState2;return Object.prototype.hasOwnProperty.call(is,e)?is[e]:((_t$getState$onError2=(_t$getState2=t.getState()).onError)!==null&&_t$getState$onError2!==void 0&&_t$getState$onError2.call(_t$getState2,"009",oo.error009(e)),null)},[e])}(o);return u?t.jsx("marker",{className:"react-flow__arrowhead",id:e,markerWidth:`${i}`,markerHeight:`${a}`,viewBox:"-10 -10 20 20",markerUnits:s,orient:c,refX:"0",refY:"0",children:t.jsx(u,{color:r,strokeWidth:l})}):null},ss=_ref96=>{let{defaultColor:e,rfId:o}=_ref96;const r=Oi(e=>e.edges),i=Oi(e=>e.defaultEdgeOptions),a=n.useMemo(()=>{const t=function(e,_ref97){let{id:t,defaultColor:n,defaultMarkerStart:o,defaultMarkerEnd:r}=_ref97;const i=new Set;return e.reduce((e,a)=>([a.markerStart||o,a.markerEnd||r].forEach(o=>{if(o&&"object"==typeof o){const r=kr(o,t);i.has(r)||(e.push({id:r,color:o.color||n,...o}),i.add(r))}}),e),[]).sort((e,t)=>e.id.localeCompare(t.id))}(r,{id:o,defaultColor:e,defaultMarkerStart:i===null||i===void 0?void 0:i.markerStart,defaultMarkerEnd:i===null||i===void 0?void 0:i.markerEnd});return t},[r,i,o,e]);return a.length?t.jsx("svg",{className:"react-flow__marker","aria-hidden":"true",children:t.jsx("defs",{children:a.map(e=>t.jsx(as,{id:e.id,type:e.type,color:e.color,width:e.width,height:e.height,markerUnits:e.markerUnits,strokeWidth:e.strokeWidth,orient:e.orient},e.id))})}):null};ss.displayName="MarkerDefinitions";var ls=n.memo(ss);function cs(_ref98){let{x:e,y:o,label:i,labelStyle:a,labelShowBg:s=!0,labelBgStyle:l,labelBgPadding:c=[2,4],labelBgBorderRadius:u=2,children:d,className:h,...f}=_ref98;const[g,p]=n.useState({x:1,y:0,width:0,height:0}),m=r(["react-flow__edge-textwrapper",h]),y=n.useRef(null);return n.useEffect(()=>{if(y.current){const e=y.current.getBBox();p({x:e.x,y:e.y,width:e.width,height:e.height})}},[i]),i?t.jsxs("g",{transform:`translate(${e-g.width/2} ${o-g.height/2})`,className:m,visibility:g.width?"visible":"hidden",...f,children:[s&&t.jsx("rect",{width:g.width+2*c[0],x:-c[0],y:-c[1],height:g.height+2*c[1],className:"react-flow__edge-textbg",style:l,rx:u,ry:u}),t.jsx("text",{className:"react-flow__edge-text",y:g.height/2,dy:"0.3em",ref:y,style:a,children:i}),d]}):null}cs.displayName="EdgeText";const us=n.memo(cs);function ds(_ref99){let{path:e,labelX:n,labelY:o,label:i,labelStyle:a,labelShowBg:s,labelBgStyle:l,labelBgPadding:c,labelBgBorderRadius:u,interactionWidth:d=20,...h}=_ref99;return t.jsxs(t.Fragment,{children:[t.jsx("path",{...h,d:e,fill:"none",className:r(["react-flow__edge-path",h.className])}),d&&t.jsx("path",{d:e,fill:"none",strokeOpacity:0,strokeWidth:d,className:"react-flow__edge-interaction"}),i&&jo(n)&&jo(o)?t.jsx(us,{x:n,y:o,label:i,labelStyle:a,labelShowBg:s,labelBgStyle:l,labelBgPadding:c,labelBgBorderRadius:u}):null]})}function hs(_ref100){let{pos:t,x1:n,y1:o,x2:r,y2:i}=_ref100;return t===e.Position.Left||t===e.Position.Right?[.5*(n+r),o]:[n,.5*(o+i)]}function fs(_ref101){let{sourceX:t,sourceY:n,sourcePosition:o=e.Position.Bottom,targetX:r,targetY:i,targetPosition:a=e.Position.Top}=_ref101;const[s,l]=hs({pos:o,x1:t,y1:n,x2:r,y2:i}),[c,u]=hs({pos:a,x1:r,y1:i,x2:t,y2:n}),[d,h,f,g]=lr({sourceX:t,sourceY:n,targetX:r,targetY:i,sourceControlX:s,sourceControlY:l,targetControlX:c,targetControlY:u});return[`M${t},${n} C${s},${l} ${c},${u} ${r},${i}`,d,h,f,g]}function gs(e){return n.memo(_ref102=>{let{id:n,sourceX:o,sourceY:r,targetX:i,targetY:a,sourcePosition:s,targetPosition:l,label:c,labelStyle:u,labelShowBg:d,labelBgStyle:h,labelBgPadding:f,labelBgBorderRadius:g,style:p,markerEnd:m,markerStart:y,interactionWidth:v}=_ref102;const[x,w,b]=fs({sourceX:o,sourceY:r,sourcePosition:s,targetX:i,targetY:a,targetPosition:l}),S=e.isInternal?void 0:n;return t.jsx(ds,{id:S,path:x,labelX:w,labelY:b,label:c,labelStyle:u,labelShowBg:d,labelBgStyle:h,labelBgPadding:f,labelBgBorderRadius:g,style:p,markerEnd:m,markerStart:y,interactionWidth:v})})}const ps=gs({isInternal:!1}),ms=gs({isInternal:!0});function ys(o){return n.memo(_ref103=>{let{id:n,sourceX:r,sourceY:i,targetX:a,targetY:s,label:l,labelStyle:c,labelShowBg:u,labelBgStyle:d,labelBgPadding:h,labelBgBorderRadius:f,style:g,sourcePosition:p=e.Position.Bottom,targetPosition:m=e.Position.Top,markerEnd:y,markerStart:v,pathOptions:x,interactionWidth:w}=_ref103;const[b,S,C]=wr({sourceX:r,sourceY:i,sourcePosition:p,targetX:a,targetY:s,targetPosition:m,borderRadius:x===null||x===void 0?void 0:x.borderRadius,offset:x===null||x===void 0?void 0:x.offset,stepPosition:x===null||x===void 0?void 0:x.stepPosition}),E=o.isInternal?void 0:n;return t.jsx(ds,{id:E,path:b,labelX:S,labelY:C,label:l,labelStyle:c,labelShowBg:u,labelBgStyle:d,labelBgPadding:h,labelBgBorderRadius:f,style:g,markerEnd:y,markerStart:v,interactionWidth:w})})}ps.displayName="SimpleBezierEdge",ms.displayName="SimpleBezierEdgeInternal";const vs=ys({isInternal:!1}),xs=ys({isInternal:!0});function ws(e){return n.memo(_ref104=>{var _r$pathOptions2;let{id:o,...r}=_ref104;const i=e.isInternal?void 0:o;return t.jsx(vs,{...r,id:i,pathOptions:n.useMemo(()=>{var _r$pathOptions;return{borderRadius:0,offset:(_r$pathOptions=r.pathOptions)===null||_r$pathOptions===void 0?void 0:_r$pathOptions.offset}},[(_r$pathOptions2=r.pathOptions)===null||_r$pathOptions2===void 0?void 0:_r$pathOptions2.offset])})})}vs.displayName="SmoothStepEdge",xs.displayName="SmoothStepEdgeInternal";const bs=ws({isInternal:!1}),Ss=ws({isInternal:!0});function Cs(e){return n.memo(_ref105=>{let{id:n,sourceX:o,sourceY:r,targetX:i,targetY:a,label:s,labelStyle:l,labelShowBg:c,labelBgStyle:u,labelBgPadding:d,labelBgBorderRadius:h,style:f,markerEnd:g,markerStart:p,interactionWidth:m}=_ref105;const[y,v,x]=mr({sourceX:o,sourceY:r,targetX:i,targetY:a}),w=e.isInternal?void 0:n;return t.jsx(ds,{id:w,path:y,labelX:v,labelY:x,label:s,labelStyle:l,labelShowBg:c,labelBgStyle:u,labelBgPadding:d,labelBgBorderRadius:h,style:f,markerEnd:g,markerStart:p,interactionWidth:m})})}bs.displayName="StepEdge",Ss.displayName="StepEdgeInternal";const Es=Cs({isInternal:!1}),ks=Cs({isInternal:!0});function Ms(o){return n.memo(_ref106=>{let{id:n,sourceX:r,sourceY:i,targetX:a,targetY:s,sourcePosition:l=e.Position.Bottom,targetPosition:c=e.Position.Top,label:u,labelStyle:d,labelShowBg:h,labelBgStyle:f,labelBgPadding:g,labelBgBorderRadius:p,style:m,markerEnd:y,markerStart:v,pathOptions:x,interactionWidth:w}=_ref106;const[b,S,C]=dr({sourceX:r,sourceY:i,sourcePosition:l,targetX:a,targetY:s,targetPosition:c,curvature:x===null||x===void 0?void 0:x.curvature}),E=o.isInternal?void 0:n;return t.jsx(ds,{id:E,path:b,labelX:S,labelY:C,label:u,labelStyle:d,labelShowBg:h,labelBgStyle:f,labelBgPadding:g,labelBgBorderRadius:p,style:m,markerEnd:y,markerStart:v,interactionWidth:w})})}Es.displayName="StraightEdge",ks.displayName="StraightEdgeInternal";const Ns=Ms({isInternal:!1}),_s=Ms({isInternal:!0});Ns.displayName="BezierEdge",_s.displayName="BezierEdgeInternal";const Ps={default:_s,straight:ks,step:Ss,smoothstep:xs,simplebezier:ms},zs={sourceX:null,sourceY:null,targetX:null,targetY:null,sourcePosition:null,targetPosition:null},Os=(t,n,o)=>o===e.Position.Left?t-n:o===e.Position.Right?t+n:t,As=(t,n,o)=>o===e.Position.Top?t-n:o===e.Position.Bottom?t+n:t,Ds="react-flow__edgeupdater";function Is(_ref107){let{position:e,centerX:n,centerY:o,radius:i=10,onMouseDown:a,onMouseEnter:s,onMouseOut:l,type:c}=_ref107;return t.jsx("circle",{onMouseDown:a,onMouseEnter:s,onMouseOut:l,className:r([Ds,`${Ds}-${c}`]),cx:Os(n,i,e),cy:As(o,i,e),r:i,stroke:"transparent",fill:"transparent"})}function Rs(_ref108){let{isReconnectable:e,reconnectRadius:n,edge:o,sourceX:r,sourceY:i,targetX:a,targetY:s,sourcePosition:l,targetPosition:c,onReconnect:u,onReconnectStart:d,onReconnectEnd:h,setReconnecting:f,setUpdateHover:g}=_ref108;const p=Ai(),m=(e,t)=>{if(0!==e.button)return;const{autoPanOnConnect:n,domNode:r,isValidConnection:i,connectionMode:a,connectionRadius:s,lib:l,onConnectStart:c,onConnectEnd:g,cancelConnection:m,nodeLookup:y,rfId:v,panBy:x,updateConnection:w}=p.getState(),b="target"===t.type;Wr.onPointerDown(e.nativeEvent,{autoPanOnConnect:n,connectionMode:a,connectionRadius:s,domNode:r,handleId:t.id,nodeId:t.nodeId,nodeLookup:y,isTarget:b,edgeUpdaterType:t.type,lib:l,flowId:v,cancelConnection:m,panBy:x,isValidConnection:i,onConnect:e=>u===null||u===void 0?void 0:u(o,e),onConnectStart:(n,r)=>{f(!0),d!==null&&d!==void 0&&d(e,o,t.type),c===null||c===void 0?void 0:c(n,r)},onConnectEnd:g,onReconnectEnd:(e,n)=>{f(!1),h===null||h===void 0?void 0:h(e,o,t.type,n)},updateConnection:w,getTransform:()=>p.getState().transform,getFromHandle:()=>p.getState().connection.fromHandle,dragThreshold:p.getState().connectionDragThreshold})},y=()=>g(!0),v=()=>g(!1);return t.jsxs(t.Fragment,{children:[(!0===e||"source"===e)&&t.jsx(Is,{position:l,centerX:r,centerY:i,radius:n,onMouseDown:e=>{var _o$targetHandle;return m(e,{nodeId:o.target,id:(_o$targetHandle=o.targetHandle)!==null&&_o$targetHandle!==void 0?_o$targetHandle:null,type:"target"})},onMouseEnter:y,onMouseOut:v,type:"source"}),(!0===e||"target"===e)&&t.jsx(Is,{position:c,centerX:a,centerY:s,radius:n,onMouseDown:e=>{var _o$sourceHandle;return m(e,{nodeId:o.source,id:(_o$sourceHandle=o.sourceHandle)!==null&&_o$sourceHandle!==void 0?_o$sourceHandle:null,type:"source"})},onMouseEnter:y,onMouseOut:v,type:"target"})]})}function Ls(_ref109){var _C$ariaRole,_C$deletable;let{id:o,edgesFocusable:i,edgesReconnectable:a,elementsSelectable:s,onClick:l,onDoubleClick:c,onContextMenu:u,onMouseEnter:d,onMouseMove:h,onMouseLeave:f,reconnectRadius:g,onReconnect:p,onReconnectStart:m,onReconnectEnd:y,rfId:v,edgeTypes:x,noPanClassName:w,onError:b,disableKeyboardA11y:S}=_ref109;let C=Oi(e=>e.edgeLookup.get(o));const E=Oi(e=>e.defaultEdgeOptions);C=E?{...E,...C}:C;let k=C.type||"default",M=(x===null||x===void 0?void 0:x[k])||Ps[k];void 0===M&&(b!==null&&b!==void 0&&b("011",oo.error011(k)),k="default",M=(x===null||x===void 0?void 0:x.default)||Ps.default);const N=!!(C.focusable||i&&void 0===C.focusable),_=void 0!==p&&(C.reconnectable||a&&void 0===C.reconnectable),P=!!(C.selectable||s&&void 0===C.selectable),z=n.useRef(null),[O,A]=n.useState(!1),[D,I]=n.useState(!1),R=Ai(),{zIndex:L,sourceX:$,sourceY:T,targetX:V,targetY:B,sourcePosition:j,targetPosition:H}=Oi(n.useCallback(t=>{const n=t.nodeLookup.get(C.source),r=t.nodeLookup.get(C.target);if(!n||!r)return{zIndex:C.zIndex,...zs};const i=function(t,_r$source,_i$target,_i$target2,_i$source,_t$onError){const{sourceNode:n,targetNode:o}=t;if(!br(n)||!br(o))return null;const r=n.internals.handleBounds||Sr(n.handles),i=o.internals.handleBounds||Sr(o.handles),a=Er((_r$source=r===null||r===void 0?void 0:r.source)!==null&&_r$source!==void 0?_r$source:[],t.sourceHandle),s=Er(t.connectionMode===e.ConnectionMode.Strict?(_i$target=i===null||i===void 0?void 0:i.target)!==null&&_i$target!==void 0?_i$target:[]:((_i$target2=i===null||i===void 0?void 0:i.target)!==null&&_i$target2!==void 0?_i$target2:[]).concat((_i$source=i===null||i===void 0?void 0:i.source)!==null&&_i$source!==void 0?_i$source:[]),t.targetHandle);if(!a||!s)return(_t$onError=t.onError)!==null&&_t$onError!==void 0&&_t$onError.call(t,"008",oo.error008(a?"target":"source",{id:t.id,sourceHandle:t.sourceHandle,targetHandle:t.targetHandle})),null;const l=(a===null||a===void 0?void 0:a.position)||e.Position.Bottom,c=(s===null||s===void 0?void 0:s.position)||e.Position.Top,u=Cr(n,a,l),d=Cr(o,s,c);return{sourceX:u.x,sourceY:u.y,targetX:d.x,targetY:d.y,sourcePosition:l,targetPosition:c}}({id:o,sourceNode:n,targetNode:r,sourceHandle:C.sourceHandle||null,targetHandle:C.targetHandle||null,connectionMode:t.connectionMode,onError:b}),a=function(_ref110){let{sourceNode:e,targetNode:t,selected:n=!1,zIndex:o,elevateOnSelect:r=!1}=_ref110;return void 0!==o?o:(r&&n?1e3:0)+Math.max(e.parentId?e.internals.z:0,t.parentId?t.internals.z:0)}({selected:C.selected,zIndex:C.zIndex,sourceNode:n,targetNode:r,elevateOnSelect:t.elevateEdgesOnSelect});return{zIndex:a,...i||zs}},[C.source,C.target,C.sourceHandle,C.targetHandle,C.selected,C.zIndex]),Xi),Z=n.useMemo(()=>C.markerStart?`url('#${kr(C.markerStart,v)}')`:void 0,[C.markerStart,v]),X=n.useMemo(()=>C.markerEnd?`url('#${kr(C.markerEnd,v)}')`:void 0,[C.markerEnd,v]);if(C.hidden||null===$||null===T||null===V||null===B)return null;const Y=c?e=>{c(e,{...C})}:void 0,F=u?e=>{u(e,{...C})}:void 0,W=d?e=>{d(e,{...C})}:void 0,K=h?e=>{h(e,{...C})}:void 0,G=f?e=>{f(e,{...C})}:void 0;return t.jsx("svg",{style:{zIndex:L},children:t.jsxs("g",{className:r(["react-flow__edge",`react-flow__edge-${k}`,C.className,w,{selected:C.selected,animated:C.animated,inactive:!P&&!l,updating:O,selectable:P}]),onClick:e=>{var _z$current;const{addSelectedEdges:t,unselectNodesAndEdges:n,multiSelectionActive:r}=R.getState();P&&(R.setState({nodesSelectionActive:!1}),C.selected&&r?(n({nodes:[],edges:[C]}),(_z$current=z.current)===null||_z$current===void 0?void 0:_z$current.blur()):t([o])),l&&l(e,C)},onDoubleClick:Y,onContextMenu:F,onMouseEnter:W,onMouseMove:K,onMouseLeave:G,onKeyDown:N?e=>{if(!S&&io.includes(e.key)&&P){var _z$current2;const{unselectNodesAndEdges:t,addSelectedEdges:n}=R.getState();"Escape"===e.key?((_z$current2=z.current)!==null&&_z$current2!==void 0&&_z$current2.blur(),t({edges:[C]})):n([o])}}:void 0,tabIndex:N?0:void 0,role:(_C$ariaRole=C.ariaRole)!==null&&_C$ariaRole!==void 0?_C$ariaRole:N?"group":"img","aria-roledescription":"edge","data-id":o,"data-testid":`rf__edge-${o}`,"aria-label":null===C.ariaLabel?void 0:C.ariaLabel||`Edge from ${C.source} to ${C.target}`,"aria-describedby":N?`${Li}-${v}`:void 0,ref:z,...C.domAttributes,children:[!D&&t.jsx(M,{id:o,source:C.source,target:C.target,type:C.type,selected:C.selected,animated:C.animated,selectable:P,deletable:(_C$deletable=C.deletable)!==null&&_C$deletable!==void 0?_C$deletable:!0,label:C.label,labelStyle:C.labelStyle,labelShowBg:C.labelShowBg,labelBgStyle:C.labelBgStyle,labelBgPadding:C.labelBgPadding,labelBgBorderRadius:C.labelBgBorderRadius,sourceX:$,sourceY:T,targetX:V,targetY:B,sourcePosition:j,targetPosition:H,data:C.data,style:C.style,sourceHandleId:C.sourceHandle,targetHandleId:C.targetHandle,markerStart:Z,markerEnd:X,pathOptions:"pathOptions"in C?C.pathOptions:void 0,interactionWidth:C.interactionWidth}),_&&t.jsx(Rs,{edge:C,isReconnectable:_,reconnectRadius:g,onReconnect:p,onReconnectStart:m,onReconnectEnd:y,sourceX:$,sourceY:T,targetX:V,targetY:B,sourcePosition:j,targetPosition:H,setUpdateHover:A,setReconnecting:I})]})})}const $s=e=>({edgesFocusable:e.edgesFocusable,edgesReconnectable:e.edgesReconnectable,elementsSelectable:e.elementsSelectable,connectionMode:e.connectionMode,onError:e.onError});function Ts(_ref111){let{defaultMarkerColor:e,onlyRenderVisibleElements:o,rfId:r,edgeTypes:i,noPanClassName:a,onReconnect:s,onEdgeContextMenu:l,onEdgeMouseEnter:c,onEdgeMouseMove:u,onEdgeMouseLeave:d,onEdgeClick:h,reconnectRadius:f,onEdgeDoubleClick:g,onReconnectStart:p,onReconnectEnd:m,disableKeyboardA11y:y}=_ref111;const{edgesFocusable:v,edgesReconnectable:x,elementsSelectable:w,onError:b}=Oi($s,Xi),S=(C=o,Oi(n.useCallback(e=>{if(!C)return e.edges.map(e=>e.id);const t=[];if(e.width&&e.height)for(const n of e.edges){const o=e.nodeLookup.get(n.source),r=e.nodeLookup.get(n.target);o&&r&&fr({sourceNode:o,targetNode:r,width:e.width,height:e.height,transform:e.transform})&&t.push(n.id)}return t},[C]),Xi));var C;return t.jsxs("div",{className:"react-flow__edges",children:[t.jsx(ls,{defaultColor:e,rfId:r}),S.map(e=>t.jsx(Ls,{id:e,edgesFocusable:v,edgesReconnectable:x,elementsSelectable:w,noPanClassName:a,onReconnect:s,onContextMenu:l,onMouseEnter:c,onMouseMove:u,onMouseLeave:d,onClick:h,reconnectRadius:f,onDoubleClick:g,onReconnectStart:p,onReconnectEnd:m,rfId:r,onError:b,edgeTypes:i,disableKeyboardA11y:y},e))]})}Ts.displayName="EdgeRenderer";const Vs=n.memo(Ts),Bs=e=>`translate(${e.transform[0]}px,${e.transform[1]}px) scale(${e.transform[2]})`;function js(_ref112){let{children:e}=_ref112;const n=Oi(Bs);return t.jsx("div",{className:"react-flow__viewport xyflow__viewport react-flow__container",style:{transform:n},children:e})}const Hs=e=>{var _e$panZoom;return(_e$panZoom=e.panZoom)===null||_e$panZoom===void 0?void 0:_e$panZoom.syncViewport};function Zs(e){return e.connection.inProgress?{...e.connection,to:Xo(e.connection.to,e.transform)}:{...e.connection}}function Xs(e){const t=function(e){if(e)return t=>{const n=Zs(t);return e(n)};return Zs}(e);return Oi(t,Xi)}const Ys=e=>({nodesConnectable:e.nodesConnectable,isValid:e.connection.isValid,inProgress:e.connection.inProgress,width:e.width,height:e.height});function Fs(_ref113){let{containerStyle:e,style:n,type:o,component:i}=_ref113;const{nodesConnectable:a,width:s,height:l,isValid:c,inProgress:u}=Oi(Ys,Xi);return!!(s&&a&&u)?t.jsx("svg",{style:e,width:s,height:l,className:"react-flow__connectionline react-flow__container",children:t.jsx("g",{className:r(["react-flow__connection",vo(c)]),children:t.jsx(Ws,{style:n,type:o,CustomComponent:i,isValid:c})})}):null}const Ws=_ref114=>{let{style:n,type:o=e.ConnectionLineType.Bezier,CustomComponent:r,isValid:i}=_ref114;const{inProgress:a,from:s,fromNode:l,fromHandle:c,fromPosition:u,to:d,toNode:h,toHandle:f,toPosition:g}=Xs();if(!a)return;if(r)return t.jsx(r,{connectionLineType:o,connectionLineStyle:n,fromNode:l,fromHandle:c,fromX:s.x,fromY:s.y,toX:d.x,toY:d.y,fromPosition:u,toPosition:g,connectionStatus:vo(i),toNode:h,toHandle:f});let p="";const m={sourceX:s.x,sourceY:s.y,sourcePosition:u,targetX:d.x,targetY:d.y,targetPosition:g};switch(o){case e.ConnectionLineType.Bezier:[p]=dr(m);break;case e.ConnectionLineType.SimpleBezier:[p]=fs(m);break;case e.ConnectionLineType.Step:[p]=wr({...m,borderRadius:0});break;case e.ConnectionLineType.SmoothStep:[p]=wr(m);break;default:[p]=mr(m)}return t.jsx("path",{d:p,fill:"none",className:"react-flow__connection-path",style:n})};Ws.displayName="ConnectionLine";const Ks={};function Gs(){let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:Ks;n.useRef(e),Ai(),n.useEffect(()=>{},[e])}function qs(_ref115){let{nodeTypes:e,edgeTypes:o,onInit:r,onNodeClick:i,onEdgeClick:a,onNodeDoubleClick:s,onEdgeDoubleClick:l,onNodeMouseEnter:c,onNodeMouseMove:u,onNodeMouseLeave:d,onNodeContextMenu:h,onSelectionContextMenu:f,onSelectionStart:g,onSelectionEnd:p,connectionLineType:m,connectionLineStyle:y,connectionLineComponent:v,connectionLineContainerStyle:x,selectionKeyCode:w,selectionOnDrag:b,selectionMode:S,multiSelectionKeyCode:C,panActivationKeyCode:E,zoomActivationKeyCode:k,deleteKeyCode:M,onlyRenderVisibleElements:N,elementsSelectable:_,defaultViewport:P,translateExtent:z,minZoom:O,maxZoom:A,preventScrolling:D,defaultMarkerColor:I,zoomOnScroll:R,zoomOnPinch:L,panOnScroll:$,panOnScrollSpeed:T,panOnScrollMode:V,zoomOnDoubleClick:B,panOnDrag:j,onPaneClick:H,onPaneMouseEnter:Z,onPaneMouseMove:X,onPaneMouseLeave:Y,onPaneScroll:F,onPaneContextMenu:W,paneClickDistance:K,nodeClickDistance:G,onEdgeContextMenu:q,onEdgeMouseEnter:U,onEdgeMouseMove:Q,onEdgeMouseLeave:J,reconnectRadius:ee,onReconnect:te,onReconnectStart:ne,onReconnectEnd:oe,noDragClassName:re,noWheelClassName:ie,noPanClassName:ae,disableKeyboardA11y:se,nodeExtent:le,rfId:ce,viewport:ue,onViewportChange:de}=_ref115;return Gs(e),Gs(o),Ai(),n.useRef(!1),n.useEffect(()=>{},[]),function(e){const t=ka(),o=n.useRef(!1);n.useEffect(()=>{!o.current&&t.viewportInitialized&&e&&(setTimeout(()=>e(t),1),o.current=!0)},[e,t.viewportInitialized])}(r),function(e){const t=Oi(Hs),o=Ai();n.useEffect(()=>{e&&(t!==null&&t!==void 0&&t(e),o.setState({transform:[e.x,e.y,e.zoom]}))},[e,t])}(ue),t.jsx(Qa,{onPaneClick:H,onPaneMouseEnter:Z,onPaneMouseMove:X,onPaneMouseLeave:Y,onPaneContextMenu:W,onPaneScroll:F,paneClickDistance:K,deleteKeyCode:M,selectionKeyCode:w,selectionOnDrag:b,selectionMode:S,onSelectionStart:g,onSelectionEnd:p,multiSelectionKeyCode:C,panActivationKeyCode:E,zoomActivationKeyCode:k,elementsSelectable:_,zoomOnScroll:R,zoomOnPinch:L,zoomOnDoubleClick:B,panOnScroll:$,panOnScrollSpeed:T,panOnScrollMode:V,panOnDrag:j,defaultViewport:P,translateExtent:z,minZoom:O,maxZoom:A,onSelectionContextMenu:f,preventScrolling:D,noDragClassName:re,noWheelClassName:ie,noPanClassName:ae,disableKeyboardA11y:se,onViewportChange:de,isControlledViewport:!!ue,children:t.jsxs(js,{children:[t.jsx(Vs,{edgeTypes:o,onEdgeClick:a,onEdgeDoubleClick:l,onReconnect:te,onReconnectStart:ne,onReconnectEnd:oe,onlyRenderVisibleElements:N,onEdgeContextMenu:q,onEdgeMouseEnter:U,onEdgeMouseMove:Q,onEdgeMouseLeave:J,reconnectRadius:ee,defaultMarkerColor:I,noPanClassName:ae,disableKeyboardA11y:se,rfId:ce}),t.jsx(Fs,{style:y,type:m,component:v,containerStyle:x}),t.jsx("div",{className:"react-flow__edgelabel-renderer"}),t.jsx(rs,{nodeTypes:e,onNodeClick:i,onNodeDoubleClick:s,onNodeMouseEnter:c,onNodeMouseMove:u,onNodeMouseLeave:d,onNodeContextMenu:h,nodeClickDistance:G,onlyRenderVisibleElements:N,noPanClassName:ae,noDragClassName:re,disableKeyboardA11y:se,nodeExtent:le,rfId:ce}),t.jsx("div",{className:"react-flow__viewport-portal"})]})})}qs.displayName="GraphView";const Us=n.memo(qs),Qs=function(){var _ref116,_ref117;let{nodes:t,edges:n,defaultNodes:o,defaultEdges:r,width:i,height:a,fitView:s,fitViewOptions:l,minZoom:c=.5,maxZoom:u=2,nodeOrigin:d,nodeExtent:h}=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const f=new Map,g=new Map,p=new Map,m=new Map,y=(_ref116=r!==null&&r!==void 0?r:n)!==null&&_ref116!==void 0?_ref116:[],v=(_ref117=o!==null&&o!==void 0?o:t)!==null&&_ref117!==void 0?_ref117:[],x=d!==null&&d!==void 0?d:[0,0],w=h!==null&&h!==void 0?h:ro;Rr(p,m,y);const b=zr(v,f,g,{nodeOrigin:x,nodeExtent:w,elevateNodesOnSelect:!1});let S=[0,0,1];if(s&&i&&a){var _l$padding;const e=Co(f,{filter:e=>!(!e.width&&!e.initialWidth||!e.height&&!e.initialHeight)}),{x:t,y:n,zoom:o}=Wo(e,i,a,c,u,(_l$padding=l===null||l===void 0?void 0:l.padding)!==null&&_l$padding!==void 0?_l$padding:.1);S=[t,n,o]}return{rfId:"1",width:0,height:0,transform:S,nodes:v,nodesInitialized:b,nodeLookup:f,parentLookup:g,edges:y,edgeLookup:m,connectionLookup:p,onNodesChange:null,onEdgesChange:null,hasDefaultNodes:void 0!==o,hasDefaultEdges:void 0!==r,panZoom:null,minZoom:c,maxZoom:u,translateExtent:ro,nodeExtent:w,nodesSelectionActive:!1,userSelectionActive:!1,userSelectionRect:null,connectionMode:e.ConnectionMode.Strict,domNode:null,paneDragging:!1,noPanClassName:"nopan",nodeOrigin:x,nodeDragThreshold:1,connectionDragThreshold:1,snapGrid:[15,15],snapToGrid:!1,nodesDraggable:!0,nodesConnectable:!0,nodesFocusable:!0,edgesFocusable:!0,edgesReconnectable:!0,elementsSelectable:!0,elevateNodesOnSelect:!0,elevateEdgesOnSelect:!1,selectNodesOnDrag:!0,multiSelectionActive:!1,fitViewQueued:s!==null&&s!==void 0?s:!1,fitViewOptions:l,fitViewResolver:null,connection:{...uo},connectionClickStartHandle:null,connectOnClick:!0,ariaLiveMessage:"",autoPanOnConnect:!0,autoPanOnNodeDrag:!0,autoPanOnNodeFocus:!0,autoPanSpeed:15,connectionRadius:20,onError:Ho,isValidConnection:void 0,onSelectionChangeHandlers:[],lib:"react",debug:!1,ariaLabelConfig:ao}},Js=_ref118=>{let{nodes:e,edges:t,defaultNodes:n,defaultEdges:o,width:r,height:i,fitView:a,fitViewOptions:s,minZoom:l,maxZoom:c,nodeOrigin:u,nodeExtent:d}=_ref118;return h=(h,f)=>{async function g(){const{nodeLookup:e,panZoom:t,fitViewOptions:n,fitViewResolver:o,width:r,height:i,minZoom:a,maxZoom:s}=f();t&&(await Mo({nodes:e,width:r,height:i,panZoom:t,minZoom:a,maxZoom:s},n),o!==null&&o!==void 0&&o.resolve(!0),h({fitViewResolver:null}))}return{...Qs({nodes:e,edges:t,width:r,height:i,fitView:a,fitViewOptions:s,minZoom:l,maxZoom:c,nodeOrigin:u,nodeExtent:d,defaultNodes:n,defaultEdges:o}),setNodes:e=>{const{nodeLookup:t,parentLookup:n,nodeOrigin:o,elevateNodesOnSelect:r,fitViewQueued:i}=f(),a=zr(e,t,n,{nodeOrigin:o,nodeExtent:d,elevateNodesOnSelect:r,checkEquality:!0});i&&a?(g(),h({nodes:e,nodesInitialized:a,fitViewQueued:!1,fitViewOptions:void 0})):h({nodes:e,nodesInitialized:a})},setEdges:e=>{const{connectionLookup:t,edgeLookup:n}=f();Rr(t,n,e),h({edges:e})},setDefaultNodesAndEdges:(e,t)=>{if(e){const{setNodes:t}=f();t(e),h({hasDefaultNodes:!0})}if(t){const{setEdges:e}=f();e(t),h({hasDefaultEdges:!0})}},updateNodeInternals:e=>{const{triggerNodeChanges:t,nodeLookup:n,parentLookup:o,domNode:r,nodeOrigin:i,nodeExtent:a,debug:s,fitViewQueued:l}=f(),{changes:c,updatedInternals:u}=function(e,t,n,o,r,i){const a=o===null||o===void 0?void 0:o.querySelector(".xyflow__viewport");let s=!1;if(!a)return{changes:[],updatedInternals:s};const l=[],c=window.getComputedStyle(a),{m22:u}=new window.DOMMatrixReadOnly(c.transform),d=[];for(const o of e.values()){const e=t.get(o.id);if(!e)continue;if(e.hidden){t.set(e.id,{...e,internals:{...e.internals,handleBounds:void 0}}),s=!0;continue}const a=tr(o.nodeElement),c=e.measured.width!==a.width||e.measured.height!==a.height;if(a.width&&a.height&&(c||!e.internals.handleBounds||o.force)){const h=o.nodeElement.getBoundingClientRect(),f=Go(e.extent)?e.extent:i;let{positionAbsolute:g}=e.internals;e.parentId&&"parent"===e.extent?g=zo(g,a,t.get(e.parentId)):f&&(g=Po(g,f,a));const p={...e,measured:a,internals:{...e.internals,positionAbsolute:g,handleBounds:{source:sr("source",o.nodeElement,h,u,e.id),target:sr("target",o.nodeElement,h,u,e.id)}}};t.set(e.id,p),e.parentId&&Or(p,t,n,{nodeOrigin:r}),s=!0,c&&(l.push({id:e.id,type:"dimensions",dimensions:a}),e.expandParent&&e.parentId&&d.push({id:e.id,parentId:e.parentId,rect:Lo(p,r)}))}}if(d.length>0){const e=Dr(d,t,n,r);l.push(...e)}return{changes:l,updatedInternals:s}}(e,n,o,r,i,a);u&&(function(e,t,n){const o=Pr(Nr,n);for(const n of e.values())if(n.parentId)Or(n,e,t,o);else{const e=bo(n,o.nodeOrigin),t=Go(n.extent)?n.extent:o.nodeExtent,r=Po(e,t,qo(n));n.internals.positionAbsolute=r}}(n,o,{nodeOrigin:i,nodeExtent:a}),l?(g(),h({fitViewQueued:!1,fitViewOptions:void 0})):h({}),(c===null||c===void 0?void 0:c.length)>0&&(s&&console.log("React Flow: trigger node changes",c),t===null||t===void 0?void 0:t(c)))},updateNodePositions:function(e){let t=arguments.length>1&&arguments[1]!==undefined?arguments[1]:!1;const n=[],o=[],{nodeLookup:r,triggerNodeChanges:i}=f();for(const[i,a]of e){var _a$measured$width2,_a$measured$height2;const e=r.get(i),s=!!(e!==null&&e!==void 0&&e.expandParent&&e!==null&&e!==void 0&&e.parentId&&a!==null&&a!==void 0&&a.position),l={id:i,type:"position",position:s?{x:Math.max(0,a.position.x),y:Math.max(0,a.position.y)}:a.position,dragging:t};s&&e.parentId&&n.push({id:i,parentId:e.parentId,rect:{...a.internals.positionAbsolute,width:(_a$measured$width2=a.measured.width)!==null&&_a$measured$width2!==void 0?_a$measured$width2:0,height:(_a$measured$height2=a.measured.height)!==null&&_a$measured$height2!==void 0?_a$measured$height2:0}}),o.push(l)}if(n.length>0){const{parentLookup:e,nodeOrigin:t}=f(),i=Dr(n,r,e,t);o.push(...i)}i(o)},triggerNodeChanges:e=>{const{onNodesChange:t,setNodes:n,nodes:o,hasDefaultNodes:r,debug:i}=f();(e===null||e===void 0?void 0:e.length)&&(r&&n(da(e,o)),i&&console.log("React Flow: trigger node changes",e),t===null||t===void 0?void 0:t(e))},triggerEdgeChanges:e=>{const{onEdgesChange:t,setEdges:n,edges:o,hasDefaultEdges:r,debug:i}=f();(e===null||e===void 0?void 0:e.length)&&(r&&n(ha(e,o)),i&&console.log("React Flow: trigger edge changes",e),t===null||t===void 0?void 0:t(e))},addSelectedNodes:e=>{const{multiSelectionActive:t,edgeLookup:n,nodeLookup:o,triggerNodeChanges:r,triggerEdgeChanges:i}=f();t?r(e.map(e=>fa(e,!0))):(r(ga(o,new Set([...e]),!0)),i(ga(n)))},addSelectedEdges:e=>{const{multiSelectionActive:t,edgeLookup:n,nodeLookup:o,triggerNodeChanges:r,triggerEdgeChanges:i}=f();t?i(e.map(e=>fa(e,!0))):(i(ga(n,new Set([...e]))),r(ga(o,new Set,!0)))},unselectNodesAndEdges:function(){let{nodes:e,edges:t}=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const{edges:n,nodes:o,nodeLookup:r,triggerNodeChanges:i,triggerEdgeChanges:a}=f(),s=t||n,l=(e||o).map(e=>{const t=r.get(e.id);return t&&(t.selected=!1),fa(e.id,!1)}),c=s.map(e=>fa(e.id,!1));i(l),a(c)},setMinZoom:e=>{const{panZoom:t,maxZoom:n}=f();t!==null&&t!==void 0&&t.setScaleExtent([e,n]),h({minZoom:e})},setMaxZoom:e=>{const{panZoom:t,minZoom:n}=f();t!==null&&t!==void 0&&t.setScaleExtent([n,e]),h({maxZoom:e})},setTranslateExtent:e=>{var _f$panZoom;(_f$panZoom=f().panZoom)!==null&&_f$panZoom!==void 0&&_f$panZoom.setTranslateExtent(e),h({translateExtent:e})},setPaneClickDistance:e=>{var _f$panZoom2;(_f$panZoom2=f().panZoom)===null||_f$panZoom2===void 0||_f$panZoom2.setClickDistance(e)},resetSelectedElements:()=>{const{edges:e,nodes:t,triggerNodeChanges:n,triggerEdgeChanges:o,elementsSelectable:r}=f();if(!r)return;const i=t.reduce((e,t)=>t.selected?[...e,fa(t.id,!1)]:e,[]),a=e.reduce((e,t)=>t.selected?[...e,fa(t.id,!1)]:e,[]);n(i),o(a)},setNodeExtent:e=>{const{nodes:t,nodeLookup:n,parentLookup:o,nodeOrigin:r,elevateNodesOnSelect:i,nodeExtent:a}=f();e[0][0]===a[0][0]&&e[0][1]===a[0][1]&&e[1][0]===a[1][0]&&e[1][1]===a[1][1]||(zr(t,n,o,{nodeOrigin:r,nodeExtent:e,elevateNodesOnSelect:i,checkEquality:!1}),h({nodeExtent:e}))},panBy:e=>{const{transform:t,width:n,height:o,panZoom:r,translateExtent:i}=f();return async function(_ref119){let{delta:e,panZoom:t,transform:n,translateExtent:o,width:r,height:i}=_ref119;if(!t||!e.x&&!e.y)return Promise.resolve(!1);const a=await t.setViewportConstrained({x:n[0]+e.x,y:n[1]+e.y,zoom:n[2]},[[0,0],[r,i]],o),s=!!a&&(a.x!==n[0]||a.y!==n[1]||a.k!==n[2]);return Promise.resolve(s)}({delta:e,panZoom:r,transform:t,translateExtent:i,width:n,height:o})},setCenter:async(e,t,n)=>{const{width:o,height:r,maxZoom:i,panZoom:a}=f();if(!a)return Promise.resolve(!1);const s=void 0!==(n===null||n===void 0?void 0:n.zoom)?n.zoom:i;return await a.setViewport({x:o/2-e*s,y:r/2-t*s,zoom:s},{duration:n===null||n===void 0?void 0:n.duration,ease:n===null||n===void 0?void 0:n.ease,interpolate:n===null||n===void 0?void 0:n.interpolate}),Promise.resolve(!0)},cancelConnection:()=>{h({connection:{...uo}})},updateConnection:e=>{h({connection:e})},reset:()=>h({...Qs()})}},f=Object.is,h?Ni(h,f):Ni;var h,f};function el(_ref120){let{initialNodes:e,initialEdges:o,defaultNodes:r,defaultEdges:i,initialWidth:a,initialHeight:s,initialMinZoom:l,initialMaxZoom:c,initialFitViewOptions:u,fitView:d,nodeOrigin:h,nodeExtent:f,children:g}=_ref120;const[p]=n.useState(()=>Js({nodes:e,edges:o,defaultNodes:r,defaultEdges:i,width:a,height:s,fitView:d,minZoom:l,maxZoom:c,fitViewOptions:u,nodeOrigin:h,nodeExtent:f}));return t.jsx(Pi,{value:p,children:t.jsx(Ca,{children:g})})}function tl(_ref121){let{children:e,nodes:o,edges:r,defaultNodes:i,defaultEdges:a,width:s,height:l,fitView:c,fitViewOptions:u,minZoom:d,maxZoom:h,nodeOrigin:f,nodeExtent:g}=_ref121;return n.useContext(_i)?t.jsx(t.Fragment,{children:e}):t.jsx(el,{initialNodes:o,initialEdges:r,defaultNodes:i,defaultEdges:a,initialWidth:s,initialHeight:l,fitView:c,initialFitViewOptions:u,initialMinZoom:d,initialMaxZoom:h,nodeOrigin:f,nodeExtent:g,children:e})}const nl={width:"100%",height:"100%",overflow:"hidden",position:"relative",zIndex:0};var ol=xa((function(_ref122,St){let{nodes:o,edges:i,defaultNodes:a,defaultEdges:s,className:l,nodeTypes:c,edgeTypes:u,onNodeClick:d,onEdgeClick:h,onInit:f,onMove:g,onMoveStart:p,onMoveEnd:m,onConnect:y,onConnectStart:v,onConnectEnd:x,onClickConnectStart:w,onClickConnectEnd:b,onNodeMouseEnter:S,onNodeMouseMove:C,onNodeMouseLeave:E,onNodeContextMenu:k,onNodeDoubleClick:M,onNodeDragStart:N,onNodeDrag:_,onNodeDragStop:P,onNodesDelete:z,onEdgesDelete:O,onDelete:A,onSelectionChange:D,onSelectionDragStart:I,onSelectionDrag:R,onSelectionDragStop:L,onSelectionContextMenu:$,onSelectionStart:T,onSelectionEnd:V,onBeforeDelete:B,connectionMode:j,connectionLineType:H=e.ConnectionLineType.Bezier,connectionLineStyle:Z,connectionLineComponent:X,connectionLineContainerStyle:Y,deleteKeyCode:F="Backspace",selectionKeyCode:W="Shift",selectionOnDrag:K=!1,selectionMode:G=e.SelectionMode.Full,panActivationKeyCode:q="Space",multiSelectionKeyCode:U=(Ko()?"Meta":"Control"),zoomActivationKeyCode:Q=(Ko()?"Meta":"Control"),snapToGrid:J,snapGrid:ee,onlyRenderVisibleElements:te=!1,selectNodesOnDrag:ne,nodesDraggable:oe,autoPanOnNodeFocus:re,nodesConnectable:ie,nodesFocusable:ae,nodeOrigin:se=Ui,edgesFocusable:le,edgesReconnectable:ce,elementsSelectable:ue=!0,defaultViewport:de=Qi,minZoom:he=.5,maxZoom:fe=2,translateExtent:ge=ro,preventScrolling:pe=!0,nodeExtent:me,defaultMarkerColor:ye="#b1b1b7",zoomOnScroll:ve=!0,zoomOnPinch:xe=!0,panOnScroll:we=!1,panOnScrollSpeed:be=.5,panOnScrollMode:Se=e.PanOnScrollMode.Free,zoomOnDoubleClick:Ce=!0,panOnDrag:Ee=!0,onPaneClick:ke,onPaneMouseEnter:Me,onPaneMouseMove:Ne,onPaneMouseLeave:_e,onPaneScroll:Pe,onPaneContextMenu:ze,paneClickDistance:Oe=0,nodeClickDistance:Ae=0,children:De,onReconnect:Ie,onReconnectStart:Re,onReconnectEnd:Le,onEdgeContextMenu:$e,onEdgeDoubleClick:Te,onEdgeMouseEnter:Ve,onEdgeMouseMove:Be,onEdgeMouseLeave:je,reconnectRadius:He=10,onNodesChange:Ze,onEdgesChange:Xe,noDragClassName:Ye="nodrag",noWheelClassName:Fe="nowheel",noPanClassName:We="nopan",fitView:Ke,fitViewOptions:Ge,connectOnClick:qe,attributionPosition:Ue,proOptions:Qe,defaultEdgeOptions:Je,elevateNodesOnSelect:et,elevateEdgesOnSelect:tt,disableKeyboardA11y:nt=!1,autoPanOnConnect:ot,autoPanOnNodeDrag:rt,autoPanSpeed:it,connectionRadius:at,isValidConnection:st,onError:lt,style:ct,id:ut,nodeDragThreshold:dt,connectionDragThreshold:ht,viewport:ft,onViewportChange:gt,width:pt,height:mt,colorMode:yt="light",debug:vt,onScroll:xt,ariaLabelConfig:wt,...bt}=_ref122;const Ct=ut||"1",Et=function(e,_oa){const[t,o]=n.useState("system"===e?null:e);return n.useEffect(()=>{if("system"!==e)return void o(e);const t=oa(),n=()=>o(t!==null&&t!==void 0&&t.matches?"dark":"light");return n(),t!==null&&t!==void 0&&t.addEventListener("change",n),()=>{t===null||t===void 0||t.removeEventListener("change",n)}},[e]),null!==t?t:(_oa=oa())!==null&&_oa!==void 0&&_oa.matches?"dark":"light"}(yt),kt=n.useCallback(e=>{e.currentTarget.scrollTo({top:0,left:0,behavior:"instant"}),xt===null||xt===void 0?void 0:xt(e)},[xt]);return t.jsx("div",{"data-testid":"rf__wrapper",...bt,onScroll:kt,style:{...ct,...nl},ref:St,className:r(["react-flow",l,Et]),id:ut,role:"application",children:t.jsxs(tl,{nodes:o,edges:i,width:pt,height:mt,fitView:Ke,fitViewOptions:Ge,minZoom:he,maxZoom:fe,nodeOrigin:se,nodeExtent:me,children:[t.jsx(Us,{onInit:f,onNodeClick:d,onEdgeClick:h,onNodeMouseEnter:S,onNodeMouseMove:C,onNodeMouseLeave:E,onNodeContextMenu:k,onNodeDoubleClick:M,nodeTypes:c,edgeTypes:u,connectionLineType:H,connectionLineStyle:Z,connectionLineComponent:X,connectionLineContainerStyle:Y,selectionKeyCode:W,selectionOnDrag:K,selectionMode:G,deleteKeyCode:F,multiSelectionKeyCode:U,panActivationKeyCode:q,zoomActivationKeyCode:Q,onlyRenderVisibleElements:te,defaultViewport:de,translateExtent:ge,minZoom:he,maxZoom:fe,preventScrolling:pe,zoomOnScroll:ve,zoomOnPinch:xe,zoomOnDoubleClick:Ce,panOnScroll:we,panOnScrollSpeed:be,panOnScrollMode:Se,panOnDrag:Ee,onPaneClick:ke,onPaneMouseEnter:Me,onPaneMouseMove:Ne,onPaneMouseLeave:_e,onPaneScroll:Pe,onPaneContextMenu:ze,paneClickDistance:Oe,nodeClickDistance:Ae,onSelectionContextMenu:$,onSelectionStart:T,onSelectionEnd:V,onReconnect:Ie,onReconnectStart:Re,onReconnectEnd:Le,onEdgeContextMenu:$e,onEdgeDoubleClick:Te,onEdgeMouseEnter:Ve,onEdgeMouseMove:Be,onEdgeMouseLeave:je,reconnectRadius:He,defaultMarkerColor:ye,noDragClassName:Ye,noWheelClassName:Fe,noPanClassName:We,rfId:Ct,disableKeyboardA11y:nt,nodeExtent:me,viewport:ft,onViewportChange:gt}),t.jsx(na,{nodes:o,edges:i,defaultNodes:a,defaultEdges:s,onConnect:y,onConnectStart:v,onConnectEnd:x,onClickConnectStart:w,onClickConnectEnd:b,nodesDraggable:oe,autoPanOnNodeFocus:re,nodesConnectable:ie,nodesFocusable:ae,edgesFocusable:le,edgesReconnectable:ce,elementsSelectable:ue,elevateNodesOnSelect:et,elevateEdgesOnSelect:tt,minZoom:he,maxZoom:fe,nodeExtent:me,onNodesChange:Ze,onEdgesChange:Xe,snapToGrid:J,snapGrid:ee,connectionMode:j,translateExtent:ge,connectOnClick:qe,defaultEdgeOptions:Je,fitView:Ke,fitViewOptions:Ge,onNodesDelete:z,onEdgesDelete:O,onDelete:A,onNodeDragStart:N,onNodeDrag:_,onNodeDragStop:P,onSelectionDrag:R,onSelectionDragStart:I,onSelectionDragStop:L,onMove:g,onMoveStart:p,onMoveEnd:m,noPanClassName:We,nodeOrigin:se,rfId:Ct,autoPanOnConnect:ot,autoPanOnNodeDrag:rt,autoPanSpeed:it,onError:lt,connectionRadius:at,isValidConnection:st,selectNodesOnDrag:ne,nodeDragThreshold:dt,connectionDragThreshold:ht,onBeforeDelete:B,paneClickDistance:Oe,debug:vt,ariaLabelConfig:wt}),t.jsx(qi,{onSelectionChange:D}),De,t.jsx(Zi,{proOptions:Qe,position:Ue}),t.jsx(ji,{rfId:Ct,disableKeyboardA11y:nt})]})})}));const rl=e=>{var _e$domNode;return(_e$domNode=e.domNode)===null||_e$domNode===void 0?void 0:_e$domNode.querySelector(".react-flow__edgelabel-renderer")};const il=e=>{var _e$domNode2;return(_e$domNode2=e.domNode)===null||_e$domNode2===void 0?void 0:_e$domNode2.querySelector(".react-flow__viewport-portal")};const al=e=>e.nodes;const sl=e=>e.edges;const ll=e=>({x:e.transform[0],y:e.transform[1],zoom:e.transform[2]});const cl=oo.error014();function ul(_ref123){let{dimensions:e,lineWidth:n,variant:o,className:i}=_ref123;return t.jsx("path",{strokeWidth:n,d:`M${e[0]/2} 0 V${e[1]} M0 ${e[1]/2} H${e[0]}`,className:r(["react-flow__background-pattern",o,i])})}function dl(_ref124){let{radius:e,className:n}=_ref124;return t.jsx("circle",{cx:e,cy:e,r:e,className:r(["react-flow__background-pattern","dots",n])})}var hl;e.BackgroundVariant=void 0,(hl=e.BackgroundVariant||(e.BackgroundVariant={})).Lines="lines",hl.Dots="dots",hl.Cross="cross";const fl={[e.BackgroundVariant.Dots]:1,[e.BackgroundVariant.Lines]:1,[e.BackgroundVariant.Cross]:6},gl=e=>({transform:e.transform,patternId:`pattern-${e.rfId}`});function pl(_ref125){let{id:o,variant:i=e.BackgroundVariant.Dots,gap:a=20,size:s,lineWidth:l=1,offset:c=0,color:u,bgColor:d,style:h,className:f,patternClassName:g}=_ref125;const p=n.useRef(null),{transform:m,patternId:y}=Oi(gl,Xi),v=s||fl[i],x=i===e.BackgroundVariant.Dots,w=i===e.BackgroundVariant.Cross,b=Array.isArray(a)?a:[a,a],S=[b[0]*m[2]||1,b[1]*m[2]||1],C=v*m[2],E=Array.isArray(c)?c:[c,c],k=w?[C,C]:S,M=[E[0]*m[2]||1+k[0]/2,E[1]*m[2]||1+k[1]/2],N=`${y}${o||""}`;return t.jsxs("svg",{className:r(["react-flow__background",f]),style:{...h,..._a,"--xy-background-color-props":d,"--xy-background-pattern-color-props":u},ref:p,"data-testid":"rf__background",children:[t.jsx("pattern",{id:N,x:m[0]%S[0],y:m[1]%S[1],width:S[0],height:S[1],patternUnits:"userSpaceOnUse",patternTransform:`translate(-${M[0]},-${M[1]})`,children:x?t.jsx(dl,{radius:C/2,className:g}):t.jsx(ul,{dimensions:k,lineWidth:l,variant:i,className:g})}),t.jsx("rect",{x:"0",y:"0",width:"100%",height:"100%",fill:`url(#${N})`})]})}pl.displayName="Background";const ml=n.memo(pl);function yl(){return t.jsx("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 32 32",children:t.jsx("path",{d:"M32 18.133H18.133V32h-4.266V18.133H0v-4.266h13.867V0h4.266v13.867H32z"})})}function vl(){return t.jsx("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 32 5",children:t.jsx("path",{d:"M0 0h32v4.2H0z"})})}function xl(){return t.jsx("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 32 30",children:t.jsx("path",{d:"M3.692 4.63c0-.53.4-.938.939-.938h5.215V0H4.708C2.13 0 0 2.054 0 4.63v5.216h3.692V4.631zM27.354 0h-5.2v3.692h5.17c.53 0 .984.4.984.939v5.215H32V4.631A4.624 4.624 0 0027.354 0zm.954 24.83c0 .532-.4.94-.939.94h-5.215v3.768h5.215c2.577 0 4.631-2.13 4.631-4.707v-5.139h-3.692v5.139zm-23.677.94c-.531 0-.939-.4-.939-.94v-5.138H0v5.139c0 2.577 2.13 4.707 4.708 4.707h5.138V25.77H4.631z"})})}function wl(){return t.jsx("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 25 32",children:t.jsx("path",{d:"M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0 8 0 4.571 3.429 4.571 7.619v3.048H3.048A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047zm4.724-13.866H7.467V7.619c0-2.59 2.133-4.724 4.723-4.724 2.591 0 4.724 2.133 4.724 4.724v3.048z"})})}function bl(){return t.jsx("svg",{xmlns:"http://www.w3.org/2000/svg",viewBox:"0 0 25 32",children:t.jsx("path",{d:"M21.333 10.667H19.81V7.619C19.81 3.429 16.38 0 12.19 0c-4.114 1.828-1.37 2.133.305 2.438 1.676.305 4.42 2.59 4.42 5.181v3.048H3.047A3.056 3.056 0 000 13.714v15.238A3.056 3.056 0 003.048 32h18.285a3.056 3.056 0 003.048-3.048V13.714a3.056 3.056 0 00-3.048-3.047zM12.19 24.533a3.056 3.056 0 01-3.047-3.047 3.056 3.056 0 013.047-3.048 3.056 3.056 0 013.048 3.048 3.056 3.056 0 01-3.048 3.047z"})})}function Sl(_ref126){let{children:e,className:n,...o}=_ref126;return t.jsx("button",{type:"button",className:r(["react-flow__controls-button",n]),...o,children:e})}const Cl=e=>({isInteractive:e.nodesDraggable||e.nodesConnectable||e.elementsSelectable,minZoomReached:e.transform[2]<=e.minZoom,maxZoomReached:e.transform[2]>=e.maxZoom,ariaLabelConfig:e.ariaLabelConfig});function El(_ref127){let{style:e,showZoom:n=!0,showFitView:o=!0,showInteractive:i=!0,fitViewOptions:a,onZoomIn:s,onZoomOut:l,onFitView:c,onInteractiveChange:u,className:d,children:h,position:f="bottom-left",orientation:g="vertical","aria-label":p}=_ref127;const m=Ai(),{isInteractive:y,minZoomReached:v,maxZoomReached:x,ariaLabelConfig:w}=Oi(Cl,Xi),{zoomIn:b,zoomOut:S,fitView:C}=ka(),E="horizontal"===g?"horizontal":"vertical";return t.jsxs(Hi,{className:r(["react-flow__controls",E,d]),position:f,style:e,"data-testid":"rf__controls","aria-label":p!==null&&p!==void 0?p:w["controls.ariaLabel"],children:[n&&t.jsxs(t.Fragment,{children:[t.jsx(Sl,{onClick:()=>{b(),s===null||s===void 0?void 0:s()},className:"react-flow__controls-zoomin",title:w["controls.zoomIn.ariaLabel"],"aria-label":w["controls.zoomIn.ariaLabel"],disabled:x,children:t.jsx(yl,{})}),t.jsx(Sl,{onClick:()=>{S(),l===null||l===void 0?void 0:l()},className:"react-flow__controls-zoomout",title:w["controls.zoomOut.ariaLabel"],"aria-label":w["controls.zoomOut.ariaLabel"],disabled:v,children:t.jsx(vl,{})})]}),o&&t.jsx(Sl,{className:"react-flow__controls-fitview",onClick:()=>{C(a),c===null||c===void 0?void 0:c()},title:w["controls.fitView.ariaLabel"],"aria-label":w["controls.fitView.ariaLabel"],children:t.jsx(xl,{})}),i&&t.jsx(Sl,{className:"react-flow__controls-interactive",onClick:()=>{m.setState({nodesDraggable:!y,nodesConnectable:!y,elementsSelectable:!y}),u===null||u===void 0?void 0:u(!y)},title:w["controls.interactive.ariaLabel"],"aria-label":w["controls.interactive.ariaLabel"],children:y?t.jsx(bl,{}):t.jsx(wl,{})}),h]})}El.displayName="Controls";const kl=n.memo(El);const Ml=n.memo((function(_ref128){let{id:e,x:n,y:o,width:i,height:a,style:s,color:l,strokeColor:c,strokeWidth:u,className:d,borderRadius:h,shapeRendering:f,selected:g,onClick:p}=_ref128;const{background:m,backgroundColor:y}=s||{},v=l||m||y;return t.jsx("rect",{className:r(["react-flow__minimap-node",{selected:g},d]),x:n,y:o,rx:h,ry:h,width:i,height:a,style:{fill:v,stroke:c,strokeWidth:u},shapeRendering:f,onClick:p?t=>p(t,e):void 0})})),Nl=e=>e.nodes.map(e=>e.id),_l=e=>e instanceof Function?e:()=>e;const Pl=n.memo((function(_ref129){let{id:e,nodeColorFunc:n,nodeStrokeColorFunc:o,nodeClassNameFunc:r,nodeBorderRadius:i,nodeStrokeWidth:a,shapeRendering:s,NodeComponent:l,onClick:c}=_ref129;const{node:u,x:d,y:h,width:f,height:g}=Oi(t=>{const{internals:n}=t.nodeLookup.get(e),o=n.userNode,{x:r,y:i}=n.positionAbsolute,{width:a,height:s}=qo(o);return{node:o,x:r,y:i,width:a,height:s}},Xi);return u&&!u.hidden&&Uo(u)?t.jsx(l,{x:d,y:h,width:f,height:g,style:u.style,selected:!!u.selected,className:r(u),color:n(u),borderRadius:i,strokeColor:o(u),strokeWidth:a,shapeRendering:s,onClick:c,id:u.id}):null}));var zl=n.memo((function(_ref130){let{nodeStrokeColor:e,nodeColor:n,nodeClassName:o="",nodeBorderRadius:r=5,nodeStrokeWidth:i,nodeComponent:a=Ml,onClick:s}=_ref130;const l=Oi(Nl,Xi),c=_l(n),u=_l(e),d=_l(o),h="undefined"==typeof window||window.chrome?"crispEdges":"geometricPrecision";return t.jsx(t.Fragment,{children:l.map(e=>t.jsx(Pl,{id:e,nodeColorFunc:c,nodeStrokeColorFunc:u,nodeClassNameFunc:d,nodeBorderRadius:r,nodeStrokeWidth:i,NodeComponent:a,onClick:s,shapeRendering:h},e))})}));const Ol=e=>!e.hidden,Al=e=>{const t={x:-e.transform[0]/e.transform[2],y:-e.transform[1]/e.transform[2],width:e.width/e.transform[2],height:e.height/e.transform[2]};return{viewBB:t,boundingRect:e.nodeLookup.size>0?To(Co(e.nodeLookup,{filter:Ol}),t):t,rfId:e.rfId,panZoom:e.panZoom,translateExtent:e.translateExtent,flowWidth:e.width,flowHeight:e.height,ariaLabelConfig:e.ariaLabelConfig}};function Dl(_ref131){var _e$width4,_e$height4;let{style:e,className:o,nodeStrokeColor:i,nodeColor:a,nodeClassName:s="",nodeBorderRadius:l=5,nodeStrokeWidth:c,nodeComponent:u,bgColor:d,maskColor:h,maskStrokeColor:f,maskStrokeWidth:g,position:p="bottom-right",onClick:m,onNodeClick:y,pannable:v=!1,zoomable:x=!1,ariaLabel:w,inversePan:b,zoomStep:S=10,offsetScale:C=5}=_ref131;const E=Ai(),k=n.useRef(null),{boundingRect:M,viewBB:N,rfId:_,panZoom:P,translateExtent:z,flowWidth:O,flowHeight:A,ariaLabelConfig:D}=Oi(Al,Xi),I=(_e$width4=e===null||e===void 0?void 0:e.width)!==null&&_e$width4!==void 0?_e$width4:200,R=(_e$height4=e===null||e===void 0?void 0:e.height)!==null&&_e$height4!==void 0?_e$height4:150,L=M.width/I,$=M.height/R,T=Math.max(L,$),V=T*I,B=T*R,j=C*T,H=M.x-(V-M.width)/2-j,Z=M.y-(B-M.height)/2-j,X=V+2*j,Y=B+2*j,F=`react-flow__minimap-desc-${_}`,W=n.useRef(0),K=n.useRef();W.current=T,n.useEffect(()=>{if(k.current&&P)return K.current=function(_ref132){let{domNode:e,panZoom:t,getTransform:n,getViewScale:o}=_ref132;const r=Se(e);return{update:function(_ref133){let{translateExtent:e,width:i,height:a,zoomStep:s=10,pannable:l=!0,zoomable:c=!0,inversePan:u=!1}=_ref133;let d=[0,0];const h=no().on("start",e=>{var _e$sourceEvent$client,_e$sourceEvent$client2;"mousedown"!==e.sourceEvent.type&&"touchstart"!==e.sourceEvent.type||(d=[(_e$sourceEvent$client=e.sourceEvent.clientX)!==null&&_e$sourceEvent$client!==void 0?_e$sourceEvent$client:e.sourceEvent.touches[0].clientX,(_e$sourceEvent$client2=e.sourceEvent.clientY)!==null&&_e$sourceEvent$client2!==void 0?_e$sourceEvent$client2:e.sourceEvent.touches[0].clientY])}).on("zoom",l?r=>{var _r$sourceEvent$client,_r$sourceEvent$client2;const s=n();if("mousemove"!==r.sourceEvent.type&&"touchmove"!==r.sourceEvent.type||!t)return;const l=[(_r$sourceEvent$client=r.sourceEvent.clientX)!==null&&_r$sourceEvent$client!==void 0?_r$sourceEvent$client:r.sourceEvent.touches[0].clientX,(_r$sourceEvent$client2=r.sourceEvent.clientY)!==null&&_r$sourceEvent$client2!==void 0?_r$sourceEvent$client2:r.sourceEvent.touches[0].clientY],c=[l[0]-d[0],l[1]-d[1]];d=l;const h=o()*Math.max(s[2],Math.log(s[2]))*(u?-1:1),f={x:s[0]-c[0]*h,y:s[1]-c[1]*h},g=[[0,0],[i,a]];t.setViewportConstrained({x:f.x,y:f.y,zoom:s[2]},g,e)}:null).on("zoom.wheel",c?e=>{const o=n();if("wheel"!==e.sourceEvent.type||!t)return;const r=-e.sourceEvent.deltaY*(1===e.sourceEvent.deltaMode?.05:e.sourceEvent.deltaMode?1:.002)*s,i=o[2]*Math.pow(2,r);t.scaleTo(i)}:null);r.call(h,{})},destroy:function(){r.on("zoom",null)},pointer:Ce}}({domNode:k.current,panZoom:P,getTransform:()=>E.getState().transform,getViewScale:()=>W.current}),()=>{var _K$current;(_K$current=K.current)===null||_K$current===void 0||_K$current.destroy()}},[P]),n.useEffect(()=>{var _K$current2;(_K$current2=K.current)===null||_K$current2===void 0||_K$current2.update({translateExtent:z,width:O,height:A,inversePan:b,pannable:v,zoomStep:S,zoomable:x})},[v,x,b,S,z,O,A]);const G=m?e=>{var _K$current3;const[t,n]=((_K$current3=K.current)===null||_K$current3===void 0?void 0:_K$current3.pointer(e))||[0,0];m(e,{x:t,y:n})}:void 0,q=y?n.useCallback((e,t)=>{const n=E.getState().nodeLookup.get(t).internals.userNode;y(e,n)},[]):void 0,U=w!==null&&w!==void 0?w:D["minimap.ariaLabel"];return t.jsx(Hi,{position:p,style:{...e,"--xy-minimap-background-color-props":"string"==typeof d?d:void 0,"--xy-minimap-mask-background-color-props":"string"==typeof h?h:void 0,"--xy-minimap-mask-stroke-color-props":"string"==typeof f?f:void 0,"--xy-minimap-mask-stroke-width-props":"number"==typeof g?g*T:void 0,"--xy-minimap-node-background-color-props":"string"==typeof a?a:void 0,"--xy-minimap-node-stroke-color-props":"string"==typeof i?i:void 0,"--xy-minimap-node-stroke-width-props":"number"==typeof c?c:void 0},className:r(["react-flow__minimap",o]),"data-testid":"rf__minimap",children:t.jsxs("svg",{width:I,height:R,viewBox:`${H} ${Z} ${X} ${Y}`,className:"react-flow__minimap-svg",role:"img","aria-labelledby":F,ref:k,onClick:G,children:[U&&t.jsx("title",{id:F,children:U}),t.jsx(zl,{onClick:q,nodeColor:a,nodeStrokeColor:i,nodeBorderRadius:l,nodeClassName:s,nodeStrokeWidth:c,nodeComponent:u}),t.jsx("path",{className:"react-flow__minimap-mask",d:`M${H-j},${Z-j}h${X+2*j}v${Y+2*j}h${-X-2*j}z\n        M${N.x},${N.y}h${N.width}v${N.height}h${-N.width}z`,fillRule:"evenodd",pointerEvents:"none"})]})})}Dl.displayName="MiniMap";const Il=n.memo(Dl),Rl={[e.ResizeControlVariant.Line]:"right",[e.ResizeControlVariant.Handle]:"bottom-right"};const Ll=n.memo((function(_ref134){let{nodeId:o,position:i,variant:a=e.ResizeControlVariant.Handle,className:s,style:l,children:c,color:u,minWidth:d=10,minHeight:h=10,maxWidth:f=Number.MAX_VALUE,maxHeight:g=Number.MAX_VALUE,keepAspectRatio:p=!1,resizeDirection:m,autoScale:y=!0,shouldResize:v,onResizeStart:x,onResize:w,onResizeEnd:b}=_ref134;const S=Ha(),C="string"==typeof o?o:S,E=Ai(),k=n.useRef(null),M=a===e.ResizeControlVariant.Handle,N=Oi(n.useCallback((_=M&&y,e=>_?`${Math.max(1/e.transform[2],1)}`:void 0),[M,y]),Xi);var _;const P=n.useRef(null),z=i!==null&&i!==void 0?i:Rl[a];n.useEffect(()=>{if(k.current&&C)return P.current||(P.current=fi({domNode:k.current,nodeId:C,getStoreItems:()=>{const{nodeLookup:e,transform:t,snapGrid:n,snapToGrid:o,nodeOrigin:r,domNode:i}=E.getState();return{nodeLookup:e,transform:t,snapGrid:n,snapToGrid:o,nodeOrigin:r,paneDomNode:i}},onChange:(e,t)=>{const{triggerNodeChanges:n,nodeLookup:o,parentLookup:r,nodeOrigin:i}=E.getState(),a=[],s={x:e.x,y:e.y},l=o.get(C);if(l&&l.expandParent&&l.parentId){var _l$origin,_ref135,_e$width5,_ref136,_e$height5,_e$x,_e$y;const t=(_l$origin=l.origin)!==null&&_l$origin!==void 0?_l$origin:i,n=(_ref135=(_e$width5=e.width)!==null&&_e$width5!==void 0?_e$width5:l.measured.width)!==null&&_ref135!==void 0?_ref135:0,c=(_ref136=(_e$height5=e.height)!==null&&_e$height5!==void 0?_e$height5:l.measured.height)!==null&&_ref136!==void 0?_ref136:0,u=Dr([{id:l.id,parentId:l.parentId,rect:{width:n,height:c,...Qo({x:(_e$x=e.x)!==null&&_e$x!==void 0?_e$x:l.position.x,y:(_e$y=e.y)!==null&&_e$y!==void 0?_e$y:l.position.y},{width:n,height:c},l.parentId,o,t)}}],o,r,i);a.push(...u),s.x=e.x?Math.max(t[0]*n,e.x):void 0,s.y=e.y?Math.max(t[1]*c,e.y):void 0}if(void 0!==s.x&&void 0!==s.y){const e={id:C,type:"position",position:{...s}};a.push(e)}if(void 0!==e.width&&void 0!==e.height){const t={id:C,type:"dimensions",resizing:!0,setAttributes:!m||("horizontal"===m?"width":"height"),dimensions:{width:e.width,height:e.height}};a.push(t)}for(const e of t){const t={...e,type:"position"};a.push(t)}n(a)},onEnd:_ref137=>{let{width:e,height:t}=_ref137;const n={id:C,type:"dimensions",resizing:!1,dimensions:{width:e,height:t}};E.getState().triggerNodeChanges([n])}})),P.current.update({controlPosition:z,boundaries:{minWidth:d,minHeight:h,maxWidth:f,maxHeight:g},keepAspectRatio:p,resizeDirection:m,onResizeStart:x,onResize:w,onResizeEnd:b,shouldResize:v}),()=>{var _P$current;(_P$current=P.current)===null||_P$current===void 0||_P$current.destroy()}},[z,d,h,f,g,p,x,w,b,v]);const O=z.split("-");return t.jsx("div",{className:r(["react-flow__resize-control","nodrag",...O,a,s]),ref:k,style:{...l,scale:N,...u&&{[M?"backgroundColor":"borderColor"]:u}},children:c})}));const $l=e=>{var _e$domNode3;return(_e$domNode3=e.domNode)===null||_e$domNode3===void 0?void 0:_e$domNode3.querySelector(".react-flow__renderer")};function Tl(_ref138){let{children:e}=_ref138;const t=Oi($l);return t?o.createPortal(e,t):null}const Vl=(e,t)=>(e===null||e===void 0?void 0:e.internals.positionAbsolute.x)!==(t===null||t===void 0?void 0:t.internals.positionAbsolute.x)||(e===null||e===void 0?void 0:e.internals.positionAbsolute.y)!==(t===null||t===void 0?void 0:t.internals.positionAbsolute.y)||(e===null||e===void 0?void 0:e.measured.width)!==(t===null||t===void 0?void 0:t.measured.width)||(e===null||e===void 0?void 0:e.measured.height)!==(t===null||t===void 0?void 0:t.measured.height)||(e===null||e===void 0?void 0:e.selected)!==(t===null||t===void 0?void 0:t.selected)||(e===null||e===void 0?void 0:e.internals.z)!==(t===null||t===void 0?void 0:t.internals.z),Bl=(e,t)=>{if(e.size!==t.size)return!1;for(const[n,o]of e)if(Vl(o,t.get(n)))return!1;return!0},jl=e=>({x:e.transform[0],y:e.transform[1],zoom:e.transform[2],selectedNodesCount:e.nodes.filter(e=>e.selected).length});e.Background=ml,e.BaseEdge=ds,e.BezierEdge=Ns,e.ControlButton=Sl,e.Controls=kl,e.EdgeLabelRenderer=function(_ref139){let{children:e}=_ref139;const t=Oi(rl);return t?o.createPortal(e,t):null},e.EdgeText=us,e.Handle=Xa,e.MiniMap=Il,e.NodeResizeControl=Ll,e.NodeResizer=function(_ref140){let{nodeId:n,isVisible:o=!0,handleClassName:r,handleStyle:i,lineClassName:a,lineStyle:s,color:l,minWidth:c=10,minHeight:u=10,maxWidth:d=Number.MAX_VALUE,maxHeight:h=Number.MAX_VALUE,keepAspectRatio:f=!1,autoScale:g=!0,shouldResize:p,onResizeStart:m,onResize:y,onResizeEnd:v}=_ref140;return o?t.jsxs(t.Fragment,{children:[ii.map(o=>t.jsx(Ll,{className:a,style:s,nodeId:n,position:o,variant:e.ResizeControlVariant.Line,color:l,minWidth:c,minHeight:u,maxWidth:d,maxHeight:h,onResizeStart:m,keepAspectRatio:f,autoScale:g,shouldResize:p,onResize:y,onResizeEnd:v},o)),ri.map(e=>t.jsx(Ll,{className:r,style:i,nodeId:n,position:e,color:l,minWidth:c,minHeight:u,maxWidth:d,maxHeight:h,onResizeStart:m,keepAspectRatio:f,autoScale:g,shouldResize:p,onResize:y,onResizeEnd:v},e))]}):null},e.NodeToolbar=function(_ref141){var _p$values$next$value;let{nodeId:o,children:i,className:a,style:s,isVisible:l,position:c=e.Position.Top,offset:u=10,align:d="center",...h}=_ref141;const f=Ha(),g=n.useCallback(e=>{const t=(Array.isArray(o)?o:[o||f||""]).reduce((t,n)=>{const o=e.nodeLookup.get(n);return o&&t.set(o.id,o),t},new Map);return t},[o,f]),p=Oi(g,Bl),{x:m,y:y,zoom:v,selectedNodesCount:x}=Oi(jl,Xi);if(!("boolean"==typeof l?l:1===p.size&&((_p$values$next$value=p.values().next().value)===null||_p$values$next$value===void 0?void 0:_p$values$next$value.selected)&&1===x)||!p.size)return null;const w=Co(p),b=Array.from(p.values()),S=Math.max(...b.map(e=>e.internals.z+1)),C={position:"absolute",transform:Mr(w,{x:m,y:y,zoom:v},c,u,d),zIndex:S,...s};return t.jsx(Tl,{children:t.jsx("div",{style:C,className:r(["react-flow__node-toolbar",a]),...h,"data-id":b.reduce((e,t)=>`${e}${t.id} `,"").trim(),children:i})})},e.Panel=Hi,e.ReactFlow=ol,e.ReactFlowProvider=el,e.SimpleBezierEdge=ps,e.SmoothStepEdge=vs,e.StepEdge=bs,e.StraightEdge=Es,e.ViewportPortal=function(_ref142){let{children:e}=_ref142;const t=Oi(il);return t?o.createPortal(e,t):null},e.addEdge=pr,e.applyEdgeChanges=ha,e.applyNodeChanges=da,e.getBezierEdgeCenter=lr,e.getBezierPath=dr,e.getConnectedEdges=ko,e.getEdgeCenter=hr,e.getIncomers=(e,t,n)=>{if(!e.id)return[];const o=new Set;return n.forEach(t=>{t.target===e.id&&o.add(t.source)}),t.filter(e=>o.has(e.id))},e.getNodesBounds=So,e.getOutgoers=(e,t,n)=>{if(!e.id)return[];const o=new Set;return n.forEach(t=>{t.source===e.id&&o.add(t.target)}),t.filter(e=>o.has(e.id))},e.getSimpleBezierPath=fs,e.getSmoothStepPath=wr,e.getStraightPath=mr,e.getViewportForBounds=Wo,e.isEdge=va,e.isNode=ya,e.reconnectEdge=function(e,t,n){let o=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{shouldReplaceId:!0};const{id:r,...i}=e;if(!t.source||!t.target)return n;if(!n.find(t=>t.id===e.id))return n;const a={...i,id:o.shouldReplaceId?gr(t):r,source:t.source,target:t.target,sourceHandle:t.sourceHandle,targetHandle:t.targetHandle};return n.filter(e=>e.id!==r).concat(a)},e.useConnection=Xs,e.useEdges=function(){return Oi(sl,Xi)},e.useEdgesState=function(e){const[t,o]=n.useState(e),r=n.useCallback(e=>o(t=>ha(e,t)),[]);return[t,o,r]},e.useHandleConnections=function(_ref143){let{type:e,id:t,nodeId:o,onConnect:r,onDisconnect:i}=_ref143;console.warn("[DEPRECATED] `useHandleConnections` is deprecated. Instead use `useNodeConnections` https://reactflow.dev/api-reference/hooks/useNodeConnections");const a=Ha(),s=o!==null&&o!==void 0?o:a,l=n.useRef(null),c=Oi(n=>n.connectionLookup.get(`${s}-${e}${t?`-${t}`:""}`),mo);return n.useEffect(()=>{if(l.current&&l.current!==c){const e=c!==null&&c!==void 0?c:new Map;yo(l.current,e,i),yo(e,l.current,r)}l.current=c!==null&&c!==void 0?c:new Map},[c,r,i]),n.useMemo(()=>{var _c$values;return Array.from((_c$values=c===null||c===void 0?void 0:c.values())!==null&&_c$values!==void 0?_c$values:[])},[c])},e.useInternalNode=function(e){return Oi(n.useCallback(t=>t.nodeLookup.get(e),[e]),Xi)},e.useKeyPress=ia,e.useNodeConnections=function(){let{id:e,handleType:t,handleId:o,onConnect:r,onDisconnect:i}=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{};const a=Ha(),s=e!==null&&e!==void 0?e:a;if(!s)throw new Error(cl);const l=n.useRef(null),c=Oi(e=>e.connectionLookup.get(`${s}${t?o?`-${t}-${o}`:`-${t}`:""}`),mo);return n.useEffect(()=>{if(l.current&&l.current!==c){const e=c!==null&&c!==void 0?c:new Map;yo(l.current,e,i),yo(e,l.current,r)}l.current=c!==null&&c!==void 0?c:new Map},[c,r,i]),n.useMemo(()=>{var _c$values2;return Array.from((_c$values2=c===null||c===void 0?void 0:c.values())!==null&&_c$values2!==void 0?_c$values2:[])},[c])},e.useNodeId=Ha,e.useNodes=function(){return Oi(al,Xi)},e.useNodesData=function(e){return Oi(n.useCallback(t=>{var _n$;const n=[],o=Array.isArray(e),r=o?e:[e];for(const e of r){const o=t.nodeLookup.get(e);o&&n.push({id:o.id,type:o.type,data:o.data})}return o?n:(_n$=n[0])!==null&&_n$!==void 0?_n$:null},[e]),Lr)},e.useNodesInitialized=function(){let e=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{includeHiddenNodes:!1};return Oi((e=>t=>{if(!e.includeHiddenNodes)return t.nodesInitialized;if(0===t.nodeLookup.size)return!1;for(const[,{internals:e}]of t.nodeLookup)if(void 0===e.handleBounds||!Uo(e.userNode))return!1;return!0})(e))},e.useNodesState=function(e){const[t,o]=n.useState(e),r=n.useCallback(e=>o(t=>da(e,t)),[]);return[t,o,r]},e.useOnSelectionChange=function(_ref144){let{onChange:e}=_ref144;const t=Ai();n.useEffect(()=>{const n=[...t.getState().onSelectionChangeHandlers,e];return t.setState({onSelectionChangeHandlers:n}),()=>{const n=t.getState().onSelectionChangeHandlers.filter(t=>t!==e);t.setState({onSelectionChangeHandlers:n})}},[e])},e.useOnViewportChange=function(_ref145){let{onStart:e,onChange:t,onEnd:o}=_ref145;const r=Ai();n.useEffect(()=>{r.setState({onViewportChangeStart:e})},[e]),n.useEffect(()=>{r.setState({onViewportChange:t})},[t]),n.useEffect(()=>{r.setState({onViewportChangeEnd:o})},[o])},e.useReactFlow=ka,e.useStore=Oi,e.useStoreApi=Ai,e.useUpdateNodeInternals=function(){const e=Ai();return n.useCallback(t=>{const{domNode:n,updateNodeInternals:o}=e.getState(),r=Array.isArray(t)?t:[t],i=new Map;r.forEach(e=>{const t=n===null||n===void 0?void 0:n.querySelector(`.react-flow__node[data-id="${e}"]`);t&&i.set(e,{id:e,nodeElement:t,force:!0})}),requestAnimationFrame(()=>o(i,{triggerFitView:!1}))},[])},e.useViewport=function(){return Oi(ll,Xi)}}))},1078:function(module,exports,__webpack_require__){"use strict";if(true){module.exports=__webpack_require__(1079)}else{}},1079:function(module,exports,__webpack_require__){"use strict";
/** @license React v16.14.0
 * react-jsx-runtime.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */var f=__webpack_require__(0),g=60103;exports.Fragment=60107;if("function"===typeof Symbol&&Symbol.for){var h=Symbol.for;g=h("react.element");exports.Fragment=h("react.fragment")}var m=f.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner,n=Object.prototype.hasOwnProperty,p={key:!0,ref:!0,__self:!0,__source:!0};function q(c,a,k){var b,d={},e=null,l=null;void 0!==k&&(e=""+k);void 0!==a.key&&(e=""+a.key);void 0!==a.ref&&(l=a.ref);for(b in a)n.call(a,b)&&!p.hasOwnProperty(b)&&(d[b]=a[b]);if(c&&c.defaultProps)for(b in a=c.defaultProps,a)void 0===d[b]&&(d[b]=a[b]);return{$$typeof:g,type:c,key:e,ref:l,props:d,_owner:m.current}}exports.jsx=q;exports.jsxs=q},482:function(module,exports,__webpack_require__){"use strict";let Graph=__webpack_require__(484).Graph;module.exports={addBorderNode:addBorderNode,addDummyNode:addDummyNode,applyWithChunking:applyWithChunking,asNonCompoundGraph:asNonCompoundGraph,buildLayerMatrix:buildLayerMatrix,intersectRect:intersectRect,mapValues:mapValues,maxRank:maxRank,normalizeRanks:normalizeRanks,notime:notime,partition:partition,pick:pick,predecessorWeights:predecessorWeights,range:range,removeEmptyRanks:removeEmptyRanks,simplify:simplify,successorWeights:successorWeights,time:time,uniqueId:uniqueId,zipObject:zipObject};function addDummyNode(g,type,attrs,name){var v=name;while(g.hasNode(v)){v=uniqueId(name)}attrs.dummy=type;g.setNode(v,attrs);return v}function simplify(g){let simplified=(new Graph).setGraph(g.graph());g.nodes().forEach(v=>simplified.setNode(v,g.node(v)));g.edges().forEach(e=>{let simpleLabel=simplified.edge(e.v,e.w)||{weight:0,minlen:1};let label=g.edge(e);simplified.setEdge(e.v,e.w,{weight:simpleLabel.weight+label.weight,minlen:Math.max(simpleLabel.minlen,label.minlen)})});return simplified}function asNonCompoundGraph(g){let simplified=new Graph({multigraph:g.isMultigraph()}).setGraph(g.graph());g.nodes().forEach(v=>{if(!g.children(v).length){simplified.setNode(v,g.node(v))}});g.edges().forEach(e=>{simplified.setEdge(e,g.edge(e))});return simplified}function successorWeights(g){let weightMap=g.nodes().map(v=>{let sucs={};g.outEdges(v).forEach(e=>{sucs[e.w]=(sucs[e.w]||0)+g.edge(e).weight});return sucs});return zipObject(g.nodes(),weightMap)}function predecessorWeights(g){let weightMap=g.nodes().map(v=>{let preds={};g.inEdges(v).forEach(e=>{preds[e.v]=(preds[e.v]||0)+g.edge(e).weight});return preds});return zipObject(g.nodes(),weightMap)}function intersectRect(rect,point){let x=rect.x;let y=rect.y;let dx=point.x-x;let dy=point.y-y;let w=rect.width/2;let h=rect.height/2;if(!dx&&!dy){throw new Error("Not possible to find intersection inside of the rectangle")}let sx,sy;if(Math.abs(dy)*w>Math.abs(dx)*h){if(dy<0){h=-h}sx=h*dx/dy;sy=h}else{if(dx<0){w=-w}sx=w;sy=w*dy/dx}return{x:x+sx,y:y+sy}}function buildLayerMatrix(g){let layering=range(maxRank(g)+1).map(()=>[]);g.nodes().forEach(v=>{let node=g.node(v);let rank=node.rank;if(rank!==undefined){layering[rank][node.order]=v}});return layering}function normalizeRanks(g){let nodeRanks=g.nodes().map(v=>{let rank=g.node(v).rank;if(rank===undefined){return Number.MAX_VALUE}return rank});let min=applyWithChunking(Math.min,nodeRanks);g.nodes().forEach(v=>{let node=g.node(v);if(Object.hasOwn(node,"rank")){node.rank-=min}})}function removeEmptyRanks(g){let nodeRanks=g.nodes().map(v=>g.node(v).rank);let offset=applyWithChunking(Math.min,nodeRanks);let layers=[];g.nodes().forEach(v=>{let rank=g.node(v).rank-offset;if(!layers[rank]){layers[rank]=[]}layers[rank].push(v)});let delta=0;let nodeRankFactor=g.graph().nodeRankFactor;Array.from(layers).forEach((vs,i)=>{if(vs===undefined&&i%nodeRankFactor!==0){--delta}else if(vs!==undefined&&delta){vs.forEach(v=>g.node(v).rank+=delta)}})}function addBorderNode(g,prefix,rank,order){let node={width:0,height:0};if(arguments.length>=4){node.rank=rank;node.order=order}return addDummyNode(g,"border",node,prefix)}function splitToChunks(array){let chunkSize=arguments.length>1&&arguments[1]!==undefined?arguments[1]:CHUNKING_THRESHOLD;const chunks=[];for(let i=0;i<array.length;i+=chunkSize){const chunk=array.slice(i,i+chunkSize);chunks.push(chunk)}return chunks}const CHUNKING_THRESHOLD=65535;function applyWithChunking(fn,argsArray){if(argsArray.length>CHUNKING_THRESHOLD){const chunks=splitToChunks(argsArray);return fn.apply(null,chunks.map(chunk=>fn.apply(null,chunk)))}else{return fn.apply(null,argsArray)}}function maxRank(g){const nodes=g.nodes();const nodeRanks=nodes.map(v=>{let rank=g.node(v).rank;if(rank===undefined){return Number.MIN_VALUE}return rank});return applyWithChunking(Math.max,nodeRanks)}function partition(collection,fn){let result={lhs:[],rhs:[]};collection.forEach(value=>{if(fn(value)){result.lhs.push(value)}else{result.rhs.push(value)}});return result}function time(name,fn){let start=Date.now();try{return fn()}finally{console.log(name+" time: "+(Date.now()-start)+"ms")}}function notime(name,fn){return fn()}let idCounter=0;function uniqueId(prefix){var id=++idCounter;return prefix+(""+id)}function range(start,limit){let step=arguments.length>2&&arguments[2]!==undefined?arguments[2]:1;if(limit==null){limit=start;start=0}let endCon=i=>i<limit;if(step<0){endCon=i=>limit<i}const range=[];for(let i=start;endCon(i);i+=step){range.push(i)}return range}function pick(source,keys){const dest={};for(const key of keys){if(source[key]!==undefined){dest[key]=source[key]}}return dest}function mapValues(obj,funcOrProp){let func=funcOrProp;if(typeof funcOrProp==="string"){func=val=>val[funcOrProp]}return Object.entries(obj).reduce((acc,_ref)=>{let[k,v]=_ref;acc[k]=func(v,k);return acc},{})}function zipObject(props,values){return props.reduce((acc,key,i)=>{acc[key]=values[i];return acc},{})}},484:function(module,exports,__webpack_require__){var lib=__webpack_require__(1026);module.exports={Graph:lib.Graph,json:__webpack_require__(1028),alg:__webpack_require__(1029),version:lib.version}},494:function(module,exports,__webpack_require__){"use strict";const{applyWithChunking:applyWithChunking}=__webpack_require__(482);module.exports={longestPath:longestPath,slack:slack};function longestPath(g){var visited={};function dfs(v){var label=g.node(v);if(Object.hasOwn(visited,v)){return label.rank}visited[v]=true;let outEdgesMinLens=g.outEdges(v).map(e=>{if(e==null){return Number.POSITIVE_INFINITY}return dfs(e.w)-g.edge(e).minlen});var rank=applyWithChunking(Math.min,outEdgesMinLens);if(rank===Number.POSITIVE_INFINITY){rank=0}return label.rank=rank}g.sources().forEach(dfs)}function slack(g,e){return g.node(e.w).rank-g.node(e.v).rank-g.edge(e).minlen}},501:function(module,exports,__webpack_require__){"use strict";function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}var DEFAULT_EDGE_NAME="\0";var GRAPH_NODE="\0";var EDGE_KEY_DELIM="";class Graph{constructor(opts){_defineProperty(this,"_isDirected",true);_defineProperty(this,"_isMultigraph",false);_defineProperty(this,"_isCompound",false);_defineProperty(this,"_label",void 0);_defineProperty(this,"_defaultNodeLabelFn",()=>undefined);_defineProperty(this,"_defaultEdgeLabelFn",()=>undefined);_defineProperty(this,"_nodes",{});_defineProperty(this,"_in",{});_defineProperty(this,"_preds",{});_defineProperty(this,"_out",{});_defineProperty(this,"_sucs",{});_defineProperty(this,"_edgeObjs",{});_defineProperty(this,"_edgeLabels",{});_defineProperty(this,"_nodeCount",0);_defineProperty(this,"_edgeCount",0);_defineProperty(this,"_parent",void 0);_defineProperty(this,"_children",void 0);if(opts){this._isDirected=Object.hasOwn(opts,"directed")?opts.directed:true;this._isMultigraph=Object.hasOwn(opts,"multigraph")?opts.multigraph:false;this._isCompound=Object.hasOwn(opts,"compound")?opts.compound:false}if(this._isCompound){this._parent={};this._children={};this._children[GRAPH_NODE]={}}}isDirected(){return this._isDirected}isMultigraph(){return this._isMultigraph}isCompound(){return this._isCompound}setGraph(label){this._label=label;return this}graph(){return this._label}setDefaultNodeLabel(newDefault){this._defaultNodeLabelFn=newDefault;if(typeof newDefault!=="function"){this._defaultNodeLabelFn=()=>newDefault}return this}nodeCount(){return this._nodeCount}nodes(){return Object.keys(this._nodes)}sources(){var self=this;return this.nodes().filter(v=>Object.keys(self._in[v]).length===0)}sinks(){var self=this;return this.nodes().filter(v=>Object.keys(self._out[v]).length===0)}setNodes(vs,value){var args=arguments;var self=this;vs.forEach((function(v){if(args.length>1){self.setNode(v,value)}else{self.setNode(v)}}));return this}setNode(v,value){if(Object.hasOwn(this._nodes,v)){if(arguments.length>1){this._nodes[v]=value}return this}this._nodes[v]=arguments.length>1?value:this._defaultNodeLabelFn(v);if(this._isCompound){this._parent[v]=GRAPH_NODE;this._children[v]={};this._children[GRAPH_NODE][v]=true}this._in[v]={};this._preds[v]={};this._out[v]={};this._sucs[v]={};++this._nodeCount;return this}node(v){return this._nodes[v]}hasNode(v){return Object.hasOwn(this._nodes,v)}removeNode(v){var self=this;if(Object.hasOwn(this._nodes,v)){var removeEdge=e=>self.removeEdge(self._edgeObjs[e]);delete this._nodes[v];if(this._isCompound){this._removeFromParentsChildList(v);delete this._parent[v];this.children(v).forEach((function(child){self.setParent(child)}));delete this._children[v]}Object.keys(this._in[v]).forEach(removeEdge);delete this._in[v];delete this._preds[v];Object.keys(this._out[v]).forEach(removeEdge);delete this._out[v];delete this._sucs[v];--this._nodeCount}return this}setParent(v,parent){if(!this._isCompound){throw new Error("Cannot set parent in a non-compound graph")}if(parent===undefined){parent=GRAPH_NODE}else{parent+="";for(var ancestor=parent;ancestor!==undefined;ancestor=this.parent(ancestor)){if(ancestor===v){throw new Error("Setting "+parent+" as parent of "+v+" would create a cycle")}}this.setNode(parent)}this.setNode(v);this._removeFromParentsChildList(v);this._parent[v]=parent;this._children[parent][v]=true;return this}_removeFromParentsChildList(v){delete this._children[this._parent[v]][v]}parent(v){if(this._isCompound){var parent=this._parent[v];if(parent!==GRAPH_NODE){return parent}}}children(){let v=arguments.length>0&&arguments[0]!==undefined?arguments[0]:GRAPH_NODE;if(this._isCompound){var children=this._children[v];if(children){return Object.keys(children)}}else if(v===GRAPH_NODE){return this.nodes()}else if(this.hasNode(v)){return[]}}predecessors(v){var predsV=this._preds[v];if(predsV){return Object.keys(predsV)}}successors(v){var sucsV=this._sucs[v];if(sucsV){return Object.keys(sucsV)}}neighbors(v){var preds=this.predecessors(v);if(preds){const union=new Set(preds);for(var succ of this.successors(v)){union.add(succ)}return Array.from(union.values())}}isLeaf(v){var neighbors;if(this.isDirected()){neighbors=this.successors(v)}else{neighbors=this.neighbors(v)}return neighbors.length===0}filterNodes(filter){var copy=new this.constructor({directed:this._isDirected,multigraph:this._isMultigraph,compound:this._isCompound});copy.setGraph(this.graph());var self=this;Object.entries(this._nodes).forEach((function(_ref){let[v,value]=_ref;if(filter(v)){copy.setNode(v,value)}}));Object.values(this._edgeObjs).forEach((function(e){if(copy.hasNode(e.v)&&copy.hasNode(e.w)){copy.setEdge(e,self.edge(e))}}));var parents={};function findParent(v){var parent=self.parent(v);if(parent===undefined||copy.hasNode(parent)){parents[v]=parent;return parent}else if(parent in parents){return parents[parent]}else{return findParent(parent)}}if(this._isCompound){copy.nodes().forEach(v=>copy.setParent(v,findParent(v)))}return copy}setDefaultEdgeLabel(newDefault){this._defaultEdgeLabelFn=newDefault;if(typeof newDefault!=="function"){this._defaultEdgeLabelFn=()=>newDefault}return this}edgeCount(){return this._edgeCount}edges(){return Object.values(this._edgeObjs)}setPath(vs,value){var self=this;var args=arguments;vs.reduce((function(v,w){if(args.length>1){self.setEdge(v,w,value)}else{self.setEdge(v,w)}return w}));return this}setEdge(){var v,w,name,value;var valueSpecified=false;var arg0=arguments[0];if(typeof arg0==="object"&&arg0!==null&&"v"in arg0){v=arg0.v;w=arg0.w;name=arg0.name;if(arguments.length===2){value=arguments[1];valueSpecified=true}}else{v=arg0;w=arguments[1];name=arguments[3];if(arguments.length>2){value=arguments[2];valueSpecified=true}}v=""+v;w=""+w;if(name!==undefined){name=""+name}var e=edgeArgsToId(this._isDirected,v,w,name);if(Object.hasOwn(this._edgeLabels,e)){if(valueSpecified){this._edgeLabels[e]=value}return this}if(name!==undefined&&!this._isMultigraph){throw new Error("Cannot set a named edge when isMultigraph = false")}this.setNode(v);this.setNode(w);this._edgeLabels[e]=valueSpecified?value:this._defaultEdgeLabelFn(v,w,name);var edgeObj=edgeArgsToObj(this._isDirected,v,w,name);v=edgeObj.v;w=edgeObj.w;Object.freeze(edgeObj);this._edgeObjs[e]=edgeObj;incrementOrInitEntry(this._preds[w],v);incrementOrInitEntry(this._sucs[v],w);this._in[w][e]=edgeObj;this._out[v][e]=edgeObj;this._edgeCount++;return this}edge(v,w,name){var e=arguments.length===1?edgeObjToId(this._isDirected,arguments[0]):edgeArgsToId(this._isDirected,v,w,name);return this._edgeLabels[e]}edgeAsObj(){const edge=this.edge(...arguments);if(typeof edge!=="object"){return{label:edge}}return edge}hasEdge(v,w,name){var e=arguments.length===1?edgeObjToId(this._isDirected,arguments[0]):edgeArgsToId(this._isDirected,v,w,name);return Object.hasOwn(this._edgeLabels,e)}removeEdge(v,w,name){var e=arguments.length===1?edgeObjToId(this._isDirected,arguments[0]):edgeArgsToId(this._isDirected,v,w,name);var edge=this._edgeObjs[e];if(edge){v=edge.v;w=edge.w;delete this._edgeLabels[e];delete this._edgeObjs[e];decrementOrRemoveEntry(this._preds[w],v);decrementOrRemoveEntry(this._sucs[v],w);delete this._in[w][e];delete this._out[v][e];this._edgeCount--}return this}inEdges(v,u){var inV=this._in[v];if(inV){var edges=Object.values(inV);if(!u){return edges}return edges.filter(edge=>edge.v===u)}}outEdges(v,w){var outV=this._out[v];if(outV){var edges=Object.values(outV);if(!w){return edges}return edges.filter(edge=>edge.w===w)}}nodeEdges(v,w){var inEdges=this.inEdges(v,w);if(inEdges){return inEdges.concat(this.outEdges(v,w))}}}function incrementOrInitEntry(map,k){if(map[k]){map[k]++}else{map[k]=1}}function decrementOrRemoveEntry(map,k){if(!--map[k]){delete map[k]}}function edgeArgsToId(isDirected,v_,w_,name){var v=""+v_;var w=""+w_;if(!isDirected&&v>w){var tmp=v;v=w;w=tmp}return v+EDGE_KEY_DELIM+w+EDGE_KEY_DELIM+(name===undefined?DEFAULT_EDGE_NAME:name)}function edgeArgsToObj(isDirected,v_,w_,name){var v=""+v_;var w=""+w_;if(!isDirected&&v>w){var tmp=v;v=w;w=tmp}var edgeObj={v:v,w:w};if(name){edgeObj.name=name}return edgeObj}function edgeObjToId(isDirected,edgeObj){return edgeArgsToId(isDirected,edgeObj.v,edgeObj.w,edgeObj.name)}module.exports=Graph},506:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _interopDefault(ex){return ex&&typeof ex==="object"&&"default"in ex?ex["default"]:ex}var allLocaleData=_interopDefault(__webpack_require__(655));var IntlMessageFormat=_interopDefault(__webpack_require__(507));var IntlRelativeFormat=_interopDefault(__webpack_require__(664));var PropTypes=_interopDefault(__webpack_require__(151));var React=__webpack_require__(0);var React__default=_interopDefault(React);var hoistNonReactStatics=_interopDefault(__webpack_require__(671));var invariant=_interopDefault(__webpack_require__(674));var memoizeIntlConstructor=_interopDefault(__webpack_require__(675));var defaultLocaleData={locale:"en",pluralRuleFunction:function pluralRuleFunction(n,ord){var s=String(n).split("."),v0=!s[1],t0=Number(s[0])==n,n10=t0&&s[0].slice(-1),n100=t0&&s[0].slice(-2);if(ord)return n10==1&&n100!=11?"one":n10==2&&n100!=12?"two":n10==3&&n100!=13?"few":"other";return n==1&&v0?"one":"other"},fields:{year:{displayName:"year",relative:{0:"this year",1:"next year","-1":"last year"},relativeTime:{future:{one:"in {0} year",other:"in {0} years"},past:{one:"{0} year ago",other:"{0} years ago"}}},"year-short":{displayName:"yr.",relative:{0:"this yr.",1:"next yr.","-1":"last yr."},relativeTime:{future:{one:"in {0} yr.",other:"in {0} yr."},past:{one:"{0} yr. ago",other:"{0} yr. ago"}}},month:{displayName:"month",relative:{0:"this month",1:"next month","-1":"last month"},relativeTime:{future:{one:"in {0} month",other:"in {0} months"},past:{one:"{0} month ago",other:"{0} months ago"}}},"month-short":{displayName:"mo.",relative:{0:"this mo.",1:"next mo.","-1":"last mo."},relativeTime:{future:{one:"in {0} mo.",other:"in {0} mo."},past:{one:"{0} mo. ago",other:"{0} mo. ago"}}},day:{displayName:"day",relative:{0:"today",1:"tomorrow","-1":"yesterday"},relativeTime:{future:{one:"in {0} day",other:"in {0} days"},past:{one:"{0} day ago",other:"{0} days ago"}}},"day-short":{displayName:"day",relative:{0:"today",1:"tomorrow","-1":"yesterday"},relativeTime:{future:{one:"in {0} day",other:"in {0} days"},past:{one:"{0} day ago",other:"{0} days ago"}}},hour:{displayName:"hour",relative:{0:"this hour"},relativeTime:{future:{one:"in {0} hour",other:"in {0} hours"},past:{one:"{0} hour ago",other:"{0} hours ago"}}},"hour-short":{displayName:"hr.",relative:{0:"this hour"},relativeTime:{future:{one:"in {0} hr.",other:"in {0} hr."},past:{one:"{0} hr. ago",other:"{0} hr. ago"}}},minute:{displayName:"minute",relative:{0:"this minute"},relativeTime:{future:{one:"in {0} minute",other:"in {0} minutes"},past:{one:"{0} minute ago",other:"{0} minutes ago"}}},"minute-short":{displayName:"min.",relative:{0:"this minute"},relativeTime:{future:{one:"in {0} min.",other:"in {0} min."},past:{one:"{0} min. ago",other:"{0} min. ago"}}},second:{displayName:"second",relative:{0:"now"},relativeTime:{future:{one:"in {0} second",other:"in {0} seconds"},past:{one:"{0} second ago",other:"{0} seconds ago"}}},"second-short":{displayName:"sec.",relative:{0:"now"},relativeTime:{future:{one:"in {0} sec.",other:"in {0} sec."},past:{one:"{0} sec. ago",other:"{0} sec. ago"}}}}};function addLocaleData(){var data=arguments.length>0&&arguments[0]!==undefined?arguments[0]:[];var locales=Array.isArray(data)?data:[data];locales.forEach((function(localeData){if(localeData&&localeData.locale){IntlMessageFormat.__addLocaleData(localeData);IntlRelativeFormat.__addLocaleData(localeData)}}))}function hasLocaleData(locale){var localeParts=(locale||"").split("-");while(localeParts.length>0){if(hasIMFAndIRFLocaleData(localeParts.join("-"))){return true}localeParts.pop()}return false}function hasIMFAndIRFLocaleData(locale){var normalizedLocale=locale&&locale.toLowerCase();return!!(IntlMessageFormat.__localeData__[normalizedLocale]&&IntlRelativeFormat.__localeData__[normalizedLocale])}var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var asyncGenerator=function(){function AwaitValue(value){this.value=value}function AsyncGenerator(gen){var front,back;function send(key,arg){return new Promise((function(resolve,reject){var request={key:key,arg:arg,resolve:resolve,reject:reject,next:null};if(back){back=back.next=request}else{front=back=request;resume(key,arg)}}))}function resume(key,arg){try{var result=gen[key](arg);var value=result.value;if(value instanceof AwaitValue){Promise.resolve(value.value).then((function(arg){resume("next",arg)}),(function(arg){resume("throw",arg)}))}else{settle(result.done?"return":"normal",result.value)}}catch(err){settle("throw",err)}}function settle(type,value){switch(type){case"return":front.resolve({value:value,done:true});break;case"throw":front.reject(value);break;default:front.resolve({value:value,done:false});break}front=front.next;if(front){resume(front.key,front.arg)}else{back=null}}this._invoke=send;if(typeof gen.return!=="function"){this.return=undefined}}if(typeof Symbol==="function"&&Symbol.asyncIterator){AsyncGenerator.prototype[Symbol.asyncIterator]=function(){return this}}AsyncGenerator.prototype.next=function(arg){return this._invoke("next",arg)};AsyncGenerator.prototype.throw=function(arg){return this._invoke("throw",arg)};AsyncGenerator.prototype.return=function(arg){return this._invoke("return",arg)};return{wrap:function(fn){return function(){return new AsyncGenerator(fn.apply(this,arguments))}},await:function(value){return new AwaitValue(value)}}}();var classCallCheck=function(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}};var createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var defineProperty=function(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj};var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var inherits=function(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass};var objectWithoutProperties=function(obj,keys){var target={};for(var i in obj){if(keys.indexOf(i)>=0)continue;if(!Object.prototype.hasOwnProperty.call(obj,i))continue;target[i]=obj[i]}return target};var possibleConstructorReturn=function(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self};var toConsumableArray=function(arr){if(Array.isArray(arr)){for(var i=0,arr2=Array(arr.length);i<arr.length;i++)arr2[i]=arr[i];return arr2}else{return Array.from(arr)}};var bool=PropTypes.bool;var number=PropTypes.number;var string=PropTypes.string;var func=PropTypes.func;var object=PropTypes.object;var oneOf=PropTypes.oneOf;var shape=PropTypes.shape;var any=PropTypes.any;var oneOfType=PropTypes.oneOfType;var localeMatcher=oneOf(["best fit","lookup"]);var narrowShortLong=oneOf(["narrow","short","long"]);var numeric2digit=oneOf(["numeric","2-digit"]);var funcReq=func.isRequired;var intlConfigPropTypes={locale:string,timeZone:string,formats:object,messages:object,textComponent:any,defaultLocale:string,defaultFormats:object,onError:func};var intlFormatPropTypes={formatDate:funcReq,formatTime:funcReq,formatRelative:funcReq,formatNumber:funcReq,formatPlural:funcReq,formatMessage:funcReq,formatHTMLMessage:funcReq};var intlShape=shape(_extends({},intlConfigPropTypes,intlFormatPropTypes,{formatters:object,now:funcReq}));var messageDescriptorPropTypes={id:string.isRequired,description:oneOfType([string,object]),defaultMessage:string};var dateTimeFormatPropTypes={localeMatcher:localeMatcher,formatMatcher:oneOf(["basic","best fit"]),timeZone:string,hour12:bool,weekday:narrowShortLong,era:narrowShortLong,year:numeric2digit,month:oneOf(["numeric","2-digit","narrow","short","long"]),day:numeric2digit,hour:numeric2digit,minute:numeric2digit,second:numeric2digit,timeZoneName:oneOf(["short","long"])};var numberFormatPropTypes={localeMatcher:localeMatcher,style:oneOf(["decimal","currency","percent"]),currency:string,currencyDisplay:oneOf(["symbol","code","name"]),useGrouping:bool,minimumIntegerDigits:number,minimumFractionDigits:number,maximumFractionDigits:number,minimumSignificantDigits:number,maximumSignificantDigits:number};var relativeFormatPropTypes={style:oneOf(["best fit","numeric"]),units:oneOf(["second","minute","hour","day","month","year","second-short","minute-short","hour-short","day-short","month-short","year-short"])};var pluralFormatPropTypes={style:oneOf(["cardinal","ordinal"])};var intlConfigPropNames=Object.keys(intlConfigPropTypes);var ESCAPED_CHARS={"&":"&amp;",">":"&gt;","<":"&lt;",'"':"&quot;","'":"&#x27;"};var UNSAFE_CHARS_REGEX=/[&><"']/g;function escape(str){return(""+str).replace(UNSAFE_CHARS_REGEX,(function(match){return ESCAPED_CHARS[match]}))}function filterProps(props,whitelist){var defaults$$1=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};return whitelist.reduce((function(filtered,name){if(props.hasOwnProperty(name)){filtered[name]=props[name]}else if(defaults$$1.hasOwnProperty(name)){filtered[name]=defaults$$1[name]}return filtered}),{})}function invariantIntlContext(){var _ref=arguments.length>0&&arguments[0]!==undefined?arguments[0]:{},intl=_ref.intl;invariant(intl,"[React Intl] Could not find required `intl` object. "+"<IntlProvider> needs to exist in the component ancestry.")}function shallowEquals(objA,objB){if(objA===objB){return true}if((typeof objA==="undefined"?"undefined":_typeof(objA))!=="object"||objA===null||(typeof objB==="undefined"?"undefined":_typeof(objB))!=="object"||objB===null){return false}var keysA=Object.keys(objA);var keysB=Object.keys(objB);if(keysA.length!==keysB.length){return false}var bHasOwnProperty=Object.prototype.hasOwnProperty.bind(objB);for(var i=0;i<keysA.length;i++){if(!bHasOwnProperty(keysA[i])||objA[keysA[i]]!==objB[keysA[i]]){return false}}return true}function shouldIntlComponentUpdate(_ref2,nextProps,nextState){var props=_ref2.props,state=_ref2.state,_ref2$context=_ref2.context,context=_ref2$context===undefined?{}:_ref2$context;var nextContext=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var _context$intl=context.intl,intl=_context$intl===undefined?{}:_context$intl;var _nextContext$intl=nextContext.intl,nextIntl=_nextContext$intl===undefined?{}:_nextContext$intl;return!shallowEquals(nextProps,props)||!shallowEquals(nextState,state)||!(nextIntl===intl||shallowEquals(filterProps(nextIntl,intlConfigPropNames),filterProps(intl,intlConfigPropNames)))}function createError(message,exception){var eMsg=exception?"\n"+exception:"";return"[React Intl] "+message+eMsg}function defaultErrorHandler(error){if(false){}}function getDisplayName(Component$$1){return Component$$1.displayName||Component$$1.name||"Component"}function injectIntl(WrappedComponent){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};var _options$intlPropName=options.intlPropName,intlPropName=_options$intlPropName===undefined?"intl":_options$intlPropName,_options$withRef=options.withRef,withRef=_options$withRef===undefined?false:_options$withRef;var InjectIntl=function(_Component){inherits(InjectIntl,_Component);function InjectIntl(props,context){classCallCheck(this,InjectIntl);var _this=possibleConstructorReturn(this,(InjectIntl.__proto__||Object.getPrototypeOf(InjectIntl)).call(this,props,context));invariantIntlContext(context);return _this}createClass(InjectIntl,[{key:"getWrappedInstance",value:function getWrappedInstance(){invariant(withRef,"[React Intl] To access the wrapped instance, "+"the `{withRef: true}` option must be set when calling: "+"`injectIntl()`");return this._wrappedInstance}},{key:"render",value:function render(){var _this2=this;return React__default.createElement(WrappedComponent,_extends({},this.props,defineProperty({},intlPropName,this.context.intl),{ref:withRef?function(ref){return _this2._wrappedInstance=ref}:null}))}}]);return InjectIntl}(React.Component);InjectIntl.displayName="InjectIntl("+getDisplayName(WrappedComponent)+")";InjectIntl.contextTypes={intl:intlShape};InjectIntl.WrappedComponent=WrappedComponent;return hoistNonReactStatics(InjectIntl,WrappedComponent)}function defineMessages(messageDescriptors){return messageDescriptors}function resolveLocale(locales){return IntlMessageFormat.prototype._resolveLocale(locales)}function findPluralFunction(locale){return IntlMessageFormat.prototype._findPluralRuleFunction(locale)}var IntlPluralFormat=function IntlPluralFormat(locales){var options=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};classCallCheck(this,IntlPluralFormat);var useOrdinal=options.style==="ordinal";var pluralFn=findPluralFunction(resolveLocale(locales));this.format=function(value){return pluralFn(value,useOrdinal)}};var DATE_TIME_FORMAT_OPTIONS=Object.keys(dateTimeFormatPropTypes);var NUMBER_FORMAT_OPTIONS=Object.keys(numberFormatPropTypes);var RELATIVE_FORMAT_OPTIONS=Object.keys(relativeFormatPropTypes);var PLURAL_FORMAT_OPTIONS=Object.keys(pluralFormatPropTypes);var RELATIVE_FORMAT_THRESHOLDS={second:60,minute:60,hour:24,day:30,month:12};function updateRelativeFormatThresholds(newThresholds){var thresholds=IntlRelativeFormat.thresholds;thresholds.second=newThresholds.second;thresholds.minute=newThresholds.minute;thresholds.hour=newThresholds.hour;thresholds.day=newThresholds.day;thresholds.month=newThresholds.month;thresholds["second-short"]=newThresholds["second-short"];thresholds["minute-short"]=newThresholds["minute-short"];thresholds["hour-short"]=newThresholds["hour-short"];thresholds["day-short"]=newThresholds["day-short"];thresholds["month-short"]=newThresholds["month-short"]}function getNamedFormat(formats,type,name,onError){var format=formats&&formats[type]&&formats[type][name];if(format){return format}onError(createError("No "+type+" format named: "+name))}function formatDate(config,state,value){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var locale=config.locale,formats=config.formats,timeZone=config.timeZone;var format=options.format;var onError=config.onError||defaultErrorHandler;var date=new Date(value);var defaults$$1=_extends({},timeZone&&{timeZone:timeZone},format&&getNamedFormat(formats,"date",format,onError));var filteredOptions=filterProps(options,DATE_TIME_FORMAT_OPTIONS,defaults$$1);try{return state.getDateTimeFormat(locale,filteredOptions).format(date)}catch(e){onError(createError("Error formatting date.",e))}return String(date)}function formatTime(config,state,value){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var locale=config.locale,formats=config.formats,timeZone=config.timeZone;var format=options.format;var onError=config.onError||defaultErrorHandler;var date=new Date(value);var defaults$$1=_extends({},timeZone&&{timeZone:timeZone},format&&getNamedFormat(formats,"time",format,onError));var filteredOptions=filterProps(options,DATE_TIME_FORMAT_OPTIONS,defaults$$1);if(!filteredOptions.hour&&!filteredOptions.minute&&!filteredOptions.second){filteredOptions=_extends({},filteredOptions,{hour:"numeric",minute:"numeric"})}try{return state.getDateTimeFormat(locale,filteredOptions).format(date)}catch(e){onError(createError("Error formatting time.",e))}return String(date)}function formatRelative(config,state,value){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var locale=config.locale,formats=config.formats;var format=options.format;var onError=config.onError||defaultErrorHandler;var date=new Date(value);var now=new Date(options.now);var defaults$$1=format&&getNamedFormat(formats,"relative",format,onError);var filteredOptions=filterProps(options,RELATIVE_FORMAT_OPTIONS,defaults$$1);var oldThresholds=_extends({},IntlRelativeFormat.thresholds);updateRelativeFormatThresholds(RELATIVE_FORMAT_THRESHOLDS);try{return state.getRelativeFormat(locale,filteredOptions).format(date,{now:isFinite(now)?now:state.now()})}catch(e){onError(createError("Error formatting relative time.",e))}finally{updateRelativeFormatThresholds(oldThresholds)}return String(date)}function formatNumber(config,state,value){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var locale=config.locale,formats=config.formats;var format=options.format;var onError=config.onError||defaultErrorHandler;var defaults$$1=format&&getNamedFormat(formats,"number",format,onError);var filteredOptions=filterProps(options,NUMBER_FORMAT_OPTIONS,defaults$$1);try{return state.getNumberFormat(locale,filteredOptions).format(value)}catch(e){onError(createError("Error formatting number.",e))}return String(value)}function formatPlural(config,state,value){var options=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var locale=config.locale;var filteredOptions=filterProps(options,PLURAL_FORMAT_OPTIONS);var onError=config.onError||defaultErrorHandler;try{return state.getPluralFormat(locale,filteredOptions).format(value)}catch(e){onError(createError("Error formatting plural.",e))}return"other"}function formatMessage(config,state){var messageDescriptor=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var values=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var locale=config.locale,formats=config.formats,messages=config.messages,defaultLocale=config.defaultLocale,defaultFormats=config.defaultFormats;var id=messageDescriptor.id,defaultMessage=messageDescriptor.defaultMessage;if(false){}invariant(id,"[React Intl] An `id` must be provided to format a message.");var message=messages&&messages[id];var hasValues=Object.keys(values).length>0;if(!hasValues&&"production"==="production"){return message||defaultMessage||id}var formattedMessage=void 0;var onError=config.onError||defaultErrorHandler;if(message){try{var formatter=state.getMessageFormat(message,locale,formats);formattedMessage=formatter.format(values)}catch(e){onError(createError('Error formatting message: "'+id+'" for locale: "'+locale+'"'+(defaultMessage?", using default message as fallback.":""),e))}}else{if(!defaultMessage||locale&&locale.toLowerCase()!==defaultLocale.toLowerCase()){onError(createError('Missing message: "'+id+'" for locale: "'+locale+'"'+(defaultMessage?", using default message as fallback.":"")))}}if(!formattedMessage&&defaultMessage){try{var _formatter=state.getMessageFormat(defaultMessage,defaultLocale,defaultFormats);formattedMessage=_formatter.format(values)}catch(e){onError(createError('Error formatting the default message for: "'+id+'"',e))}}if(!formattedMessage){onError(createError('Cannot format message: "'+id+'", '+("using message "+(message||defaultMessage?"source":"id")+" as fallback.")))}return formattedMessage||message||defaultMessage||id}function formatHTMLMessage(config,state,messageDescriptor){var rawValues=arguments.length>3&&arguments[3]!==undefined?arguments[3]:{};var escapedValues=Object.keys(rawValues).reduce((function(escaped,name){var value=rawValues[name];escaped[name]=typeof value==="string"?escape(value):value;return escaped}),{});return formatMessage(config,state,messageDescriptor,escapedValues)}var format=Object.freeze({formatDate:formatDate,formatTime:formatTime,formatRelative:formatRelative,formatNumber:formatNumber,formatPlural:formatPlural,formatMessage:formatMessage,formatHTMLMessage:formatHTMLMessage});var intlConfigPropNames$1=Object.keys(intlConfigPropTypes);var intlFormatPropNames=Object.keys(intlFormatPropTypes);var defaultProps={formats:{},messages:{},timeZone:null,textComponent:"span",defaultLocale:"en",defaultFormats:{},onError:defaultErrorHandler};var IntlProvider=function(_Component){inherits(IntlProvider,_Component);function IntlProvider(props){var context=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};classCallCheck(this,IntlProvider);var _this=possibleConstructorReturn(this,(IntlProvider.__proto__||Object.getPrototypeOf(IntlProvider)).call(this,props,context));invariant(typeof Intl!=="undefined","[React Intl] The `Intl` APIs must be available in the runtime, "+"and do not appear to be built-in. An `Intl` polyfill should be loaded.\n"+"See: http://formatjs.io/guides/runtime-environments/");var intlContext=context.intl;var initialNow=void 0;if(isFinite(props.initialNow)){initialNow=Number(props.initialNow)}else{initialNow=intlContext?intlContext.now():Date.now()}var _ref=intlContext||{},_ref$formatters=_ref.formatters,formatters=_ref$formatters===undefined?{getDateTimeFormat:memoizeIntlConstructor(Intl.DateTimeFormat),getNumberFormat:memoizeIntlConstructor(Intl.NumberFormat),getMessageFormat:memoizeIntlConstructor(IntlMessageFormat),getRelativeFormat:memoizeIntlConstructor(IntlRelativeFormat),getPluralFormat:memoizeIntlConstructor(IntlPluralFormat)}:_ref$formatters;_this.state=_extends({},formatters,{now:function now(){return _this._didDisplay?Date.now():initialNow}});return _this}createClass(IntlProvider,[{key:"getConfig",value:function getConfig(){var intlContext=this.context.intl;var config=filterProps(this.props,intlConfigPropNames$1,intlContext);for(var propName in defaultProps){if(config[propName]===undefined){config[propName]=defaultProps[propName]}}if(!hasLocaleData(config.locale)){var _config=config,locale=_config.locale,defaultLocale=_config.defaultLocale,defaultFormats=_config.defaultFormats,onError=_config.onError;onError(createError('Missing locale data for locale: "'+locale+'". '+('Using default locale: "'+defaultLocale+'" as fallback.')));config=_extends({},config,{locale:defaultLocale,formats:defaultFormats,messages:defaultProps.messages})}return config}},{key:"getBoundFormatFns",value:function getBoundFormatFns(config,state){return intlFormatPropNames.reduce((function(boundFormatFns,name){boundFormatFns[name]=format[name].bind(null,config,state);return boundFormatFns}),{})}},{key:"getChildContext",value:function getChildContext(){var config=this.getConfig();var boundFormatFns=this.getBoundFormatFns(config,this.state);var _state=this.state,now=_state.now,formatters=objectWithoutProperties(_state,["now"]);return{intl:_extends({},config,boundFormatFns,{formatters:formatters,now:now})}}},{key:"shouldComponentUpdate",value:function shouldComponentUpdate(){for(var _len=arguments.length,next=Array(_len),_key=0;_key<_len;_key++){next[_key]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this].concat(next))}},{key:"componentDidMount",value:function componentDidMount(){this._didDisplay=true}},{key:"render",value:function render(){return React.Children.only(this.props.children)}}]);return IntlProvider}(React.Component);IntlProvider.displayName="IntlProvider";IntlProvider.contextTypes={intl:intlShape};IntlProvider.childContextTypes={intl:intlShape.isRequired};false?undefined:void 0;var FormattedDate=function(_Component){inherits(FormattedDate,_Component);function FormattedDate(props,context){classCallCheck(this,FormattedDate);var _this=possibleConstructorReturn(this,(FormattedDate.__proto__||Object.getPrototypeOf(FormattedDate)).call(this,props,context));invariantIntlContext(context);return _this}createClass(FormattedDate,[{key:"shouldComponentUpdate",value:function shouldComponentUpdate(){for(var _len=arguments.length,next=Array(_len),_key=0;_key<_len;_key++){next[_key]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this].concat(next))}},{key:"render",value:function render(){var _context$intl=this.context.intl,formatDate=_context$intl.formatDate,Text=_context$intl.textComponent;var _props=this.props,value=_props.value,children=_props.children;var formattedDate=formatDate(value,this.props);if(typeof children==="function"){return children(formattedDate)}return React__default.createElement(Text,null,formattedDate)}}]);return FormattedDate}(React.Component);FormattedDate.displayName="FormattedDate";FormattedDate.contextTypes={intl:intlShape};false?undefined:void 0;var FormattedTime=function(_Component){inherits(FormattedTime,_Component);function FormattedTime(props,context){classCallCheck(this,FormattedTime);var _this=possibleConstructorReturn(this,(FormattedTime.__proto__||Object.getPrototypeOf(FormattedTime)).call(this,props,context));invariantIntlContext(context);return _this}createClass(FormattedTime,[{key:"shouldComponentUpdate",value:function shouldComponentUpdate(){for(var _len=arguments.length,next=Array(_len),_key=0;_key<_len;_key++){next[_key]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this].concat(next))}},{key:"render",value:function render(){var _context$intl=this.context.intl,formatTime=_context$intl.formatTime,Text=_context$intl.textComponent;var _props=this.props,value=_props.value,children=_props.children;var formattedTime=formatTime(value,this.props);if(typeof children==="function"){return children(formattedTime)}return React__default.createElement(Text,null,formattedTime)}}]);return FormattedTime}(React.Component);FormattedTime.displayName="FormattedTime";FormattedTime.contextTypes={intl:intlShape};false?undefined:void 0;var SECOND=1e3;var MINUTE=1e3*60;var HOUR=1e3*60*60;var DAY=1e3*60*60*24;var MAX_TIMER_DELAY=2147483647;function selectUnits(delta){var absDelta=Math.abs(delta);if(absDelta<MINUTE){return"second"}if(absDelta<HOUR){return"minute"}if(absDelta<DAY){return"hour"}return"day"}function getUnitDelay(units){switch(units){case"second":return SECOND;case"minute":return MINUTE;case"hour":return HOUR;case"day":return DAY;default:return MAX_TIMER_DELAY}}function isSameDate(a,b){if(a===b){return true}var aTime=new Date(a).getTime();var bTime=new Date(b).getTime();return isFinite(aTime)&&isFinite(bTime)&&aTime===bTime}var FormattedRelative=function(_Component){inherits(FormattedRelative,_Component);function FormattedRelative(props,context){classCallCheck(this,FormattedRelative);var _this=possibleConstructorReturn(this,(FormattedRelative.__proto__||Object.getPrototypeOf(FormattedRelative)).call(this,props,context));invariantIntlContext(context);var now=isFinite(props.initialNow)?Number(props.initialNow):context.intl.now();_this.state={now:now};return _this}createClass(FormattedRelative,[{key:"scheduleNextUpdate",value:function scheduleNextUpdate(props,state){var _this2=this;clearTimeout(this._timer);var value=props.value,units=props.units,updateInterval=props.updateInterval;var time=new Date(value).getTime();if(!updateInterval||!isFinite(time)){return}var delta=time-state.now;var unitDelay=getUnitDelay(units||selectUnits(delta));var unitRemainder=Math.abs(delta%unitDelay);var delay=delta<0?Math.max(updateInterval,unitDelay-unitRemainder):Math.max(updateInterval,unitRemainder);this._timer=setTimeout((function(){_this2.setState({now:_this2.context.intl.now()})}),delay)}},{key:"componentDidMount",value:function componentDidMount(){this.scheduleNextUpdate(this.props,this.state)}},{key:"componentWillReceiveProps",value:function componentWillReceiveProps(_ref){var nextValue=_ref.value;if(!isSameDate(nextValue,this.props.value)){this.setState({now:this.context.intl.now()})}}},{key:"shouldComponentUpdate",value:function shouldComponentUpdate(){for(var _len=arguments.length,next=Array(_len),_key=0;_key<_len;_key++){next[_key]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this].concat(next))}},{key:"componentWillUpdate",value:function componentWillUpdate(nextProps,nextState){this.scheduleNextUpdate(nextProps,nextState)}},{key:"componentWillUnmount",value:function componentWillUnmount(){clearTimeout(this._timer)}},{key:"render",value:function render(){var _context$intl=this.context.intl,formatRelative=_context$intl.formatRelative,Text=_context$intl.textComponent;var _props=this.props,value=_props.value,children=_props.children;var formattedRelative=formatRelative(value,_extends({},this.props,this.state));if(typeof children==="function"){return children(formattedRelative)}return React__default.createElement(Text,null,formattedRelative)}}]);return FormattedRelative}(React.Component);FormattedRelative.displayName="FormattedRelative";FormattedRelative.contextTypes={intl:intlShape};FormattedRelative.defaultProps={updateInterval:1e3*10};false?undefined:void 0;var FormattedNumber=function(_Component){inherits(FormattedNumber,_Component);function FormattedNumber(props,context){classCallCheck(this,FormattedNumber);var _this=possibleConstructorReturn(this,(FormattedNumber.__proto__||Object.getPrototypeOf(FormattedNumber)).call(this,props,context));invariantIntlContext(context);return _this}createClass(FormattedNumber,[{key:"shouldComponentUpdate",value:function shouldComponentUpdate(){for(var _len=arguments.length,next=Array(_len),_key=0;_key<_len;_key++){next[_key]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this].concat(next))}},{key:"render",value:function render(){var _context$intl=this.context.intl,formatNumber=_context$intl.formatNumber,Text=_context$intl.textComponent;var _props=this.props,value=_props.value,children=_props.children;var formattedNumber=formatNumber(value,this.props);if(typeof children==="function"){return children(formattedNumber)}return React__default.createElement(Text,null,formattedNumber)}}]);return FormattedNumber}(React.Component);FormattedNumber.displayName="FormattedNumber";FormattedNumber.contextTypes={intl:intlShape};false?undefined:void 0;var FormattedPlural=function(_Component){inherits(FormattedPlural,_Component);function FormattedPlural(props,context){classCallCheck(this,FormattedPlural);var _this=possibleConstructorReturn(this,(FormattedPlural.__proto__||Object.getPrototypeOf(FormattedPlural)).call(this,props,context));invariantIntlContext(context);return _this}createClass(FormattedPlural,[{key:"shouldComponentUpdate",value:function shouldComponentUpdate(){for(var _len=arguments.length,next=Array(_len),_key=0;_key<_len;_key++){next[_key]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this].concat(next))}},{key:"render",value:function render(){var _context$intl=this.context.intl,formatPlural=_context$intl.formatPlural,Text=_context$intl.textComponent;var _props=this.props,value=_props.value,other=_props.other,children=_props.children;var pluralCategory=formatPlural(value,this.props);var formattedPlural=this.props[pluralCategory]||other;if(typeof children==="function"){return children(formattedPlural)}return React__default.createElement(Text,null,formattedPlural)}}]);return FormattedPlural}(React.Component);FormattedPlural.displayName="FormattedPlural";FormattedPlural.contextTypes={intl:intlShape};FormattedPlural.defaultProps={style:"cardinal"};false?undefined:void 0;var defaultFormatMessage=function defaultFormatMessage(descriptor,values){if(false){}return formatMessage({},{getMessageFormat:memoizeIntlConstructor(IntlMessageFormat)},descriptor,values)};var FormattedMessage=function(_Component){inherits(FormattedMessage,_Component);function FormattedMessage(props,context){classCallCheck(this,FormattedMessage);var _this=possibleConstructorReturn(this,(FormattedMessage.__proto__||Object.getPrototypeOf(FormattedMessage)).call(this,props,context));if(!props.defaultMessage){invariantIntlContext(context)}return _this}createClass(FormattedMessage,[{key:"shouldComponentUpdate",value:function shouldComponentUpdate(nextProps){var values=this.props.values;var nextValues=nextProps.values;if(!shallowEquals(nextValues,values)){return true}var nextPropsToCheck=_extends({},nextProps,{values:values});for(var _len=arguments.length,next=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){next[_key-1]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this,nextPropsToCheck].concat(next))}},{key:"render",value:function render(){var _ref=this.context.intl||{},_ref$formatMessage=_ref.formatMessage,formatMessage$$1=_ref$formatMessage===undefined?defaultFormatMessage:_ref$formatMessage,_ref$textComponent=_ref.textComponent,Text=_ref$textComponent===undefined?"span":_ref$textComponent;var _props=this.props,id=_props.id,description=_props.description,defaultMessage=_props.defaultMessage,values=_props.values,_props$tagName=_props.tagName,Component$$1=_props$tagName===undefined?Text:_props$tagName,children=_props.children;var tokenDelimiter=void 0;var tokenizedValues=void 0;var elements=void 0;var hasValues=values&&Object.keys(values).length>0;if(hasValues){var uid=Math.floor(Math.random()*1099511627776).toString(16);var generateToken=function(){var counter=0;return function(){return"ELEMENT-"+uid+"-"+(counter+=1)}}();tokenDelimiter="@__"+uid+"__@";tokenizedValues={};elements={};Object.keys(values).forEach((function(name){var value=values[name];if(React.isValidElement(value)){var token=generateToken();tokenizedValues[name]=tokenDelimiter+token+tokenDelimiter;elements[token]=value}else{tokenizedValues[name]=value}}))}var descriptor={id:id,description:description,defaultMessage:defaultMessage};var formattedMessage=formatMessage$$1(descriptor,tokenizedValues||values);var nodes=void 0;var hasElements=elements&&Object.keys(elements).length>0;if(hasElements){nodes=formattedMessage.split(tokenDelimiter).filter((function(part){return!!part})).map((function(part){return elements[part]||part}))}else{nodes=[formattedMessage]}if(typeof children==="function"){return children.apply(undefined,toConsumableArray(nodes))}return React.createElement.apply(undefined,[Component$$1,null].concat(toConsumableArray(nodes)))}}]);return FormattedMessage}(React.Component);FormattedMessage.displayName="FormattedMessage";FormattedMessage.contextTypes={intl:intlShape};FormattedMessage.defaultProps={values:{}};false?undefined:void 0;var FormattedHTMLMessage=function(_Component){inherits(FormattedHTMLMessage,_Component);function FormattedHTMLMessage(props,context){classCallCheck(this,FormattedHTMLMessage);var _this=possibleConstructorReturn(this,(FormattedHTMLMessage.__proto__||Object.getPrototypeOf(FormattedHTMLMessage)).call(this,props,context));invariantIntlContext(context);return _this}createClass(FormattedHTMLMessage,[{key:"shouldComponentUpdate",value:function shouldComponentUpdate(nextProps){var values=this.props.values;var nextValues=nextProps.values;if(!shallowEquals(nextValues,values)){return true}var nextPropsToCheck=_extends({},nextProps,{values:values});for(var _len=arguments.length,next=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){next[_key-1]=arguments[_key]}return shouldIntlComponentUpdate.apply(undefined,[this,nextPropsToCheck].concat(next))}},{key:"render",value:function render(){var _context$intl=this.context.intl,formatHTMLMessage=_context$intl.formatHTMLMessage,Text=_context$intl.textComponent;var _props=this.props,id=_props.id,description=_props.description,defaultMessage=_props.defaultMessage,rawValues=_props.values,_props$tagName=_props.tagName,Component$$1=_props$tagName===undefined?Text:_props$tagName,children=_props.children;var descriptor={id:id,description:description,defaultMessage:defaultMessage};var formattedHTMLMessage=formatHTMLMessage(descriptor,rawValues);if(typeof children==="function"){return children(formattedHTMLMessage)}var html={__html:formattedHTMLMessage};return React__default.createElement(Component$$1,{dangerouslySetInnerHTML:html})}}]);return FormattedHTMLMessage}(React.Component);FormattedHTMLMessage.displayName="FormattedHTMLMessage";FormattedHTMLMessage.contextTypes={intl:intlShape};FormattedHTMLMessage.defaultProps={values:{}};false?undefined:void 0;addLocaleData(defaultLocaleData);addLocaleData(allLocaleData);exports.addLocaleData=addLocaleData;exports.intlShape=intlShape;exports.injectIntl=injectIntl;exports.defineMessages=defineMessages;exports.IntlProvider=IntlProvider;exports.FormattedDate=FormattedDate;exports.FormattedTime=FormattedTime;exports.FormattedRelative=FormattedRelative;exports.FormattedNumber=FormattedNumber;exports.FormattedPlural=FormattedPlural;exports.FormattedMessage=FormattedMessage;exports.FormattedHTMLMessage=FormattedHTMLMessage},507:function(module,exports,__webpack_require__){"use strict";var IntlMessageFormat=__webpack_require__(656)["default"];__webpack_require__(663);exports=module.exports=IntlMessageFormat;exports["default"]=exports},508:function(module,exports,__webpack_require__){"use strict";exports.extend=extend;var hop=Object.prototype.hasOwnProperty;function extend(obj){var sources=Array.prototype.slice.call(arguments,1),i,len,source,key;for(i=0,len=sources.length;i<len;i+=1){source=sources[i];if(!source){continue}for(key in source){if(hop.call(source,key)){obj[key]=source[key]}}}return obj}exports.hop=hop},515:function(module,exports,__webpack_require__){var PriorityQueue=__webpack_require__(516);module.exports=dijkstra;var DEFAULT_WEIGHT_FUNC=()=>1;function dijkstra(g,source,weightFn,edgeFn){return runDijkstra(g,String(source),weightFn||DEFAULT_WEIGHT_FUNC,edgeFn||function(v){return g.outEdges(v)})}function runDijkstra(g,source,weightFn,edgeFn){var results={};var pq=new PriorityQueue;var v,vEntry;var updateNeighbors=function(edge){var w=edge.v!==v?edge.v:edge.w;var wEntry=results[w];var weight=weightFn(edge);var distance=vEntry.distance+weight;if(weight<0){throw new Error("dijkstra does not allow negative edge weights. "+"Bad edge: "+edge+" Weight: "+weight)}if(distance<wEntry.distance){wEntry.distance=distance;wEntry.predecessor=v;pq.decrease(w,distance)}};g.nodes().forEach((function(v){var distance=v===source?0:Number.POSITIVE_INFINITY;results[v]={distance:distance};pq.add(v,distance)}));while(pq.size()>0){v=pq.removeMin();vEntry=results[v];if(vEntry.distance===Number.POSITIVE_INFINITY){break}edgeFn(v).forEach(updateNeighbors)}return results}},516:function(module,exports){function _defineProperty(e,r,t){return(r=_toPropertyKey(r))in e?Object.defineProperty(e,r,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[r]=t,e}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return"symbol"==typeof i?i:i+""}function _toPrimitive(t,r){if("object"!=typeof t||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===r?String:Number)(t)}class PriorityQueue{constructor(){_defineProperty(this,"_arr",[]);_defineProperty(this,"_keyIndices",{})}size(){return this._arr.length}keys(){return this._arr.map((function(x){return x.key}))}has(key){return Object.hasOwn(this._keyIndices,key)}priority(key){var index=this._keyIndices[key];if(index!==undefined){return this._arr[index].priority}}min(){if(this.size()===0){throw new Error("Queue underflow")}return this._arr[0].key}add(key,priority){var keyIndices=this._keyIndices;key=String(key);if(!Object.hasOwn(keyIndices,key)){var arr=this._arr;var index=arr.length;keyIndices[key]=index;arr.push({key:key,priority:priority});this._decrease(index);return true}return false}removeMin(){this._swap(0,this._arr.length-1);var min=this._arr.pop();delete this._keyIndices[min.key];this._heapify(0);return min.key}decrease(key,priority){var index=this._keyIndices[key];if(priority>this._arr[index].priority){throw new Error("New priority is greater than current priority. "+"Key: "+key+" Old: "+this._arr[index].priority+" New: "+priority)}this._arr[index].priority=priority;this._decrease(index)}_heapify(i){var arr=this._arr;var l=2*i;var r=l+1;var largest=i;if(l<arr.length){largest=arr[l].priority<arr[largest].priority?l:largest;if(r<arr.length){largest=arr[r].priority<arr[largest].priority?r:largest}if(largest!==i){this._swap(i,largest);this._heapify(largest)}}}_decrease(index){var arr=this._arr;var priority=arr[index].priority;var parent;while(index!==0){parent=index>>1;if(arr[parent].priority<priority){break}this._swap(index,parent);index=parent}}_swap(i,j){var arr=this._arr;var keyIndices=this._keyIndices;var origArrI=arr[i];var origArrJ=arr[j];arr[i]=origArrJ;arr[j]=origArrI;keyIndices[origArrJ.key]=i;keyIndices[origArrI.key]=j}}module.exports=PriorityQueue},517:function(module,exports){module.exports=tarjan;function tarjan(g){var index=0;var stack=[];var visited={};var results=[];function dfs(v){var entry=visited[v]={onStack:true,lowlink:index,index:index++};stack.push(v);g.successors(v).forEach((function(w){if(!Object.hasOwn(visited,w)){dfs(w);entry.lowlink=Math.min(entry.lowlink,visited[w].lowlink)}else if(visited[w].onStack){entry.lowlink=Math.min(entry.lowlink,visited[w].index)}}));if(entry.lowlink===entry.index){var cmpt=[];var w;do{w=stack.pop();visited[w].onStack=false;cmpt.push(w)}while(v!==w);results.push(cmpt)}}g.nodes().forEach((function(v){if(!Object.hasOwn(visited,v)){dfs(v)}}));return results}},518:function(module,exports){function topsort(g){var visited={};var stack={};var results=[];function visit(node){if(Object.hasOwn(stack,node)){throw new CycleException}if(!Object.hasOwn(visited,node)){stack[node]=true;visited[node]=true;g.predecessors(node).forEach(visit);delete stack[node];results.push(node)}}g.sinks().forEach(visit);if(Object.keys(visited).length!==g.nodeCount()){throw new CycleException}return results}class CycleException extends Error{constructor(){super(...arguments)}}module.exports=topsort;topsort.CycleException=CycleException},519:function(module,exports){module.exports=dfs;function dfs(g,vs,order){if(!Array.isArray(vs)){vs=[vs]}var navigation=g.isDirected()?v=>g.successors(v):v=>g.neighbors(v);var orderFunc=order==="post"?postOrderDfs:preOrderDfs;var acc=[];var visited={};vs.forEach(v=>{if(!g.hasNode(v)){throw new Error("Graph does not have node: "+v)}orderFunc(v,navigation,visited,acc)});return acc}function postOrderDfs(v,navigation,visited,acc){var stack=[[v,false]];while(stack.length>0){var curr=stack.pop();if(curr[1]){acc.push(curr[0])}else{if(!Object.hasOwn(visited,curr[0])){visited[curr[0]]=true;stack.push([curr[0],true]);forEachRight(navigation(curr[0]),w=>stack.push([w,false]))}}}}function preOrderDfs(v,navigation,visited,acc){var stack=[v];while(stack.length>0){var curr=stack.pop();if(!Object.hasOwn(visited,curr)){visited[curr]=true;acc.push(curr);forEachRight(navigation(curr),w=>stack.push(w))}}}function forEachRight(array,iteratee){var length=array.length;while(length--){iteratee(array[length],length,array)}return array}},520:function(module,exports,__webpack_require__){"use strict";var Graph=__webpack_require__(484).Graph;var slack=__webpack_require__(494).slack;module.exports=feasibleTree;function feasibleTree(g){var t=new Graph({directed:false});var start=g.nodes()[0];var size=g.nodeCount();t.setNode(start,{});var edge,delta;while(tightTree(t,g)<size){edge=findMinSlackEdge(t,g);delta=t.hasNode(edge.v)?slack(g,edge):-slack(g,edge);shiftRanks(t,g,delta)}return t}function tightTree(t,g){function dfs(v){g.nodeEdges(v).forEach(e=>{var edgeV=e.v,w=v===edgeV?e.w:edgeV;if(!t.hasNode(w)&&!slack(g,e)){t.setNode(w,{});t.setEdge(v,w,{});dfs(w)}})}t.nodes().forEach(dfs);return t.nodeCount()}function findMinSlackEdge(t,g){const edges=g.edges();return edges.reduce((acc,edge)=>{let edgeSlack=Number.POSITIVE_INFINITY;if(t.hasNode(edge.v)!==t.hasNode(edge.w)){edgeSlack=slack(g,edge)}if(edgeSlack<acc[0]){return[edgeSlack,edge]}return acc},[Number.POSITIVE_INFINITY,null])[1]}function shiftRanks(t,g,delta){t.nodes().forEach(v=>g.node(v).rank+=delta)}},656:function(module,exports,__webpack_require__){"use strict";var src$core$$=__webpack_require__(657),src$en$$=__webpack_require__(662);src$core$$["default"].__addLocaleData(src$en$$["default"]);src$core$$["default"].defaultLocale="en";exports["default"]=src$core$$["default"]},657:function(module,exports,__webpack_require__){"use strict";var src$utils$$=__webpack_require__(508),src$es5$$=__webpack_require__(658),src$compiler$$=__webpack_require__(659),intl$messageformat$parser$$=__webpack_require__(660);exports["default"]=MessageFormat;function MessageFormat(message,locales,formats){var ast=typeof message==="string"?MessageFormat.__parse(message):message;if(!(ast&&ast.type==="messageFormatPattern")){throw new TypeError("A message must be provided as a String or AST.")}formats=this._mergeFormats(MessageFormat.formats,formats);src$es5$$.defineProperty(this,"_locale",{value:this._resolveLocale(locales)});var pluralFn=this._findPluralRuleFunction(this._locale);var pattern=this._compilePattern(ast,locales,formats,pluralFn);var messageFormat=this;this.format=function(values){try{return messageFormat._format(pattern,values)}catch(e){if(e.variableId){throw new Error("The intl string context variable '"+e.variableId+"'"+" was not provided to the string '"+message+"'")}else{throw e}}}}src$es5$$.defineProperty(MessageFormat,"formats",{enumerable:true,value:{number:{currency:{style:"currency"},percent:{style:"percent"}},date:{short:{month:"numeric",day:"numeric",year:"2-digit"},medium:{month:"short",day:"numeric",year:"numeric"},long:{month:"long",day:"numeric",year:"numeric"},full:{weekday:"long",month:"long",day:"numeric",year:"numeric"}},time:{short:{hour:"numeric",minute:"numeric"},medium:{hour:"numeric",minute:"numeric",second:"numeric"},long:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"},full:{hour:"numeric",minute:"numeric",second:"numeric",timeZoneName:"short"}}}});src$es5$$.defineProperty(MessageFormat,"__localeData__",{value:src$es5$$.objCreate(null)});src$es5$$.defineProperty(MessageFormat,"__addLocaleData",{value:function(data){if(!(data&&data.locale)){throw new Error("Locale data provided to IntlMessageFormat is missing a "+"`locale` property")}MessageFormat.__localeData__[data.locale.toLowerCase()]=data}});src$es5$$.defineProperty(MessageFormat,"__parse",{value:intl$messageformat$parser$$["default"].parse});src$es5$$.defineProperty(MessageFormat,"defaultLocale",{enumerable:true,writable:true,value:undefined});MessageFormat.prototype.resolvedOptions=function(){return{locale:this._locale}};MessageFormat.prototype._compilePattern=function(ast,locales,formats,pluralFn){var compiler=new src$compiler$$["default"](locales,formats,pluralFn);return compiler.compile(ast)};MessageFormat.prototype._findPluralRuleFunction=function(locale){var localeData=MessageFormat.__localeData__;var data=localeData[locale.toLowerCase()];while(data){if(data.pluralRuleFunction){return data.pluralRuleFunction}data=data.parentLocale&&localeData[data.parentLocale.toLowerCase()]}throw new Error("Locale data added to IntlMessageFormat is missing a "+"`pluralRuleFunction` for :"+locale)};MessageFormat.prototype._format=function(pattern,values){var result="",i,len,part,id,value,err;for(i=0,len=pattern.length;i<len;i+=1){part=pattern[i];if(typeof part==="string"){result+=part;continue}id=part.id;if(!(values&&src$utils$$.hop.call(values,id))){err=new Error("A value must be provided for: "+id);err.variableId=id;throw err}value=values[id];if(part.options){result+=this._format(part.getOption(value),values)}else{result+=part.format(value)}}return result};MessageFormat.prototype._mergeFormats=function(defaults,formats){var mergedFormats={},type,mergedType;for(type in defaults){if(!src$utils$$.hop.call(defaults,type)){continue}mergedFormats[type]=mergedType=src$es5$$.objCreate(defaults[type]);if(formats&&src$utils$$.hop.call(formats,type)){src$utils$$.extend(mergedType,formats[type])}}return mergedFormats};MessageFormat.prototype._resolveLocale=function(locales){if(typeof locales==="string"){locales=[locales]}locales=(locales||[]).concat(MessageFormat.defaultLocale);var localeData=MessageFormat.__localeData__;var i,len,localeParts,data;for(i=0,len=locales.length;i<len;i+=1){localeParts=locales[i].toLowerCase().split("-");while(localeParts.length){data=localeData[localeParts.join("-")];if(data){return data.locale}localeParts.pop()}}var defaultLocale=locales.pop();throw new Error("No locale data has been added to IntlMessageFormat for: "+locales.join(", ")+", or the default locale: "+defaultLocale)}},658:function(module,exports,__webpack_require__){"use strict";var src$utils$$=__webpack_require__(508);var realDefineProp=function(){try{return!!Object.defineProperty({},"a",{})}catch(e){return false}}();var es3=!realDefineProp&&!Object.prototype.__defineGetter__;var defineProperty=realDefineProp?Object.defineProperty:function(obj,name,desc){if("get"in desc&&obj.__defineGetter__){obj.__defineGetter__(name,desc.get)}else if(!src$utils$$.hop.call(obj,name)||"value"in desc){obj[name]=desc.value}};var objCreate=Object.create||function(proto,props){var obj,k;function F(){}F.prototype=proto;obj=new F;for(k in props){if(src$utils$$.hop.call(props,k)){defineProperty(obj,k,props[k])}}return obj};exports.defineProperty=defineProperty,exports.objCreate=objCreate},659:function(module,exports,__webpack_require__){"use strict";exports["default"]=Compiler;function Compiler(locales,formats,pluralFn){this.locales=locales;this.formats=formats;this.pluralFn=pluralFn}Compiler.prototype.compile=function(ast){this.pluralStack=[];this.currentPlural=null;this.pluralNumberFormat=null;return this.compileMessage(ast)};Compiler.prototype.compileMessage=function(ast){if(!(ast&&ast.type==="messageFormatPattern")){throw new Error('Message AST is not of type: "messageFormatPattern"')}var elements=ast.elements,pattern=[];var i,len,element;for(i=0,len=elements.length;i<len;i+=1){element=elements[i];switch(element.type){case"messageTextElement":pattern.push(this.compileMessageText(element));break;case"argumentElement":pattern.push(this.compileArgument(element));break;default:throw new Error("Message element does not have a valid type")}}return pattern};Compiler.prototype.compileMessageText=function(element){if(this.currentPlural&&/(^|[^\\])#/g.test(element.value)){if(!this.pluralNumberFormat){this.pluralNumberFormat=new Intl.NumberFormat(this.locales)}return new PluralOffsetString(this.currentPlural.id,this.currentPlural.format.offset,this.pluralNumberFormat,element.value)}return element.value.replace(/\\#/g,"#")};Compiler.prototype.compileArgument=function(element){var format=element.format;if(!format){return new StringFormat(element.id)}var formats=this.formats,locales=this.locales,pluralFn=this.pluralFn,options;switch(format.type){case"numberFormat":options=formats.number[format.style];return{id:element.id,format:new Intl.NumberFormat(locales,options).format};case"dateFormat":options=formats.date[format.style];return{id:element.id,format:new Intl.DateTimeFormat(locales,options).format};case"timeFormat":options=formats.time[format.style];return{id:element.id,format:new Intl.DateTimeFormat(locales,options).format};case"pluralFormat":options=this.compileOptions(element);return new PluralFormat(element.id,format.ordinal,format.offset,options,pluralFn);case"selectFormat":options=this.compileOptions(element);return new SelectFormat(element.id,options);default:throw new Error("Message element does not have a valid format type")}};Compiler.prototype.compileOptions=function(element){var format=element.format,options=format.options,optionsHash={};this.pluralStack.push(this.currentPlural);this.currentPlural=format.type==="pluralFormat"?element:null;var i,len,option;for(i=0,len=options.length;i<len;i+=1){option=options[i];optionsHash[option.selector]=this.compileMessage(option.value)}this.currentPlural=this.pluralStack.pop();return optionsHash};function StringFormat(id){this.id=id}StringFormat.prototype.format=function(value){if(!value&&typeof value!=="number"){return""}return typeof value==="string"?value:String(value)};function PluralFormat(id,useOrdinal,offset,options,pluralFn){this.id=id;this.useOrdinal=useOrdinal;this.offset=offset;this.options=options;this.pluralFn=pluralFn}PluralFormat.prototype.getOption=function(value){var options=this.options;var option=options["="+value]||options[this.pluralFn(value-this.offset,this.useOrdinal)];return option||options.other};function PluralOffsetString(id,offset,numberFormat,string){this.id=id;this.offset=offset;this.numberFormat=numberFormat;this.string=string}PluralOffsetString.prototype.format=function(value){var number=this.numberFormat.format(value-this.offset);return this.string.replace(/(^|[^\\])#/g,"$1"+number).replace(/\\#/g,"#")};function SelectFormat(id,options){this.id=id;this.options=options}SelectFormat.prototype.getOption=function(value){var options=this.options;return options[value]||options.other}},660:function(module,exports,__webpack_require__){"use strict";exports=module.exports=__webpack_require__(661)["default"];exports["default"]=exports},661:function(module,exports,__webpack_require__){"use strict";exports["default"]=function(){"use strict";function peg$subclass(child,parent){function ctor(){this.constructor=child}ctor.prototype=parent.prototype;child.prototype=new ctor}function peg$SyntaxError(message,expected,found,location){this.message=message;this.expected=expected;this.found=found;this.location=location;this.name="SyntaxError";if(typeof Error.captureStackTrace==="function"){Error.captureStackTrace(this,peg$SyntaxError)}}peg$subclass(peg$SyntaxError,Error);function peg$parse(input){var options=arguments.length>1?arguments[1]:{},parser=this,peg$FAILED={},peg$startRuleFunctions={start:peg$parsestart},peg$startRuleFunction=peg$parsestart,peg$c0=function(elements){return{type:"messageFormatPattern",elements:elements,location:location()}},peg$c1=function(text){var string="",i,j,outerLen,inner,innerLen;for(i=0,outerLen=text.length;i<outerLen;i+=1){inner=text[i];for(j=0,innerLen=inner.length;j<innerLen;j+=1){string+=inner[j]}}return string},peg$c2=function(messageText){return{type:"messageTextElement",value:messageText,location:location()}},peg$c3=/^[^ \t\n\r,.+={}#]/,peg$c4={type:"class",value:"[^ \\t\\n\\r,.+={}#]",description:"[^ \\t\\n\\r,.+={}#]"},peg$c5="{",peg$c6={type:"literal",value:"{",description:'"{"'},peg$c7=",",peg$c8={type:"literal",value:",",description:'","'},peg$c9="}",peg$c10={type:"literal",value:"}",description:'"}"'},peg$c11=function(id,format){return{type:"argumentElement",id:id,format:format&&format[2],location:location()}},peg$c12="number",peg$c13={type:"literal",value:"number",description:'"number"'},peg$c14="date",peg$c15={type:"literal",value:"date",description:'"date"'},peg$c16="time",peg$c17={type:"literal",value:"time",description:'"time"'},peg$c18=function(type,style){return{type:type+"Format",style:style&&style[2],location:location()}},peg$c19="plural",peg$c20={type:"literal",value:"plural",description:'"plural"'},peg$c21=function(pluralStyle){return{type:pluralStyle.type,ordinal:false,offset:pluralStyle.offset||0,options:pluralStyle.options,location:location()}},peg$c22="selectordinal",peg$c23={type:"literal",value:"selectordinal",description:'"selectordinal"'},peg$c24=function(pluralStyle){return{type:pluralStyle.type,ordinal:true,offset:pluralStyle.offset||0,options:pluralStyle.options,location:location()}},peg$c25="select",peg$c26={type:"literal",value:"select",description:'"select"'},peg$c27=function(options){return{type:"selectFormat",options:options,location:location()}},peg$c28="=",peg$c29={type:"literal",value:"=",description:'"="'},peg$c30=function(selector,pattern){return{type:"optionalFormatPattern",selector:selector,value:pattern,location:location()}},peg$c31="offset:",peg$c32={type:"literal",value:"offset:",description:'"offset:"'},peg$c33=function(number){return number},peg$c34=function(offset,options){return{type:"pluralFormat",offset:offset,options:options,location:location()}},peg$c35={type:"other",description:"whitespace"},peg$c36=/^[ \t\n\r]/,peg$c37={type:"class",value:"[ \\t\\n\\r]",description:"[ \\t\\n\\r]"},peg$c38={type:"other",description:"optionalWhitespace"},peg$c39=/^[0-9]/,peg$c40={type:"class",value:"[0-9]",description:"[0-9]"},peg$c41=/^[0-9a-f]/i,peg$c42={type:"class",value:"[0-9a-f]i",description:"[0-9a-f]i"},peg$c43="0",peg$c44={type:"literal",value:"0",description:'"0"'},peg$c45=/^[1-9]/,peg$c46={type:"class",value:"[1-9]",description:"[1-9]"},peg$c47=function(digits){return parseInt(digits,10)},peg$c48=/^[^{}\\\0-\x1F \t\n\r]/,peg$c49={type:"class",value:"[^{}\\\\\\0-\\x1F\\x7f \\t\\n\\r]",description:"[^{}\\\\\\0-\\x1F\\x7f \\t\\n\\r]"},peg$c50="\\\\",peg$c51={type:"literal",value:"\\\\",description:'"\\\\\\\\"'},peg$c52=function(){return"\\"},peg$c53="\\#",peg$c54={type:"literal",value:"\\#",description:'"\\\\#"'},peg$c55=function(){return"\\#"},peg$c56="\\{",peg$c57={type:"literal",value:"\\{",description:'"\\\\{"'},peg$c58=function(){return"{"},peg$c59="\\}",peg$c60={type:"literal",value:"\\}",description:'"\\\\}"'},peg$c61=function(){return"}"},peg$c62="\\u",peg$c63={type:"literal",value:"\\u",description:'"\\\\u"'},peg$c64=function(digits){return String.fromCharCode(parseInt(digits,16))},peg$c65=function(chars){return chars.join("")},peg$currPos=0,peg$savedPos=0,peg$posDetailsCache=[{line:1,column:1,seenCR:false}],peg$maxFailPos=0,peg$maxFailExpected=[],peg$silentFails=0,peg$result;if("startRule"in options){if(!(options.startRule in peg$startRuleFunctions)){throw new Error("Can't start parsing from rule \""+options.startRule+'".')}peg$startRuleFunction=peg$startRuleFunctions[options.startRule]}function text(){return input.substring(peg$savedPos,peg$currPos)}function location(){return peg$computeLocation(peg$savedPos,peg$currPos)}function expected(description){throw peg$buildException(null,[{type:"other",description:description}],input.substring(peg$savedPos,peg$currPos),peg$computeLocation(peg$savedPos,peg$currPos))}function error(message){throw peg$buildException(message,null,input.substring(peg$savedPos,peg$currPos),peg$computeLocation(peg$savedPos,peg$currPos))}function peg$computePosDetails(pos){var details=peg$posDetailsCache[pos],p,ch;if(details){return details}else{p=pos-1;while(!peg$posDetailsCache[p]){p--}details=peg$posDetailsCache[p];details={line:details.line,column:details.column,seenCR:details.seenCR};while(p<pos){ch=input.charAt(p);if(ch==="\n"){if(!details.seenCR){details.line++}details.column=1;details.seenCR=false}else if(ch==="\r"||ch==="\u2028"||ch==="\u2029"){details.line++;details.column=1;details.seenCR=true}else{details.column++;details.seenCR=false}p++}peg$posDetailsCache[pos]=details;return details}}function peg$computeLocation(startPos,endPos){var startPosDetails=peg$computePosDetails(startPos),endPosDetails=peg$computePosDetails(endPos);return{start:{offset:startPos,line:startPosDetails.line,column:startPosDetails.column},end:{offset:endPos,line:endPosDetails.line,column:endPosDetails.column}}}function peg$fail(expected){if(peg$currPos<peg$maxFailPos){return}if(peg$currPos>peg$maxFailPos){peg$maxFailPos=peg$currPos;peg$maxFailExpected=[]}peg$maxFailExpected.push(expected)}function peg$buildException(message,expected,found,location){function cleanupExpected(expected){var i=1;expected.sort((function(a,b){if(a.description<b.description){return-1}else if(a.description>b.description){return 1}else{return 0}}));while(i<expected.length){if(expected[i-1]===expected[i]){expected.splice(i,1)}else{i++}}}function buildMessage(expected,found){function stringEscape(s){function hex(ch){return ch.charCodeAt(0).toString(16).toUpperCase()}return s.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\x08/g,"\\b").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\f/g,"\\f").replace(/\r/g,"\\r").replace(/[\x00-\x07\x0B\x0E\x0F]/g,(function(ch){return"\\x0"+hex(ch)})).replace(/[\x10-\x1F\x80-\xFF]/g,(function(ch){return"\\x"+hex(ch)})).replace(/[\u0100-\u0FFF]/g,(function(ch){return"\\u0"+hex(ch)})).replace(/[\u1000-\uFFFF]/g,(function(ch){return"\\u"+hex(ch)}))}var expectedDescs=new Array(expected.length),expectedDesc,foundDesc,i;for(i=0;i<expected.length;i++){expectedDescs[i]=expected[i].description}expectedDesc=expected.length>1?expectedDescs.slice(0,-1).join(", ")+" or "+expectedDescs[expected.length-1]:expectedDescs[0];foundDesc=found?'"'+stringEscape(found)+'"':"end of input";return"Expected "+expectedDesc+" but "+foundDesc+" found."}if(expected!==null){cleanupExpected(expected)}return new peg$SyntaxError(message!==null?message:buildMessage(expected,found),expected,found,location)}function peg$parsestart(){var s0;s0=peg$parsemessageFormatPattern();return s0}function peg$parsemessageFormatPattern(){var s0,s1,s2;s0=peg$currPos;s1=[];s2=peg$parsemessageFormatElement();while(s2!==peg$FAILED){s1.push(s2);s2=peg$parsemessageFormatElement()}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c0(s1)}s0=s1;return s0}function peg$parsemessageFormatElement(){var s0;s0=peg$parsemessageTextElement();if(s0===peg$FAILED){s0=peg$parseargumentElement()}return s0}function peg$parsemessageText(){var s0,s1,s2,s3,s4,s5;s0=peg$currPos;s1=[];s2=peg$currPos;s3=peg$parse_();if(s3!==peg$FAILED){s4=peg$parsechars();if(s4!==peg$FAILED){s5=peg$parse_();if(s5!==peg$FAILED){s3=[s3,s4,s5];s2=s3}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}if(s2!==peg$FAILED){while(s2!==peg$FAILED){s1.push(s2);s2=peg$currPos;s3=peg$parse_();if(s3!==peg$FAILED){s4=peg$parsechars();if(s4!==peg$FAILED){s5=peg$parse_();if(s5!==peg$FAILED){s3=[s3,s4,s5];s2=s3}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}}}else{s1=peg$FAILED}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c1(s1)}s0=s1;if(s0===peg$FAILED){s0=peg$currPos;s1=peg$parsews();if(s1!==peg$FAILED){s0=input.substring(s0,peg$currPos)}else{s0=s1}}return s0}function peg$parsemessageTextElement(){var s0,s1;s0=peg$currPos;s1=peg$parsemessageText();if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c2(s1)}s0=s1;return s0}function peg$parseargument(){var s0,s1,s2;s0=peg$parsenumber();if(s0===peg$FAILED){s0=peg$currPos;s1=[];if(peg$c3.test(input.charAt(peg$currPos))){s2=input.charAt(peg$currPos);peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c4)}}if(s2!==peg$FAILED){while(s2!==peg$FAILED){s1.push(s2);if(peg$c3.test(input.charAt(peg$currPos))){s2=input.charAt(peg$currPos);peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c4)}}}}else{s1=peg$FAILED}if(s1!==peg$FAILED){s0=input.substring(s0,peg$currPos)}else{s0=s1}}return s0}function peg$parseargumentElement(){var s0,s1,s2,s3,s4,s5,s6,s7,s8;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===123){s1=peg$c5;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c6)}}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){s3=peg$parseargument();if(s3!==peg$FAILED){s4=peg$parse_();if(s4!==peg$FAILED){s5=peg$currPos;if(input.charCodeAt(peg$currPos)===44){s6=peg$c7;peg$currPos++}else{s6=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c8)}}if(s6!==peg$FAILED){s7=peg$parse_();if(s7!==peg$FAILED){s8=peg$parseelementFormat();if(s8!==peg$FAILED){s6=[s6,s7,s8];s5=s6}else{peg$currPos=s5;s5=peg$FAILED}}else{peg$currPos=s5;s5=peg$FAILED}}else{peg$currPos=s5;s5=peg$FAILED}if(s5===peg$FAILED){s5=null}if(s5!==peg$FAILED){s6=peg$parse_();if(s6!==peg$FAILED){if(input.charCodeAt(peg$currPos)===125){s7=peg$c9;peg$currPos++}else{s7=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c10)}}if(s7!==peg$FAILED){peg$savedPos=s0;s1=peg$c11(s3,s5);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parseelementFormat(){var s0;s0=peg$parsesimpleFormat();if(s0===peg$FAILED){s0=peg$parsepluralFormat();if(s0===peg$FAILED){s0=peg$parseselectOrdinalFormat();if(s0===peg$FAILED){s0=peg$parseselectFormat()}}}return s0}function peg$parsesimpleFormat(){var s0,s1,s2,s3,s4,s5,s6;s0=peg$currPos;if(input.substr(peg$currPos,6)===peg$c12){s1=peg$c12;peg$currPos+=6}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c13)}}if(s1===peg$FAILED){if(input.substr(peg$currPos,4)===peg$c14){s1=peg$c14;peg$currPos+=4}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c15)}}if(s1===peg$FAILED){if(input.substr(peg$currPos,4)===peg$c16){s1=peg$c16;peg$currPos+=4}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c17)}}}}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){s3=peg$currPos;if(input.charCodeAt(peg$currPos)===44){s4=peg$c7;peg$currPos++}else{s4=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c8)}}if(s4!==peg$FAILED){s5=peg$parse_();if(s5!==peg$FAILED){s6=peg$parsechars();if(s6!==peg$FAILED){s4=[s4,s5,s6];s3=s4}else{peg$currPos=s3;s3=peg$FAILED}}else{peg$currPos=s3;s3=peg$FAILED}}else{peg$currPos=s3;s3=peg$FAILED}if(s3===peg$FAILED){s3=null}if(s3!==peg$FAILED){peg$savedPos=s0;s1=peg$c18(s1,s3);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parsepluralFormat(){var s0,s1,s2,s3,s4,s5;s0=peg$currPos;if(input.substr(peg$currPos,6)===peg$c19){s1=peg$c19;peg$currPos+=6}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c20)}}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){if(input.charCodeAt(peg$currPos)===44){s3=peg$c7;peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c8)}}if(s3!==peg$FAILED){s4=peg$parse_();if(s4!==peg$FAILED){s5=peg$parsepluralStyle();if(s5!==peg$FAILED){peg$savedPos=s0;s1=peg$c21(s5);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parseselectOrdinalFormat(){var s0,s1,s2,s3,s4,s5;s0=peg$currPos;if(input.substr(peg$currPos,13)===peg$c22){s1=peg$c22;peg$currPos+=13}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c23)}}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){if(input.charCodeAt(peg$currPos)===44){s3=peg$c7;peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c8)}}if(s3!==peg$FAILED){s4=peg$parse_();if(s4!==peg$FAILED){s5=peg$parsepluralStyle();if(s5!==peg$FAILED){peg$savedPos=s0;s1=peg$c24(s5);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parseselectFormat(){var s0,s1,s2,s3,s4,s5,s6;s0=peg$currPos;if(input.substr(peg$currPos,6)===peg$c25){s1=peg$c25;peg$currPos+=6}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c26)}}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){if(input.charCodeAt(peg$currPos)===44){s3=peg$c7;peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c8)}}if(s3!==peg$FAILED){s4=peg$parse_();if(s4!==peg$FAILED){s5=[];s6=peg$parseoptionalFormatPattern();if(s6!==peg$FAILED){while(s6!==peg$FAILED){s5.push(s6);s6=peg$parseoptionalFormatPattern()}}else{s5=peg$FAILED}if(s5!==peg$FAILED){peg$savedPos=s0;s1=peg$c27(s5);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parseselector(){var s0,s1,s2,s3;s0=peg$currPos;s1=peg$currPos;if(input.charCodeAt(peg$currPos)===61){s2=peg$c28;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c29)}}if(s2!==peg$FAILED){s3=peg$parsenumber();if(s3!==peg$FAILED){s2=[s2,s3];s1=s2}else{peg$currPos=s1;s1=peg$FAILED}}else{peg$currPos=s1;s1=peg$FAILED}if(s1!==peg$FAILED){s0=input.substring(s0,peg$currPos)}else{s0=s1}if(s0===peg$FAILED){s0=peg$parsechars()}return s0}function peg$parseoptionalFormatPattern(){var s0,s1,s2,s3,s4,s5,s6,s7,s8;s0=peg$currPos;s1=peg$parse_();if(s1!==peg$FAILED){s2=peg$parseselector();if(s2!==peg$FAILED){s3=peg$parse_();if(s3!==peg$FAILED){if(input.charCodeAt(peg$currPos)===123){s4=peg$c5;peg$currPos++}else{s4=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c6)}}if(s4!==peg$FAILED){s5=peg$parse_();if(s5!==peg$FAILED){s6=peg$parsemessageFormatPattern();if(s6!==peg$FAILED){s7=peg$parse_();if(s7!==peg$FAILED){if(input.charCodeAt(peg$currPos)===125){s8=peg$c9;peg$currPos++}else{s8=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c10)}}if(s8!==peg$FAILED){peg$savedPos=s0;s1=peg$c30(s2,s6);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parseoffset(){var s0,s1,s2,s3;s0=peg$currPos;if(input.substr(peg$currPos,7)===peg$c31){s1=peg$c31;peg$currPos+=7}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c32)}}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){s3=peg$parsenumber();if(s3!==peg$FAILED){peg$savedPos=s0;s1=peg$c33(s3);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parsepluralStyle(){var s0,s1,s2,s3,s4;s0=peg$currPos;s1=peg$parseoffset();if(s1===peg$FAILED){s1=null}if(s1!==peg$FAILED){s2=peg$parse_();if(s2!==peg$FAILED){s3=[];s4=peg$parseoptionalFormatPattern();if(s4!==peg$FAILED){while(s4!==peg$FAILED){s3.push(s4);s4=peg$parseoptionalFormatPattern()}}else{s3=peg$FAILED}if(s3!==peg$FAILED){peg$savedPos=s0;s1=peg$c34(s1,s3);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parsews(){var s0,s1;peg$silentFails++;s0=[];if(peg$c36.test(input.charAt(peg$currPos))){s1=input.charAt(peg$currPos);peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c37)}}if(s1!==peg$FAILED){while(s1!==peg$FAILED){s0.push(s1);if(peg$c36.test(input.charAt(peg$currPos))){s1=input.charAt(peg$currPos);peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c37)}}}}else{s0=peg$FAILED}peg$silentFails--;if(s0===peg$FAILED){s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c35)}}return s0}function peg$parse_(){var s0,s1,s2;peg$silentFails++;s0=peg$currPos;s1=[];s2=peg$parsews();while(s2!==peg$FAILED){s1.push(s2);s2=peg$parsews()}if(s1!==peg$FAILED){s0=input.substring(s0,peg$currPos)}else{s0=s1}peg$silentFails--;if(s0===peg$FAILED){s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c38)}}return s0}function peg$parsedigit(){var s0;if(peg$c39.test(input.charAt(peg$currPos))){s0=input.charAt(peg$currPos);peg$currPos++}else{s0=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c40)}}return s0}function peg$parsehexDigit(){var s0;if(peg$c41.test(input.charAt(peg$currPos))){s0=input.charAt(peg$currPos);peg$currPos++}else{s0=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c42)}}return s0}function peg$parsenumber(){var s0,s1,s2,s3,s4,s5;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===48){s1=peg$c43;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c44)}}if(s1===peg$FAILED){s1=peg$currPos;s2=peg$currPos;if(peg$c45.test(input.charAt(peg$currPos))){s3=input.charAt(peg$currPos);peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c46)}}if(s3!==peg$FAILED){s4=[];s5=peg$parsedigit();while(s5!==peg$FAILED){s4.push(s5);s5=peg$parsedigit()}if(s4!==peg$FAILED){s3=[s3,s4];s2=s3}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}if(s2!==peg$FAILED){s1=input.substring(s1,peg$currPos)}else{s1=s2}}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c47(s1)}s0=s1;return s0}function peg$parsechar(){var s0,s1,s2,s3,s4,s5,s6,s7;if(peg$c48.test(input.charAt(peg$currPos))){s0=input.charAt(peg$currPos);peg$currPos++}else{s0=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c49)}}if(s0===peg$FAILED){s0=peg$currPos;if(input.substr(peg$currPos,2)===peg$c50){s1=peg$c50;peg$currPos+=2}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c51)}}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c52()}s0=s1;if(s0===peg$FAILED){s0=peg$currPos;if(input.substr(peg$currPos,2)===peg$c53){s1=peg$c53;peg$currPos+=2}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c54)}}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c55()}s0=s1;if(s0===peg$FAILED){s0=peg$currPos;if(input.substr(peg$currPos,2)===peg$c56){s1=peg$c56;peg$currPos+=2}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c57)}}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c58()}s0=s1;if(s0===peg$FAILED){s0=peg$currPos;if(input.substr(peg$currPos,2)===peg$c59){s1=peg$c59;peg$currPos+=2}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c60)}}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c61()}s0=s1;if(s0===peg$FAILED){s0=peg$currPos;if(input.substr(peg$currPos,2)===peg$c62){s1=peg$c62;peg$currPos+=2}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c63)}}if(s1!==peg$FAILED){s2=peg$currPos;s3=peg$currPos;s4=peg$parsehexDigit();if(s4!==peg$FAILED){s5=peg$parsehexDigit();if(s5!==peg$FAILED){s6=peg$parsehexDigit();if(s6!==peg$FAILED){s7=peg$parsehexDigit();if(s7!==peg$FAILED){s4=[s4,s5,s6,s7];s3=s4}else{peg$currPos=s3;s3=peg$FAILED}}else{peg$currPos=s3;s3=peg$FAILED}}else{peg$currPos=s3;s3=peg$FAILED}}else{peg$currPos=s3;s3=peg$FAILED}if(s3!==peg$FAILED){s2=input.substring(s2,peg$currPos)}else{s2=s3}if(s2!==peg$FAILED){peg$savedPos=s0;s1=peg$c64(s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}}}}}return s0}function peg$parsechars(){var s0,s1,s2;s0=peg$currPos;s1=[];s2=peg$parsechar();if(s2!==peg$FAILED){while(s2!==peg$FAILED){s1.push(s2);s2=peg$parsechar()}}else{s1=peg$FAILED}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c65(s1)}s0=s1;return s0}peg$result=peg$startRuleFunction();if(peg$result!==peg$FAILED&&peg$currPos===input.length){return peg$result}else{if(peg$result!==peg$FAILED&&peg$currPos<input.length){peg$fail({type:"end",description:"end of input"})}throw peg$buildException(null,peg$maxFailExpected,peg$maxFailPos<input.length?input.charAt(peg$maxFailPos):null,peg$maxFailPos<input.length?peg$computeLocation(peg$maxFailPos,peg$maxFailPos+1):peg$computeLocation(peg$maxFailPos,peg$maxFailPos))}}return{SyntaxError:peg$SyntaxError,parse:peg$parse}}()},662:function(module,exports,__webpack_require__){"use strict";exports["default"]={locale:"en",pluralRuleFunction:function(n,ord){var s=String(n).split("."),v0=!s[1],t0=Number(s[0])==n,n10=t0&&s[0].slice(-1),n100=t0&&s[0].slice(-2);if(ord)return n10==1&&n100!=11?"one":n10==2&&n100!=12?"two":n10==3&&n100!=13?"few":"other";return n==1&&v0?"one":"other"}}},664:function(module,exports,__webpack_require__){"use strict";var IntlRelativeFormat=__webpack_require__(665)["default"];__webpack_require__(670);exports=module.exports=IntlRelativeFormat;exports["default"]=exports},665:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var core_1=__webpack_require__(666);var en_1=__webpack_require__(669);core_1.default.__addLocaleData(en_1.default);core_1.default.defaultLocale="en";exports.default=core_1.default},666:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var intl_messageformat_1=__webpack_require__(507);var diff_1=__webpack_require__(667);var es5_1=__webpack_require__(668);exports.default=RelativeFormat;var FIELDS=["second","second-short","minute","minute-short","hour","hour-short","day","day-short","month","month-short","year","year-short"];var STYLES=["best fit","numeric"];function RelativeFormat(locales,options){options=options||{};if(es5_1.isArray(locales)){locales=locales.concat()}es5_1.defineProperty(this,"_locale",{value:this._resolveLocale(locales)});es5_1.defineProperty(this,"_options",{value:{style:this._resolveStyle(options.style),units:this._isValidUnits(options.units)&&options.units}});es5_1.defineProperty(this,"_locales",{value:locales});es5_1.defineProperty(this,"_fields",{value:this._findFields(this._locale)});es5_1.defineProperty(this,"_messages",{value:es5_1.objCreate(null)});var relativeFormat=this;this.format=function format(date,options){return relativeFormat._format(date,options)}}es5_1.defineProperty(RelativeFormat,"__localeData__",{value:es5_1.objCreate(null)});es5_1.defineProperty(RelativeFormat,"__addLocaleData",{value:function(){for(var i=0;i<arguments.length;i++){var datum=arguments[i];if(!(datum&&datum.locale)){throw new Error("Locale data provided to IntlRelativeFormat is missing a "+"`locale` property value")}RelativeFormat.__localeData__[datum.locale.toLowerCase()]=datum;intl_messageformat_1.default.__addLocaleData(datum)}}});es5_1.defineProperty(RelativeFormat,"defaultLocale",{enumerable:true,writable:true,value:undefined});es5_1.defineProperty(RelativeFormat,"thresholds",{enumerable:true,value:{second:45,"second-short":45,minute:45,"minute-short":45,hour:22,"hour-short":22,day:26,"day-short":26,month:11,"month-short":11}});RelativeFormat.prototype.resolvedOptions=function(){return{locale:this._locale,style:this._options.style,units:this._options.units}};RelativeFormat.prototype._compileMessage=function(units){var locales=this._locales;var resolvedLocale=this._locale;var field=this._fields[units];var relativeTime=field.relativeTime;var future="";var past="";var i;for(i in relativeTime.future){if(relativeTime.future.hasOwnProperty(i)){future+=" "+i+" {"+relativeTime.future[i].replace("{0}","#")+"}"}}for(i in relativeTime.past){if(relativeTime.past.hasOwnProperty(i)){past+=" "+i+" {"+relativeTime.past[i].replace("{0}","#")+"}"}}var message="{when, select, future {{0, plural, "+future+"}}"+"past {{0, plural, "+past+"}}}";return new intl_messageformat_1.default(message,locales)};RelativeFormat.prototype._getMessage=function(units){var messages=this._messages;if(!messages[units]){messages[units]=this._compileMessage(units)}return messages[units]};RelativeFormat.prototype._getRelativeUnits=function(diff,units){var field=this._fields[units];if(field.relative){return field.relative[diff]}};RelativeFormat.prototype._findFields=function(locale){var localeData=RelativeFormat.__localeData__;var data=localeData[locale.toLowerCase()];while(data){if(data.fields){return data.fields}data=data.parentLocale&&localeData[data.parentLocale.toLowerCase()]}throw new Error("Locale data added to IntlRelativeFormat is missing `fields` for :"+locale)};RelativeFormat.prototype._format=function(date,options){var now=options&&options.now!==undefined?options.now:es5_1.dateNow();if(date===undefined){date=now}if(!isFinite(now)){throw new RangeError("The `now` option provided to IntlRelativeFormat#format() is not "+"in valid range.")}if(!isFinite(date)){throw new RangeError("The date value provided to IntlRelativeFormat#format() is not "+"in valid range.")}var diffReport=diff_1.default(now,date);var units=this._options.units||this._selectUnits(diffReport);var diffInUnits=diffReport[units];if(this._options.style!=="numeric"){var relativeUnits=this._getRelativeUnits(diffInUnits,units);if(relativeUnits){return relativeUnits}}return this._getMessage(units).format({0:Math.abs(diffInUnits),when:diffInUnits<0?"past":"future"})};RelativeFormat.prototype._isValidUnits=function(units){if(!units||es5_1.arrIndexOf.call(FIELDS,units)>=0){return true}if(typeof units==="string"){var suggestion=/s$/.test(units)&&units.substr(0,units.length-1);if(suggestion&&es5_1.arrIndexOf.call(FIELDS,suggestion)>=0){throw new Error('"'+units+'" is not a valid IntlRelativeFormat `units` '+"value, did you mean: "+suggestion)}}throw new Error('"'+units+'" is not a valid IntlRelativeFormat `units` value, it '+'must be one of: "'+FIELDS.join('", "')+'"')};RelativeFormat.prototype._resolveLocale=function(locales){if(typeof locales==="string"){locales=[locales]}locales=(locales||[]).concat(RelativeFormat.defaultLocale);var localeData=RelativeFormat.__localeData__;var i,len,localeParts,data;for(i=0,len=locales.length;i<len;i+=1){localeParts=locales[i].toLowerCase().split("-");while(localeParts.length){data=localeData[localeParts.join("-")];if(data){return data.locale}localeParts.pop()}}var defaultLocale=locales.pop();throw new Error("No locale data has been added to IntlRelativeFormat for: "+locales.join(", ")+", or the default locale: "+defaultLocale)};RelativeFormat.prototype._resolveStyle=function(style){if(!style){return STYLES[0]}if(es5_1.arrIndexOf.call(STYLES,style)>=0){return style}throw new Error('"'+style+'" is not a valid IntlRelativeFormat `style` value, it '+'must be one of: "'+STYLES.join('", "')+'"')};RelativeFormat.prototype._selectUnits=function(diffReport){var i,l,units;var fields=FIELDS.filter((function(field){return field.indexOf("-short")<1}));for(i=0,l=fields.length;i<l;i+=1){units=fields[i];if(Math.abs(diffReport[units])<RelativeFormat.thresholds[units]){break}}return units}},667:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var round=Math.round;function daysToYears(days){return days*400/146097}var MILLISECONDS_IN_MINUTE=6e4;var MILLISECONDS_IN_DAY=864e5;function startOfDay(dirtyDate){var date=new Date(dirtyDate);date.setHours(0,0,0,0);return date}function differenceInCalendarDays(dirtyDateLeft,dirtyDateRight){var startOfDayLeft=startOfDay(dirtyDateLeft);var startOfDayRight=startOfDay(dirtyDateRight);var timestampLeft=startOfDayLeft.getTime()-startOfDayLeft.getTimezoneOffset()*MILLISECONDS_IN_MINUTE;var timestampRight=startOfDayRight.getTime()-startOfDayRight.getTimezoneOffset()*MILLISECONDS_IN_MINUTE;return Math.round((timestampLeft-timestampRight)/MILLISECONDS_IN_DAY)}function default_1(from,to){from=+from;to=+to;var millisecond=round(to-from),second=round(millisecond/1e3),minute=round(second/60),hour=round(minute/60);var day=differenceInCalendarDays(to,from);var week=round(day/7);var rawYears=daysToYears(day),month=round(rawYears*12),year=round(rawYears);return{millisecond:millisecond,second:second,"second-short":second,minute:minute,"minute-short":minute,hour:hour,"hour-short":hour,day:day,"day-short":day,week:week,"week-short":week,month:month,"month-short":month,year:year,"year-short":year}}exports.default=default_1},668:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var hop=Object.prototype.hasOwnProperty;var toString=Object.prototype.toString;var realDefineProp=function(){try{return!!Object.defineProperty({},"a",{})}catch(e){return false}}();var es3=!realDefineProp&&!Object.prototype.__defineGetter__;var defineProperty=realDefineProp?Object.defineProperty:function(obj,name,desc){if("get"in desc&&obj.__defineGetter__){obj.__defineGetter__(name,desc.get)}else if(!hop.call(obj,name)||"value"in desc){obj[name]=desc.value}};exports.defineProperty=defineProperty;var objCreate=Object.create||function(proto,props){var obj,k;function F(){}F.prototype=proto;obj=new F;for(k in props){if(hop.call(props,k)){defineProperty(obj,k,props[k])}}return obj};exports.objCreate=objCreate;var arrIndexOf=Array.prototype.indexOf||function(search,fromIndex){var arr=this;if(!arr.length){return-1}for(var i=fromIndex||0,max=arr.length;i<max;i++){if(arr[i]===search){return i}}return-1};exports.arrIndexOf=arrIndexOf;var isArray=Array.isArray||function(obj){return toString.call(obj)==="[object Array]"};exports.isArray=isArray;var dateNow=Date.now||function(){return(new Date).getTime()};exports.dateNow=dateNow},669:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default={locale:"en",pluralRuleFunction:function(n,ord){var s=String(n).split("."),v0=!s[1],t0=Number(s[0])==n,n10=t0&&s[0].slice(-1),n100=t0&&s[0].slice(-2);if(ord)return n10==1&&n100!=11?"one":n10==2&&n100!=12?"two":n10==3&&n100!=13?"few":"other";return n==1&&v0?"one":"other"},fields:{year:{displayName:"year",relative:{0:"this year",1:"next year","-1":"last year"},relativeTime:{future:{one:"in {0} year",other:"in {0} years"},past:{one:"{0} year ago",other:"{0} years ago"}}},"year-short":{displayName:"yr.",relative:{0:"this yr.",1:"next yr.","-1":"last yr."},relativeTime:{future:{one:"in {0} yr.",other:"in {0} yr."},past:{one:"{0} yr. ago",other:"{0} yr. ago"}}},month:{displayName:"month",relative:{0:"this month",1:"next month","-1":"last month"},relativeTime:{future:{one:"in {0} month",other:"in {0} months"},past:{one:"{0} month ago",other:"{0} months ago"}}},"month-short":{displayName:"mo.",relative:{0:"this mo.",1:"next mo.","-1":"last mo."},relativeTime:{future:{one:"in {0} mo.",other:"in {0} mo."},past:{one:"{0} mo. ago",other:"{0} mo. ago"}}},week:{displayName:"week",relativePeriod:"the week of {0}",relative:{0:"this week",1:"next week","-1":"last week"},relativeTime:{future:{one:"in {0} week",other:"in {0} weeks"},past:{one:"{0} week ago",other:"{0} weeks ago"}}},"week-short":{displayName:"wk.",relativePeriod:"the week of {0}",relative:{0:"this wk.",1:"next wk.","-1":"last wk."},relativeTime:{future:{one:"in {0} wk.",other:"in {0} wk."},past:{one:"{0} wk. ago",other:"{0} wk. ago"}}},day:{displayName:"day",relative:{0:"today",1:"tomorrow","-1":"yesterday"},relativeTime:{future:{one:"in {0} day",other:"in {0} days"},past:{one:"{0} day ago",other:"{0} days ago"}}},"day-short":{displayName:"day",relative:{0:"today",1:"tomorrow","-1":"yesterday"},relativeTime:{future:{one:"in {0} day",other:"in {0} days"},past:{one:"{0} day ago",other:"{0} days ago"}}},hour:{displayName:"hour",relative:{0:"this hour"},relativeTime:{future:{one:"in {0} hour",other:"in {0} hours"},past:{one:"{0} hour ago",other:"{0} hours ago"}}},"hour-short":{displayName:"hr.",relative:{0:"this hour"},relativeTime:{future:{one:"in {0} hr.",other:"in {0} hr."},past:{one:"{0} hr. ago",other:"{0} hr. ago"}}},minute:{displayName:"minute",relative:{0:"this minute"},relativeTime:{future:{one:"in {0} minute",other:"in {0} minutes"},past:{one:"{0} minute ago",other:"{0} minutes ago"}}},"minute-short":{displayName:"min.",relative:{0:"this minute"},relativeTime:{future:{one:"in {0} min.",other:"in {0} min."},past:{one:"{0} min. ago",other:"{0} min. ago"}}},second:{displayName:"second",relative:{0:"now"},relativeTime:{future:{one:"in {0} second",other:"in {0} seconds"},past:{one:"{0} second ago",other:"{0} seconds ago"}}},"second-short":{displayName:"sec.",relative:{0:"now"},relativeTime:{future:{one:"in {0} sec.",other:"in {0} sec."},past:{one:"{0} sec. ago",other:"{0} sec. ago"}}}}}},671:function(module,exports,__webpack_require__){"use strict";var reactIs=__webpack_require__(672);var REACT_STATICS={childContextTypes:true,contextType:true,contextTypes:true,defaultProps:true,displayName:true,getDefaultProps:true,getDerivedStateFromError:true,getDerivedStateFromProps:true,mixins:true,propTypes:true,type:true};var KNOWN_STATICS={name:true,length:true,prototype:true,caller:true,callee:true,arguments:true,arity:true};var FORWARD_REF_STATICS={$$typeof:true,render:true,defaultProps:true,displayName:true,propTypes:true};var MEMO_STATICS={$$typeof:true,compare:true,defaultProps:true,displayName:true,propTypes:true,type:true};var TYPE_STATICS={};TYPE_STATICS[reactIs.ForwardRef]=FORWARD_REF_STATICS;TYPE_STATICS[reactIs.Memo]=MEMO_STATICS;function getStatics(component){if(reactIs.isMemo(component)){return MEMO_STATICS}return TYPE_STATICS[component["$$typeof"]]||REACT_STATICS}var defineProperty=Object.defineProperty;var getOwnPropertyNames=Object.getOwnPropertyNames;var getOwnPropertySymbols=Object.getOwnPropertySymbols;var getOwnPropertyDescriptor=Object.getOwnPropertyDescriptor;var getPrototypeOf=Object.getPrototypeOf;var objectPrototype=Object.prototype;function hoistNonReactStatics(targetComponent,sourceComponent,blacklist){if(typeof sourceComponent!=="string"){if(objectPrototype){var inheritedComponent=getPrototypeOf(sourceComponent);if(inheritedComponent&&inheritedComponent!==objectPrototype){hoistNonReactStatics(targetComponent,inheritedComponent,blacklist)}}var keys=getOwnPropertyNames(sourceComponent);if(getOwnPropertySymbols){keys=keys.concat(getOwnPropertySymbols(sourceComponent))}var targetStatics=getStatics(targetComponent);var sourceStatics=getStatics(sourceComponent);for(var i=0;i<keys.length;++i){var key=keys[i];if(!KNOWN_STATICS[key]&&!(blacklist&&blacklist[key])&&!(sourceStatics&&sourceStatics[key])&&!(targetStatics&&targetStatics[key])){var descriptor=getOwnPropertyDescriptor(sourceComponent,key);try{defineProperty(targetComponent,key,descriptor)}catch(e){}}}}return targetComponent}module.exports=hoistNonReactStatics},672:function(module,exports,__webpack_require__){"use strict";if(true){module.exports=__webpack_require__(673)}else{}},673:function(module,exports,__webpack_require__){"use strict";
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?Symbol.for("react.suspense_list"):60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.block"):60121,w=b?Symbol.for("react.fundamental"):60117,x=b?Symbol.for("react.responder"):60118,y=b?Symbol.for("react.scope"):60119;function z(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case t:case r:case h:return a;default:return u}}case d:return u}}}function A(a){return z(a)===m}exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;exports.Fragment=e;exports.Lazy=t;exports.Memo=r;exports.Portal=d;exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;exports.isAsyncMode=function(a){return A(a)||z(a)===l};exports.isConcurrentMode=A;exports.isContextConsumer=function(a){return z(a)===k};exports.isContextProvider=function(a){return z(a)===h};exports.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return z(a)===n};exports.isFragment=function(a){return z(a)===e};exports.isLazy=function(a){return z(a)===t};exports.isMemo=function(a){return z(a)===r};exports.isPortal=function(a){return z(a)===d};exports.isProfiler=function(a){return z(a)===g};exports.isStrictMode=function(a){return z(a)===f};exports.isSuspense=function(a){return z(a)===p};exports.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===w||a.$$typeof===x||a.$$typeof===y||a.$$typeof===v)};exports.typeOf=z},674:function(module,exports,__webpack_require__){"use strict";var invariant=function(condition,format,a,b,c,d,e,f){if(false){}if(!condition){var error;if(format===undefined){error=new Error("Minified exception occurred; use the non-minified dev environment "+"for the full error message and additional helpful warnings.")}else{var args=[a,b,c,d,e,f];var argIndex=0;error=new Error(format.replace(/%s/g,(function(){return args[argIndex++]})));error.name="Invariant Violation"}error.framesToPop=1;throw error}};module.exports=invariant},675:function(module,exports,__webpack_require__){"use strict";exports=module.exports=__webpack_require__(676)["default"];exports["default"]=exports},676:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var RelativeTimeFormat;function getCacheId(inputs){return JSON.stringify(inputs.map((function(input){return input&&typeof input==="object"?orderedProps(input):input})))}function orderedProps(obj){return Object.keys(obj).sort().map((function(k){var _a;return _a={},_a[k]=obj[k],_a}))}var memoizeFormatConstructor=function(FormatConstructor,cache){if(cache===void 0){cache={}}return function(){var _a;var args=[];for(var _i=0;_i<arguments.length;_i++){args[_i]=arguments[_i]}var cacheId=getCacheId(args);var format=cacheId&&cache[cacheId];if(!format){format=new((_a=FormatConstructor).bind.apply(_a,[void 0].concat(args)));if(cacheId){cache[cacheId]=format}}return format}};exports.default=memoizeFormatConstructor}}]);