function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0) { ; } } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

import React, { useCallback, useEffect, useMemo, useState } from 'react';
import classNames from 'classnames';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiSplitButtonControl } from './split_button_control';
import { EuiPopover } from '../popover';
import { EuiContextMenuItem } from '../context_menu';
import { cascadingMenuKeys, keys } from '../../services';
import { EuiI18n } from '../i18n';
import { EuiText } from '../text';
import { EuiFocusTrap } from '../focus_trap';
import { tabbable } from 'tabbable';
var ShiftDirection;
(function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
})(ShiftDirection || (ShiftDirection = {}));
export var EuiSplitButton = function EuiSplitButton(_ref) {
  var _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'primary' : _ref$color,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    disabled = _ref.disabled,
    _ref$options = _ref.options,
    options = _ref$options === void 0 ? [] : _ref$options,
    selectedIndex = _ref.selectedIndex,
    _ref$initiallyOpen = _ref.initiallyOpen,
    initiallyOpen = _ref$initiallyOpen === void 0 ? false : _ref$initiallyOpen,
    hasDividers = _ref.hasDividers,
    itemClassName = _ref.itemClassName,
    onClick = _ref.onClick,
    className = _ref.className,
    popoverClassName = _ref.popoverClassName,
    children = _ref.children,
    dropdownProps = _ref.dropdownProps,
    optionProps = _ref.optionProps,
    buttonProps = _ref.buttonProps,
    rest = _objectWithoutProperties(_ref, ["color", "fullWidth", "disabled", "options", "selectedIndex", "initiallyOpen", "hasDividers", "itemClassName", "onClick", "className", "popoverClassName", "children", "dropdownProps", "optionProps", "buttonProps"]);
  var displayDropdown = options.length > 0;
  var itemNodes = useMemo(function () {
    return [];
  }, []);
  var _useState = useState(!!initiallyOpen && displayDropdown),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    panelEl = _useState4[0],
    setPanelEl = _useState4[1];
  var panelRef = function panelRef(node) {
    return setPanelEl(node);
  };
  var onKeyDown = function onKeyDown(event) {
    if (panelEl && event.key === cascadingMenuKeys.TAB) {
      var tabbableItems = tabbable(panelEl).filter(function (el) {
        return Array.from(el.attributes).map(function (el) {
          return el.name;
        }).indexOf('data-focus-guard') < 0;
      });
      if (tabbableItems.length && tabbableItems[tabbableItems.length - 1] === document.activeElement) {
        setIsOpen(false);
      }
    }
  };
  var focusItemAt = useCallback(function (index) {
    var targetElement = itemNodes[index];
    if (targetElement != null) {
      targetElement.focus();
      return targetElement.matches(':focus');
    }
  }, [itemNodes]);
  var focusSelected = useCallback(function () {
    requestAnimationFrame(function () {
      var hasFocus = focusItemAt(selectedIndex || 0);
      if (!hasFocus) {
        focusSelected();
      }
    });
  }, [selectedIndex, focusItemAt]);
  useEffect(function () {
    isOpen && requestAnimationFrame(focusSelected);
  }, [isOpen, focusSelected]);
  var onSelectKeyDown = function onSelectKeyDown(event) {
    if (event.key === keys.ARROW_UP || event.key === keys.ARROW_DOWN) {
      event.preventDefault();
      event.stopPropagation();
      setIsOpen(true);
    }
  };
  var shiftFocus = function shiftFocus(direction) {
    var currentIndex = itemNodes.indexOf(document.activeElement);
    setIsOpen(true);
    if (currentIndex === -1) {
      // somehow the select options has lost focus
      focusItemAt(0);
    } else {
      if (direction === ShiftDirection.BACK) {
        focusItemAt(currentIndex === 0 ? itemNodes.length - 1 : currentIndex - 1);
      } else {
        focusItemAt(currentIndex === itemNodes.length - 1 ? 0 : currentIndex + 1);
      }
    }
  };
  var onItemKeyDown = function onItemKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      // close the popover and prevent ancestors from handling
      event.preventDefault();
      event.stopPropagation();
      setIsOpen(false);
    } else if (event.key === keys.TAB) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.FORWARD);
    } else if (event.key === keys.TAB && event.shiftKey) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.BACK);
    } else if (event.key === keys.ARROW_UP) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.BACK);
    } else if (event.key === keys.ARROW_DOWN) {
      event.preventDefault();
      event.stopPropagation();
      shiftFocus(ShiftDirection.FORWARD);
    }
  };
  var popoverClasses = classNames('euiSplitButton', popoverClassName);
  var buttonClasses = classNames({
    'euiSplitButton--isOpen__button': isOpen
  }, className);
  var itemClasses = classNames('euiSplitButton__item', {
    'euiSplitButton__item--hasDividers': hasDividers
  }, itemClassName);
  var onPrimaryClick = function onPrimaryClick() {
    onClick === null || onClick === void 0 ? void 0 : onClick();
    setIsOpen(false);
  };
  var button = /*#__PURE__*/React.createElement(EuiSplitButtonControl, _extends({
    displayDropdown: displayDropdown,
    color: color,
    onDropdownClick: function onDropdownClick() {
      return setIsOpen(!isOpen);
    },
    onClick: onPrimaryClick,
    onKeyDown: onSelectKeyDown,
    className: buttonClasses,
    fullWidth: fullWidth,
    dropdownProps: dropdownProps,
    buttonProps: buttonProps,
    disabled: disabled
  }, rest), children);
  var itemIcon = function itemIcon(index) {
    if (selectedIndex === undefined) return;
    if (selectedIndex === index) return 'check';
    return 'empty';
  };
  var items = options.map(function (option, index) {
    var isSelected = selectedIndex === index;
    var content = typeof option.display === 'string' ? /*#__PURE__*/React.createElement(EuiText, _extends({
      textAlign: "center"
    }, optionProps), option.display) : option.display;
    var itemOnClick = function itemOnClick() {
      var _option$onClick;
      setIsOpen(false);
      (_option$onClick = option.onClick) === null || _option$onClick === void 0 ? void 0 : _option$onClick.call(option);
    };
    return /*#__PURE__*/React.createElement(EuiContextMenuItem, {
      key: "optionItem_".concat(index),
      className: itemClasses,
      color: color,
      icon: itemIcon(index),
      href: option.href,
      target: option.target,
      onClick: itemOnClick,
      onKeyDown: onItemKeyDown,
      layoutAlign: "center",
      buttonRef: function buttonRef(node) {
        return itemNodes[index] = node;
      },
      role: "option",
      id: "splitButtonItem_".concat(index),
      "aria-selected": isSelected ? 'true' : 'false'
    }, content);
  });

  // return <div>SplitButton</div>;
  return /*#__PURE__*/React.createElement(EuiPopover, {
    ownFocus: false,
    hasArrow: false,
    anchorPosition: "downRight",
    button: button,
    panelRef: panelRef,
    className: popoverClasses,
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    panelPaddingSize: "none"
  }, /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
    role: "alert"
  }, /*#__PURE__*/React.createElement(EuiI18n, {
    token: "euiSplitButton.screenReaderAnnouncement",
    default: "You are in a selector of {optionsCount} items and must select a single option. Use the up and down keys to navigate or escape to close.",
    values: {
      optionsCount: options === null || options === void 0 ? void 0 : options.length
    }
  }))), /*#__PURE__*/React.createElement(EuiFocusTrap, {
    clickOutsideDisables: true
  }, /*#__PURE__*/React.createElement("div", {
    onKeyDown: onKeyDown
  }, /*#__PURE__*/React.createElement("div", {
    className: "euiSplitButton__listbox",
    role: "listbox",
    "aria-activedescendant": "".concat(selectedIndex),
    tabIndex: 0
  }, items))));
};