/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.opensearch.index.search.NestedHelper;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.search.internal.SearchContext;

public class HybridQueryUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(HybridQueryUtil.class);

    public static boolean isHybridQuery(Query query, SearchContext searchContext) {
        if (query instanceof HybridQuery || Objects.nonNull(searchContext.parsedQuery()) && searchContext.parsedQuery().query() instanceof HybridQuery) {
            return true;
        }
        return HybridQueryUtil.isHybridQueryExtendedWithDlsRules(query, searchContext) || Objects.nonNull(searchContext.parsedQuery()) && HybridQueryUtil.isHybridQueryExtendedWithDlsRules(searchContext.parsedQuery().query(), searchContext);
    }

    public static boolean isHybridQueryWrappedInBooleanQuery(SearchContext searchContext, Query query) {
        if (!(query instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery boolQuery = (BooleanQuery)query;
        return (HybridQueryUtil.hasAliasFilter(searchContext) || HybridQueryUtil.hasNestedFieldOrNestedDocs(query, searchContext)) && HybridQueryUtil.isWrappedHybridQuery(query) && !boolQuery.clauses().isEmpty();
    }

    public static Query transformHybridQueryWrappedInBooleanMustQuery(List<BooleanClause> booleanClauses) {
        if (booleanClauses.isEmpty()) {
            return null;
        }
        HybridQuery hybridQuery = booleanClauses.getFirst().occur() == BooleanClause.Occur.MUST && booleanClauses.getFirst().query() instanceof HybridQuery ? (HybridQuery)booleanClauses.getFirst().query() : null;
        BooleanClause filterOrMustNotClause = null;
        for (BooleanClause booleanClause : booleanClauses.stream().skip(1L).toList()) {
            if (booleanClause.occur() != BooleanClause.Occur.FILTER && booleanClause.occur() != BooleanClause.Occur.MUST_NOT) continue;
            filterOrMustNotClause = booleanClause;
            break;
        }
        return HybridQueryUtil.createBoolQueryFromHybridQuery(hybridQuery, filterOrMustNotClause);
    }

    private static Query createBoolQueryFromHybridQuery(HybridQuery hybridQuery, BooleanClause filterOrMustNotClause) {
        if (hybridQuery != null && filterOrMustNotClause != null) {
            Collection<Query> subQueries = hybridQuery.getSubQueries();
            ArrayList clauses = new ArrayList();
            subQueries.forEach(subQuery -> {
                BooleanClause booleanClause = new BooleanClause(subQuery, BooleanClause.Occur.SHOULD);
                clauses.add(booleanClause);
            });
            BooleanQuery innerBooleanQuery = new BooleanQuery.Builder().add(clauses).build();
            return new BooleanQuery.Builder().add((Query)innerBooleanQuery, BooleanClause.Occur.MUST).add(filterOrMustNotClause).build();
        }
        return null;
    }

    public static boolean isHybridQueryExtendedWithDlsRules(Query query, SearchContext searchContext) {
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            List booleanClauses = booleanQuery.clauses();
            int hybridQueryIndex = IntStream.range(0, booleanClauses.size()).filter(i -> ((BooleanClause)booleanClauses.get(i)).query() instanceof HybridQuery).findFirst().orElse(-1);
            if (hybridQueryIndex == -1 || ((BooleanClause)booleanClauses.get(hybridQueryIndex)).occur() != BooleanClause.Occur.MUST) {
                return false;
            }
            List dlsClauses = booleanClauses.subList(0, hybridQueryIndex);
            return !dlsClauses.isEmpty() && dlsClauses.stream().allMatch(clause -> {
                Query patt0$temp;
                if (clause.query() instanceof ConstantScoreQuery && clause.occur() == BooleanClause.Occur.SHOULD) {
                    return true;
                }
                if (searchContext.mapperService().hasNested() && (patt0$temp = clause.query()) instanceof ToChildBlockJoinQuery) {
                    ToChildBlockJoinQuery toChildBlockJoinQuery = (ToChildBlockJoinQuery)patt0$temp;
                    if (clause.occur() == BooleanClause.Occur.SHOULD) {
                        return toChildBlockJoinQuery.getParentQuery() instanceof ConstantScoreQuery;
                    }
                }
                return false;
            });
        }
        return false;
    }

    public static boolean isHybridQueryExtendedWithDlsRulesAndWrappedInBoolQuery(SearchContext searchContext, Query query) {
        BooleanQuery booleanQuery;
        return (HybridQueryUtil.hasAliasFilter(searchContext) || HybridQueryUtil.hasNestedFieldOrNestedDocs(query, searchContext)) && query instanceof BooleanQuery && (booleanQuery = (BooleanQuery)query).clauses().stream().anyMatch(clause -> HybridQueryUtil.isHybridQueryExtendedWithDlsRules(clause.query(), searchContext));
    }

    @VisibleForTesting
    public static Query extractHybridQuery(SearchContext searchContext, Query query) {
        HybridQuery hybridQuery = HybridQueryUtil.extractHybridQuery(searchContext);
        if (HybridQueryUtil.isHybridQueryExtendedWithDlsRules(query, searchContext)) {
            return HybridQuery.fromQueryExtendedWithDlsRules((BooleanQuery)query, hybridQuery, List.of());
        }
        if (HybridQueryUtil.isHybridQueryExtendedWithDlsRulesAndWrappedInBoolQuery(searchContext, query)) {
            List booleanClauses = ((BooleanQuery)query).clauses();
            BooleanQuery queryWithDls = booleanClauses.stream().filter(clause -> HybridQueryUtil.isHybridQueryExtendedWithDlsRules(clause.query(), searchContext)).findFirst().map(BooleanClause::query).map(BooleanQuery.class::cast).orElseThrow(() -> new IllegalArgumentException("Given boolean query does not contain a HybridQuery clause with DLS rules"));
            List<BooleanClause> filterQueries = booleanClauses.stream().filter(clause -> !HybridQueryUtil.isHybridQueryExtendedWithDlsRules(clause.query(), searchContext)).toList();
            return HybridQuery.fromQueryExtendedWithDlsRules(queryWithDls, hybridQuery, filterQueries);
        }
        if (HybridQueryUtil.isHybridQueryWrappedInBooleanQuery(searchContext, query)) {
            List booleanClauses = ((BooleanQuery)query).clauses();
            List<BooleanClause> filterQueries = booleanClauses.stream().skip(1L).collect(Collectors.toList());
            return new HybridQuery(hybridQuery.getSubQueries(), hybridQuery.getQueryContext(), filterQueries);
        }
        return query;
    }

    private static HybridQuery extractHybridQuery(SearchContext searchContext) {
        HybridQuery hybridQuery;
        Query query = searchContext.query();
        if (HybridQueryUtil.isHybridQueryExtendedWithDlsRules(query, searchContext)) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            hybridQuery = HybridQueryUtil.unwrapHybridQueryWrappedInSecurityDlsRules(booleanQuery);
        } else if (HybridQueryUtil.isHybridQueryExtendedWithDlsRulesAndWrappedInBoolQuery(searchContext, query)) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            hybridQuery = booleanQuery.clauses().stream().filter(clause -> HybridQueryUtil.isHybridQueryExtendedWithDlsRules(clause.query(), searchContext)).findFirst().map(BooleanClause::query).map(BooleanQuery.class::cast).map(HybridQueryUtil::unwrapHybridQueryWrappedInSecurityDlsRules).orElseThrow(() -> new IllegalArgumentException("Given query does not contain a HybridQuery clause with DLS rules"));
        } else if (HybridQueryUtil.isHybridQueryWrappedInBooleanQuery(searchContext, searchContext.query())) {
            List booleanClauses = ((BooleanQuery)query).clauses();
            if (!(((BooleanClause)booleanClauses.getFirst()).query() instanceof HybridQuery)) {
                throw new IllegalArgumentException("hybrid query must be a top level query and cannot be wrapped into other queries");
            }
            hybridQuery = (HybridQuery)((BooleanClause)booleanClauses.getFirst()).query();
        } else {
            hybridQuery = (HybridQuery)query;
        }
        return hybridQuery;
    }

    private static HybridQuery unwrapHybridQueryWrappedInSecurityDlsRules(BooleanQuery booleanQuery) {
        return booleanQuery.clauses().stream().map(BooleanClause::query).filter(clauseQuery -> clauseQuery instanceof HybridQuery).map(HybridQuery.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException("Given boolean query does not contain a HybridQuery clause"));
    }

    public static void validateHybridQuery(HybridQuery query) {
        for (Query innerQuery : query.getSubQueries()) {
            if (!(innerQuery instanceof HybridQuery)) continue;
            throw new IllegalArgumentException("hybrid query cannot be nested in another hybrid query");
        }
    }

    private static boolean hasNestedFieldOrNestedDocs(Query query, SearchContext searchContext) {
        return searchContext.mapperService().hasNested() && new NestedHelper(searchContext.mapperService()).mightMatchNestedDocs(query);
    }

    private static boolean isWrappedHybridQuery(Query query) {
        return query instanceof BooleanQuery && ((BooleanQuery)query).clauses().stream().anyMatch(clauseQuery -> clauseQuery.query() instanceof HybridQuery);
    }

    private static boolean hasAliasFilter(SearchContext searchContext) {
        return Objects.nonNull(searchContext.aliasFilter());
    }

    @Generated
    private HybridQueryUtil() {
    }
}

