/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDSASignatureAlgorithm;

public class ECDSASignInput {
    private final ECDSASignatureAlgorithm signatureAlgorithm;
    private final ByteBuffer signingKey;
    private final ByteBuffer message;

    protected ECDSASignInput(BuilderImpl builder) {
        this.signatureAlgorithm = builder.signatureAlgorithm();
        this.signingKey = builder.signingKey();
        this.message = builder.message();
    }

    public ECDSASignatureAlgorithm signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public ByteBuffer signingKey() {
        return this.signingKey;
    }

    public ByteBuffer message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ECDSASignatureAlgorithm signatureAlgorithm;
        protected ByteBuffer signingKey;
        protected ByteBuffer message;

        protected BuilderImpl() {
        }

        protected BuilderImpl(ECDSASignInput model) {
            this.signatureAlgorithm = model.signatureAlgorithm();
            this.signingKey = model.signingKey();
            this.message = model.message();
        }

        @Override
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        @Override
        public ECDSASignatureAlgorithm signatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        @Override
        public Builder signingKey(ByteBuffer signingKey) {
            this.signingKey = signingKey;
            return this;
        }

        @Override
        public ByteBuffer signingKey() {
            return this.signingKey;
        }

        @Override
        public Builder message(ByteBuffer message) {
            this.message = message;
            return this;
        }

        @Override
        public ByteBuffer message() {
            return this.message;
        }

        @Override
        public ECDSASignInput build() {
            if (Objects.isNull((Object)this.signatureAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `signatureAlgorithm`");
            }
            if (Objects.isNull(this.signingKey())) {
                throw new IllegalArgumentException("Missing value for required field `signingKey`");
            }
            if (Objects.isNull(this.message())) {
                throw new IllegalArgumentException("Missing value for required field `message`");
            }
            return new ECDSASignInput(this);
        }
    }

    public static interface Builder {
        public Builder signatureAlgorithm(ECDSASignatureAlgorithm var1);

        public ECDSASignatureAlgorithm signatureAlgorithm();

        public Builder signingKey(ByteBuffer var1);

        public ByteBuffer signingKey();

        public Builder message(ByteBuffer var1);

        public ByteBuffer message();

        public ECDSASignInput build();
    }
}

