/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.props;

import java.io.Reader;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.ConnectionPoolType;
import org.ldaptive.pool.PooledConnectionFactory;
import org.ldaptive.pool.SoftLimitConnectionPool;
import org.ldaptive.props.AbstractPropertySource;
import org.ldaptive.props.BlockingConnectionPoolPropertySource;
import org.ldaptive.props.PropertySource;

public final class PooledConnectionFactoryPropertySource
extends AbstractPropertySource<PooledConnectionFactory> {
    private ConnectionPoolType poolType = ConnectionPoolType.BLOCKING;

    public PooledConnectionFactoryPropertySource(PooledConnectionFactory cf) {
        this(cf, "classpath:/org/ldaptive/ldap.properties");
    }

    public PooledConnectionFactoryPropertySource(PooledConnectionFactory cf, String ... paths) {
        this(cf, PooledConnectionFactoryPropertySource.loadProperties(paths));
    }

    public PooledConnectionFactoryPropertySource(PooledConnectionFactory cf, Reader ... readers) {
        this(cf, PooledConnectionFactoryPropertySource.loadProperties(readers));
    }

    public PooledConnectionFactoryPropertySource(PooledConnectionFactory cf, Properties props) {
        this(cf, PropertySource.PropertyDomain.POOL, props);
    }

    public PooledConnectionFactoryPropertySource(PooledConnectionFactory cf, PropertySource.PropertyDomain domain, Properties props) {
        super(cf, domain, props);
    }

    public ConnectionPoolType getPoolType() {
        return this.poolType;
    }

    public void setPoolType(ConnectionPoolType pt) {
        this.poolType = pt;
    }

    @Override
    public void initialize() {
        BlockingConnectionPool cp;
        if (this.poolType == ConnectionPoolType.BLOCKING) {
            cp = new BlockingConnectionPool();
            BlockingConnectionPoolPropertySource cpPropSource = new BlockingConnectionPoolPropertySource(cp, this.propertiesDomain, this.properties);
            cpPropSource.initialize();
        } else if (this.poolType == ConnectionPoolType.SOFTLIMIT) {
            cp = new SoftLimitConnectionPool();
            BlockingConnectionPoolPropertySource cpPropSource = new BlockingConnectionPoolPropertySource((BlockingConnectionPool)((SoftLimitConnectionPool)cp), this.propertiesDomain, this.properties);
            cpPropSource.initialize();
        } else {
            throw new IllegalStateException("Unknown pool type: " + (Object)((Object)this.poolType));
        }
        cp.initialize();
        ((PooledConnectionFactory)this.object).setConnectionPool(cp);
    }

    public static Set<String> getProperties() {
        return Collections.emptySet();
    }
}

