/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.impl.pipenv.PathKt;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.FileContentUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.configuration.PyIntegratedToolsTestPanelCustomizer;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirementsTxt.PythonRequirementTxtSdkUtils;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import com.jetbrains.python.sdk.pipenv.PipenvCommandExecutorKt;
import com.jetbrains.python.testing.PyAbstractTestFactory;
import com.jetbrains.python.testing.settings.PyTestRunConfigurationRenderer;
import com.jetbrains.python.testing.settings.PyTestRunConfigurationsModel;
import com.jetbrains.python.ui.PyUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIntegratedToolsConfigurable
implements SearchableConfigurable {
    private JPanel myMainPanel;
    private JComboBox<PyAbstractTestFactory<?>> myTestRunnerComboBox;
    private JComboBox<DocStringFormat> myDocstringFormatComboBox;
    private PyTestRunConfigurationsModel myModel;
    private final PyPackageRequirementsSettings myPackagingSettings;
    @Nullable
    private final Module myModule;
    @NotNull
    private final Project myProject;
    private final PyDocumentationSettings myDocumentationSettings;
    private TextFieldWithBrowseButton myWorkDir;
    private JCheckBox txtIsRst;
    private JPanel myErrorPanel;
    private TextFieldWithBrowseButton myRequirementsPathField;
    private JCheckBox analyzeDoctest;
    private JPanel myDocStringsPanel;
    private JPanel myRestPanel;
    private JCheckBox renderExternal;
    private JPanel myPackagingPanel;
    private JPanel myTestsPanel;
    private TextFieldWithBrowseButton myPipEnvPathField;
    private JPanel myPipEnvPanel;
    @NotNull
    private final @NotNull Collection<@NotNull DialogPanel> myCustomizePanels;

    public PyIntegratedToolsConfigurable() {
        this(null, DefaultProjectFactory.getInstance().getDefaultProject());
    }

    public PyIntegratedToolsConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            PyIntegratedToolsConfigurable.$$$reportNull$$$0(0);
        }
        this(module2, module2.getProject());
    }

    private PyIntegratedToolsConfigurable(@Nullable Module module2, @NotNull Project project) {
        if (project == null) {
            PyIntegratedToolsConfigurable.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myCustomizePanels = PyIntegratedToolsTestPanelCustomizer.Companion.createPanels();
        this.myModule = module2;
        this.myProject = project;
        this.myDocumentationSettings = PyDocumentationSettings.getInstance((Module)this.myModule);
        this.myPackagingSettings = PyPackageRequirementsSettings.getInstance(module2);
        this.myDocstringFormatComboBox.setModel((ComboBoxModel<DocStringFormat>)new CollectionComboBoxModel(new ArrayList<DocStringFormat>(Arrays.asList(DocStringFormat.values())), (Object)this.myDocumentationSettings.getFormat()));
        this.myDocstringFormatComboBox.setRenderer((ListCellRenderer<DocStringFormat>)SimpleListCellRenderer.create((String)"", DocStringFormat::getName));
        this.myWorkDir.addBrowseFolderListener(this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(PyBundle.message("configurable.choose.working.directory", new Object[0])));
        ReSTService service = ReSTService.getInstance(this.myModule);
        this.myWorkDir.setText(service.getWorkdir());
        this.txtIsRst.setSelected(service.txtIsRst());
        this.analyzeDoctest.setSelected(this.myDocumentationSettings.isAnalyzeDoctest());
        this.renderExternal.setSelected(this.myDocumentationSettings.isRenderExternalDocumentation());
        this.myRequirementsPathField.addBrowseFolderListener(this.myProject, FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withTitle(PyBundle.message("configurable.choose.path.to.the.package.requirements.file", new Object[0])));
        this.myRequirementsPathField.setText(this.getRequirementsPath());
        this.myPipEnvPathField.addBrowseFolderListener(null, FileChooserDescriptorFactory.createSingleFileDescriptor());
        this.myDocStringsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PyBundle.message("integrated.tools.configurable.docstrings", new Object[0])));
        this.myRestPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PyBundle.message("integrated.tools.configurable.restructuredtext", new Object[0])));
        this.myPackagingPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PyBundle.message("integrated.tools.configurable.packaging", new Object[0])));
        this.myTestsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PyBundle.message("integrated.tools.configurable.testing", new Object[0])));
        this.myPipEnvPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PyBundle.message("integrated.tools.configurable.pipenv", new Object[0])));
    }

    @NotNull
    private String getRequirementsPath() {
        String path2;
        if (this.myModule == null) {
            return "";
        }
        Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)this.myModule);
        if (sdk2 == null) {
            return "";
        }
        SdkAdditionalData data = sdk2.getSdkAdditionalData();
        if (!(data instanceof PythonSdkAdditionalData)) {
            return "";
        }
        Path requiredTxtPath = ((PythonSdkAdditionalData)data).getRequiredTxtPath();
        String string = path2 = requiredTxtPath != null ? requiredTxtPath.toString() : "";
        if (string == null) {
            PyIntegratedToolsConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private void setRequirementsPath(String requirementsPath) {
        if (this.myModule == null) {
            return;
        }
        Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)this.myModule);
        if (sdk2 == null) {
            return;
        }
        try {
            PythonRequirementTxtSdkUtils.saveRequirementsTxtPath(this.myModule.getProject(), sdk2, Path.of(requirementsPath, new String[0]));
        }
        catch (Throwable t) {
            Logger.getInstance(PyIntegratedToolsConfigurable.class).warn("Failed to save requirements path", t);
        }
    }

    private void initErrorValidation() {
        final FacetErrorPanel facetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)facetErrorPanel.getComponent(), "Center");
        facetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                PyAbstractTestFactory factory;
                Sdk sdk2 = PythonSdkUtil.findPythonSdk((Module)PyIntegratedToolsConfigurable.this.myModule);
                if (sdk2 != null && (factory = (PyAbstractTestFactory)((Object)PyIntegratedToolsConfigurable.this.myModel.getSelected())) != null && !factory.isFrameworkInstalled(PyIntegratedToolsConfigurable.this.myProject, sdk2)) {
                    return new ValidationResult(PyBundle.message("runcfg.testing.no.test.framework", factory.getName()), PyIntegratedToolsConfigurable.this.createQuickFix(sdk2, facetErrorPanel, factory.getPackageRequired()));
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PyIntegratedToolsConfigurable$1", "check"));
            }
        }, new JComponent[]{this.myTestRunnerComboBox});
        facetErrorPanel.getValidatorsManager().validate();
    }

    private FacetConfigurationQuickFix createQuickFix(final Sdk sdk2, final FacetErrorPanel facetErrorPanel, final String name2) {
        return new FacetConfigurationQuickFix(){

            public void run(JComponent place) {
                PyPackageManagerUI ui = new PyPackageManagerUI(PyIntegratedToolsConfigurable.this.myProject, sdk2, new PyPackageManagerUI.Listener(){

                    @Override
                    public void started() {
                    }

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        if (exceptions.isEmpty()) {
                            facetErrorPanel.getValidatorsManager().validate();
                        }
                    }
                });
                ui.install(Collections.singletonList(PyRequirementsKt.pyRequirement((String)name2, null)), Collections.emptyList());
            }
        };
    }

    @Nls
    public String getDisplayName() {
        return PyBundle.message("configurable.PyIntegratedToolsConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "test_runner_configuration";
    }

    public JComponent createComponent() {
        this.myModel = PyTestRunConfigurationsModel.Companion.create(this.myModule);
        if (this.myModule != null) {
            Project project = this.myModule.getProject();
            this.myTestRunnerComboBox.setRenderer(new PyTestRunConfigurationRenderer(PythonSdkUtil.findPythonSdk((Module)this.myModule), project));
        }
        for (DialogPanel panel2 : this.myCustomizePanels) {
            this.myTestsPanel.add("Last", (Component)panel2);
        }
        this.updateConfigurations();
        this.initErrorValidation();
        JBScrollPane pane = new JBScrollPane((Component)this.myMainPanel);
        pane.setViewportBorder((Border)JBUI.Borders.empty());
        pane.setBorder((Border)JBUI.Borders.empty());
        return pane;
    }

    private void updateConfigurations() {
        this.myTestRunnerComboBox.setModel((ComboBoxModel<PyAbstractTestFactory<?>>)((Object)this.myModel));
    }

    public boolean isModified() {
        if (!Objects.equals(this.myTestRunnerComboBox.getSelectedItem(), this.myModel.getTestRunner())) {
            return true;
        }
        if (this.myDocstringFormatComboBox.getSelectedItem() != this.myDocumentationSettings.getFormat()) {
            return true;
        }
        if (this.analyzeDoctest.isSelected() != this.myDocumentationSettings.isAnalyzeDoctest()) {
            return true;
        }
        if (this.renderExternal.isSelected() != this.myDocumentationSettings.isRenderExternalDocumentation()) {
            return true;
        }
        if (!ReSTService.getInstance(this.myModule).getWorkdir().equals(this.myWorkDir.getText())) {
            return true;
        }
        if (!ReSTService.getInstance(this.myModule).txtIsRst() == this.txtIsRst.isSelected()) {
            return true;
        }
        if (!this.getRequirementsPath().equals(this.myRequirementsPathField.getText())) {
            return true;
        }
        if (!this.myPipEnvPathField.getText().equals(StringUtil.notNullize((String)PathKt.getPipenvPath((PropertiesComponent)PropertiesComponent.getInstance())))) {
            return true;
        }
        return ContainerUtil.exists(this.myCustomizePanels, panel2 -> panel2.isModified());
    }

    public void apply() throws ConfigurationException {
        if (this.myDocstringFormatComboBox.getSelectedItem() != this.myDocumentationSettings.getFormat()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart((Object)this);
        }
        if (this.analyzeDoctest.isSelected() != this.myDocumentationSettings.isAnalyzeDoctest()) {
            ArrayList files = new ArrayList();
            ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().iterateContent(fileOrDir -> {
                if (!fileOrDir.isDirectory() && PythonFileType.INSTANCE.getDefaultExtension().equals(fileOrDir.getExtension())) {
                    files.add(fileOrDir);
                }
                return true;
            });
            FileContentUtil.reparseFiles((Project)this.myProject, (Collection)Lists.newArrayList(files), (boolean)false);
        }
        this.myModel.apply();
        this.myDocumentationSettings.setRenderExternalDocumentation(this.renderExternal.isSelected());
        this.myDocumentationSettings.setFormat((DocStringFormat)this.myDocstringFormatComboBox.getSelectedItem());
        ReSTService reSTService = ReSTService.getInstance(this.myModule);
        reSTService.setWorkdir(this.myWorkDir.getText());
        if (this.txtIsRst.isSelected() != reSTService.txtIsRst()) {
            reSTService.setTxtIsRst(this.txtIsRst.isSelected());
            this.reparseFiles(Collections.singletonList(PlainTextFileType.INSTANCE.getDefaultExtension()));
        }
        this.myDocumentationSettings.setAnalyzeDoctest(this.analyzeDoctest.isSelected());
        this.setRequirementsPath(this.myRequirementsPathField.getText());
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart((Object)this);
        PathKt.setPipenvPath((PropertiesComponent)PropertiesComponent.getInstance(), (String)StringUtil.nullize((String)this.myPipEnvPathField.getText()));
        for (DialogPanel panel2 : this.myCustomizePanels) {
            panel2.apply();
        }
    }

    public void reparseFiles(List<String> extensions) {
        ArrayList filesToReparse = new ArrayList();
        ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().iterateContent(fileOrDir -> {
            if (!fileOrDir.isDirectory() && extensions.contains(fileOrDir.getExtension())) {
                filesToReparse.add(fileOrDir);
            }
            return true;
        });
        FileContentUtilCore.reparseFiles(filesToReparse);
        PyUiUtil.rehighlightOpenEditors(this.myProject);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart((Object)this);
    }

    public void reset() {
        this.myTestRunnerComboBox.setSelectedItem(this.myModel.getTestRunner());
        this.myTestRunnerComboBox.repaint();
        this.myModel.reset();
        this.myDocstringFormatComboBox.setSelectedItem(this.myDocumentationSettings.getFormat());
        this.myWorkDir.setText(ReSTService.getInstance(this.myModule).getWorkdir());
        this.txtIsRst.setSelected(ReSTService.getInstance(this.myModule).txtIsRst());
        this.analyzeDoctest.setSelected(this.myDocumentationSettings.isAnalyzeDoctest());
        this.renderExternal.setSelected(this.myDocumentationSettings.isRenderExternalDocumentation());
        this.myRequirementsPathField.setText(this.getRequirementsPath());
        JBTextField pipEnvText = (JBTextField)ObjectUtils.tryCast((Object)this.myPipEnvPathField.getTextField(), JBTextField.class);
        if (pipEnvText != null) {
            String savedPath = PathKt.getPipenvPath((PropertiesComponent)PropertiesComponent.getInstance());
            if (savedPath != null) {
                pipEnvText.setText(savedPath);
            } else {
                Path executable = PipenvCommandExecutorKt.detectPipEnvExecutableOrNull();
                if (executable != null) {
                    pipEnvText.getEmptyText().setText(PyBundle.message("configurable.pipenv.auto.detected", executable.toString()));
                }
            }
        }
        for (DialogPanel panel2 : this.myCustomizePanels) {
            panel2.reset();
        }
    }

    @NotNull
    public String getId() {
        return "PyIntegratedToolsConfigurable";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyIntegratedToolsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyIntegratedToolsConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirementsPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel3;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel4;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.myMainPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel7.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myErrorPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDocStringsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel5, new GridConstraints(3, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.docstring.format"));
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myDocstringFormatComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.analyzeDoctest = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.analyze.python.code.in.docstrings"));
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.renderExternal = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.render.external.documentation.for.stdlib"));
        jPanel5.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRestPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel4, new GridConstraints(5, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.sphinx.working.directory"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkDir = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.txtIsRst = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.treat.txt.files.as.restructuredtext"));
        jPanel4.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPackagingPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.package.requirements.file"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRequirementsPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTestsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.default.test.runner"));
        jPanel2.add((Component)jLabel, "West");
        JComboBox jComboBox2 = new JComboBox();
        this.myTestRunnerComboBox = jComboBox2;
        jPanel2.add(jComboBox2, "Center");
        this.myPipEnvPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/PyBundle", PyIntegratedToolsConfigurable.class).getString("form.integrated.tools.path.to.pipenv.executable"));
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPipEnvPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jBLabel.setLabelFor(jComboBox);
        jBLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

