/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitActivity;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.GitResetDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitResetHead
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.message("reset.action.name", new Object[0]);
        if (string == null) {
            GitResetHead.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitResetDialog d;
        if (project == null) {
            GitResetHead.$$$reportNull$$$0(1);
        }
        if (gitRoots == null) {
            GitResetHead.$$$reportNull$$$0(2);
        }
        if (defaultRoot == null) {
            GitResetHead.$$$reportNull$$$0(3);
        }
        if (!(d = new GitResetDialog(project, gitRoots, defaultRoot)).showAndGet()) {
            return;
        }
        new Task.Backgroundable(this, project, GitBundle.message("resetting.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try (AccessToken ignored = DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("activity.name.reset", new Object[0]), (ActivityId)GitActivity.Reset);){
                    GitCommandResult result2 = Git.getInstance().runCommand(d.handler());
                    if (!result2.success()) {
                        VcsNotifier.getInstance((Project)project).notifyError("git.reset.failed", GitBundle.message("resetting.title", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                    }
                    GitRepositoryManager.getInstance(project).updateRepository(d.getGitRoot());
                    GitUtil.refreshVfsInRoot(d.getGitRoot());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitResetHead$1", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitResetHead";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitResetHead";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

