/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.AccessedParameters;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.tree.Tree;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;

public class TreeCache<T> {
    private final String debugName;
    private final Function<Tree, T> compute;

    public TreeCache(String debugName, Function<Tree, T> compute) {
        this.debugName = debugName;
        this.compute = compute;
    }

    protected boolean dependsOnlyOnStructure() {
        return false;
    }

    public String toString() {
        return this.debugName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CachedData<T> compute(Tree tree) {
        Set accessed;
        T value;
        AccessedParameters token = AccessedParameters.start();
        token.ruleId = this.debugName;
        try {
            value = this.compute.apply(tree);
        }
        finally {
            Map<String, Set<Parameter>> finish = token.finish();
            accessed = (Set)StreamEx.of(finish.values()).flatCollection(Function.identity()).toCollection(LinkedHashSet::new);
        }
        return new CachedData<T>(value, accessed);
    }

    record CachedData<T>(T value, Set<Parameter> accessedParameters) {
        private final T value;

        private void markUsed() {
            AccessedParameters current = AccessedParameters.current();
            if (current != null) {
                for (Parameter parameter : this.accessedParameters) {
                    current.accessed(parameter);
                }
            }
        }

        public T value() {
            if (!this.accessedParameters.isEmpty()) {
                this.markUsed();
            }
            return this.value;
        }
    }
}

