# The PEP 484 type hints stub file for the QtMultimediaWidgets module.
#
# Generated by SIP 6.15.0
#
# Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt5.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtNetwork
from PyQt5 import QtMultimedia
from PyQt5 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QVideoWidget(QtWidgets.QWidget, QtMultimedia.QMediaBindableInterface):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def videoSurface(self) -> QtMultimedia.QAbstractVideoSurface|None: ...
    def setMediaObject(self, object: QtMultimedia.QMediaObject|None) -> bool: ...
    def paintEvent(self, event: QtGui.QPaintEvent|None) -> None: ...
    def moveEvent(self, event: QtGui.QMoveEvent|None) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent|None) -> None: ...
    def hideEvent(self, event: QtGui.QHideEvent|None) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent|None) -> None: ...
    def event(self, event: QtCore.QEvent|None) -> bool: ...
    saturationChanged: typing.ClassVar[QtCore.pyqtSignal]
    hueChanged: typing.ClassVar[QtCore.pyqtSignal]
    contrastChanged: typing.ClassVar[QtCore.pyqtSignal]
    brightnessChanged: typing.ClassVar[QtCore.pyqtSignal]
    fullScreenChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSaturation(self, saturation: int) -> None: ...
    def setHue(self, hue: int) -> None: ...
    def setContrast(self, contrast: int) -> None: ...
    def setBrightness(self, brightness: int) -> None: ...
    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None: ...
    def setFullScreen(self, fullScreen: bool) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def saturation(self) -> int: ...
    def hue(self) -> int: ...
    def contrast(self) -> int: ...
    def brightness(self) -> int: ...
    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode: ...
    def mediaObject(self) -> QtMultimedia.QMediaObject|None: ...


class QCameraViewfinder(QVideoWidget):

    def __init__(self, parent: QtWidgets.QWidget|None = ...) -> None: ...

    def setMediaObject(self, object: QtMultimedia.QMediaObject|None) -> bool: ...
    def mediaObject(self) -> QtMultimedia.QMediaObject|None: ...


class QGraphicsVideoItem(QtWidgets.QGraphicsObject, QtMultimedia.QMediaBindableInterface):

    def __init__(self, parent: QtWidgets.QGraphicsItem|None = ...) -> None: ...

    def videoSurface(self) -> QtMultimedia.QAbstractVideoSurface|None: ...
    def setMediaObject(self, object: QtMultimedia.QMediaObject|None) -> bool: ...
    def itemChange(self, change: QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def timerEvent(self, event: QtCore.QTimerEvent|None) -> None: ...
    nativeSizeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def paint(self, painter: QtGui.QPainter|None, option: QtWidgets.QStyleOptionGraphicsItem|None, widget: QtWidgets.QWidget|None = ...) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def nativeSize(self) -> QtCore.QSizeF: ...
    def setSize(self, size: QtCore.QSizeF) -> None: ...
    def size(self) -> QtCore.QSizeF: ...
    def setOffset(self, offset: QtCore.QPointF|QtCore.QPoint) -> None: ...
    def offset(self) -> QtCore.QPointF: ...
    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None: ...
    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode: ...
    def mediaObject(self) -> QtMultimedia.QMediaObject|None: ...


class QVideoWidgetControl(QtMultimedia.QMediaControl):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    saturationChanged: typing.ClassVar[QtCore.pyqtSignal]
    hueChanged: typing.ClassVar[QtCore.pyqtSignal]
    contrastChanged: typing.ClassVar[QtCore.pyqtSignal]
    brightnessChanged: typing.ClassVar[QtCore.pyqtSignal]
    fullScreenChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSaturation(self, saturation: int) -> None: ...
    def saturation(self) -> int: ...
    def setHue(self, hue: int) -> None: ...
    def hue(self) -> int: ...
    def setContrast(self, contrast: int) -> None: ...
    def contrast(self) -> int: ...
    def setBrightness(self, brightness: int) -> None: ...
    def brightness(self) -> int: ...
    def setFullScreen(self, fullScreen: bool) -> None: ...
    def isFullScreen(self) -> bool: ...
    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None: ...
    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode: ...
    def videoWidget(self) -> QtWidgets.QWidget|None: ...
