/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bool;

import com.oracle.graal.python.builtins.objects.bool.BoolBuiltins;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonIntegerTypesGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.VarHandle;
import java.util.List;
import java.util.Objects;

@GeneratedBy(value=BoolBuiltins.class)
public final class BoolBuiltinsFactory {
    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return List.of(BoolNodeFactory.getInstance(), StrNodeFactory.getInstance(), RepNodeFactory.getInstance(), AndNodeFactory.getInstance(), OrNodeFactory.getInstance(), XorNodeFactory.getInstance());
    }

    @GeneratedBy(value=BoolBuiltins.BoolNode.class)
    public static final class BoolNodeFactory
    implements NodeFactory<BoolBuiltins.BoolNode> {
        private static final BoolNodeFactory BOOL_NODE_FACTORY_INSTANCE = new BoolNodeFactory();

        private BoolNodeFactory() {
        }

        public Class<BoolBuiltins.BoolNode> getNodeClass() {
            return BoolBuiltins.BoolNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public BoolBuiltins.BoolNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return BoolNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<BoolBuiltins.BoolNode> getInstance() {
            return BOOL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolBuiltins.BoolNode create() {
            return new BoolNodeGen();
        }

        @GeneratedBy(value=BoolBuiltins.BoolNode.class)
        public static final class BoolNodeGen
        extends BoolBuiltins.BoolNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private PyObjectIsTrueNode isTrue_;

            private BoolNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                PyObjectIsTrueNode isTrue__;
                int state_0 = this.state_0_;
                if (state_0 != 0 && (isTrue__ = this.isTrue_) != null) {
                    return BoolBuiltins.BoolNode.bool(frameValue, arg0Value, arg1Value, isTrue__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                PyObjectIsTrueNode isTrue__ = (PyObjectIsTrueNode)this.insert(PyObjectIsTrueNode.create());
                Objects.requireNonNull(isTrue__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.isTrue_ = isTrue__;
                this.state_0_ = state_0 |= 1;
                return BoolBuiltins.BoolNode.bool(frameValue, arg0Value, arg1Value, isTrue__);
            }
        }
    }

    @GeneratedBy(value=BoolBuiltins.StrNode.class)
    static final class StrNodeFactory
    implements NodeFactory<BoolBuiltins.StrNode> {
        private static final StrNodeFactory STR_NODE_FACTORY_INSTANCE = new StrNodeFactory();

        private StrNodeFactory() {
        }

        public Class<BoolBuiltins.StrNode> getNodeClass() {
            return BoolBuiltins.StrNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public BoolBuiltins.StrNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return StrNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<BoolBuiltins.StrNode> getInstance() {
            return STR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolBuiltins.StrNode create() {
            return new StrNodeGen();
        }

        @GeneratedBy(value=BoolBuiltins.StrNode.class)
        static final class StrNodeGen
        extends BoolBuiltins.StrNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private StrNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return BoolBuiltins.StrNode.doBoolean(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x38) >>> 3, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x38) >>> 3, arg0Value);
                        return BoolBuiltins.StrNode.doLong(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return BoolBuiltins.StrNode.doPInt(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return BoolBuiltins.StrNode.doBoolean(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 3;
                    this.state_0_ = state_0 |= 2;
                    return BoolBuiltins.StrNode.doLong(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return BoolBuiltins.StrNode.doPInt(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=BoolBuiltins.RepNode.class)
    static final class RepNodeFactory
    implements NodeFactory<BoolBuiltins.RepNode> {
        private static final RepNodeFactory REP_NODE_FACTORY_INSTANCE = new RepNodeFactory();

        private RepNodeFactory() {
        }

        public Class<BoolBuiltins.RepNode> getNodeClass() {
            return BoolBuiltins.RepNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public BoolBuiltins.RepNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return RepNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<BoolBuiltins.RepNode> getInstance() {
            return REP_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolBuiltins.RepNode create() {
            return new RepNodeGen();
        }

        @GeneratedBy(value=BoolBuiltins.RepNode.class)
        static final class RepNodeGen
        extends BoolBuiltins.RepNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            private RepNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        return BoolBuiltins.StrNode.doBoolean(arg0Value_);
                    }
                    if ((state_0 & 2) != 0 && PythonIntegerTypesGen.isImplicitLong((state_0 & 0x38) >>> 3, arg0Value)) {
                        long arg0Value_ = PythonIntegerTypesGen.asImplicitLong((state_0 & 0x38) >>> 3, arg0Value);
                        return BoolBuiltins.StrNode.doLong(arg0Value_);
                    }
                    if ((state_0 & 4) != 0 && arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt)arg0Value;
                        return BoolBuiltins.StrNode.doPInt(arg0Value_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    this.state_0_ = state_0 |= 1;
                    return BoolBuiltins.StrNode.doBoolean(arg0Value_);
                }
                int longCast0 = PythonIntegerTypesGen.specializeImplicitLong(arg0Value);
                if (longCast0 != 0) {
                    long arg0Value_ = PythonIntegerTypesGen.asImplicitLong(longCast0, arg0Value);
                    state_0 |= longCast0 << 3;
                    this.state_0_ = state_0 |= 2;
                    return BoolBuiltins.StrNode.doLong(arg0Value_);
                }
                if (arg0Value instanceof PInt) {
                    PInt arg0Value_ = (PInt)arg0Value;
                    this.state_0_ = state_0 |= 4;
                    return BoolBuiltins.StrNode.doPInt(arg0Value_);
                }
                throw new UnsupportedSpecializationException((Node)this, null, new Object[]{arg0Value});
            }
        }
    }

    @GeneratedBy(value=BoolBuiltins.AndNode.class)
    static final class AndNodeFactory
    implements NodeFactory<BoolBuiltins.AndNode> {
        private static final AndNodeFactory AND_NODE_FACTORY_INSTANCE = new AndNodeFactory();

        private AndNodeFactory() {
        }

        public Class<BoolBuiltins.AndNode> getNodeClass() {
            return BoolBuiltins.AndNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public BoolBuiltins.AndNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return AndNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<BoolBuiltins.AndNode> getInstance() {
            return AND_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolBuiltins.AndNode create() {
            return new AndNodeGen();
        }

        @GeneratedBy(value=BoolBuiltins.AndNode.class)
        static final class AndNodeGen
        extends BoolBuiltins.AndNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IntBuiltins.AndNode fallback_andNode_;

            private AndNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg0Value instanceof Boolean) || !(arg1Value instanceof Boolean);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    IntBuiltins.AndNode andNode__;
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        if (arg1Value instanceof Boolean) {
                            boolean arg1Value_ = (Boolean)arg1Value;
                            return BoolBuiltins.AndNode.doBool(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 2) != 0 && (andNode__ = this.fallback_andNode_) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return BoolBuiltins.AndNode.doOther(frameValue, arg0Value, arg1Value, andNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (Boolean)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        return BoolBuiltins.AndNode.doBool(arg0Value_, arg1Value_);
                    }
                }
                IntBuiltins.AndNode andNode__ = (IntBuiltins.AndNode)this.insert(IntBuiltins.AndNode.create());
                Objects.requireNonNull(andNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_andNode_ = andNode__;
                this.state_0_ = state_0 |= 2;
                return BoolBuiltins.AndNode.doOther(frameValue, arg0Value, arg1Value, andNode__);
            }
        }
    }

    @GeneratedBy(value=BoolBuiltins.OrNode.class)
    static final class OrNodeFactory
    implements NodeFactory<BoolBuiltins.OrNode> {
        private static final OrNodeFactory OR_NODE_FACTORY_INSTANCE = new OrNodeFactory();

        private OrNodeFactory() {
        }

        public Class<BoolBuiltins.OrNode> getNodeClass() {
            return BoolBuiltins.OrNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public BoolBuiltins.OrNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return OrNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<BoolBuiltins.OrNode> getInstance() {
            return OR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolBuiltins.OrNode create() {
            return new OrNodeGen();
        }

        @GeneratedBy(value=BoolBuiltins.OrNode.class)
        static final class OrNodeGen
        extends BoolBuiltins.OrNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IntBuiltins.OrNode fallback_orNode_;

            private OrNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg0Value instanceof Boolean) || !(arg1Value instanceof Boolean);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    IntBuiltins.OrNode orNode__;
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        if (arg1Value instanceof Boolean) {
                            boolean arg1Value_ = (Boolean)arg1Value;
                            return BoolBuiltins.OrNode.doBool(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 2) != 0 && (orNode__ = this.fallback_orNode_) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return BoolBuiltins.OrNode.doOther(frameValue, arg0Value, arg1Value, orNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (Boolean)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        return BoolBuiltins.OrNode.doBool(arg0Value_, arg1Value_);
                    }
                }
                IntBuiltins.OrNode orNode__ = (IntBuiltins.OrNode)this.insert(IntBuiltins.OrNode.create());
                Objects.requireNonNull(orNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_orNode_ = orNode__;
                this.state_0_ = state_0 |= 2;
                return BoolBuiltins.OrNode.doOther(frameValue, arg0Value, arg1Value, orNode__);
            }
        }
    }

    @GeneratedBy(value=BoolBuiltins.XorNode.class)
    static final class XorNodeFactory
    implements NodeFactory<BoolBuiltins.XorNode> {
        private static final XorNodeFactory XOR_NODE_FACTORY_INSTANCE = new XorNodeFactory();

        private XorNodeFactory() {
        }

        public Class<BoolBuiltins.XorNode> getNodeClass() {
            return BoolBuiltins.XorNode.class;
        }

        public List<Class<? extends Node>> getExecutionSignature() {
            return List.of(Node.class, Node.class);
        }

        public List<List<Class<?>>> getNodeSignatures() {
            return List.of(List.of());
        }

        public BoolBuiltins.XorNode createNode(Object ... arguments) {
            if (arguments.length == 0) {
                return XorNodeFactory.create();
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        static NodeFactory<BoolBuiltins.XorNode> getInstance() {
            return XOR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolBuiltins.XorNode create() {
            return new XorNodeGen();
        }

        @GeneratedBy(value=BoolBuiltins.XorNode.class)
        static final class XorNodeGen
        extends BoolBuiltins.XorNode {
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private IntBuiltins.XorNode fallback_xorNode_;

            private XorNodeGen() {
            }

            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg0Value instanceof Boolean) || !(arg1Value instanceof Boolean);
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    IntBuiltins.XorNode xorNode__;
                    if ((state_0 & 1) != 0 && arg0Value instanceof Boolean) {
                        boolean arg0Value_ = (Boolean)arg0Value;
                        if (arg1Value instanceof Boolean) {
                            boolean arg1Value_ = (Boolean)arg1Value;
                            return BoolBuiltins.XorNode.doBool(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 2) != 0 && (xorNode__ = this.fallback_xorNode_) != null && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return BoolBuiltins.XorNode.doOther(frameValue, arg0Value, arg1Value, xorNode__);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof Boolean) {
                    boolean arg0Value_ = (Boolean)arg0Value;
                    if (arg1Value instanceof Boolean) {
                        boolean arg1Value_ = (Boolean)arg1Value;
                        this.state_0_ = state_0 |= 1;
                        return BoolBuiltins.XorNode.doBool(arg0Value_, arg1Value_);
                    }
                }
                IntBuiltins.XorNode xorNode__ = (IntBuiltins.XorNode)this.insert(IntBuiltins.XorNode.create());
                Objects.requireNonNull(xorNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.fallback_xorNode_ = xorNode__;
                this.state_0_ = state_0 |= 2;
                return BoolBuiltins.XorNode.doOther(frameValue, arg0Value, arg1Value, xorNode__);
            }
        }
    }
}

