/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin.utils;

import com.amazon.redshift.logger.RedshiftLogger;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public class RequestUtils {
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    private static final String HTTP_USE_PROXY = "http.useProxy";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";

    private RequestUtils() {
    }

    public static StsClient buildSts(String stsEndpoint, String region, StsClientBuilder stsClientBuilder, AwsCredentialsProvider p, RedshiftLogger log) throws Exception {
        StsClient stsSvc;
        ProxyConfiguration proxyConfig = RequestUtils.getProxyConfiguration(log);
        if (proxyConfig != null) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
            httpClientBuilder.proxyConfiguration(proxyConfig);
            stsClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        }
        if (RequestUtils.isCustomStsEndpointUrl(stsEndpoint)) {
            stsSvc = (StsClient)((StsClientBuilder)((StsClientBuilder)stsClientBuilder.credentialsProvider(p)).endpointOverride(URI.create(stsEndpoint))).build();
        } else {
            stsClientBuilder.region(Region.of((String)region));
            stsSvc = (StsClient)((StsClientBuilder)stsClientBuilder.credentialsProvider(p)).build();
        }
        return stsSvc;
    }

    public static ProxyConfiguration getProxyConfiguration(RedshiftLogger log) {
        boolean useProxy;
        block8: {
            useProxy = false;
            try {
                String useProxyStr = System.getProperty(HTTP_USE_PROXY);
                if (useProxyStr != null) {
                    useProxy = Boolean.parseBoolean(useProxyStr);
                }
            }
            catch (Exception ex) {
                if (!RedshiftLogger.isEnable()) break block8;
                log.logError(ex);
            }
        }
        if (!useProxy) {
            if (RedshiftLogger.isEnable()) {
                log.logDebug(String.format("useProxy: %s", useProxy), new Object[0]);
            }
            return null;
        }
        String proxyHost = System.getProperty(HTTPS_PROXY_HOST);
        String proxyPort = System.getProperty(HTTPS_PROXY_PORT);
        String nonProxyHostsStr = System.getProperty(HTTP_NON_PROXY_HOSTS);
        Set nonProxyHosts = Collections.emptySet();
        if (nonProxyHostsStr != null && !nonProxyHostsStr.isEmpty()) {
            nonProxyHosts = Arrays.stream(nonProxyHostsStr.split("\\|")).collect(Collectors.toSet());
        }
        if (RedshiftLogger.isEnable()) {
            log.logDebug(String.format("useProxy: %s proxyHost: %s proxyPort:%s nonProxyHosts:%s", useProxy, proxyHost, proxyPort, nonProxyHosts), new Object[0]);
        }
        if (proxyHost == null || proxyPort == null) {
            return null;
        }
        return (ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create("https://" + proxyHost + ":" + proxyPort)).nonProxyHosts(nonProxyHosts).build();
    }

    private static boolean isCustomStsEndpointUrl(String stsEndpoint) throws Exception {
        boolean isCustomStsEndPoint = false;
        if (stsEndpoint != null && !stsEndpoint.isEmpty()) {
            URL aUrl = new URL(stsEndpoint);
            String protocol = aUrl.getProtocol();
            if (protocol != null && protocol.equals(HTTPS_PROTOCOL)) {
                isCustomStsEndPoint = true;
            } else {
                throw new Exception("Only https STS URL is supported:" + stsEndpoint);
            }
        }
        return isCustomStsEndPoint;
    }

    public static boolean isCredentialExpired(Date expiryTime) {
        return expiryTime == null || expiryTime.before(new Date(System.currentTimeMillis() + 60000L));
    }

    public static boolean isCredentialExpired(Instant expiryTime) {
        return expiryTime == null || expiryTime.isBefore(Instant.now().plusSeconds(60L));
    }
}

