/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.enumerate;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.enumerate.EnumerateBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.enumerate.EnumerateBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.enumerate.PEnumerate;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PEnumerate})
public final class EnumerateBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = EnumerateBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return EnumerateBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PEnumerate self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile bigIntIndexProfile, @Cached GetClassNode getClassNode) {
            Object iterator = self.getDecoratedIterator();
            Object index = self.getIndex(inliningTarget, bigIntIndexProfile);
            PTuple contents = PFactory.createTuple(language, new Object[]{iterator, index});
            return PFactory.createTuple(language, new Object[]{getClassNode.execute(inliningTarget, self), contents});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doGeneric(PEnumerate self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object doNext(VirtualFrame frame, PEnumerate self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile bigIntIndexProfile, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext) {
            Object index = self.getAndIncrementIndex(inliningTarget, language, bigIntIndexProfile);
            Object it = self.getDecoratedIterator();
            Object nextValue = callIterNext.execute(frame, inliningTarget, getSlots.execute(inliningTarget, it).tp_iternext(), it);
            return PFactory.createTuple(language, new Object[]{index, nextValue});
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="enumerate", minNumOfPositionalArgs=2, parameterNames={"cls", "iterable", "start"})
    @GenerateNodeFactory
    public static abstract class EnumerateNode
    extends PythonBuiltinNode {
        @Specialization
        static PEnumerate doNone(VirtualFrame frame, Object cls, Object iterable, PNone keywordArg, @Bind Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createEnumerate(language, cls, getInstanceShape.execute(cls), getIter.execute((Frame)frame, inliningTarget, iterable), 0L);
        }

        @Specialization
        static PEnumerate doInt(VirtualFrame frame, Object cls, Object iterable, int start, @Bind Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createEnumerate(language, cls, getInstanceShape.execute(cls), getIter.execute((Frame)frame, inliningTarget, iterable), start);
        }

        @Specialization
        static PEnumerate doLong(VirtualFrame frame, Object cls, Object iterable, long start, @Bind Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createEnumerate(language, cls, getInstanceShape.execute(cls), getIter.execute((Frame)frame, inliningTarget, iterable), start);
        }

        @Specialization
        static PEnumerate doPInt(VirtualFrame frame, Object cls, Object iterable, PInt start, @Bind Node inliningTarget, @Cached.Shared(value="getIter") @Cached PyObjectGetIter getIter, @Bind PythonLanguage language, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return PFactory.createEnumerate(language, cls, getInstanceShape.execute(cls), getIter.execute((Frame)frame, inliningTarget, iterable), start);
        }

        static boolean isIntegerIndex(Object idx) {
            return PGuards.isInteger(idx) || idx instanceof PInt;
        }

        @Specialization(guards={"!isIntegerIndex(start)"})
        static void enumerate(Object cls, Object iterable, Object start, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, start);
        }
    }
}

