/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.js.api.PromiseLibrary;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=PromiseLibrary.class)
final class PromiseLibraryGen
extends LibraryFactory<PromiseLibrary> {
    private static final Class<PromiseLibrary> LIBRARY_CLASS = PromiseLibraryGen.lazyLibraryClass();
    private static final Message IS_PROMISE = new MessageImpl("isPromise", 0, false, Boolean.TYPE, Object.class);
    private static final Message GET_STATE = new MessageImpl("getState", 1, false, PromiseLibrary.State.class, Object.class);
    private static final Message MARK_HANDLED = new MessageImpl("markHandled", 2, false, Void.TYPE, Object.class);
    private static final PromiseLibraryGen INSTANCE = new PromiseLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private PromiseLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_PROMISE, GET_STATE, MARK_HANDLED));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return PromiseLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected PromiseLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected PromiseLibrary createDelegate(PromiseLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        PromiseLibrary lib = (PromiseLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isPromise(receiver);
            }
            case 1: {
                return lib.getState(receiver);
            }
            case 2: {
                lib.markHandled(receiver);
                return null;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected PromiseLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected PromiseLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<PromiseLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.js.api.PromiseLibrary", false, PromiseLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static final class Proxy
    extends PromiseLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPromise(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_PROMISE, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public PromiseLibrary.State getState(Object receiver_) throws UnsupportedMessageException {
            try {
                return (PromiseLibrary.State)((Object)this.lib.send(receiver_, GET_STATE, new Object[0]));
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            try {
                this.lib.send(receiver_, MARK_HANDLED, new Object[0]);
                return;
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static final class Delegate
    extends PromiseLibrary {
        @Node.Child
        private PromiseLibrary delegateLibrary;

        Delegate(PromiseLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPromise(Object receiver_) {
            if (PromiseLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = PromiseLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PromiseLibrary)PromiseLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isPromise(delegate);
            }
            return this.delegateLibrary.isPromise(receiver_);
        }

        @Override
        public PromiseLibrary.State getState(Object receiver_) throws UnsupportedMessageException {
            if (PromiseLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = PromiseLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((PromiseLibrary)PromiseLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).getState(delegate);
            }
            return this.delegateLibrary.getState(receiver_);
        }

        @Override
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            if (PromiseLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = PromiseLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((PromiseLibrary)PromiseLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).markHandled(delegate);
                return;
            }
            this.delegateLibrary.markHandled(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch {
        private final int limit_;

        CachedDispatchFirst(PromiseLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static abstract class CachedDispatch
    extends PromiseLibrary {
        @Node.Child
        PromiseLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(PromiseLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @Override
        @ExplodeLoop
        public boolean isPromise(Object receiver_) {
            while (true) {
                CachedDispatch current = this;
                do {
                    PromiseLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isPromise(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public PromiseLibrary.State getState(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PromiseLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.getState(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            while (true) {
                CachedDispatch current = this;
                do {
                    PromiseLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.markHandled(receiver_);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                PromiseLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (PromiseLibrary)this.insert((Node)((PromiseLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        PromiseLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (PromiseLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((PromiseLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends PromiseLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPromise(Object receiver_) {
            return ((PromiseLibrary)INSTANCE.getUncached(receiver_)).isPromise(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public PromiseLibrary.State getState(Object receiver_) throws UnsupportedMessageException {
            return ((PromiseLibrary)INSTANCE.getUncached(receiver_)).getState(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            ((PromiseLibrary)INSTANCE.getUncached(receiver_)).markHandled(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static final class Default
    extends LibraryExport<PromiseLibrary> {
        private Default() {
            super(PromiseLibrary.class, Object.class, false, false, 0);
        }

        protected PromiseLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected PromiseLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=PromiseLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends PromiseLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPromise(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PromiseLibrary.State getState(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getState(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void markHandled(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.markHandled(receiver);
            }
        }

        @GeneratedBy(value=PromiseLibrary.class)
        private static final class Cached
        extends PromiseLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isPromise(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPromise(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public PromiseLibrary.State getState(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.getState(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public void markHandled(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                super.markHandled(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(PromiseLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=PromiseLibrary.class)
    private static final class CachedToUncachedDispatch
    extends PromiseLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPromise(Object receiver_) {
            assert (PromiseLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((PromiseLibrary)INSTANCE.getUncached(receiver_)).isPromise(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public PromiseLibrary.State getState(Object receiver_) throws UnsupportedMessageException {
            assert (PromiseLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                PromiseLibrary.State state = ((PromiseLibrary)INSTANCE.getUncached(receiver_)).getState(receiver_);
                return state;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void markHandled(Object receiver_) throws UnsupportedMessageException {
            assert (PromiseLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((PromiseLibrary)INSTANCE.getUncached(receiver_)).markHandled(receiver_);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

