/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory;
import com.oracle.graal.python.builtins.modules.MarshalModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.GetAwaitableNode;
import com.oracle.graal.python.builtins.objects.asyncio.GetAwaitableNodeGen;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodesFactory;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageFactory;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.DictNodesFactory;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.exception.ChainExceptionsNode;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.GetEscapedExceptionNode;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltins;
import com.oracle.graal.python.builtins.objects.floats.FloatBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.ListBuiltins;
import com.oracle.graal.python.builtins.objects.list.ListBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.set.PFrozenSet;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.set.SetBuiltins;
import com.oracle.graal.python.builtins.objects.set.SetBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.set.SetNodes;
import com.oracle.graal.python.builtins.objects.set.SetNodesFactory;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.slice.SliceNodesFactory;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.compiler.BytecodeCodeUnit;
import com.oracle.graal.python.compiler.OpCodes;
import com.oracle.graal.python.compiler.ParserCallbacksImpl;
import com.oracle.graal.python.compiler.QuickeningTypes;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyNumberAndNode;
import com.oracle.graal.python.lib.PyNumberFloorDivideNode;
import com.oracle.graal.python.lib.PyNumberInPlaceAddNode;
import com.oracle.graal.python.lib.PyNumberInPlaceAndNode;
import com.oracle.graal.python.lib.PyNumberInPlaceFloorDivideNode;
import com.oracle.graal.python.lib.PyNumberInPlaceLshiftNode;
import com.oracle.graal.python.lib.PyNumberInPlaceMatrixMultiplyNode;
import com.oracle.graal.python.lib.PyNumberInPlaceMultiplyNode;
import com.oracle.graal.python.lib.PyNumberInPlaceOrNode;
import com.oracle.graal.python.lib.PyNumberInPlacePowerNode;
import com.oracle.graal.python.lib.PyNumberInPlaceRemainderNode;
import com.oracle.graal.python.lib.PyNumberInPlaceRshiftNode;
import com.oracle.graal.python.lib.PyNumberInPlaceSubtractNode;
import com.oracle.graal.python.lib.PyNumberInPlaceTrueDivideNode;
import com.oracle.graal.python.lib.PyNumberInPlaceXorNode;
import com.oracle.graal.python.lib.PyNumberInvertNode;
import com.oracle.graal.python.lib.PyNumberLshiftNode;
import com.oracle.graal.python.lib.PyNumberMatrixMultiplyNode;
import com.oracle.graal.python.lib.PyNumberMultiplyNode;
import com.oracle.graal.python.lib.PyNumberNegativeNode;
import com.oracle.graal.python.lib.PyNumberOrNode;
import com.oracle.graal.python.lib.PyNumberPositiveNode;
import com.oracle.graal.python.lib.PyNumberPowerNode;
import com.oracle.graal.python.lib.PyNumberRemainderNode;
import com.oracle.graal.python.lib.PyNumberRshiftNode;
import com.oracle.graal.python.lib.PyNumberSubtractNode;
import com.oracle.graal.python.lib.PyNumberTrueDivideNode;
import com.oracle.graal.python.lib.PyNumberXorNode;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.lib.PyObjectAsciiNodeGen;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectDelItemNodeGen;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetItemNodeGen;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.lib.PyObjectGetMethod;
import com.oracle.graal.python.lib.PyObjectGetMethodNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNodeGen;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNodeGen;
import com.oracle.graal.python.lib.PyObjectRichCompare;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSetItemNodeGen;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectSizeNodeGen;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNodeGen;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.PRootNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNodeGen;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.builtins.ListNodesFactory;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.builtins.TupleNodesFactory;
import com.oracle.graal.python.nodes.bytecode.BinarySubscrSeq;
import com.oracle.graal.python.nodes.bytecode.BinarySubscrSeqFactory;
import com.oracle.graal.python.nodes.bytecode.BytecodeFrameInfo;
import com.oracle.graal.python.nodes.bytecode.CallComprehensionNode;
import com.oracle.graal.python.nodes.bytecode.CallComprehensionNodeGen;
import com.oracle.graal.python.nodes.bytecode.CopyDictWithoutKeysNode;
import com.oracle.graal.python.nodes.bytecode.CopyDictWithoutKeysNodeGen;
import com.oracle.graal.python.nodes.bytecode.EndAsyncForNode;
import com.oracle.graal.python.nodes.bytecode.EndAsyncForNodeGen;
import com.oracle.graal.python.nodes.bytecode.ExitAWithNode;
import com.oracle.graal.python.nodes.bytecode.ExitAWithNodeGen;
import com.oracle.graal.python.nodes.bytecode.ExitWithNode;
import com.oracle.graal.python.nodes.bytecode.ExitWithNodeGen;
import com.oracle.graal.python.nodes.bytecode.ForIterINode;
import com.oracle.graal.python.nodes.bytecode.ForIterINodeGen;
import com.oracle.graal.python.nodes.bytecode.ForIterONode;
import com.oracle.graal.python.nodes.bytecode.ForIterONodeGen;
import com.oracle.graal.python.nodes.bytecode.FrameInfo;
import com.oracle.graal.python.nodes.bytecode.GeneratorReturnException;
import com.oracle.graal.python.nodes.bytecode.GeneratorYieldResult;
import com.oracle.graal.python.nodes.bytecode.GetAExitCoroNode;
import com.oracle.graal.python.nodes.bytecode.GetAExitCoroNodeGen;
import com.oracle.graal.python.nodes.bytecode.GetAIterNode;
import com.oracle.graal.python.nodes.bytecode.GetAIterNodeGen;
import com.oracle.graal.python.nodes.bytecode.GetANextNode;
import com.oracle.graal.python.nodes.bytecode.GetANextNodeGen;
import com.oracle.graal.python.nodes.bytecode.GetSendValueNode;
import com.oracle.graal.python.nodes.bytecode.GetSendValueNodeGen;
import com.oracle.graal.python.nodes.bytecode.GetTPFlagsNode;
import com.oracle.graal.python.nodes.bytecode.GetTPFlagsNodeGen;
import com.oracle.graal.python.nodes.bytecode.GetYieldFromIterNode;
import com.oracle.graal.python.nodes.bytecode.GetYieldFromIterNodeGen;
import com.oracle.graal.python.nodes.bytecode.HashingStorageFromListSequenceStorageNode;
import com.oracle.graal.python.nodes.bytecode.HashingStorageFromListSequenceStorageNodeGen;
import com.oracle.graal.python.nodes.bytecode.ImportFromNode;
import com.oracle.graal.python.nodes.bytecode.ImportFromNodeGen;
import com.oracle.graal.python.nodes.bytecode.ImportNode;
import com.oracle.graal.python.nodes.bytecode.ImportNodeGen;
import com.oracle.graal.python.nodes.bytecode.ImportStarNode;
import com.oracle.graal.python.nodes.bytecode.ImportStarNodeGen;
import com.oracle.graal.python.nodes.bytecode.InNode;
import com.oracle.graal.python.nodes.bytecode.InstrumentationMaterializationForwarder;
import com.oracle.graal.python.nodes.bytecode.KeywordsNode;
import com.oracle.graal.python.nodes.bytecode.KeywordsNodeGen;
import com.oracle.graal.python.nodes.bytecode.KwargsMergeNode;
import com.oracle.graal.python.nodes.bytecode.KwargsMergeNodeGen;
import com.oracle.graal.python.nodes.bytecode.MakeFunctionNode;
import com.oracle.graal.python.nodes.bytecode.MakeFunctionNodeGen;
import com.oracle.graal.python.nodes.bytecode.MakeGenericNode;
import com.oracle.graal.python.nodes.bytecode.MakeGenericNodeGen;
import com.oracle.graal.python.nodes.bytecode.MakeTypeAliasNode;
import com.oracle.graal.python.nodes.bytecode.MakeTypeAliasNodeGen;
import com.oracle.graal.python.nodes.bytecode.MakeTypeParamNode;
import com.oracle.graal.python.nodes.bytecode.MakeTypeParamNodeGen;
import com.oracle.graal.python.nodes.bytecode.MatchClassNode;
import com.oracle.graal.python.nodes.bytecode.MatchClassNodeGen;
import com.oracle.graal.python.nodes.bytecode.MatchKeysNode;
import com.oracle.graal.python.nodes.bytecode.MatchKeysNodeGen;
import com.oracle.graal.python.nodes.bytecode.NotNode;
import com.oracle.graal.python.nodes.bytecode.OSRException;
import com.oracle.graal.python.nodes.bytecode.OSRInterpreterState;
import com.oracle.graal.python.nodes.bytecode.PBytecodeGeneratorFunctionRootNode;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNodeFactory;
import com.oracle.graal.python.nodes.bytecode.PRaiseCachedNode;
import com.oracle.graal.python.nodes.bytecode.PRaiseCachedNodeGen;
import com.oracle.graal.python.nodes.bytecode.PrintExprNode;
import com.oracle.graal.python.nodes.bytecode.PrintExprNodeGen;
import com.oracle.graal.python.nodes.bytecode.QuickeningGeneralizeException;
import com.oracle.graal.python.nodes.bytecode.RaiseNode;
import com.oracle.graal.python.nodes.bytecode.RaiseNodeGen;
import com.oracle.graal.python.nodes.bytecode.ReadFromDictOrGlobalsNode;
import com.oracle.graal.python.nodes.bytecode.ReadFromDictOrGlobalsNodeGen;
import com.oracle.graal.python.nodes.bytecode.SendNode;
import com.oracle.graal.python.nodes.bytecode.SendNodeGen;
import com.oracle.graal.python.nodes.bytecode.SequenceFromStackNode;
import com.oracle.graal.python.nodes.bytecode.SequenceFromStackNodeFactory;
import com.oracle.graal.python.nodes.bytecode.SetupAnnotationsNode;
import com.oracle.graal.python.nodes.bytecode.SetupAnnotationsNodeGen;
import com.oracle.graal.python.nodes.bytecode.SetupAwithNode;
import com.oracle.graal.python.nodes.bytecode.SetupAwithNodeGen;
import com.oracle.graal.python.nodes.bytecode.SetupWithNode;
import com.oracle.graal.python.nodes.bytecode.SetupWithNodeGen;
import com.oracle.graal.python.nodes.bytecode.StoreSubscrSeq;
import com.oracle.graal.python.nodes.bytecode.StoreSubscrSeqFactory;
import com.oracle.graal.python.nodes.bytecode.ThrowNode;
import com.oracle.graal.python.nodes.bytecode.ThrowNodeGen;
import com.oracle.graal.python.nodes.bytecode.UnpackExNode;
import com.oracle.graal.python.nodes.bytecode.UnpackExNodeGen;
import com.oracle.graal.python.nodes.bytecode.UnpackSequenceNode;
import com.oracle.graal.python.nodes.bytecode.UnpackSequenceNodeGen;
import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentationRoot;
import com.oracle.graal.python.nodes.bytecode.instrumentation.InstrumentationSupport;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.CallNodeGen;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNodeGen;
import com.oracle.graal.python.nodes.call.special.CallQuaternaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallQuaternaryMethodNodeGen;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNodeGen;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNodeGen;
import com.oracle.graal.python.nodes.exception.ExceptMatchNode;
import com.oracle.graal.python.nodes.exception.ExceptMatchNodeGen;
import com.oracle.graal.python.nodes.expression.BinaryOp;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.graal.python.nodes.frame.DeleteGlobalNode;
import com.oracle.graal.python.nodes.frame.DeleteGlobalNodeGen;
import com.oracle.graal.python.nodes.frame.GetFrameLocalsNode;
import com.oracle.graal.python.nodes.frame.MaterializeFrameNode;
import com.oracle.graal.python.nodes.frame.ReadBuiltinNode;
import com.oracle.graal.python.nodes.frame.ReadBuiltinNodeGen;
import com.oracle.graal.python.nodes.frame.ReadFromLocalsNode;
import com.oracle.graal.python.nodes.frame.ReadFromLocalsNodeGen;
import com.oracle.graal.python.nodes.frame.ReadGlobalOrBuiltinNode;
import com.oracle.graal.python.nodes.frame.ReadGlobalOrBuiltinNodeGen;
import com.oracle.graal.python.nodes.frame.ReadNameNode;
import com.oracle.graal.python.nodes.frame.ReadNameNodeGen;
import com.oracle.graal.python.nodes.frame.WriteGlobalNode;
import com.oracle.graal.python.nodes.frame.WriteGlobalNodeGen;
import com.oracle.graal.python.nodes.frame.WriteNameNode;
import com.oracle.graal.python.nodes.frame.WriteNameNodeGen;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNodeGen;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.runtime.exception.PythonThreadKillException;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.BoolSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public final class PBytecodeRootNode
extends PRootNode
implements BytecodeOSRNode {
    private static final NodeSupplier<RaiseNode> NODE_RAISENODE = RaiseNode::create;
    private static final NodeSupplier<PyObjectDelItem> NODE_OBJECT_DEL_ITEM = PyObjectDelItem::create;
    private static final PyObjectDelItem UNCACHED_OBJECT_DEL_ITEM = PyObjectDelItem.getUncached();
    private static final NodeSupplier<HashingCollectionNodes.SetItemNode> NODE_SET_ITEM = HashingCollectionNodes.SetItemNode::create;
    private static final HashingCollectionNodes.SetItemNode UNCACHED_SET_ITEM = HashingCollectionNodes.SetItemNode.getUncached();
    private static final NodeSupplier<ObjHashMapPutNode> NODE_OBJ_HASHMAP_PUT = PBytecodeRootNodeFactory.ObjHashMapPutNodeGen::create;
    private static final ObjHashMapPutNode UNCACHED_OBJ_HASHMAP_PUT = PBytecodeRootNodeFactory.ObjHashMapPutNodeGen.getUncached();
    private static final NodeSupplier<CastToJavaIntExactNode> NODE_CAST_TO_JAVA_INT_EXACT = CastToJavaIntExactNode::create;
    private static final CastToJavaIntExactNode UNCACHED_CAST_TO_JAVA_INT_EXACT = CastToJavaIntExactNode.getUncached();
    private static final ImportNode UNCACHED_IMPORT = ImportNode.getUncached();
    private static final ReadNameNode UNCACHED_READ_NAME = ReadNameNodeGen.getUncached();
    private static final WriteNameNode UNCACHED_WRITE_NAME = WriteNameNodeGen.getUncached();
    private static final NodeSupplier<ImportNode> NODE_IMPORT = ImportNode::create;
    private static final ImportStarNode UNCACHED_IMPORT_STAR = ImportStarNode.getUncached();
    private static final NodeSupplier<ImportStarNode> NODE_IMPORT_STAR = ImportStarNode::create;
    private static final NodeSupplier<PyObjectGetAttr> NODE_OBJECT_GET_ATTR = PyObjectGetAttr::create;
    private static final PyObjectGetAttr UNCACHED_OBJECT_GET_ATTR = PyObjectGetAttr.getUncached();
    private static final NodeSupplier<PRaiseCachedNode> NODE_RAISE = PRaiseCachedNode::create;
    private static final PRaiseCachedNode UNCACHED_RAISE = PRaiseCachedNode.getUncached();
    private static final NodeSupplier<CallNode> NODE_CALL = CallNode::create;
    private static final CallNode UNCACHED_CALL = CallNode.getUncached();
    private static final NodeSupplier<CallQuaternaryMethodNode> NODE_CALL_QUATERNARY_METHOD = CallQuaternaryMethodNode::create;
    private static final CallQuaternaryMethodNode UNCACHED_CALL_QUATERNARY_METHOD = CallQuaternaryMethodNode.getUncached();
    private static final NodeSupplier<CallTernaryMethodNode> NODE_CALL_TERNARY_METHOD = CallTernaryMethodNode::create;
    private static final CallTernaryMethodNode UNCACHED_CALL_TERNARY_METHOD = CallTernaryMethodNode.getUncached();
    private static final NodeSupplier<CallBinaryMethodNode> NODE_CALL_BINARY_METHOD = CallBinaryMethodNode::create;
    private static final CallBinaryMethodNode UNCACHED_CALL_BINARY_METHOD = CallBinaryMethodNode.getUncached();
    private static final NodeSupplier<CallUnaryMethodNode> NODE_CALL_UNARY_METHOD = CallUnaryMethodNode::create;
    private static final CallUnaryMethodNode UNCACHED_CALL_UNARY_METHOD = CallUnaryMethodNode.getUncached();
    private static final NodeSupplier<PyObjectGetMethod> NODE_OBJECT_GET_METHOD = PyObjectGetMethodNodeGen::create;
    private static final PyObjectGetMethod UNCACHED_OBJECT_GET_METHOD = PyObjectGetMethodNodeGen.getUncached();
    private static final ForIterONode UNCACHED_FOR_ITER_O = ForIterONode.getUncached();
    private static final NodeSupplier<ForIterONode> NODE_FOR_ITER_O = ForIterONode::create;
    private static final ForIterINode UNCACHED_FOR_ITER_I = ForIterINode.getUncached();
    private static final NodeSupplier<ForIterINode> NODE_FOR_ITER_I = ForIterINode::create;
    private static final NodeSupplier<PyObjectGetIter> NODE_OBJECT_GET_ITER = PyObjectGetIter::create;
    private static final PyObjectGetIter UNCACHED_OBJECT_GET_ITER = PyObjectGetIter.getUncached();
    private static final NodeSupplier<GetYieldFromIterNode> NODE_OBJECT_GET_YIELD_FROM_ITER = GetYieldFromIterNode::create;
    private static final GetYieldFromIterNode UNCACHED_OBJECT_GET_YIELD_FROM_ITER = GetYieldFromIterNode.getUncached();
    private static final MakeTypeParamNode UNCACHED_MAKE_TYPE_PARAM = MakeTypeParamNode.getUncached();
    private static final NodeSupplier<MakeTypeParamNode> NODE_MAKE_TYPE_PARAM = MakeTypeParamNode::create;
    private static final MakeTypeAliasNode UNCACHED_MAKE_TYPE_ALIAS = MakeTypeAliasNode.getUncached();
    private static final NodeSupplier<MakeTypeAliasNode> NODE_MAKE_TYPE_ALIAS = MakeTypeAliasNode::create;
    private static final MakeGenericNode UNCACHED_MAKE_GENERIC = MakeGenericNode.getUncached();
    private static final NodeSupplier<MakeGenericNode> NODE_MAKE_GENERIC = MakeGenericNode::create;
    private static final NodeSupplier<GetAwaitableNode> NODE_OBJECT_GET_AWAITABLE = GetAwaitableNode::create;
    private static final GetAwaitableNode UNCACHED_OBJECT_GET_AWAITABLE = GetAwaitableNode.getUncached();
    private static final NodeSupplier<PyObjectSetAttr> NODE_OBJECT_SET_ATTR = PyObjectSetAttr::create;
    private static final PyObjectSetAttr UNCACHED_OBJECT_SET_ATTR = PyObjectSetAttr.getUncached();
    private static final NodeSupplier<ReadBuiltinNode> NODE_READ_BUILTIN_BUILD_CLASS = () -> ReadBuiltinNode.create();
    private static final NodeSupplier<ReadGlobalOrBuiltinNode> NODE_READ_GLOBAL_OR_BUILTIN = ReadGlobalOrBuiltinNode::create;
    private static final NodeSupplier<ReadNameNode> NODE_READ_NAME = ReadNameNode::create;
    private static final NodeSupplier<WriteNameNode> NODE_WRITE_NAME = WriteNameNode::create;
    private static final ReadBuiltinNode UNCACHED_READ_BUILTIN = ReadBuiltinNode.getUncached();
    private static final ReadGlobalOrBuiltinNode UNCACHED_READ_GLOBAL_OR_BUILTIN = ReadGlobalOrBuiltinNode.getUncached();
    private static final NodeSupplier<PyObjectSetItem> NODE_OBJECT_SET_ITEM = PyObjectSetItem::create;
    private static final PyObjectSetItem UNCACHED_OBJECT_SET_ITEM = PyObjectSetItem.getUncached();
    private static final NodeSupplier<PyObjectIsTrueNode> NODE_OBJECT_IS_TRUE = PyObjectIsTrueNode::create;
    private static final PyObjectIsTrueNode UNCACHED_OBJECT_IS_TRUE = PyObjectIsTrueNode.getUncached();
    private static final NodeSupplier<PyObjectGetItem> NODE_GET_ITEM = PyObjectGetItem::create;
    private static final ExceptMatchNode UNCACHED_EXCEPT_MATCH = ExceptMatchNode.getUncached();
    private static final NodeSupplier<ExceptMatchNode> NODE_EXCEPT_MATCH = ExceptMatchNode::create;
    private static final SetupWithNode UNCACHED_SETUP_WITH_NODE = SetupWithNode.getUncached();
    private static final NodeSupplier<SetupWithNode> NODE_SETUP_WITH = SetupWithNode::create;
    private static final ExitWithNode UNCACHED_EXIT_WITH_NODE = ExitWithNode.getUncached();
    private static final NodeSupplier<ExitWithNode> NODE_EXIT_WITH = ExitWithNode::create;
    private static final SetupAwithNode UNCACHED_SETUP_AWITH_NODE = SetupAwithNode.getUncached();
    private static final NodeSupplier<SetupAwithNode> NODE_SETUP_AWITH = SetupAwithNode::create;
    private static final GetAExitCoroNode UNCACHED_GET_AEXIT_CORO_NODE = GetAExitCoroNode.getUncached();
    private static final NodeSupplier<GetAExitCoroNode> NODE_GET_AEXIT_CORO = GetAExitCoroNode::create;
    private static final ExitAWithNode UNCACHED_EXIT_AWITH_NODE = ExitAWithNode.getUncached();
    private static final GetAIterNode UNCACHED_GET_AITER = GetAIterNode.getUncached();
    private static final NodeSupplier<GetAIterNode> NODE_GET_AITER = GetAIterNode::create;
    private static final GetANextNode UNCACHED_GET_ANEXT = GetANextNode.getUncached();
    private static final NodeSupplier<GetANextNode> NODE_GET_ANEXT = GetANextNode::create;
    private static final EndAsyncForNode UNCACHED_END_ASYNC_FOR = EndAsyncForNode.getUncached();
    private static final NodeSupplier<EndAsyncForNode> NODE_END_ASYNC_FOR = EndAsyncForNode::create;
    private static final NodeSupplier<ExitAWithNode> NODE_EXIT_AWITH = ExitAWithNode::create;
    private static final ImportFromNode UNCACHED_IMPORT_FROM = ImportFromNode.getUncached();
    private static final NodeSupplier<ImportFromNode> NODE_IMPORT_FROM = ImportFromNode::create;
    private static final ExecutePositionalStarargsNode UNCACHED_EXECUTE_STARARGS = ExecutePositionalStarargsNode.getUncached();
    private static final NodeSupplier<ExecutePositionalStarargsNode> NODE_EXECUTE_STARARGS = ExecutePositionalStarargsNode::create;
    private static final KeywordsNode UNCACHED_KEYWORDS = KeywordsNode.getUncached();
    private static final NodeSupplier<KeywordsNode> NODE_KEYWORDS = KeywordsNode::create;
    private static final SliceNodes.CreateSliceNode UNCACHED_CREATE_SLICE = SliceNodes.CreateSliceNode.getUncached();
    private static final NodeSupplier<SliceNodes.CreateSliceNode> NODE_CREATE_SLICE = SliceNodes.CreateSliceNode::create;
    private static final ListNodes.ConstructListNode UNCACHED_CONSTRUCT_LIST = ListNodes.ConstructListNode.getUncached();
    private static final NodeSupplier<ListNodes.ConstructListNode> NODE_CONSTRUCT_LIST = ListNodes.ConstructListNode::create;
    private static final TupleNodes.ConstructTupleNode UNCACHED_CONSTRUCT_TUPLE = TupleNodes.ConstructTupleNode.getUncached();
    private static final NodeSupplier<TupleNodes.ConstructTupleNode> NODE_CONSTRUCT_TUPLE = TupleNodes.ConstructTupleNode::create;
    private static final SetNodes.ConstructSetNode UNCACHED_CONSTRUCT_SET = SetNodes.ConstructSetNode.getUncached();
    private static final NodeSupplier<SetNodes.ConstructSetNode> NODE_CONSTRUCT_SET = SetNodes.ConstructSetNode::create;
    private static final NodeSupplier<HashingStorage.InitNode> NODE_HASHING_STORAGE_INIT = HashingStorage.InitNode::create;
    private static final NodeSupplier<ListBuiltins.ListExtendNode> NODE_LIST_EXTEND = ListBuiltins.ListExtendNode::create;
    private static final SetBuiltins.UpdateSingleNode UNCACHED_SET_UPDATE = SetBuiltins.UpdateSingleNode.getUncached();
    private static final NodeSupplier<DictNodes.UpdateNode> NODE_DICT_UPDATE = DictNodes.UpdateNode::create;
    private static final NodeSupplier<SetBuiltins.UpdateSingleNode> NODE_SET_UPDATE = SetBuiltins.UpdateSingleNode::create;
    private static final ListNodes.AppendNode UNCACHED_LIST_APPEND = ListNodes.AppendNode.getUncached();
    private static final NodeSupplier<ListNodes.AppendNode> NODE_LIST_APPEND = ListNodes.AppendNode::create;
    private static final SetNodes.AddNode UNCACHED_SET_ADD = SetNodes.AddNode.getUncached();
    private static final NodeSupplier<SetNodes.AddNode> NODE_SET_ADD = SetNodes.AddNode::create;
    private static final PyObjectSizeNode UNCACHED_SIZE = PyObjectSizeNode.getUncached();
    private static final NodeSupplier<PyObjectSizeNode> NODE_SIZE = PyObjectSizeNode::create;
    private static final NodeSupplier<GetTPFlagsNode> NODE_TP_FLAGS = GetTPFlagsNode::create;
    private static final GetTPFlagsNode UNCACHED_TP_FLAGS = GetTPFlagsNode.getUncached();
    private static final DeleteGlobalNode UNCACHED_DELETE_GLOBAL = DeleteGlobalNodeGen.getUncached();
    private static final NodeSupplier<MatchKeysNode> NODE_MATCH_KEYS = MatchKeysNode::create;
    private static final NodeSupplier<CopyDictWithoutKeysNode> NODE_COPY_DICT_WITHOUT_KEYS = CopyDictWithoutKeysNode::create;
    private static final KwargsMergeNode UNCACHED_KWARGS_MERGE = KwargsMergeNode.getUncached();
    private static final NodeSupplier<KwargsMergeNode> NODE_KWARGS_MERGE = KwargsMergeNode::create;
    private static final UnpackSequenceNode UNCACHED_UNPACK_SEQUENCE = UnpackSequenceNode.getUncached();
    private static final NodeSupplier<UnpackSequenceNode> NODE_UNPACK_SEQUENCE = UnpackSequenceNode::create;
    private static final UnpackExNode UNCACHED_UNPACK_EX = UnpackExNode.getUncached();
    private static final NodeSupplier<UnpackExNode> NODE_UNPACK_EX = UnpackExNode::create;
    private static final PyObjectStrAsObjectNode UNCACHED_STR = PyObjectStrAsObjectNode.getUncached();
    private static final NodeSupplier<PyObjectStrAsObjectNode> NODE_STR = PyObjectStrAsObjectNode::create;
    private static final PyObjectReprAsObjectNode UNCACHED_REPR = PyObjectReprAsObjectNode.getUncached();
    private static final NodeSupplier<PyObjectReprAsObjectNode> NODE_REPR = PyObjectReprAsObjectNode::create;
    private static final PyObjectAsciiNode UNCACHED_ASCII = PyObjectAsciiNode.getUncached();
    private static final NodeSupplier<PyObjectAsciiNode> NODE_ASCII = PyObjectAsciiNode::create;
    private static final NodeSupplier<BuiltinFunctions.FormatNode> NODE_FORMAT = BuiltinFunctions.FormatNode::create;
    private static final NodeSupplier<SendNode> NODE_SEND = SendNode::create;
    private static final NodeSupplier<ThrowNode> NODE_THROW = ThrowNode::create;
    private static final WriteGlobalNode UNCACHED_WRITE_GLOBAL = WriteGlobalNode.getUncached();
    private static final NodeSupplier<WriteGlobalNode> NODE_WRITE_GLOBAL = WriteGlobalNode::create;
    private static final NodeSupplier<DeleteGlobalNode> NODE_DELETE_GLOBAL = DeleteGlobalNode::create;
    private static final PrintExprNode UNCACHED_PRINT_EXPR = PrintExprNode.getUncached();
    private static final NodeSupplier<PrintExprNode> NODE_PRINT_EXPR = PrintExprNode::create;
    private static final ReadFromLocalsNode UNCACHED_READ_FROM_LOCALS = ReadFromLocalsNode.getUncached();
    private static final NodeSupplier<ReadFromLocalsNode> NODE_READ_FROM_LOCALS = ReadFromLocalsNode::create;
    private static final ReadFromDictOrGlobalsNode UNCACHED_READ_FROM_DICT_OR_GLOBALS = ReadFromDictOrGlobalsNode.getUncached();
    private static final NodeSupplier<ReadFromDictOrGlobalsNode> NODE_READ_FROM_DICT_OR_GLOBALS = ReadFromDictOrGlobalsNode::create;
    private static final SetupAnnotationsNode UNCACHED_SETUP_ANNOTATIONS = SetupAnnotationsNode.getUncached();
    private static final NodeSupplier<SetupAnnotationsNode> NODE_SETUP_ANNOTATIONS = SetupAnnotationsNode::create;
    private static final GetSendValueNode UNCACHED_GET_SEND_VALUE = GetSendValueNode.getUncached();
    private static final NodeSupplier<GetSendValueNode> NODE_GET_SEND_VALUE = GetSendValueNode::create;
    private static final NodeSupplier<BinarySubscrSeq.ONode> NODE_BINARY_SUBSCR_SEQ_O = BinarySubscrSeq.ONode::create;
    private static final NodeSupplier<BinarySubscrSeq.INode> NODE_BINARY_SUBSCR_SEQ_I = BinarySubscrSeq.INode::create;
    private static final NodeSupplier<BinarySubscrSeq.DNode> NODE_BINARY_SUBSCR_SEQ_D = BinarySubscrSeq.DNode::create;
    private static final NodeSupplier<StoreSubscrSeq.ONode> NODE_STORE_SUBSCR_SEQ_O = StoreSubscrSeq.ONode::create;
    private static final NodeSupplier<StoreSubscrSeq.INode> NODE_STORE_SUBSCR_SEQ_I = StoreSubscrSeq.INode::create;
    private static final NodeSupplier<StoreSubscrSeq.DNode> NODE_STORE_SUBSCR_SEQ_D = StoreSubscrSeq.DNode::create;
    private static final NodeSupplier<CallComprehensionNode> NODE_CALL_COMPREHENSION = CallComprehensionNode::create;
    private static final NodeSupplier<IntBuiltins.AddNode> NODE_INT_ADD = IntBuiltins.AddNode::create;
    private static final NodeSupplier<IntBuiltins.SubNode> NODE_INT_SUB = IntBuiltins.SubNode::create;
    private static final NodeSupplier<IntBuiltins.MulNode> NODE_INT_MUL = IntBuiltins.MulNode::create;
    private static final NodeSupplier<IntBuiltins.FloorDivNode> NODE_INT_FLOORDIV = IntBuiltins.FloorDivNode::create;
    private static final NodeSupplier<IntBuiltins.TrueDivNode> NODE_INT_TRUEDIV = IntBuiltins.TrueDivNode::create;
    private static final NodeSupplier<IntBuiltins.ModNode> NODE_INT_MOD = IntBuiltins.ModNode::create;
    private static final NodeSupplier<IntBuiltins.LShiftNode> NODE_INT_LSHIFT = IntBuiltins.LShiftNode::create;
    private static final NodeSupplier<IntBuiltins.RShiftNode> NODE_INT_RSHIFT = IntBuiltins.RShiftNode::create;
    private static final NodeSupplier<IntBuiltins.NegNode> NODE_INT_NEG = IntBuiltins.NegNode::create;
    private static final NodeSupplier<IntBuiltins.PowNode> NODE_INT_POW = IntBuiltins.PowNode::create;
    private static final NodeSupplier<FloatBuiltins.PowNode> NODE_FLOAT_POW = FloatBuiltins.PowNode::create;
    private static final NodeSupplier<HashingStorageFromListSequenceStorageNode> NODE_HASHING_STORAGE_FROM_SEQUENCE = HashingStorageFromListSequenceStorageNode::create;
    private static final NodeSupplier<MatchClassNode> NODE_MATCH_CLASS = MatchClassNode::create;
    private static final IntNodeFunction<SequenceFromStackNode.ListFromStackNode> LIST_FROM_STACK_NODE = SequenceFromStackNodeFactory.ListFromStackNodeGen::create;
    private static final IntNodeFunction<SequenceFromStackNode.TupleFromStackNode> TUPLE_FROM_STACK_NODE = SequenceFromStackNodeFactory.TupleFromStackNodeGen::create;
    private static final IntNodeFunction<UnaryOpNode> UNARY_OP_FACTORY = op -> {
        switch (op) {
            case 0: {
                return NotNode.create();
            }
            case 1: {
                return PyNumberPositiveNode.create();
            }
            case 2: {
                return PyNumberNegativeNode.create();
            }
            case 3: {
                return PyNumberInvertNode.create();
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    };
    private static final IntNodeFunction<Node> BINARY_OP_FACTORY = op -> {
        switch (op) {
            case 0: {
                return PyNumberAddNode.create();
            }
            case 2: {
                return PyNumberSubtractNode.create();
            }
            case 4: {
                return PyNumberMultiplyNode.create();
            }
            case 8: {
                return PyNumberTrueDivideNode.create();
            }
            case 6: {
                return PyNumberFloorDivideNode.create();
            }
            case 10: {
                return PyNumberRemainderNode.create();
            }
            case 18: {
                return PyNumberLshiftNode.create();
            }
            case 20: {
                return PyNumberRshiftNode.create();
            }
            case 22: {
                return PyNumberAndNode.create();
            }
            case 24: {
                return PyNumberOrNode.create();
            }
            case 26: {
                return PyNumberXorNode.create();
            }
            case 28: {
                return PyNumberPowerNode.create();
            }
            case 32: {
                return PyNumberMatrixMultiplyNode.create();
            }
            case 1: {
                return PyNumberInPlaceAddNode.create();
            }
            case 3: {
                return PyNumberInPlaceSubtractNode.create();
            }
            case 5: {
                return PyNumberInPlaceMultiplyNode.create();
            }
            case 9: {
                return PyNumberInPlaceTrueDivideNode.create();
            }
            case 7: {
                return PyNumberInPlaceFloorDivideNode.create();
            }
            case 11: {
                return PyNumberInPlaceRemainderNode.create();
            }
            case 19: {
                return PyNumberInPlaceLshiftNode.create();
            }
            case 21: {
                return PyNumberInPlaceRshiftNode.create();
            }
            case 23: {
                return PyNumberInPlaceAndNode.create();
            }
            case 25: {
                return PyNumberInPlaceOrNode.create();
            }
            case 27: {
                return PyNumberInPlaceXorNode.create();
            }
            case 29: {
                return PyNumberInPlacePowerNode.create();
            }
            case 33: {
                return PyNumberInPlaceMatrixMultiplyNode.create();
            }
            case 12: {
                return PyObjectRichCompare.RichCompareBinaryOp.create(RichCmpOp.Py_EQ);
            }
            case 13: {
                return PyObjectRichCompare.RichCompareBinaryOp.create(RichCmpOp.Py_NE);
            }
            case 14: {
                return PyObjectRichCompare.RichCompareBinaryOp.create(RichCmpOp.Py_LT);
            }
            case 15: {
                return PyObjectRichCompare.RichCompareBinaryOp.create(RichCmpOp.Py_LE);
            }
            case 16: {
                return PyObjectRichCompare.RichCompareBinaryOp.create(RichCmpOp.Py_GT);
            }
            case 17: {
                return PyObjectRichCompare.RichCompareBinaryOp.create(RichCmpOp.Py_GE);
            }
            case 31: {
                return IsNode.create();
            }
            case 30: {
                return InNode.create();
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    };
    private static final byte TRACE_FUN = 1;
    private static final byte PROFILE_FUN = 2;
    private static final byte TRACE_AND_PROFILE_FUN = 3;
    private final Signature signature;
    private final TruffleString name;
    private final boolean internal;
    private boolean pythonInternal;
    final int celloffset;
    final int freeoffset;
    final int stackoffset;
    final int bcioffset;
    final int selfIndex;
    final int classcellIndex;
    private final BytecodeCodeUnit co;
    private final Source source;
    private SourceSection sourceSection;
    private final ParserCallbacksImpl parserCallbacks;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final byte[] bytecode;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] consts;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final long[] longConsts;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] names;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] varnames;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] freevars;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final TruffleString[] cellvars;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] cell2arg;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Assumption[] cellEffectivelyFinalAssumptions;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] exceptionHandlerRanges;
    private final byte[] outputCanQuicken;
    private final byte[] variableShouldUnbox;
    private final int[][] generalizeInputsMap;
    private final int[][] generalizeVarsMap;
    private static final byte UNBOXED_IN_INTERPRETER = -128;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private byte[] variableTypes;
    @Node.Children
    private Node[] adoptedNodes;
    @Node.Child
    private ExecutionContext.CalleeContext calleeContext = ExecutionContext.CalleeContext.create();
    @Node.Child
    private ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode;
    @Node.Child
    private MaterializeFrameNode traceMaterializeFrameNode = null;
    @Node.Child
    private ChainExceptionsNode chainExceptionsNode;
    @CompilerDirectives.CompilationFinal
    private Object osrMetadata;
    @CompilerDirectives.CompilationFinal
    private boolean usingCachedNodes;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private int[] conditionProfiles;
    @Node.Child
    private InstrumentationRoot instrumentationRoot = InstrumentationRoot.create();
    private static final int CONDITION_PROFILE_MAX_VALUE = 0x3FFFFFFF;

    private static FrameDescriptor makeFrameDescriptor(BytecodeCodeUnit co, FrameInfo info) {
        int i;
        int capacity = co.varnames.length + co.cellvars.length + co.freevars.length + co.stacksize + 1;
        FrameDescriptor.Builder newBuilder = FrameDescriptor.newBuilder((int)capacity);
        newBuilder.info((Object)info);
        for (i = 0; i < co.varnames.length; ++i) {
            TruffleString varname = co.varnames[i];
            if (co.arg2cell != null && i < co.arg2cell.length && co.arg2cell[i] >= 0) {
                varname = null;
            }
            newBuilder.addSlot(FrameSlotKind.Illegal, (Object)varname, null);
        }
        for (i = 0; i < co.cellvars.length; ++i) {
            newBuilder.addSlot(FrameSlotKind.Illegal, (Object)co.cellvars[i], null);
        }
        for (i = 0; i < co.freevars.length; ++i) {
            newBuilder.addSlot(FrameSlotKind.Illegal, (Object)co.freevars[i], null);
        }
        newBuilder.addSlots(co.stacksize, FrameSlotKind.Illegal);
        newBuilder.addSlot(FrameSlotKind.Int, null, null);
        if (co.isGeneratorOrCoroutine()) {
            newBuilder.addSlot(FrameSlotKind.Int, null, null);
            newBuilder.addSlot(FrameSlotKind.Illegal, null, null);
        }
        return newBuilder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public static PBytecodeRootNode create(PythonLanguage language, BytecodeCodeUnit co, Source source) {
        return PBytecodeRootNode.create(language, co, source, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static PBytecodeRootNode create(PythonLanguage language, BytecodeCodeUnit co, Source source, ParserCallbacksImpl parserCallbacks) {
        BytecodeFrameInfo frameInfo = new BytecodeFrameInfo();
        FrameDescriptor fd = PBytecodeRootNode.makeFrameDescriptor(co, frameInfo);
        PBytecodeRootNode rootNode = new PBytecodeRootNode(language, fd, co.computeSignature(), co, source, parserCallbacks);
        PythonContext context = PythonContext.get((Node)rootNode);
        if (context != null && context.getOption(PythonOptions.EagerlyMaterializeInstrumentationNodes).booleanValue()) {
            rootNode.adoptChildren();
            rootNode.instrumentationRoot.materializeInstrumentableNodes(Collections.singleton(StandardTags.StatementTag.class));
        }
        frameInfo.setRootNode(rootNode);
        return rootNode;
    }

    @CompilerDirectives.TruffleBoundary
    private PBytecodeRootNode(PythonLanguage language, FrameDescriptor fd, Signature sign, BytecodeCodeUnit co, Source source, ParserCallbacksImpl parserCallbacks) {
        super(language, fd);
        assert (source != null);
        this.celloffset = co.varnames.length;
        this.freeoffset = this.celloffset + co.cellvars.length;
        this.stackoffset = this.freeoffset + co.freevars.length;
        this.bcioffset = this.stackoffset + co.stacksize;
        this.source = source;
        this.internal = source.isInternal();
        this.parserCallbacks = parserCallbacks;
        this.signature = sign;
        this.bytecode = co.code;
        this.outputCanQuicken = co.outputCanQuicken;
        this.variableShouldUnbox = co.variableShouldUnbox;
        this.generalizeInputsMap = co.generalizeInputsMap;
        this.generalizeVarsMap = co.generalizeVarsMap;
        this.consts = co.constants;
        this.longConsts = co.primitiveConstants;
        this.names = co.names;
        this.varnames = co.varnames;
        this.freevars = co.freevars;
        this.cellvars = co.cellvars;
        this.cell2arg = co.cell2arg;
        this.name = co.name;
        this.exceptionHandlerRanges = co.exceptionHandlerRanges;
        this.co = co;
        assert ((double)co.stacksize < Math.pow(2.0, 12.0)) : "stacksize cannot be larger than 12-bit range";
        this.cellEffectivelyFinalAssumptions = new Assumption[this.cellvars.length];
        for (int i = 0; i < this.cellvars.length; ++i) {
            this.cellEffectivelyFinalAssumptions[i] = Truffle.getRuntime().createAssumption("cell is effectively final");
        }
        int classcellIndexValue = -1;
        for (int i = 0; i < this.freevars.length; ++i) {
            if (!SpecialAttributeNames.T___CLASS__.equalsUncached((AbstractTruffleString)this.freevars[i], PythonUtils.TS_ENCODING)) continue;
            classcellIndexValue = this.freeoffset + i;
            break;
        }
        this.classcellIndex = classcellIndexValue;
        int selfIndexValue = -1;
        if (!this.signature.takesNoArguments()) {
            selfIndexValue = 0;
            if (co.cell2arg != null) {
                for (int i = 0; i < co.cell2arg.length; ++i) {
                    if (co.cell2arg[i] != 0) continue;
                    selfIndexValue = this.celloffset + i;
                    break;
                }
            }
        }
        this.selfIndex = selfIndexValue;
        if (language.getEngineOption(PythonOptions.ForceInitializeSourceSections).booleanValue()) {
            this.getSourceSection();
        }
    }

    protected int computeSize() {
        return this.bytecode.length / 2;
    }

    public String getName() {
        return this.name.toJavaStringUncached();
    }

    public String toString() {
        return "<bytecode " + String.valueOf(this.name) + " at " + Integer.toHexString(((Object)((Object)this)).hashCode()) + ">";
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public boolean isPythonInternal() {
        return this.pythonInternal;
    }

    public void setPythonInternal(boolean pythonInternal) {
        this.pythonInternal = pythonInternal;
    }

    public BytecodeCodeUnit getCodeUnit() {
        return this.co;
    }

    public Source getSource() {
        return this.source;
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    private Node[] getChildNodes() {
        InstrumentationSupport instrumentation = this.instrumentationRoot.getInstrumentation();
        if (instrumentation != null) {
            return instrumentation.bciToHelperNode;
        }
        if (this.adoptedNodes == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.adoptedNodes == null) {
                    this.adoptedNodes = new Node[this.bytecode.length];
                }
            }
            finally {
                lock.unlock();
            }
        }
        return this.adoptedNodes;
    }

    private <T extends Node, U> T insertChildNodeInt(Node[] nodes, int nodeIndex, Class<U> expectedClass, IntNodeFunction<T> nodeSupplier, int argument) {
        Node node = nodes[nodeIndex];
        if (expectedClass.isInstance(node)) {
            return (T)node;
        }
        return this.doInsertChildNodeInt(nodes, nodeIndex, expectedClass, nodeSupplier, argument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Node, U> T doInsertChildNodeInt(Node[] nodes, int nodeIndex, Class<U> expectedClass, IntNodeFunction<T> nodeSupplier, int argument) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Lock lock = this.getLock();
        lock.lock();
        try {
            Node node = nodes[nodeIndex];
            if (expectedClass.isInstance(node)) {
                Node node2 = node;
                return (T)node2;
            }
            T newNode2 = nodeSupplier.apply(argument);
            this.doInsertChildNode(nodes, nodeIndex, (Node)newNode2);
            T t = newNode2;
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private <T extends Node, U extends T> U insertChildNode(Node[] nodes, int nodeIndex, Class<U> cachedClass, NodeSupplier<T> nodeSupplier) {
        Node node = nodes[nodeIndex];
        if (node != null && node.getClass() == cachedClass) {
            return (U)((Node)CompilerDirectives.castExact((Object)node, cachedClass));
        }
        return (U)((Node)CompilerDirectives.castExact(this.doInsertChildNode(nodes, nodeIndex, cachedClass, nodeSupplier), cachedClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Node, U> T doInsertChildNode(Node[] nodes, int nodeIndex, Class<U> cachedClass, NodeSupplier<T> nodeSupplier) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        Lock lock = this.getLock();
        lock.lock();
        try {
            Node node = nodes[nodeIndex];
            if (node != null && node.getClass() == cachedClass) {
                Node node2 = node;
                return (T)node2;
            }
            Node newNode2 = (Node)nodeSupplier.get();
            this.doInsertChildNode(nodes, nodeIndex, newNode2);
            Node node3 = newNode2;
            return (T)node3;
        }
        finally {
            lock.unlock();
        }
    }

    private <T extends Node> T insertChildNode(Node[] nodes, int nodeIndex, T uncached, Class<? extends T> cachedClass, NodeSupplier<T> nodeSupplier, boolean useCachedNodes) {
        if (!useCachedNodes) {
            return uncached;
        }
        Node node = nodes[nodeIndex];
        if (node != null && node.getClass() == cachedClass) {
            return (T)((Node)CompilerDirectives.castExact((Object)node, cachedClass));
        }
        return (T)((Node)CompilerDirectives.castExact(this.doInsertChildNode(nodes, nodeIndex, cachedClass, nodeSupplier), cachedClass));
    }

    private void doInsertChildNode(Node[] nodes, int nodeIndex, Node newNode2) {
        if (nodes == this.adoptedNodes) {
            nodes[nodeIndex] = this.insert(newNode2);
        } else {
            assert (nodes == this.instrumentationRoot.getInstrumentation().bciToHelperNode);
            this.instrumentationRoot.getInstrumentation().insertHelperNode(newNode2, nodeIndex);
        }
    }

    private PythonLanguage getLanguage() {
        return (PythonLanguage)this.getLanguage(PythonLanguage.class);
    }

    private boolean profileCondition(boolean value, byte[] localBC, int bci, boolean useCachedNodes) {
        if (!useCachedNodes) {
            return value;
        }
        if (this.conditionProfiles == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.conditionProfiles = new int[this.co.conditionProfileCount];
        }
        int index = Byte.toUnsignedInt(localBC[bci + 2]) | Byte.toUnsignedInt(localBC[bci + 3]) << 8;
        int t = this.conditionProfiles[index];
        int f = this.conditionProfiles[index + 1];
        boolean val = value;
        if (val) {
            if (t == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (f == 0) {
                val = true;
            }
            if (CompilerDirectives.inInterpreter() && t < 0x3FFFFFFF) {
                this.conditionProfiles[index] = t + 1;
            }
        } else {
            if (f == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            if (t == 0) {
                val = false;
            }
            if (CompilerDirectives.inInterpreter() && f < 0x3FFFFFFF) {
                this.conditionProfiles[index + 1] = f + 1;
            }
        }
        if (CompilerDirectives.inInterpreter()) {
            return val;
        }
        int sum = t + f;
        return CompilerDirectives.injectBranchProbability((double)((double)t / (double)sum), (boolean)val);
    }

    public Object getOSRMetadata() {
        return this.osrMetadata;
    }

    public void setOSRMetadata(Object osrMetadata) {
        this.osrMetadata = osrMetadata;
    }

    @ExplodeLoop
    private void copyArgs(Object[] args, Frame localFrame) {
        int i;
        boolean inCompiledCode = CompilerDirectives.inCompiledCode();
        if (this.variableTypes == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.copyArgsFirstTime(args, localFrame);
            return;
        }
        int argCount = this.co.getRegularArgCount();
        for (i = 0; i < argCount; ++i) {
            Object arg = args[i + 9];
            byte type = this.variableTypes[i];
            if ((type & 1) != 0) {
                localFrame.setObject(i, arg);
                continue;
            }
            if ((type & 2) != 0) {
                if (arg instanceof Integer) {
                    if (inCompiledCode || (type & 0xFFFFFF80) != 0) {
                        localFrame.setInt(i, ((Integer)arg).intValue());
                        continue;
                    }
                    localFrame.setObject(i, arg);
                    continue;
                }
            } else if ((type & 4) != 0) {
                if (arg instanceof Long) {
                    if (inCompiledCode || (type & 0xFFFFFF80) != 0) {
                        localFrame.setLong(i, ((Long)arg).longValue());
                        continue;
                    }
                    localFrame.setObject(i, arg);
                    continue;
                }
            } else if ((type & 8) != 0) {
                if (arg instanceof Double) {
                    if (inCompiledCode || (type & 0xFFFFFF80) != 0) {
                        localFrame.setDouble(i, ((Double)arg).doubleValue());
                        continue;
                    }
                    localFrame.setObject(i, arg);
                    continue;
                }
            } else if ((type & 0x10) != 0 && arg instanceof Boolean) {
                if (inCompiledCode || (type & 0xFFFFFF80) != 0) {
                    localFrame.setBoolean(i, ((Boolean)arg).booleanValue());
                    continue;
                }
                localFrame.setObject(i, arg);
                continue;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.generalizeVariableStores(i);
            this.variableTypes[i] = 1;
            localFrame.setObject(i, arg);
        }
        if (inCompiledCode != CompilerDirectives.inCompiledCode()) {
            for (i = 0; i < argCount; ++i) {
                if (this.variableTypes[i] == 0 || (this.variableTypes[i] & 0xFFFFFF80) != 0 || localFrame.isObject(i)) continue;
                localFrame.setObject(i, localFrame.getValue(i));
            }
        }
    }

    private void copyArgsFirstTime(Object[] args, Frame localFrame) {
        CompilerAsserts.neverPartOfCompilation();
        this.variableTypes = new byte[this.varnames.length];
        int argCount = this.co.getRegularArgCount();
        for (int i = 0; i < argCount; ++i) {
            Object arg = args[i + 9];
            if (arg instanceof Integer) {
                this.variableTypes[i] = 2;
                if ((this.variableShouldUnbox[i] & 2) != 0) {
                    int n = i;
                    this.variableTypes[n] = (byte)(this.variableTypes[n] | 0xFFFFFF80);
                    localFrame.setInt(i, ((Integer)arg).intValue());
                    continue;
                }
            } else if (arg instanceof Long) {
                this.variableTypes[i] = 4;
                if ((this.variableShouldUnbox[i] & 4) != 0) {
                    int n = i;
                    this.variableTypes[n] = (byte)(this.variableTypes[n] | 0xFFFFFF80);
                    localFrame.setLong(i, ((Long)arg).longValue());
                    continue;
                }
            } else if (arg instanceof Double) {
                this.variableTypes[i] = 8;
                if ((this.variableShouldUnbox[i] & 8) != 0) {
                    int n = i;
                    this.variableTypes[n] = (byte)(this.variableTypes[n] | 0xFFFFFF80);
                    localFrame.setDouble(i, ((Double)arg).doubleValue());
                    continue;
                }
            } else if (arg instanceof Boolean) {
                this.variableTypes[i] = 16;
                if ((this.variableShouldUnbox[i] & 0x10) != 0) {
                    int n = i;
                    this.variableTypes[n] = (byte)(this.variableTypes[n] | 0xFFFFFF80);
                    localFrame.setBoolean(i, ((Boolean)arg).booleanValue());
                    continue;
                }
            } else {
                this.variableTypes[i] = 1;
            }
            localFrame.setObject(i, arg);
        }
    }

    public void createGeneratorFrame(Object[] arguments) {
        Object[] generatorFrameArguments = PArguments.create();
        MaterializedFrame generatorFrame = Truffle.getRuntime().createMaterializedFrame(generatorFrameArguments, this.getFrameDescriptor());
        PArguments.setGeneratorFrame(arguments, generatorFrame);
        PArguments.setCurrentFrameInfo(generatorFrameArguments, new PFrame.Reference(this.getRootNode(), null));
        PArguments.setException(arguments, null);
        PArguments.setCallerFrameInfo(arguments, null);
        this.copyArgsAndCells((Frame)generatorFrame, arguments);
    }

    private void copyArgsAndCells(Frame localFrame, Object[] arguments) {
        this.copyArgs(arguments, localFrame);
        int varIdx = this.co.getRegularArgCount();
        if (this.co.takesVarArgs()) {
            localFrame.setObject(varIdx++, (Object)PFactory.createTuple(this.getLanguage(), PArguments.getVariableArguments(arguments)));
        }
        if (this.co.takesVarKeywordArgs()) {
            localFrame.setObject(varIdx, (Object)PFactory.createDict(this.getLanguage(), PArguments.getKeywordArguments(arguments)));
        }
        this.initCellVars(localFrame);
        this.initFreeVars(localFrame, arguments);
    }

    int getInitialStackTop() {
        return this.stackoffset - 1;
    }

    public Object execute(VirtualFrame virtualFrame) {
        this.calleeContext.enter(virtualFrame);
        try {
            if (!this.co.isGeneratorOrCoroutine()) {
                this.copyArgsAndCells((Frame)virtualFrame, virtualFrame.getArguments());
            }
            Object object = this.executeFromBci(virtualFrame, (Frame)virtualFrame, this, 0, this.getInitialStackTop());
            return object;
        }
        finally {
            this.calleeContext.exit(virtualFrame, this);
        }
    }

    public Object[] storeParentFrameInArguments(VirtualFrame parentFrame) {
        Object[] arguments = parentFrame.getArguments();
        PArguments.setOSRFrame(arguments, parentFrame);
        return arguments;
    }

    public Frame restoreParentFrameFromArguments(Object[] arguments) {
        return PArguments.getOSRFrame(arguments);
    }

    public Object executeOSR(VirtualFrame osrFrame, int target, Object interpreterStateObject) {
        OSRInterpreterState interpreterState = (OSRInterpreterState)interpreterStateObject;
        return this.executeFromBci(osrFrame, (Frame)osrFrame, this, target, interpreterState.stackTop);
    }

    Object executeFromBci(VirtualFrame virtualFrame, Frame localFrame, BytecodeOSRNode osrNode, int initialBci, int initialStackTop) {
        if (this.usingCachedNodes) {
            return this.executeCached(virtualFrame, localFrame, osrNode, initialBci, initialStackTop, false);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.usingCachedNodes = true;
        Object result = this.executeUncached(virtualFrame, localFrame, osrNode, initialBci, initialStackTop);
        if (result instanceof InterpreterContinuation) {
            InterpreterContinuation continuation = (InterpreterContinuation)result;
            return this.executeCached(virtualFrame, localFrame, osrNode, continuation.bci, continuation.stackTop, true);
        }
        return result;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private Object executeCached(VirtualFrame virtualFrame, Frame localFrame, BytecodeOSRNode osrNode, int initialBci, int initialStackTop, boolean fromOSR) {
        return this.bytecodeLoop(virtualFrame, localFrame, osrNode, initialBci, initialStackTop, true, fromOSR);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private Object executeUncached(VirtualFrame virtualFrame, Frame localFrame, BytecodeOSRNode osrNode, int initialBci, int initialStackTop) {
        return this.bytecodeLoop(virtualFrame, localFrame, osrNode, initialBci, initialStackTop, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.MERGE_EXPLODE)
    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private Object bytecodeLoop(VirtualFrame virtualFrame, Frame localFrame, BytecodeOSRNode osrNode, int initialBci, int initialStackTop, boolean useCachedNodes, boolean fromOSR) {
        Object result;
        boolean hasUnboxedLocals = CompilerDirectives.inCompiledCode();
        Object[] arguments = virtualFrame.getArguments();
        PythonObject globals = PArguments.getGlobals(arguments);
        Object locals = PArguments.getSpecialArgument(arguments);
        boolean isGeneratorOrCoroutine = this.co.isGeneratorOrCoroutine();
        if (hasUnboxedLocals && !isGeneratorOrCoroutine) {
            this.unboxVariables(localFrame);
        }
        PythonLanguage language = (PythonLanguage)this.getLanguage(PythonLanguage.class);
        Assumption noTraceOrProfile = language.noTracingOrProfilingAssumption;
        InstrumentationSupport instrumentation = this.instrumentationRoot.getInstrumentation();
        if (instrumentation != null && !fromOSR && (result = this.notifyEnter(virtualFrame, instrumentation, initialBci)) != null) {
            return result;
        }
        MutableLoopData mutableData = new MutableLoopData();
        int stackTop = initialStackTop;
        int bci = initialBci;
        byte[] localBC = this.bytecode;
        Object[] localConsts = this.consts;
        long[] localLongConsts = this.longConsts;
        TruffleString[] localNames = this.names;
        Node[] localNodes = this.getChildNodes();
        int bciSlot = this.bcioffset;
        int localCelloffset = this.celloffset;
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, initialBci);
        CompilerAsserts.partialEvaluationConstant((Object)localBC);
        CompilerAsserts.partialEvaluationConstant((int)bci);
        CompilerAsserts.partialEvaluationConstant((int)stackTop);
        byte tracingOrProfilingEnabled = 0;
        if (!fromOSR) {
            tracingOrProfilingEnabled = this.checkTracingAndProfilingEnabled(noTraceOrProfile, mutableData);
            this.traceOrProfileCall(virtualFrame, initialBci, mutableData, tracingOrProfilingEnabled);
        }
        int oparg = 0;
        block174: while (true) {
            int stackDiff;
            byte bc = localBC[bci];
            int beginBci = bci;
            tracingOrProfilingEnabled = this.checkTracingAndProfilingEnabled(noTraceOrProfile, mutableData);
            if (PBytecodeRootNode.isTracingEnabled(tracingOrProfilingEnabled) && (stackDiff = this.traceLine(virtualFrame, mutableData, localBC, bci)) <= 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                bci = mutableData.getJumpBci();
                stackTop += stackDiff;
                continue;
            }
            CompilerAsserts.partialEvaluationConstant((int)bc);
            CompilerAsserts.partialEvaluationConstant((int)bci);
            CompilerAsserts.partialEvaluationConstant((int)stackTop);
            try {
                switch (bc) {
                    case 54: {
                        virtualFrame.setObject(++stackTop, (Object)PNone.NONE);
                        break;
                    }
                    case 55: {
                        virtualFrame.setObject(++stackTop, (Object)PEllipsis.INSTANCE);
                        break;
                    }
                    case 114: {
                        virtualFrame.setBoolean(++stackTop, true);
                        break;
                    }
                    case 113: {
                        virtualFrame.setObject(++stackTop, (Object)true);
                        break;
                    }
                    case 116: {
                        virtualFrame.setBoolean(++stackTop, false);
                        break;
                    }
                    case 115: {
                        virtualFrame.setObject(++stackTop, (Object)false);
                        break;
                    }
                    case 118: {
                        virtualFrame.setInt(++stackTop, (int)localBC[++bci]);
                        break;
                    }
                    case 117: {
                        virtualFrame.setObject(++stackTop, (Object)localBC[++bci]);
                        break;
                    }
                    case 120: {
                        virtualFrame.setInt(++stackTop, (int)localLongConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]);
                        break;
                    }
                    case 119: {
                        virtualFrame.setObject(++stackTop, (Object)((int)localLongConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]));
                        break;
                    }
                    case 122: {
                        virtualFrame.setLong(++stackTop, localLongConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]);
                        break;
                    }
                    case 121: {
                        virtualFrame.setObject(++stackTop, (Object)localLongConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]);
                        break;
                    }
                    case 124: {
                        virtualFrame.setDouble(++stackTop, Double.longBitsToDouble(localLongConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]));
                        break;
                    }
                    case 123: {
                        virtualFrame.setObject(++stackTop, (Object)Double.longBitsToDouble(localLongConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]));
                        break;
                    }
                    case 62: {
                        virtualFrame.setObject(++stackTop, (Object)PFactory.createInt(language, (BigInteger)localConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]));
                        break;
                    }
                    case 29: 
                    case 63: {
                        virtualFrame.setObject(++stackTop, localConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]);
                        break;
                    }
                    case 64: {
                        virtualFrame.setObject(++stackTop, (Object)PFactory.createBytes(language, (byte[])localConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])]));
                        break;
                    }
                    case 66: {
                        oparg |= Byte.toUnsignedInt(localBC[++bci]);
                        int typeAndKind = Byte.toUnsignedInt(localBC[++bci]);
                        Object array = localConsts[oparg];
                        this.bytecodeLoadConstCollection(virtualFrame, ++stackTop, array, typeAndKind);
                        break;
                    }
                    case 65: {
                        double[] num = (double[])localConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])];
                        virtualFrame.setObject(++stackTop, (Object)PFactory.createComplex(language, num[0], num[1]));
                        break;
                    }
                    case 96: {
                        TruffleString key = (TruffleString)localConsts[oparg |= Byte.toUnsignedInt(localBC[++bci])];
                        Object value = virtualFrame.getObject(stackTop);
                        virtualFrame.setObject(stackTop, (Object)new PKeyword(key, value));
                        break;
                    }
                    case 40: {
                        int count = Byte.toUnsignedInt(localBC[++bci]);
                        stackTop = this.bytecodeBuildSlice(virtualFrame, stackTop, beginBci, count, localNodes, useCachedNodes);
                        break;
                    }
                    case 41: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int options = Byte.toUnsignedInt(localBC[++bci]);
                        stackTop = this.bytecodeFormatValue(virtualFrame, stackTop, beginBci, localNodes, options, useCachedNodes);
                        break;
                    }
                    case 91: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int type = Byte.toUnsignedInt(localBC[++bci]);
                        this.bytecodeCollectionFromCollection(virtualFrame, type, stackTop, localNodes, beginBci, useCachedNodes);
                        break;
                    }
                    case 90: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int type = Byte.toUnsignedInt(localBC[++bci]);
                        stackTop = this.bytecodeCollectionAddCollection(virtualFrame, type, stackTop, localNodes, beginBci, useCachedNodes);
                        break;
                    }
                    case 88: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int countAndType = Byte.toUnsignedInt(localBC[++bci]);
                        int count = OpCodes.CollectionBits.elementCount(countAndType);
                        int type = OpCodes.CollectionBits.collectionKind(countAndType);
                        stackTop = this.bytecodeCollectionFromStack(virtualFrame, type, count, stackTop, localNodes, beginBci, useCachedNodes);
                        break;
                    }
                    case 89: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int countAndType = Byte.toUnsignedInt(localBC[++bci]);
                        int count = OpCodes.CollectionBits.elementCount(countAndType);
                        int type = OpCodes.CollectionBits.collectionKind(countAndType);
                        stackTop = this.bytecodeCollectionFromStack(virtualFrame, type, count, stackTop, localNodes, beginBci, useCachedNodes);
                        stackTop = this.bytecodeCollectionAddCollection(virtualFrame, type, stackTop, localNodes, beginBci + 1, useCachedNodes);
                        break;
                    }
                    case 94: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int depthAndType = Byte.toUnsignedInt(localBC[++bci]);
                        int depth = OpCodes.CollectionBits.elementCount(depthAndType);
                        int type = OpCodes.CollectionBits.collectionKind(depthAndType);
                        stackTop = this.bytecodeAddToCollection(virtualFrame, stackTop, beginBci, localNodes, depth, type, useCachedNodes);
                        break;
                    }
                    case 92: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeTupleFromList(virtualFrame, stackTop);
                        break;
                    }
                    case 93: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeFrozensetFromList(virtualFrame, stackTop, beginBci, localNodes);
                        break;
                    }
                    case 95: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeKwargsMerge(virtualFrame, useCachedNodes, stackTop, bci, localNodes);
                        break;
                    }
                    case 73: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeUnpackSequence(virtualFrame, stackTop, beginBci, localNodes, oparg |= Byte.toUnsignedInt(localBC[++bci]), useCachedNodes);
                        break;
                    }
                    case 74: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        oparg |= Byte.toUnsignedInt(localBC[++bci]);
                        int countAfter = Byte.toUnsignedInt(localBC[++bci]);
                        stackTop = this.bytecodeUnpackEx(virtualFrame, stackTop, beginBci, localNodes, oparg, countAfter, useCachedNodes);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 30: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastAdaptive(virtualFrame, localFrame, ++stackTop, localBC, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case 125: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastO(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case 127: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastI(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case 126: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastIBox(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case -127: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastL(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case -128: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastLBox(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case -125: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastD(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case -126: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastDBox(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case -123: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastB(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case -124: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeLoadFastBBox(virtualFrame, localFrame, ++stackTop, bci++, oparg, localNodes, hasUnboxedLocals);
                        break;
                    }
                    case 82: {
                        PCell cell = (PCell)localFrame.getObject(localCelloffset + (oparg |= Byte.toUnsignedInt(localBC[++bci])));
                        virtualFrame.setObject(++stackTop, (Object)cell);
                        break;
                    }
                    case 83: {
                        stackTop = this.bytecodeClosureFromStack(virtualFrame, stackTop, oparg |= Byte.toUnsignedInt(localBC[++bci]));
                        break;
                    }
                    case 33: {
                        stackTop = this.bytecodeLoadDeref(virtualFrame, localFrame, stackTop, beginBci, localNodes, oparg |= Byte.toUnsignedInt(localBC[++bci]), localCelloffset, useCachedNodes);
                        break;
                    }
                    case 34: {
                        stackTop = this.bytecodeStoreDeref(virtualFrame, localFrame, stackTop, oparg |= Byte.toUnsignedInt(localBC[++bci]), localCelloffset);
                        break;
                    }
                    case 35: {
                        this.bytecodeDeleteDeref(localFrame, beginBci, localNodes, oparg |= Byte.toUnsignedInt(localBC[++bci]), localCelloffset, useCachedNodes);
                        break;
                    }
                    case 31: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastAdaptive(virtualFrame, localFrame, stackTop--, bci++, localBC, oparg, hasUnboxedLocals);
                        break;
                    }
                    case -122: {
                        this.bytecodeStoreFastO(virtualFrame, localFrame, stackTop--, oparg |= Byte.toUnsignedInt(localBC[bci + 1]));
                        ++bci;
                        break;
                    }
                    case -121: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastUnboxI(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -120: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastBoxedI(virtualFrame, localFrame, stackTop--, bci++, oparg, hasUnboxedLocals);
                        break;
                    }
                    case -119: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastI(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -118: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastUnboxL(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -117: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastBoxedL(virtualFrame, localFrame, stackTop--, bci++, oparg, hasUnboxedLocals);
                        break;
                    }
                    case -116: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastL(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -115: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastUnboxD(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -114: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastBoxedD(virtualFrame, localFrame, stackTop--, bci++, oparg, hasUnboxedLocals);
                        break;
                    }
                    case -113: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastD(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -112: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastUnboxB(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case -111: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastBoxedB(virtualFrame, localFrame, stackTop--, bci++, oparg, hasUnboxedLocals);
                        break;
                    }
                    case -110: {
                        oparg |= Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeStoreFastB(virtualFrame, localFrame, stackTop--, bci++, oparg);
                        break;
                    }
                    case 0: {
                        virtualFrame.clear(stackTop--);
                        break;
                    }
                    case 1: {
                        Object top = virtualFrame.getObject(stackTop);
                        virtualFrame.setObject(stackTop, virtualFrame.getObject(stackTop - 1));
                        virtualFrame.setObject(stackTop - 1, top);
                        break;
                    }
                    case 2: {
                        Object top = virtualFrame.getObject(stackTop);
                        virtualFrame.setObject(stackTop, virtualFrame.getObject(stackTop - 1));
                        virtualFrame.setObject(stackTop - 1, virtualFrame.getObject(stackTop - 2));
                        virtualFrame.setObject(stackTop - 2, top);
                        break;
                    }
                    case 3: {
                        this.bytcodeRotN(virtualFrame, stackTop, oparg |= Byte.toUnsignedInt(localBC[++bci]));
                        break;
                    }
                    case 48: {
                        stackTop = this.bytecodeCheckTpFlags(virtualFrame, 32L, useCachedNodes, stackTop, bci, localNodes);
                        break;
                    }
                    case 49: {
                        stackTop = this.bytecodeCheckTpFlags(virtualFrame, 64L, useCachedNodes, stackTop, bci, localNodes);
                        break;
                    }
                    case 51: {
                        stackTop = this.bytecodeMatchKeys(virtualFrame, stackTop, bci, localNodes);
                        break;
                    }
                    case 52: {
                        this.bytecodeCopyDictWithoutKeys(virtualFrame, stackTop, bci, localNodes);
                        break;
                    }
                    case 50: {
                        stackTop = this.bytecodeMatchClass(virtualFrame, stackTop, oparg |= Byte.toUnsignedInt(localBC[++bci]), bci, localNodes);
                        break;
                    }
                    case 53: {
                        stackTop = this.bytecodeGetLen(virtualFrame, useCachedNodes, stackTop, bci, localNodes);
                        break;
                    }
                    case 4: {
                        virtualFrame.setObject(stackTop + 1, virtualFrame.getObject(stackTop));
                        ++stackTop;
                        break;
                    }
                    case 6: {
                        this.bytecodeUnaryOpAdaptive(virtualFrame, stackTop, bci++, localBC, localNodes);
                        break;
                    }
                    case -109: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpOO(virtualFrame, stackTop, bci++, localNodes, op, bciSlot);
                        break;
                    }
                    case -107: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpII(virtualFrame, stackTop, bci++, localNodes, op);
                        break;
                    }
                    case -108: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpIO(virtualFrame, stackTop, bci++, localNodes, op);
                        break;
                    }
                    case -105: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpDD(virtualFrame, stackTop, bci++, localNodes, op);
                        break;
                    }
                    case -106: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpDO(virtualFrame, stackTop, bci++, localNodes, op);
                        break;
                    }
                    case -103: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpBB(virtualFrame, stackTop, bci++, localNodes, op);
                        break;
                    }
                    case -104: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeUnaryOpBO(virtualFrame, stackTop, bci++, localNodes, op);
                        break;
                    }
                    case 7: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpAdaptive(virtualFrame, stackTop--, localBC, bci++, localNodes, op, useCachedNodes);
                        break;
                    }
                    case -102: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpOOO(virtualFrame, stackTop--, bci++, localNodes, op, bciSlot);
                        break;
                    }
                    case -100: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpIII(virtualFrame, stackTop--, bci++, localNodes, op, useCachedNodes);
                        break;
                    }
                    case -99: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpIIB(virtualFrame, stackTop--, bci++, localNodes, op);
                        break;
                    }
                    case -101: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpIIO(virtualFrame, stackTop--, bci++, localNodes, op);
                        break;
                    }
                    case -97: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpDDD(virtualFrame, stackTop--, bci++, localNodes, op, useCachedNodes);
                        break;
                    }
                    case -96: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpDDB(virtualFrame, stackTop--, bci++, localNodes, op);
                        break;
                    }
                    case -98: {
                        int op = Byte.toUnsignedInt(localBC[bci + 1]);
                        this.bytecodeBinaryOpDDO(virtualFrame, stackTop--, bci++, localNodes, op, useCachedNodes);
                        break;
                    }
                    case 8: {
                        stackTop = this.bytecodeBinarySubscrAdaptive(virtualFrame, stackTop, bci, localNodes, bciSlot);
                        break;
                    }
                    case -91: {
                        stackTop = this.bytecodeBinarySubscrSeqII(virtualFrame, stackTop, bci, localNodes);
                        break;
                    }
                    case -90: {
                        stackTop = this.bytecodeBinarySubscrSeqID(virtualFrame, stackTop, bci, localNodes);
                        break;
                    }
                    case -92: {
                        stackTop = this.bytecodeBinarySubscrSeqIO(virtualFrame, stackTop, bci, localNodes);
                        break;
                    }
                    case -93: {
                        stackTop = this.bytecodeBinarySubscrOO(virtualFrame, stackTop, bci, localNodes, bciSlot);
                        break;
                    }
                    case 9: {
                        stackTop = this.bytecodeStoreSubscrAdaptive(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes, bciSlot);
                        break;
                    }
                    case -89: {
                        stackTop = this.bytecodeStoreSubscrOOO(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes, bciSlot);
                        break;
                    }
                    case -88: {
                        stackTop = this.bytecodeStoreSubscrSeqIOO(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes);
                        break;
                    }
                    case -87: {
                        stackTop = this.bytecodeStoreSubscrSeqIIO(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes);
                        break;
                    }
                    case -86: {
                        stackTop = this.bytecodeStoreSubscrSeqIDO(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes);
                        break;
                    }
                    case 10: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeDeleteSubscr(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes);
                        break;
                    }
                    case 39: {
                        int count = Byte.toUnsignedInt(localBC[bci + 1]);
                        throw this.bytecodeRaiseVarargs(virtualFrame, stackTop, beginBci, count, localNodes);
                    }
                    case 18: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        return this.bytecodeReturnValue(virtualFrame, isGeneratorOrCoroutine, instrumentation, mutableData, stackTop, tracingOrProfilingEnabled, beginBci);
                    }
                    case 16: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeLoadBuildClass(virtualFrame, useCachedNodes, ++stackTop, localNodes, beginBci);
                        break;
                    }
                    case 17: {
                        virtualFrame.setObject(++stackTop, (Object)PythonBuiltinClassType.AssertionError);
                        break;
                    }
                    case 20: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeStoreName(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNames, localNodes, useCachedNodes);
                        break;
                    }
                    case 21: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeDeleteName(virtualFrame, globals, locals, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNames, localNodes, useCachedNodes);
                        break;
                    }
                    case 24: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeStoreAttr(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, localNames, useCachedNodes);
                        break;
                    }
                    case 25: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeDeleteAttr(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, localNames, useCachedNodes);
                        break;
                    }
                    case 27: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeStoreGlobal(virtualFrame, globals, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, localNames, useCachedNodes);
                        break;
                    }
                    case 28: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeDeleteGlobal(virtualFrame, globals, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, localNames, useCachedNodes);
                        break;
                    }
                    case 19: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeLoadName(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, localNames, useCachedNodes);
                        break;
                    }
                    case 26: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeLoadGlobal(virtualFrame, globals, stackTop, beginBci, localNames[oparg |= Byte.toUnsignedInt(localBC[++bci])], localNodes, useCachedNodes);
                        break;
                    }
                    case 32: {
                        this.bytecodeDeleteFast(localFrame, beginBci, localNodes, oparg |= Byte.toUnsignedInt(localBC[++bci]));
                        break;
                    }
                    case 22: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeLoadAttr(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, localNames, useCachedNodes);
                        break;
                    }
                    case 43: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeImportName(virtualFrame, globals, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNames, localNodes, useCachedNodes);
                        break;
                    }
                    case 44: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeImportFrom(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNames, localNodes, useCachedNodes);
                        break;
                    }
                    case 45: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeImportStar(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNames, localNodes, useCachedNodes);
                        break;
                    }
                    case 76: {
                        oparg = 0;
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        continue block174;
                    }
                    case 80: {
                        this.bytecodePopAndJumpIfFalse(virtualFrame, bci, stackTop);
                        continue block174;
                    }
                    case 81: {
                        this.bytecodePopAndJumpIfTrue(virtualFrame, bci, stackTop);
                        continue block174;
                    }
                    case -85: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        if (this.profileCondition(!this.bytecodePopCondition(virtualFrame, stackTop--, localNodes, bci, useCachedNodes), localBC, bci, useCachedNodes)) {
                            oparg = 0;
                            this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                            continue block174;
                        }
                        bci += 3;
                        break;
                    }
                    case -83: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        if (this.profileCondition(this.bytecodePopCondition(virtualFrame, stackTop--, localNodes, bci, useCachedNodes), localBC, bci, useCachedNodes)) {
                            oparg = 0;
                            this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                            continue block174;
                        }
                        bci += 3;
                        break;
                    }
                    case -84: {
                        if (!virtualFrame.isBoolean(stackTop)) {
                            this.generalizePopAndJumpIfFalseB(bci);
                            continue block174;
                        }
                        boolean cond = virtualFrame.getBoolean(stackTop);
                        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
                        if (this.profileCondition(!cond, localBC, bci, useCachedNodes)) {
                            oparg = 0;
                            this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                            continue block174;
                        }
                        bci += 3;
                        break;
                    }
                    case -82: {
                        if (!virtualFrame.isBoolean(stackTop)) {
                            this.generalizePopAndJumpIfTrueB(bci);
                            continue block174;
                        }
                        boolean cond = virtualFrame.getBoolean(stackTop);
                        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
                        if (this.profileCondition(cond, localBC, bci, useCachedNodes)) {
                            oparg = 0;
                            this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                            continue block174;
                        }
                        bci += 3;
                        break;
                    }
                    case 78: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean cond = this.evaluateObjectCondition(virtualFrame, useCachedNodes, stackTop, bci, localBC, localNodes, beginBci);
                        if (cond) {
                            virtualFrame.clear(stackTop--);
                            bci += 3;
                            break;
                        }
                        oparg = 0;
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        continue block174;
                    }
                    case 79: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean cond = this.evaluateObjectCondition(virtualFrame, useCachedNodes, stackTop, bci, localBC, localNodes, beginBci);
                        if (cond) {
                            oparg = 0;
                            this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                            continue block174;
                        }
                        virtualFrame.clear(stackTop--);
                        bci += 3;
                        break;
                    }
                    case 77: {
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci -= (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        if (CompilerDirectives.hasNextTier()) {
                            ++mutableData.loopCount;
                        }
                        if (CompilerDirectives.inInterpreter()) {
                            if (!useCachedNodes) {
                                return new InterpreterContinuation(bci, stackTop);
                            }
                            if (BytecodeOSRNode.pollOSRBackEdge((BytecodeOSRNode)osrNode, (int)1)) {
                                Object osrResult;
                                try {
                                    osrResult = BytecodeOSRNode.tryOSR((BytecodeOSRNode)osrNode, (int)bci, (Object)new OSRInterpreterState(stackTop), null, (VirtualFrame)virtualFrame);
                                }
                                catch (AbstractTruffleException e) {
                                    throw new OSRException(e);
                                }
                                if (osrResult != null) {
                                    if (!CompilerDirectives.hasNextTier() || mutableData.loopCount <= 0) return osrResult;
                                    LoopNode.reportLoopCount((Node)this, (int)mutableData.loopCount);
                                    return osrResult;
                                }
                            }
                        }
                        PythonContext.triggerAsyncActions((Node)this);
                        oparg = 0;
                        continue block174;
                    }
                    case 11: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeGetIter(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 12: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeGetYieldFromIter(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 75: {
                        this.bytecodeForIterAdaptive(bci);
                        continue block174;
                    }
                    case -95: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean shouldLoop = this.bytecodeForIterO(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        if (shouldLoop) {
                            ++stackTop;
                            ++bci;
                            break;
                        }
                        virtualFrame.clear(stackTop--);
                        oparg = 0;
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        continue block174;
                    }
                    case -94: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean shouldLoop = this.bytecodeForIterI(virtualFrame, useCachedNodes, stackTop, bci, localNodes, beginBci);
                        if (shouldLoop) {
                            ++stackTop;
                            ++bci;
                            break;
                        }
                        virtualFrame.clear(stackTop--);
                        oparg = 0;
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        continue block174;
                    }
                    case 23: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeLoadMethod(virtualFrame, stackTop, bci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNames, localNodes, useCachedNodes);
                        break;
                    }
                    case 68: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        int argcount = Byte.toUnsignedInt(localBC[++bci]);
                        stackTop = this.bytecodeCallMethod(virtualFrame, stackTop, beginBci, argcount, localNodes, useCachedNodes, mutableData, tracingOrProfilingEnabled);
                        break;
                    }
                    case 67: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeCallMethodVarargs(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes, mutableData, tracingOrProfilingEnabled);
                        break;
                    }
                    case 69: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeCallFunction(virtualFrame, stackTop, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]), localNodes, useCachedNodes, mutableData, tracingOrProfilingEnabled);
                        break;
                    }
                    case 70: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeCallComprehension(virtualFrame, stackTop, beginBci, localNodes, mutableData, tracingOrProfilingEnabled);
                        break;
                    }
                    case 72: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeCallFunctionVarargs(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes, mutableData, tracingOrProfilingEnabled);
                        break;
                    }
                    case 71: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeCallFunctionKw(virtualFrame, stackTop, beginBci, localNodes, useCachedNodes, mutableData, tracingOrProfilingEnabled);
                        break;
                    }
                    case 84: {
                        oparg |= Byte.toUnsignedInt(localBC[++bci]);
                        int flags = Byte.toUnsignedInt(localBC[++bci]);
                        stackTop = this.bytecodeMakeFunction(virtualFrame, globals, stackTop, localNodes, beginBci, flags, localConsts[oparg]);
                        break;
                    }
                    case 47: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        this.bytecodeSetupAnnotations(virtualFrame, useCachedNodes, localNodes, beginBci);
                        break;
                    }
                    case 97: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean match = this.bytecodeMatchExc(virtualFrame, useCachedNodes, stackTop--, localNodes, beginBci);
                        if (this.profileCondition(!match, localBC, bci, useCachedNodes)) {
                            oparg = 0;
                            this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                            continue block174;
                        }
                        bci += 3;
                        break;
                    }
                    case 101: {
                        this.bytecodeUnwrapExc(virtualFrame, stackTop);
                        break;
                    }
                    case 108: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeSetupWith(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 109: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeExitWith(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 110: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeSetupAWith(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 111: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeGetAExitCoro(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 112: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeExitAWith(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 14: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeGetAIter(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 15: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeGetANext(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 107: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        stackTop = this.bytecodeEndAsyncFor(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                        break;
                    }
                    case 103: {
                        virtualFrame.setObject(stackTop, (Object)PFactory.createAsyncGeneratorWrappedValue(language, virtualFrame.getObject(stackTop)));
                        break;
                    }
                    case 98: {
                        this.bytecodePushExcInfo(virtualFrame, arguments, mutableData, stackTop++);
                        break;
                    }
                    case 99: {
                        mutableData.localException = this.popExceptionState(arguments, virtualFrame.getObject(stackTop), mutableData.outerException);
                        virtualFrame.clear(stackTop--);
                        break;
                    }
                    case 100: {
                        mutableData.localException = this.popExceptionState(arguments, virtualFrame.getObject(stackTop - 1), mutableData.outerException);
                        throw this.bytecodeEndExcHandler(virtualFrame, stackTop);
                    }
                    case 102: {
                        return this.bytecodeYieldValue(virtualFrame, localFrame, initialStackTop, arguments, instrumentation, mutableData, stackTop, bci, tracingOrProfilingEnabled, beginBci);
                    }
                    case 104: {
                        this.bytecodeResumeYield(virtualFrame, useCachedNodes, arguments, mutableData, ++stackTop, bci, localNodes);
                        break;
                    }
                    case 105: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean returned = this.bytecodeSend(virtualFrame, stackTop, localNodes, beginBci);
                        if (!returned) {
                            ++bci;
                            break;
                        }
                        --stackTop;
                        oparg = 0;
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        continue block174;
                    }
                    case 106: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        boolean returned = this.bytecodeThrow(virtualFrame, stackTop, localNodes, beginBci);
                        if (!returned) {
                            ++bci;
                            break;
                        }
                        --stackTop;
                        oparg = 0;
                        this.notifyStatement(virtualFrame, instrumentation, mutableData, bci += (oparg |= Byte.toUnsignedInt(localBC[bci + 1])), beginBci);
                        continue block174;
                    }
                    case 13: {
                        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                        GetAwaitableNode getAwait = this.insertChildNode(localNodes, beginBci, UNCACHED_OBJECT_GET_AWAITABLE, GetAwaitableNodeGen.class, NODE_OBJECT_GET_AWAITABLE, useCachedNodes);
                        virtualFrame.setObject(stackTop, getAwait.execute(virtualFrame, virtualFrame.getObject(stackTop)));
                        break;
                    }
                    case 46: {
                        stackTop = this.bytecodePrintExpr(virtualFrame, useCachedNodes, stackTop, bci, localNodes, bciSlot, beginBci);
                        break;
                    }
                    case 42: {
                        oparg |= Byte.toUnsignedInt(localBC[++bci]);
                        oparg <<= 8;
                        ++bci;
                        continue block174;
                    }
                    case 37: 
                    case 38: 
                    case 85: {
                        stackTop = this.infrequentBytecodes(virtualFrame, localFrame, bc, bci, stackTop, beginBci, oparg, localBC, globals, locals, localNames, localNodes, bciSlot, localCelloffset, useCachedNodes);
                        ++bci;
                        break;
                    }
                    case 36: 
                    case 86: 
                    case 87: {
                        stackTop = this.infrequentBytecodes(virtualFrame, localFrame, bc, bci, stackTop, beginBci, oparg, localBC, globals, locals, localNames, localNodes, bciSlot, localCelloffset, useCachedNodes);
                        break;
                    }
                    default: {
                        throw this.raiseUnknownBytecodeError(bc);
                    }
                }
                oparg = 0;
                this.notifyStatement(virtualFrame, instrumentation, mutableData, ++bci, beginBci);
                continue;
            }
            catch (GeneratorReturnException | PythonExitException | PythonThreadKillException e) {
                throw e;
            }
            catch (OSRException e) {
                throw e.exception;
            }
            catch (Throwable e) {
                try {
                    AbstractTruffleException exception;
                    if (instrumentation != null) {
                        if (!mutableData.isExceptionNotified()) {
                            this.notifyException(virtualFrame, instrumentation, beginBci, e);
                        }
                        mutableData.setExceptionNotified(false);
                    }
                    if (e instanceof ThreadDeath) {
                        throw e;
                    }
                    if (e instanceof AbstractTruffleException) {
                        exception = (AbstractTruffleException)e;
                    } else {
                        exception = this.wrapJavaExceptionIfApplicable(language, e);
                        if (exception == null) {
                            throw e;
                        }
                    }
                    tracingOrProfilingEnabled = this.checkTracingAndProfilingEnabled(noTraceOrProfile, mutableData);
                    if (PBytecodeRootNode.isTracingEnabled(tracingOrProfilingEnabled) && exception != null && !mutableData.getThreadState(this).isTracing()) {
                        this.traceException(virtualFrame, mutableData, beginBci, exception);
                    }
                    int targetIndex = this.findHandler(beginBci);
                    CompilerAsserts.partialEvaluationConstant((int)targetIndex);
                    this.chainPythonExceptions(virtualFrame, mutableData, exception);
                    if (targetIndex == -1) {
                        this.prepareForReraise(virtualFrame, localFrame, initialStackTop, isGeneratorOrCoroutine, mutableData, bciSlot, beginBci, tracingOrProfilingEnabled);
                        if (!(exception instanceof PException)) throw e;
                        ((PException)exception).notifyAddedTracebackFrame(this.frameIsVisibleToPython());
                        throw exception;
                    }
                    if (exception instanceof PException) {
                        ((PException)exception).setCatchingFrameReference((Frame)virtualFrame, this, beginBci);
                    }
                    int stackSizeOnEntry = this.exceptionHandlerRanges[targetIndex + 1];
                    int targetStackTop = stackSizeOnEntry + this.stackoffset;
                    stackTop = PBytecodeRootNode.unwindBlock(virtualFrame, stackTop, targetStackTop);
                    virtualFrame.setObject(stackTop, (Object)exception);
                    bci = this.exceptionHandlerRanges[targetIndex];
                    oparg = 0;
                    if (instrumentation == null) continue;
                    this.notifyStatementAfterException(virtualFrame, instrumentation, bci);
                    continue;
                }
                catch (Throwable t) {
                    if (instrumentation == null) throw t;
                    Object result2 = this.notifyExceptionalReturn(virtualFrame, mutableData, t);
                    if (result2 == ProbeNode.UNWIND_ACTION_REENTER) {
                        CompilerDirectives.transferToInterpreter();
                        this.copyArgs(virtualFrame.getArguments(), (Frame)virtualFrame);
                        bci = 0;
                        stackTop = this.getInitialStackTop();
                        oparg = 0;
                        result2 = this.notifyEnter(virtualFrame, instrumentation, bci);
                        if (result2 != null) return result2;
                        continue;
                    }
                    if (result2 == null) throw t;
                    return result2;
                }
            }
            break;
        }
    }

    private int infrequentBytecodes(VirtualFrame virtualFrame, Frame localFrame, byte bc, int bci, int stackTop, int beginBci, int oparg, byte[] localBC, Object globals, Object locals, TruffleString[] localNames, Node[] localNodes, int bciSlot, int localCelloffset, boolean useCachedNodes) {
        switch (bc) {
            case 36: {
                if (locals == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.NO_LOCALS_FOUND);
                }
                virtualFrame.setObject(++stackTop, locals);
                break;
            }
            case 37: {
                PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                stackTop = this.bytecodeLoadFromDictOrDeref(virtualFrame, localFrame, stackTop, beginBci, localNodes, oparg |= Byte.toUnsignedInt(localBC[++bci]), localCelloffset, useCachedNodes);
                break;
            }
            case 38: {
                PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
                stackTop = this.bytecodeLoadFromDictOrGlobals(virtualFrame, globals, stackTop, beginBci, localNames[oparg |= Byte.toUnsignedInt(localBC[++bci])], localNodes, useCachedNodes);
                break;
            }
            case 85: {
                stackTop = this.bytecodeMakeTypeParam(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci, oparg |= Byte.toUnsignedInt(localBC[++bci]));
                break;
            }
            case 86: {
                stackTop = this.bytecodeMakeTypeAlias(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                break;
            }
            case 87: {
                stackTop = this.bytecodeMakeGeneric(virtualFrame, useCachedNodes, stackTop, localNodes, beginBci);
                break;
            }
            default: {
                throw this.raiseUnknownBytecodeError(bc);
            }
        }
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeGetAIter(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int bci) {
        GetAIterNode node = this.insertChildNode(localNodes, bci, UNCACHED_GET_AITER, GetAIterNodeGen.class, NODE_GET_AITER, useCachedNodes);
        virtualFrame.setObject(stackTop, node.execute((Frame)virtualFrame, virtualFrame.getObject(stackTop)));
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeGetANext(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int bci) {
        GetANextNode node = this.insertChildNode(localNodes, bci, UNCACHED_GET_ANEXT, GetANextNodeGen.class, NODE_GET_ANEXT, useCachedNodes);
        virtualFrame.setObject(stackTop, node.execute(virtualFrame, virtualFrame.getObject(stackTop)));
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeEndAsyncFor(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int bci) {
        EndAsyncForNode node = this.insertChildNode(localNodes, bci, UNCACHED_END_ASYNC_FOR, EndAsyncForNodeGen.class, NODE_END_ASYNC_FOR, useCachedNodes);
        node.execute(virtualFrame.getObject(stackTop), this.frameIsVisibleToPython());
        virtualFrame.clear(stackTop);
        virtualFrame.clear(stackTop - 1);
        virtualFrame.clear(stackTop - 2);
        return stackTop - 3;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    @ExplodeLoop
    private void bytcodeRotN(VirtualFrame virtualFrame, int stackTop, int oparg) {
        CompilerAsserts.partialEvaluationConstant((int)oparg);
        if (oparg > 1) {
            int i;
            Object top = virtualFrame.getObject(stackTop);
            for (i = 0; i < oparg - 1; ++i) {
                virtualFrame.setObject(stackTop - i, virtualFrame.getObject(stackTop - i - 1));
            }
            virtualFrame.setObject(stackTop - i, top);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCheckTpFlags(VirtualFrame virtualFrame, long flags, boolean useCachedNodes, int stackTop, int bci, Node[] localNodes) {
        Object obj = virtualFrame.getObject(stackTop);
        GetTPFlagsNode flagsNode = this.insertChildNode(localNodes, bci, UNCACHED_TP_FLAGS, GetTPFlagsNodeGen.class, NODE_TP_FLAGS, useCachedNodes);
        boolean res = (flagsNode.execute(obj) & flags) != 0L;
        virtualFrame.setObject(++stackTop, (Object)res);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeMatchKeys(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        Object keys = virtualFrame.getObject(stackTop);
        Object subject = virtualFrame.getObject(stackTop - 1);
        MatchKeysNode matchKeysNode = this.insertChildNode(localNodes, bci, MatchKeysNodeGen.class, NODE_MATCH_KEYS);
        Object values = matchKeysNode.execute((Frame)virtualFrame, subject, (Object[])keys);
        virtualFrame.setObject(++stackTop, values);
        virtualFrame.setObject(++stackTop, (Object)(values != PNone.NONE ? 1 : 0));
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCopyDictWithoutKeys(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        Object keys = virtualFrame.getObject(stackTop);
        Object subject = virtualFrame.getObject(stackTop - 1);
        CopyDictWithoutKeysNode copyDictNode = this.insertChildNode(localNodes, bci, CopyDictWithoutKeysNodeGen.class, NODE_COPY_DICT_WITHOUT_KEYS);
        PDict rest = copyDictNode.execute((Frame)virtualFrame, subject, (Object[])keys);
        virtualFrame.setObject(stackTop, (Object)rest);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeMatchClass(VirtualFrame virtualFrame, int stackTop, int oparg, int bci, Node[] localNodes) {
        TruffleString[] argNames = (TruffleString[])virtualFrame.getObject(stackTop--);
        Object type = virtualFrame.getObject(stackTop);
        Object subject = virtualFrame.getObject(stackTop - 1);
        MatchClassNode matchClassNode = this.insertChildNode(localNodes, bci, MatchClassNodeGen.class, NODE_MATCH_CLASS);
        Object attrs = matchClassNode.execute((Frame)virtualFrame, subject, type, oparg, argNames);
        if (attrs != null) {
            virtualFrame.setObject(stackTop, (Object)true);
            virtualFrame.setObject(stackTop - 1, attrs);
        } else {
            virtualFrame.setObject(stackTop, (Object)false);
        }
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeGetLen(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, int bci, Node[] localNodes) {
        Object seq = virtualFrame.getObject(stackTop);
        PyObjectSizeNode sizeNode = this.insertChildNode(localNodes, bci, UNCACHED_SIZE, PyObjectSizeNodeGen.class, NODE_SIZE, useCachedNodes);
        Integer s = sizeNode.executeCached((Frame)virtualFrame, seq);
        virtualFrame.setObject(++stackTop, (Object)s);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeKwargsMerge(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, int bci, Node[] localNodes) {
        KwargsMergeNode mergeNode = this.insertChildNode(localNodes, bci, UNCACHED_KWARGS_MERGE, KwargsMergeNodeGen.class, NODE_KWARGS_MERGE, useCachedNodes);
        return mergeNode.execute((Frame)virtualFrame, stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean evaluateObjectCondition(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, int bci, byte[] localBC, Node[] localNodes, int beginBci) {
        PyObjectIsTrueNode isTrue = this.insertChildNode(localNodes, beginBci, UNCACHED_OBJECT_IS_TRUE, PyObjectIsTrueNodeGen.class, NODE_OBJECT_IS_TRUE, useCachedNodes);
        Object condObj = virtualFrame.getObject(stackTop);
        boolean cond = isTrue.execute((Frame)virtualFrame, condObj);
        return this.profileCondition(cond, localBC, bci, useCachedNodes);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeGetIter(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        PyObjectGetIter getIter = this.insertChildNode(localNodes, beginBci, UNCACHED_OBJECT_GET_ITER, PyObjectGetIterNodeGen.class, NODE_OBJECT_GET_ITER, useCachedNodes);
        virtualFrame.setObject(stackTop, getIter.executeCached((Frame)virtualFrame, virtualFrame.getObject(stackTop)));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeGetYieldFromIter(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        GetYieldFromIterNode getIter = this.insertChildNode(localNodes, beginBci, UNCACHED_OBJECT_GET_YIELD_FROM_ITER, GetYieldFromIterNodeGen.class, NODE_OBJECT_GET_YIELD_FROM_ITER, useCachedNodes);
        virtualFrame.setObject(stackTop, getIter.execute(virtualFrame, virtualFrame.getObject(stackTop)));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean bytecodeForIterO(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        ForIterONode node = this.insertChildNode(localNodes, beginBci, UNCACHED_FOR_ITER_O, ForIterONodeGen.class, NODE_FOR_ITER_O, useCachedNodes);
        return node.execute((Frame)virtualFrame, virtualFrame.getObject(stackTop), stackTop + 1);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean bytecodeForIterI(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, int bci, Node[] localNodes, int beginBci) {
        ForIterINode node = this.insertChildNode(localNodes, beginBci, UNCACHED_FOR_ITER_I, ForIterINodeGen.class, NODE_FOR_ITER_I, useCachedNodes);
        boolean cont = true;
        try {
            cont = node.execute((Frame)virtualFrame, virtualFrame.getObject(stackTop), stackTop + 1);
        }
        catch (QuickeningGeneralizeException e) {
            this.generalizeForIterI(bci, e);
        }
        return cont;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean bytecodeMatchExc(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        Object exception = virtualFrame.getObject(stackTop - 1);
        Object matchType = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop);
        ExceptMatchNode matchNode = this.insertChildNode(localNodes, beginBci, UNCACHED_EXCEPT_MATCH, ExceptMatchNodeGen.class, NODE_EXCEPT_MATCH, useCachedNodes);
        return matchNode.executeMatch((Frame)virtualFrame, exception, matchType);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnwrapExc(VirtualFrame virtualFrame, int stackTop) {
        Object exception = virtualFrame.getObject(stackTop);
        if (exception instanceof PException) {
            virtualFrame.setObject(stackTop, ((PException)((Object)exception)).getEscapedException());
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeSetupWith(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        SetupWithNode setupWithNode = this.insertChildNode(localNodes, beginBci, UNCACHED_SETUP_WITH_NODE, SetupWithNodeGen.class, NODE_SETUP_WITH, useCachedNodes);
        return setupWithNode.execute((Frame)virtualFrame, stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeExitWith(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        ExitWithNode exitWithNode = this.insertChildNode(localNodes, beginBci, UNCACHED_EXIT_WITH_NODE, ExitWithNodeGen.class, NODE_EXIT_WITH, useCachedNodes);
        return exitWithNode.execute((Frame)virtualFrame, stackTop, this.frameIsVisibleToPython());
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeSetupAWith(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        SetupAwithNode setupAwithNode = this.insertChildNode(localNodes, beginBci, UNCACHED_SETUP_AWITH_NODE, SetupAwithNodeGen.class, NODE_SETUP_AWITH, useCachedNodes);
        return setupAwithNode.execute((Frame)virtualFrame, stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeGetAExitCoro(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        GetAExitCoroNode getAExitCoroNode = this.insertChildNode(localNodes, beginBci, UNCACHED_GET_AEXIT_CORO_NODE, GetAExitCoroNodeGen.class, NODE_GET_AEXIT_CORO, useCachedNodes);
        return getAExitCoroNode.execute((Frame)virtualFrame, stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeExitAWith(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        ExitAWithNode exitAWithNode = this.insertChildNode(localNodes, beginBci, UNCACHED_EXIT_AWITH_NODE, ExitAWithNodeGen.class, NODE_EXIT_AWITH, useCachedNodes);
        return exitAWithNode.execute((Frame)virtualFrame, stackTop, this.frameIsVisibleToPython());
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean bytecodeSend(VirtualFrame virtualFrame, int stackTop, Node[] localNodes, int beginBci) {
        Object value = virtualFrame.getObject(stackTop);
        Object obj = virtualFrame.getObject(stackTop - 1);
        SendNode sendNode = this.insertChildNode(localNodes, beginBci, SendNodeGen.class, NODE_SEND);
        return sendNode.execute(virtualFrame, stackTop, obj, value);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean bytecodeThrow(VirtualFrame virtualFrame, int stackTop, Node[] localNodes, int beginBci) {
        Object exception = virtualFrame.getObject(stackTop);
        Object obj = virtualFrame.getObject(stackTop - 1);
        ThrowNode throwNode = this.insertChildNode(localNodes, beginBci, ThrowNodeGen.class, NODE_THROW);
        return throwNode.execute(virtualFrame, stackTop, obj, (AbstractTruffleException)((Object)exception));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeSetupAnnotations(VirtualFrame virtualFrame, boolean useCachedNodes, Node[] localNodes, int beginBci) {
        SetupAnnotationsNode setupAnnotationsNode = this.insertChildNode(localNodes, beginBci, UNCACHED_SETUP_ANNOTATIONS, SetupAnnotationsNodeGen.class, NODE_SETUP_ANNOTATIONS, useCachedNodes);
        setupAnnotationsNode.execute((Frame)virtualFrame);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeMakeFunction(VirtualFrame virtualFrame, Object globals, int stackTop, Node[] localNodes, int beginBci, int flags, Object localConsts) {
        BytecodeCodeUnit codeUnit = (BytecodeCodeUnit)localConsts;
        MakeFunctionNode makeFunctionNode = this.insertMakeFunctionNode(localNodes, beginBci, codeUnit);
        return makeFunctionNode.execute(virtualFrame, globals, stackTop, flags);
    }

    private int bytecodeMakeTypeParam(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci, int kind) {
        MakeTypeParamNode makeTypeParamNode = this.insertChildNode(localNodes, beginBci, UNCACHED_MAKE_TYPE_PARAM, MakeTypeParamNodeGen.class, NODE_MAKE_TYPE_PARAM, useCachedNodes);
        return makeTypeParamNode.execute(virtualFrame, stackTop, kind);
    }

    private int bytecodeMakeTypeAlias(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        MakeTypeAliasNode makeTypeAliasNode = this.insertChildNode(localNodes, beginBci, UNCACHED_MAKE_TYPE_ALIAS, MakeTypeAliasNodeGen.class, NODE_MAKE_TYPE_ALIAS, useCachedNodes);
        return makeTypeAliasNode.execute(virtualFrame, stackTop);
    }

    private int bytecodeMakeGeneric(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        MakeGenericNode makeGenericNode = this.insertChildNode(localNodes, beginBci, UNCACHED_MAKE_GENERIC, MakeGenericNodeGen.class, NODE_MAKE_GENERIC, useCachedNodes);
        return makeGenericNode.execute(virtualFrame, stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeResumeYield(VirtualFrame virtualFrame, boolean useCachedNodes, Object[] arguments, MutableLoopData mutableData, int stackTop, int bci, Node[] localNodes) {
        mutableData.localException = PArguments.getException((Frame)PArguments.getGeneratorFrame(arguments));
        if (mutableData.localException != null) {
            PArguments.setException(arguments, mutableData.localException);
        }
        GetSendValueNode node = this.insertChildNode(localNodes, bci, UNCACHED_GET_SEND_VALUE, GetSendValueNodeGen.class, NODE_GET_SEND_VALUE, useCachedNodes);
        virtualFrame.setObject(stackTop, node.execute(PArguments.getSpecialArgument(arguments)));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodePushExcInfo(VirtualFrame virtualFrame, Object[] arguments, MutableLoopData mutableData, int stackTop) {
        Object exception = virtualFrame.getObject(stackTop);
        if (!mutableData.fetchedException) {
            mutableData.outerException = PArguments.getException(arguments);
            mutableData.fetchedException = true;
        }
        virtualFrame.setObject(stackTop++, (Object)mutableData.localException);
        mutableData.localException = (AbstractTruffleException)((Object)exception);
        PArguments.setException(arguments, mutableData.localException);
        virtualFrame.setObject(stackTop, exception);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private GeneratorYieldResult bytecodeYieldValue(VirtualFrame virtualFrame, Frame localFrame, int initialStackTop, Object[] arguments, InstrumentationSupport instrumentation, MutableLoopData mutableData, int stackTop, int bci, byte tracingOrProfilingEnabled, int beginBci) {
        if (CompilerDirectives.hasNextTier() && mutableData.loopCount > 0) {
            LoopNode.reportLoopCount((Node)this, (int)mutableData.loopCount);
        }
        Object value = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        PArguments.setException((Frame)PArguments.getGeneratorFrame(arguments), mutableData.localException);
        AbstractTruffleException abstractTruffleException = mutableData.localException;
        if (abstractTruffleException instanceof PException) {
            PException pe = (PException)abstractTruffleException;
            pe.markEscaped();
        }
        if (localFrame != virtualFrame) {
            this.copyStackSlotsToGeneratorFrame((Frame)virtualFrame, localFrame, stackTop);
            this.clearFrameSlots(localFrame, stackTop + 1, initialStackTop);
        }
        this.traceOrProfileYield(virtualFrame, mutableData, value, tracingOrProfilingEnabled);
        if (instrumentation != null) {
            this.notifyReturn(virtualFrame, mutableData, instrumentation, beginBci, value);
        }
        return new GeneratorYieldResult(bci + 1, stackTop, value);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadBuildClass(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, Node[] localNodes, int beginBci) {
        ReadBuiltinNode read = this.insertChildNode(localNodes, beginBci, UNCACHED_READ_BUILTIN, ReadBuiltinNodeGen.class, NODE_READ_BUILTIN_BUILD_CLASS, useCachedNodes);
        virtualFrame.setObject(stackTop, read.execute(BuiltinNames.T___BUILD_CLASS__));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private Object bytecodeReturnValue(VirtualFrame virtualFrame, boolean isGeneratorOrCoroutine, InstrumentationSupport instrumentation, MutableLoopData mutableData, int stackTop, byte tracingOrProfilingEnabled, int beginBci) {
        if (CompilerDirectives.hasNextTier() && mutableData.loopCount > 0) {
            LoopNode.reportLoopCount((Node)this, (int)mutableData.loopCount);
        }
        Object value = virtualFrame.getObject(stackTop);
        this.traceOrProfileReturn(virtualFrame, mutableData, value, tracingOrProfilingEnabled);
        if (instrumentation != null) {
            this.notifyReturn(virtualFrame, mutableData, instrumentation, beginBci, value);
        }
        if (isGeneratorOrCoroutine) {
            throw new GeneratorReturnException(value);
        }
        return value;
    }

    @HostCompilerDirectives.InliningCutoff
    private void notifyStatementAfterException(VirtualFrame virtualFrame, InstrumentationSupport instrumentation, int bci) {
        instrumentation.notifyStatementEnter(virtualFrame, this.bciToLine(bci));
    }

    @HostCompilerDirectives.InliningCutoff
    private void notifyException(VirtualFrame virtualFrame, InstrumentationSupport instrumentation, int bci, Throwable e) {
        instrumentation.notifyException(virtualFrame, this.bciToLine(bci), e);
    }

    @HostCompilerDirectives.InliningCutoff
    private Object notifyExceptionalReturn(VirtualFrame virtualFrame, MutableLoopData mutableData, Throwable e) {
        if (this.instrumentationRoot instanceof InstrumentableNode.WrapperNode) {
            InstrumentableNode.WrapperNode wrapper = (InstrumentableNode.WrapperNode)this.instrumentationRoot;
            Object result = wrapper.getProbeNode().onReturnExceptionalOrUnwind(virtualFrame, e, mutableData.isReturnCalled());
            this.checkOnReturnExceptionalOrUnwindResult(result);
            return result;
        }
        return null;
    }

    private void checkOnReturnExceptionalOrUnwindResult(Object result) {
        if (result != null && this.co.isGeneratorOrCoroutine()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException(result == ProbeNode.UNWIND_ACTION_REENTER ? "Frame restarting is not possible in generators" : "Cannot replace return value of generators");
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void notifyReturn(VirtualFrame virtualFrame, MutableLoopData mutableData, InstrumentationSupport instrumentation, int bci, Object value) {
        try {
            instrumentation.notifyStatementExit(virtualFrame, this.bciToLine(bci));
        }
        catch (Throwable t) {
            mutableData.setExceptionNotified(true);
            throw t;
        }
        mutableData.setReturnCalled(true);
        if (this.instrumentationRoot instanceof InstrumentableNode.WrapperNode) {
            InstrumentableNode.WrapperNode wrapper = (InstrumentableNode.WrapperNode)this.instrumentationRoot;
            wrapper.getProbeNode().onReturnValue(virtualFrame, value);
        }
    }

    private void notifyStatement(VirtualFrame virtualFrame, InstrumentationSupport instrumentation, MutableLoopData mutableData, int bci, int beginBci) {
        if (instrumentation != null) {
            this.notifyStatementCutoff(virtualFrame, instrumentation, mutableData, beginBci, bci);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void notifyStatementCutoff(VirtualFrame virtualFrame, InstrumentationSupport instrumentation, MutableLoopData mutableData, int prevBci, int nextBci) {
        try {
            instrumentation.notifyStatement(virtualFrame, this.bciToLine(prevBci), this.bciToLine(nextBci));
        }
        catch (Throwable t) {
            mutableData.setExceptionNotified(true);
            throw t;
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private Object notifyEnter(VirtualFrame virtualFrame, InstrumentationSupport instrumentation, int initialBci) {
        block6: {
            if (this.instrumentationRoot instanceof InstrumentableNode.WrapperNode) {
                InstrumentableNode.WrapperNode wrapper = (InstrumentableNode.WrapperNode)this.instrumentationRoot;
                try {
                    wrapper.getProbeNode().onEnter(virtualFrame);
                }
                catch (Throwable t) {
                    Object result = wrapper.getProbeNode().onReturnExceptionalOrUnwind(virtualFrame, t, false);
                    this.checkOnReturnExceptionalOrUnwindResult(result);
                    if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                        this.copyArgs(virtualFrame.getArguments(), (Frame)virtualFrame);
                        return null;
                    }
                    if (result == null) break block6;
                    return result;
                }
            }
        }
        int line = this.bciToLine(initialBci);
        try {
            instrumentation.notifyStatementEnter(virtualFrame, line);
        }
        catch (Throwable t) {
            instrumentation.notifyException(virtualFrame, line, t);
            throw t;
        }
        return null;
    }

    private MakeFunctionNode insertMakeFunctionNode(Node[] localNodes, int beginBci, BytecodeCodeUnit codeUnit) {
        return this.insertChildNode(localNodes, beginBci, MakeFunctionNodeGen.class, () -> MakeFunctionNode.create((PythonLanguage)this.getLanguage(PythonLanguage.class), codeUnit, this.source));
    }

    public void materializeContainedFunctionsForInstrumentation(Set<Class<? extends Tag>> materializedTags) {
        this.usingCachedNodes = true;
        BytecodeCodeUnit.iterateBytecode(this.bytecode, (bci, op, oparg, followingArgs) -> {
            if (op == OpCodes.MAKE_FUNCTION) {
                BytecodeCodeUnit codeUnit = (BytecodeCodeUnit)this.consts[oparg];
                MakeFunctionNode makeFunctionNode = this.insertMakeFunctionNode(this.getChildNodes(), bci, codeUnit);
                RootNode rootNode = makeFunctionNode.getCallTarget().getRootNode();
                if (rootNode instanceof PBytecodeGeneratorFunctionRootNode) {
                    rootNode = ((PBytecodeGeneratorFunctionRootNode)rootNode).getBytecodeRootNode();
                }
                ((PBytecodeRootNode)rootNode).instrumentationRoot.materializeInstrumentableNodes(materializedTags);
            }
        });
    }

    public Node createInstrumentationMaterializationForwarder() {
        return new InstrumentationMaterializationForwarder(this.instrumentationRoot);
    }

    @HostCompilerDirectives.InliningCutoff
    private int bytecodePrintExpr(VirtualFrame virtualFrame, boolean useCachedNodes, int stackTop, int bci, Node[] localNodes, int bciSlot, int beginBci) {
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
        PrintExprNode printExprNode = this.insertChildNode(localNodes, beginBci, UNCACHED_PRINT_EXPR, PrintExprNodeGen.class, NODE_PRINT_EXPR, useCachedNodes);
        printExprNode.execute((Frame)virtualFrame, virtualFrame.getObject(stackTop));
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private byte checkTracingAndProfilingEnabled(Assumption noTraceOrProfile, MutableLoopData mutableData) {
        if (!noTraceOrProfile.isValid() && this.frameIsVisibleToPython()) {
            PythonContext.PythonThreadState ts = mutableData.getThreadState(this);
            Object profileFun = ts.getProfileFun();
            if (ts.getTraceFun() != null) {
                if (profileFun != null) {
                    return 3;
                }
                return 1;
            }
            if (profileFun != null) {
                return 2;
            }
        }
        return 0;
    }

    private static boolean isTracingOrProfilingEnabled(byte tracingOrProfilingEnabled) {
        return tracingOrProfilingEnabled != 0;
    }

    private static boolean isTracingEnabled(byte tracingOrProfilingEnabled) {
        return (tracingOrProfilingEnabled & 1) != 0;
    }

    private static boolean isProfilingEnabled(byte tracingOrProfilingEnabled) {
        return (tracingOrProfilingEnabled & 2) != 0;
    }

    private void traceOrProfileYield(VirtualFrame virtualFrame, MutableLoopData mutableData, Object value, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isTracingOrProfilingEnabled(tracingOrProfilingEnabled)) {
            this.traceOrProfileYieldCutoff(virtualFrame, mutableData, value, tracingOrProfilingEnabled);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void traceOrProfileYieldCutoff(VirtualFrame virtualFrame, MutableLoopData mutableData, Object value, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isTracingEnabled(tracingOrProfilingEnabled)) {
            this.invokeTraceFunction(virtualFrame, value, mutableData.getThreadState(this), mutableData, PythonContext.TraceEvent.RETURN, mutableData.getReturnLine(), true);
        }
        if (PBytecodeRootNode.isProfilingEnabled(tracingOrProfilingEnabled)) {
            this.invokeProfileFunction(virtualFrame, value, mutableData.getThreadState(this), mutableData, PythonContext.ProfileEvent.RETURN);
        }
    }

    private void traceOrProfileReturn(VirtualFrame virtualFrame, MutableLoopData mutableData, Object value, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isTracingOrProfilingEnabled(tracingOrProfilingEnabled)) {
            this.traceOrProfileReturnCutoff(virtualFrame, mutableData, value, tracingOrProfilingEnabled);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void traceOrProfileReturnCutoff(VirtualFrame virtualFrame, MutableLoopData mutableData, Object value, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isTracingEnabled(tracingOrProfilingEnabled)) {
            this.invokeTraceFunction(virtualFrame, value, mutableData.getThreadState(this), mutableData, PythonContext.TraceEvent.RETURN, mutableData.getReturnLine(), true);
        }
        if (PBytecodeRootNode.isProfilingEnabled(tracingOrProfilingEnabled)) {
            this.invokeProfileFunction(virtualFrame, value, mutableData.getThreadState(this), mutableData, PythonContext.ProfileEvent.RETURN);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void traceException(VirtualFrame virtualFrame, MutableLoopData mutableData, int bci, AbstractTruffleException exception) {
        mutableData.setPyFrame(this.ensurePyFrame(virtualFrame));
        if (mutableData.getPyFrame().getLocalTraceFun() != null) {
            if (exception instanceof PException) {
                ((PException)exception).setCatchingFrameReference((Frame)virtualFrame, this, bci);
            }
            Object exceptionObject = GetEscapedExceptionNode.executeUncached(exception);
            Object peType = GetClassNode.executeUncached(exceptionObject);
            Object traceback = ExceptionNodes.GetTracebackNode.executeUncached((Object)exception);
            this.invokeTraceFunction(virtualFrame, PFactory.createTuple(this.getLanguage(), new Object[]{peType, exceptionObject, traceback}), mutableData.getThreadState(this), mutableData, PythonContext.TraceEvent.EXCEPTION, this.bciToLine(bci), true);
        }
    }

    private void traceOrProfileCall(VirtualFrame virtualFrame, int initialBci, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isTracingOrProfilingEnabled(tracingOrProfilingEnabled)) {
            this.traceOrProfileCallCutoff(virtualFrame, initialBci, mutableData, tracingOrProfilingEnabled);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void traceOrProfileCallCutoff(VirtualFrame virtualFrame, int initialBci, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isTracingEnabled(tracingOrProfilingEnabled)) {
            this.invokeTraceFunction(virtualFrame, null, mutableData.getThreadState(this), mutableData, PythonContext.TraceEvent.CALL, initialBci == 0 ? this.getFirstLineno() : mutableData.setPastLine(this.bciToLine(initialBci)), false);
        }
        if (PBytecodeRootNode.isProfilingEnabled(tracingOrProfilingEnabled)) {
            this.invokeProfileFunction(virtualFrame, null, mutableData.getThreadState(this), mutableData, PythonContext.ProfileEvent.CALL);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private int traceLine(VirtualFrame virtualFrame, MutableLoopData mutableData, byte[] localBC, int bci) {
        boolean shouldTrace;
        int thisLine = this.bciToLine(bci);
        int ret = 1;
        boolean onANewLine = thisLine != mutableData.getPastLine();
        mutableData.setPastLine(thisLine);
        OpCodes c = OpCodes.fromOpCode(localBC[mutableData.getPastBci()]);
        boolean bl = shouldTrace = mutableData.getPastBci() > bci;
        if (!shouldTrace) {
            boolean bl2 = shouldTrace = onANewLine && (mutableData.getPastBci() + c.length() >= bci || this.bciToLine(bci - 1) != thisLine);
        }
        if (shouldTrace) {
            mutableData.setReturnLine(mutableData.getPastLine());
            mutableData.setPyFrame(this.ensurePyFrame(virtualFrame));
            PFrame pyFrame = mutableData.getPyFrame();
            if (pyFrame.didJump()) {
                mutableData.setPastBci(bci);
                return ret;
            }
            if (pyFrame.getTraceLine()) {
                pyFrame.setJumpDestLine(-2);
                this.invokeTraceFunction(virtualFrame, null, mutableData.getThreadState(this), mutableData, PythonContext.TraceEvent.LINE, mutableData.getPastLine(), true);
                if (pyFrame.didJump()) {
                    int newBci = this.lineToBci(pyFrame.getJumpDestLine());
                    mutableData.setPastBci(bci);
                    if (newBci == -1) {
                        throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.LINE_D_COMES_AFTER_THE_CURRENT_CODE_BLOCK, pyFrame.getLine());
                    }
                    if (newBci == -2) {
                        throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.LINE_D_COMES_BEFORE_THE_CURRENT_CODE_BLOCK, pyFrame.getJumpDestLine());
                    }
                    ret = this.computeJumpStackDifference(bci, newBci);
                    mutableData.setJumpBci(newBci);
                }
            }
            pyFrame.setJumpDestLine(-3);
        }
        mutableData.setPastBci(bci);
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    private int computeJumpStackDifference(int bci, int newBci) {
        List<ArrayList<BytecodeCodeUnit.StackItem>> stacks = this.co.computeStackElems();
        String error = this.co.checkJump((Node)this, stacks, bci, newBci);
        if (error != null) {
            throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.ValueError, ErrorMessages.CANT_JUMP_INTO_S, error);
        }
        int ret = stacks.get(newBci).size() - stacks.get(bci).size();
        return ret;
    }

    private int bytecodeBinarySubscrAdaptive(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int bciSlot) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (virtualFrame.isInt(stackTop) && virtualFrame.getObject(stackTop - 1) instanceof PSequence) {
            this.bytecode[bci] = -92;
            stackTop = this.bytecodeBinarySubscrSeqIO(virtualFrame, stackTop, bci, localNodes);
            if (this.bytecode[bci] == -92 && this.outputCanQuicken[bci] != 0) {
                Object result = virtualFrame.getObject(stackTop);
                if (result instanceof Integer && (this.outputCanQuicken[bci] & 2) != 0) {
                    this.bytecode[bci] = -91;
                    virtualFrame.setInt(stackTop, ((Integer)result).intValue());
                } else if (result instanceof Double && (this.outputCanQuicken[bci] & 8) != 0) {
                    this.bytecode[bci] = -90;
                    virtualFrame.setDouble(stackTop, ((Double)result).doubleValue());
                }
            }
            return stackTop;
        }
        if (!virtualFrame.isObject(stackTop)) {
            this.generalizeInputs(bci);
            this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        }
        this.bytecode[bci] = -93;
        return this.bytecodeBinarySubscrOO(virtualFrame, stackTop, bci, localNodes, bciSlot);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeBinarySubscrOO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int bciSlot) {
        Object index;
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
        PyObjectGetItem getItemNode = this.insertChildNode(localNodes, bci, PyObjectGetItemNodeGen.class, NODE_GET_ITEM);
        try {
            index = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            return this.generalizeBinarySubscr(virtualFrame, stackTop, bci, localNodes);
        }
        virtualFrame.clear(stackTop--);
        virtualFrame.setObject(stackTop, getItemNode.executeCached((Frame)virtualFrame, virtualFrame.getObject(stackTop), index));
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeBinarySubscrSeqIO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        Object value;
        if (!virtualFrame.isInt(stackTop)) {
            return this.generalizeBinarySubscr(virtualFrame, stackTop, bci, localNodes);
        }
        int index = virtualFrame.getInt(stackTop);
        Object sequence = virtualFrame.getObject(stackTop - 1);
        BinarySubscrSeq.ONode node = this.insertChildNode(localNodes, bci, BinarySubscrSeqFactory.ONodeGen.class, NODE_BINARY_SUBSCR_SEQ_O);
        try {
            value = node.execute(sequence, index);
        }
        catch (QuickeningGeneralizeException e) {
            return this.generalizeBinarySubscrSeq(virtualFrame, stackTop, bci, localNodes, e);
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        virtualFrame.setObject(stackTop, value);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeBinarySubscrSeqII(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        int value;
        if (!virtualFrame.isInt(stackTop)) {
            return this.generalizeBinarySubscr(virtualFrame, stackTop, bci, localNodes);
        }
        int index = virtualFrame.getInt(stackTop);
        Object sequence = virtualFrame.getObject(stackTop - 1);
        BinarySubscrSeq.INode node = this.insertChildNode(localNodes, bci, BinarySubscrSeqFactory.INodeGen.class, NODE_BINARY_SUBSCR_SEQ_I);
        try {
            value = node.execute(sequence, index);
        }
        catch (QuickeningGeneralizeException e) {
            return this.generalizeBinarySubscrSeq(virtualFrame, stackTop, bci, localNodes, e);
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        virtualFrame.setInt(stackTop, value);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeBinarySubscrSeqID(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        double value;
        if (!virtualFrame.isInt(stackTop)) {
            return this.generalizeBinarySubscr(virtualFrame, stackTop, bci, localNodes);
        }
        int index = virtualFrame.getInt(stackTop);
        Object sequence = virtualFrame.getObject(stackTop - 1);
        BinarySubscrSeq.DNode node = this.insertChildNode(localNodes, bci, BinarySubscrSeqFactory.DNodeGen.class, NODE_BINARY_SUBSCR_SEQ_D);
        try {
            value = node.execute(sequence, index);
        }
        catch (QuickeningGeneralizeException e) {
            return this.generalizeBinarySubscrSeq(virtualFrame, stackTop, bci, localNodes, e);
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        virtualFrame.setDouble(stackTop, value);
        return stackTop;
    }

    private int generalizeBinarySubscrSeq(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, QuickeningGeneralizeException e) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (e == BinarySubscrSeq.GENERALIZE_RESULT) {
            return this.generalizeBinarySubscrSeqResult(virtualFrame, stackTop, bci, localNodes);
        }
        return this.generalizeBinarySubscr(virtualFrame, stackTop, bci, localNodes);
    }

    private int generalizeBinarySubscrSeqResult(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.bytecode[bci] = -92;
        return this.bytecodeBinarySubscrOO(virtualFrame, stackTop, bci, localNodes, this.bcioffset);
    }

    private int generalizeBinarySubscr(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeInputs(bci);
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        this.bytecode[bci] = -93;
        return this.bytecodeBinarySubscrOO(virtualFrame, stackTop, bci, localNodes, this.bcioffset);
    }

    private PFrame ensurePyFrame(VirtualFrame virtualFrame) {
        if (this.traceMaterializeFrameNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.traceMaterializeFrameNode = (MaterializeFrameNode)this.insert(MaterializeFrameNode.create());
        }
        return this.traceMaterializeFrameNode.execute((Frame)virtualFrame, (Node)this, true, true);
    }

    @HostCompilerDirectives.InliningCutoff
    private void invokeTraceFunction(VirtualFrame virtualFrame, Object arg, PythonContext.PythonThreadState threadState, MutableLoopData mutableData, PythonContext.TraceEvent event, int line, boolean useLocalFn) {
        Object traceFn;
        if (threadState.isTracing()) {
            return;
        }
        assert (event != PythonContext.TraceEvent.DISABLED);
        threadState.tracingStart(event);
        PFrame pyFrame = mutableData.setPyFrame(this.ensurePyFrame(virtualFrame));
        Object object = traceFn = useLocalFn ? pyFrame.getLocalTraceFun() : threadState.getTraceFun();
        if (traceFn == null) {
            threadState.tracingStop();
            return;
        }
        Object nonNullArg = arg == null ? PNone.NONE : arg;
        try {
            if (line != -1) {
                pyFrame.setLineLock(line);
            }
            GetFrameLocalsNode.executeUncached(pyFrame);
            Object result = CallTernaryMethodNode.getUncached().execute(null, traceFn, pyFrame, event.pythonName, nonNullArg);
            this.syncLocalsBackToFrame(virtualFrame, pyFrame);
            if (useLocalFn) {
                Object realResult = result == PNone.NONE ? traceFn : result;
                pyFrame.setLocalTraceFun(realResult);
            } else if (result != PNone.NONE) {
                pyFrame.setLocalTraceFun(result);
            } else {
                pyFrame.setLocalTraceFun(null);
            }
        }
        catch (Throwable e) {
            threadState.setTraceFun(null, this.getLanguage());
            throw e;
        }
        finally {
            if (line != -1) {
                pyFrame.lineUnlock();
            }
            threadState.tracingStop();
        }
    }

    private void syncLocalsBackToFrame(VirtualFrame virtualFrame, PFrame pyFrame) {
        VirtualFrame localFrame = virtualFrame;
        if (this.co.isGeneratorOrCoroutine()) {
            localFrame = PArguments.getGeneratorFrame((Frame)virtualFrame);
        }
        GetFrameLocalsNode.syncLocalsBackToFrame(this.co, this, pyFrame, (Frame)localFrame);
    }

    private void profileCEvent(VirtualFrame virtualFrame, Object callable, PythonContext.ProfileEvent event, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        if (PBytecodeRootNode.isProfilingEnabled(tracingOrProfilingEnabled)) {
            this.profileCEvent(virtualFrame, callable, event, mutableData);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void profileCEvent(VirtualFrame virtualFrame, Object callable, PythonContext.ProfileEvent event, MutableLoopData mutableData) {
        PythonContext.PythonThreadState threadState = mutableData.getThreadState(this);
        if (PBytecodeRootNode.isBuiltin(callable)) {
            this.invokeProfileFunction(virtualFrame, callable, threadState, mutableData, event);
        } else if (callable instanceof BoundDescriptor && PBytecodeRootNode.isBuiltin(((BoundDescriptor)callable).descriptor)) {
            this.invokeProfileFunction(virtualFrame, ((BoundDescriptor)callable).descriptor, threadState, mutableData, event);
        }
    }

    private static boolean isBuiltin(Object fun) {
        return fun instanceof PBuiltinFunction || fun instanceof PBuiltinMethod;
    }

    @HostCompilerDirectives.InliningCutoff
    private void invokeProfileFunction(VirtualFrame virtualFrame, Object arg, PythonContext.PythonThreadState threadState, MutableLoopData mutableData, PythonContext.ProfileEvent event) {
        if (threadState.isProfiling()) {
            return;
        }
        threadState.profilingStart();
        PFrame pyFrame = mutableData.setPyFrame(this.ensurePyFrame(virtualFrame));
        Object profileFun = threadState.getProfileFun();
        if (profileFun == null) {
            threadState.profilingStop();
            return;
        }
        try {
            GetFrameLocalsNode.executeUncached(pyFrame);
            Object result = CallTernaryMethodNode.getUncached().execute(null, profileFun, pyFrame, event.name, arg == null ? PNone.NONE : arg);
            this.syncLocalsBackToFrame(virtualFrame, pyFrame);
            Object realResult = result == PNone.NONE ? null : result;
            pyFrame.setLocalTraceFun(realResult);
        }
        catch (Throwable e) {
            threadState.setProfileFun(null, this.getLanguage());
            throw e;
        }
        finally {
            threadState.profilingStop();
        }
    }

    @ExplodeLoop
    private void unboxVariables(Frame localFrame) {
        for (int i = 0; i < this.variableTypes.length; ++i) {
            Object value;
            if (this.variableTypes[i] == 0 || this.variableTypes[i] == 1 || !localFrame.isObject(i) || (value = localFrame.getObject(i)) == null) continue;
            if (this.variableTypes[i] == 2) {
                localFrame.setInt(i, ((Integer)value).intValue());
                continue;
            }
            if (this.variableTypes[i] != 16) continue;
            localFrame.setBoolean(i, ((Boolean)value).booleanValue());
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private void prepareForReraise(VirtualFrame virtualFrame, Frame localFrame, int initialStackTop, boolean isGeneratorOrCoroutine, MutableLoopData mutableData, int bciSlot, int beginBci, byte tracingOrProfilingEnabled) {
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, beginBci);
        if (isGeneratorOrCoroutine && localFrame != virtualFrame) {
            this.clearFrameSlots(localFrame, this.stackoffset, initialStackTop);
        }
        if (CompilerDirectives.hasNextTier() && mutableData.loopCount > 0) {
            LoopNode.reportLoopCount((Node)this, (int)mutableData.loopCount);
        }
        this.traceOrProfileReturn(virtualFrame, mutableData, PNone.NONE, tracingOrProfilingEnabled);
    }

    @HostCompilerDirectives.InliningCutoff
    private void chainPythonExceptions(VirtualFrame virtualFrame, MutableLoopData mutableData, AbstractTruffleException exception) {
        if (exception instanceof PException) {
            PException pe = (PException)exception;
            AbstractTruffleException abstractTruffleException = mutableData.localException;
            if (abstractTruffleException instanceof PException) {
                PException pe2 = (PException)abstractTruffleException;
                this.chainPythonExceptions(pe, pe2);
            } else {
                AbstractTruffleException exceptionState;
                if (this.getCaughtExceptionNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getCaughtExceptionNode = (ExceptionStateNodes.GetCaughtExceptionNode)this.insert(ExceptionStateNodes.GetCaughtExceptionNode.create());
                }
                if ((exceptionState = this.getCaughtExceptionNode.execute(virtualFrame)) instanceof PException) {
                    PException pe2 = (PException)exceptionState;
                    this.chainPythonExceptions(pe, pe2);
                }
            }
        }
    }

    private void chainPythonExceptions(PException current, PException context) {
        if (this.chainExceptionsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.chainExceptionsNode = (ChainExceptionsNode)this.insert(ChainExceptionsNode.create());
        }
        this.chainExceptionsNode.execute(current, context);
    }

    private PException raiseUnknownBytecodeError(byte bc) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        TruffleString format = PythonUtils.toTruffleStringUncached("not implemented bytecode %s");
        throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.SystemError, format, new Object[]{OpCodes.fromOpCode(bc)});
    }

    private static void clearInCompiledCode(VirtualFrame virtualFrame, int stackTop) {
        if (CompilerDirectives.inCompiledCode()) {
            virtualFrame.clear(stackTop);
        }
    }

    private void generalizeForIterI(int bci, QuickeningGeneralizeException e) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (e.type != 1) {
            throw CompilerDirectives.shouldNotReachHere((String)"invalid type");
        }
        this.bytecode[bci] = -95;
    }

    private void bytecodeForIterAdaptive(int bci) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.bytecode[bci] = (this.outputCanQuicken[bci] & 2) != 0 ? -94 : -95;
    }

    private void generalizePopAndJumpIfTrueB(int bci) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeInputs(bci);
        this.bytecode[bci] = -83;
    }

    private void generalizePopAndJumpIfFalseB(int bci) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeInputs(bci);
        this.bytecode[bci] = -85;
    }

    private static void setCurrentBci(VirtualFrame virtualFrame, int bciSlot, int bci) {
        virtualFrame.setInt(bciSlot, bci);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private boolean bytecodePopCondition(VirtualFrame virtualFrame, int stackTop, Node[] localNodes, int bci, boolean useCachedNodes) {
        PyObjectIsTrueNode isTrue = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_IS_TRUE, PyObjectIsTrueNodeGen.class, NODE_OBJECT_IS_TRUE, useCachedNodes);
        Object cond = virtualFrame.isObject(stackTop) ? virtualFrame.getObject(stackTop) : this.generalizePopCondition(virtualFrame, stackTop, bci);
        virtualFrame.clear(stackTop);
        return isTrue.execute((Frame)virtualFrame, cond);
    }

    private Object generalizePopCondition(VirtualFrame virtualFrame, int stackTop, int bci) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeInputs(bci);
        return virtualFrame.getValue(stackTop);
    }

    private void bytecodeBinaryOpAdaptive(VirtualFrame virtualFrame, int stackTop, byte[] localBC, int bci, Node[] localNodes, int op, boolean useCachedNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (virtualFrame.isObject(stackTop) && virtualFrame.isObject(stackTop - 1)) {
            localBC[bci] = -102;
            this.bytecodeBinaryOpOOO(virtualFrame, stackTop, bci, localNodes, op, this.bcioffset);
            return;
        }
        if (virtualFrame.isInt(stackTop) && virtualFrame.isInt(stackTop - 1)) {
            switch (op) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    if ((this.outputCanQuicken[bci] & 2) != 0) {
                        localBC[bci] = -100;
                        this.bytecodeBinaryOpIII(virtualFrame, stackTop, bci, localNodes, op, useCachedNodes);
                    } else {
                        localBC[bci] = -101;
                        this.bytecodeBinaryOpIIO(virtualFrame, stackTop, bci, localNodes, op);
                    }
                    return;
                }
                case 8: 
                case 9: {
                    localBC[bci] = -101;
                    this.bytecodeBinaryOpIIO(virtualFrame, stackTop, bci, localNodes, op);
                    return;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 31: {
                    if ((this.outputCanQuicken[bci] & 0x10) != 0) {
                        localBC[bci] = -99;
                        this.bytecodeBinaryOpIIB(virtualFrame, stackTop, bci, localNodes, op);
                    } else {
                        localBC[bci] = -101;
                        this.bytecodeBinaryOpIIO(virtualFrame, stackTop, bci, localNodes, op);
                    }
                    return;
                }
            }
        } else if (virtualFrame.isDouble(stackTop) && virtualFrame.isDouble(stackTop - 1)) {
            switch (op) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: 
                case 9: 
                case 28: 
                case 29: {
                    if ((this.outputCanQuicken[bci] & 2) != 0) {
                        localBC[bci] = -97;
                        this.bytecodeBinaryOpDDD(virtualFrame, stackTop, bci, localNodes, op, useCachedNodes);
                    } else {
                        localBC[bci] = -98;
                        this.bytecodeBinaryOpDDO(virtualFrame, stackTop, bci, localNodes, op, useCachedNodes);
                    }
                    return;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    if ((this.outputCanQuicken[bci] & 0x10) != 0) {
                        localBC[bci] = -96;
                        this.bytecodeBinaryOpDDB(virtualFrame, stackTop, bci, localNodes, op);
                    } else {
                        localBC[bci] = -98;
                        this.bytecodeBinaryOpDDO(virtualFrame, stackTop, bci, localNodes, op, useCachedNodes);
                    }
                    return;
                }
            }
        }
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop - 1);
        this.generalizeInputs(bci);
        localBC[bci] = -102;
        this.bytecodeBinaryOpOOO(virtualFrame, stackTop, bci, localNodes, op, this.bcioffset);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpIIB(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isInt(stackTop) || !virtualFrame.isInt(stackTop - 1)) {
            this.generalizeBinaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        int right = virtualFrame.getInt(stackTop);
        int left = virtualFrame.getInt(stackTop - 1);
        boolean result = switch (op) {
            case 12, 31 -> left == right;
            case 13 -> left != right;
            case 14 -> left < right;
            case 15 -> left <= right;
            case 16 -> left > right;
            case 17 -> left >= right;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for BINARY_OP_II_B");
        };
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        virtualFrame.setBoolean(stackTop - 1, result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpIIO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isInt(stackTop) || !virtualFrame.isInt(stackTop - 1)) {
            this.generalizeBinaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        int right = virtualFrame.getInt(stackTop);
        int left = virtualFrame.getInt(stackTop - 1);
        Object result = switch (op) {
            case 0, 1 -> {
                IntBuiltins.AddNode addNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.AddNodeFactory.AddNodeGen.class, NODE_INT_ADD);
                yield addNode.execute(left, right);
            }
            case 2, 3 -> {
                IntBuiltins.SubNode subNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.SubNodeFactory.SubNodeGen.class, NODE_INT_SUB);
                yield subNode.execute(left, right);
            }
            case 4, 5 -> {
                IntBuiltins.MulNode mulNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.MulNodeFactory.MulNodeGen.class, NODE_INT_MUL);
                yield mulNode.execute(left, right);
            }
            case 6, 7 -> {
                IntBuiltins.FloorDivNode floorDivNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.FloorDivNodeFactory.FloorDivNodeGen.class, NODE_INT_FLOORDIV);
                yield floorDivNode.execute(left, right);
            }
            case 8, 9 -> {
                IntBuiltins.TrueDivNode trueDivNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.TrueDivNodeFactory.TrueDivNodeGen.class, NODE_INT_TRUEDIV);
                yield trueDivNode.execute(left, right);
            }
            case 10, 11 -> {
                IntBuiltins.ModNode modNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.ModNodeFactory.ModNodeGen.class, NODE_INT_MOD);
                yield modNode.execute(left, right);
            }
            case 18, 19 -> {
                IntBuiltins.LShiftNode lShiftNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.LShiftNodeFactory.LShiftNodeGen.class, NODE_INT_LSHIFT);
                yield lShiftNode.execute(left, right);
            }
            case 20, 21 -> {
                IntBuiltins.RShiftNode rShiftNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.RShiftNodeFactory.RShiftNodeGen.class, NODE_INT_RSHIFT);
                yield rShiftNode.execute(left, right);
            }
            case 28, 29 -> {
                IntBuiltins.PowNode powNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.PowNodeFactory.PowNodeGen.class, NODE_INT_POW);
                yield powNode.execute(left, right);
            }
            case 22, 23 -> left & right;
            case 24, 25 -> left | right;
            case 26, 27 -> left ^ right;
            case 12, 31 -> left == right;
            case 13 -> left != right;
            case 14 -> left < right;
            case 15 -> left <= right;
            case 16 -> left > right;
            case 17 -> left >= right;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for BINARY_OP_II_O");
        };
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        virtualFrame.setObject(stackTop - 1, result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpIII(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op, boolean useCachedNodes) {
        int result;
        if (!virtualFrame.isInt(stackTop) || !virtualFrame.isInt(stackTop - 1)) {
            this.generalizeBinaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        int right = virtualFrame.getInt(stackTop);
        int left = virtualFrame.getInt(stackTop - 1);
        try {
            switch (op) {
                case 0: 
                case 1: {
                    try {
                        result = Math.addExact(left, right);
                        break;
                    }
                    catch (ArithmeticException e) {
                        this.generalizeBinaryOpIIIOverflow(virtualFrame, stackTop, bci, localNodes, op);
                        return;
                    }
                }
                case 2: 
                case 3: {
                    try {
                        result = Math.subtractExact(left, right);
                        break;
                    }
                    catch (ArithmeticException e) {
                        this.generalizeBinaryOpIIIOverflow(virtualFrame, stackTop, bci, localNodes, op);
                        return;
                    }
                }
                case 4: 
                case 5: {
                    try {
                        result = Math.multiplyExact(left, right);
                        break;
                    }
                    catch (ArithmeticException e) {
                        this.generalizeBinaryOpIIIOverflow(virtualFrame, stackTop, bci, localNodes, op);
                        return;
                    }
                }
                case 6: 
                case 7: {
                    if (left == Integer.MIN_VALUE && right == -1) {
                        this.generalizeBinaryOpIIIOverflow(virtualFrame, stackTop, bci, localNodes, op);
                        return;
                    }
                    if (right == 0) {
                        this.raiseDivOrModByZero(bci, localNodes, useCachedNodes);
                    }
                    result = Math.floorDiv(left, right);
                    break;
                }
                case 10: 
                case 11: {
                    IntBuiltins.ModNode modNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.ModNodeFactory.ModNodeGen.class, NODE_INT_MOD);
                    result = modNode.executeInt(left, right);
                    break;
                }
                case 18: 
                case 19: {
                    IntBuiltins.LShiftNode lShiftNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.LShiftNodeFactory.LShiftNodeGen.class, NODE_INT_LSHIFT);
                    result = lShiftNode.executeInt(left, right);
                    break;
                }
                case 20: 
                case 21: {
                    IntBuiltins.RShiftNode rShiftNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.RShiftNodeFactory.RShiftNodeGen.class, NODE_INT_RSHIFT);
                    result = rShiftNode.executeInt(left, right);
                    break;
                }
                case 22: 
                case 23: {
                    result = left & right;
                    break;
                }
                case 24: 
                case 25: {
                    result = left | right;
                    break;
                }
                case 26: 
                case 27: {
                    result = left ^ right;
                    break;
                }
                case 28: 
                case 29: {
                    IntBuiltins.PowNode powNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.PowNodeFactory.PowNodeGen.class, NODE_INT_POW);
                    result = powNode.executeInt(left, right);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for BINARY_OP_II_I");
                }
            }
        }
        catch (UnexpectedResultException e) {
            this.generalizeBinaryOpIIIOverflow(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        virtualFrame.setInt(stackTop - 1, result);
    }

    @HostCompilerDirectives.InliningCutoff
    private void raiseDivOrModByZero(int bci, Node[] localNodes, boolean useCachedNodes) {
        PRaiseCachedNode raiseNode = this.insertChildNode(localNodes, bci, UNCACHED_RAISE, PRaiseCachedNodeGen.class, NODE_RAISE, useCachedNodes);
        throw raiseNode.raise(PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.S_DIVISION_OR_MODULO_BY_ZERO, "integer");
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpDDD(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op, boolean useCachedNodes) {
        double result;
        if (!virtualFrame.isDouble(stackTop) || !virtualFrame.isDouble(stackTop - 1)) {
            this.generalizeBinaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        double right = virtualFrame.getDouble(stackTop);
        double left = virtualFrame.getDouble(stackTop - 1);
        try {
            switch (op) {
                case 0: 
                case 1: {
                    result = left + right;
                    break;
                }
                case 2: 
                case 3: {
                    result = left - right;
                    break;
                }
                case 4: 
                case 5: {
                    result = left * right;
                    break;
                }
                case 8: 
                case 9: {
                    if (right == 0.0) {
                        this.raiseDivByZero(bci, localNodes, useCachedNodes);
                    }
                    result = left / right;
                    break;
                }
                case 28: 
                case 29: {
                    FloatBuiltins.PowNode powNode = this.insertChildNode(localNodes, bci, FloatBuiltinsFactory.PowNodeFactory.PowNodeGen.class, NODE_FLOAT_POW);
                    result = powNode.executeDouble(left, right);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for BINARY_OP_DD_D");
                }
            }
        }
        catch (UnexpectedResultException e) {
            this.generalizeBinaryOpDDDOverflow(virtualFrame, stackTop, bci, localNodes, op, useCachedNodes);
            return;
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        virtualFrame.setDouble(stackTop - 1, result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpDDB(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isDouble(stackTop) || !virtualFrame.isDouble(stackTop - 1)) {
            this.generalizeBinaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        double right = virtualFrame.getDouble(stackTop);
        double left = virtualFrame.getDouble(stackTop - 1);
        boolean result = switch (op) {
            case 12 -> left == right;
            case 13 -> left != right;
            case 14 -> left < right;
            case 15 -> left <= right;
            case 16 -> left > right;
            case 17 -> left >= right;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for BINARY_OP_DD_B");
        };
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        virtualFrame.setBoolean(stackTop - 1, result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpDDO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op, boolean useCachedNodes) {
        if (!virtualFrame.isInt(stackTop) || !virtualFrame.isInt(stackTop - 1)) {
            this.generalizeBinaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        int right = virtualFrame.getInt(stackTop);
        int left = virtualFrame.getInt(stackTop - 1);
        Object result = switch (op) {
            case 0, 1 -> left + right;
            case 2, 3 -> left - right;
            case 4, 5 -> left * right;
            case 8, 9 -> {
                if ((double)right == 0.0) {
                    this.raiseDivByZero(bci, localNodes, useCachedNodes);
                }
                yield left / right;
            }
            case 28, 29 -> {
                FloatBuiltins.PowNode powNode = this.insertChildNode(localNodes, bci, FloatBuiltinsFactory.PowNodeFactory.PowNodeGen.class, NODE_FLOAT_POW);
                yield powNode.execute(left, right);
            }
            case 12, 31 -> left == right;
            case 13 -> left != right;
            case 14 -> left < right;
            case 15 -> left <= right;
            case 16 -> left > right;
            case 17 -> left >= right;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for BINARY_OP_DD_O");
        };
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        virtualFrame.setObject(stackTop - 1, result);
    }

    @HostCompilerDirectives.InliningCutoff
    private void raiseDivByZero(int bci, Node[] localNodes, boolean useCachedNodes) {
        PRaiseCachedNode raiseNode = this.insertChildNode(localNodes, bci, UNCACHED_RAISE, PRaiseCachedNodeGen.class, NODE_RAISE, useCachedNodes);
        throw raiseNode.raise(PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO, new Object[0]);
    }

    private void generalizeBinaryOp(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop - 1);
        this.generalizeInputs(bci);
        this.bytecode[bci] = -102;
        this.bytecodeBinaryOpOOO(virtualFrame, stackTop, bci, localNodes, op, this.bcioffset);
    }

    private void generalizeBinaryOpIIIOverflow(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.bytecode[bci] = -101;
        this.bytecodeBinaryOpIIO(virtualFrame, stackTop, bci, localNodes, op);
    }

    private void generalizeBinaryOpDDDOverflow(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op, boolean useCachedNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.bytecode[bci] = -98;
        this.bytecodeBinaryOpDDO(virtualFrame, stackTop, bci, localNodes, op, useCachedNodes);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeBinaryOpOOO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op, int bciSlot) {
        Object left;
        Object right;
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
        BinaryOp opNode = (BinaryOp)this.insertChildNodeInt(localNodes, bci, BinaryOp.class, BINARY_OP_FACTORY, op);
        try {
            right = virtualFrame.getObject(stackTop);
            left = virtualFrame.getObject(stackTop - 1);
        }
        catch (FrameSlotTypeException e) {
            right = this.generalizePopCondition(virtualFrame, stackTop, bci);
            left = virtualFrame.getValue(stackTop - 1);
        }
        virtualFrame.clear(stackTop);
        Object result = opNode.execute(virtualFrame, left, right);
        virtualFrame.setObject(stackTop - 1, result);
    }

    private void bytecodeUnaryOpAdaptive(VirtualFrame virtualFrame, int stackTop, int bci, byte[] localBC, Node[] localNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        int op = Byte.toUnsignedInt(localBC[bci + 1]);
        if (virtualFrame.isObject(stackTop)) {
            localBC[bci] = -109;
            this.bytecodeUnaryOpOO(virtualFrame, stackTop, bci, localNodes, op, this.bcioffset);
            return;
        }
        if (virtualFrame.isInt(stackTop)) {
            if ((this.outputCanQuicken[bci] & 2) != 0) {
                if (op == 0) {
                    localBC[bci] = -108;
                    this.bytecodeUnaryOpIO(virtualFrame, stackTop, bci, localNodes, op);
                } else {
                    localBC[bci] = -107;
                    this.bytecodeUnaryOpII(virtualFrame, stackTop, bci, localNodes, op);
                }
                return;
            }
            localBC[bci] = -108;
            this.bytecodeUnaryOpIO(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        if (virtualFrame.isDouble(stackTop)) {
            if ((this.outputCanQuicken[bci] & 2) != 0) {
                if (op == 0 || op == 3) {
                    localBC[bci] = -106;
                    this.bytecodeUnaryOpDO(virtualFrame, stackTop, bci, localNodes, op);
                } else {
                    localBC[bci] = -105;
                    this.bytecodeUnaryOpDD(virtualFrame, stackTop, bci, localNodes, op);
                }
                return;
            }
            localBC[bci] = -106;
            this.bytecodeUnaryOpIO(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        if (virtualFrame.isBoolean(stackTop) && op == 0) {
            if ((this.outputCanQuicken[bci] & 0x10) != 0) {
                localBC[bci] = -103;
                this.bytecodeUnaryOpBB(virtualFrame, stackTop, bci, localNodes, op);
            } else {
                localBC[bci] = -104;
                this.bytecodeUnaryOpBO(virtualFrame, stackTop, bci, localNodes, op);
            }
            return;
        }
        this.generalizeInputs(bci);
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        localBC[bci] = -109;
        this.bytecodeUnaryOpOO(virtualFrame, stackTop, bci, localNodes, op, this.bcioffset);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpII(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isInt(stackTop)) {
            this.generalizeUnaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        int value = virtualFrame.getInt(stackTop);
        switch (op) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    virtualFrame.setInt(stackTop, Math.negateExact(value));
                    break;
                }
                catch (ArithmeticException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.bytecode[bci] = -108;
                    this.bytecodeUnaryOpIO(virtualFrame, stackTop, bci, localNodes, op);
                    return;
                }
            }
            case 3: {
                virtualFrame.setInt(stackTop, ~value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for UNARY_OP_I_I");
            }
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpIO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isInt(stackTop)) {
            this.generalizeUnaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        int value = virtualFrame.getInt(stackTop);
        virtualFrame.setObject(stackTop, switch (op) {
            case 0 -> value == 0;
            case 1 -> value;
            case 2 -> {
                IntBuiltins.NegNode negNode = this.insertChildNode(localNodes, bci, IntBuiltinsFactory.NegNodeFactory.NegNodeGen.class, NODE_INT_NEG);
                yield negNode.execute(value);
            }
            case 3 -> ~value;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for UNARY_OP_I_O");
        });
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpDD(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isDouble(stackTop)) {
            this.generalizeUnaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        double value = virtualFrame.getDouble(stackTop);
        switch (op) {
            case 1: {
                break;
            }
            case 2: {
                virtualFrame.setDouble(stackTop, -value);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for UNARY_OP_D_D");
            }
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpDO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isDouble(stackTop)) {
            this.generalizeUnaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        double value = virtualFrame.getDouble(stackTop);
        virtualFrame.setObject(stackTop, (Object)(switch (op) {
            case 0 -> Boolean.valueOf(value == 0.0);
            case 1 -> value;
            case 2 -> -value;
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for UNARY_OP_D_O");
        }));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpBB(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isBoolean(stackTop)) {
            this.generalizeUnaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        boolean value = virtualFrame.getBoolean(stackTop);
        if (op != 0) {
            throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for UNARY_OP_B_B");
        }
        virtualFrame.setBoolean(stackTop, !value);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpBO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        if (!virtualFrame.isBoolean(stackTop)) {
            this.generalizeUnaryOp(virtualFrame, stackTop, bci, localNodes, op);
            return;
        }
        boolean value = virtualFrame.getBoolean(stackTop);
        if (op != 0) {
            throw CompilerDirectives.shouldNotReachHere((String)"Invalid operation for UNARY_OP_B_B");
        }
        virtualFrame.setObject(stackTop, (Object)(!value ? 1 : 0));
    }

    private void generalizeUnaryOp(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        this.generalizeInputs(bci);
        this.bytecode[bci] = -109;
        this.bytecodeUnaryOpOO(virtualFrame, stackTop, bci, localNodes, op, this.bcioffset);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeUnaryOpOO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int op, int bciSlot) {
        Object value;
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
        UnaryOpNode opNode = this.insertChildNodeInt(localNodes, bci, UnaryOpNode.class, UNARY_OP_FACTORY, op);
        try {
            value = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeInputs(bci);
            value = virtualFrame.getValue(stackTop);
        }
        Object result = opNode.execute(virtualFrame, value);
        virtualFrame.setObject(stackTop, result);
    }

    private void bytecodeStoreFastAdaptive(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, byte[] localBC, int index, boolean hasUnboxedLocals) {
        byte variableType;
        boolean unboxInIntepreter;
        byte stackType;
        CompilerDirectives.transferToInterpreterAndInvalidate();
        byte itemType = stackType = PBytecodeRootNode.stackSlotTypeToTypeId(virtualFrame, stackTop);
        boolean bl = unboxInIntepreter = (this.variableShouldUnbox[index] & itemType) != 0;
        if (itemType == 1) {
            itemType = QuickeningTypes.fromObjectType(virtualFrame.getObject(stackTop));
        }
        if ((variableType = this.variableTypes[index]) == 0) {
            variableType = itemType;
        } else if ((variableType & 0x7F) != itemType) {
            if (variableType != 1) {
                this.variableTypes[index] = 1;
                this.generalizeVariableStores(index);
            }
            if (itemType != 1) {
                this.generalizeInputs(bci);
                this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
            }
            localBC[bci] = -122;
            this.bytecodeStoreFastO(virtualFrame, localFrame, stackTop, index);
            return;
        }
        if (itemType == 2) {
            if (unboxInIntepreter && stackType == 2) {
                localBC[bci] = -119;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastI(virtualFrame, localFrame, stackTop, bci, index);
            } else if (unboxInIntepreter) {
                localBC[bci] = -121;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastUnboxI(virtualFrame, localFrame, stackTop, bci, index);
            } else {
                this.variableTypes[index] = variableType;
                if (stackType == 2) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getInt(stackTop));
                    this.generalizeInputs(bci);
                }
                localBC[bci] = -120;
                this.bytecodeStoreFastBoxedI(virtualFrame, localFrame, stackTop, bci, index, hasUnboxedLocals);
            }
            return;
        }
        if (itemType == 4) {
            if (unboxInIntepreter && stackType == 4) {
                localBC[bci] = -116;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastL(virtualFrame, localFrame, stackTop, bci, index);
            } else if (unboxInIntepreter) {
                localBC[bci] = -118;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastUnboxL(virtualFrame, localFrame, stackTop, bci, index);
            } else {
                this.variableTypes[index] = variableType;
                if (stackType == 4) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getLong(stackTop));
                    this.generalizeInputs(bci);
                }
                localBC[bci] = -117;
                this.bytecodeStoreFastBoxedL(virtualFrame, localFrame, stackTop, bci, index, hasUnboxedLocals);
            }
            return;
        }
        if (itemType == 8) {
            if (unboxInIntepreter && stackType == 8) {
                localBC[bci] = -113;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastD(virtualFrame, localFrame, stackTop, bci, index);
            } else if (unboxInIntepreter) {
                localBC[bci] = -115;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastUnboxD(virtualFrame, localFrame, stackTop, bci, index);
            } else {
                this.variableTypes[index] = variableType;
                if (stackType == 8) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getDouble(stackTop));
                    this.generalizeInputs(bci);
                }
                localBC[bci] = -114;
                this.bytecodeStoreFastBoxedD(virtualFrame, localFrame, stackTop, bci, index, hasUnboxedLocals);
            }
            return;
        }
        if (itemType == 16) {
            if (unboxInIntepreter && stackType == 16) {
                localBC[bci] = -110;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastB(virtualFrame, localFrame, stackTop, bci, index);
            } else if (unboxInIntepreter) {
                localBC[bci] = -112;
                this.variableTypes[index] = variableType = (byte)(variableType | 0xFFFFFF80);
                this.bytecodeStoreFastUnboxB(virtualFrame, localFrame, stackTop, bci, index);
            } else {
                this.variableTypes[index] = variableType;
                if (stackType == 16) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getBoolean(stackTop));
                    this.generalizeInputs(bci);
                }
                localBC[bci] = -111;
                this.bytecodeStoreFastBoxedB(virtualFrame, localFrame, stackTop, bci, index, hasUnboxedLocals);
            }
            return;
        }
        if (itemType == 1) {
            this.variableTypes[index] = variableType;
            localBC[bci] = -122;
            this.bytecodeStoreFastO(virtualFrame, localFrame, stackTop, index);
            return;
        }
        throw CompilerDirectives.shouldNotReachHere((String)("Unexpected variable type: " + itemType));
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastI(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        if (virtualFrame.isInt(stackTop)) {
            localFrame.setInt(index, virtualFrame.getInt(stackTop));
            PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastUnboxI(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (object instanceof Integer) {
            localFrame.setInt(index, ((Integer)object).intValue());
            virtualFrame.clear(stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastBoxedI(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, boolean hasUnboxedLocals) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (!(object instanceof Integer)) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (hasUnboxedLocals) {
            localFrame.setInt(index, ((Integer)object).intValue());
        } else {
            localFrame.setObject(index, object);
        }
        virtualFrame.clear(stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastL(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        if (virtualFrame.isLong(stackTop)) {
            localFrame.setLong(index, virtualFrame.getLong(stackTop));
            PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastUnboxL(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (object instanceof Long) {
            localFrame.setLong(index, ((Long)object).longValue());
            virtualFrame.clear(stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastBoxedL(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, boolean hasUnboxedLocals) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (!(object instanceof Long)) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (hasUnboxedLocals) {
            localFrame.setLong(index, ((Long)object).longValue());
        } else {
            localFrame.setObject(index, object);
        }
        virtualFrame.clear(stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastD(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        if (virtualFrame.isDouble(stackTop)) {
            localFrame.setDouble(index, virtualFrame.getDouble(stackTop));
            PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastUnboxD(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (object instanceof Double) {
            localFrame.setDouble(index, ((Double)object).doubleValue());
            virtualFrame.clear(stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastBoxedD(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, boolean hasUnboxedLocals) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (!(object instanceof Double)) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (hasUnboxedLocals) {
            localFrame.setDouble(index, ((Double)object).doubleValue());
        } else {
            localFrame.setObject(index, object);
        }
        virtualFrame.clear(stackTop);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastB(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        if (virtualFrame.isBoolean(stackTop)) {
            localFrame.setBoolean(index, virtualFrame.getBoolean(stackTop));
            PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastUnboxB(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (object instanceof Boolean) {
            localFrame.setBoolean(index, ((Boolean)object).booleanValue());
            virtualFrame.clear(stackTop);
        } else {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastBoxedB(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, boolean hasUnboxedLocals) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (!(object instanceof Boolean)) {
            this.generalizeStoreFast(virtualFrame, localFrame, stackTop, bci, index);
            return;
        }
        if (hasUnboxedLocals) {
            localFrame.setBoolean(index, ((Boolean)object).booleanValue());
        } else {
            localFrame.setObject(index, object);
        }
        virtualFrame.clear(stackTop);
    }

    private void generalizeStoreFast(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeFrameSlot((Frame)virtualFrame, index);
        this.generalizeInputs(index);
        this.bytecode[bci] = -122;
        this.generalizeVariableStores(index);
        this.bytecodeStoreFastO(virtualFrame, localFrame, stackTop, index);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeStoreFastO(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int index) {
        Object object;
        try {
            object = virtualFrame.getObject(stackTop);
        }
        catch (FrameSlotTypeException e) {
            this.generalizeVariableStores(index);
            object = virtualFrame.getValue(stackTop);
        }
        localFrame.setObject(index, object);
        virtualFrame.clear(stackTop);
    }

    @HostCompilerDirectives.InliningCutoff
    private void bytecodeLoadFastAdaptive(VirtualFrame virtualFrame, Frame localFrame, int stackTop, byte[] localBC, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (localFrame.isObject(index)) {
            localBC[bci] = 125;
            this.bytecodeLoadFastO(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        } else if (localFrame.isInt(index)) {
            if ((this.outputCanQuicken[bci] & 2) != 0) {
                localBC[bci] = 127;
                this.bytecodeLoadFastI(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            } else {
                localBC[bci] = 126;
                this.bytecodeLoadFastIBox(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            }
        } else if (localFrame.isLong(index)) {
            if ((this.outputCanQuicken[bci] & 4) != 0) {
                localBC[bci] = -127;
                this.bytecodeLoadFastL(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            } else {
                localBC[bci] = -128;
                this.bytecodeLoadFastLBox(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            }
        } else if (localFrame.isDouble(index)) {
            if ((this.outputCanQuicken[bci] & 8) != 0) {
                localBC[bci] = -125;
                this.bytecodeLoadFastD(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            } else {
                localBC[bci] = -126;
                this.bytecodeLoadFastDBox(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            }
        } else if (localFrame.isBoolean(index)) {
            if ((this.outputCanQuicken[bci] & 0x10) != 0) {
                localBC[bci] = -123;
                this.bytecodeLoadFastB(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            } else {
                localBC[bci] = -124;
                this.bytecodeLoadFastBBox(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
            }
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)"Unimplemented stack item type for LOAD_FAST");
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadFastIBox(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isInt(index)) {
            virtualFrame.setObject(stackTop, (Object)localFrame.getInt(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadFastI(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isInt(index)) {
            virtualFrame.setInt(stackTop, localFrame.getInt(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    private void bytecodeLoadFastLBox(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isLong(index)) {
            virtualFrame.setObject(stackTop, (Object)localFrame.getLong(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    private void bytecodeLoadFastL(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isLong(index)) {
            virtualFrame.setLong(stackTop, localFrame.getLong(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    private void bytecodeLoadFastDBox(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isDouble(index)) {
            virtualFrame.setObject(stackTop, (Object)localFrame.getDouble(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    private void bytecodeLoadFastD(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isDouble(index)) {
            virtualFrame.setDouble(stackTop, localFrame.getDouble(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadFastBBox(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isBoolean(index)) {
            virtualFrame.setObject(stackTop, (Object)localFrame.getBoolean(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadFastB(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        if (localFrame.isBoolean(index)) {
            virtualFrame.setBoolean(stackTop, localFrame.getBoolean(index));
        } else {
            this.generalizeLoadFast(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
        }
    }

    private void generalizeLoadFast(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeVariableStores(index);
        this.generalizeFrameSlot((Frame)virtualFrame, index);
        this.bytecode[bci] = 125;
        this.bytecodeLoadFastO(virtualFrame, localFrame, stackTop, bci, index, localNodes, hasUnboxedLocals);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadFastO(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, int index, Node[] localNodes, boolean hasUnboxedLocals) {
        Object value;
        try {
            if (hasUnboxedLocals) {
                if (this.variableTypes[index] == 2) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getInt(index));
                    return;
                }
                if (this.variableTypes[index] == 4) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getLong(index));
                    return;
                }
                if (this.variableTypes[index] == 8) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getDouble(index));
                    return;
                }
                if (this.variableTypes[index] == 16) {
                    virtualFrame.setObject(stackTop, (Object)virtualFrame.getBoolean(index));
                    return;
                }
            }
            value = localFrame.getObject(index);
        }
        catch (FrameSlotTypeException e) {
            value = this.generalizeBytecodeLoadFastO(localFrame, index);
        }
        if (value == null) {
            throw this.raiseVarReferencedBeforeAssignment(localNodes, bci, index);
        }
        virtualFrame.setObject(stackTop, value);
    }

    @HostCompilerDirectives.InliningCutoff
    private PException raiseVarReferencedBeforeAssignment(Node[] localNodes, int bci, int index) {
        PRaiseCachedNode raiseNode = this.insertChildNode(localNodes, bci, PRaiseCachedNodeGen.class, NODE_RAISE);
        throw raiseNode.raise(PythonBuiltinClassType.UnboundLocalError, ErrorMessages.LOCAL_VAR_REFERENCED_BEFORE_ASSIGMENT, this.varnames[index]);
    }

    private Object generalizeBytecodeLoadFastO(Frame localFrame, int index) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeVariableStores(index);
        this.generalizeFrameSlot(localFrame, index);
        return localFrame.getValue(index);
    }

    private static byte stackSlotTypeToTypeId(VirtualFrame virtualFrame, int stackTop) {
        return QuickeningTypes.fromFrameSlotTag(virtualFrame.getTag(stackTop));
    }

    private void generalizeInputs(int beginBci) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.generalizeInputsMap != null && this.generalizeInputsMap[beginBci] != null) {
            for (int i = 0; i < this.generalizeInputsMap[beginBci].length; ++i) {
                int generalizeBci = this.generalizeInputsMap[beginBci][i];
                OpCodes generalizeInstr = OpCodes.fromOpCode(this.bytecode[generalizeBci]);
                if (generalizeInstr.generalizesTo == null) continue;
                this.bytecode[generalizeBci] = (byte)generalizeInstr.generalizesTo.ordinal();
            }
        }
    }

    private void generalizeVariableStores(int index) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.variableTypes[index] = 1;
        if (this.generalizeVarsMap != null && this.generalizeVarsMap[index] != null) {
            for (int i = 0; i < this.generalizeVarsMap[index].length; ++i) {
                int generalizeBci = this.generalizeVarsMap[index][i];
                if (this.bytecode[generalizeBci] == 31) continue;
                this.generalizeInputs(generalizeBci);
                this.bytecode[generalizeBci] = -122;
            }
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private PException wrapJavaExceptionIfApplicable(PythonLanguage language, Throwable e) {
        if (e instanceof AbstractTruffleException) {
            return null;
        }
        if (e instanceof ControlFlowException) {
            return null;
        }
        if (language.getEngineOption(PythonOptions.CatchAllExceptions).booleanValue() && (e instanceof Exception || e instanceof AssertionError)) {
            return ExceptionUtils.wrapJavaException(e, (Node)this, PFactory.createBaseException(language, PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e}));
        }
        return ExceptionUtils.wrapJavaExceptionIfApplicable((Node)this, e);
    }

    @ExplodeLoop
    private void copyStackSlotsToGeneratorFrame(Frame virtualFrame, Frame generatorFrame, int stackTop) {
        for (int i = this.stackoffset; i <= stackTop; ++i) {
            if (virtualFrame.isObject(i)) {
                generatorFrame.setObject(i, virtualFrame.getObject(i));
                continue;
            }
            if (virtualFrame.isInt(i)) {
                generatorFrame.setInt(i, virtualFrame.getInt(i));
                continue;
            }
            if (virtualFrame.isLong(i)) {
                generatorFrame.setLong(i, virtualFrame.getLong(i));
                continue;
            }
            if (virtualFrame.isDouble(i)) {
                generatorFrame.setDouble(i, virtualFrame.getDouble(i));
                continue;
            }
            if (virtualFrame.isBoolean(i)) {
                generatorFrame.setBoolean(i, virtualFrame.getBoolean(i));
                continue;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"unexpected frame slot type");
        }
    }

    @ExplodeLoop
    private void clearFrameSlots(Frame frame, int start, int end) {
        CompilerAsserts.partialEvaluationConstant((int)start);
        CompilerAsserts.partialEvaluationConstant((int)end);
        for (int i = start; i <= end; ++i) {
            frame.setObject(i, null);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private int bytecodeFormatValue(VirtualFrame virtualFrame, int initialStackTop, int bci, Node[] localNodes, int options, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        int type = options & 3;
        Object spec = PNone.NO_VALUE;
        if ((options & 4) == 4) {
            spec = virtualFrame.getObject(stackTop);
            virtualFrame.clear(stackTop--);
        }
        Object value = virtualFrame.getObject(stackTop);
        switch (type) {
            case 1: {
                value = this.insertChildNode(localNodes, bci, UNCACHED_STR, PyObjectStrAsObjectNodeGen.class, NODE_STR, useCachedNodes).executeCached((Frame)virtualFrame, value);
                break;
            }
            case 2: {
                value = this.insertChildNode(localNodes, bci, UNCACHED_REPR, PyObjectReprAsObjectNodeGen.class, NODE_REPR, useCachedNodes).executeCached((Frame)virtualFrame, value);
                break;
            }
            case 3: {
                value = this.insertChildNode(localNodes, bci, UNCACHED_ASCII, PyObjectAsciiNodeGen.class, NODE_ASCII, useCachedNodes).executeCached((Frame)virtualFrame, value);
                break;
            }
            default: {
                assert (type == 0);
                break;
            }
        }
        BuiltinFunctions.FormatNode formatNode = this.insertChildNode(localNodes, bci + 1, BuiltinFunctionsFactory.FormatNodeFactory.FormatNodeGen.class, NODE_FORMAT);
        value = formatNode.execute(virtualFrame, value, spec);
        virtualFrame.setObject(stackTop, value);
        return stackTop;
    }

    private void bytecodeDeleteDeref(Frame localFrame, int bci, Node[] localNodes, int oparg, int cachedCelloffset, boolean useCachedNodes) {
        PCell cell = (PCell)localFrame.getObject(cachedCelloffset + oparg);
        Object value = cell.getRef();
        if (value == null) {
            this.raiseUnboundCell(localNodes, bci, oparg, useCachedNodes);
        }
        cell.clearRef();
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreDeref(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int oparg, int cachedCelloffset) {
        PCell cell = (PCell)localFrame.getObject(cachedCelloffset + oparg);
        Object value = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        cell.setRef(value);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeLoadDeref(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, Node[] localNodes, int oparg, int cachedCelloffset, boolean useCachedNodes) {
        PCell cell = (PCell)localFrame.getObject(cachedCelloffset + oparg);
        Object value = cell.getRef();
        if (value == null) {
            this.raiseUnboundCell(localNodes, bci, oparg, useCachedNodes);
        }
        virtualFrame.setObject(++stackTop, value);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeLoadFromDictOrDeref(VirtualFrame virtualFrame, Frame localFrame, int stackTop, int bci, Node[] localNodes, int oparg, int cachedCelloffset, boolean useCachedNodes) {
        TruffleString varName = oparg >= this.cellvars.length ? this.freevars[oparg - this.cellvars.length] : this.cellvars[oparg];
        ReadFromLocalsNode readFromLocals = this.insertChildNode(localNodes, bci, UNCACHED_READ_FROM_LOCALS, ReadFromLocalsNodeGen.class, NODE_READ_FROM_LOCALS, useCachedNodes);
        Object dict = virtualFrame.getObject(stackTop);
        virtualFrame.setObject(stackTop--, null);
        Object value = readFromLocals.executeCached(virtualFrame, dict, varName);
        if (value != PNone.NO_VALUE) {
            virtualFrame.setObject(++stackTop, value);
            return stackTop;
        }
        return this.bytecodeLoadDeref(virtualFrame, localFrame, stackTop, bci, localNodes, oparg, cachedCelloffset, useCachedNodes);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeLoadFromDictOrGlobals(VirtualFrame virtualFrame, Object globals, int stackTop, int bci, TruffleString localName, Node[] localNodes, boolean useCachedNodes) {
        ReadFromDictOrGlobalsNode read = this.insertChildNode(localNodes, bci, UNCACHED_READ_FROM_DICT_OR_GLOBALS, ReadFromDictOrGlobalsNodeGen.class, NODE_READ_FROM_DICT_OR_GLOBALS, useCachedNodes);
        return read.execute(virtualFrame, stackTop, globals, localName);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeClosureFromStack(VirtualFrame virtualFrame, int stackTop, int oparg) {
        PCell[] closure = new PCell[oparg];
        PBytecodeRootNode.moveFromStack(virtualFrame, stackTop - oparg + 1, stackTop + 1, closure);
        virtualFrame.setObject(stackTop -= oparg - 1, (Object)closure);
        return stackTop;
    }

    private AbstractTruffleException popExceptionState(Object[] arguments, Object savedException, AbstractTruffleException outerException) {
        AbstractTruffleException localException = null;
        if (savedException instanceof AbstractTruffleException) {
            localException = (AbstractTruffleException)((Object)savedException);
            PArguments.setException(arguments, localException);
        } else if (savedException == null) {
            PArguments.setException(arguments, outerException);
        } else {
            throw CompilerDirectives.shouldNotReachHere((String)"expected exception on the stack");
        }
        return localException;
    }

    private AbstractTruffleException bytecodeEndExcHandler(VirtualFrame virtualFrame, int stackTop) {
        Object exception = virtualFrame.getObject(stackTop);
        if (exception instanceof PException) {
            throw ((PException)((Object)exception)).getExceptionForReraise(this.frameIsVisibleToPython());
        }
        if (exception instanceof AbstractTruffleException) {
            throw (AbstractTruffleException)((Object)exception);
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Exception not on stack");
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadAttr(VirtualFrame virtualFrame, int stackTop, int bci, int oparg, Node[] localNodes, TruffleString[] localNames, boolean useCachedNodes) {
        PyObjectGetAttr getAttr = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_GET_ATTR, PyObjectGetAttrNodeGen.class, NODE_OBJECT_GET_ATTR, useCachedNodes);
        TruffleString varname = localNames[oparg];
        Object owner = virtualFrame.getObject(stackTop);
        Object value = getAttr.executeCached((Frame)virtualFrame, owner, varname);
        virtualFrame.setObject(stackTop, value);
    }

    private void bytecodeDeleteFast(Frame localFrame, int bci, Node[] localNodes, int oparg) {
        if (localFrame.isObject(oparg)) {
            Object value = localFrame.getObject(oparg);
            if (value == null) {
                throw this.raiseVarReferencedBeforeAssignment(localNodes, bci, oparg);
            }
        } else {
            this.generalizeVariableStores(oparg);
        }
        localFrame.setObject(oparg, null);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeLoadGlobal(VirtualFrame virtualFrame, Object globals, int stackTop, int bci, TruffleString localName, Node[] localNodes, boolean useCachedNodes) {
        ReadGlobalOrBuiltinNode read = this.insertChildNode(localNodes, bci, UNCACHED_READ_GLOBAL_OR_BUILTIN, ReadGlobalOrBuiltinNodeGen.class, NODE_READ_GLOBAL_OR_BUILTIN, useCachedNodes);
        virtualFrame.setObject(++stackTop, read.read((Frame)virtualFrame, globals, localName));
        return stackTop;
    }

    @HostCompilerDirectives.InliningCutoff
    private void bytecodeDeleteGlobal(VirtualFrame virtualFrame, Object globals, int bci, int oparg, Node[] localNodes, TruffleString[] localNames, boolean useCachedNodes) {
        TruffleString varname = localNames[oparg];
        DeleteGlobalNode deleteGlobalNode = this.insertChildNode(localNodes, bci, UNCACHED_DELETE_GLOBAL, DeleteGlobalNodeGen.class, NODE_DELETE_GLOBAL, useCachedNodes);
        deleteGlobalNode.executeWithGlobals(virtualFrame, globals, varname);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreGlobal(VirtualFrame virtualFrame, Object globals, int stackTop, int bci, int oparg, Node[] localNodes, TruffleString[] localNames, boolean useCachedNodes) {
        TruffleString varname = localNames[oparg];
        WriteGlobalNode writeGlobalNode = this.insertChildNode(localNodes, bci, UNCACHED_WRITE_GLOBAL, WriteGlobalNodeGen.class, NODE_WRITE_GLOBAL, useCachedNodes);
        writeGlobalNode.write((Frame)virtualFrame, globals, varname, virtualFrame.getObject(stackTop));
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    private int bytecodeDeleteAttr(VirtualFrame virtualFrame, int stackTop, int bci, int oparg, Node[] localNodes, TruffleString[] localNames, boolean useCachedNodes) {
        PyObjectSetAttr callNode = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_SET_ATTR, PyObjectSetAttrNodeGen.class, NODE_OBJECT_SET_ATTR, useCachedNodes);
        TruffleString varname = localNames[oparg];
        Object owner = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        callNode.deleteCached((Frame)virtualFrame, owner, varname);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreAttr(VirtualFrame virtualFrame, int stackTop, int bci, int oparg, Node[] localNodes, TruffleString[] localNames, boolean useCachedNodes) {
        PyObjectSetAttr callNode = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_SET_ATTR, PyObjectSetAttrNodeGen.class, NODE_OBJECT_SET_ATTR, useCachedNodes);
        TruffleString varname = localNames[oparg];
        Object owner = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        Object value = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        callNode.executeCached((Frame)virtualFrame, owner, varname, value);
        return stackTop;
    }

    private void bytecodeDeleteName(VirtualFrame virtualFrame, Object globals, Object locals, int bci, int oparg, TruffleString[] localNames, Node[] localNodes, boolean useCachedNodes) {
        TruffleString varname = localNames[oparg];
        if (locals != null) {
            PyObjectDelItem delItemNode = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_DEL_ITEM, PyObjectDelItemNodeGen.class, NODE_OBJECT_DEL_ITEM, useCachedNodes);
            try {
                delItemNode.executeCached((Frame)virtualFrame, locals, varname);
            }
            catch (PException e) {
                PRaiseCachedNode raiseNode = this.insertChildNode(localNodes, bci, UNCACHED_RAISE, PRaiseCachedNodeGen.class, NODE_RAISE, useCachedNodes);
                throw raiseNode.raise(PythonErrorType.NameError, ErrorMessages.NAME_NOT_DEFINED, varname);
            }
        } else {
            DeleteGlobalNode deleteGlobalNode = this.insertChildNode(localNodes, bci + 1, UNCACHED_DELETE_GLOBAL, DeleteGlobalNodeGen.class, NODE_DELETE_GLOBAL, useCachedNodes);
            deleteGlobalNode.executeWithGlobals(virtualFrame, globals, varname);
        }
    }

    private int bytecodeDeleteSubscr(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes) {
        PyObjectDelItem delItem = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_DEL_ITEM, PyObjectDelItemNodeGen.class, NODE_OBJECT_DEL_ITEM, useCachedNodes);
        Object slice = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        Object container = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        delItem.executeCached((Frame)virtualFrame, container, slice);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreSubscrAdaptive(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes, int bciSlot) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (virtualFrame.isInt(stackTop) && virtualFrame.getObject(stackTop - 1) instanceof PList) {
            if (virtualFrame.isInt(stackTop - 2)) {
                this.bytecode[bci] = -87;
                return this.bytecodeStoreSubscrSeqIIO(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
            }
            if (virtualFrame.isDouble(stackTop - 2)) {
                this.bytecode[bci] = -86;
                return this.bytecodeStoreSubscrSeqIDO(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
            }
            this.bytecode[bci] = -88;
            return this.bytecodeStoreSubscrSeqIOO(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        if (!virtualFrame.isObject(stackTop) || !virtualFrame.isObject(stackTop - 2)) {
            this.generalizeInputs(bci);
            this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
            this.generalizeFrameSlot((Frame)virtualFrame, stackTop - 2);
        }
        this.bytecode[bci] = -89;
        return this.bytecodeStoreSubscrOOO(virtualFrame, stackTop, bci, localNodes, useCachedNodes, bciSlot);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreSubscrOOO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes, int bciSlot) {
        PBytecodeRootNode.setCurrentBci(virtualFrame, bciSlot, bci);
        PyObjectSetItem setItem = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_SET_ITEM, PyObjectSetItemNodeGen.class, NODE_OBJECT_SET_ITEM, useCachedNodes);
        try {
            Object index = virtualFrame.getObject(stackTop);
            Object container = virtualFrame.getObject(stackTop - 1);
            Object value = virtualFrame.getObject(stackTop - 2);
            setItem.executeCached((Frame)virtualFrame, container, index, value);
        }
        catch (FrameSlotTypeException e) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        virtualFrame.clear(stackTop--);
        virtualFrame.clear(stackTop--);
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreSubscrSeqIOO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes) {
        Object value;
        Object container;
        if (!virtualFrame.isInt(stackTop)) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        int index = virtualFrame.getInt(stackTop);
        try {
            container = virtualFrame.getObject(stackTop - 1);
            value = virtualFrame.getObject(stackTop - 2);
        }
        catch (FrameSlotTypeException e) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        try {
            StoreSubscrSeq.ONode setItem = this.insertChildNode(localNodes, bci, StoreSubscrSeqFactory.ONodeGen.class, NODE_STORE_SUBSCR_SEQ_O);
            setItem.execute(container, index, value);
        }
        catch (QuickeningGeneralizeException e) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        virtualFrame.clear(stackTop--);
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreSubscrSeqIIO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes) {
        if (!virtualFrame.isInt(stackTop - 2)) {
            return this.generalizeStoreSubscrSeq(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        if (!virtualFrame.isInt(stackTop)) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        int index = virtualFrame.getInt(stackTop);
        Object container = virtualFrame.getObject(stackTop - 1);
        int value = virtualFrame.getInt(stackTop - 2);
        try {
            StoreSubscrSeq.INode setItem = this.insertChildNode(localNodes, bci, StoreSubscrSeqFactory.INodeGen.class, NODE_STORE_SUBSCR_SEQ_I);
            setItem.execute(container, index, value);
        }
        catch (QuickeningGeneralizeException e) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        virtualFrame.clear(stackTop--);
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreSubscrSeqIDO(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes) {
        if (!virtualFrame.isInt(stackTop - 2)) {
            return this.generalizeStoreSubscrSeq(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        if (!virtualFrame.isInt(stackTop)) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        int index = virtualFrame.getInt(stackTop);
        Object container = virtualFrame.getObject(stackTop - 1);
        double value = virtualFrame.getDouble(stackTop - 2);
        try {
            StoreSubscrSeq.DNode setItem = this.insertChildNode(localNodes, bci, StoreSubscrSeqFactory.DNodeGen.class, NODE_STORE_SUBSCR_SEQ_D);
            setItem.execute(container, index, value);
        }
        catch (QuickeningGeneralizeException e) {
            return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        virtualFrame.clear(stackTop--);
        PBytecodeRootNode.clearInCompiledCode(virtualFrame, stackTop--);
        return stackTop;
    }

    private int generalizeStoreSubscrSeq(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (virtualFrame.isInt(stackTop)) {
            this.generalizeFrameSlot((Frame)virtualFrame, stackTop - 2);
            this.bytecode[bci] = -88;
            return this.bytecodeStoreSubscrSeqIOO(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
        }
        return this.generalizeStoreSubscr(virtualFrame, stackTop, bci, localNodes, useCachedNodes);
    }

    private int generalizeStoreSubscr(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, boolean useCachedNodes) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.generalizeInputs(bci);
        this.bytecode[bci] = -89;
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop);
        this.generalizeFrameSlot((Frame)virtualFrame, stackTop - 2);
        return this.bytecodeStoreSubscrOOO(virtualFrame, stackTop, bci, localNodes, useCachedNodes, this.bcioffset);
    }

    private void generalizeFrameSlot(Frame frame, int slot) {
        if (!frame.isObject(slot)) {
            frame.setObject(slot, frame.getValue(slot));
        }
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeBuildSlice(VirtualFrame virtualFrame, int stackTop, int bci, int count, Node[] localNodes, boolean useCachedNodes) {
        Object step;
        if (count == 3) {
            step = virtualFrame.getObject(stackTop);
            virtualFrame.clear(stackTop--);
        } else {
            assert (count == 2);
            step = PNone.NONE;
        }
        Object stop = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        Object start = virtualFrame.getObject(stackTop);
        SliceNodes.CreateSliceNode sliceNode = this.insertChildNode(localNodes, bci, UNCACHED_CREATE_SLICE, SliceNodesFactory.CreateSliceNodeGen.class, NODE_CREATE_SLICE, useCachedNodes);
        PSlice slice = sliceNode.execute(start, stop, step);
        virtualFrame.setObject(stackTop, (Object)slice);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeLoadConstCollection(VirtualFrame virtualFrame, int stackTop, Object array, int typeAndKind) {
        int kind = OpCodes.CollectionBits.collectionKind(typeAndKind);
        assert (kind == 32 || kind == 64);
        boolean list = kind == 32;
        PythonLanguage language = this.getLanguage();
        boolean useNativePrimitiveStorage = language.getEngineOption(PythonOptions.UseNativePrimitiveStorageStrategy);
        SequenceStorage storage = switch (OpCodes.CollectionBits.elementType(typeAndKind)) {
            case 1 -> {
                PythonContext context = PythonContext.get((Node)this);
                int[] a = (int[])array;
                if (useNativePrimitiveStorage) {
                    yield context.nativeBufferContext.toNativeIntStorage(a);
                }
                if (list) {
                    a = PythonUtils.arrayCopyOf(a, a.length);
                }
                yield new IntSequenceStorage(a);
            }
            case 2 -> {
                long[] a = (long[])array;
                if (list) {
                    a = PythonUtils.arrayCopyOf(a, a.length);
                }
                yield new LongSequenceStorage(a);
            }
            case 3 -> {
                boolean[] a = (boolean[])array;
                if (list) {
                    a = PythonUtils.arrayCopyOf(a, a.length);
                }
                yield new BoolSequenceStorage(a);
            }
            case 4 -> {
                double[] a = (double[])array;
                if (list) {
                    a = PythonUtils.arrayCopyOf(a, a.length);
                }
                yield new DoubleSequenceStorage(a);
            }
            case 5 -> {
                Object[] a = (Object[])array;
                if (list) {
                    a = PythonUtils.arrayCopyOf(a, a.length);
                }
                yield new ObjectSequenceStorage(a);
            }
            default -> throw CompilerDirectives.shouldNotReachHere();
        };
        PSequence result = list ? PFactory.createList(language, storage) : PFactory.createTuple(language, storage);
        virtualFrame.setObject(stackTop, (Object)result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCallFunctionKw(VirtualFrame virtualFrame, int initialStackTop, int bci, Node[] localNodes, boolean useCachedNodes, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        Object result;
        int stackTop = initialStackTop;
        CallNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL, CallNodeGen.class, NODE_CALL, useCachedNodes);
        Object callable = virtualFrame.getObject(stackTop - 2);
        Object[] args = (Object[])virtualFrame.getObject(stackTop - 1);
        this.profileCEvent(virtualFrame, callable, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
        try {
            result = callNode.execute((Frame)virtualFrame, callable, args, (PKeyword[])virtualFrame.getObject(stackTop));
            this.profileCEvent(virtualFrame, callable, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
        }
        catch (AbstractTruffleException e) {
            this.profileCEvent(virtualFrame, callable, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
            throw e;
        }
        virtualFrame.setObject(stackTop - 2, result);
        virtualFrame.clear(stackTop--);
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCallFunctionVarargs(VirtualFrame virtualFrame, int initialStackTop, int bci, Node[] localNodes, boolean useCachedNodes, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        Object result;
        int stackTop = initialStackTop;
        CallNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL, CallNodeGen.class, NODE_CALL, useCachedNodes);
        Object callable = virtualFrame.getObject(stackTop - 1);
        Object[] args = (Object[])virtualFrame.getObject(stackTop);
        this.profileCEvent(virtualFrame, callable, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
        try {
            result = callNode.execute((Frame)virtualFrame, callable, args, PKeyword.EMPTY_KEYWORDS);
            this.profileCEvent(virtualFrame, callable, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
        }
        catch (AbstractTruffleException e) {
            this.profileCEvent(virtualFrame, callable, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
            throw e;
        }
        virtualFrame.setObject(stackTop - 1, result);
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCallMethodVarargs(VirtualFrame virtualFrame, int initialStackTop, int bci, Node[] localNodes, boolean useCachedNodes, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        Object result;
        int stackTop = initialStackTop;
        Object func = virtualFrame.getObject(stackTop - 1);
        Object[] args = (Object[])virtualFrame.getObject(stackTop);
        CallNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL, CallNodeGen.class, NODE_CALL, useCachedNodes);
        this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
        try {
            result = callNode.execute((Frame)virtualFrame, func, args, PKeyword.EMPTY_KEYWORDS);
            this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
        }
        catch (AbstractTruffleException e) {
            this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
            throw e;
        }
        virtualFrame.setObject(stackTop - 1, result);
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeLoadName(VirtualFrame virtualFrame, int initialStackTop, int bci, int oparg, Node[] localNodes, TruffleString[] localNames, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        ReadNameNode readNameNode = this.insertChildNode(localNodes, bci, UNCACHED_READ_NAME, ReadNameNodeGen.class, NODE_READ_NAME, useCachedNodes);
        virtualFrame.setObject(++stackTop, readNameNode.execute(virtualFrame, localNames[oparg]));
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCallFunction(VirtualFrame virtualFrame, int stackTop, int bci, int oparg, Node[] localNodes, boolean useCachedNodes, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        Object func = virtualFrame.getObject(stackTop - oparg);
        switch (oparg) {
            case 0: {
                Object result;
                CallNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL, CallNodeGen.class, NODE_CALL, useCachedNodes);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.execute((Frame)virtualFrame, func, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 1: {
                Object result;
                CallUnaryMethodNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL_UNARY_METHOD, CallUnaryMethodNodeGen.class, NODE_CALL_UNARY_METHOD, useCachedNodes);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.executeObject((Frame)virtualFrame, func, virtualFrame.getObject(stackTop));
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.clear(stackTop--);
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 2: {
                Object result;
                CallBinaryMethodNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL_BINARY_METHOD, CallBinaryMethodNodeGen.class, NODE_CALL_BINARY_METHOD, useCachedNodes);
                Object arg1 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg0 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.executeObject((Frame)virtualFrame, func, arg0, arg1);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 3: {
                Object result;
                CallTernaryMethodNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL_TERNARY_METHOD, CallTernaryMethodNodeGen.class, NODE_CALL_TERNARY_METHOD, useCachedNodes);
                Object arg2 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg1 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg0 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.execute((Frame)virtualFrame, func, arg0, arg1, arg2);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 4: {
                Object result;
                CallQuaternaryMethodNode callNode = this.insertChildNode(localNodes, bci, UNCACHED_CALL_QUATERNARY_METHOD, CallQuaternaryMethodNodeGen.class, NODE_CALL_QUATERNARY_METHOD, useCachedNodes);
                Object arg3 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg2 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg1 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg0 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.execute((Frame)virtualFrame, func, arg0, arg1, arg2, arg3);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.setObject(stackTop, result);
                break;
            }
        }
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCallComprehension(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        Object result;
        PFunction func = (PFunction)virtualFrame.getObject(stackTop - 1);
        CallComprehensionNode callNode = this.insertChildNode(localNodes, bci, CallComprehensionNodeGen.class, NODE_CALL_COMPREHENSION);
        this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
        try {
            Object[] arguments = PArguments.create(1);
            PArguments.setArgument(arguments, 0, virtualFrame.getObject(stackTop));
            result = callNode.execute(virtualFrame, func, arguments);
            this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
        }
        catch (AbstractTruffleException e) {
            this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
            throw e;
        }
        virtualFrame.clear(stackTop--);
        virtualFrame.setObject(stackTop, result);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeLoadMethod(VirtualFrame virtualFrame, int stackTop, int bci, int oparg, TruffleString[] localNames, Node[] localNodes, boolean useCachedNodes) {
        Object rcvr = virtualFrame.getObject(stackTop);
        TruffleString methodName = localNames[oparg];
        PyObjectGetMethod getMethodNode = this.insertChildNode(localNodes, bci, UNCACHED_OBJECT_GET_METHOD, PyObjectGetMethodNodeGen.class, NODE_OBJECT_GET_METHOD, useCachedNodes);
        Object func = getMethodNode.executeCached((Frame)virtualFrame, rcvr, methodName);
        virtualFrame.setObject(++stackTop, func);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCallMethod(VirtualFrame virtualFrame, int stackTop, int bci, int argcount, Node[] localNodes, boolean useCachedNodes, MutableLoopData mutableData, byte tracingOrProfilingEnabled) {
        Object func = virtualFrame.getObject(stackTop - argcount);
        Object rcvr = virtualFrame.getObject(stackTop - argcount - 1);
        switch (argcount) {
            case 0: {
                Object result;
                CallUnaryMethodNode callNode = this.insertChildNode(localNodes, bci + 1, UNCACHED_CALL_UNARY_METHOD, CallUnaryMethodNodeGen.class, NODE_CALL_UNARY_METHOD, useCachedNodes);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.executeObject((Frame)virtualFrame, func, rcvr);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.clear(stackTop--);
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 1: {
                Object result;
                CallBinaryMethodNode callNode = this.insertChildNode(localNodes, bci + 1, UNCACHED_CALL_BINARY_METHOD, CallBinaryMethodNodeGen.class, NODE_CALL_BINARY_METHOD, useCachedNodes);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.executeObject((Frame)virtualFrame, func, rcvr, virtualFrame.getObject(stackTop));
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.clear(stackTop--);
                virtualFrame.clear(stackTop--);
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 2: {
                Object result;
                CallTernaryMethodNode callNode = this.insertChildNode(localNodes, bci + 1, UNCACHED_CALL_TERNARY_METHOD, CallTernaryMethodNodeGen.class, NODE_CALL_TERNARY_METHOD, useCachedNodes);
                Object arg1 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg0 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                virtualFrame.clear(stackTop--);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.execute((Frame)virtualFrame, func, rcvr, arg0, arg1);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.setObject(stackTop, result);
                break;
            }
            case 3: {
                Object result;
                CallQuaternaryMethodNode callNode = this.insertChildNode(localNodes, bci + 1, UNCACHED_CALL_QUATERNARY_METHOD, CallQuaternaryMethodNodeGen.class, NODE_CALL_QUATERNARY_METHOD, useCachedNodes);
                Object arg2 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg1 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                Object arg0 = virtualFrame.getObject(stackTop);
                virtualFrame.clear(stackTop--);
                virtualFrame.clear(stackTop--);
                this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_CALL, mutableData, tracingOrProfilingEnabled);
                try {
                    result = callNode.execute((Frame)virtualFrame, func, rcvr, arg0, arg1, arg2);
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_RETURN, mutableData, tracingOrProfilingEnabled);
                }
                catch (AbstractTruffleException e) {
                    this.profileCEvent(virtualFrame, func, PythonContext.ProfileEvent.C_EXCEPTION, mutableData, tracingOrProfilingEnabled);
                    throw e;
                }
                virtualFrame.setObject(stackTop, result);
                break;
            }
        }
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeStoreName(VirtualFrame virtualFrame, int initialStackTop, int bci, int oparg, TruffleString[] localNames, Node[] localNodes, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        Object value = virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        WriteNameNode writeNameNode = this.insertChildNode(localNodes, bci, UNCACHED_WRITE_NAME, WriteNameNodeGen.class, NODE_WRITE_NAME, useCachedNodes);
        writeNameNode.execute(virtualFrame, localNames[oparg], value);
        return stackTop;
    }

    @HostCompilerDirectives.InliningCutoff
    private AbstractTruffleException bytecodeRaiseVarargs(VirtualFrame virtualFrame, int stackTop, int bci, int count, Node[] localNodes) {
        Object exception;
        Object cause;
        RaiseNode raiseNode = this.insertChildNode(localNodes, bci, RaiseNodeGen.class, NODE_RAISENODE);
        if (count > 1) {
            cause = virtualFrame.getObject(stackTop);
            virtualFrame.clear(stackTop--);
        } else {
            cause = PNone.NO_VALUE;
        }
        if (count > 0) {
            exception = virtualFrame.getObject(stackTop);
            virtualFrame.clear(stackTop--);
        } else {
            exception = PNone.NO_VALUE;
        }
        raiseNode.execute(virtualFrame, exception, cause, this.frameIsVisibleToPython());
        throw CompilerDirectives.shouldNotReachHere();
    }

    @HostCompilerDirectives.InliningCutoff
    private void raiseUnboundCell(Node[] localNodes, int bci, int oparg, boolean useCachedNodes) {
        PRaiseCachedNode raiseNode = this.insertChildNode(localNodes, bci, UNCACHED_RAISE, PRaiseCachedNodeGen.class, NODE_RAISE, useCachedNodes);
        if (oparg < this.cellvars.length) {
            throw raiseNode.raise(PythonBuiltinClassType.UnboundLocalError, ErrorMessages.LOCAL_VAR_REFERENCED_BEFORE_ASSIGMENT, this.cellvars[oparg]);
        }
        int varIdx = oparg - this.cellvars.length;
        throw raiseNode.raise(PythonBuiltinClassType.NameError, ErrorMessages.UNBOUNDFREEVAR, this.freevars[varIdx]);
    }

    @HostCompilerDirectives.InliningCutoff
    private int bytecodeImportName(VirtualFrame virtualFrame, Object globals, int initialStackTop, int bci, int oparg, TruffleString[] localNames, Node[] localNodes, boolean useCachedNodes) {
        CastToJavaIntExactNode castNode = this.insertChildNode(localNodes, bci, UNCACHED_CAST_TO_JAVA_INT_EXACT, CastToJavaIntExactNodeGen.class, NODE_CAST_TO_JAVA_INT_EXACT, useCachedNodes);
        TruffleString modname = localNames[oparg];
        int stackTop = initialStackTop;
        TruffleString[] fromlist = (TruffleString[])virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        int level = castNode.executeCached(virtualFrame.getObject(stackTop));
        ImportNode importNode = this.insertChildNode(localNodes, bci + 1, UNCACHED_IMPORT, ImportNodeGen.class, NODE_IMPORT, useCachedNodes);
        Object result = importNode.execute(virtualFrame, modname, globals, fromlist, level);
        virtualFrame.setObject(stackTop, result);
        return stackTop;
    }

    @HostCompilerDirectives.InliningCutoff
    private int bytecodeImportFrom(VirtualFrame virtualFrame, int initialStackTop, int bci, int oparg, TruffleString[] localNames, Node[] localNodes, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        TruffleString importName = localNames[oparg];
        Object from = virtualFrame.getObject(stackTop);
        ImportFromNode importFromNode = this.insertChildNode(localNodes, bci, UNCACHED_IMPORT_FROM, ImportFromNodeGen.class, NODE_IMPORT_FROM, useCachedNodes);
        Object imported = importFromNode.execute((Frame)virtualFrame, from, importName);
        virtualFrame.setObject(++stackTop, imported);
        return stackTop;
    }

    @HostCompilerDirectives.InliningCutoff
    private int bytecodeImportStar(VirtualFrame virtualFrame, int initialStackTop, int bci, int oparg, TruffleString[] localNames, Node[] localNodes, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        TruffleString importName = localNames[oparg];
        int level = (Integer)virtualFrame.getObject(stackTop);
        virtualFrame.clear(stackTop--);
        ImportStarNode importStarNode = this.insertChildNode(localNodes, bci, UNCACHED_IMPORT_STAR, ImportStarNodeGen.class, NODE_IMPORT_STAR, useCachedNodes);
        importStarNode.execute(virtualFrame, importName, level);
        return stackTop;
    }

    @ExplodeLoop
    private void initCellVars(Frame localFrame) {
        for (int i = 0; i < this.cellvars.length; ++i) {
            this.initCell(localFrame, i);
        }
    }

    private void initCell(Frame localFrame, int i) {
        PCell cell = new PCell(this.cellEffectivelyFinalAssumptions[i]);
        localFrame.setObject(this.celloffset + i, (Object)cell);
        if (this.cell2arg != null && this.cell2arg[i] != -1) {
            int idx = this.cell2arg[i];
            if (CompilerDirectives.inCompiledCode()) {
                cell.setRef(localFrame.getValue(idx));
            } else {
                cell.setRef(localFrame.getObject(idx));
            }
            localFrame.setObject(idx, null);
        }
    }

    @ExplodeLoop
    private void initFreeVars(Frame localFrame, Object[] originalArgs) {
        if (this.freevars.length > 0) {
            PCell[] closure = PArguments.getClosure(originalArgs);
            for (int i = 0; i < this.freevars.length; ++i) {
                localFrame.setObject(this.freeoffset + i, (Object)closure[i]);
            }
        }
    }

    @ExplodeLoop
    private static <T> void moveFromStack(VirtualFrame virtualFrame, int start, int stop, T[] target) {
        CompilerAsserts.partialEvaluationConstant((int)start);
        CompilerAsserts.partialEvaluationConstant((int)stop);
        int j = 0;
        int i = start;
        while (i < stop) {
            target[j] = virtualFrame.getObject(i);
            virtualFrame.clear(i);
            ++i;
            ++j;
        }
    }

    @ExplodeLoop
    private static ObjectHashMap moveFromStackToSetHashMap(VirtualFrame virtualFrame, int start, int stop, ObjHashMapPutNode putNode) {
        CompilerAsserts.partialEvaluationConstant((int)start);
        CompilerAsserts.partialEvaluationConstant((int)stop);
        ObjectHashMap result = new ObjectHashMap(stop - start);
        for (int i = start; i < stop; ++i) {
            putNode.execute(virtualFrame, result, virtualFrame.getObject(i), PNone.NONE);
            virtualFrame.clear(i);
        }
        return result;
    }

    @ExplodeLoop
    private static ObjectHashMap moveFromStackToDictHashMap(VirtualFrame virtualFrame, int start, int stop, ObjHashMapPutNode putNode) {
        CompilerAsserts.partialEvaluationConstant((int)start);
        CompilerAsserts.partialEvaluationConstant((int)stop);
        ObjectHashMap result = new ObjectHashMap((stop - start) / 2);
        int i = start;
        while (i + 1 < stop) {
            putNode.execute(virtualFrame, result, virtualFrame.getObject(i), virtualFrame.getObject(i + 1));
            virtualFrame.clear(i);
            virtualFrame.clear(i + 1);
            i += 2;
        }
        return result;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCollectionFromStack(VirtualFrame virtualFrame, int type, int count, int oldStackTop, Node[] localNodes, int nodeIndex, boolean useCachedNodes) {
        int stackTop = oldStackTop;
        Object res = null;
        switch (type) {
            case 32: {
                SequenceFromStackNode.ListFromStackNode storageFromStackNode = this.insertChildNodeInt(localNodes, nodeIndex, SequenceFromStackNodeFactory.ListFromStackNodeGen.class, LIST_FROM_STACK_NODE, count);
                SequenceStorage store = storageFromStackNode.execute((Frame)virtualFrame, stackTop - count + 1, stackTop + 1);
                res = PFactory.createList(this.getLanguage(), store, storageFromStackNode);
                break;
            }
            case 64: {
                SequenceFromStackNode.TupleFromStackNode storageFromStackNode = this.insertChildNodeInt(localNodes, nodeIndex, SequenceFromStackNodeFactory.TupleFromStackNodeGen.class, TUPLE_FROM_STACK_NODE, count);
                SequenceStorage store = storageFromStackNode.execute((Frame)virtualFrame, stackTop - count + 1, stackTop + 1);
                res = PFactory.createTuple(this.getLanguage(), store);
                break;
            }
            case 96: {
                ObjHashMapPutNode putNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_OBJ_HASHMAP_PUT, PBytecodeRootNodeFactory.ObjHashMapPutNodeGen.class, NODE_OBJ_HASHMAP_PUT, useCachedNodes);
                ObjectHashMap storage = PBytecodeRootNode.moveFromStackToSetHashMap(virtualFrame, stackTop - count + 1, stackTop + 1, putNode);
                res = PFactory.createSet(this.getLanguage(), new EconomicMapStorage(storage, false));
                break;
            }
            case 128: {
                ObjHashMapPutNode putNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_OBJ_HASHMAP_PUT, PBytecodeRootNodeFactory.ObjHashMapPutNodeGen.class, NODE_OBJ_HASHMAP_PUT, useCachedNodes);
                assert (count % 2 == 0);
                ObjectHashMap storage = PBytecodeRootNode.moveFromStackToDictHashMap(virtualFrame, stackTop - count + 1, stackTop + 1, putNode);
                res = PFactory.createDict(this.getLanguage(), new EconomicMapStorage(storage, false));
                break;
            }
            case 160: {
                PKeyword[] kwds = new PKeyword[count];
                PBytecodeRootNode.moveFromStack(virtualFrame, stackTop - count + 1, stackTop + 1, kwds);
                res = kwds;
                break;
            }
            case 192: {
                Object[] objs = new Object[count];
                PBytecodeRootNode.moveFromStack(virtualFrame, stackTop - count + 1, stackTop + 1, objs);
                res = objs;
                break;
            }
        }
        stackTop -= count;
        virtualFrame.setObject(++stackTop, res);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeCollectionFromCollection(VirtualFrame virtualFrame, int type, int stackTop, Node[] localNodes, int nodeIndex, boolean useCachedNodes) {
        Object sourceCollection = virtualFrame.getObject(stackTop);
        virtualFrame.setObject(stackTop, switch (type) {
            case 32 -> {
                ListNodes.ConstructListNode constructNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_CONSTRUCT_LIST, ListNodesFactory.ConstructListNodeGen.class, NODE_CONSTRUCT_LIST, useCachedNodes);
                yield constructNode.execute((Frame)virtualFrame, sourceCollection);
            }
            case 64 -> {
                TupleNodes.ConstructTupleNode constructNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_CONSTRUCT_TUPLE, TupleNodesFactory.ConstructTupleNodeGen.class, NODE_CONSTRUCT_TUPLE, useCachedNodes);
                yield constructNode.execute((Frame)virtualFrame, sourceCollection);
            }
            case 96 -> {
                SetNodes.ConstructSetNode constructNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_CONSTRUCT_SET, SetNodesFactory.ConstructSetNodeGen.class, NODE_CONSTRUCT_SET, useCachedNodes);
                yield constructNode.execute((Frame)virtualFrame, sourceCollection);
            }
            case 128 -> {
                HashingStorage.InitNode initNode = this.insertChildNode(localNodes, nodeIndex, HashingStorageFactory.InitNodeGen.class, NODE_HASHING_STORAGE_INIT);
                HashingStorage storage = initNode.execute(virtualFrame, sourceCollection, PKeyword.EMPTY_KEYWORDS);
                yield PFactory.createDict(this.getLanguage(), storage);
            }
            case 192 -> {
                ExecutePositionalStarargsNode executeStarargsNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_EXECUTE_STARARGS, ExecutePositionalStarargsNodeGen.class, NODE_EXECUTE_STARARGS, useCachedNodes);
                yield executeStarargsNode.executeWith((Frame)virtualFrame, sourceCollection);
            }
            case 160 -> {
                KeywordsNode keywordsNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_KEYWORDS, KeywordsNodeGen.class, NODE_KEYWORDS, useCachedNodes);
                yield keywordsNode.execute((Frame)virtualFrame, sourceCollection, stackTop);
            }
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Unexpected collection type");
        });
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeCollectionAddCollection(VirtualFrame virtualFrame, int type, int initialStackTop, Node[] localNodes, int nodeIndex, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        PKeyword[] collection1 = virtualFrame.getObject(stackTop - 1);
        Object collection2 = virtualFrame.getObject(stackTop);
        Object[] result = switch (type) {
            case 32 -> {
                ListBuiltins.ListExtendNode extendNode = this.insertChildNode(localNodes, nodeIndex, ListBuiltinsFactory.ListExtendNodeFactory.ListExtendNodeGen.class, NODE_LIST_EXTEND);
                extendNode.execute(virtualFrame, (PList)collection1, collection2);
                yield collection1;
            }
            case 96 -> {
                SetBuiltins.UpdateSingleNode updateNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_SET_UPDATE, SetBuiltinsFactory.UpdateSingleNodeGen.class, NODE_SET_UPDATE, useCachedNodes);
                PSet set = (PSet)collection1;
                updateNode.execute(virtualFrame, set, collection2);
                yield set;
            }
            case 128 -> {
                DictNodes.UpdateNode updateNode = this.insertChildNode(localNodes, nodeIndex, DictNodesFactory.UpdateNodeGen.class, NODE_DICT_UPDATE);
                updateNode.execute((Frame)virtualFrame, (PDict)collection1, collection2);
                yield collection1;
            }
            case 192 -> {
                Object[] array1 = collection1;
                ExecutePositionalStarargsNode executeStarargsNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_EXECUTE_STARARGS, ExecutePositionalStarargsNodeGen.class, NODE_EXECUTE_STARARGS, useCachedNodes);
                Object[] array2 = executeStarargsNode.executeWith((Frame)virtualFrame, collection2);
                Object[] combined = new Object[array1.length + array2.length];
                System.arraycopy(array1, 0, combined, 0, array1.length);
                System.arraycopy(array2, 0, combined, array1.length, array2.length);
                yield combined;
            }
            case 160 -> {
                PKeyword[] array1 = collection1;
                PKeyword[] array2 = (PKeyword[])collection2;
                PKeyword[] combined = new PKeyword[array1.length + array2.length];
                System.arraycopy(array1, 0, combined, 0, array1.length);
                System.arraycopy(array2, 0, combined, array1.length, array2.length);
                yield combined;
            }
            default -> {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_TYPE_FOR_S, "COLLECTION_ADD_COLLECTION");
            }
        };
        virtualFrame.clear(stackTop--);
        virtualFrame.setObject(stackTop, (Object)result);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeAddToCollection(VirtualFrame virtualFrame, int initialStackTop, int nodeIndex, Node[] localNodes, int depth, int type, boolean useCachedNodes) {
        int stackTop = initialStackTop;
        Object collection = virtualFrame.getObject(stackTop - depth);
        Object item = virtualFrame.getObject(stackTop);
        switch (type) {
            case 32: {
                ListNodes.AppendNode appendNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_LIST_APPEND, ListNodesFactory.AppendNodeGen.class, NODE_LIST_APPEND, useCachedNodes);
                appendNode.execute((PList)collection, item);
                break;
            }
            case 96: {
                SetNodes.AddNode addNode = this.insertChildNode(localNodes, nodeIndex, UNCACHED_SET_ADD, SetNodesFactory.AddNodeGen.class, NODE_SET_ADD, useCachedNodes);
                addNode.execute((Frame)virtualFrame, (PSet)collection, item);
                break;
            }
            case 128: {
                Object key = virtualFrame.getObject(stackTop - 1);
                HashingCollectionNodes.SetItemNode setItem = this.insertChildNode(localNodes, nodeIndex, UNCACHED_SET_ITEM, HashingCollectionNodesFactory.SetItemNodeGen.class, NODE_SET_ITEM, useCachedNodes);
                setItem.executeCached((Frame)virtualFrame, (PDict)collection, key, item);
                virtualFrame.clear(stackTop--);
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_TYPE_FOR_S, "ADD_TO_COLLECTION");
            }
        }
        virtualFrame.clear(stackTop--);
        return stackTop;
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeTupleFromList(VirtualFrame virtualFrame, int stackTop) {
        PList list = (PList)virtualFrame.getObject(stackTop);
        PTuple result = PFactory.createTuple(this.getLanguage(), list.getSequenceStorage());
        virtualFrame.setObject(stackTop, (Object)result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private void bytecodeFrozensetFromList(VirtualFrame virtualFrame, int stackTop, int nodeIndex, Node[] localNodes) {
        PList list = (PList)virtualFrame.getObject(stackTop);
        HashingStorageFromListSequenceStorageNode node = this.insertChildNode(localNodes, nodeIndex, HashingStorageFromListSequenceStorageNodeGen.class, NODE_HASHING_STORAGE_FROM_SEQUENCE);
        PFrozenSet result = PFactory.createFrozenSet(this.getLanguage(), node.execute((Frame)virtualFrame, list.getSequenceStorage()));
        virtualFrame.setObject(stackTop, (Object)result);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeUnpackSequence(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int count, boolean useCachedNodes) {
        UnpackSequenceNode unpackNode = this.insertChildNode(localNodes, bci, UNCACHED_UNPACK_SEQUENCE, UnpackSequenceNodeGen.class, NODE_UNPACK_SEQUENCE, useCachedNodes);
        Object collection = virtualFrame.getObject(stackTop);
        return unpackNode.execute((Frame)virtualFrame, stackTop - 1, collection, count);
    }

    @HostCompilerDirectives.BytecodeInterpreterSwitch
    private int bytecodeUnpackEx(VirtualFrame virtualFrame, int stackTop, int bci, Node[] localNodes, int countBefore, int countAfter, boolean useCachedNodes) {
        UnpackExNode unpackNode = this.insertChildNode(localNodes, bci, UNCACHED_UNPACK_EX, UnpackExNodeGen.class, NODE_UNPACK_EX, useCachedNodes);
        Object collection = virtualFrame.getObject(stackTop);
        return unpackNode.execute((Frame)virtualFrame, stackTop - 1, collection, countBefore, countAfter);
    }

    @HostCompilerDirectives.InliningCutoff
    @ExplodeLoop
    private int findHandler(int bci) {
        CompilerAsserts.partialEvaluationConstant((int)bci);
        for (int i = 0; i < this.exceptionHandlerRanges.length && bci >= this.exceptionHandlerRanges[i]; i += 4) {
            if (bci >= this.exceptionHandlerRanges[i + 1]) continue;
            return i + 2;
        }
        return -1;
    }

    @HostCompilerDirectives.InliningCutoff
    @ExplodeLoop
    private static int unwindBlock(VirtualFrame virtualFrame, int stackTop, int stackTopBeforeBlock) {
        CompilerAsserts.partialEvaluationConstant((int)stackTop);
        CompilerAsserts.partialEvaluationConstant((int)stackTopBeforeBlock);
        for (int i = stackTop; i > stackTopBeforeBlock; --i) {
            virtualFrame.clear(i);
        }
        return stackTopBeforeBlock;
    }

    public PCell readClassCell(Frame frame) {
        if (this.classcellIndex < 0) {
            return null;
        }
        return (PCell)frame.getObject(this.classcellIndex);
    }

    public Object readSelf(Frame frame) {
        if (this.selfIndex < 0) {
            return null;
        }
        if (this.selfIndex == 0) {
            return frame.getObject(0);
        }
        PCell selfCell = (PCell)frame.getObject(this.selfIndex);
        return selfCell.getRef();
    }

    public int bciToLine(int bci) {
        return this.co.bciToLine(bci);
    }

    public int lineToBci(int line) {
        return this.co.lineToBci(line);
    }

    public int getFirstLineno() {
        return this.co.startLine;
    }

    public boolean frameIsVisibleToPython() {
        return !this.internal;
    }

    public SourceSection getSourceSection() {
        if (this.sourceSection != null) {
            return this.sourceSection;
        }
        if (!this.source.hasCharacters()) {
            this.sourceSection = this.source.createUnavailableSection();
            return this.sourceSection;
        }
        this.sourceSection = this.co.getSourceSection(this.source);
        return this.sourceSection;
    }

    public int bciToLasti(int bci) {
        if (bci <= 0) {
            return bci;
        }
        byte[] bytecode = this.co.code;
        int number = 0;
        int i = 0;
        while (i < bytecode.length) {
            if (i >= bci) {
                return number;
            }
            i += OpCodes.fromOpCode(bytecode[i]).length();
            number += 2;
        }
        return -1;
    }

    public int lastiToBci(int lasti) {
        int bci = 0;
        for (int i = 0; i < lasti && bci < this.co.code.length; bci += OpCodes.fromOpCode(this.co.code[bci]).length(), i += 2) {
        }
        return bci;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public boolean setsUpCalleeContext() {
        return true;
    }

    @Override
    protected byte[] extractCode() {
        return MarshalModuleBuiltins.serializeCodeUnit((Node)this, PythonContext.get((Node)this), this.co);
    }

    protected boolean isCloneUninitializedSupported() {
        return true;
    }

    protected RootNode cloneUninitialized() {
        return new PBytecodeRootNode(this.getLanguage(), this.getFrameDescriptor(), this.getSignature(), this.co, this.source, this.parserCallbacks);
    }

    public void triggerDeferredDeprecationWarnings() {
        if (this.parserCallbacks != null) {
            this.parserCallbacks.triggerDeprecationWarnings();
        }
    }

    private void bytecodePopAndJumpIfFalse(VirtualFrame virtualFrame, int bci, int stackTop) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.bytecode[bci] = virtualFrame.isBoolean(stackTop) ? -84 : -85;
    }

    private void bytecodePopAndJumpIfTrue(VirtualFrame virtualFrame, int bci, int stackTop) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.bytecode[bci] = virtualFrame.isBoolean(stackTop) ? -82 : -83;
    }

    public boolean hasSelf() {
        return this.selfIndex >= 0;
    }

    @FunctionalInterface
    private static interface IntNodeFunction<T extends Node> {
        public T apply(int var1);
    }

    @FunctionalInterface
    private static interface NodeSupplier<T> {
        public T get();
    }

    private static final class InterpreterContinuation {
        public final int bci;
        public final int stackTop;

        private InterpreterContinuation(int bci, int stackTop) {
            this.bci = bci;
            this.stackTop = stackTop;
        }
    }

    @CompilerDirectives.ValueType
    private static final class MutableLoopData {
        private InstrumentationData instrumentationData = null;
        int loopCount;
        boolean fetchedException;
        AbstractTruffleException outerException;
        AbstractTruffleException localException;

        private MutableLoopData() {
        }

        public int getPastBci() {
            return this.getTraceData().pastBci;
        }

        public int setPastBci(int pastBci) {
            this.getTraceData().pastBci = pastBci;
            return this.getTraceData().pastBci;
        }

        public int getPastLine() {
            return this.getTraceData().pastLine;
        }

        public int setPastLine(int pastLine) {
            this.getTraceData().pastLine = pastLine;
            return this.getTraceData().pastLine;
        }

        public int getReturnLine() {
            return this.getTraceData().returnLine;
        }

        public int setReturnLine(int returnLine) {
            this.getTraceData().returnLine = returnLine;
            return this.getTraceData().returnLine;
        }

        public boolean isReturnCalled() {
            return this.getTraceData().returnCalled;
        }

        public int getJumpBci() {
            return this.getTraceData().jumpBci;
        }

        public void setJumpBci(int target) {
            this.getTraceData().jumpBci = target;
        }

        public void setReturnCalled(boolean value) {
            this.getTraceData().returnCalled = value;
        }

        public boolean isExceptionNotified() {
            return this.getTraceData().exceptionNotified;
        }

        public void setExceptionNotified(boolean value) {
            this.getTraceData().exceptionNotified = value;
        }

        public PFrame getPyFrame() {
            return this.getTraceData().pyFrame;
        }

        public PFrame setPyFrame(PFrame pyFrame) {
            this.getTraceData().pyFrame = pyFrame;
            return this.getTraceData().pyFrame;
        }

        private InstrumentationData getTraceData() {
            if (this.instrumentationData == null) {
                this.instrumentationData = new InstrumentationData();
            }
            return this.instrumentationData;
        }

        public PythonContext.PythonThreadState getThreadState(PBytecodeRootNode node) {
            if (this.getTraceData().threadState == null) {
                PythonContext context = PythonContext.get((Node)node);
                this.getTraceData().threadState = context.getThreadState(node.getLanguage());
                return this.getTraceData().threadState;
            }
            return this.getTraceData().threadState;
        }

        private static final class InstrumentationData {
            private int pastBci = 0;
            private int pastLine = -1;
            private int returnLine = -1;
            private PFrame pyFrame = null;
            private boolean exceptionNotified;
            private boolean returnCalled;
            private int jumpBci;
            private PythonContext.PythonThreadState threadState = null;

            InstrumentationData() {
            }
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class ObjHashMapPutNode
    extends Node {
        ObjHashMapPutNode() {
        }

        public abstract void execute(VirtualFrame var1, ObjectHashMap var2, Object var3, Object var4);

        @Specialization
        static void doIt(VirtualFrame frame, ObjectHashMap map, Object key, Object value, @Bind Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.PutNode putNode) {
            long hash = hashNode.execute((Frame)frame, inliningTarget, key);
            putNode.put((Frame)frame, inliningTarget, map, key, hash, value);
        }
    }
}

