/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.CodecsTruffleModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.IncrementalNewlineDecoderBuiltins;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.modules.io.PNLDecoder;
import com.oracle.graal.python.builtins.modules.io.PTextIO;
import com.oracle.graal.python.builtins.modules.io.PTextIOBase;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;

public abstract class TextIOWrapperNodes {
    public static final TruffleString T_CODECS_OPEN = PythonUtils.tsLiteral("codecs.open()");

    protected static void validateNewline(TruffleString str, Node inliningTarget, PRaiseNode raise, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        int c;
        int len = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
        int n = c = len == 0 ? 0 : codePointAtIndexNode.execute((AbstractTruffleString)str, 0, PythonUtils.TS_ENCODING);
        if (!(c == 0 || c == 10 && len == 1 || c == 13 && len == 1 || c == 13 && len == 2 && codePointAtIndexNode.execute((AbstractTruffleString)str, 1, PythonUtils.TS_ENCODING) == 10)) {
            throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ILLEGAL_NEWLINE_VALUE_S, str);
        }
    }

    protected static void setNewline(PTextIO self, TruffleString newline, TruffleString.EqualNode equalNode) {
        boolean empty = true;
        if (newline == null) {
            self.setReadNewline(null);
        } else {
            self.setReadNewline(newline);
            empty = newline.isEmpty();
        }
        self.setReadUniversal(newline == null || empty);
        self.setReadTranslate(newline == null);
        self.setWriteTranslate(newline == null || !empty);
        if (!self.isReadUniversal()) {
            if (equalNode.execute((AbstractTruffleString)StringLiterals.T_NEWLINE, (AbstractTruffleString)self.getReadNewline(), PythonUtils.TS_ENCODING)) {
                self.setWriteNewline(null);
            } else {
                self.setWriteNewline(self.getReadNewline());
            }
        } else if (PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32) {
            self.setWriteNewline(StringLiterals.T_CRLF);
        } else {
            self.setWriteNewline(null);
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class TextIOWrapperInitNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, Node var2, PTextIO var3, Object var4, Object var5, TruffleString var6, Object var7, boolean var8, boolean var9);

        @Specialization
        static void init(VirtualFrame frame, Node inliningTarget, PTextIO self, Object buffer, Object encodingArg, TruffleString errors, Object newlineArg, boolean lineBuffering, boolean writeThrough, @Cached(inline=false) CodecsTruffleModuleBuiltins.GetEncodingNode getEncodingNode, @Cached(inline=false) CodecsTruffleModuleBuiltins.LookupTextEncoding lookupTextEncoding, @Cached SetEncoderNode setEncoderNode, @Cached SetDecoderNode setDecoderNode, @Cached FixEncoderStateNode fixEncoderStateNode, @Cached PyObjectCallMethodObjArgs callMethodSeekable, @Cached PyObjectLookupAttr lookup, @Cached PyObjectIsTrueNode isTrueNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached(inline=false) TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached(inline=false) TruffleString.EqualNode equalNode, @Cached(inline=false) WarningsModuleBuiltins.WarnNode warnNode, @Cached PRaiseNode raiseNode) {
            TruffleString newline;
            self.setOK(false);
            self.setDetached(false);
            TruffleString encoding = encodingArg == PNone.NONE ? null : (TruffleString)encodingArg;
            TruffleString truffleString = newline = newlineArg == PNone.NONE ? null : (TruffleString)newlineArg;
            if (encoding == null) {
                if (PythonContext.get(inliningTarget).getOption(PythonOptions.WarnDefaultEncodingFlag).booleanValue()) {
                    warnNode.warnEx((Frame)frame, (Object)PythonBuiltinClassType.EncodingWarning, ErrorMessages.WARN_ENCODING_ARGUMENT_NOT_SPECIFIED, 1);
                }
            } else if (equalNode.execute((AbstractTruffleString)BuiltinNames.T_LOCALE, (AbstractTruffleString)encoding, PythonUtils.TS_ENCODING)) {
                encoding = null;
            } else if (indexOfCodePointNode.execute((AbstractTruffleString)encoding, 0, 0, codePointLengthNode.execute((AbstractTruffleString)encoding, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) != -1) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
            }
            if (newline != null) {
                if (indexOfCodePointNode.execute((AbstractTruffleString)newline, 0, 0, codePointLengthNode.execute((AbstractTruffleString)newline, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING) != -1) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
                }
                TextIOWrapperNodes.validateNewline(newline, inliningTarget, raiseNode, codePointLengthNode, codePointAtIndexNode);
            }
            self.clearAll();
            if (encoding == null && !self.hasEncoding()) {
                try {
                    self.setEncoding(getEncodingNode.execute((Frame)frame));
                }
                catch (Exception e) {
                    self.setEncoding(BuiltinNames.T_ASCII);
                }
            }
            if (self.hasEncoding()) {
                encoding = self.getEncoding();
            } else if (encoding != null) {
                self.setEncoding(encoding);
            } else {
                throw raiseNode.raise(inliningTarget, PythonErrorType.OSError, ErrorMessages.COULD_NOT_DETERMINE_DEFAULT_ENCODING);
            }
            Object codecInfo = lookupTextEncoding.execute((Frame)frame, encoding, T_CODECS_OPEN);
            self.setErrors(errors);
            self.setChunkSize(8192);
            self.setLineBuffering(lineBuffering);
            self.setWriteThrough(writeThrough);
            TextIOWrapperNodes.setNewline(self, newline, equalNode);
            self.setBuffer(buffer);
            setDecoderNode.execute((Frame)frame, inliningTarget, self, codecInfo, errors);
            setEncoderNode.execute((Frame)frame, inliningTarget, self, codecInfo, errors);
            if (buffer instanceof PBuffered && ((PBuffered)buffer).isFastClosedChecks()) {
                PFileIO f = ((PBuffered)buffer).getFileIORaw();
                self.setFileIO(f);
            }
            Object res = callMethodSeekable.execute((Frame)frame, inliningTarget, buffer, IONodes.T_SEEKABLE, new Object[0]);
            self.setTelling(isTrueNode.execute((Frame)frame, res));
            self.setSeekable(self.isTelling());
            self.setHasRead1(lookup.execute((Frame)frame, inliningTarget, buffer, IONodes.T_READ1) != PNone.NO_VALUE);
            self.setEncodingStartOfStream(false);
            fixEncoderStateNode.execute(frame, inliningTarget, self);
            self.setOK(true);
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    protected static abstract class SetEncoderNode
    extends PNodeWithContext {
        protected SetEncoderNode() {
        }

        public abstract void execute(Frame var1, Node var2, PTextIO var3, Object var4, TruffleString var5);

        @Specialization
        static void setEncoder(VirtualFrame frame, Node inliningTarget, PTextIO self, Object codecInfo, TruffleString errors, @Cached(inline=false) CodecsTruffleModuleBuiltins.MakeIncrementalcodecNode makeIncrementalcodecNode, @Cached InlinedConditionProfile isTrueProfile, @Cached PyObjectIsTrueNode isTrueNode, @Cached PyObjectCallMethodObjArgs callMethodWritable) {
            Object res = callMethodWritable.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_WRITABLE, new Object[0]);
            if (isTrueProfile.profile(inliningTarget, !isTrueNode.execute((Frame)frame, res))) {
                return;
            }
            self.setEncoder(null);
            self.setEncodefunc(null);
            self.setEncoder(makeIncrementalcodecNode.execute(frame, codecInfo, errors, CodecsTruffleModuleBuiltins.T_INCREMENTALENCODER));
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    protected static abstract class SetDecoderNode
    extends PNodeWithContext {
        protected SetDecoderNode() {
        }

        public abstract void execute(Frame var1, Node var2, PTextIO var3, Object var4, TruffleString var5);

        @Specialization
        static void setDecoder(VirtualFrame frame, Node inliningTarget, PTextIO self, Object codecInfo, TruffleString errors, @Cached(inline=false) CodecsTruffleModuleBuiltins.MakeIncrementalcodecNode makeIncrementalcodecNode, @Cached InlinedConditionProfile isTrueProfile, @Cached PyObjectCallMethodObjArgs callMethodReadable, @Cached PyObjectIsTrueNode isTrueNode) {
            Object res = callMethodReadable.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_READABLE, new Object[0]);
            if (isTrueProfile.profile(inliningTarget, !isTrueNode.execute((Frame)frame, res))) {
                return;
            }
            Object decoder = makeIncrementalcodecNode.execute(frame, codecInfo, errors, CodecsTruffleModuleBuiltins.T_INCREMENTALDECODER);
            if (self.isReadUniversal()) {
                PNLDecoder incDecoder = PFactory.createNLDecoder(PythonLanguage.get(inliningTarget));
                IncrementalNewlineDecoderBuiltins.InitNode.internalInit(incDecoder, decoder, self.isReadTranslate());
                self.setDecoder(incDecoder);
            } else {
                self.setDecoder(decoder);
            }
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    protected static abstract class FixEncoderStateNode
    extends PNodeWithContext {
        protected FixEncoderStateNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PTextIO var3);

        @Specialization(guards={"!self.isSeekable() || !self.hasEncoder()"})
        void nothing(PTextIO self) {
        }

        @Specialization(guards={"self.isSeekable()", "self.hasEncoder()"})
        static void fixEncoderState(VirtualFrame frame, Node inliningTarget, PTextIO self, @Cached PyObjectCallMethodObjArgs callMethodTell, @Cached PyObjectCallMethodObjArgs callMethodSetState, @Cached PyObjectRichCompareBool eqNode) {
            self.setEncodingStartOfStream(true);
            Object cookieObj = callMethodTell.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_TELL, new Object[0]);
            if (!eqNode.executeEq((Frame)frame, inliningTarget, cookieObj, 0)) {
                self.setEncodingStartOfStream(false);
                callMethodSetState.execute((Frame)frame, inliningTarget, self.getEncoder(), IONodes.T_SETSTATE, 0);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class EncoderResetNode
    extends Node {
        protected EncoderResetNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PTextIO var3, boolean var4);

        @Specialization(guards={"startOfStream"})
        static void encoderResetStart(VirtualFrame frame, Node inliningTarget, PTextIO self, boolean startOfStream, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodReset) {
            callMethodReset.execute((Frame)frame, inliningTarget, self.getEncoder(), IONodes.T_RESET, new Object[0]);
            self.setEncodingStartOfStream(true);
        }

        @Specialization(guards={"!startOfStream"})
        static void encoderResetNotStart(VirtualFrame frame, Node inliningTarget, PTextIO self, boolean startOfStream, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodSetState) {
            callMethodSetState.execute((Frame)frame, inliningTarget, self.getEncoder(), IONodes.T_SETSTATE, 0);
            self.setEncodingStartOfStream(false);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class DecoderResetNode
    extends Node {
        protected DecoderResetNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PTextIO var3);

        @Specialization(guards={"!self.hasDecoder()"})
        static void nothing(PTextIO self) {
        }

        @Specialization(guards={"self.hasDecoder()"})
        static void reset(VirtualFrame frame, Node inliningTarget, PTextIO self, @Cached PyObjectCallMethodObjArgs callMethod) {
            callMethod.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_RESET, new Object[0]);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class DecoderSetStateNode
    extends Node {
        protected DecoderSetStateNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PTextIO var3, PTextIO.CookieType var4);

        @Specialization(guards={"!self.hasDecoder()"})
        static void nothing(PTextIO self, PTextIO.CookieType cookie) {
        }

        protected static boolean isAtInit(PTextIO.CookieType cookie) {
            return cookie.startPos == 0L && cookie.decFlags == 0;
        }

        @Specialization(guards={"self.hasDecoder()", "isAtInit(cookie)"})
        static void atInit(VirtualFrame frame, Node inliningTarget, PTextIO self, PTextIO.CookieType cookie, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodReset) {
            callMethodReset.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_RESET, new Object[0]);
        }

        @Specialization(guards={"self.hasDecoder()", "!isAtInit(cookie)"})
        static void decoderSetstate(VirtualFrame frame, Node inliningTarget, PTextIO self, PTextIO.CookieType cookie, @Bind PythonLanguage language, @Cached.Exclusive @Cached PyObjectCallMethodObjArgs callMethodSetState) {
            PTuple tuple = PFactory.createTuple(language, new Object[]{PFactory.createEmptyBytes(language), cookie.decFlags});
            callMethodSetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_SETSTATE, tuple);
        }
    }

    @GenerateInline(value=false)
    protected static abstract class DecodeNode
    extends Node {
        protected DecodeNode() {
        }

        public abstract TruffleString execute(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        static TruffleString decodeGeneric(VirtualFrame frame, Object decoder, Object o, boolean eof, @Bind Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode castNode, @Cached PyObjectCallMethodObjArgs callMethodDecode) {
            Object decoded = callMethodDecode.execute((Frame)frame, inliningTarget, decoder, SpecialMethodNames.T_DECODE, o, eof);
            return castNode.cast(inliningTarget, decoded, ErrorMessages.DECODER_SHOULD_RETURN_A_STRING_RESULT_NOT_P, decoded);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class ReadChunkNode
    extends Node {
        protected ReadChunkNode() {
        }

        public abstract boolean execute(VirtualFrame var1, Node var2, PTextIO var3, int var4);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.hasDecoder()"})
        static boolean readChunk(VirtualFrame frame, Node inliningTarget, PTextIO self, int hint, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached SequenceNodes.GetObjectArrayNode getArray, @Cached(inline=false) DecodeNode decodeNode, @Cached PyObjectCallMethodObjArgs callMethodGetState, @Cached PyObjectCallMethodObjArgs callMethodRead, @Cached PyNumberAsSizeNode asSizeNode, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @CachedLibrary(limit="3") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode) {
            Object inputChunkBuf;
            int sizeHint;
            PBytes decBuffer = null;
            Object decFlags = null;
            if (self.isTelling()) {
                Object state = callMethodGetState.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_GETSTATE, new Object[0]);
                if (!(state instanceof PTuple)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ILLEGAL_DECODER_STATE);
                }
                Object[] array = getArray.execute(inliningTarget, state);
                if (array.length < 2) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ILLEGAL_DECODER_STATE);
                }
                if (!(array[0] instanceof PBytes)) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.ILLEGAL_DECODER_STATE_THE_FIRST, array[0]);
                }
                decBuffer = (PBytes)array[0];
                decFlags = array[1];
            }
            if ((sizeHint = hint) > 0) {
                sizeHint = (int)(Math.max(self.getB2cratio(), 1.0) * (double)sizeHint);
            }
            int chunkSize = Math.max(self.getChunkSize(), sizeHint);
            Object inputChunk = self.isHasRead1() ? callMethodRead.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_READ1, chunkSize) : callMethodRead.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_READ, chunkSize);
            try {
                inputChunkBuf = bufferAcquireLib.acquireReadonly(inputChunk, frame, indirectCallData);
            }
            catch (PException e) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_SHOULD_HAVE_RETURNED_A_BYTES_LIKE_OBJECT_NOT_P, self.isHasRead1() ? IONodes.T_READ1 : IONodes.T_READ, inputChunk);
            }
            try {
                int nbytes = bufferLib.getBufferLength(inputChunkBuf);
                boolean eof = nbytes == 0;
                TruffleString decodedChars = decodeNode.execute(frame, self.getDecoder(), inputChunk, eof);
                self.clearDecodedChars();
                int nchars = self.setDecodedChars(decodedChars, codePointLengthNode);
                if (nchars > 0) {
                    self.setB2cratio((double)nbytes / (double)nchars);
                } else {
                    self.setB2cratio(0.0);
                }
                if (nchars > 0) {
                    eof = false;
                }
                if (self.isTelling()) {
                    int decBufferLen = bufferLib.getBufferLength(decBuffer);
                    byte[] nextInput = new byte[decBufferLen + nbytes];
                    bufferLib.readIntoByteArray(decBuffer, 0, nextInput, 0, decBufferLen);
                    bufferLib.readIntoByteArray(inputChunkBuf, 0, nextInput, decBufferLen, nbytes);
                    self.setSnapshotNextInput(nextInput);
                    self.setSnapshotDecFlags(asSizeNode.executeExact((Frame)frame, inliningTarget, decFlags));
                }
                boolean bl = !eof;
                return bl;
            }
            finally {
                bufferLib.release(inputChunkBuf, frame, indirectCallData);
            }
        }

        @Specialization(guards={"!self.hasDecoder()"})
        static boolean error(PTextIO self, int size_hint, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.IOUnsupportedOperation, ErrorMessages.NOT_READABLE);
        }
    }

    @GenerateInline(value=false)
    protected static abstract class ReadlineNode
    extends Node {
        protected ReadlineNode() {
        }

        public abstract TruffleString execute(VirtualFrame var1, PTextIO var2, int var3);

        @Specialization
        static TruffleString readline(VirtualFrame frame, PTextIO self, int limit, @Bind Node inliningTarget, @Cached ReadChunkNode readChunkNode, @Cached WriteFlushNode writeFlushNode, @Cached FindLineEndingNode findLineEndingNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleString.ConcatNode concatNode) {
            int start;
            int endpos;
            int offsetToBuffer;
            writeFlushNode.execute(frame, inliningTarget, self);
            int chunked = 0;
            TruffleString line = null;
            TruffleStringBuilder chunks = null;
            TruffleString remaining = null;
            int[] consumed = new int[1];
            while (true) {
                int lineLen;
                boolean res = true;
                while (!self.hasDecodedCharsAvailable() && (res = readChunkNode.execute(frame, inliningTarget, self, 0))) {
                }
                if (!res) {
                    self.clearDecodedChars();
                    self.clearSnapshot();
                    offsetToBuffer = 0;
                    endpos = 0;
                    start = 0;
                    break;
                }
                if (remaining == null) {
                    line = self.getDecodedChars();
                    start = self.getDecodedCharsUsed();
                    offsetToBuffer = 0;
                } else {
                    assert (self.getDecodedCharsUsed() == 0);
                    line = concatNode.execute(remaining, (AbstractTruffleString)self.getDecodedChars(), PythonUtils.TS_ENCODING, false);
                    start = 0;
                    offsetToBuffer = codePointLengthNode.execute(remaining, PythonUtils.TS_ENCODING);
                    remaining = null;
                }
                endpos = findLineEndingNode.execute(inliningTarget, self, line, start, consumed);
                if (endpos >= 0) {
                    if (limit < 0 || (endpos += start) - start + chunked < limit) break;
                    endpos = start + limit - chunked;
                    break;
                }
                endpos = consumed[0] + start;
                if (limit >= 0 && endpos - start + chunked >= limit) {
                    endpos = start + limit - chunked;
                    break;
                }
                if (endpos > start) {
                    if (chunks == null) {
                        chunks = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                    }
                    TruffleString s = substringNode.execute((AbstractTruffleString)line, start, endpos - start, PythonUtils.TS_ENCODING, true);
                    appendStringNode.execute(chunks, (AbstractTruffleString)s);
                    chunked += endpos - start;
                }
                if (endpos < (lineLen = codePointLengthNode.execute((AbstractTruffleString)line, PythonUtils.TS_ENCODING))) {
                    remaining = substringNode.execute((AbstractTruffleString)line, endpos, lineLen - endpos, PythonUtils.TS_ENCODING, true);
                }
                line = null;
                self.clearDecodedChars();
            }
            if (line != null) {
                self.incDecodedCharsUsed(endpos - offsetToBuffer - self.getDecodedCharsUsed());
                int lineLen = codePointLengthNode.execute((AbstractTruffleString)line, PythonUtils.TS_ENCODING);
                if (start > 0 || endpos < lineLen) {
                    line = substringNode.execute((AbstractTruffleString)line, start, endpos - start, PythonUtils.TS_ENCODING, remaining != null || chunks != null);
                }
            }
            if (remaining != null) {
                if (chunks == null) {
                    chunks = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                }
                appendStringNode.execute(chunks, remaining);
            }
            if (chunks != null) {
                if (line != null) {
                    appendStringNode.execute(chunks, (AbstractTruffleString)line);
                }
                line = toStringNode.execute(chunks);
            }
            return line == null ? StringLiterals.T_EMPTY_STRING : line;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FindLineEndingNode
    extends Node {
        public abstract int execute(Node var1, PTextIOBase var2, TruffleString var3, int var4, int[] var5);

        @Specialization(guards={"self.isReadTranslate()"})
        static int doTranslated(PTextIOBase self, TruffleString line, int start, int[] consumed, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached(inline=false) TruffleString.IndexOfCodePointNode indexOfCodePointNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)line, PythonUtils.TS_ENCODING);
            int pos = indexOfCodePointNode.execute((AbstractTruffleString)line, 10, start, len, PythonUtils.TS_ENCODING);
            if (pos < 0) {
                consumed[0] = len - start;
                return -1;
            }
            return pos - start + 1;
        }

        @Specialization(guards={"!self.isReadTranslate()", "self.isReadUniversal()"})
        static int doUniversal(PTextIOBase self, TruffleString line, int start, int[] consumed, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared @Cached(inline=false) TruffleString.IndexOfCodePointNode indexOfCodePointNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)line, PythonUtils.TS_ENCODING);
            int nlpos = indexOfCodePointNode.execute((AbstractTruffleString)line, 10, start, len, PythonUtils.TS_ENCODING);
            int crpos = indexOfCodePointNode.execute((AbstractTruffleString)line, 13, start, len, PythonUtils.TS_ENCODING);
            if (crpos < 0) {
                if (nlpos < 0) {
                    consumed[0] = len - start;
                    return -1;
                }
                return nlpos - start + 1;
            }
            if (nlpos < 0) {
                return crpos - start + 1;
            }
            if (nlpos < crpos) {
                return nlpos - start + 1;
            }
            if (nlpos == crpos + 1) {
                return nlpos - start + 1;
            }
            return crpos - start + 1;
        }

        @Specialization(guards={"!self.isReadTranslate()", "!self.isReadUniversal()"})
        static int doNonUniversal(PTextIOBase self, TruffleString line, int start, int[] consumed, @Cached.Shared @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.IndexOfStringNode indexOfStringNode, @Cached.Shared @Cached(inline=false) TruffleString.IndexOfCodePointNode indexOfCodePointNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)line, PythonUtils.TS_ENCODING);
            TruffleString readNl = self.getReadNewline();
            int nlLen = codePointLengthNode.execute((AbstractTruffleString)readNl, PythonUtils.TS_ENCODING);
            if (nlLen == 1) {
                int cp = codePointAtIndexNode.execute((AbstractTruffleString)readNl, 0, PythonUtils.TS_ENCODING);
                int pos = indexOfCodePointNode.execute((AbstractTruffleString)line, cp, start, len, PythonUtils.TS_ENCODING);
                if (pos >= 0) {
                    return pos - start + 1;
                }
                consumed[0] = len - start;
                return -1;
            }
            int pos = indexOfStringNode.execute((AbstractTruffleString)line, (AbstractTruffleString)readNl, start, len, PythonUtils.TS_ENCODING);
            if (pos >= 0) {
                return pos - start + nlLen;
            }
            int firstCp = codePointAtIndexNode.execute((AbstractTruffleString)readNl, 0, PythonUtils.TS_ENCODING);
            int i = len - (nlLen - 1);
            if (i < start) {
                i = start;
            }
            consumed[0] = (pos = indexOfCodePointNode.execute((AbstractTruffleString)line, firstCp, i, len, PythonUtils.TS_ENCODING)) < 0 ? len - start : pos - start;
            return -1;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class ChangeEncodingNode
    extends Node {
        protected ChangeEncodingNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PTextIO var3, Object var4, Object var5, boolean var6);

        protected static boolean isNothingTodo(Object encodingObj, Object errorsObj, boolean newline_changed) {
            return PGuards.isPNone(encodingObj) && PGuards.isPNone(errorsObj) && !newline_changed;
        }

        @Specialization(guards={"isNothingTodo(encodingObj, errorsObj, newline_changed)"})
        static void nothing(PTextIO self, Object encodingObj, Object errorsObj, boolean newline_changed) {
        }

        @Specialization(guards={"!isNothingTodo(encodingObj, errorsObj, newline_changed)"})
        static void changeEncoding(VirtualFrame frame, Node inliningTarget, PTextIO self, Object encodingObj, Object errorsObj, boolean newline_changed, @Cached IONodes.ToTruffleStringNode asString, @Cached(inline=false) CodecsTruffleModuleBuiltins.LookupTextEncoding lookupTextEncoding, @Cached SetDecoderNode setDecoderNode, @Cached SetEncoderNode setEncoderNode, @Cached FixEncoderStateNode fixEncoderStateNode) {
            TruffleString encoding;
            TruffleString truffleString = encoding = PGuards.isPNone(encodingObj) ? self.getEncoding() : asString.execute(inliningTarget, encodingObj);
            TruffleString errors = PGuards.isPNone(errorsObj) ? (PGuards.isPNone(encodingObj) ? self.getErrors() : StringLiterals.T_STRICT) : asString.execute(inliningTarget, errorsObj);
            Object codecInfo = lookupTextEncoding.execute((Frame)frame, encoding, T_CODECS_OPEN);
            setDecoderNode.execute((Frame)frame, inliningTarget, self, codecInfo, errors);
            setEncoderNode.execute((Frame)frame, inliningTarget, self, codecInfo, errors);
            self.setEncoding(encoding);
            self.setErrors(errors);
            fixEncoderStateNode.execute(frame, inliningTarget, self);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class WriteFlushNode
    extends Node {
        protected WriteFlushNode() {
        }

        public abstract void execute(VirtualFrame var1, Node var2, PTextIO var3);

        @Specialization(guards={"!self.hasPendingBytes()"})
        static void nothingTodo(PTextIO self) {
        }

        @Specialization(guards={"self.hasPendingBytes()"})
        static void writeflush(VirtualFrame frame, Node inliningTarget, PTextIO self, @Bind PythonLanguage language, @Cached PyObjectCallMethodObjArgs callMethod) {
            byte[] pending = self.getAndClearPendingBytes();
            PBytes b = PFactory.createBytes(language, pending);
            callMethod.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_WRITE, b);
        }
    }

    @GenerateInline(value=false)
    static abstract class CheckClosedNode
    extends Node {
        CheckClosedNode() {
        }

        public abstract void execute(VirtualFrame var1, PTextIO var2);

        @Specialization(guards={"self.isFileIO()", "!self.getFileIO().isClosed()"})
        static void ideal(PTextIO self) {
        }

        @Specialization(guards={"self.isFileIO()", "self.getFileIO().isClosed()"})
        static void error(PTextIO self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }

        @Specialization(guards={"!self.isFileIO()"})
        static void checkGeneric(VirtualFrame frame, PTextIO self, @Bind Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached PyObjectIsTrueNode isTrueNode, @Cached PRaiseNode raiseNode) {
            Object res = getAttr.execute((Frame)frame, inliningTarget, self.getBuffer(), IONodes.T_CLOSED);
            if (isTrueNode.execute((Frame)frame, res)) {
                CheckClosedNode.error(self, raiseNode);
            }
        }
    }
}

