/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlotsFactory;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotNbPower;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqAssItem;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotUnaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotVarargs;
import com.oracle.graal.python.lib.PyDictGetItem;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.InlineWeakValueProfile;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public record TpSlots(TpSlot nb_bool, TpSlot nb_index, TpSlot nb_int, TpSlot nb_float, TpSlot nb_absolute, TpSlot nb_positive, TpSlot nb_negative, TpSlot nb_invert, TpSlot nb_add, TpSlot nb_subtract, TpSlot nb_multiply, TpSlot nb_remainder, TpSlot nb_lshift, TpSlot nb_rshift, TpSlot nb_and, TpSlot nb_xor, TpSlot nb_or, TpSlot nb_floor_divide, TpSlot nb_true_divide, TpSlot nb_divmod, TpSlot nb_matrix_multiply, TpSlot nb_power, TpSlot nb_inplace_add, TpSlot nb_inplace_subtract, TpSlot nb_inplace_multiply, TpSlot nb_inplace_remainder, TpSlot nb_inplace_lshift, TpSlot nb_inplace_rshift, TpSlot nb_inplace_and, TpSlot nb_inplace_xor, TpSlot nb_inplace_or, TpSlot nb_inplace_floor_divide, TpSlot nb_inplace_true_divide, TpSlot nb_inplace_matrix_multiply, TpSlot nb_inplace_power, TpSlot sq_length, TpSlot sq_item, TpSlot sq_ass_item, TpSlot sq_concat, TpSlot sq_repeat, TpSlot sq_inplace_concat, TpSlot sq_inplace_repeat, TpSlot sq_contains, TpSlot mp_length, TpSlot mp_subscript, TpSlot mp_ass_subscript, TpSlot combined_sq_mp_length, TpSlot combined_mp_sq_length, TpSlot tp_richcmp, TpSlot tp_descr_get, TpSlot tp_descr_set, TpSlot tp_hash, TpSlot tp_getattro, TpSlot tp_getattr, TpSlot combined_tp_getattro_getattr, TpSlot tp_setattro, TpSlot tp_setattr, TpSlot combined_tp_setattro_setattr, TpSlot tp_iter, TpSlot tp_iternext, TpSlot tp_repr, TpSlot tp_str, TpSlot tp_init, TpSlot tp_new, TpSlot tp_call, TpSlot am_await, TpSlot am_aiter, TpSlot am_anext, boolean has_as_number, boolean has_as_sequence, boolean has_as_mapping, boolean has_as_async) {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(TpSlot.class);
    private static final TpSlot NEXT_NOT_IMPLEMENTED = TpSlotIterNext.NEXT_NOT_IMPLEMENTED;
    private static final LinkedHashMap<TpSlotMeta, TpSlotDef[]> SLOTDEFS;
    private static final Map<TruffleString, List<TpSlotMeta>> SPECIAL2SLOT;
    private static final Map<TruffleString, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>>> SPECIAL2SLOTDEF;

    private static void addSlotDef(LinkedHashMap<TpSlotMeta, TpSlotDef[]> defs, TpSlotMeta slot, TpSlotDef ... slotDefs) {
        defs.put(slot, slotDefs);
    }

    public static TpSlots createEmpty() {
        return TpSlots.newBuilder().build();
    }

    public static TpSlots fromNative(PythonAbstractNativeObject pythonClass, PythonContext ctx) {
        Builder builder = TpSlots.newBuilder();
        for (TpSlotGroup tpSlotGroup : TpSlotGroup.VALID_VALUES) {
            if (!tpSlotGroup.readFromNative(pythonClass)) continue;
            builder.setExplicitGroup(tpSlotGroup);
        }
        for (Enum enum_ : TpSlotMeta.VALUES) {
            PyProcsWrapper.TpSlotWrapper existingSlotWrapper;
            Object field;
            block17: {
                if (!((TpSlotMeta)enum_).hasNativeWrapperFactory() || (field = ((TpSlotMeta)enum_).readFromNative(pythonClass)) == null) continue;
                InteropLibrary interop = InteropLibrary.getUncached((Object)field);
                existingSlotWrapper = null;
                if (interop.isPointer(field)) {
                    try {
                        long fieldPointer = interop.asPointer(field);
                        Object executable = ctx.getCApiContext().getClosureExecutable(fieldPointer);
                        if (executable instanceof PyProcsWrapper.TpSlotWrapper) {
                            PyProcsWrapper.TpSlotWrapper execWrapper;
                            existingSlotWrapper = execWrapper = (PyProcsWrapper.TpSlotWrapper)executable;
                        } else if (executable != null) {
                            LOGGER.fine(() -> String.format("Unexpected executable for slot pointer: %s", executable));
                        } else if (enum_ == TpSlotMeta.TP_HASH) {
                            if (CApiContext.isIdenticalToSymbol(fieldPointer, NativeCAPISymbol.FUN_PYOBJECT_HASH_NOT_IMPLEMENTED)) {
                                builder.set((TpSlotMeta)enum_, TpSlotHashFun.HASH_NOT_IMPLEMENTED);
                                continue;
                            }
                        } else if (enum_ == TpSlotMeta.TP_ITERNEXT && CApiContext.isIdenticalToSymbol(fieldPointer, NativeCAPISymbol.FUN_PY_OBJECT_NEXT_NOT_IMPLEMENTED)) {
                            builder.set((TpSlotMeta)enum_, TpSlotIterNext.NEXT_NOT_IMPLEMENTED);
                            continue;
                        }
                        break block17;
                    }
                    catch (UnsupportedMessageException e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (field instanceof PyProcsWrapper.TpSlotWrapper) {
                    PyProcsWrapper.TpSlotWrapper execWrapper;
                    existingSlotWrapper = execWrapper = (PyProcsWrapper.TpSlotWrapper)field;
                }
            }
            if (existingSlotWrapper != null) {
                TpSlot.TpSlotPython pythonSlot;
                TpSlot.TpSlotPython newPythonSlot;
                TpSlot.TpSlotManaged existingSlot;
                TpSlot.TpSlotManaged newSlot = existingSlot = existingSlotWrapper.getSlot();
                if (existingSlot instanceof TpSlot.TpSlotPython && (newSlot = (newPythonSlot = (pythonSlot = (TpSlot.TpSlotPython)existingSlot).forNewType(pythonClass))) != existingSlot) {
                    PyProcsWrapper.TpSlotWrapper newWrapper = existingSlotWrapper.cloneWith(newPythonSlot);
                    TpSlots.toNative(pythonClass.getPtr(), (TpSlotMeta)enum_, newWrapper, (Object)ctx.getNativeNull());
                    field = ((TpSlotMeta)enum_).readFromNative(pythonClass);
                }
                if (((TpSlotMeta)enum_).isValidSlotValue(newSlot)) {
                    builder.set((TpSlotMeta)enum_, newSlot);
                    continue;
                }
            }
            Object executable = CExtCommonNodes.EnsureExecutableNode.executeUncached(field, ((TpSlotMeta)enum_).nativeSignature);
            builder.set((TpSlotMeta)enum_, TpSlot.TpSlotNative.createCExtSlot(executable));
        }
        return builder.build();
    }

    @CompilerDirectives.TruffleBoundary
    public static void addOperatorsToNative(PythonAbstractNativeObject type) {
        PythonContext context = PythonContext.get(null);
        PythonLanguage language = context.getLanguage();
        TpSlots slots = GetTpSlotsNode.executeUncached(type);
        Object base = TypeNodes.GetBaseClassNode.executeUncached(type);
        TpSlots baseSlots = GetTpSlotsNode.executeUncached(base);
        PDict dict = GetDictIfExistsNode.getUncached().execute(type);
        assert (dict != null);
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> slotDefEntry : SLOTDEFS.entrySet()) {
            TpSlotMeta tpSlotMeta = slotDefEntry.getKey();
            for (TpSlotDef tpSlotDef : slotDefEntry.getValue()) {
                PythonAbstractObject wrapperDescriptor;
                Object existingValue;
                TpSlot value;
                if (tpSlotDef.wrapper == null || (value = tpSlotMeta.getValue(slots)) == null || tpSlotMeta.getValue(baseSlots) == value || (existingValue = PyDictGetItem.executeUncached(dict, tpSlotDef.name)) != null) continue;
                if (value == TpSlotHashFun.HASH_NOT_IMPLEMENTED) {
                    wrapperDescriptor = PNone.NONE;
                } else if (value instanceof TpSlot.TpSlotBuiltin) {
                    TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)value;
                    wrapperDescriptor = builtinSlot.createBuiltin(context, type, tpSlotDef.name, tpSlotDef.wrapper);
                } else if (value instanceof TpSlot.TpSlotNative) {
                    TpSlot.TpSlotNative nativeSlot = (TpSlot.TpSlotNative)value;
                    wrapperDescriptor = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(tpSlotDef.name, nativeSlot.getCallable(), (Object)type, 0, tpSlotDef.wrapper, language);
                } else {
                    if (value instanceof TpSlot.TpSlotPython) continue;
                    throw new IllegalStateException("addOperators: unexpected object in slot " + String.valueOf(value));
                }
                PyDictSetItem.executeUncached(dict, tpSlotDef.name, wrapperDescriptor);
            }
        }
    }

    public static void toNative(Object ptrToWrite, TpSlotMeta def, TpSlot value, Object nullValue) {
        assert (!(ptrToWrite instanceof PythonAbstractNativeObject));
        Object slotNativeValue = def.getNativeValue(value, nullValue);
        TpSlots.toNative(ptrToWrite, def, slotNativeValue, nullValue);
    }

    private static void toNative(Object prtToWrite, TpSlotMeta def, Object slotNativeValue, Object nullValue) {
        assert (!(slotNativeValue instanceof TpSlot));
        assert (!(prtToWrite instanceof PythonAbstractNativeObject));
        CompilerAsserts.neverPartOfCompilation();
        CFields fieldToWrite = def.nativeGroupOrField;
        if (def.nativeField != null) {
            prtToWrite = CStructAccess.ReadPointerNode.getUncached().read(prtToWrite, def.nativeGroupOrField);
            if (InteropLibrary.getUncached().isNull(prtToWrite)) {
                if (slotNativeValue == nullValue) {
                    return;
                }
                throw new IllegalStateException("Trying to write a native slot whose group is not allocated. Do we need to update 'updateSlots' to ignore non-allocated groups like CPython?");
            }
            fieldToWrite = def.nativeField;
        }
        CStructAccess.WritePointerNode.getUncached().write(prtToWrite, fieldToWrite, slotNativeValue);
    }

    @CompilerDirectives.TruffleBoundary
    public static void inherit(PythonClass klass, PDict namespace, MroSequenceStorage mro, boolean allocateAllGroups) {
        Builder klassSlots = TpSlots.buildInherited(klass, null, mro, allocateAllGroups);
        klass.setTpSlots(klassSlots.build());
    }

    @CompilerDirectives.TruffleBoundary
    public static Builder buildInherited(PythonClass klass, PDict namespace, MroSequenceStorage mro, boolean allocateAllGroups) {
        assert (klass.getTpSlots() == null);
        Builder klassSlots = TpSlots.newBuilder();
        if (allocateAllGroups) {
            klassSlots.allocateAllGroups();
        }
        if (klass.getBase() != null) {
            klassSlots.set(TpSlotMeta.TP_NEW, GetTpSlotsNode.executeUncached(klass.getBase()).tp_new());
        }
        for (int i = 0; i < mro.length(); ++i) {
            PythonAbstractClass type = mro.getPythonClassItemNormalized(i);
            TpSlots slots = GetTpSlotsNode.executeUncached(type);
            assert (slots != null || type == klass);
            if (slots == null) continue;
            klassSlots.inherit(klass, namespace, slots);
        }
        return klassSlots;
    }

    public static boolean canBeSpecialMethod(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        int len = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING);
        return len > 5 && codePointAtIndexNode.execute((AbstractTruffleString)name, len - 2, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, len - 1, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, 1, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, 0, PythonUtils.TS_ENCODING) == 95;
    }

    public static boolean isSpecialMethod(TruffleString name) {
        CompilerAsserts.neverPartOfCompilation();
        return SPECIAL2SLOT.containsKey(name);
    }

    private static TpSlotMeta resolveSlotdups(Builder slots, TruffleString name) {
        TpSlotMeta found = null;
        for (TpSlotMeta s : SPECIAL2SLOT.get(name)) {
            TpSlot value = slots.get(s);
            if (value == null) continue;
            if (found != null) {
                return null;
            }
            found = s;
        }
        return found;
    }

    @CompilerDirectives.TruffleBoundary
    public static void fixupSlotDispatchers(PythonClass klass, Builder slots) {
        TpSlots.updateSlots((PythonAbstractClass)klass, slots, SLOTDEFS.entrySet());
    }

    @CompilerDirectives.TruffleBoundary
    public static void fixupSlotDispatchers(PythonClass klass) {
        TpSlots.updateSlots((PythonAbstractClass)klass, klass.getTpSlots(), SLOTDEFS.entrySet());
    }

    @CompilerDirectives.TruffleBoundary
    public static void updateAllSlots(PythonAbstractClass klass) {
        TpSlots.updateSlot(klass, SLOTDEFS.entrySet());
    }

    @CompilerDirectives.TruffleBoundary
    public static void updateSlot(PythonAbstractClass klass, TruffleString specialMethodName) {
        Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups = SPECIAL2SLOTDEF.get(specialMethodName);
        if (slotdefGroups == null) {
            return;
        }
        TpSlots.updateSlot(klass, slotdefGroups);
    }

    private static void updateSlot(PythonAbstractClass klass, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups) {
        TpSlots slots = GetTpSlotsNode.executeUncached(klass);
        if (slots == null) {
            return;
        }
        TpSlots.updateSlots(klass, slots, slotdefGroups);
        for (PythonAbstractClass subClass : TypeNodes.GetSubclassesAsArrayNode.executeUncached(klass)) {
            TpSlots.updateSlot(subClass, slotdefGroups);
        }
    }

    private static void updateSlots(PythonAbstractClass klass, TpSlots slots, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups) {
        TpSlots.setSlots(klass, TpSlots.updateSlots(klass, slots.copy(), slotdefGroups).build());
    }

    private static Builder updateSlots(PythonAbstractClass klass, Builder slots, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups) {
        LookupAttributeInMRONode.Dynamic lookup = LookupAttributeInMRONode.Dynamic.getUncached();
        IsSubtypeNode isSubType = IsSubtypeNode.getUncached();
        NativePointer nativeNull = PythonContext.get(null).getNativeNull();
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> slotdefGroup : slotdefGroups) {
            Object replacement;
            PythonManagedClass managedClass;
            PythonClassNativeWrapper classNativeWrapper;
            TpSlotMeta slot = slotdefGroup.getKey();
            if (slot.hasGroup() && !slots.hasGroup(slot.getGroup())) continue;
            boolean useGeneric = false;
            PythonFunctionFactory generic = null;
            TpSlot specific = null;
            TpSlotDef[] defs = slotdefGroup.getValue();
            Object[] genericCallables = new Object[defs.length];
            TruffleString[] genericCallablesNames = new TruffleString[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                PBuiltinMethod method;
                PBuiltinFunction builtin;
                Object descr;
                TruffleString name = defs[i].name();
                genericCallables[i] = descr = lookup.execute(klass, name);
                genericCallablesNames[i] = name;
                if (descr == PNone.NO_VALUE) {
                    if (slot != TpSlotMeta.TP_ITERNEXT) continue;
                    specific = NEXT_NOT_IMPLEMENTED;
                    continue;
                }
                if (descr instanceof PBuiltinFunction && (builtin = (PBuiltinFunction)descr).getSlot() != null) {
                    boolean canSetSpecific;
                    TpSlotMeta tptr = TpSlots.resolveSlotdups(slots, name);
                    if (tptr == null || tptr == slot) {
                        generic = defs[i].functionFactory;
                    }
                    TpSlot wrappedSlot = builtin.getSlot();
                    boolean bl = canSetSpecific = specific == null || specific == wrappedSlot || TpSlots.areSameNativeCallables(wrappedSlot, specific);
                    if (canSetSpecific && builtin.getSlotWrapper() == defs[i].wrapper() && isSubType.execute(klass, builtin.getEnclosingType())) {
                        specific = wrappedSlot;
                        continue;
                    }
                    useGeneric = true;
                    continue;
                }
                if (slot == TpSlotMeta.TP_NEW && descr instanceof PBuiltinMethod && (method = (PBuiltinMethod)descr).getBuiltinFunction().getSlot() != null && !(slots.get(TpSlotMeta.TP_NEW) instanceof TpSlot.TpSlotPython)) {
                    specific = slots.get(TpSlotMeta.TP_NEW);
                    continue;
                }
                if (descr == PNone.NONE && slot == TpSlotMeta.TP_HASH) {
                    specific = TpSlotHashFun.HASH_NOT_IMPLEMENTED;
                    continue;
                }
                useGeneric = true;
                generic = defs[i].functionFactory;
            }
            TpSlot newValue = null;
            if (specific != null && !useGeneric) {
                newValue = specific;
            } else if (generic != null) {
                newValue = generic.create(genericCallables, genericCallablesNames, klass);
            }
            slots.set(slot, newValue);
            if (klass instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject nativeClass = (PythonAbstractNativeObject)klass;
                TpSlots.toNative(nativeClass.getPtr(), slot, newValue, (Object)nativeNull);
            }
            if (!(klass instanceof PythonManagedClass) || (classNativeWrapper = (managedClass = (PythonManagedClass)klass).getClassNativeWrapper()) == null || (replacement = classNativeWrapper.getReplacementIfInitialized()) == null) continue;
            TpSlots.toNative(replacement, slot, newValue, (Object)nativeNull);
        }
        return slots;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean areSameNativeCallables(TpSlot a, TpSlot b) {
        if (!(a instanceof TpSlot.TpSlotNative)) return false;
        TpSlot.TpSlotNative na = (TpSlot.TpSlotNative)a;
        if (!(b instanceof TpSlot.TpSlotNative)) return false;
        TpSlot.TpSlotNative nb = (TpSlot.TpSlotNative)b;
        if (!na.isSameCallable(nb, InteropLibrary.getUncached())) return false;
        return true;
    }

    public static void setSlots(PythonAbstractClass klass, TpSlots slots) {
        if (klass instanceof PythonClass) {
            PythonClass pythonClass = (PythonClass)klass;
            pythonClass.setTpSlots(slots);
        } else if (klass instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeClass = (PythonAbstractNativeObject)klass;
            nativeClass.setTpSlots(slots);
        } else {
            String name = klass == null ? "null" : klass.getClass().getName();
            throw new AssertionError((Object)("Unexpected type :" + name));
        }
    }

    public static void initializeBuiltinSlots(PythonLanguage language) {
        for (PythonBuiltinClassType klass : PythonBuiltinClassType.VALUES) {
            for (TpSlotMeta slotMeta : TpSlotMeta.VALUES) {
                TpSlot slotValue = slotMeta.getValue(klass.getDeclaredSlots());
                if (slotValue instanceof TpSlot.TpSlotBuiltin) {
                    TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)slotValue;
                    builtinSlot.initialize(language);
                    continue;
                }
                assert (slotValue == null);
            }
        }
    }

    private static boolean checkNoMagicOverrides(Python3Core core, PythonBuiltinClassType type) {
        ReadAttributeFromObjectNode readAttr = ReadAttributeFromObjectNode.getUncachedForceType();
        PythonBuiltinClass typeObj = core.lookupType(type);
        for (TruffleString name : SPECIAL2SLOT.keySet()) {
            assert (readAttr.execute(typeObj, name) == PNone.NO_VALUE) : type.name() + ":" + String.valueOf(name);
        }
        return true;
    }

    public static void addOperatorsToBuiltin(Python3Core core, PythonBuiltinClassType type, PythonBuiltinClass pythonBuiltinClass) {
        TpSlots slots = type.getDeclaredSlots();
        assert (TpSlots.checkNoMagicOverrides(core, type));
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> slotDefGroup : SLOTDEFS.entrySet()) {
            TpSlotMeta slotMeta = slotDefGroup.getKey();
            TpSlot slotValue = slotMeta.getter.get(slots);
            if (slotMeta == TpSlotMeta.TP_HASH && slotValue == TpSlotHashFun.HASH_NOT_IMPLEMENTED) {
                DynamicObjectLibrary.getUncached().put((DynamicObject)pythonBuiltinClass, (Object)SpecialMethodNames.T___HASH__, (Object)PNone.NONE);
                continue;
            }
            if (!(slotValue instanceof TpSlot.TpSlotBuiltin)) continue;
            TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)slotValue;
            for (TpSlotDef slotDef : slotDefGroup.getValue()) {
                if (slotDef.wrapper() == null || pythonBuiltinClass.getAttribute(slotDef.name()) != PNone.NO_VALUE) continue;
                PythonObject value = builtinSlot.createBuiltin(core, (Object)type, slotDef.name(), slotDef.wrapper());
                pythonBuiltinClass.setAttribute(slotDef.name(), value);
            }
        }
    }

    public Builder copy() {
        Builder result = new Builder();
        for (TpSlotMeta tpSlotMeta : TpSlotMeta.VALUES) {
            result.set(tpSlotMeta, tpSlotMeta.getValue(this));
        }
        for (Enum enum_ : TpSlotGroup.VALID_VALUES) {
            if (!((TpSlotGroup)enum_).getValue(this)) continue;
            result.setExplicitGroup((TpSlotGroup)enum_);
        }
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static boolean areAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public boolean areEqualTo(TpSlots otherSlots) {
        for (TpSlotMeta def : TpSlotMeta.VALUES) {
            TpSlot otherValue;
            TpSlot thisValue = def.getter.get(this);
            if (thisValue == (otherValue = def.getter.get(otherSlots))) continue;
            return false;
        }
        return true;
    }

    static {
        LinkedHashMap<TpSlotMeta, TpSlotDef[]> s = new LinkedHashMap<TpSlotMeta, TpSlotDef[]>(30);
        TpSlots.addSlotDef(s, TpSlotMeta.TP_GETATTR, TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___GETATTRIBUTE__), TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___GETATTR__));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_SETATTR, TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___SETATTR__), TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___DELATTR__));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_HASH, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___HASH__, ExternalFunctionNodes.PExternalFunctionWrapper.HASHFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_GETATTRO, TpSlotDef.create(SpecialMethodNames.T___GETATTRIBUTE__, TpSlotGetAttr.TpSlotGetAttrPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC), TpSlotDef.create(SpecialMethodNames.T___GETATTR__, TpSlotGetAttr.TpSlotGetAttrPython::create, null));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_SETATTRO, TpSlotDef.create(SpecialMethodNames.T___SETATTR__, TpSlotSetAttr.TpSlotSetAttrPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.SETATTRO), TpSlotDef.create(SpecialMethodNames.T___DELATTR__, TpSlotSetAttr.TpSlotSetAttrPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DELATTRO));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_RICHCOMPARE, TpSlotDef.create(SpecialMethodNames.T___LT__, TpSlotRichCompare.TpSlotRichCmpPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.LT), TpSlotDef.create(SpecialMethodNames.T___LE__, TpSlotRichCompare.TpSlotRichCmpPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.LE), TpSlotDef.create(SpecialMethodNames.T___EQ__, TpSlotRichCompare.TpSlotRichCmpPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.EQ), TpSlotDef.create(SpecialMethodNames.T___NE__, TpSlotRichCompare.TpSlotRichCmpPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.NE), TpSlotDef.create(SpecialMethodNames.T___GT__, TpSlotRichCompare.TpSlotRichCmpPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.GT), TpSlotDef.create(SpecialMethodNames.T___GE__, TpSlotRichCompare.TpSlotRichCmpPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.GE));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_DESCR_GET, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___GET__, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_GET));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_DESCR_SET, TpSlotDef.create(SpecialMethodNames.T___SET__, TpSlotDescrSet.TpSlotDescrSetPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_SET), TpSlotDef.create(SpecialMethodNames.T___DELETE__, TpSlotDescrSet.TpSlotDescrSetPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_DELETE));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_ITER, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___ITER__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_ITERNEXT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___NEXT__, ExternalFunctionNodes.PExternalFunctionWrapper.ITERNEXT));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_STR, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___STR__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_REPR, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___REPR__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_INIT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___INIT__, ExternalFunctionNodes.PExternalFunctionWrapper.INITPROC));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_NEW, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___NEW__, ExternalFunctionNodes.PExternalFunctionWrapper.NEW));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_CALL, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___CALL__, ExternalFunctionNodes.PExternalFunctionWrapper.CALL));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_ADD, TpSlotDef.create(SpecialMethodNames.T___ADD__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RADD__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_SUBTRACT, TpSlotDef.create(SpecialMethodNames.T___SUB__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RSUB__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_MULTIPLY, TpSlotDef.create(SpecialMethodNames.T___MUL__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RMUL__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_REMAINDER, TpSlotDef.create(SpecialMethodNames.T___MOD__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RMOD__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_LSHIFT, TpSlotDef.create(SpecialMethodNames.T___LSHIFT__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RLSHIFT__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_RSHIFT, TpSlotDef.create(SpecialMethodNames.T___RSHIFT__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RRSHIFT__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_AND, TpSlotDef.create(SpecialMethodNames.T___AND__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RAND__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_XOR, TpSlotDef.create(SpecialMethodNames.T___XOR__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RXOR__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_OR, TpSlotDef.create(SpecialMethodNames.T___OR__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___ROR__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_FLOOR_DIVIDE, TpSlotDef.create(SpecialMethodNames.T___FLOORDIV__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RFLOORDIV__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_TRUE_DIVIDE, TpSlotDef.create(SpecialMethodNames.T___TRUEDIV__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RTRUEDIV__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_DIVMOD, TpSlotDef.create(SpecialMethodNames.T___DIVMOD__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RDIVMOD__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_MATRIX_MULTIPLY, TpSlotDef.create(SpecialMethodNames.T___MATMUL__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_L), TpSlotDef.create(SpecialMethodNames.T___RMATMUL__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_POWER, TpSlotDef.create(SpecialMethodNames.T___POW__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.TERNARYFUNC), TpSlotDef.create(SpecialMethodNames.T___RPOW__, TpSlotBinaryOp.TpSlotReversiblePython::create, ExternalFunctionNodes.PExternalFunctionWrapper.TERNARYFUNC_R));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_ADD, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IADD__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_SUBTRACT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___ISUB__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_MULTIPLY, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IMUL__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_REMAINDER, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IMOD__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_LSHIFT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___ILSHIFT__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_RSHIFT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IRSHIFT__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_AND, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IAND__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_XOR, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IXOR__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_OR, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IOR__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_FLOOR_DIVIDE, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IFLOORDIV__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_TRUE_DIVIDE, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___ITRUEDIV__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_MATRIX_MULTIPLY, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IMATMUL__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INPLACE_POWER, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___IPOW__, ExternalFunctionNodes.PExternalFunctionWrapper.TERNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_BOOL, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___BOOL__, ExternalFunctionNodes.PExternalFunctionWrapper.INQUIRY));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INDEX, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___INDEX__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___INT__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_FLOAT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___FLOAT__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_ABSOLUTE, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___ABS__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_POSITIVE, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___POS__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_NEGATIVE, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___NEG__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_INVERT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___INVERT__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.MP_LENGTH, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___LEN__, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.MP_SUBSCRIPT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___GETITEM__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.MP_ASS_SUBSCRIPT, TpSlotDef.create(SpecialMethodNames.T___SETITEM__, TpSlotMpAssSubscript.TpSlotMpAssSubscriptPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.OBJOBJARGPROC), TpSlotDef.create(SpecialMethodNames.T___DELITEM__, TpSlotMpAssSubscript.TpSlotMpAssSubscriptPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.MP_DELITEM));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_LENGTH, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___LEN__, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_CONCAT, TpSlotDef.withNoFunction(SpecialMethodNames.T___ADD__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_REPEAT, TpSlotDef.withNoFunction(SpecialMethodNames.T___MUL__, ExternalFunctionNodes.PExternalFunctionWrapper.SSIZE_ARG), TpSlotDef.withNoFunction(SpecialMethodNames.T___RMUL__, ExternalFunctionNodes.PExternalFunctionWrapper.SSIZE_ARG));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_ITEM, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___GETITEM__, ExternalFunctionNodes.PExternalFunctionWrapper.GETITEM));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_ASS_ITEM, TpSlotDef.create(SpecialMethodNames.T___SETITEM__, TpSlotSqAssItem.TpSlotSqAssItemPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.SETITEM), TpSlotDef.create(SpecialMethodNames.T___DELITEM__, TpSlotSqAssItem.TpSlotSqAssItemPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DELITEM));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_INPLACE_CONCAT, TpSlotDef.withNoFunction(SpecialMethodNames.T___IADD__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_INPLACE_REPEAT, TpSlotDef.withNoFunction(SpecialMethodNames.T___IMUL__, ExternalFunctionNodes.PExternalFunctionWrapper.SSIZE_ARG));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_CONTAINS, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___CONTAINS__, ExternalFunctionNodes.PExternalFunctionWrapper.OBJOBJPROC));
        TpSlots.addSlotDef(s, TpSlotMeta.AM_AWAIT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___AWAIT__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.AM_ANEXT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___ANEXT__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.AM_AITER, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___AITER__, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC));
        SLOTDEFS = s;
        SPECIAL2SLOT = new HashMap<TruffleString, List<TpSlotMeta>>(SLOTDEFS.size() * 2);
        SPECIAL2SLOTDEF = new HashMap<TruffleString, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>>>(SLOTDEFS.size() * 2);
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> e : SLOTDEFS.entrySet()) {
            for (TpSlotDef slotDef : e.getValue()) {
                SPECIAL2SLOT.computeIfAbsent(slotDef.name(), k -> new ArrayList()).add(e.getKey());
                SPECIAL2SLOTDEF.computeIfAbsent(slotDef.name(), k -> new HashSet()).add(e);
            }
        }
    }

    public static final class Builder {
        private final TpSlot[] values = new TpSlot[TpSlotMeta.VALUES.length];
        private final boolean[] explicitGroups = new boolean[TpSlotGroup.VALID_VALUES.length];

        public void allocateAllGroups() {
            Arrays.fill(this.explicitGroups, true);
        }

        public void setExplicitGroup(TpSlotGroup group) {
            assert (group != TpSlotGroup.NO_GROUP);
            this.explicitGroups[group.ordinal()] = true;
        }

        public Builder set(TpSlotMeta slotMeta, TpSlot value) {
            assert (slotMeta.isValidSlotValue(value)) : String.format("Slot %s is being assigned to type incompatible slot value %s.", slotMeta.name(), value);
            this.values[slotMeta.ordinal()] = value;
            return this;
        }

        public Builder overrideIgnoreGroups(TpSlots other) {
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                TpSlot current = this.values[def.ordinal()];
                TpSlot otherValue = def.getter.get(other);
                TpSlot newValue = otherValue != null ? otherValue : current;
                this.set(def, newValue);
            }
            return this;
        }

        private Builder inherit(PythonClass klass, PDict namespace, TpSlots base) {
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                if (def == TpSlotMeta.TP_RICHCOMPARE || def == TpSlotMeta.TP_HASH || def == TpSlotMeta.TP_GETATTRO || def == TpSlotMeta.TP_GETATTR || def == TpSlotMeta.TP_SETATTRO || def == TpSlotMeta.TP_SETATTR || def.group != TpSlotGroup.NO_GROUP && !this.explicitGroups[def.group.ordinal()]) continue;
                TpSlot current = this.values[def.ordinal()];
                TpSlot otherValue = def.getter.get(base);
                TpSlot newValue = current != null ? current : otherValue;
                this.set(def, newValue);
            }
            if (this.get(TpSlotMeta.TP_GETATTR) == null && this.get(TpSlotMeta.TP_GETATTRO) == null) {
                this.set(TpSlotMeta.TP_GETATTR, base.tp_getattr());
                this.set(TpSlotMeta.TP_GETATTRO, base.tp_getattro());
            }
            if (this.get(TpSlotMeta.TP_SETATTR) == null && this.get(TpSlotMeta.TP_SETATTRO) == null) {
                this.set(TpSlotMeta.TP_SETATTR, base.tp_setattr());
                this.set(TpSlotMeta.TP_SETATTRO, base.tp_setattro());
            }
            if (this.get(TpSlotMeta.TP_RICHCOMPARE) == null && this.get(TpSlotMeta.TP_HASH) == null && !Builder.overridesHash(namespace)) {
                this.set(TpSlotMeta.TP_RICHCOMPARE, base.tp_richcmp());
                this.set(TpSlotMeta.TP_HASH, base.tp_hash());
            }
            return this;
        }

        private static boolean overridesHash(PDict namespace) {
            if (namespace == null) {
                return false;
            }
            Object eq = HashingStorageNodes.HashingStorageGetItem.executeUncached(namespace.getDictStorage(), SpecialMethodNames.T___EQ__);
            if (eq == null) {
                Object hash = HashingStorageNodes.HashingStorageGetItem.executeUncached(namespace.getDictStorage(), SpecialMethodNames.T___HASH__);
                return hash != null;
            }
            return true;
        }

        private TpSlot fistNonNull(TpSlotMeta a, TpSlotMeta b) {
            return this.values[a.ordinal()] != null ? this.values[a.ordinal()] : this.values[b.ordinal()];
        }

        TpSlot get(TpSlotMeta s) {
            return this.values[s.ordinal()];
        }

        private boolean hasGroup(TpSlotGroup group) {
            assert (group != TpSlotGroup.NO_GROUP);
            if (this.explicitGroups[group.ordinal()]) {
                return true;
            }
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                if (def.group != group || this.values[def.ordinal()] == null) continue;
                return true;
            }
            return false;
        }

        public TpSlots build() {
            TpSlot sq_mp_length = this.fistNonNull(TpSlotMeta.SQ_LENGTH, TpSlotMeta.MP_LENGTH);
            TpSlot mp_sq_length = this.fistNonNull(TpSlotMeta.MP_LENGTH, TpSlotMeta.SQ_LENGTH);
            TpSlot tp_get_attro_attr = this.fistNonNull(TpSlotMeta.TP_GETATTRO, TpSlotMeta.TP_GETATTR);
            TpSlot tp_set_attro_attr = this.fistNonNull(TpSlotMeta.TP_SETATTRO, TpSlotMeta.TP_SETATTR);
            return new TpSlots(this.get(TpSlotMeta.NB_BOOL), this.get(TpSlotMeta.NB_INDEX), this.get(TpSlotMeta.NB_INT), this.get(TpSlotMeta.NB_FLOAT), this.get(TpSlotMeta.NB_ABSOLUTE), this.get(TpSlotMeta.NB_POSITIVE), this.get(TpSlotMeta.NB_NEGATIVE), this.get(TpSlotMeta.NB_INVERT), this.get(TpSlotMeta.NB_ADD), this.get(TpSlotMeta.NB_SUBTRACT), this.get(TpSlotMeta.NB_MULTIPLY), this.get(TpSlotMeta.NB_REMAINDER), this.get(TpSlotMeta.NB_LSHIFT), this.get(TpSlotMeta.NB_RSHIFT), this.get(TpSlotMeta.NB_AND), this.get(TpSlotMeta.NB_XOR), this.get(TpSlotMeta.NB_OR), this.get(TpSlotMeta.NB_FLOOR_DIVIDE), this.get(TpSlotMeta.NB_TRUE_DIVIDE), this.get(TpSlotMeta.NB_DIVMOD), this.get(TpSlotMeta.NB_MATRIX_MULTIPLY), this.get(TpSlotMeta.NB_POWER), this.get(TpSlotMeta.NB_INPLACE_ADD), this.get(TpSlotMeta.NB_INPLACE_SUBTRACT), this.get(TpSlotMeta.NB_INPLACE_MULTIPLY), this.get(TpSlotMeta.NB_INPLACE_REMAINDER), this.get(TpSlotMeta.NB_INPLACE_LSHIFT), this.get(TpSlotMeta.NB_INPLACE_RSHIFT), this.get(TpSlotMeta.NB_INPLACE_AND), this.get(TpSlotMeta.NB_INPLACE_XOR), this.get(TpSlotMeta.NB_INPLACE_OR), this.get(TpSlotMeta.NB_INPLACE_FLOOR_DIVIDE), this.get(TpSlotMeta.NB_INPLACE_TRUE_DIVIDE), this.get(TpSlotMeta.NB_INPLACE_MATRIX_MULTIPLY), this.get(TpSlotMeta.NB_INPLACE_POWER), this.get(TpSlotMeta.SQ_LENGTH), this.get(TpSlotMeta.SQ_ITEM), this.get(TpSlotMeta.SQ_ASS_ITEM), this.get(TpSlotMeta.SQ_CONCAT), this.get(TpSlotMeta.SQ_REPEAT), this.get(TpSlotMeta.SQ_INPLACE_CONCAT), this.get(TpSlotMeta.SQ_INPLACE_REPEAT), this.get(TpSlotMeta.SQ_CONTAINS), this.get(TpSlotMeta.MP_LENGTH), this.get(TpSlotMeta.MP_SUBSCRIPT), this.get(TpSlotMeta.MP_ASS_SUBSCRIPT), sq_mp_length, mp_sq_length, this.get(TpSlotMeta.TP_RICHCOMPARE), this.get(TpSlotMeta.TP_DESCR_GET), this.get(TpSlotMeta.TP_DESCR_SET), this.get(TpSlotMeta.TP_HASH), this.get(TpSlotMeta.TP_GETATTRO), this.get(TpSlotMeta.TP_GETATTR), tp_get_attro_attr, this.get(TpSlotMeta.TP_SETATTRO), this.get(TpSlotMeta.TP_SETATTR), tp_set_attro_attr, this.get(TpSlotMeta.TP_ITER), this.get(TpSlotMeta.TP_ITERNEXT), this.get(TpSlotMeta.TP_REPR), this.get(TpSlotMeta.TP_STR), this.get(TpSlotMeta.TP_INIT), this.get(TpSlotMeta.TP_NEW), this.get(TpSlotMeta.TP_CALL), this.get(TpSlotMeta.AM_AWAIT), this.get(TpSlotMeta.AM_AITER), this.get(TpSlotMeta.AM_ANEXT), this.hasGroup(TpSlotGroup.AS_NUMBER), this.hasGroup(TpSlotGroup.AS_SEQUENCE), this.hasGroup(TpSlotGroup.AS_MAPPING), this.hasGroup(TpSlotGroup.AS_ASYNC));
        }
    }

    public static final class TpSlotGroup
    extends Enum<TpSlotGroup> {
        public static final /* enum */ TpSlotGroup AS_NUMBER = new TpSlotGroup(TpSlots::has_as_number, CFields.PyTypeObject__tp_as_number);
        public static final /* enum */ TpSlotGroup AS_SEQUENCE = new TpSlotGroup(TpSlots::has_as_sequence, CFields.PyTypeObject__tp_as_sequence);
        public static final /* enum */ TpSlotGroup AS_MAPPING = new TpSlotGroup(TpSlots::has_as_mapping, CFields.PyTypeObject__tp_as_mapping);
        public static final /* enum */ TpSlotGroup AS_ASYNC = new TpSlotGroup(TpSlots::has_as_async, CFields.PyTypeObject__tp_as_async);
        public static final /* enum */ TpSlotGroup NO_GROUP = new TpSlotGroup(null, null);
        public static final TpSlotGroup[] VALID_VALUES;
        private final GroupGetter getter;
        private final CFields cField;
        private static final /* synthetic */ TpSlotGroup[] $VALUES;

        public static TpSlotGroup[] values() {
            return (TpSlotGroup[])$VALUES.clone();
        }

        public static TpSlotGroup valueOf(String name) {
            return Enum.valueOf(TpSlotGroup.class, name);
        }

        private TpSlotGroup(GroupGetter getter, CFields cField) {
            this.getter = getter;
            this.cField = cField;
        }

        public boolean getValue(TpSlots slots) {
            assert (this != NO_GROUP);
            return this.getter.get(slots);
        }

        public boolean readFromNative(PythonAbstractNativeObject pythonClass) {
            Object ptr = CStructAccess.ReadPointerNode.getUncached().readFromObj(pythonClass, this.cField);
            return !InteropLibrary.getUncached().isNull(ptr);
        }

        private static /* synthetic */ TpSlotGroup[] $values() {
            return new TpSlotGroup[]{AS_NUMBER, AS_SEQUENCE, AS_MAPPING, AS_ASYNC, NO_GROUP};
        }

        static {
            $VALUES = TpSlotGroup.$values();
            VALID_VALUES = Arrays.copyOf(TpSlotGroup.values(), TpSlotGroup.values().length - 1);
        }
    }

    public static final class TpSlotMeta
    extends Enum<TpSlotMeta> {
        public static final /* enum */ TpSlotMeta NB_BOOL = new TpSlotMeta(TpSlots::nb_bool, TpSlot.TpSlotPythonSingle.class, TpSlotInquiry.TpSlotInquiryBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_bool, ExternalFunctionNodes.PExternalFunctionWrapper.INQUIRY, PyProcsWrapper.InquiryWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INDEX = new TpSlotMeta(TpSlots::nb_index, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_index, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INT = new TpSlotMeta(TpSlots::nb_int, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_int, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_FLOAT = new TpSlotMeta(TpSlots::nb_float, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_float, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_ABSOLUTE = new TpSlotMeta(TpSlots::nb_absolute, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_absolute, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_POSITIVE = new TpSlotMeta(TpSlots::nb_positive, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_positive, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_NEGATIVE = new TpSlotMeta(TpSlots::nb_negative, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_negative, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INVERT = new TpSlotMeta(TpSlots::nb_invert, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_invert, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_ADD = new TpSlotMeta(TpSlots::nb_add, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_add, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createAdd);
        public static final /* enum */ TpSlotMeta NB_SUBTRACT = new TpSlotMeta(TpSlots::nb_subtract, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_subtract, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createSubtract);
        public static final /* enum */ TpSlotMeta NB_MULTIPLY = new TpSlotMeta(TpSlots::nb_multiply, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_multiply, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createMultiply);
        public static final /* enum */ TpSlotMeta NB_REMAINDER = new TpSlotMeta(TpSlots::nb_remainder, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_remainder, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createRemainder);
        public static final /* enum */ TpSlotMeta NB_LSHIFT = new TpSlotMeta(TpSlots::nb_lshift, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_lshift, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createLShift);
        public static final /* enum */ TpSlotMeta NB_RSHIFT = new TpSlotMeta(TpSlots::nb_rshift, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_rshift, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createRShift);
        public static final /* enum */ TpSlotMeta NB_AND = new TpSlotMeta(TpSlots::nb_and, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_and, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createAnd);
        public static final /* enum */ TpSlotMeta NB_XOR = new TpSlotMeta(TpSlots::nb_xor, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_xor, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createXor);
        public static final /* enum */ TpSlotMeta NB_OR = new TpSlotMeta(TpSlots::nb_or, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_or, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createOr);
        public static final /* enum */ TpSlotMeta NB_FLOOR_DIVIDE = new TpSlotMeta(TpSlots::nb_floor_divide, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_floor_divide, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createFloorDivide);
        public static final /* enum */ TpSlotMeta NB_TRUE_DIVIDE = new TpSlotMeta(TpSlots::nb_true_divide, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_true_divide, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createTrueDivide);
        public static final /* enum */ TpSlotMeta NB_DIVMOD = new TpSlotMeta(TpSlots::nb_divmod, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_divmod, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createDivMod);
        public static final /* enum */ TpSlotMeta NB_MATRIX_MULTIPLY = new TpSlotMeta(TpSlots::nb_matrix_multiply, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotBinaryOp.TpSlotBinaryOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_matrix_multiply, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinaryOpSlotFuncWrapper::createMatrixMultiply);
        public static final /* enum */ TpSlotMeta NB_POWER = new TpSlotMeta(TpSlots::nb_power, TpSlotBinaryOp.TpSlotReversiblePython.class, TpSlotNbPower.TpSlotNbPowerBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_power, ExternalFunctionNodes.PExternalFunctionWrapper.TERNARYFUNC, PyProcsWrapper.NbPowerWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_ADD = new TpSlotMeta(TpSlots::nb_inplace_add, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_add, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_SUBTRACT = new TpSlotMeta(TpSlots::nb_inplace_subtract, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_subtract, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_MULTIPLY = new TpSlotMeta(TpSlots::nb_inplace_multiply, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_multiply, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_REMAINDER = new TpSlotMeta(TpSlots::nb_inplace_remainder, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_remainder, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_LSHIFT = new TpSlotMeta(TpSlots::nb_inplace_lshift, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_lshift, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_RSHIFT = new TpSlotMeta(TpSlots::nb_inplace_rshift, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_rshift, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_AND = new TpSlotMeta(TpSlots::nb_inplace_and, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_and, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_XOR = new TpSlotMeta(TpSlots::nb_inplace_xor, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_xor, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_OR = new TpSlotMeta(TpSlots::nb_inplace_or, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_or, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_FLOOR_DIVIDE = new TpSlotMeta(TpSlots::nb_inplace_floor_divide, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_floor_divide, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_TRUE_DIVIDE = new TpSlotMeta(TpSlots::nb_inplace_true_divide, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_true_divide, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_MATRIX_MULTIPLY = new TpSlotMeta(TpSlots::nb_inplace_matrix_multiply, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_matrix_multiply, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta NB_INPLACE_POWER = new TpSlotMeta(TpSlots::nb_inplace_power, TpSlot.TpSlotPythonSingle.class, null, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_inplace_power, ExternalFunctionNodes.PExternalFunctionWrapper.TERNARYFUNC, PyProcsWrapper.NbInPlacePowerWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_LENGTH = new TpSlotMeta(TpSlots::sq_length, TpSlot.TpSlotPythonSingle.class, TpSlotLen.TpSlotLenBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_length, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC, PyProcsWrapper.LenfuncWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_CONCAT = new TpSlotMeta(TpSlots::sq_concat, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryFunc.TpSlotSqConcat.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_concat, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_ITEM = new TpSlotMeta(TpSlots::sq_item, TpSlot.TpSlotPythonSingle.class, TpSlotSizeArgFun.TpSlotSizeArgFunBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_item, ExternalFunctionNodes.PExternalFunctionWrapper.GETITEM, PyProcsWrapper.SsizeargfuncSlotWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_ASS_ITEM = new TpSlotMeta(TpSlots::sq_ass_item, TpSlotSqAssItem.TpSlotSqAssItemPython.class, TpSlotSqAssItem.TpSlotSqAssItemBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_ass_item, ExternalFunctionNodes.PExternalFunctionWrapper.SETITEM, PyProcsWrapper.SsizeobjargprocWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_REPEAT = new TpSlotMeta(TpSlots::sq_repeat, TpSlot.TpSlotPythonSingle.class, TpSlotSizeArgFun.TpSlotSizeArgFunBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_repeat, ExternalFunctionNodes.PExternalFunctionWrapper.SSIZE_ARG, PyProcsWrapper.SsizeargfuncSlotWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_INPLACE_CONCAT = new TpSlotMeta(TpSlots::sq_inplace_concat, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryOp.TpSlotBinaryIOpBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_inplace_concat, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_INPLACE_REPEAT = new TpSlotMeta(TpSlots::sq_inplace_repeat, TpSlot.TpSlotPythonSingle.class, TpSlotSizeArgFun.TpSlotSizeArgFunBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_inplace_repeat, ExternalFunctionNodes.PExternalFunctionWrapper.SSIZE_ARG, PyProcsWrapper.SsizeargfuncSlotWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_CONTAINS = new TpSlotMeta(TpSlots::sq_contains, TpSlot.TpSlotPythonSingle.class, TpSlotSqContains.TpSlotSqContainsBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_contains, ExternalFunctionNodes.PExternalFunctionWrapper.OBJOBJPROC, PyProcsWrapper.SqContainsWrapper::new);
        public static final /* enum */ TpSlotMeta MP_LENGTH = new TpSlotMeta(TpSlots::mp_length, TpSlot.TpSlotPythonSingle.class, TpSlotLen.TpSlotLenBuiltin.class, TpSlotGroup.AS_MAPPING, CFields.PyMappingMethods__mp_length, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC, PyProcsWrapper.LenfuncWrapper::new);
        public static final /* enum */ TpSlotMeta MP_SUBSCRIPT = new TpSlotMeta(TpSlots::mp_subscript, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryFunc.TpSlotBinaryFuncBuiltin.class, TpSlotGroup.AS_MAPPING, CFields.PyMappingMethods__mp_subscript, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta MP_ASS_SUBSCRIPT = new TpSlotMeta(TpSlots::mp_ass_subscript, TpSlotMpAssSubscript.TpSlotMpAssSubscriptPython.class, TpSlotMpAssSubscript.TpSlotMpAssSubscriptBuiltin.class, TpSlotGroup.AS_MAPPING, CFields.PyMappingMethods__mp_ass_subscript, ExternalFunctionNodes.PExternalFunctionWrapper.OBJOBJARGPROC, PyProcsWrapper.ObjobjargWrapper::new);
        public static final /* enum */ TpSlotMeta TP_RICHCOMPARE = new TpSlotMeta(TpSlots::tp_richcmp, TpSlotRichCompare.TpSlotRichCmpPython.class, TpSlotRichCompare.TpSlotRichCmpBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_richcompare, ExternalFunctionNodes.PExternalFunctionWrapper.RICHCMP, PyProcsWrapper.RichcmpFunctionWrapper::new);
        public static final /* enum */ TpSlotMeta TP_DESCR_GET = new TpSlotMeta(TpSlots::tp_descr_get, TpSlot.TpSlotPythonSingle.class, TpSlotDescrGet.TpSlotDescrGetBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_descr_get, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_GET, PyProcsWrapper.DescrGetFunctionWrapper::new);
        public static final /* enum */ TpSlotMeta TP_DESCR_SET = new TpSlotMeta(TpSlots::tp_descr_set, TpSlotDescrSet.TpSlotDescrSetPython.class, TpSlotDescrSet.TpSlotDescrSetBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_descr_set, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_SET, PyProcsWrapper.DescrSetFunctionWrapper::new);
        public static final /* enum */ TpSlotMeta TP_HASH = new TpSlotMeta(TpSlots::tp_hash, TpSlot.TpSlotPythonSingle.class, TpSlotHashFun.TpSlotHashBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_hash, ExternalFunctionNodes.PExternalFunctionWrapper.HASHFUNC, PyProcsWrapper.HashfuncWrapper::new);
        public static final /* enum */ TpSlotMeta TP_GETATTRO = new TpSlotMeta(TpSlots::tp_getattro, TpSlotGetAttr.TpSlotGetAttrPython.class, TpSlotGetAttr.TpSlotGetAttrBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_getattro, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.GetAttrWrapper::new);
        public static final /* enum */ TpSlotMeta TP_GETATTR = new TpSlotMeta(TpSlots::tp_getattr, null, null, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_getattr, ExternalFunctionNodes.PExternalFunctionWrapper.GETATTR, new NativeWrapperFactory.ShouldNotReach("tp_getattr"));
        public static final /* enum */ TpSlotMeta TP_SETATTRO = new TpSlotMeta(TpSlots::tp_setattro, TpSlotSetAttr.TpSlotSetAttrPython.class, TpSlotSetAttr.TpSlotSetAttrBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_setattro, ExternalFunctionNodes.PExternalFunctionWrapper.SETATTRO, PyProcsWrapper.SetattrWrapper::new);
        public static final /* enum */ TpSlotMeta TP_SETATTR = new TpSlotMeta(TpSlots::tp_setattr, null, null, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_setattr, ExternalFunctionNodes.PExternalFunctionWrapper.SETATTR, new NativeWrapperFactory.ShouldNotReach("tp_setattr"));
        public static final /* enum */ TpSlotMeta TP_ITER = new TpSlotMeta(TpSlots::tp_iter, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_iter, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta TP_ITERNEXT = new TpSlotMeta(TpSlots::tp_iternext, TpSlot.TpSlotPythonSingle.class, TpSlotIterNext.TpSlotIterNextBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_iternext, ExternalFunctionNodes.PExternalFunctionWrapper.ITERNEXT, PyProcsWrapper.IterNextWrapper::new);
        public static final /* enum */ TpSlotMeta TP_REPR = new TpSlotMeta(TpSlots::tp_repr, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_repr, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta TP_STR = new TpSlotMeta(TpSlots::tp_str, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_str, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta TP_INIT = new TpSlotMeta(TpSlots::tp_init, TpSlot.TpSlotPythonSingle.class, TpSlotVarargs.TpSlotVarargsBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_init, ExternalFunctionNodes.PExternalFunctionWrapper.INITPROC, PyProcsWrapper.InitWrapper::new);
        public static final /* enum */ TpSlotMeta TP_NEW = new TpSlotMeta(TpSlots::tp_new, TpSlot.TpSlotPythonSingle.class, TpSlotVarargs.TpSlotNewBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_new, ExternalFunctionNodes.PExternalFunctionWrapper.NEW, PyProcsWrapper.NewWrapper::new);
        public static final /* enum */ TpSlotMeta TP_CALL = new TpSlotMeta(TpSlots::tp_call, TpSlot.TpSlotPythonSingle.class, TpSlotVarargs.TpSlotVarargsBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_call, ExternalFunctionNodes.PExternalFunctionWrapper.CALL, PyProcsWrapper.CallWrapper::new);
        public static final /* enum */ TpSlotMeta AM_AWAIT = new TpSlotMeta(TpSlots::am_await, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_ASYNC, CFields.PyAsyncMethods__am_await, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta AM_AITER = new TpSlotMeta(TpSlots::am_aiter, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_ASYNC, CFields.PyAsyncMethods__am_aiter, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final /* enum */ TpSlotMeta AM_ANEXT = new TpSlotMeta(TpSlots::am_anext, TpSlot.TpSlotPythonSingle.class, TpSlotUnaryFunc.TpSlotUnaryFuncBuiltin.class, TpSlotGroup.AS_ASYNC, CFields.PyAsyncMethods__am_anext, ExternalFunctionNodes.PExternalFunctionWrapper.UNARYFUNC, PyProcsWrapper.UnaryFuncWrapper::new);
        public static final TpSlotMeta[] VALUES;
        private final TpSlotGetter getter;
        private final Class<? extends TpSlot.TpSlotPython> permittedPythonSlotClass;
        private final Class<? extends TpSlot.TpSlotBuiltin> permittedBuiltinSlotClass;
        private final TpSlotGroup group;
        private final CFields nativeGroupOrField;
        private final CFields nativeField;
        private final ExternalFunctionNodes.PExternalFunctionWrapper nativeSignature;
        private final NativeWrapperFactory nativeWrapperFactory;
        private static final /* synthetic */ TpSlotMeta[] $VALUES;

        public static TpSlotMeta[] values() {
            return (TpSlotMeta[])$VALUES.clone();
        }

        public static TpSlotMeta valueOf(String name) {
            return Enum.valueOf(TpSlotMeta.class, name);
        }

        private TpSlotMeta(TpSlotGetter getter, Class<? extends TpSlot.TpSlotPython> permittedPythonSlotClass, Class<? extends TpSlot.TpSlotBuiltin> permittedBuiltinSlotClass, TpSlotGroup group, CFields nativeField, ExternalFunctionNodes.PExternalFunctionWrapper nativeSignature, NativeWrapperFactory nativeWrapperFactory) {
            this.permittedPythonSlotClass = permittedPythonSlotClass;
            this.permittedBuiltinSlotClass = permittedBuiltinSlotClass;
            this.nativeWrapperFactory = nativeWrapperFactory;
            this.getter = getter;
            assert (group != null);
            this.group = group;
            if (group == TpSlotGroup.NO_GROUP) {
                this.nativeGroupOrField = nativeField;
                this.nativeField = null;
            } else {
                this.nativeGroupOrField = group.cField;
                this.nativeField = nativeField;
            }
            this.nativeSignature = nativeSignature;
        }

        public boolean isValidSlotValue(Object value) {
            return value == null || value instanceof TpSlot.TpSlotNative || this.permittedBuiltinSlotClass != null && this.permittedBuiltinSlotClass.isAssignableFrom(value.getClass()) || this.permittedPythonSlotClass != null && this.permittedPythonSlotClass.isAssignableFrom(value.getClass());
        }

        public boolean supportsManagedSlotValues() {
            return this.permittedBuiltinSlotClass != null || this.permittedPythonSlotClass != null;
        }

        public CFields getNativeGroupOrField() {
            return this.nativeGroupOrField;
        }

        public boolean hasGroup() {
            return this.nativeField != null;
        }

        public CFields getNativeField() {
            return this.nativeField;
        }

        public TpSlot getValue(TpSlots slots) {
            return this.getter.get(slots);
        }

        public Object getNativeValue(TpSlots slots, Object defaultValue) {
            return TpSlot.toNative(this, this.getter.get(slots), defaultValue);
        }

        private Object getNativeValue(TpSlot slot, Object defaultValue) {
            return TpSlot.toNative(this, slot, defaultValue);
        }

        public Object readFromNative(PythonAbstractNativeObject pythonClass) {
            Object field = CStructAccess.ReadPointerNode.getUncached().readFromObj(pythonClass, this.nativeGroupOrField);
            InteropLibrary ptrInterop = null;
            if (this.nativeField != null) {
                ptrInterop = InteropLibrary.getUncached((Object)field);
                if (!ptrInterop.isNull(field)) {
                    field = CStructAccess.ReadPointerNode.getUncached().read(field, this.nativeField);
                } else {
                    return null;
                }
            }
            if (PythonUtils.getUncachedInterop(ptrInterop, field).isNull(field)) {
                return null;
            }
            return field;
        }

        public PyProcsWrapper.TpSlotWrapper createNativeWrapper(TpSlot.TpSlotManaged slot) {
            return this.nativeWrapperFactory.create(slot);
        }

        public boolean hasNativeWrapperFactory() {
            return !(this.nativeWrapperFactory instanceof NativeWrapperFactory.Unimplemented);
        }

        public ExternalFunctionNodes.PExternalFunctionWrapper getNativeSignature() {
            return this.nativeSignature;
        }

        public TpSlotGroup getGroup() {
            return this.group;
        }

        private static /* synthetic */ TpSlotMeta[] $values() {
            return new TpSlotMeta[]{NB_BOOL, NB_INDEX, NB_INT, NB_FLOAT, NB_ABSOLUTE, NB_POSITIVE, NB_NEGATIVE, NB_INVERT, NB_ADD, NB_SUBTRACT, NB_MULTIPLY, NB_REMAINDER, NB_LSHIFT, NB_RSHIFT, NB_AND, NB_XOR, NB_OR, NB_FLOOR_DIVIDE, NB_TRUE_DIVIDE, NB_DIVMOD, NB_MATRIX_MULTIPLY, NB_POWER, NB_INPLACE_ADD, NB_INPLACE_SUBTRACT, NB_INPLACE_MULTIPLY, NB_INPLACE_REMAINDER, NB_INPLACE_LSHIFT, NB_INPLACE_RSHIFT, NB_INPLACE_AND, NB_INPLACE_XOR, NB_INPLACE_OR, NB_INPLACE_FLOOR_DIVIDE, NB_INPLACE_TRUE_DIVIDE, NB_INPLACE_MATRIX_MULTIPLY, NB_INPLACE_POWER, SQ_LENGTH, SQ_CONCAT, SQ_ITEM, SQ_ASS_ITEM, SQ_REPEAT, SQ_INPLACE_CONCAT, SQ_INPLACE_REPEAT, SQ_CONTAINS, MP_LENGTH, MP_SUBSCRIPT, MP_ASS_SUBSCRIPT, TP_RICHCOMPARE, TP_DESCR_GET, TP_DESCR_SET, TP_HASH, TP_GETATTRO, TP_GETATTR, TP_SETATTRO, TP_SETATTR, TP_ITER, TP_ITERNEXT, TP_REPR, TP_STR, TP_INIT, TP_NEW, TP_CALL, AM_AWAIT, AM_AITER, AM_ANEXT};
        }

        static {
            $VALUES = TpSlotMeta.$values();
            VALUES = TpSlotMeta.values();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetTpSlotsNode
    extends Node {
        public abstract TpSlots execute(Node var1, Object var2);

        public static TpSlots executeUncached(Object pythonClass) {
            return TpSlotsFactory.GetTpSlotsNodeGen.getUncached().execute(null, pythonClass);
        }

        @Specialization
        static TpSlots doBuiltinType(PythonBuiltinClassType type) {
            return type.getSlots();
        }

        @Specialization
        static TpSlots doManaged(PythonManagedClass klass) {
            return klass.getTpSlots();
        }

        @Specialization
        static TpSlots doNative(Node inliningTarget, PythonAbstractNativeObject nativeKlass, @Cached InlinedBranchProfile slotsNotInitializedProfile) {
            TpSlots tpSlots = nativeKlass.getTpSlots();
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (tpSlots == null ? 1 : 0) != 0)) {
                slotsNotInitializedProfile.enter(inliningTarget);
                tpSlots = GetTpSlotsNode.initializeNativeSlots(nativeKlass);
            }
            return tpSlots;
        }

        @CompilerDirectives.TruffleBoundary
        private static TpSlots initializeNativeSlots(PythonAbstractNativeObject nativeKlass) {
            TpSlots tpSlots = TpSlots.fromNative(nativeKlass, PythonContext.get(null));
            nativeKlass.setTpSlots(tpSlots);
            return tpSlots;
        }
    }

    public record TpSlotDef(TruffleString name, PythonFunctionFactory functionFactory, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
        public static TpSlotDef create(TruffleString name, PythonFunctionFactory functionFactory, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return new TpSlotDef(name, functionFactory, wrapper);
        }

        public static TpSlotDef withSimpleFunction(TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return new TpSlotDef(name, SimplePythonWrapper.INSTANCE, wrapper);
        }

        public static TpSlotDef withNoFunctionNoWrapper(TruffleString name) {
            return new TpSlotDef(name, null, null);
        }

        public static TpSlotDef withNoFunction(TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return new TpSlotDef(name, null, wrapper);
        }
    }

    @FunctionalInterface
    public static interface PythonFunctionFactory {
        public TpSlot create(Object[] var1, TruffleString[] var2, Object var3);
    }

    @FunctionalInterface
    private static interface TpSlotGetter {
        public TpSlot get(TpSlots var1);
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class GetObjectSlotsNode
    extends Node {
        public abstract TpSlots execute(Node var1, Object var2);

        public final TpSlots executeCached(Object pythonObject) {
            return this.execute(this, pythonObject);
        }

        public static TpSlots executeUncached(Object pythonObject) {
            return TpSlotsFactory.GetObjectSlotsNodeGen.getUncached().execute(null, pythonObject);
        }

        @NeverDefault
        public static GetObjectSlotsNode create() {
            return TpSlotsFactory.GetObjectSlotsNodeGen.create();
        }

        @Specialization
        static TpSlots doIt(Node inliningTarget, Object pythonObject, @Cached GetClassNode getClassNode, @Cached GetCachedTpSlotsNode getSlotsNode) {
            return getSlotsNode.execute(inliningTarget, getClassNode.execute(inliningTarget, pythonObject));
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @ImportStatic(value={PGuards.class})
    public static abstract class GetCachedTpSlotsNode
    extends Node {
        public abstract TpSlots execute(Node var1, Object var2);

        @Specialization
        static TpSlots doBuiltin(PythonBuiltinClassType klass) {
            return klass.getSlots();
        }

        @Specialization(replaces={"doBuiltin"})
        static TpSlots doOtherCached(Node inliningTarget, Object klass, @Cached InlineWeakValueProfile weakValueProfile, @Cached GetTpSlotsNode getSlots) {
            return weakValueProfile.execute(inliningTarget, getSlots.execute(inliningTarget, klass));
        }

        public static GetCachedTpSlotsNode getUncached() {
            return Uncached.INSTANCE;
        }

        @GenerateCached(value=false)
        private static final class Uncached
        extends GetCachedTpSlotsNode {
            private static final Uncached INSTANCE = new Uncached();

            private Uncached() {
            }

            @Override
            public TpSlots execute(Node inliningTarget, Object pythonClass) {
                return GetTpSlotsNode.executeUncached(pythonClass);
            }
        }
    }

    @FunctionalInterface
    static interface GroupGetter {
        public boolean get(TpSlots var1);
    }

    public static final class SimplePythonWrapper
    implements PythonFunctionFactory {
        private static final SimplePythonWrapper INSTANCE = new SimplePythonWrapper();

        @Override
        public TpSlot create(Object[] callables, TruffleString[] names, Object klass) {
            assert (callables.length == 1);
            assert (callables[0] != PNone.NO_VALUE);
            return new TpSlot.TpSlotPythonSingle(callables[0], klass, names[0]);
        }
    }

    @FunctionalInterface
    private static interface NativeWrapperFactory {
        public PyProcsWrapper.TpSlotWrapper create(TpSlot.TpSlotManaged var1);

        public record ShouldNotReach(String slotName) implements NativeWrapperFactory
        {
            @Override
            public PyProcsWrapper.TpSlotWrapper create(TpSlot.TpSlotManaged slot) {
                throw new IllegalStateException(String.format("Slot %s should never be assigned a managed slot value.", this.slotName));
            }
        }

        public static final class Unimplemented
        implements NativeWrapperFactory {
            @Override
            public PyProcsWrapper.TpSlotWrapper create(TpSlot.TpSlotManaged slot) {
                throw new IllegalStateException("TODO: " + String.valueOf(slot));
            }
        }
    }
}

