/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltins;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyObjectHashNode
extends PNodeWithContext {
    public static long executeUncached(Object value) {
        return PyObjectHashNodeGen.getUncached().execute(null, null, value);
    }

    public abstract long execute(Frame var1, Node var2, Object var3);

    public abstract long execute(Frame var1, Node var2, TruffleString var3);

    public static long avoidNegative1(long hash) {
        return hash == -1L ? -2L : hash;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    public static long hash(TruffleString object, @Cached.Shared @Cached(inline=false) TruffleString.HashCodeNode hashCodeNode) {
        return PyObjectHashNode.avoidNegative1(hashCodeNode.execute((AbstractTruffleString)object, PythonUtils.TS_ENCODING));
    }

    @Specialization(guards={"isBuiltinPString(object)"})
    @HostCompilerDirectives.InliningCutoff
    static long hash(Node inliningTarget, PString object, @Cached CastToTruffleStringNode cast, @Cached.Shared @Cached(inline=false) TruffleString.HashCodeNode hashCodeNode) {
        return PyObjectHashNode.hash(cast.execute(inliningTarget, object), hashCodeNode);
    }

    @Specialization
    public static long hash(boolean object) {
        return object ? 1L : 0L;
    }

    @Specialization
    public static long hash(int object) {
        return PyObjectHashNode.avoidNegative1(object);
    }

    @Specialization
    public static long hash(long object) {
        long h = object % 0x1FFFFFFFFFFFFFFFL;
        return PyObjectHashNode.avoidNegative1(h);
    }

    @Specialization
    public static long hash(double object) {
        if (!Double.isFinite(object)) {
            if (Double.isInfinite(object)) {
                return object > 0.0 ? 314159L : -314159L;
            }
            return 0L;
        }
        double[] frexpRes = MathModuleBuiltins.FrexpNode.frexp(object);
        double m = frexpRes[0];
        int e = (int)frexpRes[1];
        int sign = 1;
        if (m < 0.0) {
            sign = -1;
            m = -m;
        }
        long x = 0L;
        while (m != 0.0) {
            x = x << 28 & 0x1FFFFFFFFFFFFFFFL | x >> 33;
            e -= 28;
            long y = (long)(m *= 2.68435456E8);
            m -= (double)y;
            if ((x += y) < 0x1FFFFFFFFFFFFFFFL) continue;
            x -= 0x1FFFFFFFFFFFFFFFL;
        }
        e = e >= 0 ? e % 61 : 60 - (-1 - e) % 61;
        x = x << e & 0x1FFFFFFFFFFFFFFFL | x >> 61 - e;
        return PyObjectHashNode.avoidNegative1(x *= (long)sign);
    }

    @HostCompilerDirectives.InliningCutoff
    @Fallback
    static long genericHash(VirtualFrame frame, Node inliningTarget, Object object, @Cached GetClassNode getClassNode, @Cached TpSlots.GetCachedTpSlotsNode getSlotsNode, @Cached CStructAccess.ReadI64Node readTypeObjectFieldNode, @Cached InlinedConditionProfile typeIsNotReadyProfile, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached TpSlotHashFun.CallSlotHashFunNode callHashFun, @Cached PRaiseNode raiseNode) {
        Object klass = getClassNode.execute(inliningTarget, object);
        TpSlots slots = getSlotsNode.execute(inliningTarget, klass);
        if (slots.tp_hash() == null) {
            slots = PyObjectHashNode.handleNoHash(frame, inliningTarget, object, readTypeObjectFieldNode, typeIsNotReadyProfile, indirectCallData, raiseNode, klass, slots);
        }
        return callHashFun.execute(frame, inliningTarget, slots.tp_hash(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HostCompilerDirectives.InliningCutoff
    private static TpSlots handleNoHash(VirtualFrame frame, Node inliningTarget, Object object, CStructAccess.ReadI64Node readTypeObjectFieldNode, InlinedConditionProfile typeIsNotReadyProfile, IndirectCallData indirectCallData, PRaiseNode raiseNode, Object klass, TpSlots slots) {
        PythonAbstractNativeObject nativeKlass;
        long flags;
        boolean initialized = false;
        if (klass instanceof PythonAbstractNativeObject && typeIsNotReadyProfile.profile(inliningTarget, ((flags = readTypeObjectFieldNode.readFromObj(nativeKlass = (PythonAbstractNativeObject)klass, CFields.PyTypeObject__tp_flags)) & 0x1000L) == 0L)) {
            Object savedState = ExecutionContext.IndirectCallContext.enter(frame, inliningTarget, indirectCallData);
            try {
                slots = PyObjectHashNode.callTypeReady(inliningTarget, object, nativeKlass);
                initialized = true;
            }
            finally {
                ExecutionContext.IndirectCallContext.exit(frame, inliningTarget, indirectCallData, savedState);
            }
        }
        if (!initialized) {
            throw PyObjectHashNode.raiseUnhashable(inliningTarget, object, raiseNode);
        }
        return slots;
    }

    @CompilerDirectives.TruffleBoundary
    private static TpSlots callTypeReady(Node inliningTarget, Object object, PythonAbstractNativeObject klass) {
        int res = (Integer)CExtNodes.PCallCapiFunction.getUncached().call(NativeCAPISymbol.FUN_PY_TYPE_READY, CApiTransitions.PythonToNativeNode.executeUncached(klass));
        if (res < 0) {
            throw PyObjectHashNode.raiseSystemError(inliningTarget, klass);
        }
        TpSlots slots = TpSlots.GetTpSlotsNode.executeUncached(klass);
        if (slots.tp_hash() == null) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, object);
        }
        return slots;
    }

    private static PException raiseSystemError(Node inliningTarget, Object klass) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.LAZY_INITIALIZATION_FAILED, klass);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseUnhashable(Node inliningTarget, Object object, PRaiseNode raiseNode) {
        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.UNHASHABLE_TYPE_P, object);
    }
}

