/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;

class TcpFastOpen {
    private static final String TFO_JDBC_LIB_NAME = "tfojdbc1";
    private static final String LIB_TFO_JDBC = "libtfojdbc1.so";
    private static RuntimeException libTfoJdbcPreloadException;
    private static boolean IS_PREFER_IPV4_STACK_PROPERTY_SET;
    private static final TcpFastOpen INSTANCE;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    private TcpFastOpen() {
    }

    public static TcpFastOpen getInstance() {
        return INSTANCE;
    }

    private static boolean isLibTfoJdbcPreloadSet() {
        String ldPreloadValue = TcpFastOpen.getPreloadEnvValue();
        if (ldPreloadValue != null && ldPreloadValue.contains(LIB_TFO_JDBC)) {
            return true;
        }
        libTfoJdbcPreloadException = new RuntimeException(DatabaseError.createSqlException(1739).getMessage());
        return false;
    }

    private static void loadLibTfoJdbcLibrary() {
        try {
            AccessController.doPrivileged(() -> {
                System.loadLibrary(TFO_JDBC_LIB_NAME);
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void init() {
        if (TcpFastOpen.isLibTfoJdbcPreloadSet()) {
            TcpFastOpen.loadLibTfoJdbcLibrary();
        }
        try {
            AccessController.doPrivileged(() -> {
                IS_PREFER_IPV4_STACK_PROPERTY_SET = "true".equals(System.getProperty("java.net.preferIPv4Stack"));
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getPreloadEnvValue() {
        String[] value = new String[]{null};
        try {
            AccessController.doPrivileged(() -> {
                value[0] = System.getenv("LD_PRELOAD");
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw new RuntimeException(ex);
        }
        return value[0];
    }

    public static InetSocketAddress setTcpFastOpenBytes(InetSocketAddress socketAddress, byte[] tcpFastOpenBytes) {
        if (libTfoJdbcPreloadException != null) {
            throw libTfoJdbcPreloadException;
        }
        if (socketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
        InetAddress iaddr = socketAddress.getAddress();
        byte[] addr = iaddr.getAddress();
        return TcpFastOpen.setTcpFastOpenBytes0(addr, addr.length, socketAddress.getPort(), tcpFastOpenBytes, IS_PREFER_IPV4_STACK_PROPERTY_SET);
    }

    public static String getErrorMessage() {
        try {
            return TcpFastOpen.getErrorMessage0();
        }
        catch (UnsatisfiedLinkError ex) {
            return null;
        }
    }

    private static native InetSocketAddress setTcpFastOpenBytes0(byte[] var0, int var1, int var2, byte[] var3, boolean var4);

    private static native String getErrorMessage0();

    static {
        try {
            $$$methodRef$$$10 = TcpFastOpen.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpFastOpen.class.getDeclaredMethod("lambda$loadLibTfoJdbcLibrary$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpFastOpen.class.getDeclaredMethod("lambda$init$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpFastOpen.class.getDeclaredMethod("lambda$getPreloadEnvValue$2", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpFastOpen.class.getDeclaredMethod("getErrorMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpFastOpen.class.getDeclaredMethod("setTcpFastOpenBytes", InetSocketAddress.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpFastOpen.class.getDeclaredMethod("getPreloadEnvValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpFastOpen.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpFastOpen.class.getDeclaredMethod("loadLibTfoJdbcLibrary", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpFastOpen.class.getDeclaredMethod("isLibTfoJdbcPreloadSet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpFastOpen.class.getDeclaredMethod("getInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        libTfoJdbcPreloadException = null;
        IS_PREFER_IPV4_STACK_PROPERTY_SET = false;
        INSTANCE = new TcpFastOpen();
    }
}

