/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDate;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class DATE
extends Datum
implements OracleDate {
    static final long serialVersionUID = 5229717576495161269L;
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;

    public DATE() {
        super(DATE._initDate());
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(byte[] date) {
        super(date);
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null, new Object[]{date});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Date date) {
        super(DATE.toBytes(date));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null, time);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Timestamp timestamp) {
        super(DATE.toBytes(timestamp));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null, timestamp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Date date, Calendar cal) {
        super(DATE.toBytes(date, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null, date, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Time time, Calendar cal) {
        super(DATE.toBytes(time, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null, time, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null);
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Timestamp timestamp, Calendar cal) {
        super(DATE.toBytes(timestamp, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null, timestamp, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null);
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(String str) {
        super(DATE.toBytes(str));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null, str);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null);
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(String str, boolean lenient) throws ParseException {
        super(DATE.toBytes(str));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null, str, lenient);
            }
            if (!lenient) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                simpleDateFormat.setLenient(false);
                java.util.Date date = simpleDateFormat.parse(str);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(String str, Calendar cal) {
        super(DATE.toBytes(str, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null, str, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Object obj) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, obj);
            }
            if (obj instanceof Date) {
                this.setShareBytes(DATE.toBytes((Date)obj));
            } else if (obj instanceof Time) {
                this.setShareBytes(DATE.toBytes((Time)obj));
            } else if (obj instanceof Timestamp) {
                this.setShareBytes(DATE.toBytes((Timestamp)obj));
            } else if (obj instanceof String) {
                this.setShareBytes(DATE.toBytes((String)obj));
            } else {
                SQLException sQLException = new SQLException("Initialization failed");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Object obj, Calendar cal) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, obj, cal);
            }
            if (obj instanceof Date) {
                this.setShareBytes(DATE.toBytes((Date)obj, cal));
            } else if (obj instanceof Time) {
                this.setShareBytes(DATE.toBytes((Time)obj, cal));
            } else if (obj instanceof Timestamp) {
                this.setShareBytes(DATE.toBytes((Timestamp)obj, cal));
            } else if (obj instanceof String) {
                this.setShareBytes(DATE.toBytes((String)obj, cal));
            } else {
                SQLException sQLException = new SQLException("Initialization failed");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate(byte[] byArray) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, new Object[]{byArray});
            }
            Date date2 = DATE.toDate(date, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, date2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, null);
            }
            return date2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Time toTime(byte[] byArray) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, new Object[]{byArray});
            }
            Time time = DATE.toTime(date, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, time);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(byte[] byArray) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, new Object[]{byArray});
            }
            Timestamp timestamp = DATE.toTimestamp(date, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, timestamp);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Date toDate(byte[] byArray, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Date newDate;
            void cal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, byArray, calendar);
            }
            int[] result = new int[7];
            for (int i2 = 0; i2 < 7; ++i2) {
                byte[] date;
                result[i2] = date[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.set(1, year);
            cal1.set(2, result[2] - 1);
            cal1.set(5, result[3]);
            if (!OracleDriver.getSystemPropertyDateZeroTimeExtra()) {
                cal1.set(11, result[4] - 1);
                cal1.set(12, result[5] - 1);
                cal1.set(13, result[6] - 1);
            } else {
                cal1.set(11, 0);
                cal1.set(12, 0);
                cal1.set(13, 0);
            }
            cal1.set(14, 0);
            Date date = newDate = new Date(cal1.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, date);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Time toTime(byte[] byArray, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            byte[] date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, byArray, calendar);
            }
            int hour = date[4] & 0xFF;
            int minute = date[5] & 0xFF;
            int second = date[6] & 0xFF;
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.set(1, 1970);
            cal1.set(2, 0);
            cal1.set(5, 1);
            cal1.set(11, hour - 1);
            cal1.set(12, minute - 1);
            cal1.set(13, second - 1);
            cal1.set(14, 0);
            Time time = new Time(cal1.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, time);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp newTimestamp;
            void cal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, byArray, calendar);
            }
            int[] result = new int[7];
            for (int i2 = 0; i2 < 7; ++i2) {
                byte[] date;
                result[i2] = date[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.set(1, year);
            cal1.set(2, result[2] - 1);
            cal1.set(5, result[3]);
            cal1.set(11, result[4] - 1);
            cal1.set(12, result[5] - 1);
            cal1.set(13, result[6] - 1);
            cal1.set(14, 0);
            Timestamp timestamp = newTimestamp = new Timestamp(cal1.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, timestamp);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static String toString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new String();
        }
        int[] result = new int[7];
        for (int i2 = 0; i2 < 7; ++i2) {
            result[i2] = bytes[i2] < 0 ? bytes[i2] + 256 : bytes[i2];
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int month = result[2];
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        int nanos = -1;
        String sResult = TIMESTAMPTZ.toString(year, month, day, hours, minutes, seconds, -1, null);
        return sResult;
    }

    @Override
    public byte[] toBytes() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Date date) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Date date2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, date);
            }
            byte[] byArray = DATE.toBytes(date2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Time time) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Time time2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, time);
            }
            byte[] byArray = DATE.toBytes(time2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Timestamp timestamp) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp timestamp2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, timestamp);
            }
            byte[] byArray = DATE.toBytes(timestamp2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Date date, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Date date2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, date, calendar);
            }
            if (date2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, null);
                }
                return null;
            }
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.setTime(date2);
            byte[] result = new byte[7];
            int year = TIMESTAMP.getOracleYear(cal1);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal1.get(2) + 1);
            result[3] = (byte)cal1.get(5);
            if (!OracleDriver.getSystemPropertyDateZeroTime()) {
                result[4] = (byte)(cal1.get(11) + 1);
                result[5] = (byte)(cal1.get(12) + 1);
                result[6] = (byte)(cal1.get(13) + 1);
            } else {
                result[4] = 1;
                result[5] = 1;
                result[6] = 1;
            }
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Time time, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Time time2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, time, calendar);
            }
            if (time2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, null);
                }
                return null;
            }
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.setTime(time2);
            byte[] result = new byte[]{119, -86, 1, 1, (byte)(cal1.get(11) + 1), (byte)(cal1.get(12) + 1), (byte)(cal1.get(13) + 1)};
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Timestamp timestamp2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, timestamp, calendar);
            }
            if (timestamp2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, null);
                }
                return null;
            }
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.setTime(timestamp2);
            byte[] result = new byte[7];
            int year = TIMESTAMP.getOracleYear(cal1);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal1.get(2) + 1);
            result[3] = (byte)cal1.get(5);
            result[4] = (byte)(cal1.get(11) + 1);
            result[5] = (byte)(cal1.get(12) + 1);
            result[6] = (byte)(cal1.get(13) + 1);
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(String string) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] result;
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, string);
            }
            if (str == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, null);
                }
                return null;
            }
            byte[] byArray = result = DATE.toBytes(Timestamp.valueOf(str));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static byte[] toBytes(String str, Calendar cal) {
        return DATE.toBytes(Timestamp.valueOf(str), cal);
    }

    @Override
    @DisableTrace
    public Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    @Override
    @DisableTrace
    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    @Override
    public Timestamp timestampValue() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, new Object[0]);
            }
            Timestamp timestamp = DATE.toTimestamp(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public Date dateValue(Calendar cal) {
        return DATE.toDate(this.getBytes(), cal);
    }

    @Override
    @DisableTrace
    public Time timeValue(Calendar cal) {
        return DATE.toTime(this.getBytes(), cal);
    }

    @Override
    @DisableTrace
    public Timestamp timestampValue(Calendar cal) {
        return DATE.toTimestamp(this.getBytes(), cal);
    }

    @Override
    @DisableTrace
    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    @DisableTrace
    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object toJdbc() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, new Object[0]);
            }
            Timestamp timestamp = this.timestampValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void arraySize;
            Timestamp[] ts;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, n2);
            }
            Timestamp[] timestampArray = ts = new Timestamp[arraySize];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, timestampArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, null);
            }
            return ts;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cls;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, clazz);
            }
            if (cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DATE addJulianDays(int n2, int n3) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void julianSec;
            void julianDay;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, n2, n3);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), (int)julianDay, (int)julianSec));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DATE addMonths(int n2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void months;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, n2);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), (int)months));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    public DATE zeroTime() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, new Object[0]);
            }
            byte[] tmpDate = this.toBytes();
            tmpDate[4] = 1;
            tmpDate[5] = 1;
            tmpDate[6] = 1;
            DATE dATE = new DATE(tmpDate);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void diffInJulianDays(DATE dATE, int[] nArray, int[] nArray2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void julianSec;
            void julianDay;
            void date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this, dATE, nArray, nArray2);
            }
            DATE._getLdxLib().ldxsub(this.shareBytes(), date.shareBytes(), (int[])julianDay, (int[])julianSec);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public NUMBER diffInMonths(DATE dATE) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, dATE);
            }
            NUMBER nUMBER = new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), date.shareBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE getCurrentDate() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, new Object[0]);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxgdt());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    public static int checkValidity(byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, new Object[]{byArray});
            }
            int n2 = DATE._getLdxLib().ldxchk(date);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, n2);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DATE fromJulianDays(int n2, int n3) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void julianSec;
            int julianDay;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, n2, n3);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxdfd(julianDay, (int)julianSec));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static DATE fromText(String string, String string2, String string3) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lang;
            void fmt;
            String datestr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, string, string2, string3);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxstd(datestr, (String)fmt, (String)lang));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE lastDayOfMonth() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, new Object[0]);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void numberToJulianDays(NUMBER nUMBER, int[] nArray, int[] nArray2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void julianSec;
            void julianDay;
            NUMBER num;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null, nUMBER, nArray, nArray2);
            }
            DATE._getLdxLib().ldxftd(num.toBytes(), (int[])julianDay, (int[])julianSec);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DATE round(String string) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prec;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, string);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), (String)prec));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DATE setDayOfWeek(int n2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void day;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, n2);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), (int)day));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void toJulianDays(int[] nArray, int[] nArray2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void julianSec;
            void julianDay;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this, nArray, nArray2);
            }
            DATE._getLdxLib().ldxdtd(this.shareBytes(), (int[])julianDay, (int[])julianSec);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER toNumber() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, new Object[0]);
            }
            NUMBER nUMBER = new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toText(String string, String string2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lang;
            void fmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, string, string2);
            }
            String string3 = DATE._getLdxLib().ldxdts(this.shareBytes(), (String)fmt, (String)lang);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, string3);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toText(byte[] byArray, String string) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lang;
            void pfmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, byArray, string);
            }
            String string2 = DATE._getLdxLib().ldxdts(this.shareBytes(), (byte[])pfmt, (String)lang);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, string2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] parseFormat(String string, String string2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lang;
            String fmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, string, string2);
            }
            byte[] byArray = DATE._getLdxLib().ldxsto(fmt, (String)lang);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public DATE truncate(String string) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void prec;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, string);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), (String)prec));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int compareTo(DATE dATE) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, dATE);
            }
            int n2 = DATE.compareBytes(this.shareBytes(), date.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, n2);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] _initDate() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, DATE.class, $$$methodRef$$$38, null, new Object[0]);
            }
            byte[] tmp = new byte[]{119, -86, 1, 1, 1, 1, 1};
            byte[] byArray = tmp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, DATE.class, $$$methodRef$$$38, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DATE.class, $$$methodRef$$$38, null, null);
            }
            return tmp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DATE.class, $$$methodRef$$$38, null, throwable2);
            }
            throw throwable;
        }
    }

    private static LdxLib _getLdxLib() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, DATE.class, $$$methodRef$$$39, null, new Object[0]);
            }
            if (_sldxlib == null) {
                _sldxlib = new LdxLibThin();
            }
            LdxLib ldxLib = _sldxlib;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, DATE.class, $$$methodRef$$$39, null, ldxLib);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, DATE.class, $$$methodRef$$$39, null, null);
            }
            return ldxLib;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, DATE.class, $$$methodRef$$$39, null, throwable2);
            }
            throw throwable;
        }
    }

    private static void _printBytes(byte[] byArray) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, DATE.class, $$$methodRef$$$40, null, new Object[]{byArray});
            }
            System.out.println(DATE.toString(date));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DATE.class, $$$methodRef$$$40, null);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DATE.class, $$$methodRef$$$40, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DATE.class, $$$methodRef$$$40, null, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE of(LocalDate localDate) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            LocalDate ld;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, localDate);
            }
            DATE dATE = new DATE(Date.valueOf(ld));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDate toLocalDate() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, new Object[0]);
            }
            LocalDate localDate = this.dateValue().toLocalDate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, localDate);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, null);
            }
            return localDate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE of(LocalDateTime localDateTime) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            LocalDateTime ldt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, localDateTime);
            }
            DATE dATE = new DATE(Timestamp.valueOf(ldt));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, new Object[0]);
            }
            LocalDateTime localDateTime = this.timestampValue().toLocalDateTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, localDateTime);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE of(LocalTime localTime) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            LocalTime lt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, localTime);
            }
            DATE dATE = new DATE(Time.valueOf(lt));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalTime toLocalTime() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, new Object[0]);
            }
            LocalTime localTime = this.timeValue().toLocalTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, localTime);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, null);
            }
            return localTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$59 = DATE.class.getDeclaredConstructor(Object.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$58 = DATE.class.getDeclaredConstructor(Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$57 = DATE.class.getDeclaredConstructor(String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$56 = DATE.class.getDeclaredConstructor(String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$55 = DATE.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$54 = DATE.class.getDeclaredConstructor(Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$53 = DATE.class.getDeclaredConstructor(Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = DATE.class.getDeclaredConstructor(Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = DATE.class.getDeclaredConstructor(Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = DATE.class.getDeclaredConstructor(Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = DATE.class.getDeclaredConstructor(Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = DATE.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = DATE.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = DATE.class.getDeclaredMethod("toLocalTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = DATE.class.getDeclaredMethod("of", LocalTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = DATE.class.getDeclaredMethod("toLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = DATE.class.getDeclaredMethod("of", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = DATE.class.getDeclaredMethod("toLocalDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = DATE.class.getDeclaredMethod("of", LocalDate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = DATE.class.getDeclaredMethod("_printBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = DATE.class.getDeclaredMethod("_getLdxLib", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = DATE.class.getDeclaredMethod("_initDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = DATE.class.getDeclaredMethod("compareTo", DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = DATE.class.getDeclaredMethod("truncate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = DATE.class.getDeclaredMethod("parseFormat", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = DATE.class.getDeclaredMethod("toText", byte[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = DATE.class.getDeclaredMethod("toText", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = DATE.class.getDeclaredMethod("toNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = DATE.class.getDeclaredMethod("toJulianDays", int[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = DATE.class.getDeclaredMethod("setDayOfWeek", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = DATE.class.getDeclaredMethod("round", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = DATE.class.getDeclaredMethod("numberToJulianDays", NUMBER.class, int[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = DATE.class.getDeclaredMethod("lastDayOfMonth", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = DATE.class.getDeclaredMethod("fromText", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = DATE.class.getDeclaredMethod("fromJulianDays", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = DATE.class.getDeclaredMethod("checkValidity", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = DATE.class.getDeclaredMethod("getCurrentDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = DATE.class.getDeclaredMethod("diffInMonths", DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = DATE.class.getDeclaredMethod("diffInJulianDays", DATE.class, int[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = DATE.class.getDeclaredMethod("zeroTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = DATE.class.getDeclaredMethod("addMonths", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = DATE.class.getDeclaredMethod("addJulianDays", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = DATE.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = DATE.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = DATE.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = DATE.class.getDeclaredMethod("timestampValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = DATE.class.getDeclaredMethod("toBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = DATE.class.getDeclaredMethod("toBytes", Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = DATE.class.getDeclaredMethod("toBytes", Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = DATE.class.getDeclaredMethod("toBytes", Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = DATE.class.getDeclaredMethod("toBytes", Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = DATE.class.getDeclaredMethod("toBytes", Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = DATE.class.getDeclaredMethod("toBytes", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = DATE.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = DATE.class.getDeclaredMethod("toTimestamp", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = DATE.class.getDeclaredMethod("toTime", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = DATE.class.getDeclaredMethod("toDate", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = DATE.class.getDeclaredMethod("toTimestamp", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = DATE.class.getDeclaredMethod("toTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = DATE.class.getDeclaredMethod("toDate", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

