/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.ds;

import com.amazon.redshift.ds.RedshiftPooledConnection;
import com.amazon.redshift.ds.common.BaseDataSource;
import com.amazon.redshift.util.DriverInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class RedshiftConnectionPoolDataSource
extends BaseDataSource
implements DataSource,
ConnectionPoolDataSource,
Serializable {
    private boolean defaultAutoCommit = true;

    @Override
    public String getDescription() {
        return "ConnectionPoolDataSource from " + DriverInfo.DRIVER_FULL_NAME;
    }

    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        return new RedshiftPooledConnection(this.getConnection(), this.defaultAutoCommit);
    }

    @Override
    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new RedshiftPooledConnection(this.getConnection(user, password), this.defaultAutoCommit);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeBaseObject(out);
        out.writeBoolean(this.defaultAutoCommit);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readBaseObject(in);
        this.defaultAutoCommit = in.readBoolean();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }
}

