/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.MetadataLoader;
import com.ibm.db2.cmx.runtime.internal.repository.api.SavedDataContentType;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.MetadataSourceWriter;
import com.ibm.db2.cmx.runtime.internal.repository.util.ZippedByteArray;
import java.io.InputStream;
import java.sql.Connection;

public class MetadataLoaderImpl
implements MetadataLoader {
    private Connection c = null;
    private String schema = null;
    private String projectName = null;
    private String appName = null;
    private String appVersion = null;

    public MetadataLoaderImpl(Connection connection, String string, String string2, String string3, String string4) {
        this.c = connection;
        this.schema = string;
        this.projectName = string2;
        this.appName = string3;
        this.appVersion = string4;
    }

    @Override
    public int load(InputStream inputStream, String string, SavedDataContentType savedDataContentType) throws MetadataException {
        ZippedByteArray zippedByteArray = ZippedByteArray.getZippedByteArray(inputStream);
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.schema);
        int n2 = metadataSourceWriter.createEntry(this.c, savedDataContentType.getSqlValue(), string, zippedByteArray.getData(), zippedByteArray.getOriginalDataLength());
        if (this.projectName != null) {
            throw new RuntimeException("Connecting to a project name not yet supported");
        }
        if (this.appName != null) {
            throw new RuntimeException("Connecting to an app name not yet supported");
        }
        return n2;
    }

    @Override
    public void replace(int n2, InputStream inputStream, String string, SavedDataContentType savedDataContentType) throws MetadataException {
        ZippedByteArray zippedByteArray = ZippedByteArray.getZippedByteArray(inputStream);
        MetadataSourceWriter metadataSourceWriter = MetadataSourceWriter.getInstance(this.schema);
        metadataSourceWriter.replaceEntry(this.c, n2, savedDataContentType.getSqlValue(), string, zippedByteArray.getData(), zippedByteArray.getOriginalDataLength());
    }
}

