/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.concurrent;

import java.util.concurrent.atomic.AtomicLong;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.concurrent.DoubleAdder;

final class AtomicLongDoubleAdder
implements DoubleAdder {
    private final AtomicLong atomicLong = new AtomicLong();

    AtomicLongDoubleAdder() {
    }

    @Override
    public void add(double x) {
        double currentDouble;
        double nextDouble;
        long nextLongBits;
        long currentLongBits;
        while (!this.atomicLong.compareAndSet(currentLongBits = this.atomicLong.get(), nextLongBits = Double.doubleToLongBits(nextDouble = (currentDouble = Double.longBitsToDouble(currentLongBits)) + x))) {
        }
    }

    @Override
    public double sum() {
        return Double.longBitsToDouble(this.atomicLong.get());
    }

    @Override
    public void reset() {
        this.atomicLong.set(0L);
    }

    @Override
    public double sumThenReset() {
        long prev;
        while (!this.atomicLong.compareAndSet(prev = this.atomicLong.get(), 0L)) {
        }
        return Double.longBitsToDouble(prev);
    }

    public String toString() {
        return Double.toString(this.sum());
    }
}

