/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.opentracingshim;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.opentracingshim.ScopeShim;
import io.opentelemetry.opentracingshim.ShimUtil;
import io.opentelemetry.opentracingshim.SpanShim;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import javax.annotation.Nullable;

final class ScopeManagerShim
implements ScopeManager {
    private static final SpanShim NOOP_SPANSHIM = new SpanShim(Span.getInvalid());

    ScopeManagerShim() {
    }

    @Nullable
    public io.opentracing.Span activeSpan() {
        SpanShim spanShim = SpanShim.current();
        Span span = Span.current();
        Baggage baggage = Baggage.current();
        if (!span.getSpanContext().isValid()) {
            if (baggage.isEmpty()) {
                return null;
            }
            return new SpanShim(Span.getInvalid(), baggage);
        }
        if (spanShim != null && spanShim.getSpan() == span) {
            return spanShim;
        }
        return new SpanShim(span, baggage);
    }

    public Scope activate(@Nullable io.opentracing.Span span) {
        SpanShim spanShim = ShimUtil.getSpanShim(span);
        if (spanShim == null) {
            return new ScopeShim(Context.current().with((ImplicitContextKeyed)NOOP_SPANSHIM).makeCurrent());
        }
        return new ScopeShim(Context.current().with((ImplicitContextKeyed)spanShim).makeCurrent());
    }
}

