/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.facet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.analytics.facet.AnalyticsFacet;
import org.apache.solr.analytics.facet.compare.FacetResultsComparator;
import org.apache.solr.analytics.function.ReductionCollectionManager;
import org.apache.solr.common.util.NamedList;

public abstract class SortableFacet
extends AnalyticsFacet {
    protected FacetSortSpecification sort = null;

    protected SortableFacet(String name) {
        super(name);
    }

    @Override
    public NamedList<Object> createOldResponse() {
        NamedList results = new NamedList();
        for (FacetBucket bucket : this.getBuckets()) {
            results.add(bucket.getFacetValue(), (Object)new NamedList(bucket.getResults()));
        }
        return results;
    }

    @Override
    public Iterable<Map<String, Object>> createResponse() {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (FacetBucket bucket : this.getBuckets()) {
            HashMap<String, Object> bucketMap = new HashMap<String, Object>();
            bucketMap.put("value", bucket.getFacetValue());
            bucketMap.put("results", bucket.getResults());
            results.add(bucketMap);
        }
        return results;
    }

    private Iterable<FacetBucket> getBuckets() {
        ArrayList<FacetBucket> facetResults = new ArrayList<FacetBucket>();
        this.reductionData.forEach((facetVal, dataCol) -> {
            this.collectionManager.setData((ReductionCollectionManager.ReductionDataCollection)dataCol);
            facetResults.add(new FacetBucket((String)facetVal, this.expressionCalculator.getResults()));
        });
        return this.applyOptions(facetResults);
    }

    protected Iterable<FacetBucket> applyOptions(List<FacetBucket> facetResults) {
        if (this.sort == null || facetResults.isEmpty()) {
            return facetResults;
        }
        FacetResultsComparator comp = this.sort.getComparator();
        facetResults.sort(comp);
        if (this.sort.getLimit() > 0) {
            if (this.sort.getOffset() > 0) {
                facetResults = facetResults.stream().skip(this.sort.getOffset()).collect(Collectors.toUnmodifiableList());
            }
            facetResults = facetResults.stream().limit(this.sort.getLimit()).collect(Collectors.toUnmodifiableList());
        } else if (this.sort.getLimit() == 0) {
            return new ArrayList<FacetBucket>();
        }
        return facetResults;
    }

    public FacetSortSpecification getSort() {
        return this.sort;
    }

    public void setSort(FacetSortSpecification sort) {
        this.sort = sort;
    }

    public static class FacetBucket {
        private final String facetValue;
        private final Map<String, Object> expressionResults;

        public FacetBucket(String facetValue, Map<String, Object> expressionResults) {
            this.facetValue = facetValue;
            this.expressionResults = expressionResults;
        }

        public Object getResult(String expression) {
            return this.expressionResults.get(expression);
        }

        public Map<String, Object> getResults() {
            return this.expressionResults;
        }

        public String getFacetValue() {
            return this.facetValue;
        }
    }

    public static class FacetSortSpecification {
        private FacetResultsComparator comparator;
        protected int limit;
        protected int offset;

        public FacetSortSpecification(FacetResultsComparator comparator, int limit, int offset) {
            this.comparator = comparator;
            this.limit = limit;
            this.offset = offset;
        }

        public FacetResultsComparator getComparator() {
            return this.comparator;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

