//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_MATERIAL_INTERFACE_PARAMETER_SCHEMA_H
#define PXR_IMAGING_HD_MATERIAL_INTERFACE_PARAMETER_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"
#include "pxr/imaging/hd/schemaTypeDefs.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_MATERIAL_INTERFACE_PARAMETER_SCHEMA_TOKENS \
    (displayGroup) \
    (displayName) \
    (mappings) \

TF_DECLARE_PUBLIC_TOKENS(HdMaterialInterfaceParameterSchemaTokens, HD_API,
    HD_MATERIAL_INTERFACE_PARAMETER_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


/// \class HdMaterialInterfaceParameterSchema
///
/// The MaterialInterfaceParameter schema describes a single interface
/// parameter (public UI parameter).
///
/// An interface parameter defines a vector of mappings to material node
/// parameters. These mappings indicate which material node parameters should
/// be overridden when a value is set on the interface parameter.
///
/// For example, the following data sources define a public UI "globalVal" that
/// maps to two different node parameters:
///
/// ds at: material/<renderContext>/interface/parameters/globalVal/
/// mappings/[0]/nodePath = Color_Manipulate
///
/// ds at: material/<renderContext>/interface/parameters/globalVal/
/// mappings/[0]/inputName = adjustVal
///
/// ds at: material/<renderContext>/interface/parameters/globalVal/
/// mappings/[1]/nodePath = Color_RetargetLayer
///
/// ds at: material/<renderContext>/interface/parameters/globalVal/
/// mappings/[1]/inputName = valRemapAmount
///
/// The above means that the "globalVal" public UI name maps to the following
/// parameter data sources at:
///
/// ds at: material/<renderContext>/nodes/Color_Manipulate/parameters/
/// adjustVal
///
/// ds at: material/<renderContext>/nodes/Color_RetargetLayer/
/// parameters/valRemapAmount
///
class HdMaterialInterfaceParameterSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdMaterialInterfaceParameterSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Optional displayGroup. Intended for GUI organization.
    HD_API
    HdTokenDataSourceHandle GetDisplayGroup() const;

    /// Optional displayName. Intended for GUI organization.
    HD_API
    HdTokenDataSourceHandle GetDisplayName() const;

    /// Maps this singular interface parameter to a vector of target node
    /// parameters. Each mapping target is defined by the InterfaceMappings
    /// schema.
    HD_API
    HdMaterialInterfaceMappingVectorSchema GetMappings() const; 

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &displayGroup,
        const HdTokenDataSourceHandle &displayName,
        const HdVectorDataSourceHandle &mappings
    );

    /// \class HdMaterialInterfaceParameterSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetDisplayGroup(
            const HdTokenDataSourceHandle &displayGroup);
        HD_API
        Builder &SetDisplayName(
            const HdTokenDataSourceHandle &displayName);
        HD_API
        Builder &SetMappings(
            const HdVectorDataSourceHandle &mappings);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _displayGroup;
        HdTokenDataSourceHandle _displayName;
        HdVectorDataSourceHandle _mappings;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif